/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.render.icon.RGBMutatorInterpolatedComponentRemap;
import com.hbm.render.icon.TextureAtlasSpriteMutatable;
import com.hbm.util.EnumUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemBedrockOreNew
extends Item {
    public IIcon[] icons = new IIcon[BedrockOreType.values().length * BedrockOreGrade.values().length];
    public IIcon[] overlays = new IIcon[ProcessingTrait.values().length];
    public static final int none = 0xFFFFFF;
    public static final int roasted = 0xCFCFCF;
    public static final int arc = 12821154;
    public static final int washed = 14410443;

    public ItemBedrockOreNew() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        if (reg instanceof TextureMap) {
            TextureMap map = (TextureMap)reg;
            for (int i = 0; i < BedrockOreGrade.values().length; ++i) {
                BedrockOreGrade grade = BedrockOreGrade.values()[i];
                for (int j = 0; j < BedrockOreType.values().length; ++j) {
                    BedrockOreType type = BedrockOreType.values()[j];
                    String placeholderName = "hbm:bedrock_ore_" + grade.prefix + "_" + type.suffix + "-" + (i * BedrockOreType.values().length + j);
                    TextureAtlasSpriteMutatable mutableIcon = new TextureAtlasSpriteMutatable(placeholderName, new RGBMutatorInterpolatedComponentRemap(0xFFFFFF, 0x505050, type.light, type.dark));
                    map.setTextureEntry(placeholderName, (TextureAtlasSprite)mutableIcon);
                    this.icons[i * BedrockOreType.values().length + j] = mutableIcon;
                }
            }
        }
        for (int i = 0; i < this.overlays.length; ++i) {
            ProcessingTrait trait = ProcessingTrait.values()[i];
            this.overlays[i] = reg.func_94245_a("hbm:bedrock_ore_overlay." + trait.name().toLowerCase(Locale.US));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < BedrockOreType.values().length; ++j) {
            BedrockOreType type = BedrockOreType.values()[j];
            for (int i = 0; i < BedrockOreGrade.values().length; ++i) {
                BedrockOreGrade grade = BedrockOreGrade.values()[i];
                list.add(ItemBedrockOreNew.make(grade, type));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1 + this.getGrade((int)metadata).traits.length;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        if (pass == 0) {
            return this.func_77617_a(meta);
        }
        return this.overlays[this.getGrade((int)meta).traits[pass - 1].ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        int icon = this.getGrade(meta).ordinal() * BedrockOreType.values().length + this.getType(meta).ordinal();
        return this.icons[Math.abs(icon % this.icons.length)];
    }

    public String func_77653_i(ItemStack stack) {
        int meta = stack.func_77960_j();
        String type = StatCollector.func_74837_a((String)(this.func_77657_g(stack) + ".type." + this.getType((int)meta).suffix + ".name"), (Object[])new Object[0]);
        return StatCollector.func_74837_a((String)(this.func_77657_g(stack) + ".grade." + this.getGrade(meta).name().toLowerCase(Locale.US) + ".name"), (Object[])new Object[]{type});
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        for (ProcessingTrait trait : this.getGrade((int)stack.func_77960_j()).traits) {
            list.add(I18nUtil.resolveKey(this.func_77657_g(stack) + ".trait." + trait.name().toLowerCase(Locale.US), new Object[0]));
        }
    }

    public static BedrockOreOutput o(NTMMaterial mat, int amount) {
        return new BedrockOreOutput(mat, amount);
    }

    public static Mats.MaterialStack toFluid(BedrockOreOutput o, double amount) {
        if (o.mat != null && o.mat.smeltable == NTMMaterial.SmeltingBehavior.SMELTABLE) {
            return new Mats.MaterialStack(o.mat, (int)Math.ceil((double)MaterialShapes.FRAGMENT.q(o.amount) * amount));
        }
        return null;
    }

    public static ItemStack extract(BedrockOreOutput o, double amount) {
        return new ItemStack(ModItems.bedrock_ore_fragment, Math.min((int)Math.ceil((double)o.amount * amount), 64), o.mat.id);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass != 0) {
            return 0xFFFFFF;
        }
        BedrockOreGrade grade = this.getGrade(stack.func_77960_j());
        return grade.tint;
    }

    public static ItemStack make(BedrockOreGrade grade, BedrockOreType type) {
        return ItemBedrockOreNew.make(grade, type, 1);
    }

    public static ItemStack make(BedrockOreGrade grade, BedrockOreType type, int amount) {
        return new ItemStack(ModItems.bedrock_ore, amount, grade.ordinal() << 4 | type.ordinal());
    }

    public BedrockOreGrade getGrade(int meta) {
        return (BedrockOreGrade)((Object)EnumUtil.grabEnumSafely(BedrockOreGrade.class, meta >> 4));
    }

    public BedrockOreType getType(int meta) {
        return (BedrockOreType)((Object)EnumUtil.grabEnumSafely(BedrockOreType.class, meta & 0xF));
    }

    public static enum BedrockOreGrade {
        BASE(0xFFFFFF, "base", new ProcessingTrait[0]),
        BASE_ROASTED(0xCFCFCF, "base", ProcessingTrait.ROASTED),
        BASE_WASHED(14410443, "base", ProcessingTrait.WASHED),
        PRIMARY(0xFFFFFF, "primary", ProcessingTrait.CENTRIFUGED),
        PRIMARY_ROASTED(0xCFCFCF, "primary", ProcessingTrait.ROASTED),
        PRIMARY_SULFURIC(0xFFFFD3, "primary", ProcessingTrait.SULFURIC),
        PRIMARY_NOSULFURIC(13882623, "primary", ProcessingTrait.CENTRIFUGED, ProcessingTrait.SULFURIC),
        PRIMARY_SOLVENT(13889791, "primary", ProcessingTrait.SOLVENT),
        PRIMARY_NOSOLVENT(16768723, "primary", ProcessingTrait.CENTRIFUGED, ProcessingTrait.SOLVENT),
        PRIMARY_RAD(15531987, "primary", ProcessingTrait.RAD),
        PRIMARY_NORAD(15455231, "primary", ProcessingTrait.CENTRIFUGED, ProcessingTrait.RAD),
        PRIMARY_FIRST(16765908, "primary", ProcessingTrait.CENTRIFUGED),
        PRIMARY_SECOND(13893611, "primary", ProcessingTrait.CENTRIFUGED),
        CRUMBS(0xFFFFFF, "crumbs", ProcessingTrait.CENTRIFUGED),
        SULFURIC_BYPRODUCT(0xFFFFFF, "sulfuric", ProcessingTrait.CENTRIFUGED, ProcessingTrait.SULFURIC),
        SULFURIC_ROASTED(0xCFCFCF, "sulfuric", ProcessingTrait.ROASTED, ProcessingTrait.SULFURIC),
        SULFURIC_ARC(12821154, "sulfuric", ProcessingTrait.ARC, ProcessingTrait.SULFURIC),
        SULFURIC_WASHED(14410443, "sulfuric", ProcessingTrait.WASHED, ProcessingTrait.SULFURIC),
        SOLVENT_BYPRODUCT(0xFFFFFF, "solvent", ProcessingTrait.CENTRIFUGED, ProcessingTrait.SOLVENT),
        SOLVENT_ROASTED(0xCFCFCF, "solvent", ProcessingTrait.ROASTED, ProcessingTrait.SOLVENT),
        SOLVENT_ARC(12821154, "solvent", ProcessingTrait.ARC, ProcessingTrait.SOLVENT),
        SOLVENT_WASHED(14410443, "solvent", ProcessingTrait.WASHED, ProcessingTrait.SOLVENT),
        RAD_BYPRODUCT(0xFFFFFF, "rad", ProcessingTrait.CENTRIFUGED, ProcessingTrait.RAD),
        RAD_ROASTED(0xCFCFCF, "rad", ProcessingTrait.ROASTED, ProcessingTrait.RAD),
        RAD_ARC(12821154, "rad", ProcessingTrait.ARC, ProcessingTrait.RAD),
        RAD_WASHED(14410443, "rad", ProcessingTrait.WASHED, ProcessingTrait.RAD);

        public int tint;
        public String prefix;
        public ProcessingTrait[] traits;

        private BedrockOreGrade(int tint, String prefix, ProcessingTrait ... traits) {
            this.tint = tint;
            this.prefix = prefix;
            this.traits = traits;
        }
    }

    public static enum ProcessingTrait {
        ROASTED,
        ARC,
        WASHED,
        CENTRIFUGED,
        SULFURIC,
        SOLVENT,
        RAD;

    }

    public static enum BedrockOreType {
        LIGHT_METAL(0xFFFFFF, 0x353535, "light", ItemBedrockOreNew.o(Mats.MAT_IRON, 9), ItemBedrockOreNew.o(Mats.MAT_COPPER, 9), ItemBedrockOreNew.o(Mats.MAT_TITANIUM, 6), ItemBedrockOreNew.o(Mats.MAT_BAUXITE, 9), ItemBedrockOreNew.o(Mats.MAT_CRYOLITE, 3), ItemBedrockOreNew.o(Mats.MAT_CHLOROCALCITE, 5), ItemBedrockOreNew.o(Mats.MAT_LITHIUM, 5), ItemBedrockOreNew.o(Mats.MAT_SODIUM, 3), ItemBedrockOreNew.o(Mats.MAT_CHLOROCALCITE, 6), ItemBedrockOreNew.o(Mats.MAT_LITHIUM, 6), ItemBedrockOreNew.o(Mats.MAT_SODIUM, 6)),
        HEAVY_METAL(0x868686, 0, "heavy", ItemBedrockOreNew.o(Mats.MAT_TUNGSTEN, 9), ItemBedrockOreNew.o(Mats.MAT_LEAD, 9), ItemBedrockOreNew.o(Mats.MAT_GOLD, 2), ItemBedrockOreNew.o(Mats.MAT_GOLD, 2), ItemBedrockOreNew.o(Mats.MAT_BERYLLIUM, 3), ItemBedrockOreNew.o(Mats.MAT_TUNGSTEN, 9), ItemBedrockOreNew.o(Mats.MAT_LEAD, 9), ItemBedrockOreNew.o(Mats.MAT_GOLD, 5), ItemBedrockOreNew.o(Mats.MAT_BISMUTH, 1), ItemBedrockOreNew.o(Mats.MAT_TANTALIUM, 1), ItemBedrockOreNew.o(Mats.MAT_GOLD, 6)),
        RARE_EARTH(0xE6E6B6, 0x1C1C00, "rare", ItemBedrockOreNew.o(Mats.MAT_COBALT, 5), ItemBedrockOreNew.o(Mats.MAT_RAREEARTH, 5), ItemBedrockOreNew.o(Mats.MAT_BORON, 5), ItemBedrockOreNew.o(Mats.MAT_LANTHANIUM, 3), ItemBedrockOreNew.o(Mats.MAT_NIOBIUM, 4), ItemBedrockOreNew.o(Mats.MAT_NEODYMIUM, 3), ItemBedrockOreNew.o(Mats.MAT_STRONTIUM, 3), ItemBedrockOreNew.o(Mats.MAT_ZIRCONIUM, 3), ItemBedrockOreNew.o(Mats.MAT_NIOBIUM, 5), ItemBedrockOreNew.o(Mats.MAT_NEODYMIUM, 5), ItemBedrockOreNew.o(Mats.MAT_STRONTIUM, 3)),
        ACTINIDE(12699581, 2830887, "actinide", ItemBedrockOreNew.o(Mats.MAT_URANIUM, 4), ItemBedrockOreNew.o(Mats.MAT_THORIUM, 4), ItemBedrockOreNew.o(Mats.MAT_RADIUM, 2), ItemBedrockOreNew.o(Mats.MAT_RADIUM, 2), ItemBedrockOreNew.o(Mats.MAT_POLONIUM, 2), ItemBedrockOreNew.o(Mats.MAT_RADIUM, 2), ItemBedrockOreNew.o(Mats.MAT_RADIUM, 2), ItemBedrockOreNew.o(Mats.MAT_POLONIUM, 2), ItemBedrockOreNew.o(Mats.MAT_TECHNETIUM, 1), ItemBedrockOreNew.o(Mats.MAT_TECHNETIUM, 1), ItemBedrockOreNew.o(Mats.MAT_U238, 1)),
        NON_METAL(0xAFAFAF, 986895, "nonmetal", ItemBedrockOreNew.o(Mats.MAT_COAL, 9), ItemBedrockOreNew.o(Mats.MAT_SULFUR, 9), ItemBedrockOreNew.o(Mats.MAT_LIGNITE, 9), ItemBedrockOreNew.o(Mats.MAT_KNO, 6), ItemBedrockOreNew.o(Mats.MAT_FLUORITE, 6), ItemBedrockOreNew.o(Mats.MAT_PHOSPHORUS, 5), ItemBedrockOreNew.o(Mats.MAT_FLUORITE, 6), ItemBedrockOreNew.o(Mats.MAT_SULFUR, 6), ItemBedrockOreNew.o(Mats.MAT_CHLOROCALCITE, 6), ItemBedrockOreNew.o(Mats.MAT_SILICON, 2), ItemBedrockOreNew.o(Mats.MAT_SILICON, 2)),
        CRYSTALLINE(14876666, 2001527, "crystal", ItemBedrockOreNew.o(Mats.MAT_REDSTONE, 9), ItemBedrockOreNew.o(Mats.MAT_CINNABAR, 4), ItemBedrockOreNew.o(Mats.MAT_SODALITE, 9), ItemBedrockOreNew.o(Mats.MAT_ASBESTOS, 6), ItemBedrockOreNew.o(Mats.MAT_DIAMOND, 3), ItemBedrockOreNew.o(Mats.MAT_CINNABAR, 3), ItemBedrockOreNew.o(Mats.MAT_ASBESTOS, 5), ItemBedrockOreNew.o(Mats.MAT_EMERALD, 3), ItemBedrockOreNew.o(Mats.MAT_BORAX, 3), ItemBedrockOreNew.o(Mats.MAT_MOLYSITE, 3), ItemBedrockOreNew.o(Mats.MAT_SODALITE, 9));

        public int light;
        public int dark;
        public String suffix;
        public BedrockOreOutput primary1;
        public BedrockOreOutput primary2;
        public BedrockOreOutput byproductAcid1;
        public BedrockOreOutput byproductAcid2;
        public BedrockOreOutput byproductAcid3;
        public BedrockOreOutput byproductSolvent1;
        public BedrockOreOutput byproductSolvent2;
        public BedrockOreOutput byproductSolvent3;
        public BedrockOreOutput byproductRad1;
        public BedrockOreOutput byproductRad2;
        public BedrockOreOutput byproductRad3;

        private BedrockOreType(int light, int dark, String suffix, BedrockOreOutput p1, BedrockOreOutput p2, BedrockOreOutput bA1, BedrockOreOutput bA2, BedrockOreOutput bA3, BedrockOreOutput bS1, BedrockOreOutput bS2, BedrockOreOutput bS3, BedrockOreOutput bR1, BedrockOreOutput bR2, BedrockOreOutput bR3) {
            this.light = light;
            this.dark = dark;
            this.suffix = suffix;
            this.primary1 = p1;
            this.primary2 = p2;
            this.byproductAcid1 = bA1;
            this.byproductAcid2 = bA2;
            this.byproductAcid3 = bA3;
            this.byproductSolvent1 = bS1;
            this.byproductSolvent2 = bS2;
            this.byproductSolvent3 = bS3;
            this.byproductRad1 = bR1;
            this.byproductRad2 = bR2;
            this.byproductRad3 = bR3;
        }
    }

    public static class BedrockOreOutput {
        public NTMMaterial mat;
        public int amount;

        public BedrockOreOutput(NTMMaterial mat, int amount) {
            this.mat = mat;
            this.amount = amount;
        }
    }
}

