/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.items.ModItems;
import com.hbm.particle.helper.ExplosionCreator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityMissileTier3
extends EntityMissileBaseNT {
    public EntityMissileTier3(World world) {
        super(world);
    }

    public EntityMissileTier3(World world, float x, float y, float z, int a, int b) {
        super(world, x, y, z, a, b);
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.plate_steel, 16));
        list.add(new ItemStack(ModItems.plate_titanium, 10));
        list.add(new ItemStack(ModItems.thruster_large, 1));
        return list;
    }

    @Override
    public String getUnlocalizedName() {
        return "radar.target.tier3";
    }

    @Override
    public int getBlipLevel() {
        return 3;
    }

    @Override
    protected void spawnContrail() {
        Vec3 thrust = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.5);
        thrust.func_72442_b((this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f);
        thrust.func_72440_a(this.field_70125_A * (float)Math.PI / 180.0f);
        thrust.func_72442_b(-(this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f);
        this.spawnContraolWithOffset(thrust.field_72450_a, thrust.field_72448_b, thrust.field_72449_c);
        this.spawnContraolWithOffset(-thrust.field_72449_c, thrust.field_72448_b, thrust.field_72450_a);
        this.spawnContraolWithOffset(-thrust.field_72450_a, -thrust.field_72449_c, -thrust.field_72449_c);
        this.spawnContraolWithOffset(thrust.field_72449_c, -thrust.field_72449_c, -thrust.field_72450_a);
    }

    public static class EntityMissileDrill
    extends EntityMissileTier3 {
        public EntityMissileDrill(World world) {
            super(world);
        }

        public EntityMissileDrill(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            for (int i = 0; i < 30; ++i) {
                ExplosionNT explosion = new ExplosionNT(this.field_70170_p, this, this.field_70165_t, this.field_70163_u - (double)i, this.field_70161_v, 10.0f);
                explosion.addAllAttrib(ExplosionNT.ExAttrib.ERRODE);
                explosion.explode();
            }
            ExplosionLarge.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25);
            ExplosionLarge.spawnShrapnels(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12);
            ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0, 50, 1.0);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_buster_large);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_drill);
        }
    }

    public static class EntityMissileRain
    extends EntityMissileTier3 {
        public EntityMissileRain(World world) {
            super(world);
        }

        public EntityMissileRain(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
            this.isCluster = true;
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0f, true);
            ExplosionChaos.cluster(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 100, 100);
        }

        @Override
        public void cluster() {
            this.onMissileImpact(null);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_cluster_large);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_rain);
        }
    }

    public static class EntityMissileInferno
    extends EntityMissileTier3 {
        public EntityMissileInferno(World world) {
            super(world);
        }

        public EntityMissileInferno(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            this.explodeStandard(50.0f, 48, true);
            ExplosionCreator.composeEffectLarge(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            ExplosionChaos.burn(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 10);
            ExplosionChaos.flameDeath(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 25);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_incendiary_large);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_inferno);
        }
    }

    public static class EntityMissileBurst
    extends EntityMissileTier3 {
        public EntityMissileBurst(World world) {
            super(world);
        }

        public EntityMissileBurst(World world, float x, float y, float z, int a, int b) {
            super(world, x, y, z, a, b);
        }

        @Override
        public void onMissileImpact(MovingObjectPosition mop) {
            this.explodeStandard(50.0f, 48, false);
            ExplosionCreator.composeEffectLarge(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }

        @Override
        public ItemStack getDebrisRareDrop() {
            return new ItemStack(ModItems.warhead_generic_large);
        }

        @Override
        public ItemStack getMissileItemForInfo() {
            return new ItemStack(ModItems.missile_burst);
        }
    }
}

