//===-- tapi/tapi.h - TAPI C++ Library Interface ----------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
///
/// \file
/// \brief This is the umbrella header for the TAPI C++ Library Interface.
/// \since 1.0
///
//===----------------------------------------------------------------------===//
#ifndef TAPI_H
#define TAPI_H

///
/// \defgroup TAPI_CPP_API TAPI C++ API
///
/// The C++ Application Programming Interface (API) for the TAPI library
///

#include <stdint.h>
#include <tapi/APIVersion.h>
#include <tapi/Defines.h>
#include <tapi/LinkerInterfaceFile.h>
#include <tapi/PackedVersion32.h>
#include <tapi/Symbol.h>
#include <tapi/Version.h>

#endif // TAPI_H
