'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tclvfs/tclvfs/doc/vfs-filesystems.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2001-2003 Vince Darley <vincentdarley@users.sourceforge.net>
'\" Copyright (c) 2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "vfs-filesystems" n 1.0  "Tcl-level Virtual Filesystems"
.BS
.SH NAME
vfs-filesystems \- Filesystems provided by tclvfs
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBvfs  ?1.2.1?\fR
.sp
package require \fBvfs::zip  ?1.0?\fR
.sp
package require \fBvfs::mk4  ?1.6?\fR
.sp
package require \fBvfs::tar  ?0.9?\fR
.sp
package require \fBvfs::ftp  ?1.0?\fR
.sp
package require \fBvfs::ns  ?1.0?\fR
.sp
package require \fBvfs::webdav  ?0.1?\fR
.sp
package require \fBvfs::http  ?0.5?\fR
.sp
package require \fBvfs::urltype  ?1.0?\fR
.sp
\fBvfs::zip::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::mk4::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::tar::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::ftp::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::ns::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::webdav::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::http::Mount\fR \fIpath\fR \fIto\fR
.sp
\fBvfs::urltype::Mount\fR \fIpath\fR \fIto\fR
.sp
.BE
.SH DESCRIPTION
The package \fBvfs\fR provides not only the means to implement a
virtual filesystem at the tcl level, but also a number of ready to be
used filesystems as well.
.PP
Each of these filesystem exists as its own package, and can be
accessed through \fBpackage require vfs::NAME\fR.
The whole set of these virtual filesystems is known informally as
\'\fIvfslib\fR'.
.SH "SUPPORTED VFS TYPES"
Currently supported are ftp, tar, http, zip, mk4, ns, and webdav.
In addition there is the ability to mount any 'urltype' as a new
directory, provided an appropriate vfs is supported.  This means that
you can treat urls based on the schemes \fIftp://\fR, \fIhttp://\fR
and \fIfile://\fR as files.  To do this, simply evaluate the command
\fBvfs::urltype::Mount ftp\fR
for example.  Any access inside the new volume will result in an
attempt to require a package through
\fBpackage require vfs::${type}\fR, which must therefore exist, or
errors will be thrown.
If a filesystem is loaded, use the associated command listed below to
mount a source for that filesystem as a tcl directory.
.TP
\fBvfs::zip::Mount\fR \fIpath\fR \fIto\fR
Mount the zip file \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::mk4::Mount\fR \fIpath\fR \fIto\fR
Mount the metakit database file file \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::tar::Mount\fR \fIpath\fR \fIto\fR
Mount the tar file \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::ftp::Mount\fR \fIpath\fR \fIto\fR
Mount the ftp url \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::ns::Mount\fR \fIpath\fR \fIto\fR
Mount the tcl namespace \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::webdav::Mount\fR \fIpath\fR \fIto\fR
Mount the webdav url \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::http::Mount\fR \fIpath\fR \fIto\fR
Mount the http url \fIpath\fR as directory \fIto\fR.
.TP
\fBvfs::urltype::Mount\fR \fIpath\fR \fIto\fR
Mount the url \fIpath\fR, of type \fIurltype\fR as directory \fIto\fR.
.PP
.SH LIMITATIONS
Most of the vfs types listed above have not been very well debugged as
yet.  Please test them!
.SH "SEE ALSO"
vfs, vfs-fsapi
.SH KEYWORDS
file, filesystem, ftp, http, metakit, namespace, tar, vfs, vfslib, webdav, zip
.SH COPYRIGHT
.nf
Copyright (c) 2001-2003 Vince Darley <vincentdarley@users.sourceforge.net>
Copyright (c) 2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi