'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/pt/pt_peg_import.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pt::peg::import" n 1 pt "Parser Tools"
.BS
.SH NAME
pt::peg::import \- PEG Import
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
package require \fBsnit \fR
.sp
package require \fBconfiguration \fR
.sp
package require \fBpt::peg \fR
.sp
package require \fBpluginmgr \fR
.sp
package require \fBpt::peg::import  ?1?\fR
.sp
\fB::pt::peg::import\fR \fIobjectName\fR
.sp
\fBobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBimport text\fR \fItext\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBimport file\fR \fIpath\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBimport object text\fR \fIobject\fR \fItext\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBimport object file\fR \fIobject\fR \fIpath\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBincludes\fR
.sp
\fIobjectName\fR \fBinclude add\fR \fIpath\fR
.sp
\fIobjectName\fR \fBinclude remove\fR \fIpath\fR
.sp
\fIobjectName\fR \fBinclude clear\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR. This document is the
entrypoint to the whole system the current package is a part of.
.PP
This package provides a manager for parsing expression grammars, with
each instance handling a set of plugins for the import of them from
other formats, i.e. their conversion from, for example \fIpeg\fR,
\fIcontainer\fR, \fIjson\fR, etc.
.PP
It resides in the Import section of the Core Layer of Parser Tools,
and is one of the three pillars the management of parsing expression
grammars resides on.
.PP
IMAGE: arch_core_import
.PP
The other two pillars are, as shown above
.IP [1]
\fIPEG Export\fR, and
.IP [2]
\fIPEG Storage\fR
.PP
.PP
For information about the data structure which is the major output of
the manager objects provided by this package see the section
\fBPEG serialization format\fR.
.PP
The plugin system of our class is based on the package
\fBpluginmgr\fR, and configured to look for plugins using
.IP [1]
the environment variable \fBGRAMMAR_PEG_IMPORT_PLUGINS\fR,
.IP [2]
the environment variable \fBGRAMMAR_PEG_PLUGINS\fR,
.IP [3]
the environment variable \fBGRAMMAR_PLUGINS\fR,
.IP [4]
the path "\fI~/.grammar/peg/import/plugin\fR"
.IP [5]
the path "\fI~/.grammar/peg/plugin\fR"
.IP [6]
the path "\fI~/.grammar/plugin\fR"
.IP [7]
the path "\fI~/.grammar/peg/import/plugins\fR"
.IP [8]
the path "\fI~/.grammar/peg/plugins\fR"
.IP [9]
the path "\fI~/.grammar/plugins\fR"
.IP [10]
the registry entry "HKEY_CURRENT_USER\\SOFTWARE\\GRAMMAR\\PEG\\IMPORT\\PLUGINS"
.IP [11]
the registry entry "HKEY_CURRENT_USER\\SOFTWARE\\GRAMMAR\\PEG\\PLUGINS"
.IP [12]
the registry entry "HKEY_CURRENT_USER\\SOFTWARE\\GRAMMAR\\PLUGINS"
.PP
The last three are used only when the package is run on a machine
using the Windows(tm) operating system.
.PP
The whole system is delivered with three predefined import plugins,
namely
.TP
container
See \fIPEG Import Plugin. From CONTAINER format\fR for details.
.TP
json
See \fIPEG Import Plugin. From JSON format\fR for details.
.TP
peg
See \fIPEG Import Plugin. From PEG format\fR for details.
.PP
.PP
For readers wishing to write their own import plugin for some format,
i.e. \fIplugin writer\fRs, reading and understanding the
\fIParser Tools Impport API\fR specification is an absolute
necessity, as it documents the interaction between this package and
its plugins in detail.
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fB::pt::peg::import\fR \fIobjectName\fR
This command creates a new import manager object with an associated
Tcl command whose name is \fIobjectName\fR. This \fIobject\fR command
is explained in full detail in the sections \fBObject command\fR
and \fBObject methods\fR. The object command will be created
under the current namespace if the \fIobjectName\fR is not fully
qualified, and in the specified namespace otherwise.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::pt::peg::import\fR command have
the following general form:
.TP
\fBobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command.
See section \fBObject methods\fR for the detailed
specifications.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object it is invoked for.
.TP
\fIobjectName\fR \fBimport text\fR \fItext\fR ?\fIformat\fR?
This method takes the \fItext\fR and converts it from the specified
\fIformat\fR to the canonical serialization of a parsing expression
grammar using the import plugin for the format. An error is thrown if
no plugin could be found for the format.
The serialization generated by the conversion process is returned as
the result of this method.
.sp
If no format is specified the method defaults to \fBtext\fR.
.sp
The specification of what a \fIcanonical\fR serialization is can be
found in the section \fBPEG serialization format\fR.
.sp
The plugin has to conform to the interface documented in the
\fIParser Tools Import API\fR specification.
.TP
\fIobjectName\fR \fBimport file\fR \fIpath\fR ?\fIformat\fR?
This method is a convenient wrapper around the \fBimport text\fR
method described by the previous item.
It reads the contents of the specified file into memory, feeds the
result into \fBimport text\fR and returns the resulting
serialization as its own result.
.TP
\fIobjectName\fR \fBimport object text\fR \fIobject\fR \fItext\fR ?\fIformat\fR?
This method is a convenient wrapper around the \fBimport text\fR
method described by the previous item.
It expects that \fIobject\fR is an object command supporting a
\fBdeserialize\fR method expecting the canonical serialization of a
parsing expression grammar.
It imports the text using \fBimport text\fR and then feeds the
resulting serialization into the \fIobject\fR via \fBdeserialize\fR.
This method returns the empty string as it result.
.TP
\fIobjectName\fR \fBimport object file\fR \fIobject\fR \fIpath\fR ?\fIformat\fR?
This method behaves like \fBimport object text\fR, except that it
reads the text to convert from the specified file instead of being
given it as argument.
.TP
\fIobjectName\fR \fBincludes\fR
This method returns a list containing the currently specified paths to
use to search for include files when processing input.
The order of paths in the list corresponds to the order in which they
are used, from first to last, and also corresponds to the order in
which they were added to the object.
.TP
\fIobjectName\fR \fBinclude add\fR \fIpath\fR
This methods adds the specified \fIpath\fR to the list of paths to use
to search for include files when processing input. The path is added
to the end of the list, causing it to be searched after all previously
added paths. The result of the command is the empty string.
.sp
The method does nothing if the path is already known.
.TP
\fIobjectName\fR \fBinclude remove\fR \fIpath\fR
This methods removes the specified \fIpath\fR from the list of paths
to use to search for include files when processing input. The result
of the command is the empty string.
.sp
The method does nothing if the path is not known.
.TP
\fIobjectName\fR \fBinclude clear\fR
This method clears the list of paths to use to search for include
files when processing input. The result of the command is the empty
string.
.PP
.SH "PEG SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expression Grammars as immutable values for transport,
comparison, etc.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations.
While a PEG may have more than one regular serialization only exactly
one of them will be \fIcanonical\fR.
.TP
regular serialization
.RS
.IP [1]
The serialization of any PEG is a nested Tcl dictionary.
.IP [2]
This dictionary holds a single key, \fBpt::grammar::peg\fR, and its
value. This value holds the contents of the grammar.
.IP [3]
The contents of the grammar are a Tcl dictionary holding the set of
nonterminal symbols and the starting expression. The relevant keys and
their values are
.RS
.TP
\fBrules\fR
The value is a Tcl dictionary whose keys are the names of the
nonterminal symbols known to the grammar.
.RS
.IP [1]
Each nonterminal symbol may occur only once.
.IP [2]
The empty string is not a legal nonterminal symbol.
.IP [3]
The value for each symbol is a Tcl dictionary itself. The relevant
keys and their values in this dictionary are
.RS
.TP
\fBis\fR
The value is the serialization of the parsing expression describing
the symbols sentennial structure, as specified in the section
\fBPE serialization format\fR.
.TP
\fBmode\fR
The value can be one of three values specifying how a parser should
handle the semantic value produced by the symbol.
.RS
.TP
\fBvalue\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal itself,
which has the ASTs of the symbol's right hand side as its children.
.TP
\fBleaf\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal, without any
children. Any ASTs generated by the symbol's right hand side are
discarded.
.TP
\fBvoid\fR
The nonterminal has no semantic value. Any ASTs generated by the
symbol's right hand side are discarded (as well).
.RE
.RE
.RE
.TP
\fBstart\fR
The value is the serialization of the start parsing expression of the
grammar, as specified in the section \fBPE serialization format\fR.
.RE
.IP [4]
The terminal symbols of the grammar are specified implicitly as the
set of all terminal symbols used in the start expression and on the
RHS of the grammar rules.
.RE
.TP
canonical serialization
The canonical serialization of a grammar has the format as specified
in the previous item, and then additionally satisfies the constraints
below, which make it unique among all the possible serializations of
this grammar.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR.
.IP [2]
The string representation of the value is the canonical representation
of a Tcl dictionary. I.e. it does not contain superfluous whitespace.
.RE
.PP
.SS EXAMPLE
Assuming the following PEG for simple mathematical expressions
.PP
.nf

PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'	;
    Sign       <- '-' / '+'					;
    Number     <- Sign? Digit+					;
    Expression <- '(' Expression ')' / (Factor (MulOp Factor)*)	;
    MulOp      <- '*' / '/'					;
    Factor     <- Term (AddOp Term)*				;
    AddOp      <- '+'/'-'					;
    Term       <- Number					;
END;

.fi
.PP
then its canonical serialization (except for whitespace) is
.PP
.nf

pt::grammar::peg {
    rules {
	AddOp      {is {/ {t -} {t +}}                                                                mode value}
	Digit      {is {/ {t 0} {t 1} {t 2} {t 3} {t 4} {t 5} {t 6} {t 7} {t 8} {t 9}}                mode value}
	Expression {is {/ {x {t (} {n Expression} {t )}} {x {n Factor} {* {x {n MulOp} {n Factor}}}}} mode value}
	Factor     {is {x {n Term} {* {x {n AddOp} {n Term}}}}                                        mode value}
	MulOp      {is {/ {t *} {t /}}                                                                mode value}
	Number     {is {x {? {n Sign}} {+ {n Digit}}}                                                 mode value}
	Sign       {is {/ {t -} {t +}}                                                                mode value}
	Term       {is  {n Number}                                                                    mode value}
    }
    start {n Expression}
}

.fi
.PP
.SH "PE SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expressions as immutable values for transport, comparison,
etc.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations.
While a parsing expression may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR.
.TP
Regular serialization
.RS
.TP
\fBAtomic Parsing Expressions\fR
.RS
.IP [1]
The string \fBepsilon\fR is an atomic parsing expression. It matches
the empty string.
.IP [2]
The string \fBdot\fR is an atomic parsing expression. It matches
any character.
.IP [3]
The string \fBalnum\fR is an atomic parsing expression. It matches
any Unicode alphabet or digit character. This is a custom extension of
PEs based on Tcl's builtin command \fBstring is\fR.
.IP [4]
The string \fBalpha\fR is an atomic parsing expression. It matches
any Unicode alphabet character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [5]
The string \fBascii\fR is an atomic parsing expression. It matches
any Unicode character below U0080. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [6]
The string \fBcontrol\fR is an atomic parsing expression. It matches
any Unicode control character. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR.
.IP [7]
The string \fBdigit\fR is an atomic parsing expression. It matches
any Unicode digit character. Note that this includes characters
outside of the [0..9] range. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [8]
The string \fBgraph\fR is an atomic parsing expression. It matches
any Unicode printing character, except for space. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [9]
The string \fBlower\fR is an atomic parsing expression. It matches
any Unicode lower-case alphabet character. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [10]
The string \fBprint\fR is an atomic parsing expression. It matches
any Unicode printing character, including space. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [11]
The string \fBpunct\fR is an atomic parsing expression. It matches
any Unicode punctuation character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [12]
The string \fBspace\fR is an atomic parsing expression. It matches
any Unicode space character. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR.
.IP [13]
The string \fBupper\fR is an atomic parsing expression. It matches
any Unicode upper-case alphabet character. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [14]
The string \fBwordchar\fR is an atomic parsing expression. It
matches any Unicode word character. This is any alphanumeric character
(see alnum), and any connector punctuation characters (e.g.
underscore). This is a custom extension of PEs based on Tcl's builtin
command \fBstring is\fR.
.IP [15]
The string \fBxdigit\fR is an atomic parsing expression. It matches
any hexadecimal digit character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [16]
The string \fBddigit\fR is an atomic parsing expression. It matches
any decimal digit character. This is a custom extension of PEs based
on Tcl's builtin command \fBregexp\fR.
.IP [17]
The expression
[list t \fBx\fR]
is an atomic parsing expression. It matches the terminal string \fBx\fR.
.IP [18]
The expression
[list n \fBA\fR]
is an atomic parsing expression. It matches the nonterminal \fBA\fR.
.RE
.TP
\fBCombined Parsing Expressions\fR
.RS
.IP [1]
For parsing expressions \fBe1\fR, \fBe2\fR, ... the result of
[list / \fBe1\fR \fBe2\fR ... ]
is a parsing expression as well.
This is the \fIordered choice\fR, aka \fIprioritized choice\fR.
.IP [2]
For parsing expressions \fBe1\fR, \fBe2\fR, ... the result of
[list x \fBe1\fR \fBe2\fR ... ]
is a parsing expression as well.
This is the \fIsequence\fR.
.IP [3]
For a parsing expression \fBe\fR the result of
[list * \fBe\fR]
is a parsing expression as well.
This is the \fIkleene closure\fR, describing zero or more
repetitions.
.IP [4]
For a parsing expression \fBe\fR the result of
[list + \fBe\fR]
is a parsing expression as well.
This is the \fIpositive kleene closure\fR, describing one or more
repetitions.
.IP [5]
For a parsing expression \fBe\fR the result of
[list & \fBe\fR]
is a parsing expression as well.
This is the \fIand lookahead predicate\fR.
.IP [6]
For a parsing expression \fBe\fR the result of
[list ! \fBe\fR]
is a parsing expression as well.
This is the \fInot lookahead predicate\fR.
.IP [7]
For a parsing expression \fBe\fR the result of
[list ? \fBe\fR]
is a parsing expression as well.
This is the \fIoptional input\fR.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of a parsing expression has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this parsing expression.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list. I.e. it does not contain superfluous whitespace.
.IP [2]
Terminals are \fInot\fR encoded as ranges (where start and end of the
range are identical).
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression shown on the right-hand side of the
rule
.PP
.nf

    Expression <- '(' Expression ')'
                / Factor (MulOp Factor)*

.fi
.PP
then its canonical serialization (except for whitespace) is
.PP
.nf

    {/ {x {t (} {n Expression} {t )}} {x {n Factor} {* {x {n MulOp} {n Factor}}}}}

.fi
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpt\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi