'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/png/png.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004, Code: Aaron Faupell <afaupell@users.sourceforge.net>
'\" Copyright (c) 2004, Doc:  Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "png" n 0.1.2 png "Image manipulation"
.BS
.SH NAME
png \- PNG querying and manipulation of meta data
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBcrc32 \fR
.sp
package require \fBpng  ?0.1.2?\fR
.sp
\fB::png::validate\fR \fIfile\fR
.sp
\fB::png::isPNG\fR \fIfile\fR
.sp
\fB::png::imageInfo\fR \fIfile\fR
.sp
\fB::png::getTimestamp\fR \fIfile\fR
.sp
\fB::png::setTimestamp\fR \fIfile\fR \fItime\fR
.sp
\fB::png::getComments\fR \fIfile\fR
.sp
\fB::png::removeComments\fR \fIfile\fR
.sp
\fB::png::addComment\fR \fIfile\fR \fIkeyword\fR \fItext\fR
.sp
\fB::png::addComment\fR \fIfile\fR \fIkeyword\fR \fIlang\fR \fIkeyword2\fR \fItext\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides commands to query and modify PNG images. PNG
stands for \fIPortable Network Graphics\fR and is specified at
\fIhttp://www.libpng.org/pub/png/spec/1.2\fR.
.SH COMMANDS
.TP
\fB::png::validate\fR \fIfile\fR
Returns a value indicating if \fIfile\fR is a valid PNG file. The file
is checked for PNG signature, each chunks checksum is verified,
existence of a data chunk is verified, first chunk is checked for
header, last chunk is checked for ending. Things \fInot\fR checked
for are: validity of values within a chunk, multiple header chunks,
noncontiguous data chunks, end chunk before actual eof. This procedure
can take lots of time.
.sp
Possible return values:
.RS
.TP
OK
File is a valid PNG file.
.TP
SIG
no/broken PNG signature.
.TP
BADLEN
corrupt chunk length.
.TP
EOF
premature end of file.
.TP
NOHDR
missing header chunk.
.TP
CKSUM
crc mismatch.
.TP
NODATA
missing data chunk(s).
.TP
NOEND
missing end marker.
.RE
.TP
\fB::png::isPNG\fR \fIfile\fR
Returns a boolean value indicating if the file \fIfile\fR starts with
a PNG signature. This is a much faster and less intensive check than
\fB::png::validate\fR as it does not check if the PNG data is valid.
.TP
\fB::png::imageInfo\fR \fIfile\fR
Returns a dictionary with keys \fBwidth\fR, \fBheight\fR,
\fBdepth\fR, \fBcolor\fR, \fBcompression\fR, \fBfilter\fR, and
\fBinterlace\fR. The values are the associated properties of the PNG
image in \fIfile\fR.
Throws an error if file is not a PNG image, or if the checksum of the
header is invalid. For information on interpreting the values for the
returned properties see
\fIhttp://www.libpng.org/pub/png/spec/1.2/PNG-Chunks.html\fR.
.TP
\fB::png::getTimestamp\fR \fIfile\fR
Returns the epoch time if a timestamp chunk is found in the PNG image
contained in the \fIfile\fR, otherwise returns the empty string. Does
not attempt to verify the checksum of the timestamp chunk.
Throws an error if the \fIfile\fR is not a valid PNG image.
.TP
\fB::png::setTimestamp\fR \fIfile\fR \fItime\fR
Writes a new timestamp to the \fIfile\fR, either replacing the old
timestamp, or adding one just before the data chunks if there was no
previous timestamp. \fItime\fR is the new time in the gmt epoch
format.
Throws an error if \fIfile\fR is not a valid PNG image.
.TP
\fB::png::getComments\fR \fIfile\fR
Currently supports only uncompressed comments. Does not attempt to
verify the checksums of the comment chunks. Returns a list where each
element is a comment. Each comment is itself a list. The list for a
plain text comment consists of 2 elements: the human readable keyword,
and the text data. A unicode (international) comment consists of 4
elements: the human readable keyword, the language identifier, the
translated keyword, and the unicode text data.
Throws an error if \fIfile\fR is not a valid PNG image.
.TP
\fB::png::removeComments\fR \fIfile\fR
Removes all comments from the PNG image in \fIfile\fR. Beware - This
uses memory equal to the file size minus comments, to hold the
intermediate result.
Throws an error if \fIfile\fR is not a valid PNG image.
.TP
\fB::png::addComment\fR \fIfile\fR \fIkeyword\fR \fItext\fR
Adds a plain \fItext\fR comment to the PNG image in \fIfile\fR, just
before the first data chunk. Will throw an error if no data chunk is
found. \fIkeyword\fR has to be less than 80 characters long to conform
to the PNG specification.
.TP
\fB::png::addComment\fR \fIfile\fR \fIkeyword\fR \fIlang\fR \fIkeyword2\fR \fItext\fR
Adds a unicode (international) comment to the PNG image in \fIfile\fR,
just before the first data chunk. Will throw an error if no data chunk
is found. \fIkeyword\fR has to be less than 80 characters long to
conform to the PNG specification. \fIkeyword2\fR is the translated
\fIkeyword\fR, in the language specified by the language identifier
\fIlang\fR.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpng\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
comment, image, png, timestamp
.SH CATEGORY
File formats
.SH COPYRIGHT
.nf
Copyright (c) 2004, Code: Aaron Faupell <afaupell@users.sourceforge.net>
Copyright (c) 2004, Doc:  Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi