'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/pluginmgr/pluginmgr.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pluginmgr" n 0.3 pluginmgr "Plugin management"
.BS
.SH NAME
pluginmgr \- Manage a plugin
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBpluginmgr  ?0.3?\fR
.sp
\fB::pluginmgr\fR \fIobjectName\fR ?\fIoption value\fR...?
.sp
\fB::pluginmgr::paths\fR \fIobjectName\fR \fIname\fR...
.sp
\fBobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
.sp
\fIobjectName\fR \fBclone\fR
.sp
\fIobjectName\fR \fBconfigure\fR
.sp
\fIobjectName\fR \fBconfigure\fR \fIoption\fR
.sp
\fIobjectName\fR \fBconfigure\fR \fB-option\fR \fIvalue\fR...
.sp
\fIobjectName\fR \fBcget\fR \fB-option\fR
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBdo\fR \fIarg\fR...
.sp
\fIobjectName\fR \fBinterpreter\fR
.sp
\fIobjectName\fR \fBplugin\fR
.sp
\fIobjectName\fR \fBload\fR \fIstring\fR
.sp
\fIobjectName\fR \fBunload\fR
.sp
\fIobjectName\fR \fBlist\fR
.sp
\fIobjectName\fR \fBpath\fR \fIpath\fR
.sp
\fIobjectName\fR \fBpaths\fR
.sp
.BE
.SH DESCRIPTION
This package provides commands and objects for the generic management
of plugins which can be loaded into an application.
.PP
To avoid the implementation of yet another system to locate Tcl code
the system provides by this package is built on top of the regular
package management system. Each plugin is considered as a package and
a simple invokation of \fBpackage require\fR is enough to locate and
load it, if it exists. The only time we will need additional paths is
when a plugin manager is part of a wrapped application and has to be
able to search for plugins existing outside of that application. For
this situation the package provides a command to create a general set
of such paths based on names for the plugin manager and/or application
in question.
.PP
The main contribution of this package is a generic framework which
allows the easy declaration of
.IP [1]
How to translate a plugin name to the name of the package implementing
it, and vice versa.
.IP [2]
The list of commands a plugin has to provide as API, and also of more
complex checks as code.
.IP [3]
The list of commands expected by the plugin from the environment.
.PP
This then allows the easy generation of plugin managers customized to
particular types of plugins for an application.
.PP
It should be noted that all plugin code is considered untrusted and
will always be executed within a safe interpreter. The interpreter is
enabled enough to allow plugins the loading of all additional packages
they may need.
.SH "PUBLIC API"
.SS "PACKAGE COMMANDS"
.TP
\fB::pluginmgr\fR \fIobjectName\fR ?\fIoption value\fR...?
This command creates a new plugin manager object with an associated
Tcl command whose name is \fIobjectName\fR. This \fIobject\fR command
is explained in full detail in the sections \fBOBJECT COMMAND\fR
and \fBOBJECT METHODS\fR. The object command will be created
under the current namespace if the \fIobjectName\fR is not fully
qualified, and in the specified namespace otherwise.
.sp
The options and their values coming after the name of the object are
used to set the initial configuration of the mamager object,
specifying the applicable plugins and their API.
.TP
\fB::pluginmgr::paths\fR \fIobjectName\fR \fIname\fR...
This utility command adds a set of paths to the specified object,
based on the given \fIname\fRs.
It will search for:
.RS
.IP [1]
The environment variable \fB\fIname\fR_PLUGINS\fR. Its contents will
be interpreted as a list of package paths. The entries have to be
separated by either \fB:\fR (unix) or \fB;\fR (windows).
.sp
The name will be converted to upper-case letters.
.IP [2]
The registry entry "HKEY_LOCAL_MACHINE\\SOFTWARE\\\fIname\fR\\PLUGINS".
Its contents will be interpreted as a list of package paths. The
entries have to be separated by \fB;\fR. This item is considered
only when on Windows (tm).
.sp
The casing of letters is not changed.
.IP [3]
The registry entry "HKEY_CURRENT_USER\\SOFTWARE\\\fIname\fR\\PLUGINS".
Its contents will be interpreted as a list of package paths. The
entries have to be separated by \fB;\fR. This item is considered
only when on Windows (tm).
.sp
The casing of letters is not changed.
.IP [4]
The directory "\fI~/.\fIname\fR/plugin\fR".
.IP [5]
The directory "\fI~/.\fIname\fR/plugins\fR".
.sp
The casing of letters is not changed.
.RE
.sp
and add all the paths found that way to the list of package paths
maintained by the object.
.sp
If \fIname\fR is namespaced each item in the list will be repeated per
prefix of \fIname\fR, with conversion of :-sequences into the proper
separator (underscore for environment variables, backslash for
registry entries, and / for directories).
.sp
Examples:
.sp
.nf

    ::pluginmgr::paths ::obj docidx

    => env  DOCIDX_PLUGINS
       reg  HKEY_LOCAL_MACHINE\\SOFTWARE\\docidx\\PLUGINS
       reg  HKEY_CURRENT_USER\\SOFTWARE\\docidx\\PLUGINS
       path ~/.docidx/plugins

    ::pluginmgr::paths ::obj doctools::idx

    => env  DOCTOOLS_PLUGINS
       env  DOCTOOLS_IDX_PLUGINS
       reg  HKEY_LOCAL_MACHINE\\SOFTWARE\\doctools\\PLUGINS
       reg  HKEY_LOCAL_MACHINE\\SOFTWARE\\doctools\\idx\\PLUGINS
       reg  HKEY_CURRENT_USER\\SOFTWARE\\doctools\\PLUGINS
       reg  HKEY_CURRENT_USER\\SOFTWARE\\doctools\\idx\\PLUGINS
       path ~/.doctools/plugin
       path ~/.doctools/idx/plugin

.fi
.PP
.SS "OBJECT COMMAND"
All commands created by the command \fB::pluginmgr\fR (See section
\fBPACKAGE COMMANDS\fR) have the following general form and may
be used to invoke various operations on their plugin manager object.
.TP
\fBobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the exact
behavior of the command. See section \fBOBJECT METHODS\fR for
the detailed specifications.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBclone\fR
This method creates a new plugin management object and returns the
associated object command. The generated object is a clone of the
object the method was invoked on. I.e. the new object will have the
same configuration as the current object. With regard to state, if the
current object has a plugin loaded then this plugin and all associated
state is moved to the generated clone and the current object is reset
into the base state (no plugin loaded). In this manner a configured
plugin manager is also a factory for loaded plugins.
.TP
\fIobjectName\fR \fBconfigure\fR
The method returns a list of all known options and their current
values when called without any arguments.
.TP
\fIobjectName\fR \fBconfigure\fR \fIoption\fR
The method behaves like the method \fBcget\fR when called with a
single argument and returns the value of the option specified by said
argument.
.TP
\fIobjectName\fR \fBconfigure\fR \fB-option\fR \fIvalue\fR...
The method reconfigures the specified \fBoption\fRs of the object,
setting them to the associated \fIvalue\fRs, when called with an even
number of arguments, at least two.
.sp
The legal options are described in the section
\fBOBJECT CONFIGURATION\fR.
.TP
\fIobjectName\fR \fBcget\fR \fB-option\fR
This method expects a legal configuration option as argument and will
return the current value of that option for the object the method was
invoked for.
.sp
The legal configuration options are described in section
\fBOBJECT CONFIGURATION\fR.
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object it is invoked for.
.TP
\fIobjectName\fR \fBdo\fR \fIarg\fR...
This method interprets its list of arguments as the words of a command
and invokes this command in the execution context of the plugin.
The result of the invoked command is made the result of the method.
The call will fail with an error if no valid plugin has been loaded
into the manager object.
.TP
\fIobjectName\fR \fBinterpreter\fR
This method returns the handle of the safe interpreter the current
plugin is loaded into. An empty string as return value signals that
the manager currently has no valid plugin loaded.
.TP
\fIobjectName\fR \fBplugin\fR
This method returns the name of the plugin currently loaded. An empty
string as return value signals that the manager currently has no valid
plugin loaded.
.TP
\fIobjectName\fR \fBload\fR \fIstring\fR
This method loads, validates, and initializes a named plugin into the
manager object.
.sp
The algorithm to locate and load the plugin employed is:
.RS
.IP [1]
If the \fIstring\fR contains the path to an existing file then this
file is taken as the implementation of the plugin.
.IP [2]
Otherwise the plugin name is translated into a package name via the value
of the option \fB-pattern\fR and then loaded through the
regular package management.
.IP [3]
The load fails.
.RE
.sp
The algorithm to validate and initialize the loaded code is:
.RS
.IP [1]
If the option \fB-api\fR is non-empty introspection commands are
used to ascertain that the plugin provides the listed commands.
.IP [2]
If the option \fB-check\fR is non-empty the specified command
prefix is called.
.IP [3]
If either of the above fails the candidate plugin is unloaded again
.IP [4]
Otherwise all the commands specified via the option
\fB-cmds\fR are installed in the plugin.
.RE
.sp
A previously loaded plugin is discarded, but only if the new plugin
was found and sucessfully validated and initialized. Note that there
will be no intereference between old and new plugin as both will be
put into separate safe interpreters.
.TP
\fIobjectName\fR \fBunload\fR
This method unloads the currently loaded plugin. It returns the empty
string. The call will be silently ignored if no plugin is loaded at
all.
.TP
\fIobjectName\fR \fBlist\fR
This method uses the contents of the option \fB-pattern\fR to find
all packages which can be plugins under the purview of this manager
object. It translates their names into plugin names and returns a list
containing them.
.TP
\fIobjectName\fR \fBpath\fR \fIpath\fR
This methods adds the specified \fIpath\fR to the list of additional
package paths to look at when searching for a plugin. It returns the
empty string. Duplicate paths are ignored, i.e. each path is added
only once. Paths are made absolute, but are not normalized.
.TP
\fIobjectName\fR \fBpaths\fR
This method returns a list containing all additional paths which have
been added to the plugin manager object since its creation.
.PP
.SS "OBJECT CONFIGURATION"
All plugin manager objects understand the following configuration options:
.TP
\fB-pattern\fR \fIstring\fR
The value of this option is a glob pattern which has to contain
exactly one '*'-operator. All packages whose names match this pattern
are the plugins recognized by the manager object. And vice versa, the
replacement of the '*'-operator with a plugin name will yield the name
of the package implementing that plugin.
.sp
This option has no default, except if option \fB-name\fR was set.
It has to be set before attempting to load a plugin, either directly,
or through option \fB-name\fR.
.TP
\fB-api\fR \fIlist\fR
The value of this option is a list of command names, and any plugin
loaded has to provide these commands. Names which are not fully
qualified are considered to be rooted in the global namespace.
If empty no expectations are made on the plugin. The default value is
the empty list.
.TP
\fB-check\fR \fIcmdprefix\fR
The value of this option is interpreted as a command prefix.
Its purpose is to perform complex checks on a loaded plugin package to
validate it, which go beyond a simple list of provided commands.
.sp
It is called with the manager object command as the only argument and
has to return a boolean value. A value of \fBtrue\fR will be
interpreted to mean that the candidate plugin passed the test.
The call will happen if and only if the candidate plugin already
passed the basic API check specified through the option \fB-api\fR.
.sp
The default value is the empty list, which causes the manager object
to suppress the call and to assume the candidate plugin passes.
.TP
\fB-cmds\fR \fIdict\fR
The value of this option is a dictionary.  It specifies the commands
which will be made available to the plugin (as keys), and the trusted
commands in the environment which implement them (as values).
The trusted commands will be executed in the interpreter specified by
the option \fB-cmdip\fR.
The default value is the empty dictionary.
.TP
\fB-cmdip\fR \fIipspec\fR
The value of this option is the path of the interpreter where the
trusted commands given to the plugin will be executed in.
The default is the empty string, referring to the current interpreter.
.TP
\fB-setup\fR \fIcmdprefix\fR
The value of this option is interpreted as a command prefix.
.sp
It is called whenever a new safe interpreter for a plugin has been
created, but before a plugin is loaded. It is provided with the
manager object command and the interpreter handle as its only
arguments. Any return value will be ignored.
.sp
Its purpose is give a user of the plugin management the ability to
define commands, packages, etc. a chosen plugin may need while being
loaded.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpluginmgr\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
plugin management, plugin search
.SH CATEGORY
Programming tools
.SH COPYRIGHT
.nf
Copyright (c) 2005 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi