'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/nns/nns_intro.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "nns_intro" n 1.0 nns "Name service facility"
.BS
.SH NAME
nns_intro \- Name service facility, introduction
.SH DESCRIPTION
.PP
\fInns\fR (short for \fInano nameservice\fR) is a facility built
for the package \fBcomm\fR, adding a simple name service to it.
It is also built on top of \fBcomm\fR, using it for the exchange
of messages between the client and server parts.
.PP
This name service facility has nothing to do with the Internet's
\fIDomain Name System\fR, otherwise known as \fIDNS\fR. If the
reader is looking for a package dealing with that please see either of
the packages \fBdns\fR and \fBresolv\fR, both found in Tcllib
too.
.PP
Tcllib provides 2 applications and 4 packages which are working
together and provide access to the facility at different levels.
.SH APPLICATIONS
The application \fBnnsd\fR provides a simple name server which can
be run by anybody anywhere on their system, as they see fit.
It is also an example on the use of the server-side package
\fBnameserv::server\fR.
.PP
Complementing this server is the \fBnns\fR client application.
A possible, but no very sensible use would be to enter name/port
bindings into a server from a shell script. Not sensible, as shell
scripts normally do not provide a \fBcomm\fR-based service.
.PP
The only case for this to make some sense would be in a shell script
wrapped around a Tcl script FOO which is using comm, to register the
listening port used by FOO.
However even there it would much more sensible to extend FOO to use
the nameservice directly. And in regard on how to that \fBnns\fR
can be used as both example and template.
Beyond that it may also be useful to perform nameservice queries from
shell scripts.
.PP
The third application, \fBnnslog\fR is a stripped down form of the
\fBnns\fR client application. It is reduced to perform a continuous
search for all changes and logs all received events to stdout.
.PP
Both clients use the \fBnameserv::auto\fR package to automatically
hande the loss and restoration of the connection to the server.
.SH PACKAGES
The two main packages implementing the service are \fBnameserv\fR
and \fBnameserv::server\fR, i.e. client and server. The latter has
not much of an API, just enough to start, stop, and configure it. See
the application \fBnnsd\fR on how to use it.
.PP
The basic client, in package \fBnameserv\fR, provides the main API
to manipulate and query the service. An example of its use is the
application \fBnns\fR.
.PP
The second client package, \fBnameserv::auto\fR is API compatible
to the basic client, but provides the additional functionality that it
will automatically restore data like bound names when the connection
to the name service was lost and then reestablished. I.e. it
automatically detects the loss of the server and re-enters the data
when the server comes back.
.PP
The package \fBnameserv::common\fR is of no interest to users. It
is an internal package containing code and definitions common to the
packages \fBnameserv\fR and \fBnameserv::server\fR.
.PP
All packages use the \fBuevent\fR package for the reporting of
special circumstances via events, and reserve the uevent-tag
\fInameserv\fR for their exclusive use. All their events will be
posted to that tag.
.SH INTERNALS
The document \fIName service facility, client/server protocol\fR
specifies the protocol used by the packages \fBnameserv\fR and
\fBnameserv::server\fR to talk to each other. It is of no interest
to users of either the packages or applications.
.PP
Developers wishing to modify and/or extend or to just understand the
internals of the nameservice facility however are strongly advised to
read it.
.SH "BUGS, IDEAS, FEEDBACK"
This document, will undoubtedly contain bugs and other problems.
Please report such in the category \fInameserv\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
Please also report any ideas for enhancements you may have.
.SH "SEE ALSO"
nameserv(n), nameserv::auto(n), nameserv::common(n), nameserv::protocol(n), nameserv::server(n), nnsd(n), nss(n)
.SH KEYWORDS
client, name service, server
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi