'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/struct/graphops.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 Alejandro Paz <vidriloco@gmail.com>
'\" Copyright (c) 2008 (docs) Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\" Copyright (c) 2009 Michal Antoniewski <antoniewski.m@gmail.com>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::graph::op" n 0.11.3 struct "Tcl Data Structures"
.BS
.SH NAME
struct::graph::op \- Operation for (un)directed graph objects
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBstruct::graph::op  ?0.11.3?\fR
.sp
\fBstruct::graph:op::toAdjacencyMatrix\fR \fIg\fR
.sp
\fBstruct::graph:op::toAdjacencyList\fR \fIG\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::kruskal\fR \fIg\fR
.sp
\fBstruct::graph:op::prim\fR \fIg\fR
.sp
\fBstruct::graph:op::isBipartite?\fR \fIg\fR ?\fIbipartvar\fR?
.sp
\fBstruct::graph:op::tarjan\fR \fIg\fR
.sp
\fBstruct::graph:op::connectedComponents\fR \fIg\fR
.sp
\fBstruct::graph:op::connectedComponentOf\fR \fIg\fR \fIn\fR
.sp
\fBstruct::graph:op::isConnected?\fR \fIg\fR
.sp
\fBstruct::graph:op::isCutVertex?\fR \fIg\fR \fIn\fR
.sp
\fBstruct::graph:op::isBridge?\fR \fIg\fR \fIa\fR
.sp
\fBstruct::graph:op::isEulerian?\fR \fIg\fR ?\fItourvar\fR?
.sp
\fBstruct::graph:op::isSemiEulerian?\fR \fIg\fR ?\fIpathvar\fR?
.sp
\fBstruct::graph:op::dijkstra\fR \fIg\fR \fIstart\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::distance\fR \fIg\fR \fIorigin\fR \fIdestination\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::eccentricity\fR \fIg\fR \fIn\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::radius\fR \fIg\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph:op::diameter\fR \fIg\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph::op::BellmanFord\fR \fIG\fR \fIstartnode\fR
.sp
\fBstruct::graph::op::Johnsons\fR \fIG\fR ?\fIoptions\fR...?
.sp
\fBstruct::graph::op::FloydWarshall\fR \fIG\fR
.sp
\fBstruct::graph::op::MetricTravellingSalesman\fR \fIG\fR
.sp
\fBstruct::graph::op::Christofides\fR \fIG\fR
.sp
\fBstruct::graph::op::GreedyMaxMatching\fR \fIG\fR
.sp
\fBstruct::graph::op::MaxCut\fR \fIG\fR \fIU\fR \fIV\fR
.sp
\fBstruct::graph::op::UnweightedKCenter\fR \fIG\fR \fIk\fR
.sp
\fBstruct::graph::op::WeightedKCenter\fR \fIG\fR \fInodeWeights\fR \fIW\fR
.sp
\fBstruct::graph::op::GreedyMaxIndependentSet\fR \fIG\fR
.sp
\fBstruct::graph::op::GreedyWeightedMaxIndependentSet\fR \fIG\fR \fInodeWeights\fR
.sp
\fBstruct::graph::op::VerticesCover\fR \fIG\fR
.sp
\fBstruct::graph::op::EdmondsKarp\fR \fIG\fR \fIs\fR \fIt\fR
.sp
\fBstruct::graph::op::BusackerGowen\fR \fIG\fR \fIdesiredFlow\fR \fIs\fR \fIt\fR
.sp
\fBstruct::graph::op::ShortestsPathsByBFS\fR \fIG\fR \fIs\fR \fIoutputFormat\fR
.sp
\fBstruct::graph::op::BFS\fR \fIG\fR \fIs\fR ?\fIoutputFormat\fR...?
.sp
\fBstruct::graph::op::MinimumDiameterSpanningTree\fR \fIG\fR
.sp
\fBstruct::graph::op::MinimumDegreeSpanningTree\fR \fIG\fR
.sp
\fBstruct::graph::op::MaximumFlowByDinic\fR \fIG\fR \fIs\fR \fIt\fR \fIblockingFlowAlg\fR
.sp
\fBstruct::graph::op::BlockingFlowByDinic\fR \fIG\fR \fIs\fR \fIt\fR
.sp
\fBstruct::graph::op::BlockingFlowByMKM\fR \fIG\fR \fIs\fR \fIt\fR
.sp
\fBstruct::graph::op::createResidualGraph\fR \fIG\fR \fIf\fR
.sp
\fBstruct::graph::op::createAugmentingNetwork\fR \fIG\fR \fIf\fR \fIpath\fR
.sp
\fBstruct::graph::op::createLevelGraph\fR \fIGf\fR \fIs\fR
.sp
\fBstruct::graph::op::TSPLocalSearching\fR \fIG\fR \fIC\fR
.sp
\fBstruct::graph::op::TSPLocalSearching3Approx\fR \fIG\fR \fIC\fR
.sp
\fBstruct::graph::op::createSquaredGraph\fR \fIG\fR
.sp
\fBstruct::graph::op::createCompleteGraph\fR \fIG\fR \fIoriginalEdges\fR
.sp
.BE
.SH DESCRIPTION
.PP
The package described by this document, \fBstruct::graph::op\fR,
is a companion to the package \fBstruct::graph\fR. It provides a
series of common operations and algorithms applicable to (un)directed
graphs.
.PP
Despite being a companion the package is not directly dependent on
\fBstruct::graph\fR, only on the API defined by that
package. I.e. the operations of this package can be applied to any and
all graph objects which provide the same API as the objects created
through \fBstruct::graph\fR.
.SH OPERATIONS
.TP
\fBstruct::graph:op::toAdjacencyMatrix\fR \fIg\fR
This command takes the graph \fIg\fR and returns a nested list
containing the adjacency matrix of \fIg\fR.
.sp
The elements of the outer list are the rows of the matrix, the inner
elements are the column values in each row. The matrix has "\fBn\fR+1"
rows and columns, with the first row and column (index 0) containing
the name of the node the row/column is for. All other elements are
boolean values, \fBTrue\fR if there is an arc between the 2 nodes
of the respective row and column, and \fBFalse\fR otherwise.
.sp
Note that the matrix is symmetric. It does not represent the
directionality of arcs, only their presence between nodes. It is also
unable to represent parallel arcs in \fIg\fR.
.TP
\fBstruct::graph:op::toAdjacencyList\fR \fIG\fR ?\fIoptions\fR...?
Procedure creates for input graph \fIG\fR, it's representation as \fIAdjacency List\fR.
It handles both directed and undirected graphs (default is undirected).
It returns dictionary that for each node (key) returns list of nodes adjacent
to it. When considering weighted version, for each adjacent node there is also
weight of the edge included.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph object \fIG\fR (input)
A graph to convert into an \fIAdjacency List\fR.
.RE
.TP
Options:
.RS
.TP
\fB-directed\fR
By default \fIG\fR is operated as if it were an \fIUndirected graph\fR.
Using this option tells the command to handle \fIG\fR as the directed graph it is.
.TP
\fB-weights\fR
By default any weight information the graph \fIG\fR may have is ignored.
Using this option tells the command to put weight information into the result.
In that case it is expected that all arcs have a proper weight, and an error
is thrown if that is not the case.
.RE
.RE
.TP
\fBstruct::graph:op::kruskal\fR \fIg\fR
This command takes the graph \fIg\fR and returns a list containing the
names of the arcs in \fIg\fR which span up a minimum weight spanning tree
(MST), or, in the case of an un-connected graph, a minimum weight spanning
forest (except for the 1-vertex components). Kruskal's algorithm is used
to compute the tree or forest.
This algorithm has a time complexity of \fIO(E*log E)\fR or \fIO(E* log V)\fR,
where \fIV\fR is the number of vertices and \fIE\fR is the number of edges
in graph \fIg\fR.
.sp
The command will throw an error if one or more arcs in \fIg\fR have no
weight associated with them.
.sp
A note regarding the result, the command refrains from explicitly
listing the nodes of the MST as this information is implicitly
provided in the arcs already.
.TP
\fBstruct::graph:op::prim\fR \fIg\fR
This command takes the graph \fIg\fR and returns a list containing the
names of the arcs in \fIg\fR which span up a minimum weight spanning tree
(MST), or, in the case of an un-connected graph, a minimum weight spanning
forest (except for the 1-vertex components). Prim's algorithm is used to
compute the tree or forest.
This algorithm has a time complexity between \fIO(E+V*log V)\fR and \fIO(V*V)\fR,
depending on the implementation (Fibonacci heap + Adjacency list versus
Adjacency Matrix).  As usual \fIV\fR is the number of vertices and
\fIE\fR the number of edges in graph \fIg\fR.
.sp
The command will throw an error if one or more arcs in \fIg\fR have no
weight associated with them.
.sp
A note regarding the result, the command refrains from explicitly
listing the nodes of the MST as this information is implicitly
provided in the arcs already.
.TP
\fBstruct::graph:op::isBipartite?\fR \fIg\fR ?\fIbipartvar\fR?
This command takes the graph \fIg\fR and returns a boolean value
indicating whether it is bipartite (\fBtrue\fR) or not
(\fBfalse\fR). If the variable \fIbipartvar\fR is specified the two
partitions of the graph are there as a list, if, and only if the graph
is bipartit. If it is not the variable, if specified, is not touched.
.TP
\fBstruct::graph:op::tarjan\fR \fIg\fR
This command computes the set of \fIstrongly connected\fR
components (SCCs) of the graph \fIg\fR. The result of the command is a
list of sets, each of which contains the nodes for one of the SCCs of
\fIg\fR. The union of all SCCs covers the whole graph, and no two SCCs
intersect with each other.
.sp
The graph \fIg\fR is \fIacyclic\fR if all SCCs in the result contain
only a single node. The graph \fIg\fR is \fIstrongly connected\fR
if the result contains only a single SCC containing all nodes of
\fIg\fR.
.TP
\fBstruct::graph:op::connectedComponents\fR \fIg\fR
This command computes the set of \fIconnected\fR components (CCs) of
the graph \fIg\fR. The result of the command is a list of sets, each
of which contains the nodes for one of the CCs of \fIg\fR. The union
of all CCs covers the whole graph, and no two CCs intersect with each
other.
.sp
The graph \fIg\fR is \fIconnected\fR if the result contains only a
single SCC containing all nodes of \fIg\fR.
.TP
\fBstruct::graph:op::connectedComponentOf\fR \fIg\fR \fIn\fR
This command computes the \fIconnected\fR component (CC) of the graph
\fIg\fR containing the node \fIn\fR. The result of the command is a
sets which contains the nodes for the CC of \fIn\fR in \fIg\fR.
.sp
The command will throw an error if \fIn\fR is not a node of the graph
\fIg\fR.
.TP
\fBstruct::graph:op::isConnected?\fR \fIg\fR
This is a convenience command determining whether the graph \fIg\fR is
\fIconnected\fR or not.  The result is a boolean value, \fBtrue\fR
if the graph is connected, and \fBfalse\fR otherwise.
.TP
\fBstruct::graph:op::isCutVertex?\fR \fIg\fR \fIn\fR
This command determines whether the node \fIn\fR in the graph \fIg\fR
is a \fIcut vertex\fR (aka \fIarticulation point\fR). The result
is a boolean value, \fBtrue\fR if the node is a cut vertex, and
\fBfalse\fR otherwise.
.sp
The command will throw an error if \fIn\fR is not a node of the graph
\fIg\fR.
.TP
\fBstruct::graph:op::isBridge?\fR \fIg\fR \fIa\fR
This command determines whether the arc \fIa\fR in the graph \fIg\fR
is a \fIbridge\fR (aka \fIcut edge\fR, or \fIisthmus\fR). The
result is a boolean value, \fBtrue\fR if the arc is a bridge, and
\fBfalse\fR otherwise.
.sp
The command will throw an error if \fIa\fR is not an arc of the graph
\fIg\fR.
.TP
\fBstruct::graph:op::isEulerian?\fR \fIg\fR ?\fItourvar\fR?
This command determines whether the graph \fIg\fR is \fIeulerian\fR
or not.  The result is a boolean value, \fBtrue\fR if the graph is
eulerian, and \fBfalse\fR otherwise.
.sp
If the graph is eulerian and \fItourvar\fR is specified then an euler
tour is computed as well and stored in the named variable. The tour is
represented by the list of arcs traversed, in the order of traversal.
.TP
\fBstruct::graph:op::isSemiEulerian?\fR \fIg\fR ?\fIpathvar\fR?
This command determines whether the graph \fIg\fR is
\fIsemi-eulerian\fR or not.  The result is a boolean value, \fBtrue\fR
if the graph is semi-eulerian, and \fBfalse\fR otherwise.
.sp
If the graph is semi-eulerian and \fIpathvar\fR is specified then an
euler path is computed as well and stored in the named variable. The
path is represented by the list of arcs traversed, in the order of
traversal.
.TP
\fBstruct::graph:op::dijkstra\fR \fIg\fR \fIstart\fR ?\fIoptions\fR...?
This command determines distances in the weighted \fIg\fR from the
node \fIstart\fR to all other nodes in the graph. The options specify
how to traverse graphs, and the format of the result.
.sp
Two options are recognized
.RS
.TP
\fB-arcmode\fR mode
The accepted mode values are \fBdirected\fR and \fBundirected\fR.
For directed traversal all arcs are traversed from source to
target. For undirected traversal all arcs are traversed in the
opposite direction as well. Undirected traversal is the default.
.TP
\fB-outputformat\fR format
The accepted format values are \fBdistances\fR and \fBtree\fR. In
both cases the result is a dictionary keyed by the names of all nodes
in the graph. For \fBdistances\fR the value is the distance of the
node to \fIstart\fR, whereas for \fBtree\fR the value is the path
from the node to \fIstart\fR, excluding the node itself, but including
\fIstart\fR. Tree format is the default.
.RE
.TP
\fBstruct::graph:op::distance\fR \fIg\fR \fIorigin\fR \fIdestination\fR ?\fIoptions\fR...?
This command determines the (un)directed distance between the two
nodes \fIorigin\fR and \fIdestination\fR in the graph \fIg\fR. It
accepts the option \fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.TP
\fBstruct::graph:op::eccentricity\fR \fIg\fR \fIn\fR ?\fIoptions\fR...?
This command determines the (un)directed \fIeccentricity\fR of the
node \fIn\fR in the graph \fIg\fR. It accepts the option
\fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.sp
The (un)directed \fIeccentricity\fR of a node is the maximal
(un)directed distance between the node and any other node in the
graph.
.TP
\fBstruct::graph:op::radius\fR \fIg\fR ?\fIoptions\fR...?
This command determines the (un)directed \fIradius\fR of the graph
\fIg\fR. It accepts the option \fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.sp
The (un)directed \fIradius\fR of a graph is the minimal (un)directed
\fIeccentricity\fR of all nodes in the graph.
.TP
\fBstruct::graph:op::diameter\fR \fIg\fR ?\fIoptions\fR...?
This command determines the (un)directed \fIdiameter\fR of the graph
\fIg\fR. It accepts the option \fB-arcmode\fR of \fBstruct::graph:op::dijkstra\fR.
.sp
The (un)directed \fIdiameter\fR of a graph is the maximal (un)directed
\fIeccentricity\fR of all nodes in the graph.
.TP
\fBstruct::graph::op::BellmanFord\fR \fIG\fR \fIstartnode\fR
Searching for \fBshortests paths\fR between chosen node and all other nodes in graph \fIG\fR. Based
on relaxation method. In comparison to \fBstruct::graph::op::dijkstra\fR it doesn't need assumption that all weights
on edges in input graph \fIG\fR have to be positive.
.sp
That generality sets the complexity of algorithm to - \fIO(V*E)\fR, where \fIV\fR is the number of vertices
and \fIE\fR is number of edges in graph \fIG\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph object \fIG\fR (input)
Directed, connected and edge weighted graph \fIG\fR, without any negative cycles ( presence of cycles with the negative sum
of weight means that there is no shortest path, since the total weight becomes lower each time the cycle is
traversed ). Negative weights on edges are allowed.
.TP
Node \fIstartnode\fR (input)
The node for which we find all shortest paths to each other node in graph \fIG\fR.
.RE
.TP
Result:
Dictionary containing for each node (key) distances to each other node in graph \fIG\fR.
.RE
.sp
\fINote:\fR If algorithm finds a negative cycle, it will return error message.
.TP
\fBstruct::graph::op::Johnsons\fR \fIG\fR ?\fIoptions\fR...?
Searching for \fBshortest paths\fR between all pairs of vertices in graph. For sparse graphs
asymptotically quicker than \fBstruct::graph::op::FloydWarshall\fR algorithm. Johnson's algorithm
uses \fBstruct::graph::op::BellmanFord\fR and \fBstruct::graph::op::dijkstra\fR as subprocedures.
.sp
Time complexity: \fIO(n**2*log(n) +n*m)\fR, where \fIn\fR is the number of nodes and \fIm\fR is
the number of edges in graph \fIG\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph object \fIG\fR (input)
Directed graph \fIG\fR, weighted on edges and not containing
any cycles with negative sum of weights ( the presence of such cycles means
there is no shortest path, since the total weight becomes lower each time the
cycle is traversed ). Negative weights on edges are allowed.
.RE
.TP
Options:
.RS
.TP
\fB-filter\fR
Returns only existing distances, cuts all \fIInf\fR values for
non-existing connections between pairs of nodes.
.RE
.TP
Result:
Dictionary containing distances between all pairs of vertices.
.RE
.TP
\fBstruct::graph::op::FloydWarshall\fR \fIG\fR
Searching for \fBshortest paths\fR between all pairs of edges in weighted graphs.
.sp
Time complexity: \fIO(V^3)\fR - where \fIV\fR is number of vertices.
.sp
Memory complexity: \fIO(V^2)\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph object \fIG\fR (input)
Directed and weighted graph \fIG\fR.
.RE
.TP
Result:
Dictionary containing shortest distances to each node from each node.
.RE
\fINote:\fR Algorithm finds solutions dynamically. It compares all possible paths through the graph
between each pair of vertices. Graph shouldn't possess any cycle with negative
sum of weights (the presence of such cycles means there is no shortest path,
since the total weight becomes lower each time the cycle is traversed).
.sp
On the other hand algorithm can be used to find those cycles - if any shortest distance
found by algorithm for any nodes \fIv\fR and \fIu\fR (when \fIv\fR is the same node as \fIu\fR) is negative,
that node surely belong to at least one negative cycle.
.TP
\fBstruct::graph::op::MetricTravellingSalesman\fR \fIG\fR
Algorithm for solving a metric variation of \fBTravelling salesman problem\fR.
\fITSP problem\fR is \fINP-Complete\fR, so there is no efficient algorithm to solve it. Greedy methods
are getting extremely slow, with the increase in the set of nodes.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph object \fIG\fR (input)
Undirected, weighted graph \fIG\fR.
.RE
.TP
Result:
Approximated solution of minimum \fIHamilton Cycle\fR - closed path visiting all nodes,
each exactly one time.
.RE
\fINote:\fR \fBIt's 2-approximation algorithm.\fR
.TP
\fBstruct::graph::op::Christofides\fR \fIG\fR
Another algorithm for solving \fBmetric \fITSP problem\fR\fR.
Christofides implementation uses \fIMax Matching\fR for reaching better approximation factor.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected, weighted graph \fIG\fR.
.RE
.TP
Result:
Approximated solution of minimum \fIHamilton Cycle\fR - closed path visiting all nodes,
each exactly one time.
.RE
.sp
\fINote:\fR \fBIt's is a 3/2 approximation algorithm. \fR
.TP
\fBstruct::graph::op::GreedyMaxMatching\fR \fIG\fR
\fIGreedy Max Matching\fR procedure, which finds \fBmaximal matching\fR (not maximum)
for given graph \fIG\fR. It adds edges to solution, beginning from edges with the
lowest cost.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected graph \fIG\fR.
.RE
.TP
Result:
Set of edges - the max matching for graph \fIG\fR.
.RE
.TP
\fBstruct::graph::op::MaxCut\fR \fIG\fR \fIU\fR \fIV\fR
Algorithm solving a \fBMaximum Cut Problem\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
The graph to cut.
.TP
List \fIU\fR (output)
Variable storing first set of nodes (cut) given by solution.
.TP
List \fIV\fR (output)
Variable storing second set of nodes (cut) given by solution.
.RE
.TP
Result:
Algorithm returns number of edges between found two sets of nodes.
.RE
\fINote:\fR \fIMaxCut\fR is a \fB2-approximation algorithm.\fR
.TP
\fBstruct::graph::op::UnweightedKCenter\fR \fIG\fR \fIk\fR
Approximation algorithm that solves a \fBk-center problem\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected complete graph \fIG\fR, which satisfies triangle inequality.
.sp
.TP
Integer \fIk\fR (input)
Positive integer that sets the number of nodes that will be included in \fIk-center\fR.
.RE
.TP
Result:
Set of nodes - \fIk\fR center for graph \fIG\fR.
.RE
\fINote:\fR \fIUnweightedKCenter\fR is a \fB2-approximation algorithm.\fR
.TP
\fBstruct::graph::op::WeightedKCenter\fR \fIG\fR \fInodeWeights\fR \fIW\fR
Approximation algorithm that solves a weighted version of \fBk-center problem\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected complete graph \fIG\fR, which satisfies triangle inequality.
.TP
Integer \fIW\fR (input)
Positive integer that sets the maximum possible weight of \fIk-center\fR found by algorithm.
.TP
List \fInodeWeights\fR (input)
List of nodes and its weights in graph \fIG\fR.
.RE
.TP
Result:
Set of nodes, which is solution found by algorithm.
.RE
\fINote:\fR\fIWeightedKCenter\fR is a \fB3-approximation algorithm.\fR
.TP
\fBstruct::graph::op::GreedyMaxIndependentSet\fR \fIG\fR
A \fImaximal independent set\fR is an \fIindependent set\fR such that adding any other node
to the set forces the set to contain an edge.
.sp
Algorithm for input graph \fIG\fR returns set of nodes (list), which are contained in Max Independent
Set found by algorithm.
.TP
\fBstruct::graph::op::GreedyWeightedMaxIndependentSet\fR \fIG\fR \fInodeWeights\fR
Weighted variation of \fIMaximal Independent Set\fR. It takes as an input argument
not only graph \fIG\fR but also set of weights for all vertices in graph \fIG\fR.
.sp
\fINote:\fR
Read also \fIMaximal Independent Set\fR description for more info.
.TP
\fBstruct::graph::op::VerticesCover\fR \fIG\fR
\fIVertices cover\fR is a set of vertices such that each edge of the graph is incident to
at least one vertex of the set. This 2-approximation algorithm searches for minimum
\fIvertices cover\fR, which is a classical optimization problem in computer science and
is a typical example of an \fINP-hard\fR optimization problem that has an approximation
algorithm.
For input graph \fIG\fR algorithm returns the set of edges (list), which is Vertex Cover found by algorithm.
.TP
\fBstruct::graph::op::EdmondsKarp\fR \fIG\fR \fIs\fR \fIt\fR
Improved Ford-Fulkerson's algorithm, computing the \fBmaximum flow\fR in given flow network \fIG\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Weighted and directed graph. Each edge should have set integer attribute considered as
maximum throughputs that can be carried by that link (edge).
.TP
Node \fIs\fR (input)
The node that is a source for graph \fIG\fR.
.TP
Node \fIt\fR (input)
The node that is a sink for graph \fIG\fR.
.RE
.TP
Result:
Procedure returns the dictionary containing throughputs for all edges. For
each key ( the edge between nodes \fIu\fR and \fIv\fR in the form of \fIlist u v\fR ) there is
a value that is a throughput for that key. Edges where throughput values
are equal to 0 are not returned ( it is like there was no link in the flow network
between nodes connected by such edge).
.RE
.sp
The general idea of algorithm is finding the shortest augumenting paths in graph \fIG\fR, as long
as they exist, and for each path updating the edge's weights along that path,
with maximum possible throughput. The final (maximum) flow is found
when there is no other augumenting path from source to sink.
.sp
\fINote:\fR Algorithm complexity : \fIO(V*E)\fR, where \fIV\fR is the number of nodes and \fIE\fR is the number
of edges in graph \fIG\fR.
.TP
\fBstruct::graph::op::BusackerGowen\fR \fIG\fR \fIdesiredFlow\fR \fIs\fR \fIt\fR
Algorithm finds solution for a \fBminimum cost flow problem\fR. So, the goal is to find a flow,
whose max value can be \fIdesiredFlow\fR, from source node \fIs\fR to sink node \fIt\fR in given flow network \fIG\fR.
That network except throughputs at edges has also defined a non-negative cost on each edge - cost of using that edge when
directing flow with that edge ( it can illustrate e.g. fuel usage, time or any other measure dependent on usages ).
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Flow network (directed graph), each edge in graph should have two integer attributes: \fIcost\fR and \fIthroughput\fR.
.TP
Integer \fIdesiredFlow\fR (input)
Max value of the flow for that network.
.TP
Node \fIs\fR (input)
The source node for graph \fIG\fR.
.TP
Node \fIt\fR (input)
The sink node for graph \fIG\fR.
.RE
.TP
Result:
Dictionary containing values of used throughputs for each edge ( key ).
found by algorithm.
.RE
\fINote:\fR Algorithm complexity : \fIO(V**2*desiredFlow)\fR, where \fIV\fR is the number of nodes in graph \fIG\fR.
.TP
\fBstruct::graph::op::ShortestsPathsByBFS\fR \fIG\fR \fIs\fR \fIoutputFormat\fR
Shortest pathfinding algorithm using BFS method. In comparison to \fBstruct::graph::op::dijkstra\fR it can
work with negative weights on edges. Of course negative cycles are not allowed. Algorithm is better than dijkstra
for sparse graphs, but also there exist some pathological cases (those cases generally don't appear in practise) that
make time complexity increase exponentially with the growth of the number of nodes.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Input graph.
.TP
Node \fIs\fR (input)
Source node for which all distances to each other node in graph \fIG\fR are computed.
.RE
.TP
Options and result:
.RS
.TP
\fBdistances\fR
When selected \fIoutputFormat\fR is \fBdistances\fR - procedure returns dictionary containing
distances between source node \fIs\fR and each other node in graph \fIG\fR.
.TP
\fBpaths\fR
When selected \fIoutputFormat\fR is \fBpaths\fR - procedure returns dictionary containing
for each node \fIv\fR, a list of nodes, which is a path between source node \fIs\fR and node \fIv\fR.
.RE
.RE
.TP
\fBstruct::graph::op::BFS\fR \fIG\fR \fIs\fR ?\fIoutputFormat\fR...?
Breadth-First Search - algorithm creates the BFS Tree.
Memory and time complexity: \fIO(V + E)\fR, where \fIV\fR is the number of nodes and \fIE\fR
is number of edges.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Input graph.
.TP
Node \fIs\fR (input)
Source node for BFS procedure.
.RE
.TP
Options and result:
.RS
.TP
\fBgraph\fR
When selected \fBoutputFormat\fR is \fBgraph\fR - procedure returns a graph structure (\fBstruct::graph\fR),
which is equivalent to BFS tree found by algorithm.
.TP
\fBtree\fR
When selected \fBoutputFormat\fR is \fBtree\fR - procedure returns a tree structure (\fBstruct::tree\fR),
which is equivalent to BFS tree found by algorithm.
.RE
.RE
.TP
\fBstruct::graph::op::MinimumDiameterSpanningTree\fR \fIG\fR
The goal is to find for input graph \fIG\fR, the \fIspanning tree\fR that
has the minimum \fIdiameter\fR value.
.sp
General idea of algorithm is to run \fIBFS\fR over all vertices in graph
\fIG\fR. If the diameter \fId\fR of the tree is odd, then we are sure that tree
given by \fIBFS\fR is minimum (considering diameter value). When, diameter \fId\fR
is even, then optimal tree can have minimum \fIdiameter\fR equal to \fId\fR or
\fId-1\fR.
.sp
In that case, what algorithm does is rebuilding the tree given by \fIBFS\fR, by
adding a vertice between root node and root's child node (nodes), such that
subtree created with child node as root node is the greatest one (has the
greatests height). In the next step for such rebuilded tree, we run again \fIBFS\fR
with new node as root node. If the height of the tree didn't changed, we have found
a better solution.
.sp
For input graph \fIG\fR algorithm returns the graph structure (\fBstruct::graph\fR) that is
a spanning tree with minimum diameter found by algorithm.
.TP
\fBstruct::graph::op::MinimumDegreeSpanningTree\fR \fIG\fR
Algorithm finds for input graph \fIG\fR, a spanning tree \fIT\fR with the minimum possible
degree. That problem is \fINP-hard\fR, so algorithm is an approximation algorithm.
.sp
Let \fIV\fR be the set of nodes for graph \fIG\fR and let \fIW\fR be any subset of \fIV\fR. Lets
assume also that \fIOPT\fR is optimal solution and \fIALG\fR is solution found by algorithm for input
graph \fIG\fR.
.sp
It can be proven that solution found with the algorithm must fulfil inequality:
.sp
\fI((|W| + k - 1) / |W|) <= ALG <= 2*OPT + log2(n) + 1\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected simple graph.
.RE
.TP
Result:
Algorithm returns graph structure, which is equivalent to spanning tree \fIT\fR found by algorithm.
.RE
.TP
\fBstruct::graph::op::MaximumFlowByDinic\fR \fIG\fR \fIs\fR \fIt\fR \fIblockingFlowAlg\fR
Algorithm finds \fBmaximum flow\fR for the flow network represented by graph \fIG\fR. It is based on
the blocking-flow finding methods, which give us different complexities what makes a better fit for
different graphs.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Directed graph \fIG\fR representing the flow network. Each edge should have attribute
\fIthroughput\fR set with integer value.
.TP
Node \fIs\fR (input)
The source node for the flow network \fIG\fR.
.TP
Node \fIt\fR (input)
The sink node for the flow network \fIG\fR.
.RE
.TP
Options:
.RS
.TP
\fBdinic\fR
Procedure will find maximum flow for flow network \fIG\fR using Dinic's algorithm (\fBstruct::graph::op::BlockingFlowByDinic\fR)
for blocking flow computation.
.TP
\fBmkm\fR
Procedure will find maximum flow for flow network \fIG\fR using Malhotra, Kumar and Maheshwari's algorithm (\fBstruct::graph::op::BlockingFlowByMKM\fR)
for blocking flow computation.
.RE
.TP
Result:
Algorithm returns dictionary containing it's flow value for each edge (key) in network \fIG\fR.
.RE
.sp
\fINote:\fR \fBstruct::graph::op::BlockingFlowByDinic\fR gives \fIO(m*n^2)\fR complexity and
\fBstruct::graph::op::BlockingFlowByMKM\fR gives \fIO(n^3)\fR complexity, where \fIn\fR is the number of nodes
and \fIm\fR is the number of edges in flow network \fIG\fR.
.TP
\fBstruct::graph::op::BlockingFlowByDinic\fR \fIG\fR \fIs\fR \fIt\fR
Algorithm for given network \fIG\fR with source \fIs\fR and sink \fIt\fR, finds a \fBblocking
flow\fR, which can be used to obtain a \fImaximum flow\fR for that network \fIG\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Directed graph \fIG\fR representing the flow network. Each edge should have attribute
\fIthroughput\fR set with integer value.
.TP
Node \fIs\fR (input)
The source node for the flow network \fIG\fR.
.TP
Node \fIt\fR (input)
The sink node for the flow network \fIG\fR.
.RE
.TP
Result:
Algorithm returns dictionary containing it's blocking flow value for each edge (key) in network \fIG\fR.
.RE
\fINote:\fR Algorithm's complexity is \fIO(n*m)\fR, where \fIn\fR is the number of nodes
and \fIm\fR is the number of edges in flow network \fIG\fR.
.TP
\fBstruct::graph::op::BlockingFlowByMKM\fR \fIG\fR \fIs\fR \fIt\fR
Algorithm for given network \fIG\fR with source \fIs\fR and sink \fIt\fR, finds a \fBblocking
flow\fR, which can be used to obtain a \fImaximum flow\fR for that \fInetwork\fR \fIG\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Directed graph \fIG\fR representing the flow network. Each edge should have attribute
\fIthroughput\fR set with integer value.
.TP
Node \fIs\fR (input)
The source node for the flow network \fIG\fR.
.TP
Node \fIt\fR (input)
The sink node for the flow network \fIG\fR.
.RE
.TP
Result:
Algorithm returns dictionary containing it's blocking flow value for each edge (key) in network \fIG\fR.
.RE
\fINote:\fR Algorithm's complexity is \fIO(n^2)\fR, where \fIn\fR is the number of nodes in flow network \fIG\fR.
.TP
\fBstruct::graph::op::createResidualGraph\fR \fIG\fR \fIf\fR
Procedure creates a \fIresidual graph\fR (or \fBresidual network\fR ) for network \fIG\fR and given
flow \fIf\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Flow network (directed graph where each edge has set attribute: \fIthroughput\fR ).
.TP
dictionary \fIf\fR (input)
Current flows in flow network \fIG\fR.
.RE
.TP
Result:
Procedure returns graph structure that is a \fIresidual graph\fR created from input flow
network \fIG\fR.
.RE
.TP
\fBstruct::graph::op::createAugmentingNetwork\fR \fIG\fR \fIf\fR \fIpath\fR
Procedure creates an \fBaugmenting network\fR for a given residual network \fIG\fR
, flow \fIf\fR and augmenting path \fIpath\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Residual network (directed graph), where for every edge there are set two attributes: throughput and cost.
.TP
Dictionary \fIf\fR (input)
Dictionary which contains for every edge (key), current value of the flow on that edge.
.TP
List \fIpath\fR (input)
Augmenting path, set of edges (list) for which we create the network modification.
.RE
.TP
Result:
Algorithm returns graph structure containing the modified augmenting network.
.RE
.TP
\fBstruct::graph::op::createLevelGraph\fR \fIGf\fR \fIs\fR
For given residual graph \fIGf\fR procedure finds the \fBlevel graph\fR.
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIGf\fR (input)
Residual network, where each edge has it's attribute \fIthroughput\fR set with certain value.
.TP
Node \fIs\fR (input)
The source node for the residual network \fIGf\fR.
.RE
.TP
Result:
Procedure returns a \fIlevel graph\fR created from input \fIresidual network\fR.
.RE
.TP
\fBstruct::graph::op::TSPLocalSearching\fR \fIG\fR \fIC\fR
Algorithm is a \fIheuristic of local searching\fR for \fITravelling Salesman Problem\fR. For some
solution of \fITSP problem\fR, it checks if it's possible to find a better solution. As \fITSP\fR
is well known NP-Complete problem, so algorithm is a approximation algorithm (with 2 approximation factor).
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected and complete graph with attributes "weight" set on each single edge.
.TP
List \fIC\fR (input)
A list of edges being \fIHamiltonian cycle\fR, which is solution of \fITSP Problem\fR for graph \fIG\fR.
.RE
.TP
Result:
Algorithm returns the best solution for \fITSP problem\fR, it was able to find.
.RE
\fINote:\fR The solution depends on the choosing of the beginning cycle \fIC\fR. It's not true that better cycle
assures that better solution will be found, but practise shows that we should give starting cycle with as small
sum of weights as possible.
.TP
\fBstruct::graph::op::TSPLocalSearching3Approx\fR \fIG\fR \fIC\fR
Algorithm is a \fIheuristic of local searching\fR for \fITravelling Salesman Problem\fR. For some
solution of \fITSP problem\fR, it checks if it's possible to find a better solution. As \fITSP\fR
is well known NP-Complete problem, so algorithm is a approximation algorithm (with 3 approximation factor).
.sp
.RS
.TP
Arguments:
.RS
.TP
Graph Object \fIG\fR (input)
Undirected and complete graph with attributes "weight" set on each single edge.
.TP
List \fIC\fR (input)
A list of edges being \fIHamiltonian cycle\fR, which is solution of \fITSP Problem\fR for graph \fIG\fR.
.RE
.TP
Result:
Algorithm returns the best solution for \fITSP problem\fR, it was able to find.
.RE
\fINote:\fR In practise 3-approximation algorithm turns out to be far more effective than 2-approximation, but it gives
worser approximation factor. Further heuristics of local searching (e.g. 4-approximation) doesn't give enough boost to
square the increase of approximation factor, so 2 and 3 approximations are mainly used.
.TP
\fBstruct::graph::op::createSquaredGraph\fR \fIG\fR
X-Squared graph is a graph with the same set of nodes as input graph \fIG\fR, but a different set of edges. X-Squared graph
has edge \fI(u,v)\fR, if and only if, the distance between \fIu\fR and \fIv\fR nodes is not greater than X and \fIu != v\fR.
.sp
Procedure for input graph \fIG\fR, returns its two-squared graph.
.sp
\fINote:\fR Distances used in choosing new set of edges are considering the number of edges, not the sum of weights at edges.
.TP
\fBstruct::graph::op::createCompleteGraph\fR \fIG\fR \fIoriginalEdges\fR
For input graph \fIG\fR procedure adds missing arcs to make it a \fIcomplete graph\fR. It also holds in
variable \fIoriginalEdges\fR the set of arcs that graph \fIG\fR possessed before that operation.
.PP
.SH "BACKGROUND THEORY AND TERMS"
.SS "SHORTEST PATH PROBLEM"
.TP
Definition (\fIsingle-pair shortest path problem\fR):
Formally, given a weighted graph (let \fIV\fR be the set of vertices, and \fIE\fR a set of edges),
and one vertice \fIv\fR of \fIV\fR, find a path \fIP\fR from \fIv\fR to a \fIv'\fR of V so that
the sum of weights on edges along the path is minimal among all paths connecting v to v'.
.TP
Generalizations:
.RS
.IP \(bu
\fIThe single-source shortest path problem\fR, in which we have to find shortest paths from a source vertex v to all other vertices in the graph.
.IP \(bu
\fIThe single-destination shortest path problem\fR, in which we have to find shortest paths from all vertices in the graph to a single destination vertex v. This can be reduced to the single-source shortest path problem by reversing the edges in the graph.
.IP \(bu
\fIThe all-pairs shortest path problem\fR, in which we have to find shortest paths between every pair of vertices v, v' in the graph.
.RE
\fINote:\fR
The result of \fIShortest Path problem\fR can be \fIShortest Path tree\fR, which is a subgraph of a given (possibly weighted) graph constructed so that the
distance between a selected root node and all other nodes is minimal. It is a tree because if there are two paths between the root node and some
vertex v (i.e. a cycle), we can delete the last edge of the longer path without increasing the distance from the root node to any node in the subgraph.
.PP
.SS "TRAVELLING SALESMAN PROBLEM"
.TP
Definition:
For given edge-weighted (weights on edges should be positive) graph the goal is to find the cycle that visits each node in graph
exactly once (\fIHamiltonian cycle\fR).
.TP
Generalizations:
.RS
.IP \(bu
\fIMetric TSP\fR - A very natural restriction of the \fITSP\fR is to require that the distances between cities form a \fImetric\fR, i.e.,
they satisfy \fIthe triangle inequality\fR. That is, for any 3 cities \fIA\fR, \fIB\fR and \fIC\fR, the distance between \fIA\fR and \fIC\fR
must be at most the distance from \fIA\fR to \fIB\fR plus the distance from \fIB\fR to \fIC\fR. Most natural instances of \fITSP\fR
satisfy this constraint.
.IP \(bu
\fIEuclidean TSP\fR - Euclidean TSP, or \fIplanar TSP\fR, is the \fITSP\fR with the distance being the ordinary \fIEuclidean distance\fR.
\fIEuclidean TSP\fR is a particular case of \fITSP\fR with \fItriangle inequality\fR, since distances in plane obey triangle inequality. However,
it seems to be easier than general \fITSP\fR with \fItriangle inequality\fR. For example, \fIthe minimum spanning tree\fR of the graph associated
with an instance of \fIEuclidean TSP\fR is a \fIEuclidean minimum spanning tree\fR, and so can be computed in expected \fIO(n log n)\fR time for
\fIn\fR points (considerably less than the number of edges). This enables the simple \fI2-approximation algorithm\fR for TSP with triangle
inequality above to operate more quickly.
.IP \(bu
\fIAsymmetric TSP\fR - In most cases, the distance between two nodes in the \fITSP\fR network is the same in both directions.
The case where the distance from \fIA\fR to \fIB\fR is not equal to the distance from \fIB\fR to \fIA\fR is called \fIasymmetric TSP\fR.
A practical application of an \fIasymmetric TSP\fR is route optimisation using street-level routing (asymmetric due to one-way streets,
slip-roads and motorways).
.RE
.PP
.SS "MATCHING PROBLEM"
.TP
Definition:
Given a graph \fIG = (V,E)\fR, a matching or \fIedge-independent set\fR \fIM\fR in \fIG\fR is a set of pairwise non-adjacent edges,
that is, no two edges share a common vertex. A vertex is \fImatched\fR if it is incident to an edge in the \fImatching M\fR.
Otherwise the vertex is \fIunmatched\fR.
.TP
Generalizations:
.RS
.IP \(bu
\fIMaximal matching\fR - a matching \fIM\fR of a graph G with the property that if any edge not in \fIM\fR is added to \fIM\fR,
it is no longer a \fImatching\fR, that is, \fIM\fR is maximal if it is not a proper subset of any other \fImatching\fR in graph G.
In other words, a \fImatching M\fR of a graph G is maximal if every edge in G has a non-empty intersection with at least one edge in \fIM\fR.
.IP \(bu
\fIMaximum matching\fR - a matching that contains the largest possible number of edges. There may be many \fImaximum matchings\fR.
The \fImatching number\fR of a graph G is the size of a \fImaximum matching\fR. Note that every \fImaximum matching\fR is \fImaximal\fR,
but not every \fImaximal matching\fR is a \fImaximum matching\fR.
.IP \(bu
\fIPerfect matching\fR - a matching which matches all vertices of the graph. That is, every vertex of the graph is incident to exactly one
edge of the matching. Every \fIperfect matching\fR is \fImaximum\fR and hence \fImaximal\fR. In some literature, the term \fIcomplete matching\fR
is used. A \fIperfect matching\fR is also a \fIminimum-size edge cover\fR. Moreover, the size of a \fImaximum matching\fR is no larger than the
size of a \fIminimum edge cover\fR.
.IP \(bu
\fINear-perfect matching\fR - a matching in which exactly one vertex is unmatched. This can only occur when the graph has an odd number of vertices,
and such a \fImatching\fR must be \fImaximum\fR. If, for every vertex in a graph, there is a near-perfect matching that omits only that vertex, the graph
is also called \fIfactor-critical\fR.
.RE
.TP
Related terms:
.RS
.IP \(bu
\fIAlternating path\fR - given a matching \fIM\fR, an \fIalternating path\fR is a path in which the edges belong alternatively
to the matching and not to the matching.
.IP \(bu
\fIAugmenting path\fR - given a matching \fIM\fR, an \fIaugmenting path\fR is an \fIalternating path\fR that starts from
and ends on free (unmatched) vertices.
.RE
.PP
.SS "CUT PROBLEMS"
.TP
Definition:
A \fIcut\fR is a partition of the vertices of a graph into two \fIdisjoint subsets\fR. The \fIcut-set\fR of the \fIcut\fR is the
set of edges whose end points are in different subsets of the partition. Edges are said to be crossing the cut if they are in its \fIcut-set\fR.
.sp
Formally:
.RS
.IP \(bu
a \fIcut\fR \fIC = (S,T)\fR is a partition of \fIV\fR of a graph \fIG = (V, E)\fR.
.IP \(bu
an \fIs-t cut\fR \fIC = (S,T)\fR of a \fIflow network\fR \fIN = (V, E)\fR is a cut of \fIN\fR such that \fIs\fR is included in \fIS\fR
and \fIt\fR is included in \fIT\fR, where \fIs\fR and \fIt\fR are the \fIsource\fR and the \fIsink\fR of \fIN\fR respectively.
.IP \(bu
The \fIcut-set\fR of a \fIcut C = (S,T)\fR is such set of edges from graph \fIG = (V, E)\fR that each edge \fI(u, v)\fR satisfies
condition that \fIu\fR is included in \fIS\fR and \fIv\fR is included in \fIT\fR.
.RE
.sp
In an \fIunweighted undirected\fR graph, the size or weight of a cut is the number of edges crossing the cut. In a \fIweighted graph\fR,
the same term is defined by the sum of the weights of the edges crossing the cut.
.sp
In a \fIflow network\fR, an \fIs-t cut\fR is a cut that requires the \fIsource\fR and the \fIsink\fR to be in different subsets,
and its \fIcut-set\fR only consists of edges going from the \fIsource's\fR side to the \fIsink's\fR side. The capacity of an \fIs-t cut\fR
is defined by the sum of capacity of each edge in the \fIcut-set\fR.
.sp
The \fIcut\fR of a graph can sometimes refer to its \fIcut-set\fR instead of the partition.
.TP
Generalizations:
.RS
.IP \(bu
\fIMinimum cut\fR - A cut is minimum if the size of the cut is not larger than the size of any other cut.
.IP \(bu
\fIMaximum cut\fR - A cut is maximum if the size of the cut is not smaller than the size of any other cut.
.IP \(bu
\fISparsest cut\fR - The \fISparsest cut problem\fR is to bipartition the vertices so as to minimize the ratio of the number
of edges across the cut divided by the number of vertices in the smaller half of the partition.
.RE
.PP
.SS "K-CENTER PROBLEM"
.TP
Definitions:
.RS
.TP
\fIUnweighted K-Center\fR
For any set \fIS\fR ( which is subset of \fIV\fR ) and node \fIv\fR, let the \fIconnect(v,S)\fR be the
cost of cheapest edge connecting \fIv\fR with any node in \fIS\fR. The goal is to find
such \fIS\fR, that \fI|S| = k\fR and \fImax_v{connect(v,S)}\fR is possibly small.
.sp
In other words, we can use it i.e. for finding best locations in the city ( nodes
of input graph ) for placing k buildings, such that those buildings will be as close
as possible to all other locations in town.
.sp
.TP
\fIWeighted K-Center\fR
The variation of \fIunweighted k-center problem\fR. Besides the fact graph is edge-weighted,
there are also weights on vertices of input graph \fIG\fR. We've got also restriction
\fIW\fR. The goal is to choose such set of nodes \fIS\fR ( which is a subset of \fIV\fR ), that it's
total weight is not greater than \fIW\fR and also function: \fImax_v { min_u { cost(u,v) }}\fR
has the smallest possible worth ( \fIv\fR is a node in \fIV\fR and \fIu\fR is a node in \fIS\fR ).
.RE
.PP
.SS "FLOW PROBLEMS"
.TP
Definitions:
.RS
.IP \(bu
\fIthe maximum flow problem\fR - the goal is to find a feasible flow through a single-source, single-sink flow network that is maximum.
The \fImaximum flow problem\fR can be seen as a special case of more complex network flow problems, such as the \fIcirculation problem\fR.
The maximum value of an \fIs-t flow\fR is equal to the minimum capacity of an \fIs-t cut\fR in the network, as stated in the
\fImax-flow min-cut theorem\fR.
.sp
More formally for flow network \fIG = (V,E)\fR, where for each edge \fI(u, v)\fR we have its throuhgput \fIc(u,v)\fR defined. As \fIflow\fR
\fIF\fR we define set of non-negative integer attributes \fIf(u,v)\fR assigned to edges, satisfying such conditions:
.RS
.IP [1]
for each edge \fI(u, v)\fR in \fIG\fR such condition should be satisfied:      0 <= f(u,v) <= c(u,v)
.IP [2]
Network \fIG\fR has source node \fIs\fR such that the flow \fIF\fR is equal to the sum of outcoming flow decreased by the sum of incoming flow from that source node \fIs\fR.
.IP [3]
Network \fIG\fR has sink node \fIt\fR such that the the \fI-F\fR value is equal to the sum of the incoming flow decreased by the sum of outcoming flow from that sink node \fIt\fR.
.IP [4]
For each node that is not a \fIsource\fR or \fIsink\fR the sum of incoming flow and sum of outcoming flow should be equal.
.RE
.IP \(bu
\fIthe minimum cost flow problem\fR - the goal is finding the cheapest possible way of sending a certain amount of flow through a \fIflow network\fR.
.IP \(bu
\fIblocking flow\fR - a \fIblocking flow\fR for a \fIresidual network\fR \fIGf\fR we name such flow \fIb\fR in \fIGf\fR that:
.RS
.IP [1]
Each path from \fIsink\fR to \fIsource\fR is the shortest path in \fIGf\fR.
.IP [2]
Each shortest path in \fIGf\fR contains an edge with fully used throughput in \fIGf+b\fR.
.RE
.IP \(bu
\fIresidual network\fR - for a flow network \fIG\fR and flow \fIf\fR \fIresidual network\fR is built with those edges, which can
send larger flow. It contains only those edges, which can send flow larger than 0.
.IP \(bu
\fIlevel network\fR - it has the same set of nodes as \fIresidual graph\fR, but has only those edges \fI(u,v)\fR from \fIGf\fR
for which such equality is satisfied: \fIdistance(s,u)+1 = distance(s,v)\fR.
.IP \(bu
\fIaugmenting network\fR - it is a modification of \fIresidual network\fR considering the new
flow values. Structure stays unchanged but values of throughputs and costs at edges
are different.
.RE
.PP
.SS "APPROXIMATION ALGORITHM"
.TP
k-approximation algorithm:
Algorithm is a k-approximation, when for \fIALG\fR (solution returned by algorithm) and
\fIOPT\fR (optimal solution), such inequality is true:
.RS
.IP \(bu
for minimalization problems: \fIALG/OPT <= k\fR
.IP \(bu
for maximalization problems: \fIOPT/ALG <= k\fR
.RE
.PP
.SH REFERENCES
.IP [1]
\fIAdjacency matrix\fR [http://en.wikipedia.org/wiki/Adjacency_matrix]
.IP [2]
\fIAdjacency list\fR [http://en.wikipedia.org/wiki/Adjacency_list]
.IP [3]
\fIKruskal's algorithm\fR [http://en.wikipedia.org/wiki/Kruskal%27s_algorithm]
.IP [4]
\fIPrim's algorithm\fR [http://en.wikipedia.org/wiki/Prim%27s_algorithm]
.IP [5]
\fIBipartite graph\fR [http://en.wikipedia.org/wiki/Bipartite_graph]
.IP [6]
\fIStrongly connected components\fR [http://en.wikipedia.org/wiki/Strongly_connected_components]
.IP [7]
\fITarjan's strongly connected components algorithm\fR [http://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm]
.IP [8]
\fICut vertex\fR [http://en.wikipedia.org/wiki/Cut_vertex]
.IP [9]
\fIBridge\fR [http://en.wikipedia.org/wiki/Bridge_(graph_theory)]
.IP [10]
\fIBellman-Ford's algorithm\fR [http://en.wikipedia.org/wiki/Bellman-Ford_algorithm]
.IP [11]
\fIJohnson's algorithm\fR [http://en.wikipedia.org/wiki/Johnson_algorithm]
.IP [12]
\fIFloyd-Warshall's algorithm\fR [http://en.wikipedia.org/wiki/Floyd-Warshall_algorithm]
.IP [13]
\fITravelling Salesman Problem\fR [http://en.wikipedia.org/wiki/Travelling_salesman_problem]
.IP [14]
\fIChristofides Algorithm\fR [http://en.wikipedia.org/wiki/Christofides_algorithm]
.IP [15]
\fIMax Cut\fR [http://en.wikipedia.org/wiki/Maxcut]
.IP [16]
\fIMatching\fR [http://en.wikipedia.org/wiki/Matching]
.IP [17]
\fIMax Independent Set\fR [http://en.wikipedia.org/wiki/Maximal_independent_set]
.IP [18]
\fIVertex Cover\fR [http://en.wikipedia.org/wiki/Vertex_cover_problem]
.IP [19]
\fIFord-Fulkerson's algorithm\fR [http://en.wikipedia.org/wiki/Ford-Fulkerson_algorithm]
.IP [20]
\fIMaximum Flow problem\fR [http://en.wikipedia.org/wiki/Maximum_flow_problem]
.IP [21]
\fIBusacker-Gowen's algorithm\fR [http://en.wikipedia.org/wiki/Minimum_cost_flow_problem]
.IP [22]
\fIDinic's algorithm\fR [http://en.wikipedia.org/wiki/Dinic's_algorithm]
.IP [23]
\fIK-Center problem\fR [http://www.csc.kth.se/~viggo/wwwcompendium/node128.html]
.IP [24]
\fIBFS\fR [http://en.wikipedia.org/wiki/Breadth-first_search]
.IP [25]
\fIMinimum Degree Spanning Tree\fR [http://en.wikipedia.org/wiki/Degree-constrained_spanning_tree]
.IP [26]
\fIApproximation algorithm\fR [http://en.wikipedia.org/wiki/Approximation_algorithm]
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: graph\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
adjacency list, adjacency matrix, adjacent, approximation algorithm, arc, articulation point, augmenting network, augmenting path, bfs, bipartite, blocking flow, bridge, complete graph, connected component, cut edge, cut vertex, degree, degree constrained spanning tree, diameter, dijkstra, distance, eccentricity, edge, flow network, graph, heuristic, independent set, isthmus, level graph, local searching, loop, matching, max cut, maximum flow, minimal spanning tree, minimum cost flow, minimum degree spanning tree, minimum diameter spanning tree, neighbour, node, radius, residual graph, shortest path, squared graph, strongly connected component, subgraph, travelling salesman, vertex, vertex cover
.SH CATEGORY
Data structures
.SH COPYRIGHT
.nf
Copyright (c) 2008 Alejandro Paz <vidriloco@gmail.com>
Copyright (c) 2008 (docs) Andreas Kupries <andreas_kupries@users.sourceforge.net>
Copyright (c) 2009 Michal Antoniewski <antoniewski.m@gmail.com>

.fi