'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tklib/tklib/modules/controlwidget/controlwidget.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2010 Ron Fox <rfox@...>
'\" Copyright (c) 2010 Gerhard Reithofer <...@...>
'\" Copyright (c) 2010 Marco Maggi <...@...>
'\" Copyright (c) 2010 Arjen Markus <arjenmarkus@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "controlwidget" n 0.1 controlwidget "controlwidget"
.BS
.SH NAME
controlwidget \- Collection of widgets for displaying and controlling numerical values
.SH SYNOPSIS
package require \fBTcl  ?8.5?\fR
.sp
package require \fBTk  ?8.5?\fR
.sp
package require \fBsnit  ?2.0?\fR
.sp
package require \fBcontrolwidget  ?0.1?\fR
.sp
\fB::controlwidget::meter\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::slider\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::equalizerBar\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::thermometer\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::voltmeter\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::tachometer\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::rdial\fR \fIw\fR \fIargs\fR
.sp
\fB$widget\fR get
.sp
\fB$widget\fR set \fIvalue\fR
.sp
\fB::controlwidget::led\fR \fIw\fR \fIargs\fR
.sp
\fB::controlwidget::radioMatrix\fR \fIw\fR \fIargs\fR
.sp
\fB$led\fR on
.sp
\fB$led\fR off
.sp
\fB$led\fR setstate \fIstate\fR
.sp
\fB$matrix\fR get
.sp
\fB$matrix\fR set \fIindex\fR
.sp
.BE
.SH DESCRIPTION
.PP
The controlwidget package focuses on the display and interactive control of numerical values.
It mimicks several of the meters and controls found in laboratory settings but also
daily life: volt meters, equalizers and tachometers to name a few. They can be seen as alternatives
for the \fIscale widget\fR.
.PP
\fINote:\fR The package has not sofar been tested extensively, and that may result in
an unexpected appearance if you use sizes that are different than the defaults. Also
not all options for the coloring of the various parts and fonts and so on have been tested, so that
may be another source of bugs.
.PP
A last note: some parts have not been included in any option, most notably the colors of
parts that require lighter and darker shades to cooperate.
.SH "TYPES OF WIDGETS"
The package distinguishes several typed of widgets:
.IP \(bu
Vertical meters: the value of the variable is translated into a vertical position, like with
the coloured bars you find on your stereo installation.
.IP \(bu
Angle displays: the value of the variable is related to the angle of a needle, like with tachometers.
.IP \(bu
Interactive widgets: most widgets allow you to change the value of the variable by pressing the mouse button
on the needle and shifting it up and down or left and right.
.IP \(bu
Non-interactive widgets: some widgets, like the thermometer widget, do not allow such interaction.
.IP \(bu
Logical or choice widgets: some widgets display the values as either on/off (or true/false) or as
one of a set of discrete choices.
.PP
All widgets have in common, however, that you can connect them to a variable and that changing the variable
changes the display. Forthermore, all widgets have the set and get methods to interact with the value that
the widget displays (whether that is stored in a global variable or not).
.PP
They also have in common that their appearance and behaviour is determined by one or more options that
you can set at creation time and often later on as well. The widgets are all based on the \fIsnit\fR
package, so that the methods \fBconfigure\fR and \fBcget\fR are available to set and get these options.
.SH COMMANDS
Currently the package contains these widgets of the \fIvertical meter\fR type:
.TP
\fB::controlwidget::meter\fR \fIw\fR \fIargs\fR
Create a vertical meter consisting of an axis and a moveable arrow.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget:
.RS
.TP
\fBvariable\fR name
Name of the variable to be associated with the meter
.TP
\fBbackground\fR color
Background color for the widget
.TP
\fBheight\fR pixels
Height of the widget
.TP
\fBwidth\fR pixels
Width of the widget
.TP
\fBarrowthickness\fR pixels
Thickness of the displayed arrow in pixels
.TP
\fBarrowcolor\fR color
Color of the displayed arrow
.TP
\fBreadonly\fR boolean
Whether the arrow can be moved interactively or not
.RE
.RE
.TP
\fB::controlwidget::slider\fR \fIw\fR \fIargs\fR
Create a widget containing one or more vertical sliders and an axis. You can shift the slider handles
interactively via the mouse.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget:
.RS
.TP
\fBvariable\fR name
Name of the (list) variable to be associated with the widget
.TP
\fBnumber\fR integer
Number of sliders in the widget
.TP
\fBbackground\fR color
Background color for the widget
.TP
\fBheight\fR pixels
Height of the widget
.TP
\fBwidth\fR pixels
Width of the widget
.TP
\fBsliderthickness\fR pixels
Thickness of the slider handles
.TP
\fBsliderwidth\fR color
Width of the slider handles
.TP
\fBtroughwidth\fR color
Width of the troughs holding the sliders
.RE
.RE
.TP
\fB::controlwidget::equalizerBar\fR \fIw\fR \fIargs\fR
Create a widget containing one or more vertical bars resembling those found on hifi graphical equalizers.
Note that it is a read-only widget.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget:
.RS
.TP
\fBvariable\fR name
Name of the (list) variable to be associated with the widget
.TP
\fBnumber\fR integer
Number of bars in the widget
.TP
\fBbackground\fR color
Background color for the widget
.TP
\fBheight\fR pixels
Height of the widget
.TP
\fBwidth\fR pixels
Width of the widget
.TP
\fBbarwidth\fR pixels
Width of the bars
.TP
\fBsegments\fR integer
Number of segments the bars are divided in
.TP
\fBsafecolor\fR color
Color for values lower than the warning level
.TP
\fBwarningcolor\fR color
Color for values greater than the warning level
.TP
\fBwarninglevel\fR double
Threshold value, determines at what level the color changes
.RE
.RE
.TP
\fB::controlwidget::thermometer\fR \fIw\fR \fIargs\fR
Create a thermometer widget (read-only)
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget:
.RS
.TP
\fBvariable\fR name
Name of the (list) variable to be associated with the widget
.TP
\fBbackground\fR color
Background color for the widget
.TP
\fBheight\fR pixels
Height of the widget
.TP
\fBwidth\fR pixels
Width of the widget
.TP
\fBlinethickness\fR pixels
Thickness of the line representing the "temperature"
.TP
\fBlinecolor\fR color
Color of the line
.RE
.RE
.PP
These widgets all use a vertical axis and have the following options in common for configuring the
axis:
.TP
\fBaxisformat\fR string
Format string for formatting the numbers along the axis
.TP
\fBaxisfont\fR string
Name of the font to be used for the numbers
.TP
\fBaxiscolor\fR color
Color of the axis (including the numbers)
.TP
\fBfrom\fR color
Lower value for the axis
.TP
\fBto\fR color
Upper value for the axis
.TP
\fBmajorticks\fR integer
Number of major tickmarks to draw (each is labelled)
.TP
\fBminorticks\fR integer
Number of minor tickmarks to draw between two major tickmarks
.TP
\fBlog\fR boolean
Use a logarithmic axis (true) or a linear axis (false)
.PP
The package contains the following widget based on angle displays:
.TP
\fB::controlwidget::voltmeter\fR \fIw\fR \fIargs\fR
Create a voltmeter-like widget.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget:
.RS
.TP
\fBvariable\fR name
Name of the variable to be associated with the meter
.TP
\fBvalue\fR value
Value for the meter (if not associated with a variable)
.TP
\fBmin\fR value
The minimum value for data in the display
.TP
\fBmax\fR value
The maximum value for data in the display
.TP
\fBlabels\fR list
The labels to be shown along the scale. (These are simply considered texts, so no
relation with the minimum and maximum perse)
.TP
\fBtitle\fR string
String to be shown below the dial
.TP
\fBwidth\fR pixels
The width of the widget
.TP
\fBheight\fR pixels
The height of the widget
.TP
\fBborderwidth\fR pixels
The width of the border surrounding the entire widget
.TP
\fBrelief\fR string
The relief of the border surrounding the entire widget
.TP
\fBhighlightthickness\fR pixels
The width of the border to indicate the widget has keyboard focus
.TP
\fBlabelfont\fR fontname
Font of the labels to the scale
.TP
\fBtitlefont\fR fontname
Font of the title below the dial
.TP
\fBdialcolor\fR color
Color of the dial holding the needle
.TP
\fBneedlecolor\fR color
Color of the needle
.TP
\fBscalecolor\fR color
Color of the scale (arc and tickmarks)
.TP
\fBlabelcolor\fR color
Color of the labels to the scale
.TP
\fBtitlecolor\fR color
Color of the title below the dial
.RE
.RE
.TP
\fB::controlwidget::tachometer\fR \fIw\fR \fIargs\fR
Create a tachometer-like widget.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget. In addition
to the ones given for the voltmeter widget:
.RS
.TP
\fBvariable\fR name
Name of the variable to be associated with the meter
.TP
\fBvalue\fR value
Value for the meter (if not associated with a variable)
.TP
\fBdangerlevel\fR value
Level above which values are indicated with a different color
.TP
\fBdangercolor\fR color
Color for the values above the "danger level"
.TP
\fBdangerwidth\fR pixels
Width for the colored band indicating the "danger level"
.TP
\fBpincolor\fR color
Color for the needle and the pin
.RE
.RE
.TP
\fB::controlwidget::rdial\fR \fIw\fR \fIargs\fR
Create a rotating dial. You can drag the dial to change the value. With the shift button
depressed the value changes slowly, with the control button depressed it changes fast.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget:
.RS
.TP
\fBvariable\fR name
Name of the variable to be associated with the dial
.TP
\fBvalue\fR value
Value for the dial (if not associated with a variable)
.TP
\fBorient\fR string
Whether a horizontal disk/dial is required ("horizontal") or a vertical one ("vertical")
.TP
\fBstep\fR value
Initial step for incrementing or decrementing the value
.TP
\fBslow\fR value
Factor on the step size for incrementing or decrementing the value slowly
.TP
\fBfast\fR value
Factor on the step size for incrementing or decrementing the value fast
.TP
\fBscale\fR value
Scale value to be applied to the actual value
.TP
\fBcallback\fR command
Command to be called when the value changes
.TP
\fBwidth\fR pixels
The width of the widget
.TP
\fBheight\fR pixels
The height of the widget
.TP
\fBbackground\fR color
The background color of the widget (coloring of the disk/dial)
.TP
\fBforeground\fR color
The foreground color of the widget (the marker lines)
.RE
.RE
.PP
All these widgets have the following methods:
.TP
\fB$widget\fR get
Return the current value or values shown in the widget
.TP
\fB$widget\fR set \fIvalue\fR
Reset the value or values shown in the widget. If the widget is associated with
a variable, that variable is set as well.
.RS
.TP
value \fIdouble/list\fR
New value or values for the widget
.RE
.PP
Two further widgets are available, meant to display logical values:
.TP
\fB::controlwidget::led\fR \fIw\fR \fIargs\fR
Create a LED-like widget.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget. In addition
to the ones given for the voltmeter widget:
.RS
.TP
\fBvariable\fR name
Name of the variable to be associated with the LED
.TP
\fBsize\fR pixels
Diameter of the LED widget
.TP
\fBon\fR color
Color to use for the "on" state
.TP
\fBoff\fR color
Color to use for the "off" state
.RE
.RE
.TP
\fB::controlwidget::radioMatrix\fR \fIw\fR \fIargs\fR
Create a matrix of radio buttons that behaves as a single widget.
.RS
.TP
widget \fIw\fR (in)
Name of the widget to be created.
.TP
arguments \fIargs\fR (in)
List of key-value pairs, controlling the appearance and behaviour of the widget. In addition
to the ones given for the voltmeter widget:
.RS
.TP
\fBvariable\fR name
Name of the variable to be associated with the matrix
.TP
\fBorient\fR string
The way the radio buttons are to be arranged (horizontal or vertical first)
.TP
\fBrows\fR integer
Number of rows in the matrix
.TP
\fBcolumns\fR integer
Number of columns in the matrix
.TP
\fBcommand\fR list
Command associated with the radio buttons. Invoked when the active radio button changes.
.RE
.RE
.PP
The LED widget has the following public methods:
.TP
\fB$led\fR on
Set the state to "on"
.TP
\fB$led\fR off
Set the state to "off"
.TP
\fB$led\fR setstate \fIstate\fR
Set the state according to the value of "state"
.RS
.TP
state \fIboolean\fR (in)
New state for the LED widget
.RE
.PP
The radioMatrix widget has two public methods:
.TP
\fB$matrix\fR get
Return the index of the currently selected radio button
.TP
\fB$matrix\fR set \fIindex\fR
Select the radio button with index "index"
.RS
.TP
index \fIinteger\fR
Index of the radio button to be set
.RE
.PP
.SH ACKNOWLEDGMENTS
The code for most of these widgets first appeared on the Wiki. In many cases, Arjen Markus merely
refactored the code a bit and "snitified" some of them. The original code was developed by the following people:
.IP \(bu
Vertical meter, LED display, radio matrix: Ron Fox
.IP \(bu
Rotating dials: Gerhard Reithofer
.IP \(bu
Voltmeter and tachometer: Marco Maggi
.IP \(bu
Code for moving the needle: ?
.PP
.SH KEYWORDS
controlling, displaying, numerical values, scale widget
.SH COPYRIGHT
.nf
Copyright (c) 2010 Ron Fox <rfox@...>
Copyright (c) 2010 Gerhard Reithofer <...@...>
Copyright (c) 2010 Marco Maggi <...@...>
Copyright (c) 2010 Arjen Markus <arjenmarkus@users.sourceforge.net>

.fi