//
//  HMError.h
//  HomeKit
//
//  Copyright (c) 2014-2015 Apple Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <HomeKit/HMDefines.h>

NS_ASSUME_NONNULL_BEGIN

HM_EXTERN NSString * const HMErrorDomain API_AVAILABLE(ios(8.0), macCatalyst(14.0)) API_UNAVAILABLE(macos);

/*!
 * @brief This enumeration describes the possible error constants that can be
 *        returned from the the HomeKit APIs.
 */
typedef NS_ENUM(NSInteger, HMErrorCode) {
    HMErrorCodeUnexpectedError                         API_AVAILABLE(ios(11.2), watchos(4.2), tvos(11.2)) = -1,
    HMErrorCodeAlreadyExists                           = 1,
    HMErrorCodeNotFound                                = 2,
    HMErrorCodeInvalidParameter                        = 3,
    HMErrorCodeAccessoryNotReachable                   = 4,
    HMErrorCodeReadOnlyCharacteristic                  = 5,
    HMErrorCodeWriteOnlyCharacteristic                 = 6,
    HMErrorCodeNotificationNotSupported                = 7,
    HMErrorCodeOperationTimedOut                       = 8,
    HMErrorCodeAccessoryPoweredOff                     = 9,
    HMErrorCodeAccessDenied                            = 10,
    HMErrorCodeObjectAssociatedToAnotherHome           = 11,
    HMErrorCodeObjectNotAssociatedToAnyHome            = 12,
    HMErrorCodeObjectAlreadyAssociatedToHome           = 13,
    HMErrorCodeAccessoryIsBusy                         = 14,
    HMErrorCodeOperationInProgress                     = 15,
    HMErrorCodeAccessoryOutOfResources                 = 16,
    HMErrorCodeInsufficientPrivileges                  = 17,
    HMErrorCodeAccessoryPairingFailed                  = 18,
    HMErrorCodeInvalidDataFormatSpecified              = 19,
    HMErrorCodeNilParameter                            = 20,
    HMErrorCodeUnconfiguredParameter                   = 21,
    HMErrorCodeInvalidClass                            = 22,
    HMErrorCodeOperationCancelled                      = 23,
    HMErrorCodeRoomForHomeCannotBeInZone               = 24,
    HMErrorCodeNoActionsInActionSet                    = 25,
    HMErrorCodeNoRegisteredActionSets                  = 26,
    HMErrorCodeMissingParameter                        = 27,
    HMErrorCodeFireDateInPast                          = 28,
    HMErrorCodeRoomForHomeCannotBeUpdated              = 29,
    HMErrorCodeActionInAnotherActionSet                = 30,
    HMErrorCodeObjectWithSimilarNameExistsInHome       = 31,
    HMErrorCodeHomeWithSimilarNameExists               = 32,
    HMErrorCodeRenameWithSimilarName                   = 33,
    HMErrorCodeCannotRemoveNonBridgeAccessory          = 34,
    HMErrorCodeNameContainsProhibitedCharacters        = 35,
    HMErrorCodeNameDoesNotStartWithValidCharacters     = 36,
    HMErrorCodeUserIDNotEmailAddress                   = 37,
    HMErrorCodeUserDeclinedAddingUser                  = 38,
    HMErrorCodeUserDeclinedRemovingUser                = 39,
    HMErrorCodeUserDeclinedInvite                      = 40,
    HMErrorCodeUserManagementFailed                    = 41,
    HMErrorCodeRecurrenceTooSmall                      = 42,
    HMErrorCodeInvalidValueType                        = 43,
    HMErrorCodeValueLowerThanMinimum                   = 44,
    HMErrorCodeValueHigherThanMaximum                  = 45,
    HMErrorCodeStringLongerThanMaximum                 = 46,
    HMErrorCodeHomeAccessNotAuthorized                 = 47,
    HMErrorCodeOperationNotSupported                   = 48,
    HMErrorCodeMaximumObjectLimitReached               = 49,
    HMErrorCodeAccessorySentInvalidResponse            = 50,
    HMErrorCodeStringShorterThanMinimum                = 51,
    HMErrorCodeGenericError                            = 52,
    HMErrorCodeSecurityFailure                         = 53,
    HMErrorCodeCommunicationFailure                    = 54,
    HMErrorCodeMessageAuthenticationFailed             = 55,
    HMErrorCodeInvalidMessageSize                      = 56,
    HMErrorCodeAccessoryDiscoveryFailed                = 57,
    HMErrorCodeClientRequestError                      = 58,
    HMErrorCodeAccessoryResponseError                  = 59,
    HMErrorCodeNameDoesNotEndWithValidCharacters       = 60,
    HMErrorCodeAccessoryIsBlocked                      = 61,
    HMErrorCodeInvalidAssociatedServiceType            = 62,
    HMErrorCodeActionSetExecutionFailed                = 63,
    HMErrorCodeActionSetExecutionPartialSuccess        = 64,
    HMErrorCodeActionSetExecutionInProgress            = 65,
    HMErrorCodeAccessoryOutOfCompliance                = 66,
    HMErrorCodeDataResetFailure                        = 67,
    HMErrorCodeNotificationAlreadyEnabled              = 68,
    HMErrorCodeRecurrenceMustBeOnSpecifiedBoundaries   = 69,
    HMErrorCodeDateMustBeOnSpecifiedBoundaries         = 70,
    HMErrorCodeCannotActivateTriggerTooFarInFuture     = 71,
    HMErrorCodeRecurrenceTooLarge                      = 72,
    HMErrorCodeReadWritePartialSuccess                 = 73,
    HMErrorCodeReadWriteFailure                        = 74,
    HMErrorCodeNotSignedIntoiCloud                     = 75,
    HMErrorCodeKeychainSyncNotEnabled                  = 76,
    HMErrorCodeCloudDataSyncInProgress                 = 77,
    HMErrorCodeNetworkUnavailable                      = 78,
    HMErrorCodeAddAccessoryFailed                      = 79,
    HMErrorCodeMissingEntitlement                      = 80,
    HMErrorCodeCannotUnblockNonBridgeAccessory         = 81,
    HMErrorCodeDeviceLocked                            = 82,
    HMErrorCodeCannotRemoveBuiltinActionSet            API_AVAILABLE(ios(9.0)) = 83,
    HMErrorCodeLocationForHomeDisabled                 API_AVAILABLE(ios(9.0)) = 84,
    HMErrorCodeNotAuthorizedForLocationServices        API_AVAILABLE(ios(9.0)) = 85,
    HMErrorCodeReferToUserManual                       API_AVAILABLE(ios(9.3)) = 86,
    HMErrorCodeInvalidOrMissingAuthorizationData       API_AVAILABLE(ios(10.0)) = 87,
    HMErrorCodeBridgedAccessoryNotReachable            API_AVAILABLE(ios(10.0)) = 88,
    HMErrorCodeNotAuthorizedForMicrophoneAccess        API_AVAILABLE(ios(10.0)) = 89,
    HMErrorCodeIncompatibleNetwork                     API_AVAILABLE(ios(10.2)) = 90,
    HMErrorCodeNoHomeHub                               API_AVAILABLE(ios(11.0)) = 91,
    HMErrorCodeNoCompatibleHomeHub                     API_AVAILABLE(ios(11.0)) = 92,
    HMErrorCodeIncompatibleAccessory                   API_AVAILABLE(ios(11.3)) = 93,
    HMErrorCodeIncompatibleHomeHub                     API_DEPRECATED_WITH_REPLACEMENT("HMErrorCodeNoCompatibleHomeHub", ios(11.0, 11.0), watchos(4.0, 4.0), tvos(11.0, 11.0)) API_UNAVAILABLE(macos, macCatalyst) = HMErrorCodeNoCompatibleHomeHub,
    HMErrorCodeObjectWithSimilarNameExists             API_AVAILABLE(ios(12.0)) = 95,
    HMErrorCodeOwnershipFailure                        API_AVAILABLE(ios(13.0)) = 96,
    HMErrorCodeMaximumAccessoriesOfTypeInHome          API_AVAILABLE(ios(13.0)) = 97,
    HMErrorCodeWiFiCredentialGenerationFailed          API_AVAILABLE(ios(13.0)) = 98,
    HMErrorCodeEnterpriseNetworkNotSupported           API_AVAILABLE(ios(14.0)) = 99,
    HMErrorCodeTimedOutWaitingForAccessory             API_AVAILABLE(ios(14.0)) = 100,
    HMErrorCodeAccessoryCommunicationFailure           API_AVAILABLE(ios(14.0)) = 101,
    HMErrorCodeFailedToJoinNetwork                     API_AVAILABLE(ios(14.0)) = 102,
} API_AVAILABLE(ios(8.0), watchos(2.0), tvos(10.0), macCatalyst(14.0)) API_UNAVAILABLE(macos);

NS_ASSUME_NONNULL_END
