/*
 * Copyright 2013-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.sidecar;

/**
 * @author www.itmuch.com
 */
public interface SidecarDiscoveryClient {

	/**
	 * register instance.
	 * @param applicationName applicationName
	 * @param ip ip
	 * @param port port
	 */
	void registerInstance(String applicationName, String ip, Integer port);

	/**
	 * deregister instance.
	 * @param applicationName applicationName
	 * @param ip ip
	 * @param port port
	 */
	void deregisterInstance(String applicationName, String ip, Integer port);

}
