// This file is auto-generated by @hey-api/openapi-ts

import { client } from "./client.gen.js"
import { buildClientParams, type Client, type Options as Options2, type TDataShape } from "./client/index.js"
import type {
  AgentPartInput,
  AppAgentsResponses,
  AppLogErrors,
  AppLogResponses,
  Auth as Auth2,
  AuthSetErrors,
  AuthSetResponses,
  CommandListResponses,
  Config as Config2,
  ConfigGetResponses,
  ConfigProvidersResponses,
  ConfigUpdateErrors,
  ConfigUpdateResponses,
  EventSubscribeResponses,
  EventTuiCommandExecute,
  EventTuiPromptAppend,
  EventTuiSessionSelect,
  EventTuiToastShow,
  ExperimentalResourceListResponses,
  FileListResponses,
  FilePartInput,
  FilePartSource,
  FileReadResponses,
  FileStatusResponses,
  FindFilesResponses,
  FindSymbolsResponses,
  FindTextResponses,
  FormatterStatusResponses,
  GlobalDisposeResponses,
  GlobalEventResponses,
  GlobalHealthResponses,
  InstanceDisposeResponses,
  LspStatusResponses,
  McpAddErrors,
  McpAddResponses,
  McpAuthAuthenticateErrors,
  McpAuthAuthenticateResponses,
  McpAuthCallbackErrors,
  McpAuthCallbackResponses,
  McpAuthRemoveErrors,
  McpAuthRemoveResponses,
  McpAuthStartErrors,
  McpAuthStartResponses,
  McpConnectResponses,
  McpDisconnectResponses,
  McpLocalConfig,
  McpRemoteConfig,
  McpStatusResponses,
  Part as Part2,
  PartDeleteErrors,
  PartDeleteResponses,
  PartUpdateErrors,
  PartUpdateResponses,
  PathGetResponses,
  PermissionListResponses,
  PermissionReplyErrors,
  PermissionReplyResponses,
  PermissionRespondErrors,
  PermissionRespondResponses,
  PermissionRuleset,
  ProjectCurrentResponses,
  ProjectListResponses,
  ProjectUpdateErrors,
  ProjectUpdateResponses,
  ProviderAuthResponses,
  ProviderListResponses,
  ProviderOauthAuthorizeErrors,
  ProviderOauthAuthorizeResponses,
  ProviderOauthCallbackErrors,
  ProviderOauthCallbackResponses,
  PtyConnectErrors,
  PtyConnectResponses,
  PtyCreateErrors,
  PtyCreateResponses,
  PtyGetErrors,
  PtyGetResponses,
  PtyListResponses,
  PtyRemoveErrors,
  PtyRemoveResponses,
  PtyUpdateErrors,
  PtyUpdateResponses,
  QuestionAnswer,
  QuestionListResponses,
  QuestionRejectErrors,
  QuestionRejectResponses,
  QuestionReplyErrors,
  QuestionReplyResponses,
  SessionAbortErrors,
  SessionAbortResponses,
  SessionChildrenErrors,
  SessionChildrenResponses,
  SessionCommandErrors,
  SessionCommandResponses,
  SessionCreateErrors,
  SessionCreateResponses,
  SessionDeleteErrors,
  SessionDeleteResponses,
  SessionDiffErrors,
  SessionDiffResponses,
  SessionForkResponses,
  SessionGetErrors,
  SessionGetResponses,
  SessionInitErrors,
  SessionInitResponses,
  SessionListResponses,
  SessionMessageErrors,
  SessionMessageResponses,
  SessionMessagesErrors,
  SessionMessagesResponses,
  SessionPromptAsyncErrors,
  SessionPromptAsyncResponses,
  SessionPromptErrors,
  SessionPromptResponses,
  SessionRevertErrors,
  SessionRevertResponses,
  SessionShareErrors,
  SessionShareResponses,
  SessionShellErrors,
  SessionShellResponses,
  SessionStatusErrors,
  SessionStatusResponses,
  SessionSummarizeErrors,
  SessionSummarizeResponses,
  SessionTodoErrors,
  SessionTodoResponses,
  SessionUnrevertErrors,
  SessionUnrevertResponses,
  SessionUnshareErrors,
  SessionUnshareResponses,
  SessionUpdateErrors,
  SessionUpdateResponses,
  SubtaskPartInput,
  TextPartInput,
  ToolIdsErrors,
  ToolIdsResponses,
  ToolListErrors,
  ToolListResponses,
  TuiAppendPromptErrors,
  TuiAppendPromptResponses,
  TuiClearPromptResponses,
  TuiControlNextResponses,
  TuiControlResponseResponses,
  TuiExecuteCommandErrors,
  TuiExecuteCommandResponses,
  TuiOpenHelpResponses,
  TuiOpenModelsResponses,
  TuiOpenSessionsResponses,
  TuiOpenThemesResponses,
  TuiPublishErrors,
  TuiPublishResponses,
  TuiSelectSessionErrors,
  TuiSelectSessionResponses,
  TuiShowToastResponses,
  TuiSubmitPromptResponses,
  VcsGetResponses,
  WorktreeCreateErrors,
  WorktreeCreateInput,
  WorktreeCreateResponses,
  WorktreeListResponses,
} from "./types.gen.js"

export type Options<TData extends TDataShape = TDataShape, ThrowOnError extends boolean = boolean> = Options2<
  TData,
  ThrowOnError
> & {
  /**
   * You can provide a client instance returned by `createClient()` instead of
   * individual options. This might be also useful if you want to implement a
   * custom client.
   */
  client?: Client
  /**
   * You can pass arbitrary values through the `meta` object. This can be
   * used to access values that aren't defined as part of the SDK function.
   */
  meta?: Record<string, unknown>
}

class HeyApiClient {
  protected client: Client

  constructor(args?: { client?: Client }) {
    this.client = args?.client ?? client
  }
}

class HeyApiRegistry<T> {
  private readonly defaultKey = "default"

  private readonly instances: Map<string, T> = new Map()

  get(key?: string): T {
    const instance = this.instances.get(key ?? this.defaultKey)
    if (!instance) {
      throw new Error(`No SDK client found. Create one with "new OpencodeClient()" to fix this error.`)
    }
    return instance
  }

  set(value: T, key?: string): void {
    this.instances.set(key ?? this.defaultKey, value)
  }
}

export class Global extends HeyApiClient {
  /**
   * Get health
   *
   * Get health information about the OpenCode server.
   */
  public health<ThrowOnError extends boolean = false>(options?: Options<never, ThrowOnError>) {
    return (options?.client ?? this.client).get<GlobalHealthResponses, unknown, ThrowOnError>({
      url: "/global/health",
      ...options,
    })
  }

  /**
   * Get global events
   *
   * Subscribe to global events from the OpenCode system using server-sent events.
   */
  public event<ThrowOnError extends boolean = false>(options?: Options<never, ThrowOnError>) {
    return (options?.client ?? this.client).sse.get<GlobalEventResponses, unknown, ThrowOnError>({
      url: "/global/event",
      ...options,
    })
  }

  /**
   * Dispose instance
   *
   * Clean up and dispose all OpenCode instances, releasing all resources.
   */
  public dispose<ThrowOnError extends boolean = false>(options?: Options<never, ThrowOnError>) {
    return (options?.client ?? this.client).post<GlobalDisposeResponses, unknown, ThrowOnError>({
      url: "/global/dispose",
      ...options,
    })
  }
}

export class Project extends HeyApiClient {
  /**
   * List all projects
   *
   * Get a list of projects that have been opened with OpenCode.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ProjectListResponses, unknown, ThrowOnError>({
      url: "/project",
      ...options,
      ...params,
    })
  }

  /**
   * Get current project
   *
   * Retrieve the currently active project that OpenCode is working with.
   */
  public current<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ProjectCurrentResponses, unknown, ThrowOnError>({
      url: "/project/current",
      ...options,
      ...params,
    })
  }

  /**
   * Update project
   *
   * Update project properties such as name, icon and color.
   */
  public update<ThrowOnError extends boolean = false>(
    parameters: {
      projectID: string
      directory?: string
      name?: string
      icon?: {
        url?: string
        color?: string
      }
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "projectID" },
            { in: "query", key: "directory" },
            { in: "body", key: "name" },
            { in: "body", key: "icon" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).patch<ProjectUpdateResponses, ProjectUpdateErrors, ThrowOnError>({
      url: "/project/{projectID}",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }
}

export class Pty extends HeyApiClient {
  /**
   * List PTY sessions
   *
   * Get a list of all active pseudo-terminal (PTY) sessions managed by OpenCode.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<PtyListResponses, unknown, ThrowOnError>({
      url: "/pty",
      ...options,
      ...params,
    })
  }

  /**
   * Create PTY session
   *
   * Create a new pseudo-terminal (PTY) session for running shell commands and processes.
   */
  public create<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      command?: string
      args?: Array<string>
      cwd?: string
      title?: string
      env?: {
        [key: string]: string
      }
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "command" },
            { in: "body", key: "args" },
            { in: "body", key: "cwd" },
            { in: "body", key: "title" },
            { in: "body", key: "env" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<PtyCreateResponses, PtyCreateErrors, ThrowOnError>({
      url: "/pty",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Remove PTY session
   *
   * Remove and terminate a specific pseudo-terminal (PTY) session.
   */
  public remove<ThrowOnError extends boolean = false>(
    parameters: {
      ptyID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "ptyID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).delete<PtyRemoveResponses, PtyRemoveErrors, ThrowOnError>({
      url: "/pty/{ptyID}",
      ...options,
      ...params,
    })
  }

  /**
   * Get PTY session
   *
   * Retrieve detailed information about a specific pseudo-terminal (PTY) session.
   */
  public get<ThrowOnError extends boolean = false>(
    parameters: {
      ptyID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "ptyID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<PtyGetResponses, PtyGetErrors, ThrowOnError>({
      url: "/pty/{ptyID}",
      ...options,
      ...params,
    })
  }

  /**
   * Update PTY session
   *
   * Update properties of an existing pseudo-terminal (PTY) session.
   */
  public update<ThrowOnError extends boolean = false>(
    parameters: {
      ptyID: string
      directory?: string
      title?: string
      size?: {
        rows: number
        cols: number
      }
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "ptyID" },
            { in: "query", key: "directory" },
            { in: "body", key: "title" },
            { in: "body", key: "size" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).put<PtyUpdateResponses, PtyUpdateErrors, ThrowOnError>({
      url: "/pty/{ptyID}",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Connect to PTY session
   *
   * Establish a WebSocket connection to interact with a pseudo-terminal (PTY) session in real-time.
   */
  public connect<ThrowOnError extends boolean = false>(
    parameters: {
      ptyID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "ptyID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<PtyConnectResponses, PtyConnectErrors, ThrowOnError>({
      url: "/pty/{ptyID}/connect",
      ...options,
      ...params,
    })
  }
}

export class Config extends HeyApiClient {
  /**
   * Get configuration
   *
   * Retrieve the current OpenCode configuration settings and preferences.
   */
  public get<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ConfigGetResponses, unknown, ThrowOnError>({
      url: "/config",
      ...options,
      ...params,
    })
  }

  /**
   * Update configuration
   *
   * Update OpenCode configuration settings and preferences.
   */
  public update<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      config?: Config2
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { key: "config", map: "body" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).patch<ConfigUpdateResponses, ConfigUpdateErrors, ThrowOnError>({
      url: "/config",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * List config providers
   *
   * Get a list of all configured AI providers and their default models.
   */
  public providers<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ConfigProvidersResponses, unknown, ThrowOnError>({
      url: "/config/providers",
      ...options,
      ...params,
    })
  }
}

export class Tool extends HeyApiClient {
  /**
   * List tool IDs
   *
   * Get a list of all available tool IDs, including both built-in tools and dynamically registered tools.
   */
  public ids<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ToolIdsResponses, ToolIdsErrors, ThrowOnError>({
      url: "/experimental/tool/ids",
      ...options,
      ...params,
    })
  }

  /**
   * List tools
   *
   * Get a list of available tools with their JSON schema parameters for a specific provider and model combination.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters: {
      directory?: string
      provider: string
      model: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "provider" },
            { in: "query", key: "model" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<ToolListResponses, ToolListErrors, ThrowOnError>({
      url: "/experimental/tool",
      ...options,
      ...params,
    })
  }
}

export class Instance extends HeyApiClient {
  /**
   * Dispose instance
   *
   * Clean up and dispose the current OpenCode instance, releasing all resources.
   */
  public dispose<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<InstanceDisposeResponses, unknown, ThrowOnError>({
      url: "/instance/dispose",
      ...options,
      ...params,
    })
  }
}

export class Path extends HeyApiClient {
  /**
   * Get paths
   *
   * Retrieve the current working directory and related path information for the OpenCode instance.
   */
  public get<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<PathGetResponses, unknown, ThrowOnError>({
      url: "/path",
      ...options,
      ...params,
    })
  }
}

export class Worktree extends HeyApiClient {
  /**
   * List worktrees
   *
   * List all sandbox worktrees for the current project.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<WorktreeListResponses, unknown, ThrowOnError>({
      url: "/experimental/worktree",
      ...options,
      ...params,
    })
  }

  /**
   * Create worktree
   *
   * Create a new git worktree for the current project.
   */
  public create<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      worktreeCreateInput?: WorktreeCreateInput
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { key: "worktreeCreateInput", map: "body" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<WorktreeCreateResponses, WorktreeCreateErrors, ThrowOnError>({
      url: "/experimental/worktree",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }
}

export class Vcs extends HeyApiClient {
  /**
   * Get VCS info
   *
   * Retrieve version control system (VCS) information for the current project, such as git branch.
   */
  public get<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<VcsGetResponses, unknown, ThrowOnError>({
      url: "/vcs",
      ...options,
      ...params,
    })
  }
}

export class Session extends HeyApiClient {
  /**
   * List sessions
   *
   * Get a list of all OpenCode sessions, sorted by most recently updated.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      start?: number
      search?: string
      limit?: number
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "start" },
            { in: "query", key: "search" },
            { in: "query", key: "limit" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionListResponses, unknown, ThrowOnError>({
      url: "/session",
      ...options,
      ...params,
    })
  }

  /**
   * Create session
   *
   * Create a new OpenCode session for interacting with AI assistants and managing conversations.
   */
  public create<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      parentID?: string
      title?: string
      permission?: PermissionRuleset
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "parentID" },
            { in: "body", key: "title" },
            { in: "body", key: "permission" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionCreateResponses, SessionCreateErrors, ThrowOnError>({
      url: "/session",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Get session status
   *
   * Retrieve the current status of all sessions, including active, idle, and completed states.
   */
  public status<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<SessionStatusResponses, SessionStatusErrors, ThrowOnError>({
      url: "/session/status",
      ...options,
      ...params,
    })
  }

  /**
   * Delete session
   *
   * Delete a session and permanently remove all associated data, including messages and history.
   */
  public delete<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).delete<SessionDeleteResponses, SessionDeleteErrors, ThrowOnError>({
      url: "/session/{sessionID}",
      ...options,
      ...params,
    })
  }

  /**
   * Get session
   *
   * Retrieve detailed information about a specific OpenCode session.
   */
  public get<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionGetResponses, SessionGetErrors, ThrowOnError>({
      url: "/session/{sessionID}",
      ...options,
      ...params,
    })
  }

  /**
   * Update session
   *
   * Update properties of an existing session, such as title or other metadata.
   */
  public update<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      title?: string
      time?: {
        archived?: number
      }
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "title" },
            { in: "body", key: "time" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).patch<SessionUpdateResponses, SessionUpdateErrors, ThrowOnError>({
      url: "/session/{sessionID}",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Get session children
   *
   * Retrieve all child sessions that were forked from the specified parent session.
   */
  public children<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionChildrenResponses, SessionChildrenErrors, ThrowOnError>({
      url: "/session/{sessionID}/children",
      ...options,
      ...params,
    })
  }

  /**
   * Get session todos
   *
   * Retrieve the todo list associated with a specific session, showing tasks and action items.
   */
  public todo<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionTodoResponses, SessionTodoErrors, ThrowOnError>({
      url: "/session/{sessionID}/todo",
      ...options,
      ...params,
    })
  }

  /**
   * Initialize session
   *
   * Analyze the current application and create an AGENTS.md file with project-specific agent configurations.
   */
  public init<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      modelID?: string
      providerID?: string
      messageID?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "modelID" },
            { in: "body", key: "providerID" },
            { in: "body", key: "messageID" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionInitResponses, SessionInitErrors, ThrowOnError>({
      url: "/session/{sessionID}/init",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Fork session
   *
   * Create a new session by forking an existing session at a specific message point.
   */
  public fork<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      messageID?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "messageID" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionForkResponses, unknown, ThrowOnError>({
      url: "/session/{sessionID}/fork",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Abort session
   *
   * Abort an active session and stop any ongoing AI processing or command execution.
   */
  public abort<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionAbortResponses, SessionAbortErrors, ThrowOnError>({
      url: "/session/{sessionID}/abort",
      ...options,
      ...params,
    })
  }

  /**
   * Unshare session
   *
   * Remove the shareable link for a session, making it private again.
   */
  public unshare<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).delete<SessionUnshareResponses, SessionUnshareErrors, ThrowOnError>({
      url: "/session/{sessionID}/share",
      ...options,
      ...params,
    })
  }

  /**
   * Share session
   *
   * Create a shareable link for a session, allowing others to view the conversation.
   */
  public share<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionShareResponses, SessionShareErrors, ThrowOnError>({
      url: "/session/{sessionID}/share",
      ...options,
      ...params,
    })
  }

  /**
   * Get session diff
   *
   * Get all file changes (diffs) made during this session.
   */
  public diff<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      messageID?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "query", key: "messageID" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionDiffResponses, SessionDiffErrors, ThrowOnError>({
      url: "/session/{sessionID}/diff",
      ...options,
      ...params,
    })
  }

  /**
   * Summarize session
   *
   * Generate a concise summary of the session using AI compaction to preserve key information.
   */
  public summarize<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      providerID?: string
      modelID?: string
      auto?: boolean
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "providerID" },
            { in: "body", key: "modelID" },
            { in: "body", key: "auto" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionSummarizeResponses, SessionSummarizeErrors, ThrowOnError>({
      url: "/session/{sessionID}/summarize",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Get session messages
   *
   * Retrieve all messages in a session, including user prompts and AI responses.
   */
  public messages<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      limit?: number
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "query", key: "limit" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionMessagesResponses, SessionMessagesErrors, ThrowOnError>({
      url: "/session/{sessionID}/message",
      ...options,
      ...params,
    })
  }

  /**
   * Send message
   *
   * Create and send a new message to a session, streaming the AI response.
   */
  public prompt<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      messageID?: string
      model?: {
        providerID: string
        modelID: string
      }
      agent?: string
      noReply?: boolean
      tools?: {
        [key: string]: boolean
      }
      system?: string
      variant?: string
      parts?: Array<TextPartInput | FilePartInput | AgentPartInput | SubtaskPartInput>
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "messageID" },
            { in: "body", key: "model" },
            { in: "body", key: "agent" },
            { in: "body", key: "noReply" },
            { in: "body", key: "tools" },
            { in: "body", key: "system" },
            { in: "body", key: "variant" },
            { in: "body", key: "parts" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionPromptResponses, SessionPromptErrors, ThrowOnError>({
      url: "/session/{sessionID}/message",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Get message
   *
   * Retrieve a specific message from a session by its message ID.
   */
  public message<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      messageID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "path", key: "messageID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<SessionMessageResponses, SessionMessageErrors, ThrowOnError>({
      url: "/session/{sessionID}/message/{messageID}",
      ...options,
      ...params,
    })
  }

  /**
   * Send async message
   *
   * Create and send a new message to a session asynchronously, starting the session if needed and returning immediately.
   */
  public promptAsync<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      messageID?: string
      model?: {
        providerID: string
        modelID: string
      }
      agent?: string
      noReply?: boolean
      tools?: {
        [key: string]: boolean
      }
      system?: string
      variant?: string
      parts?: Array<TextPartInput | FilePartInput | AgentPartInput | SubtaskPartInput>
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "messageID" },
            { in: "body", key: "model" },
            { in: "body", key: "agent" },
            { in: "body", key: "noReply" },
            { in: "body", key: "tools" },
            { in: "body", key: "system" },
            { in: "body", key: "variant" },
            { in: "body", key: "parts" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionPromptAsyncResponses, SessionPromptAsyncErrors, ThrowOnError>({
      url: "/session/{sessionID}/prompt_async",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Send command
   *
   * Send a new command to a session for execution by the AI assistant.
   */
  public command<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      messageID?: string
      agent?: string
      model?: string
      arguments?: string
      command?: string
      variant?: string
      parts?: Array<{
        id?: string
        type: "file"
        mime: string
        filename?: string
        url: string
        source?: FilePartSource
      }>
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "messageID" },
            { in: "body", key: "agent" },
            { in: "body", key: "model" },
            { in: "body", key: "arguments" },
            { in: "body", key: "command" },
            { in: "body", key: "variant" },
            { in: "body", key: "parts" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionCommandResponses, SessionCommandErrors, ThrowOnError>({
      url: "/session/{sessionID}/command",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Run shell command
   *
   * Execute a shell command within the session context and return the AI's response.
   */
  public shell<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      agent?: string
      model?: {
        providerID: string
        modelID: string
      }
      command?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "agent" },
            { in: "body", key: "model" },
            { in: "body", key: "command" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionShellResponses, SessionShellErrors, ThrowOnError>({
      url: "/session/{sessionID}/shell",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Revert message
   *
   * Revert a specific message in a session, undoing its effects and restoring the previous state.
   */
  public revert<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
      messageID?: string
      partID?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "messageID" },
            { in: "body", key: "partID" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionRevertResponses, SessionRevertErrors, ThrowOnError>({
      url: "/session/{sessionID}/revert",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Restore reverted messages
   *
   * Restore all previously reverted messages in a session.
   */
  public unrevert<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<SessionUnrevertResponses, SessionUnrevertErrors, ThrowOnError>({
      url: "/session/{sessionID}/unrevert",
      ...options,
      ...params,
    })
  }
}

export class Part extends HeyApiClient {
  /**
   * Delete a part from a message
   */
  public delete<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      messageID: string
      partID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "path", key: "messageID" },
            { in: "path", key: "partID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).delete<PartDeleteResponses, PartDeleteErrors, ThrowOnError>({
      url: "/session/{sessionID}/message/{messageID}/part/{partID}",
      ...options,
      ...params,
    })
  }

  /**
   * Update a part in a message
   */
  public update<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      messageID: string
      partID: string
      directory?: string
      part?: Part2
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "path", key: "messageID" },
            { in: "path", key: "partID" },
            { in: "query", key: "directory" },
            { key: "part", map: "body" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).patch<PartUpdateResponses, PartUpdateErrors, ThrowOnError>({
      url: "/session/{sessionID}/message/{messageID}/part/{partID}",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }
}

export class Permission extends HeyApiClient {
  /**
   * Respond to permission
   *
   * Approve or deny a permission request from the AI assistant.
   *
   * @deprecated
   */
  public respond<ThrowOnError extends boolean = false>(
    parameters: {
      sessionID: string
      permissionID: string
      directory?: string
      response?: "once" | "always" | "reject"
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "sessionID" },
            { in: "path", key: "permissionID" },
            { in: "query", key: "directory" },
            { in: "body", key: "response" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<PermissionRespondResponses, PermissionRespondErrors, ThrowOnError>({
      url: "/session/{sessionID}/permissions/{permissionID}",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Respond to permission request
   *
   * Approve or deny a permission request from the AI assistant.
   */
  public reply<ThrowOnError extends boolean = false>(
    parameters: {
      requestID: string
      directory?: string
      reply?: "once" | "always" | "reject"
      message?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "requestID" },
            { in: "query", key: "directory" },
            { in: "body", key: "reply" },
            { in: "body", key: "message" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<PermissionReplyResponses, PermissionReplyErrors, ThrowOnError>({
      url: "/permission/{requestID}/reply",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * List pending permissions
   *
   * Get all pending permission requests across all sessions.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<PermissionListResponses, unknown, ThrowOnError>({
      url: "/permission",
      ...options,
      ...params,
    })
  }
}

export class Question extends HeyApiClient {
  /**
   * List pending questions
   *
   * Get all pending question requests across all sessions.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<QuestionListResponses, unknown, ThrowOnError>({
      url: "/question",
      ...options,
      ...params,
    })
  }

  /**
   * Reply to question request
   *
   * Provide answers to a question request from the AI assistant.
   */
  public reply<ThrowOnError extends boolean = false>(
    parameters: {
      requestID: string
      directory?: string
      answers?: Array<QuestionAnswer>
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "requestID" },
            { in: "query", key: "directory" },
            { in: "body", key: "answers" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<QuestionReplyResponses, QuestionReplyErrors, ThrowOnError>({
      url: "/question/{requestID}/reply",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Reject question request
   *
   * Reject a question request from the AI assistant.
   */
  public reject<ThrowOnError extends boolean = false>(
    parameters: {
      requestID: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "requestID" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<QuestionRejectResponses, QuestionRejectErrors, ThrowOnError>({
      url: "/question/{requestID}/reject",
      ...options,
      ...params,
    })
  }
}

export class Command extends HeyApiClient {
  /**
   * List commands
   *
   * Get a list of all available commands in the OpenCode system.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<CommandListResponses, unknown, ThrowOnError>({
      url: "/command",
      ...options,
      ...params,
    })
  }
}

export class Oauth extends HeyApiClient {
  /**
   * OAuth authorize
   *
   * Initiate OAuth authorization for a specific AI provider to get an authorization URL.
   */
  public authorize<ThrowOnError extends boolean = false>(
    parameters: {
      providerID: string
      directory?: string
      method?: number
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "providerID" },
            { in: "query", key: "directory" },
            { in: "body", key: "method" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<
      ProviderOauthAuthorizeResponses,
      ProviderOauthAuthorizeErrors,
      ThrowOnError
    >({
      url: "/provider/{providerID}/oauth/authorize",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * OAuth callback
   *
   * Handle the OAuth callback from a provider after user authorization.
   */
  public callback<ThrowOnError extends boolean = false>(
    parameters: {
      providerID: string
      directory?: string
      method?: number
      code?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "providerID" },
            { in: "query", key: "directory" },
            { in: "body", key: "method" },
            { in: "body", key: "code" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<
      ProviderOauthCallbackResponses,
      ProviderOauthCallbackErrors,
      ThrowOnError
    >({
      url: "/provider/{providerID}/oauth/callback",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }
}

export class Provider extends HeyApiClient {
  /**
   * List providers
   *
   * Get a list of all available AI providers, including both available and connected ones.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ProviderListResponses, unknown, ThrowOnError>({
      url: "/provider",
      ...options,
      ...params,
    })
  }

  /**
   * Get provider auth methods
   *
   * Retrieve available authentication methods for all AI providers.
   */
  public auth<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ProviderAuthResponses, unknown, ThrowOnError>({
      url: "/provider/auth",
      ...options,
      ...params,
    })
  }

  oauth = new Oauth({ client: this.client })
}

export class Find extends HeyApiClient {
  /**
   * Find text
   *
   * Search for text patterns across files in the project using ripgrep.
   */
  public text<ThrowOnError extends boolean = false>(
    parameters: {
      directory?: string
      pattern: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "pattern" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<FindTextResponses, unknown, ThrowOnError>({
      url: "/find",
      ...options,
      ...params,
    })
  }

  /**
   * Find files
   *
   * Search for files or directories by name or pattern in the project directory.
   */
  public files<ThrowOnError extends boolean = false>(
    parameters: {
      directory?: string
      query: string
      dirs?: "true" | "false"
      type?: "file" | "directory"
      limit?: number
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "query" },
            { in: "query", key: "dirs" },
            { in: "query", key: "type" },
            { in: "query", key: "limit" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<FindFilesResponses, unknown, ThrowOnError>({
      url: "/find/file",
      ...options,
      ...params,
    })
  }

  /**
   * Find symbols
   *
   * Search for workspace symbols like functions, classes, and variables using LSP.
   */
  public symbols<ThrowOnError extends boolean = false>(
    parameters: {
      directory?: string
      query: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "query" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<FindSymbolsResponses, unknown, ThrowOnError>({
      url: "/find/symbol",
      ...options,
      ...params,
    })
  }
}

export class File extends HeyApiClient {
  /**
   * List files
   *
   * List files and directories in a specified path.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters: {
      directory?: string
      path: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "path" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<FileListResponses, unknown, ThrowOnError>({
      url: "/file",
      ...options,
      ...params,
    })
  }

  /**
   * Read file
   *
   * Read the content of a specified file.
   */
  public read<ThrowOnError extends boolean = false>(
    parameters: {
      directory?: string
      path: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "query", key: "path" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).get<FileReadResponses, unknown, ThrowOnError>({
      url: "/file/content",
      ...options,
      ...params,
    })
  }

  /**
   * Get file status
   *
   * Get the git status of all files in the project.
   */
  public status<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<FileStatusResponses, unknown, ThrowOnError>({
      url: "/file/status",
      ...options,
      ...params,
    })
  }
}

export class App extends HeyApiClient {
  /**
   * Write log
   *
   * Write a log entry to the server logs with specified level and metadata.
   */
  public log<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      service?: string
      level?: "debug" | "info" | "error" | "warn"
      message?: string
      extra?: {
        [key: string]: unknown
      }
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "service" },
            { in: "body", key: "level" },
            { in: "body", key: "message" },
            { in: "body", key: "extra" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<AppLogResponses, AppLogErrors, ThrowOnError>({
      url: "/log",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * List agents
   *
   * Get a list of all available AI agents in the OpenCode system.
   */
  public agents<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<AppAgentsResponses, unknown, ThrowOnError>({
      url: "/agent",
      ...options,
      ...params,
    })
  }
}

export class Auth extends HeyApiClient {
  /**
   * Remove MCP OAuth
   *
   * Remove OAuth credentials for an MCP server
   */
  public remove<ThrowOnError extends boolean = false>(
    parameters: {
      name: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "name" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).delete<McpAuthRemoveResponses, McpAuthRemoveErrors, ThrowOnError>({
      url: "/mcp/{name}/auth",
      ...options,
      ...params,
    })
  }

  /**
   * Start MCP OAuth
   *
   * Start OAuth authentication flow for a Model Context Protocol (MCP) server.
   */
  public start<ThrowOnError extends boolean = false>(
    parameters: {
      name: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "name" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<McpAuthStartResponses, McpAuthStartErrors, ThrowOnError>({
      url: "/mcp/{name}/auth",
      ...options,
      ...params,
    })
  }

  /**
   * Complete MCP OAuth
   *
   * Complete OAuth authentication for a Model Context Protocol (MCP) server using the authorization code.
   */
  public callback<ThrowOnError extends boolean = false>(
    parameters: {
      name: string
      directory?: string
      code?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "name" },
            { in: "query", key: "directory" },
            { in: "body", key: "code" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<McpAuthCallbackResponses, McpAuthCallbackErrors, ThrowOnError>({
      url: "/mcp/{name}/auth/callback",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Authenticate MCP OAuth
   *
   * Start OAuth flow and wait for callback (opens browser)
   */
  public authenticate<ThrowOnError extends boolean = false>(
    parameters: {
      name: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "name" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<McpAuthAuthenticateResponses, McpAuthAuthenticateErrors, ThrowOnError>(
      {
        url: "/mcp/{name}/auth/authenticate",
        ...options,
        ...params,
      },
    )
  }

  /**
   * Set auth credentials
   *
   * Set authentication credentials
   */
  public set<ThrowOnError extends boolean = false>(
    parameters: {
      providerID: string
      directory?: string
      auth?: Auth2
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "providerID" },
            { in: "query", key: "directory" },
            { key: "auth", map: "body" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).put<AuthSetResponses, AuthSetErrors, ThrowOnError>({
      url: "/auth/{providerID}",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }
}

export class Mcp extends HeyApiClient {
  /**
   * Get MCP status
   *
   * Get the status of all Model Context Protocol (MCP) servers.
   */
  public status<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<McpStatusResponses, unknown, ThrowOnError>({
      url: "/mcp",
      ...options,
      ...params,
    })
  }

  /**
   * Add MCP server
   *
   * Dynamically add a new Model Context Protocol (MCP) server to the system.
   */
  public add<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      name?: string
      config?: McpLocalConfig | McpRemoteConfig
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "name" },
            { in: "body", key: "config" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<McpAddResponses, McpAddErrors, ThrowOnError>({
      url: "/mcp",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Connect an MCP server
   */
  public connect<ThrowOnError extends boolean = false>(
    parameters: {
      name: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "name" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<McpConnectResponses, unknown, ThrowOnError>({
      url: "/mcp/{name}/connect",
      ...options,
      ...params,
    })
  }

  /**
   * Disconnect an MCP server
   */
  public disconnect<ThrowOnError extends boolean = false>(
    parameters: {
      name: string
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "path", key: "name" },
            { in: "query", key: "directory" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<McpDisconnectResponses, unknown, ThrowOnError>({
      url: "/mcp/{name}/disconnect",
      ...options,
      ...params,
    })
  }

  auth = new Auth({ client: this.client })
}

export class Resource extends HeyApiClient {
  /**
   * Get MCP resources
   *
   * Get all available MCP resources from connected servers. Optionally filter by name.
   */
  public list<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<ExperimentalResourceListResponses, unknown, ThrowOnError>({
      url: "/experimental/resource",
      ...options,
      ...params,
    })
  }
}

export class Experimental extends HeyApiClient {
  resource = new Resource({ client: this.client })
}

export class Lsp extends HeyApiClient {
  /**
   * Get LSP status
   *
   * Get LSP server status
   */
  public status<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<LspStatusResponses, unknown, ThrowOnError>({
      url: "/lsp",
      ...options,
      ...params,
    })
  }
}

export class Formatter extends HeyApiClient {
  /**
   * Get formatter status
   *
   * Get formatter status
   */
  public status<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<FormatterStatusResponses, unknown, ThrowOnError>({
      url: "/formatter",
      ...options,
      ...params,
    })
  }
}

export class Control extends HeyApiClient {
  /**
   * Get next TUI request
   *
   * Retrieve the next TUI (Terminal User Interface) request from the queue for processing.
   */
  public next<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).get<TuiControlNextResponses, unknown, ThrowOnError>({
      url: "/tui/control/next",
      ...options,
      ...params,
    })
  }

  /**
   * Submit TUI response
   *
   * Submit a response to the TUI request queue to complete a pending request.
   */
  public response<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      body?: unknown
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }, { in: "body" }] }])
    return (options?.client ?? this.client).post<TuiControlResponseResponses, unknown, ThrowOnError>({
      url: "/tui/control/response",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }
}

export class Tui extends HeyApiClient {
  /**
   * Append TUI prompt
   *
   * Append prompt to the TUI
   */
  public appendPrompt<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      text?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "text" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<TuiAppendPromptResponses, TuiAppendPromptErrors, ThrowOnError>({
      url: "/tui/append-prompt",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Open help dialog
   *
   * Open the help dialog in the TUI to display user assistance information.
   */
  public openHelp<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<TuiOpenHelpResponses, unknown, ThrowOnError>({
      url: "/tui/open-help",
      ...options,
      ...params,
    })
  }

  /**
   * Open sessions dialog
   *
   * Open the session dialog
   */
  public openSessions<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<TuiOpenSessionsResponses, unknown, ThrowOnError>({
      url: "/tui/open-sessions",
      ...options,
      ...params,
    })
  }

  /**
   * Open themes dialog
   *
   * Open the theme dialog
   */
  public openThemes<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<TuiOpenThemesResponses, unknown, ThrowOnError>({
      url: "/tui/open-themes",
      ...options,
      ...params,
    })
  }

  /**
   * Open models dialog
   *
   * Open the model dialog
   */
  public openModels<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<TuiOpenModelsResponses, unknown, ThrowOnError>({
      url: "/tui/open-models",
      ...options,
      ...params,
    })
  }

  /**
   * Submit TUI prompt
   *
   * Submit the prompt
   */
  public submitPrompt<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<TuiSubmitPromptResponses, unknown, ThrowOnError>({
      url: "/tui/submit-prompt",
      ...options,
      ...params,
    })
  }

  /**
   * Clear TUI prompt
   *
   * Clear the prompt
   */
  public clearPrompt<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).post<TuiClearPromptResponses, unknown, ThrowOnError>({
      url: "/tui/clear-prompt",
      ...options,
      ...params,
    })
  }

  /**
   * Execute TUI command
   *
   * Execute a TUI command (e.g. agent_cycle)
   */
  public executeCommand<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      command?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "command" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<TuiExecuteCommandResponses, TuiExecuteCommandErrors, ThrowOnError>({
      url: "/tui/execute-command",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Show TUI toast
   *
   * Show a toast notification in the TUI
   */
  public showToast<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      title?: string
      message?: string
      variant?: "info" | "success" | "warning" | "error"
      duration?: number
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "title" },
            { in: "body", key: "message" },
            { in: "body", key: "variant" },
            { in: "body", key: "duration" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<TuiShowToastResponses, unknown, ThrowOnError>({
      url: "/tui/show-toast",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Publish TUI event
   *
   * Publish a TUI event
   */
  public publish<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      body?: EventTuiPromptAppend | EventTuiCommandExecute | EventTuiToastShow | EventTuiSessionSelect
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }, { in: "body" }] }])
    return (options?.client ?? this.client).post<TuiPublishResponses, TuiPublishErrors, ThrowOnError>({
      url: "/tui/publish",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  /**
   * Select session
   *
   * Navigate the TUI to display the specified session.
   */
  public selectSession<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
      sessionID?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams(
      [parameters],
      [
        {
          args: [
            { in: "query", key: "directory" },
            { in: "body", key: "sessionID" },
          ],
        },
      ],
    )
    return (options?.client ?? this.client).post<TuiSelectSessionResponses, TuiSelectSessionErrors, ThrowOnError>({
      url: "/tui/select-session",
      ...options,
      ...params,
      headers: {
        "Content-Type": "application/json",
        ...options?.headers,
        ...params.headers,
      },
    })
  }

  control = new Control({ client: this.client })
}

export class Event extends HeyApiClient {
  /**
   * Subscribe to events
   *
   * Get events
   */
  public subscribe<ThrowOnError extends boolean = false>(
    parameters?: {
      directory?: string
    },
    options?: Options<never, ThrowOnError>,
  ) {
    const params = buildClientParams([parameters], [{ args: [{ in: "query", key: "directory" }] }])
    return (options?.client ?? this.client).sse.get<EventSubscribeResponses, unknown, ThrowOnError>({
      url: "/event",
      ...options,
      ...params,
    })
  }
}

export class OpencodeClient extends HeyApiClient {
  public static readonly __registry = new HeyApiRegistry<OpencodeClient>()

  constructor(args?: { client?: Client; key?: string }) {
    super(args)
    OpencodeClient.__registry.set(this, args?.key)
  }

  global = new Global({ client: this.client })

  project = new Project({ client: this.client })

  pty = new Pty({ client: this.client })

  config = new Config({ client: this.client })

  tool = new Tool({ client: this.client })

  instance = new Instance({ client: this.client })

  path = new Path({ client: this.client })

  worktree = new Worktree({ client: this.client })

  vcs = new Vcs({ client: this.client })

  session = new Session({ client: this.client })

  part = new Part({ client: this.client })

  permission = new Permission({ client: this.client })

  question = new Question({ client: this.client })

  command = new Command({ client: this.client })

  provider = new Provider({ client: this.client })

  find = new Find({ client: this.client })

  file = new File({ client: this.client })

  app = new App({ client: this.client })

  mcp = new Mcp({ client: this.client })

  experimental = new Experimental({ client: this.client })

  lsp = new Lsp({ client: this.client })

  formatter = new Formatter({ client: this.client })

  tui = new Tui({ client: this.client })

  auth = new Auth({ client: this.client })

  event = new Event({ client: this.client })
}
