# Event List

The `/campaign` directory is used to place map files.

To add a new event, add a new row in here, and run `python -m module.config.config_updater`. Some date in directory not equal to Aired date, because they use the map files in old events. Use `Ctrl+F` to search what you want.

**Aired Date** The date that the event aired for the first time.

**Directory** The directory where contains map files of an event are stored.

**Event Name** Official name in English. If an event haven't aired in EN, use the name in CN.

**CN, EN, JP, TW** Event names in GUI. If an event is not aired on some servers, use `-`.

| Aired Date | Directory                | Event Name                                   | CN                         | EN                                                 | JP                                   | TW                         |
| :--------- | :----------------------- | :------------------------------------------- | :------------------------- | :------------------------------------------------- | :----------------------------------- | :------------------------- |
| 20170607   | war archives 20181020 en | Strive, Wish, and Strategize                 | 努力、希望和计划           | Strive, Wish, and Strategize                       | 努力、希望と計画                     | 努力、希望和計劃           |
| 20170802   | war archives 20191031 en | Divergent Chessboard                         | 异色格                     | Divergent Chessboard                               | 鏡写されし異色                       | 異色格                     |
| 20170928   | war archives 20190321 en | Visitors Dyed in Red                         | 红染的参访者               | Visitors Dyed in Red                               | 紅染の来訪者                         | 紅染的參訪者               |
| 20171026   | war archives 20190620 en | Glorious Battle                              | 光荣的一战                 | Glorious Battle                                    | 栄光なる最終戦                       | 光榮的一戰                 |
| 20171228   | war archives 20181026 en | Fallen Wings                                 | 坠落之翼                   | Fallen Wings                                       | 闇に堕ちた青き翼                     | 墜落之翼                   |
| 20180119   | war archives 20191010 en | Encircling Graf Spee                         | 围剿斯佩伯爵               | Encircling Graf Spee                               | アドミラル・グラーフ・シュペー追撃戦 | 圍剿斯佩伯爵               |
| 20180226   | war archives 20190221 en | Winter\'s Crown                              | 凛冬王冠                   | Winter\'s Crown                                    | 凛冽なりし冬の王冠                   | 凜冬王冠                   |
| 20180607   | war archives 20180607 cn | Ink Stained Steel Sakura                     | 墨染的钢铁之花             | Ink Stained Steel Sakura                           | 墨染まりし鋼の桜                     | 墨染的鋼鐵之花             |
| 20180717   | war archives 20190314 en | Prelude under the Moon                       | 月光下的序曲               | Prelude under the Moon                             | 月夜の開幕曲                         | 月光下的序曲               |
| 20180726   | war archives 20180726 cn | Iris of Light and Dark                       | 光与影的鸢尾之华           | Iris of Light and Dark                             | 光と影のアイリス                     | 光與影的鳶尾之華           |
| 20200312   | war archives 20200312 cn | The Solomon Ranger                           | 斯图尔特的硝烟             | The Solomon Ranger                                 | 南洋に靡く硝煙                       | 斯圖爾特的硝煙             |
| 20210121   | war archives 20181227 cn | Crimson Echoes                               | 苍红的回响                 | Crimson Echoes                                     | 縹映る深緋の残響                     | 蒼紅的迴響                 |
| 20210513   | war archives 20200820 cn | Scherzo of Iron and Blood                    | 铁血音符誓言               | Scherzo of Iron and Blood                          | 黒鉄の楽章 誓いの海                  | 鐵血音符誓言               |
| 20211014   | war archives 20211014 cn | Crescendo of Polaris                         | 激奏的Polaris              | Crescendo of Polaris                               | 激奏のポラリス                       | 激奏的Polaris              |
| 20220113   | war archives 20190911 cn | Empyreal Tragicomedy                         | 神圣的悲喜剧               | Empyreal Tragicomedy                               | 悲歎せし焔海の詩                     | 神聖的悲喜劇               |
| 20220407   | war archives 20210325 cn | Ashen Simulacrum                             | 箱庭疗法                   | Ashen Simulacrum                                   | 開かれし紺碧の砂箱                   | 箱庭療法                   |
| 20220721   | war archives 20210624 cn | Swirling Cherry Blossoms                     | 浮樱影华                   | Swirling Cherry Blossoms                           | 翳りし満ちる影の華                   | 浮櫻影華                   |
| 20220901   | war archives 20200806 cn | The Enigma and the Shark                     | 最重要的宝物               | The Enigma and the Shark                           | 鉄血鮫とエニグマ                     | 最重要的寶物               |
| 20221013   | war archives 20201029 cn | Universe in Unison                           | 激唱的UNIVERSE             | Universe in Unison                                 | 激唱のユニバース                     | 激唱的UNIVERSE             |
| 20221117   | war archives 20200903 cn | Stars of the Shimmering Fjord                | 峡湾间的星辰               | Stars of the Shimmering Fjord                      | 輝ける峡湾の星                       | 峽灣間的星辰               |
| 20221117   | war archives 20210819 cn | Microlayer Medley                            | 微层混合                   | Microlayer Medley                                  | 闇靄払う銀翼                         | 微層混合                   |
| 20211028   | war archives 20211028 cn | Skybound Oratorio                            | 穹顶下的圣咏曲             | Skybound Oratorio                                  | 神穹を衝く聖歌                       | 穹頂下的聖詠曲             |
| 20230309   | war archives 20200507 cn | The Way Home in the Night                    | 夜幕下的归途               | The Way Home in the Night                          | 帰路は海色の陰りへと                 | 夜幕下的歸途               |
| 20230420   | war archives 20220210 cn | Northern Overture                            | 北境序曲                   | Northern Overture                                  | 凍絶の北海                           | 北境序曲                   |
| 20230511   | war archives 20220414 cn | Aurora Noctis                                | 永夜幻光                   | Aurora Noctis                                      | 極夜照らす幻光                       | 永夜幻光                   |
| 20230713   | war archives 20200603 cn | Counterattack Within the Fjord               | 峡湾间的反击               | Counterattack Within the Fjord                     | 峡湾間の反撃                         | 峽灣間的反擊               |
| 20230831   | war archives 20201229 cn | Inverted Orthant                             | 负象限作战                 | Inverted Orthant                                   | 虚畳なりし限象                       | 負象限作戰                 |
| 20240118   | war archives 20200917 cn | Dreamwaker's Butterfly                       | 蝶海梦花                   | Dreamwaker's Butterfly                             | 刹那觀る胡蝶の夢                     | 蝶海夢花                   |
| 20240118   | war archives 20210527 cn | Mirror Involution                            | 镜位螺旋                   | Mirror Involution                                  | 照らす螺旋の鏡海                     | 鏡位螺旋                   |
| 20240222   | war archives 20210225 cn | Khorovod of Dawn's Rime                      | 破晓冰华                   | Khorovod of Dawn's Rime                            | 暁射す氷華の嵐                       | 破曉冰華                   |
| 20240321   | war archives 20201012 cn | Sundered Blue                                | 划破海空之翼               | Sundered Blue                                      | 奔る彩帆の青                         | 劃破海空之翼               |
| 20240613   | war archives 20211111 cn | The Flame-Touched Dagger                     | 杰诺瓦的焰火               | The Flame-Touched Dagger                           | 燈火のシニエ                         | 杰諾瓦的焰火               |
| 20240718   | war archives 20210916 cn | Upon the Shimmering Blue                     | 碧海光粼                   | Upon the Shimmering Blue                           | 駆けよ 碧海の吹き風                  | 碧海光粼                   |
| 20240829   | war archives 20210422 cn | Daedalian Hymn                               | 复兴的赞美诗               | Daedalian Hymn                                     | 讃える復興の迷路                     | 復興的讚美詩               |
| 20241017   | war archives 20211229 cn | Tower of Transcendence                       | 逆转彩虹之塔               | Tower of Transcendence                             | 遡望せし虹彩の塔                     | 逆轉彩虹之塔               |
| 20250109   | war archives 20220224 cn | Abyssal Refrain                              | 深度回音                   | Abyssal Refrain                                    | 鳴動せし星霜の淵                     | 深度回音                   |
| 20250320   | war archives 20220324 cn | Virtual Tower                                | 虚像构筑之塔               | Virtual Tower                                      | 幻像の塔                             | 虛像構築之塔               |
| 20250417   | war archives 20220526 cn | Pledge of the Radiant Court                  | 泠誓光庭                   | Pledge of the Radiant Court                        | 诚閃の剣 搖光の城                    | 泠誓光庭                   |
| 20250619   | war archives 20220728 cn | Aquilifer's Ballade                          | 雄鹰的叙事歌               | Aquilifer's Ballade                                | 鋼鷲の冒険譚                         | 雄鷹的敘事歌               |
| 20250717   | war archives 20220428 cn | Rondo at Rainbow's End                       | 虹彩的终幕曲               | Rondo at Rainbow's End                             | 吟ずる瑠璃の楽章                     | 虹彩的終幕曲               |
| 20251016   | war archives 20231026 cn | Tempesta and the Fountain of Youth           | 飓风与青春之泉             | Tempesta and the Fountain of Youth                 | テンペスタと若返りの泉               | 飓風與青春之泉             |
| 20251106   | war archives 20220915 cn | Violet Tempest Blooming Lycoris              | 紫绛槿岚                   | Violet Tempest Blooming Lycoris                    | 赫の涙月 菫の暁風                    | 紫絳槿嵐                   |
| 20251218   | war archives 20221222 cn | Parallel Superimposition                     | 定向折叠                   | Parallel Superimposition                           | 積重なる事象の幻界                   | 定向折疊                   |
| 20200227   | event 20200227 cn        | Northern Overture                            | 北境序曲                   | Northern Overture                                  | 凍絶の北海                           | -                          |
| 20200312   | event 20200312 cn        | The Solomon Ranger                           | 复刻斯图尔特的硝烟         | The Solomon Ranger Rerun                           | 南洋に靡く硝煙（復刻）               | -                          |
| 20200326   | event 20200326 cn        | Microlayer Medley                            | 微层混合                   | Microlayer Medley                                  | 闇靄払う銀翼                         | -                          |
| 20200423   | event 20200423 cn        | Crimson Echoes                               | 复刻苍红的回响             | Crimson Echoes Rerun                               | 縹映る深緋の残響（復刻）             | -                          |
| 20200507   | event 20200507 cn        | The Way Home in the Night                    | 夜幕下的归途               | The Way Home in the Night                          | 帰路は海色の陰りへと                 | -                          |
| 20200521   | event 20200521 cn        | Skybound Oratorio                            | 穹顶下的圣咏曲             | -                                                  | 神穹を衝く聖歌                       | -                          |
| 20200521   | event 20200521 en        | Iris of Light and Dark                       | -                          | Iris of Light and Dark Rerun                       | -                                    | -                          |
| 20200603   | event 20200603 cn        | Counterattack Within the Fjord               | 峡湾间的反击               | -                                                  | 峡湾間の反撃                         | -                          |
| 20200603   | event 20200603 en        | Prelude under the Moon                       | -                          | Prelude under the Moon Rerun                       | -                                    | -                          |
| 20200611   | event 20200611 en        | Skybound Oratorio                            | -                          | Skybound Oratorio                                  | -                                    | -                          |
| 20200624   | raid 20200624            | Air Raid Drills with Essex                   | 复刻特别演习埃塞克斯级     | Air Raid Drills with Essex Rerun                   | 特別演習超空強襲波（復刻）           | 特別演習埃塞克斯級         |
| 20200716   | event 20200716 en        | Ink Stained Steel Sakura                     | -                          | Ink Stained Steel Sakura Rerun                     | -                                    | -                          |
| 20200723   | event 20200723 cn        | Aurora Noctis                                | 永夜幻光                   | Aurora Noctis                                      | 極夜照らす幻光                       | -                          |
| 20200806   | event 20200806 cn        | The Enigma and the Shark                     | 复刻最重要的宝物           | -                                                  | 鉄血鮫とエニグマ（復刻）             | -                          |
| 20200820   | event 20200820 cn        | Scherzo of Iron and Blood                    | 复刻铁血音符誓言           | Scherzo of Iron and Blood Rerun                    | 黒鉄の楽章 誓いの海（復刻）          | -                          |
| 20200903   | event 20200903 en        | Stars of the Shimmering Fjord                | -                          | Stars of the Shimmering Fjord                      | -                                    | -                          |
| 20200917   | event 20200917 cn        | Dreamwaker's Butterfly                       | 蝶海梦花                   | Dreamwaker's Butterfly                             | 刹那觀る胡蝶の夢                     | -                          |
| 20201002   | event 20201002 en        | Counterattack Within the Fjord               | -                          | Counterattack Within the Fjord                     | -                                    | -                          |
| 20201012   | event 20201012 cn        | Sundered Blue                                | 划破海空之翼               | -                                                  | 奔る彩帆の青                         | -                          |
| 20201029   | event 20201029 cn        | Universe in Unison                           | 激唱的UNIVERSE             | Universe in Unison                                 | 激唱のユニバース                     | -                          |
| 20201105   | event 20200312 cn        | The Solomon Ranger                           | -                          | -                                                  | -                                    | 斯圖爾特的硝煙             |
| 20201112   | event 20200903 en        | Stars of the Shimmering Fjord                | 复刻峡湾间的星辰           | -                                                  | 輝ける峡湾の星（復刻）               | -                          |
| 20201112   | event 20201012 cn        | Sundered Blue                                | -                          | Sundered Blue                                      | -                                    | -                          |
| 20201126   | event 20201126 cn        | Vacation Lane                                | 假日航线                   | Vacation Lane                                      | バケーションレーン                   | -                          |
| 20201210   | event 20200806 cn        | The Enigma and the Shark                     | -                          | The Enigma and the Shark Rerun                     | -                                    | -                          |
| 20201229   | event 20201229 cn        | Inverted Orthant                             | 负象限作战                 | Inverted Orthant                                   | 虚畳なりし限象                       | -                          |
| 20210121   | event 20210121 cn        | Empyreal Tragicomedy                         | 复刻神圣的悲喜剧           | Empyreal Tragicomedy Rerun                         | 悲歎せし焔海の詩（復刻）             | -                          |
| 20210225   | event 20210225 cn        | Khorovod of Dawn's Rime                      | 破晓冰华                   | Khorovod of Dawn's Rime                            | 暁射す氷華の嵐                       | -                          |
| 20210225   | event 20210225 tw        | Northern Overture                            | -                          | -                                                  | -                                    | 北境序曲                   |
| 20210325   | event 20210325 cn        | Ashen Simulacrum                             | 复刻箱庭疗法               | Ashen Simulacrum Rerun                             | 開かれし紺碧の砂箱（復刻）           | -                          |
| 20210415   | event 20210415 tw        | Encircling Graf Spee                         | -                          | -                                                  | -                                    | 復刻圍剿施佩伯爵           |
| 20210422   | event 20210422 cn        | Daedalian Hymn                               | 复兴的赞美诗               | Daedalian Hymn                                     | 讃える復興の迷路                     | -                          |
| 20210429   | event 20210429 tw        | Ink Stained Steel Sakura                     | -                          | -                                                  | -                                    | 復刻墨染的鋼鐵之花         |
| 20210527   | event 20210527 tw        | Microlayer Medley                            | -                          | -                                                  | -                                    | 微層混合                   |
| 20210527   | event 20210527 cn        | Mirror Involution                            | 镜位螺旋                   | Mirror Involution                                  | 照らす螺旋の鏡海                     | -                          |
| 20210610   | event 20210610 tw        | The Way Home in the Night                    | -                          | -                                                  | -                                    | 夜幕下的歸途               |
| 20210624   | event 20210624 tw        | Skybound Oratorio                            | -                          | -                                                  | -                                    | 穹頂下的聖詠曲             |
| 20210624   | event 20210624 cn        | Swirling Cherry Blossoms                     | 复刻浮樱影华               | Swirling Cherry Blossoms Rerun                     | 翳りし満ちる影の華(復刻)             | -                          |
| 20210708   | raid 20210708            | Cross Wave                                   | 复刻穿越彼方的水线         | Cross Wave rerun                                   | 交錯する新たな波 (復刻)              | -                          |
| 20210708   | event 20200903 en        | Stars of the Shimmering Fjord                | -                          | -                                                  | -                                    | 峽灣間的星辰               |
| 20210722   | event 20210722 cn        | Azur Anthem                                  | 响彻碧海的偶像歌           | Azur Anthem                                        | 海に響くアイドルの歌                 | -                          |
| 20210729   | event 20200723 cn        | Aurora Noctis                                | -                          | -                                                  | -                                    | 永夜幻光                   |
| 20210812   | event 20200806 cn        | The Enigma and the Shark                     | -                          | -                                                  | -                                    | 最重要的寶物               |
| 20210819   | event 20210819 cn        | Microlayer Medley                            | 复刻微层混合               | Microlayer Medley Rerun                            | 闇靄払う銀翼（復刻）                 | -                          |
| 20210826   | event 20210722 cn        | Azur Anthem                                  | -                          | -                                                  | -                                    | 響徹碧海的偶像歌           |
| 20210916   | event 20210916 cn        | Upon the Shimmering Blue                     | 碧海光粼                   | Upon the Shimmering Blue                           | 駆けよ 碧海の吹き風                  | -                          |
| 20210923   | event 20200917 cn        | Dreamwaker's Butterfly                       | -                          | -                                                  | -                                    | 蝶海夢花                   |
| 20211008   | event 20201012 cn        | Sundered Blue                                | -                          | -                                                  | -                                    | 劃破海空之翼               |
| 20211014   | raid 20210708            | Cross Wave                                   | -                          | -                                                  | -                                    | 穿越彼方的水線             |
| 20211028   | event 20211028 cn        | Skybound Oratorio                            | 复刻穹顶下的圣咏曲         | Skybound Oratorio Rerun                            | 神穹を衝く聖歌（復刻）               | -                          |
| 20211028   | event 20211028 tw        | Iris of Light and Dark                       | -                          | -                                                  | -                                    | 復刻光與影的鳶尾之華       |
| 20211111   | event 20211111 cn        | The Flame-Touched Dagger                     | 杰诺瓦的焰火               | The Flame-Touched Dagger                           | 燈火のシニエ                         | -                          |
| 20211125   | event 20211125 cn        | World-spanning Arclight                      | 交汇世界的弧光             | World-spanning Arclight                            | 弧光は交わる世界にて                 | -                          |
| 20211130   | event 20211125 cn        | World-spanning Arclight                      | -                          | -                                                  | -                                    | 交匯世界的弧光             |
| 20211214   | event 20200603 cn        | Counterattack Within the Fjord               | -                          | -                                                  | -                                    | 峽灣間的反擊               |
| 20211229   | event 20211229 cn        | Tower of Transcendence                       | 逆转彩虹之塔               | Tower of Transcendence                             | 遡望せし虹彩の塔                     | -                          |
| 20211230   | event 20201229 cn        | Inverted Orthant                             | -                          | -                                                  | -                                    | 負象限作戰                 |
| 20220127   | raid 20220127            | Mystery Investigation                        | 演习神秘事件调查           | Mystery Investigation                              | 秘密事件調査                         | -                          |
| 20220210   | event 20220210 cn        | Northern Overture Rerun                      | 复刻北境序曲               | Northern Overture Rerun                            | 凍絶の北海（復刻）                   | -                          |
| 20220224   | event 20210225 cn        | Khorovod of Dawn's Rime                      | -                          | -                                                  | -                                    | 破曉冰華                   |
| 20220224   | event 20220224 cn        | Abyssal Refrain                              | 深度回音                   | Abyssal Refrain                                    | 鳴動せし星霜の淵                     | -                          |
| 20220310   | event 20200603 cn        | Counterattack Within the Fjord               | 复刻峡湾间的反击           | Counterattack Within the Fjord Rerun               | 峡湾間の反撃（復刻）                 | -                          |
| 20220310   | event 20220310 tw        | The Solomon Ranger                           | -                          | -                                                  | -                                    | 復刻斯圖爾特的硝煙         |
| 20220324   | event 20220324 cn        | Virtual Tower                                | 虚像构筑之塔               | Virtual Tower                                      | 幻像の塔                             | -                          |
| 20220324   | event 20210422 cn        | Daedalian Hymn                               | -                          | -                                                  | -                                    | 復興的讚美詩               |
| 20220407   | event 20220407 tw        | Crimson Echoes                               | -                          | -                                                  | -                                    | 蒼紅的迴響(復刻)           |
| 20220414   | event 20220414 cn        | Aurora Noctis                                | 复刻永夜幻光               | Aurora Noctis Rerun                                | 極夜照らす幻光（復刻）               | -                          |
| 20220428   | event 20220428 cn        | Rondo at Rainbow's End                       | 虹彩的终幕曲               | Rondo at Rainbow's End                             | 吟ずる瑠璃の楽章                     | -                          |
| 20220505   | raid 20200624            | Air Raid Drills with Essex                   | -                          | -                                                  | -                                    | 特別演習埃塞克斯級(復刻)   |
| 20220526   | event 20220526 cn        | Pledge of the Radiant Court                  | 泠誓光庭                   | Pledge of the Radiant Court                        | 诚閃の剣 搖光の城                    | -                          |
| 20220526   | event 20210527 cn        | Mirror Involution                            | -                          | -                                                  | -                                    | 鏡位螺旋                   |
| 20220616   | event 20201012 cn        | Sundered Blue                                | 复刻划破海空之翼           | Sundered Blue Rerun                                | 奔る彩帆の青（復刻）                 | -                          |
| 20220616   | event 20200820 cn        | Scherzo of Iron and Blood                    | -                          | -                                                  | -                                    | 復刻鐵血音符誓言           |
| 20220630   | raid 20210708            | Cross Wave                                   | -                          | -                                                  | -                                    | 復刻穿越彼方的水線         |
| 20220630   | raid 20220630            | Angel of Iris                                | 来自鸢尾的天使             | Angel of Iris                                      | アイリスの天使                       | -                          |
| 20220714   | event 20201029 cn        | Universe in Unison                           | -                          | -                                                  | -                                    | 激唱的UNIVERSE             |
| 20220714   | event 20200917 cn        | Dreamwaker's Butterfly                       | 复刻蝶海梦花               | Dreamwaker's Butterfly Rerun                       | 刹那觀る胡蝶の夢（復刻）             | -                          |
| 20220728   | event 20220728 cn        | Aquilifer's Ballade                          | 雄鹰的叙事歌               | Aquilifer's Ballade                                | 鋼鷲の冒険譚                         | -                          |
| 20220804   | event 20211028 cn        | Skybound Oratorio Rerun                      | -                          | -                                                  | -                                    | 復刻穹頂下的聖詠曲         |
| 20220818   | event 20220324 cn        | Virtual Tower                                | -                          | -                                                  | -                                    | 虛像構築之塔               |
| 20220818   | event 20220818 cn        | Operation Convergence                        | 远汇点作战                 | Operation Convergence                              | 結像点作戦                           | -                          |
| 20220901   | event 20200903 en        | Stars of the Shimmering Fjord                | -                          | -                                                  | -                                    | 復刻峽灣間的星辰           |
| 20220915   | event 20210916 cn        | Upon the Shimmering Blue                     | -                          | -                                                  | -                                    | 碧海光粼                   |
| 20220915   | event 20220915 cn        | Violet Tempest Blooming Lycoris              | 紫绛槿岚                   | Violet Tempest Blooming Lycoris                    | 赫の涙月 菫の暁風                    | -                          |
| 20221021   | event 20210121 cn        | Empyreal Tragicomedy                         | -                          | -                                                  | -                                    | 復刻神聖的悲喜劇           |
| 20221027   | raid 20221027            | Fight! Royal Maid                            | 战斗！皇家女仆队3rd        | Fight On, Royal Maids!(Part 3)                     | 戦え！ロイヤルメイド隊3rd            | -                          |
| 20221103   | event 20211111 cn        | The Flame-Touched Dagger                     | -                          | -                                                  | -                                    | 杰諾瓦的焰火               |
| 20221110   | event 20201229 cn        | Inverted Orthant                             | 复刻负象限作战             | Inverted Orthant Rerun                             | 虚畳なりし限象（復刻）               | -                          |
| 20221117   | event 20210325 cn        | Ashen Simulacrum                             | -                          | -                                                  | -                                    | 復刻箱庭療法               |
| 20221124   | event 20221124 cn        | The Alchemist and the Archipelago of Secrets | 炼金术士与秘密遗迹群岛     | The Alchemist and the Archipelago of Secrets       | 錬金術士と謎の遺跡群島               | -                          |
| 20221201   | event 20221124 cn        | The Alchemist and the Archipelago of Secrets | -                          | -                                                  | -                                    | 鍊金術士與秘密遺跡群島     |
| 20221222   | event 20221222 cn        | Parallel Superimposition                     | 定向折叠                   | Parallel Superimposition                           | 積重なる事象の幻界                   | -                          |
| 20221222   | event 20211229 cn        | Tower of Transcendence                       | -                          | -                                                  | -                                    | 逆轉彩虹之塔               |
| 20230105   | event 20210225 cn        | Khorovod of Dawn's Rime                      | 复刻破晓冰华               | Khorovod of Dawn's Rime Rerun                      | 暁射す氷華の嵐（復刻）               | -                          |
| 20230105   | event 20210610 tw        | The Way Home in the Night                    | -                          | -                                                  | -                                    | 復刻夜幕下的歸途           |
| 20230118   | raid 20230118            | Winter Pathfinder                            | 冬日的寻路人               | Winter Pathfinder                                  | 冬の案内人                           | -                          |
| 20230118   | raid 20220127            | -                                            | -                          | -                                                  | -                                    | 演習神秘事件調查           |
| 20230202   | event 20200806 cn        | The Enigma and the Shark                     | -                          | -                                                  | -                                    | 復刻最重要的寶物           |
| 20230216   | event 20220224 cn        | Abyssal Refrain                              | -                          | -                                                  | -                                    | 深度回音                   |
| 20230223   | event 20230223 cn        | Revelations of Dust                          | 湮烬尘墟                   | Revelations of Dust                                | 黙示の遺構                           | -                          |
| 20230309   | event 20210624 cn        | Swirling Cherry Blossoms                     | -                          | -                                                  | -                                    | 復刻-浮櫻影華              |
| 20230309   | event 20210422 cn        | Daedalian Hymn                               | 复刻复兴的赞美诗           | Daedalian Hymn Rerun                               | 讃える復興の迷路（復刻）             | -                          |
| 20230323   | raid 20220630            | Angel of Iris                                | -                          | -                                                  | -                                    | 來自鳶尾的天使             |
| 20230323   | coalition 20230323       | Frostfall                                    | 极地风暴                   | Frostfall                                          | 星霜海嵐                             | -                          |
| 20230413   | event 20211111 cn        | The Flame-Touched Dagger                     | 复刻杰诺瓦的焰火           | The Flame-Touched Dagger Rerun                     | 復刻-燈火のシニエ                    | -                          |
| 20230413   | event 20210819 cn        | Microlayer Medley                            | -                          | -                                                  | -                                    | 復刻-微層混合              |
| 20230427   | event 20201126 cn        | Vacation Lane                                | 假日航线                   | Vacation Lane                                      | バケーションレーン                   | 假日航線                   |
| 20230525   | event 20220526 cn        | Pledge of the Radiant Court                  | -                          | -                                                  | -                                    | 泠誓光庭                   |
| 20230525   | event 20230525 cn        | Confluence of Nothingness                    | 空相交汇点                 | Confluence of Nothingness                          | 覆天せし万象の塵                     | -                          |
| 20230615   | event 20200603 cn        | Counterattack Within the Fjord               | -                          | -                                                  | -                                    | 復刻峽灣間的反擊           |
| 20230621   | event 20210527 cn        | Mirror Involution Rerun                      | 复刻镜位螺旋               | Mirror Involution Rerun                            | 照らす螺旋の鏡海（復刻）             | -                          |
| 20230629   | event 20220428 cn        | Rondo at Rainbow's End                       | -                          | -                                                  | -                                    | 虹彩的終幕曲               |
| 20230629   | raid 20230629            | Reflections of the Oasis                     | 绿洲往事                   | Reflections of the Oasis                           | 緑地伽話                             | -                          |
| 20230713   | event 20220818 cn        | Operation Convergence                        | -                          | -                                                  | 結像点作戦                           | 遠匯點作戰                 |
| 20230720   | event 20211125 cn        | World-spanning Arclight                      | 复刻交汇世界的弧光         | World-spanning Arclight Rerun                      | 弧光は交わる世界にて（復刻）         | -                          |
| 20230727   | event 20200917 cn        | Dreamwaker's Butterfly                       | -                          | -                                                  | -                                    | 復刻-蝶海夢花              |
| 20230803   | event 20211125 cn        | World-spanning Arclight                      | -                          | -                                                  | -                                    | 復刻-交匯世界的弧光        |
| 20230803   | event 20230803 cn        | Anthem of Remembrance                        | 奏响鸢尾之歌               | Anthem of Remembrance                              | 燃ゆる聖都の回想曲                   | -                          |
| 20230817   | event 20230817 cn        | The Fool's Scales                            | 愚者的天平                 | The Fool's Scales                                  | 愚者の天秤                           | -                          |
| 20230817   | event 20220414 cn        | Aurora Noctis                                | -                          | -                                                  | -                                    | 復刻-永夜幻光              |
| 20230824   | coalition 20230323       | Frostfall                                    | -                          | -                                                  | -                                    | 極地風暴                   |
| 20230914   | event 20220915 cn        | Violet Tempest Blooming Lycoris              | -                          | -                                                  | -                                    | 紫絳槿嵐                   |
| 20230914   | event 20230914 cn        | Effulgence Before Eclipse                    | 须臾望月抄                 | Effulgence Before Eclipse                          | 須臾望月抄                           | -                          |
| 20231012   | event 20201229 cn        | Inverted Orthant                             | -                          | -                                                  | -                                    | 復刻-負象限作戰            |
| 20231019   | raid 20221027            | Fight! Royal Maid                            | -                          | -                                                  | -                                    | 戰鬥！皇家女僕隊3rd        |
| 20231026   | event 20231026 cn        | Tempesta and the Fountain of Youth           | 飓风与青春之泉             | Tempesta and the Fountain of Youth                 | テンペスタと若返りの泉               | -                          |
| 20231109   | event 20210916 cn        | Upon the Shimmering Blue                     | 复刻碧海光粼               | Upon the Shimmering Blue Rerun                     | 駆けよ 碧海の吹き風（復刻）          | -                          |
| 20231109   | event 20220728 cn        | Aquilifer's Ballade                          | -                          | -                                                  | -                                    | 雄鷹的敘事歌               |
| 20231123   | event 20220210 cn        | Northern Overture Rerun                      | -                          | -                                                  | -                                    | 復刻北境序曲               |
| 20231123   | event 20231123 cn        | The Ninja Scrolls: Azur Flash                | 苍闪忍法帖                 | The Ninja Scrolls: Azur Flash                      | 蒼閃忍法帖                           | -                          |
| 20231130   | event 20231123 cn        | The Ninja Scrolls: Azur Flash                | -                          | -                                                  | -                                    | 蒼閃忍法帖                 |
| 20221222   | event 20221222 cn        | Parallel Superimposition                     | -                          | -                                                  | -                                    | 定向折疊                   |
| 20231221   | event 20231221 cn        | Light-Chasing Sea of Stars                   | 星海逐光                   | Light-Chasing Sea of Stars                         | 光追う星の海                         | -                          |
| 20240104   | event 20210225 cn        | Khorovod of Dawn's Rime                      | -                          | -                                                  | -                                    | 復刻破曉冰華               |
| 20240111   | event 20211229 cn        | Tower of Transcendence                       | 复刻逆转彩虹之塔           | Tower of Transcendence Rerun                       | 遡望せし虹彩の塔（復刻）             | -                          |
| 20240111   | event 20230803 cn        | Anthem of Remembrance                        | -                          | -                                                  | -                                    | 奏響鳶尾之歌               |
| 20240125   | event 20210527 cn        | Mirror Involution Rerun                      | -                          | -                                                  | -                                    | 復刻鏡位螺旋               |
| 20240130   | raid 20240130            | Spring Festive Fiasco                        | 寰昌宇定家事忙             | Spring Festive Fiasco                              | 新春宴会狂騒曲                       | -                          |
| 20240206   | raid 20230118            | Winter Pathfinder                            | -                          | -                                                  | -                                    | 冬日的尋路人               |
| 20240229   | event 20230223 cn        | Revelations of Dust                          | -                          | -                                                  | -                                    | 湮燼塵墟                   |
| 20240229   | event 20240229 cn        | Snowrealm Peregrination                      | 雪境迷踪                   | Snowrealm Peregrination                            | 銀界遊廻                             | -                          |
| 20240314   | event 20210422 cn        | Daedalian Hymn                               | -                          | -                                                  | -                                    | 復刻復興的讚美詩           |
| 20240314   | event 20220324 cn        | Virtual Tower Rerun                          | 复刻虚像构筑之塔           | Virtual Tower Rerun                                | 幻像の塔（復刻）                     | -                          |
| 20240321   | raid 20230629            | Reflections of the Oasis                     | -                          | -                                                  | -                                    | 綠洲往事                   |
| 20240328   | raid 20240328            | From Zero to Hero                            | 从零开始的魔王讨伐之旅     | From Zero to Hero                                  | ゼロから頑張る魔王討伐               | -                          |
| 20240403   | event 20211111 cn        | The Flame-Touched Dagger                     | -                          | -                                                  | -                                    | 復刻杰諾瓦的焰火           |
| 20240411   | event 20220224 cn        | Abyssal Refrain                              | 复刻深度回音               | Abyssal Refrain Rerun                              | 鳴動せし星霜の淵（復刻）             | -                          |
| 20240425   | event 20230817 cn        | The Fool's Scales                            | -                          | -                                                  | -                                    | 愚者的天平                 |
| 20240425   | event 20240425 cn        | Heart-Linking Harmony                        | 共鸣的PASSION              | Heart-Linking Harmony                              | 共鳴のパッション                     | -                          |
| 20240509   | event 20210916 cn        | Upon the Shimmering Blue                     | -                          | -                                                  | -                                    | 復刻碧海光粼               |
| 20240521   | event 20240521 cn        | Light of the Martyrium                       | 绽放于辉光之城             | Light of the Martyrium                             | 赫輝のマルティリウム                 | -                          |
| 20240523   | event 20230525 cn        | Confluence of Nothingness                    | -                          | -                                                  | -                                    | 空相交會點                 |
| 20240613   | event 20201012 cn        | Sundered Blue                                | -                          | -                                                  | -                                    | 復刻劃破海空之翼           |
| 20240620   | event 20220428 cn        | Rondo at Rainbow's End                       | 复刻虹彩的终幕曲           | Rondo at Rainbow's End Rerun                       | 吟ずる瑠璃の楽章（復刻）             | -                          |
| 20240627   | event 20231026 cn        | Tempesta and the Fountain of Youth           | -                          | -                                                  | -                                    | 飓風與青春之泉             |
| 20240627   | coalition 20240627       | Welcome to Little Academy                    | 欢迎来到童心学院           | Welcome to Little Academy                          | リトル学園へようこそ                 | -                          |
| 20240711   | event 20211229 cn        | Tower of Transcendence                       | -                          | -                                                  | -                                    | 復刻逆轉彩虹之塔           |
| 20240718   | event 20220526 cn        | Pledge of the Radiant Court                  | 复刻泠誓光庭               | Pledge of the Radiant Court Rerun                  | 復刻诚閃の剣 搖光の城                | -                          |
| 20240725   | event 20240725 cn        | Interlude of Illusions                       | 幻梦间奏曲                 | Interlude of Illusions                             | 夢幻の間奏曲                         | -                          |
| 20240725   | raid 20240328            | From Zero to Hero                            | -                          | -                                                  | -                                    | 從零開始的魔王討伐之旅     |
| 20240815   | event 20240815 cn        | Windborne Steel Wings                        | 铁翼擎风                   | Windborne Steel Wings                              | 錬翼空翔                             | -                          |
| 20240815   | event 20240425 cn        | Heart-Linking Harmony                        | -                          | -                                                  | -                                    | 共鳴的PASSION              |
| 20240829   | event 20240829 cn        | Whence Flowers Bear No Fruit                 | 埋葬于彼岸之花             | Whence Flowers Bear No Fruit                       | 徒花咲かす彼岸                       | -                          |
| 20240829   | event 20220324 cn        | Virtual Tower                                | -                          | -                                                  | -                                    | 復刻虛像構築之塔           |
| 20240912   | event 20240912 cn        | Ode of Everblooming Crimson                  | 唤醒苍红之炎               | Ode of Everblooming Crimson                        | 絳染む丹華の詠歌                     | -                          |
| 20240919   | event 20230914 cn        | Effulgence Before Eclipse                    | -                          | -                                                  | -                                    | 須臾望月抄                 |
| 20241017   | event 20220728 cn        | Aquilifer's Ballade                          | 复刻雄鹰的叙事歌           | Aquilifer's Ballade Rerun                          | 鋼鷲の冒険譚（復刻）                 | -                          |
| 20241017   | coalition 20240627       | Welcome to Little Academy                    | -                          | -                                                  | -                                    | 歡迎來到童心學院           |
| 20241024   | event 20241024 cn        | Tempesta and the Sleeping Sea                | 飓风与沉眠之海             | Tempesta and the Sleeping Sea                      | テンペスタと眠りし海                 | -                          |
| 20241031   | event 20240829 cn        | Whence Flowers Bear No Fruit                 | -                          | -                                                  | -                                    | 埋葬於彼岸之花             |
| 20241114   | event 20220915 cn        | Violet Tempest Blooming Lycoris              | 复刻紫绛槿岚               | Violet Tempest Blooming Lycoris Rerun              | 赫の涙月 菫の暁風（復刻）            | -                          |
| 20241114   | event 20240229 cn        | Snowrealm Peregrination                      | -                          | -                                                  | -                                    | 雪境迷蹤                   |
| 20241121   | event 20241121 cn        | Dangerous Inventions Incoming                | 危险发明迫近中             | Dangerous Inventions Incoming                      | 危険発明接近中                       | -                          |
| 20241128   | event 20241121 cn        | Dangerous Inventions                         | -                          | -                                                  | -                                    | 危險發明逼近中             |
| 20241219   | event 20241219 cn        | Substellar Crepuscule                        | 星光下的余晖               | Substellar Crepuscule                              | 星降る夕影の残光                     | -                          |
| 20241219   | event 20231221 cn        | Light-Chasing Sea of Stars                   | -                          | -                                                  | -                                    | 星海逐光                   |
| 20250102   | raid 20240130            | Spring Festive Fiasco                        | -                          | -                                                  | -                                    | 寰昌宇定家事忙             |
| 20250109   | event 20221222 cn        | Parallel Superimposition                     | 复刻定向折叠               | Parallel Superimposition Rerun                     | 積重なる事象の幻界（復刻）           | -                          |
| 20250116   | raid 20250116            | Spring Fashion Festa                         | 华裳巧展喜事长             | Spring Fashion Festa                               | 新春華裳協奏曲                       | -                          |
| 20250123   | raid 20250116            | Spring Fashion Festa                         | -                          | -                                                  | -                                    | 華裳巧展喜事長             |
| 20250206   | event 20220818 cn        | Operation Convergence                        | 复刻远汇点作战             | Operation Convergence Return                       | 結像点作戦（復刻）                   | -                          |
| 20250213   | event 20240815 cn        | Windborne Steel Wings                        | -                          | -                                                  | -                                    | 鐵翼擎風                   |
| 20250227   | event 20250227 cn        | Paradiso of Shackled Light                   | 樊笼内的神光               | Paradiso of Shackled Light                         | 籠檻に囚われし神光                   | -                          |
| 20250227   | event 20240725 cn        | Interlude of Illusions                       | -                          | -                                                  | -                                    | 幻夢間奏曲                 |
| 20250320   | event 20230223 cn        | Revelations of Dust                          | 复刻湮烬尘墟               | Revelations of Dust Rerun                          | 黙示の遺構（復刻）                   | -                          |
| 20250320   | event 20240521 cn        | Light of the Martyrium                       | -                          | -                                                  | -                                    | 綻放於輝光之城             |
| 20250410   | event 20241024 cn        | Tempesta and the Sleeping Sea                | -                          | -                                                  | -                                    | 颶風與沉眠之海             |
| 20250417   | coalition 20230323       | Frostfall                                    | 极地风暴                   | Frostfall                                          | 星霜海嵐                             | -                          |
| 20250424   | event 20250424 cn        | Toward Tulipa’s Seas                         | 扬起郁金之旗               | Toward Tulipa’s Seas                               | チュリッパの海へ                     | -                          |
| 20250430   | event 20240912 cn        | Ode of Everblooming Crimson                  | -                          | -                                                  | -                                    | 喚醒蒼紅之炎               |
| 20250520   | event 20250520 cn        | A Rose on the High Tower                     | 高塔上的蔷薇               | A Rose on the High Tower                           | 高い塔の薔薇                         | -                          |
| 20250612   | event 20250520 cn        | A Rose on the High Tower                     | -                          | -                                                  | -                                    | 高塔上的薔薇               |
| 20250619   | event 20230525 cn        | Confluence of Nothingness                    | 复刻空相交汇点             | Confluence of Nothingness Rerun                    | 覆天せし万象の塵（復刻）             | -                          |
| 20250626   | coalition 20250626       | The Neon City Investigator                   | 迷彩都市的寻踪者           | The Neon City Investigator                         | ネオンシティの探索者                 | -                          |
| 20250703   | event 20250424 cn        | Toward Tulipa’s Seas                         | -                          | -                                                  | -                                    | 揚起鬱金之旗               |
| 20250724   | event 20241219 cn        | Substellar Crepuscule                        | -                          | -                                                  | -                                    | 星光下的餘暉               |
| 20250724   | event 20250724 cn        | The Alchemist and the Tower of Horizons      | 优米雅的炼金工房           | The Alchemist and the Tower of Horizons            | 錬金術士と天空邂逅の塔               | -                          |
| 20250726   | event 20221124 cn        | The Alchemist and the Archipelago of Secrets | 复刻炼金术士与秘密遗迹群岛 | The Alchemist and the Archipelago of Secrets Rerun | 錬金術士と謎の遺跡群島（復刻）       | -                          |
| 20250807   | event 20250724 cn        | The Alchemist and the Tower of Horizons      | -                          | -                                                  | -                                    | 鍊金術士與天際交會之塔     |
| 20250807   | event 20221124 cn        | The Alchemist and the Archipelago of Secrets | -                          | -                                                  | -                                    | 復刻鍊金術士與秘密遺跡群島 |
| 20250814   | event 20250814 cn        | Secrets of the Abyss                         | 奇渊下的秘密               | Secrets of the Abyss                               | 淵層界の秘密                         | -                          |
| 20250821   | event 20220224 cn        | Abyssal Refrain                              | -                          | -                                                  | -                                    | 復刻深度回音               |
| 20250828   | event 20250814 cn        | Secrets of the Abyss                         | -                          | -                                                  | -                                    | 奇淵下的秘密               |
| 20250912   | event 20250912 cn        | A Dance for Amahara Above                    | 起舞于天原之上             | A Dance for Amahara Above                          | アマハラに舞い奉れ                   | -                          |
| 20250919   | event 20250912 cn        | A Dance for Amahara Above                    | -                          | -                                                  | -                                    | 起舞於天原之上             |
| 20251009   | coalition 20250626       | The Neon City Investigator                   | -                          | -                                                  | -                                    | 迷彩都市的尋蹤者           |
| 20251016   | event 20230817 cn        | The Fool's Scales                            | 复刻愚者的天平             | The Fool's Scales Rerun                            | 愚者の天秤（復刻）                   | -                          |
| 20251023   | event 20251023 cn        | Tempesta and Islas de Libertád               | 飓风与自由群岛             | Tempesta and Islas de Libertád                     | テンペスタと自由群島                 | -                          |
| 20251106   | event 20230803 cn        | Anthem of Remembrance                        | 复刻奏响鸢尾之歌           | Anthem of Remembrance Rerun                        | 燃ゆる聖都の回想曲（復刻）           | -                          |
| 20251106   | event 20250227 cn        | Paradiso of Shackled Light                   | -                          | -                                                  | -                                    | 樊籠內的神光               |
| 20251113   | event 20230914 cn        | Effulgence Before Eclipse                    | 复刻须臾望月抄             | Effulgence Before Eclipse Rerun                    | 須臾望月抄（復刻）                   | -                          |
| 20251120   | coalition 20251120       | DATE A LANE                                  | DATE A LANE                | DATE A LANE                                        | DATE A LANE                          | -                          |
| 20251121   | event 20220428 cn        | Rondo at Rainbow's End                       | -                          | -                                                  | -                                    | 復刻虹彩的終幕曲           |
| 20251120   | coalition 20251120       | DATE A LANE                                  | DATE A LANE                | DATE A LANE                                        | DATE A LANE                          | -                          |
| 20251127   | coalition 20251120       | DATE A LANE                                  | -                          | -                                                  | -                                    | DATE A LANE                |
| 20251211   | event 20251023 cn        | Tempesta and Islas de Libertád               | -                          | -                                                  | -                                    | 颶風與自由群島             |
| 20251218   | event 20251218 cn        | A Note Through the Firmament                 | 响彻于天穹之音             | A Note Through the Firmament                       | 天穹に響く音謡                       | -                          |
| 20251231   | event 20251218 cn        | A Note Through the Firmament                 | -                          | -                                                  | -                                    | 響徹於天穹之音             |
