#!/usr/bin/env bun

const colors = await Bun.file(import.meta.dir + "/colors.txt").text()

const variables = []
for (const line of colors.split("\n")) {
  if (!line.trim()) continue
  const [variable] = line.trim().split(":")
  const name = variable!.trim().substring(2)
  variables.push(`--color-${name}: var(--${name});`)
}

const output = `
/* Generated by script/tailwind.ts */
/* Do not edit this file manually */

@theme {
  --color-*: initial;
  ${variables.join("\n  ")}
}
`

await Bun.file(import.meta.dir + "/../src/styles/tailwind/colors.css").write(output.trim())
