/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.wrapper;

import com.lx862.jcm.mapping.LoaderImpl;
import com.lx862.mtrscripting.wrapper.EntityWrapper;
import com.lx862.mtrscripting.wrapper.ItemStackWrapper;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.tool.HolderBase;

public class PlayerEntityWrapper
extends EntityWrapper {
    private final PlayerEntity playerEntity;

    public PlayerEntityWrapper(PlayerEntity player) {
        super(Entity.cast((HolderBase)player));
        this.playerEntity = player;
    }

    public String playerName() {
        return this.playerEntity.getGameProfile().getName();
    }

    public boolean isHoldingItem(Identifier id) {
        Item itm = LoaderImpl.getItemFromId(id);
        if (itm == null) {
            return false;
        }
        return this.playerEntity.isHolding(itm);
    }

    public ItemStackWrapper mainHandItem() {
        return new ItemStackWrapper(this.playerEntity.getMainHandStack());
    }

    public ItemStackWrapper offHandItem() {
        return new ItemStackWrapper(this.playerEntity.getOffHandStack());
    }

    public ItemStackWrapper activeItem() {
        ItemStackWrapper mainHandItem = this.mainHandItem();
        if (!mainHandItem.empty()) {
            return mainHandItem;
        }
        return this.offHandItem();
    }
}

