/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3f;

public class ScriptVector3f {
    public static final ScriptVector3f ZERO = new ScriptVector3f(0.0f, 0.0f, 0.0f);
    public static final ScriptVector3f XP = new ScriptVector3f(1.0f, 0.0f, 0.0f);
    public static final ScriptVector3f YP = new ScriptVector3f(0.0f, 1.0f, 0.0f);
    public static final ScriptVector3f ZP = new ScriptVector3f(0.0f, 0.0f, 1.0f);
    private Vector3d impl;

    public ScriptVector3f(Vector3d impl) {
        this.impl = impl;
    }

    public ScriptVector3f(float x, float y, float z) {
        this(new Vector3d((double)x, (double)y, (double)z));
    }

    public ScriptVector3f(Vector3f impl) {
        this(new Vector3d(impl));
    }

    public ScriptVector3f(BlockPos blockPos) {
        this(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public float x() {
        return (float)this.impl.getXMapped();
    }

    public float y() {
        return (float)this.impl.getYMapped();
    }

    public float z() {
        return (float)this.impl.getZMapped();
    }

    public ScriptVector3f copy() {
        Vector3d newImpl = new Vector3d((double)this.x(), (double)this.y(), (double)this.z());
        return new ScriptVector3f(newImpl);
    }

    public void normalize() {
        this.impl = this.impl.normalize();
    }

    public void add(float x, float y, float z) {
        this.impl = this.impl.add((double)x, (double)y, (double)z);
    }

    public void add(ScriptVector3f other) {
        this.impl = this.impl.add(other.impl);
    }

    public void sub(ScriptVector3f other) {
        this.impl = this.impl.subtract(other.impl);
    }

    public void mul(float x, float y, float z) {
        this.impl = this.impl.multiply((double)x, (double)y, (double)z);
    }

    public void mul(float n) {
        this.impl = this.impl.multiply((double)n);
    }

    public void rotX(float rad) {
        this.impl = this.impl.rotateX(rad);
    }

    public void rotY(float rad) {
        this.impl = this.impl.rotateY(rad);
    }

    public void rotZ(float rad) {
        this.impl = this.impl.rotateZ(rad);
    }

    public void cross(ScriptVector3f other) {
        this.impl = this.impl.crossProduct(other.impl);
    }

    public double distance(ScriptVector3f other) {
        double dx = this.x() - other.x();
        double dy = this.y() - other.y();
        double dz = this.z() - other.z();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceSq(ScriptVector3f other) {
        double dx = this.x() - other.x();
        double dy = this.y() - other.y();
        double dz = this.z() - other.z();
        return dx * dx + dy * dy + dz * dz;
    }

    @Deprecated
    public BlockPos toBlockPos() {
        return this.rawBlockPos();
    }

    public BlockPos rawBlockPos() {
        return new BlockPos((int)this.x(), (int)this.y(), (int)this.z());
    }

    public Vector3d rawVector3d() {
        return this.copy().impl;
    }

    public Vector3f rawVector3f() {
        return new Vector3f(this.x(), this.y(), this.z());
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptVector3f scriptVector3F = (ScriptVector3f)o;
        return this.impl.equals((Object)scriptVector3F.impl);
    }

    public String toString() {
        return "Vector3dWrapper[x=" + this.x() + ", y=" + this.y() + ", z=" + this.z() + "]";
    }
}

