/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr.sound;

import com.lx862.jcm.mod.scripting.mtr.sound.NonPositionedSoundCall;
import com.lx862.jcm.mod.scripting.mtr.sound.PositionedSoundCall;
import com.lx862.mtrscripting.api.ScriptResultCall;
import com.lx862.mtrscripting.util.ScriptVector3f;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.render.StoredMatrixTransformations;

public class ScriptSoundManager {
    public final List<ScriptResultCall> soundCalls = new ArrayList<ScriptResultCall>();

    public ScriptSoundManager() {
    }

    private ScriptSoundManager(List<ScriptResultCall> soundCalls) {
        this.soundCalls.addAll(soundCalls);
    }

    public void playLocalSound(Identifier id, float volume, float pitch) {
        this.soundCalls.add(new NonPositionedSoundCall(id, volume, pitch));
    }

    public void playSound(Identifier id, ScriptVector3f pos, float volume, float pitch) {
        this.soundCalls.add(new PositionedSoundCall(id, pos.x(), pos.y(), pos.z(), volume, pitch));
    }

    public void invoke(World world, ScriptVector3f basePos, GraphicsHolder graphicsHolder, StoredMatrixTransformations storedMatrixTransformations, Direction facing, int light) {
        for (ScriptResultCall soundCall : new ArrayList<ScriptResultCall>(this.soundCalls)) {
            soundCall.run(world, basePos, graphicsHolder, storedMatrixTransformations, facing, light);
        }
    }

    public ScriptSoundManager copy() {
        return new ScriptSoundManager(this.soundCalls);
    }

    public void reset() {
        this.soundCalls.clear();
    }
}

