/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.base;

import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.util.BlockUtil;
import java.util.List;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public abstract class Vertical3Block
extends DirectionalBlock {
    private static final int HEIGHT = 3;
    public static final EnumProperty<IBlock.EnumThird> THIRD = BlockProperties.VERTICAL_PART_3;

    public Vertical3Block(BlockSettings settings) {
        super(settings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return BlockUtil.isReplacable(ctx.getWorld(), ctx.getBlockPos(), Direction.UP, ctx, 3) ? super.getPlacementState2(ctx) : null;
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        world.setBlockState(pos.up(1), state.with(new Property((class_2769)Vertical3Block.THIRD.data), (Comparable)IBlock.EnumThird.MIDDLE));
        world.setBlockState(pos.up(2), state.with(new Property((class_2769)Vertical3Block.THIRD.data), (Comparable)IBlock.EnumThird.UPPER));
    }

    public void onBreak2(World world, BlockPos breakPos, BlockState breakState, PlayerEntity player) {
        this.breakWithoutDropIfCreative(world, breakPos, breakState, player, this, this::getLootDropPos);
        super.onBreak2(world, breakPos, breakState, player);
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (!BlockUtil.canSurvive(state.getBlock(), world, pos, Direction.UP, this.getPart((IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((class_2769)Vertical3Block.THIRD.data))), 3)) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)THIRD);
    }

    @Override
    public BlockPos[] getAllPos(BlockState state, World world, BlockPos pos) {
        switch ((IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((class_2769)Vertical3Block.THIRD.data))) {
            case LOWER: {
                return new BlockPos[]{pos, pos.up(), pos.up(2)};
            }
            case MIDDLE: {
                return new BlockPos[]{pos.down(), pos, pos.up()};
            }
            case UPPER: {
                return new BlockPos[]{pos.down(2), pos.down(), pos};
            }
        }
        return super.getAllPos(state, world, pos);
    }

    private BlockPos getLootDropPos(BlockState state, BlockPos pos) {
        switch ((IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)state, (Property)new Property((class_2769)Vertical3Block.THIRD.data))) {
            case LOWER: {
                return pos;
            }
            case MIDDLE: {
                return pos.down();
            }
            case UPPER: {
                return pos.down(2);
            }
        }
        return pos;
    }

    public int getPart(IBlock.EnumThird e) {
        if (e == IBlock.EnumThird.LOWER) {
            return 0;
        }
        if (e == IBlock.EnumThird.MIDDLE) {
            return 1;
        }
        return 2;
    }
}

