/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.util;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MtrVersion
implements Comparable<MtrVersion> {
    public final int[] parts;

    private MtrVersion(int[] parts) {
        this.parts = parts;
    }

    public static MtrVersion parse(String src) {
        int i2;
        ArrayList<Integer> parts = new ArrayList<Integer>();
        String[] strParts = src.split("-");
        int n = i2 = strParts.length > 1 ? 1 : 0;
        while (i2 < strParts.length) {
            String[] subParts;
            for (String subPart : subParts = strParts[i2].split("\\.")) {
                if (!subPart.matches("\\d+")) continue;
                parts.add(Integer.parseInt(subPart));
            }
            ++i2;
        }
        return new MtrVersion(parts.stream().mapToInt(i -> i).toArray());
    }

    @Override
    public int compareTo(@NotNull MtrVersion o) {
        for (int i = 0; i < Math.min(this.parts.length, o.parts.length); ++i) {
            if (this.parts[i] == o.parts[i]) continue;
            return Integer.compare(this.parts[i], o.parts[i]);
        }
        return Integer.compare(this.parts.length, o.parts.length);
    }

    public boolean matches(String criteria) {
        if (criteria.isEmpty()) {
            return false;
        }
        switch (criteria.charAt(0)) {
            case '=': {
                return this.compareTo(MtrVersion.parse(criteria.substring(1))) == 0;
            }
            case '>': {
                return this.compareTo(MtrVersion.parse(criteria.substring(1))) > 0;
            }
            case '<': {
                return this.compareTo(MtrVersion.parse(criteria.substring(1))) < 0;
            }
        }
        return this.compareTo(MtrVersion.parse(criteria)) >= 0;
    }
}

