/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io.network;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.io.FileProperty;
import cn.zbx1425.resourcepackupdater.io.ProgressReceiver;
import cn.zbx1425.resourcepackupdater.io.network.DownloadTask;
import cn.zbx1425.resourcepackupdater.io.network.ProgressOutputStream;
import cn.zbx1425.resourcepackupdater.util.MismatchingVersionException;
import cn.zbx1425.resourcepackupdater.util.MtrVersion;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class RemoteMetadata {
    public String baseUrl;
    public boolean encrypt = false;
    public List<String> dirs = new ArrayList<String>();
    public HashMap<String, FileProperty> files = new HashMap();
    public long downloadStartTime;
    public long downloadedBytes;

    public RemoteMetadata(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public byte[] fetchDirChecksum(ProgressReceiver cb) throws Exception {
        String metaString = this.httpGetString(this.baseUrl + "/metadata.sha1", cb);
        if (metaString.startsWith("{")) {
            JsonObject metadataObj = ResourcePackUpdater.JSON_PARSER.parse(metaString).getAsJsonObject();
            this.assertMetadataVersion(metadataObj);
            if (metadataObj.has("encrypt")) {
                this.encrypt = metadataObj.get("encrypt").getAsBoolean();
            }
            return Hex.decodeHex((char[])metadataObj.get("sha1").getAsString().toCharArray());
        }
        return Hex.decodeHex((char[])metaString.trim().toCharArray());
    }

    public void fetch(ProgressReceiver cb) throws Exception {
        this.dirs.clear();
        this.files.clear();
        JsonObject metadataObj = ResourcePackUpdater.JSON_PARSER.parse(this.httpGetString(this.baseUrl + "/metadata.json", cb)).getAsJsonObject();
        this.assertMetadataVersion(metadataObj);
        int metadataVersion = 1;
        if (metadataObj.has("version")) {
            metadataVersion = metadataObj.get("version").getAsInt();
        }
        if (metadataObj.has("encrypt")) {
            this.encrypt = metadataObj.get("encrypt").getAsBoolean();
        }
        if (metadataVersion == 1) {
            for (Map.Entry entry : metadataObj.get("dirs").getAsJsonObject().entrySet()) {
                this.dirs.add((String)entry.getKey());
            }
            for (Map.Entry entry : metadataObj.get("files").getAsJsonObject().entrySet()) {
                this.files.put((String)entry.getKey(), new FileProperty(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        } else if (metadataVersion == 2) {
            JsonObject contentObj = metadataObj.get("file_content").getAsJsonObject();
            for (Map.Entry entry : contentObj.get("dirs").getAsJsonObject().entrySet()) {
                this.dirs.add((String)entry.getKey());
            }
            for (Map.Entry entry : contentObj.get("files").getAsJsonObject().entrySet()) {
                this.files.put((String)entry.getKey(), new FileProperty(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        } else {
            throw new MismatchingVersionException("Unsupported metadata protocol version: " + metadataVersion);
        }
    }

    private String httpGetString(String urlStr, ProgressReceiver cb) throws IOException {
        URL url = new URL(urlStr);
        int retryCount = 0;
        int MAX_RETRIES = 3;
        while (true) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.urlToStream(url, 0L, bos, cb);
                String string = bos.toString(StandardCharsets.UTF_8);
                return string;
            }
            catch (IOException ex) {
                if (retryCount < 3) {
                    cb.printLog(ex.toString());
                    cb.printLog(String.format("Retrying (%d/%d) ...", ++retryCount, 3));
                    continue;
                }
                throw ex;
            }
            finally {
                bos.close();
                continue;
            }
            break;
        }
    }

    public void beginDownloads(ProgressReceiver cb) throws IOException {
        this.downloadStartTime = System.currentTimeMillis();
        this.downloadedBytes = 0L;
    }

    public void endDownloads(ProgressReceiver cb) throws IOException {
        long elapsedTimeSecs = (System.currentTimeMillis() - this.downloadStartTime) / 1000L;
        long speedKibPS = elapsedTimeSecs == 0L ? 0L : this.downloadedBytes / elapsedTimeSecs / 1024L;
        cb.setInfo("", String.format("%.2f MiB in %02d:%02d, Average speed %d KiB/s", Float.valueOf((float)this.downloadedBytes * 1.0f / 1024.0f / 1024.0f), elapsedTimeSecs / 60L, elapsedTimeSecs % 60L, speedKibPS));
    }

    private void urlToStream(URL url, long expectedSize, OutputStream target, final ProgressReceiver cb) throws IOException {
        URI requestUri;
        try {
            requestUri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        HttpResponse<InputStream> httpResponse = DownloadTask.sendHttpRequest(requestUri);
        final long fileSize = Long.parseLong(httpResponse.headers().firstValue("Content-Length").orElse(Long.toString(expectedSize)));
        long downloadedBytesBefore = this.downloadedBytes;
        try (BufferedOutputStream bos = new BufferedOutputStream(target);
             InputStream inputStream = DownloadTask.unwrapHttpResponse(httpResponse);){
            ProgressOutputStream pOfs = new ProgressOutputStream(bos, new ProgressOutputStream.WriteListener(){
                long lastAmount = -1L;
                final long noticeDivisor = 8192L;

                @Override
                public void registerWrite(long amountOfBytesWritten) throws IOException {
                    if (this.lastAmount / 8192L != amountOfBytesWritten / 8192L) {
                        RemoteMetadata.this.downloadedBytes += amountOfBytesWritten - this.lastAmount;
                        long elapsedTimeSecs = (System.currentTimeMillis() - RemoteMetadata.this.downloadStartTime) / 1000L;
                        if (fileSize > 0L) {
                            String message = String.format(": %5d KiB / %5d KiB; %5d KiB/s", amountOfBytesWritten / 1024L, fileSize / 1024L, elapsedTimeSecs == 0L ? 0L : RemoteMetadata.this.downloadedBytes / elapsedTimeSecs / 1024L);
                            cb.setProgress((float)amountOfBytesWritten * 1.0f / (float)fileSize, 0.0f);
                            cb.setInfo(String.format("%.2f%%", Float.valueOf((float)amountOfBytesWritten * 1.0f / (float)fileSize * 100.0f)), message);
                        } else {
                            String message = String.format(": %5d KiB downloaded; %5d KiB/s", amountOfBytesWritten / 1024L, elapsedTimeSecs == 0L ? 0L : RemoteMetadata.this.downloadedBytes / elapsedTimeSecs / 1024L);
                            cb.setProgress((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.0f);
                            cb.setInfo(String.format("%.2f%%", Float.valueOf((float)(System.currentTimeMillis() % 1000L) / 1000.0f * 100.0f)), message);
                        }
                        this.lastAmount = amountOfBytesWritten;
                    }
                }
            });
            IOUtils.copy((InputStream)new BufferedInputStream(inputStream), (OutputStream)pOfs);
        }
        catch (Exception ex) {
            this.downloadedBytes = downloadedBytesBefore;
            throw ex;
        }
        this.downloadedBytes = downloadedBytesBefore + fileSize;
    }

    public void assertMetadataVersion(JsonObject metadataObj) throws MismatchingVersionException {
        if (metadataObj.has("client_version")) {
            String requestedVer = metadataObj.get("client_version").getAsString();
            if (!MtrVersion.parse(ResourcePackUpdater.MOD_VERSION).matches(requestedVer)) {
                throw new MismatchingVersionException(requestedVer, ResourcePackUpdater.MOD_VERSION);
            }
        }
        int metadataVersion = 1;
        if (metadataObj.has("version")) {
            metadataVersion = metadataObj.get("version").getAsInt();
        }
        if (metadataVersion > 2) {
            throw new MismatchingVersionException("Unsupported metadata protocol version: " + metadataVersion);
        }
    }
}

