/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io.network;

import cn.zbx1425.resourcepackupdater.drm.AssetEncryption;
import cn.zbx1425.resourcepackupdater.io.HashCache;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class PackOutputStream
extends OutputStream {
    private final boolean encrypt;
    private final Path target;
    private final HashCache hashCache;
    private final byte[] expectedSha;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean closed = false;

    public PackOutputStream(Path target, boolean encrypt, HashCache hashCache, byte[] expectedSha) {
        this.encrypt = encrypt;
        this.target = target;
        this.expectedSha = expectedSha;
        this.hashCache = hashCache;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.encrypt) {
            AssetEncryption.writeEncrypted(this.buffer.toByteArray(), this.target.toFile());
        } else {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.target.toFile()));){
                bos.write(this.buffer.toByteArray());
            }
        }
        byte[] localSha = this.hashCache.getDigestNoCache(this.target.toFile());
        if (!Arrays.equals(localSha, this.expectedSha)) {
            throw new IOException("SHA1 mismatch: " + Hex.encodeHexString((byte[])localSha) + " downloaded, " + Hex.encodeHexString((byte[])this.expectedSha) + " expected");
        }
        super.close();
    }
}

