/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io;

import cn.zbx1425.resourcepackupdater.io.HashCache;
import cn.zbx1425.resourcepackupdater.io.ProgressReceiver;
import cn.zbx1425.resourcepackupdater.io.network.RemoteMetadata;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

public class LocalMetadata {
    public List<String> dirs = new ArrayList<String>();
    public HashMap<String, byte[]> files = new HashMap();
    public String baseDir;
    public HashCache hashCache;
    public final String HASH_CACHE_FILE_NAME = "updater_hash_cache.bin";

    public LocalMetadata(String baseDir) {
        this.baseDir = baseDir;
        this.hashCache = new HashCache(Paths.get(baseDir, new String[0]));
    }

    public void loadHashCache() throws Exception {
        this.hashCache.load(Path.of(this.baseDir, "updater_hash_cache.bin"));
    }

    public void scanDir(boolean shouldEncrypt, ProgressReceiver cb) throws Exception {
        this.loadHashCache();
        this.dirs.clear();
        this.files.clear();
        int filesScanned = 0;
        Path basePath = Paths.get(this.baseDir, new String[0]);
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            Files.createDirectories(basePath, new FileAttribute[0]);
        }
        try (Stream<Path> walkStream = Files.walk(basePath, new FileVisitOption[0]);){
            for (Path entry : walkStream.toList()) {
                String relPath = basePath.relativize(entry).toString().replace('\\', '/');
                if (relPath.equals("updater_hash_cache.bin")) continue;
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.dirs.add(relPath);
                    continue;
                }
                if (entry.getFileName().toString().toLowerCase(Locale.ROOT).equals("desktop.ini")) continue;
                if (++filesScanned % 200 == 0) {
                    cb.setProgress((float)filesScanned / (float)this.hashCache.entries.size(), 0.0f);
                    cb.setInfo(filesScanned + " / " + this.hashCache.entries.size(), "");
                }
                this.files.put(relPath, this.hashCache.getDigest(entry.toFile()));
            }
        }
        this.saveHashCache();
    }

    public void saveHashCache() throws IOException {
        this.hashCache.save(Path.of(this.baseDir, "updater_hash_cache.bin"));
    }

    public byte[] getDirChecksum() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)524288);
        this.dirs.stream().sorted().forEach(dir -> buf.writeCharSequence((CharSequence)dir, StandardCharsets.UTF_8));
        this.files.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            buf.writeCharSequence((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
            buf.writeBytes((byte[])entry.getValue());
        });
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        buf.capacity(buf.writerIndex());
        ByteArrayInputStream fis = new ByteArrayInputStream(buf.array());
        int n = 0;
        byte[] buffer = new byte[8192];
        while (n != -1) {
            n = fis.read(buffer);
            if (n <= 0) continue;
            digest.update(buffer, 0, n);
        }
        return digest.digest();
    }

    public List<String> getDirsToCreate(RemoteMetadata other) {
        return other.dirs.stream().filter(dir -> !this.dirs.contains(dir)).toList();
    }

    public List<String> getDirsToDelete(RemoteMetadata other) {
        return this.dirs.stream().filter(dir -> !other.dirs.contains(dir)).toList();
    }

    public List<String> getFilesToCreate(RemoteMetadata other) {
        return other.files.keySet().stream().filter(file -> !this.files.containsKey(file)).toList();
    }

    public List<String> getFilesToUpdate(RemoteMetadata other) {
        return this.files.entrySet().stream().filter(entry -> other.files.containsKey(entry.getKey()) && !Arrays.equals(other.files.get(entry.getKey()).hash, (byte[])entry.getValue())).map(Map.Entry::getKey).toList();
    }

    public List<String> getFilesToDelete(RemoteMetadata other) {
        return this.files.keySet().stream().filter(file -> !other.files.containsKey(file)).toList();
    }
}

