/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io;

import cn.zbx1425.resourcepackupdater.drm.AssetEncryption;
import cn.zbx1425.resourcepackupdater.io.FileProperty;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class HashCache {
    public HashMap<String, FileProperty> entries = new HashMap();
    public HashMap<String, FileProperty> entriesToSave = new HashMap();
    private final Path basePath;
    private boolean isDirty = false;

    public HashCache(Path basePath) {
        this.basePath = basePath;
    }

    public void load(Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return;
        }
        this.entries.clear();
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));){
            int version = stream.readInt();
            int entryCount = stream.readInt();
            for (int i = 0; i < entryCount; ++i) {
                int keyLength = stream.readInt();
                String key = new String(stream.readNBytes(keyLength));
                long mTime = stream.readLong();
                int hashLength = stream.readInt();
                byte[] hash = stream.readNBytes(hashLength);
                this.entries.put(key, new FileProperty(hash, mTime));
            }
        }
        this.isDirty = false;
    }

    public void save(Path file) throws IOException {
        if (!this.isDirty) {
            return;
        }
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));){
            stream.writeInt(1);
            stream.writeInt(this.entriesToSave.size());
            for (Map.Entry<String, FileProperty> entry : this.entriesToSave.entrySet()) {
                stream.writeInt(entry.getKey().length());
                stream.writeBytes(entry.getKey());
                stream.writeLong(entry.getValue().mTime);
                stream.writeInt(entry.getValue().hash.length);
                stream.write(entry.getValue().hash);
            }
        }
        this.isDirty = false;
    }

    public byte[] getDigest(File file) {
        byte[] hash;
        String key = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
        FileProperty entry = this.entries.getOrDefault(key, null);
        if (entry != null && entry.mTime == file.lastModified()) {
            this.entriesToSave.put(key, entry);
            return entry.hash;
        }
        try {
            hash = HashCache.calculateDigest(file);
        }
        catch (IOException ex) {
            hash = new byte[20];
        }
        entry = new FileProperty(hash, file.lastModified());
        this.entries.put(key, entry);
        this.entriesToSave.put(key, entry);
        this.isDirty = true;
        return hash;
    }

    public byte[] getDigestNoCache(File file) {
        byte[] hash;
        String key = this.basePath.relativize(file.toPath()).toString().replace('\\', '/');
        try {
            hash = HashCache.calculateDigest(file);
        }
        catch (IOException ex) {
            hash = new byte[20];
        }
        this.entries.put(key, new FileProperty(hash, file.lastModified()));
        this.isDirty = true;
        return hash;
    }

    public static byte[] calculateDigest(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = DigestUtils.sha1((InputStream)AssetEncryption.wrapInputStream(fis));
            return byArray;
        }
    }
}

