/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io;

import cn.zbx1425.resourcepackupdater.Config;
import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.gui.GlProgressScreen;
import cn.zbx1425.resourcepackupdater.gui.gl.GlHelper;
import cn.zbx1425.resourcepackupdater.io.LocalMetadata;
import cn.zbx1425.resourcepackupdater.io.ProgressReceiver;
import cn.zbx1425.resourcepackupdater.io.network.DownloadDispatcher;
import cn.zbx1425.resourcepackupdater.io.network.DownloadTask;
import cn.zbx1425.resourcepackupdater.io.network.PackOutputStream;
import cn.zbx1425.resourcepackupdater.io.network.RemoteMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;

public class Dispatcher {
    private RemoteMetadata remoteMetadata;
    private LocalMetadata localMetadata;

    public boolean runSync(String baseDir, Config.SourceProperty source, ProgressReceiver cb) throws Exception {
        try {
            if (source.baseUrl.isEmpty()) {
                throw new IOException("There is no source configured. Install the config file to your config folder!");
            }
            cb.printLog("Resource Pack Updater v" + ResourcePackUpdater.MOD_VERSION + " (C) Zbx1425, www.zbx1425.cn");
            cb.printLog("Server: " + source.baseUrl);
            cb.printLog("");
            this.localMetadata = new LocalMetadata(baseDir);
            this.remoteMetadata = new RemoteMetadata(source.baseUrl);
            byte[] remoteChecksum = null;
            if (source.hasDirHash) {
                cb.printLog("Downloading remote directory checksum ...");
                remoteChecksum = this.remoteMetadata.fetchDirChecksum(cb);
                cb.amendLastLog("Done");
                cb.printLog("Remote directory checksum is " + Hex.encodeHexString((byte[])remoteChecksum));
            } else {
                cb.printLog("This server does not have a directory checksum.");
                cb.printLog("Downloading remote metadata ...");
                this.remoteMetadata.fetch(cb);
                cb.amendLastLog("Done");
                cb.setProgress(0.0f, 0.0f);
            }
            cb.printLog("Scanning local files ...");
            this.localMetadata.scanDir(this.remoteMetadata.encrypt, cb);
            cb.amendLastLog("Done");
            byte[] localChecksum = this.localMetadata.getDirChecksum();
            cb.printLog("Local directory checksum is " + Hex.encodeHexString((byte[])localChecksum));
            if (this.localMetadata.files.size() < 1) {
                cb.printLog("The resource pack for the server is being downloaded.");
                cb.printLog("This is going to take a while. Sit back and relax!");
            }
            if (remoteChecksum != null) {
                if (Arrays.equals(localChecksum, remoteChecksum)) {
                    cb.printLog("All files are up to date.");
                    cb.setProgress(1.0f, 1.0f);
                    cb.printLog("");
                    cb.printLog("Done! Thank you.");
                    return true;
                }
                cb.printLog("Downloading remote metadata ...");
                this.remoteMetadata.fetch(cb);
                cb.amendLastLog("Done");
                cb.setProgress(0.0f, 0.0f);
            }
            List<String> dirsToCreate = this.localMetadata.getDirsToCreate(this.remoteMetadata);
            List<String> dirsToDelete = this.localMetadata.getDirsToDelete(this.remoteMetadata);
            List<String> filesToCreate = this.localMetadata.getFilesToCreate(this.remoteMetadata);
            List<String> filesToUpdate = this.localMetadata.getFilesToUpdate(this.remoteMetadata);
            List<String> filesToDelete = this.localMetadata.getFilesToDelete(this.remoteMetadata);
            cb.printLog(String.format("Found %-3d new directories, %-3d to delete.", dirsToCreate.size(), dirsToDelete.size()));
            cb.printLog(String.format("Found %-3d new files, %-3d to update, %-3d to delete.", filesToCreate.size(), filesToUpdate.size(), filesToDelete.size()));
            cb.printLog("Creating & deleting directories and files ...");
            for (String dir : dirsToCreate) {
                Files.createDirectories(Paths.get(baseDir, dir), new FileAttribute[0]);
            }
            for (String file : filesToDelete) {
                Files.deleteIfExists(Paths.get(baseDir, file));
            }
            for (String dir : dirsToDelete) {
                Path dirPath = Paths.get(baseDir, dir);
                if (!Files.isDirectory(dirPath, new LinkOption[0])) continue;
                FileUtils.deleteDirectory((File)dirPath.toFile());
            }
            cb.amendLastLog("Done");
            this.remoteMetadata.beginDownloads(cb);
            cb.printLog("Downloading files ... ");
            DownloadDispatcher downloadDispatcher = new DownloadDispatcher(cb);
            for (String file : Stream.concat(filesToCreate.stream(), filesToUpdate.stream()).toList()) {
                DownloadTask task = new DownloadTask(downloadDispatcher, this.remoteMetadata.baseUrl + "/dist/" + file, file, this.remoteMetadata.files.get((Object)file).size);
                downloadDispatcher.dispatch(task, () -> new PackOutputStream(Paths.get(baseDir, file), this.remoteMetadata.encrypt, this.localMetadata.hashCache, this.remoteMetadata.files.get((Object)file).hash));
            }
            while (!downloadDispatcher.tasksFinished()) {
                downloadDispatcher.updateSummary();
                ((GlProgressScreen)cb).redrawScreen(true);
                Thread.sleep(33L);
            }
            this.remoteMetadata.downloadedBytes += downloadDispatcher.downloadedBytes;
            downloadDispatcher.close();
            this.localMetadata.saveHashCache();
            cb.setInfo("", "");
            cb.setProgress(1.0f, 1.0f);
            cb.printLog("");
            this.remoteMetadata.endDownloads(cb);
            cb.printLog("Done! Thank you.");
            return true;
        }
        catch (GlHelper.MinecraftStoppingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cb.setException(ex);
            return false;
        }
    }
}

