/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.gui.gl;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;

public class SimpleFont {
    public final float lineHeight;
    public final float sheetWidth;
    public final float sheetHeight;
    public final float baseLineYPl;
    public final Char2ObjectMap<GlyphProperty> glyphMap = new Char2ObjectOpenHashMap();
    private static final char REPLACEMENT_CHAR = '\u25af';
    public final class_2960 textureLocation;
    public final float whiteU;
    public final float whiteV;
    public final float spaceWidthPl;

    public SimpleFont(class_2960 textureLocation) {
        JsonObject srcObj;
        this.textureLocation = textureLocation;
        class_2960 metadataLocation = new class_2960(textureLocation.method_12836(), textureLocation.method_12832().replace(".png", ".json"));
        try (InputStream metadataIs = this.getClass().getResourceAsStream("/assets/" + metadataLocation.method_12836() + "/" + metadataLocation.method_12832());){
            assert (metadataIs != null);
            srcObj = ResourcePackUpdater.JSON_PARSER.parse(IOUtils.toString((InputStream)metadataIs, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lineHeight = srcObj.get("size").getAsInt();
        this.sheetWidth = srcObj.get("width").getAsInt();
        this.sheetHeight = srcObj.get("height").getAsInt();
        JsonObject characterObj = srcObj.getAsJsonObject("characters");
        for (Map.Entry entry : characterObj.entrySet()) {
            char codePoint = ((String)entry.getKey()).charAt(0);
            this.glyphMap.put(codePoint, (Object)new GlyphProperty(((JsonElement)entry.getValue()).getAsJsonObject(), this));
        }
        this.baseLineYPl = -((GlyphProperty)this.glyphMap.get((char)'A')).offsetYPl;
        GlyphProperty whiteGlyph = (GlyphProperty)this.glyphMap.get('\u25a0');
        this.whiteU = (whiteGlyph.u1 + whiteGlyph.u2) / 2.0f;
        this.whiteV = (whiteGlyph.v1 + whiteGlyph.v2) / 2.0f;
        this.spaceWidthPl = ((GlyphProperty)this.glyphMap.get((char)' ')).advancePl;
    }

    public GlyphProperty getGlyph(char chr) {
        if (!this.glyphMap.containsKey(chr)) {
            return (GlyphProperty)this.glyphMap.get('\u25af');
        }
        return (GlyphProperty)this.glyphMap.get(chr);
    }

    public static class GlyphProperty {
        public final float u1;
        public final float v1;
        public final float u2;
        public final float v2;
        public final float widthPl;
        public final float heightPl;
        public final float offsetXPl;
        public final float offsetYPl;
        public final float advancePl;

        public GlyphProperty(JsonObject srcObj, SimpleFont font) {
            this.u1 = (float)srcObj.get("x").getAsInt() * 1.0f / font.sheetWidth;
            this.v1 = (float)srcObj.get("y").getAsInt() * 1.0f / font.sheetHeight;
            this.u2 = this.u1 + (float)srcObj.get("width").getAsInt() * 1.0f / font.sheetWidth;
            this.v2 = this.v1 + (float)srcObj.get("height").getAsInt() * 1.0f / font.sheetHeight;
            this.widthPl = (float)srcObj.get("width").getAsInt() * 1.0f / font.lineHeight;
            this.heightPl = (float)srcObj.get("height").getAsInt() * 1.0f / font.lineHeight;
            this.advancePl = (float)srcObj.get("advance").getAsInt() * 1.0f / font.lineHeight;
            this.offsetXPl = (float)(-srcObj.get("originX").getAsInt()) * 1.0f / font.lineHeight;
            this.offsetYPl = (float)(-srcObj.get("originY").getAsInt()) * 1.0f / font.lineHeight;
        }
    }
}

