/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.gui.gl;

import cn.zbx1425.resourcepackupdater.gui.gl.SimpleFont;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class GlHelper {
    private static class_5944 previousShader;
    private static Matrix4f lastProjectionMat;
    private static class_8251 lastVertexSorting;
    public static final class_2960 PRELOAD_FONT_TEXTURE;
    public static final SimpleFont preloadFont;
    private static class_287 bufferBuilder;

    public static void clearScreen(float r, float g, float b) {
        RenderSystem.clearColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
    }

    public static void initGlStates() {
        previousShader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_34426();
        RenderSystem.applyModelViewMatrix();
        lastProjectionMat = RenderSystem.getProjectionMatrix();
        lastVertexSorting = RenderSystem.getVertexSorting();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
    }

    public static void resetGlStates() {
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(() -> previousShader);
        RenderSystem.setProjectionMatrix((Matrix4f)lastProjectionMat, (class_8251)lastVertexSorting);
    }

    public static void begin(class_2960 texture) {
        bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        class_310.method_1551().method_1531().method_4619(texture).method_4527(true, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void end() {
        class_289.method_1348().method_1350();
    }

    public static void swapBuffer() throws MinecraftStoppingException {
        class_1041 window = class_310.method_1551().method_22683();
        if (window.method_22093()) {
            throw new MinecraftStoppingException();
        }
        window.method_15998();
    }

    public static void blit(float x1, float y1, float width, float height, float u1, float v1, float u2, float v2, int color) {
        float x2 = x1 + width;
        float y2 = y1 + height;
        GlHelper.withColor(bufferBuilder.method_22912((double)x1, (double)y1, 1.0).method_22913(u1, v1), color).method_1344();
        GlHelper.withColor(bufferBuilder.method_22912((double)x2, (double)y1, 1.0).method_22913(u2, v1), color).method_1344();
        GlHelper.withColor(bufferBuilder.method_22912((double)x2, (double)y2, 1.0).method_22913(u2, v2), color).method_1344();
        GlHelper.withColor(bufferBuilder.method_22912((double)x1, (double)y2, 1.0).method_22913(u1, v2), color).method_1344();
    }

    public static void blit(float x1, float y1, float width, float height, int color) {
        float x2 = x1 + width;
        float y2 = y1 + height;
        GlHelper.withColor(bufferBuilder.method_22912((double)x1, (double)y1, 1.0).method_22913(GlHelper.preloadFont.whiteU, GlHelper.preloadFont.whiteV), color).method_1344();
        GlHelper.withColor(bufferBuilder.method_22912((double)x2, (double)y1, 1.0).method_22913(GlHelper.preloadFont.whiteU, GlHelper.preloadFont.whiteV), color).method_1344();
        GlHelper.withColor(bufferBuilder.method_22912((double)x2, (double)y2, 1.0).method_22913(GlHelper.preloadFont.whiteU, GlHelper.preloadFont.whiteV), color).method_1344();
        GlHelper.withColor(bufferBuilder.method_22912((double)x1, (double)y2, 1.0).method_22913(GlHelper.preloadFont.whiteU, GlHelper.preloadFont.whiteV), color).method_1344();
    }

    public static void drawShadowString(float x1, float y1, float width, float height, float fontSize, String text, int color, boolean monospace, boolean noWrap) {
        GlHelper.drawString(x1 + fontSize / 16.0f, y1 + fontSize / 16.0f, width, height, fontSize, text, -14540254, monospace, noWrap);
        GlHelper.drawString(x1, y1, width, height, fontSize, text, color, monospace, noWrap);
    }

    public static void drawString(float x1, float y1, float width, float height, float fontSize, String text, int color, boolean monospace, boolean noWrap) {
        float CHAR_SPACING = 0.0f;
        float LINE_SPACING = 0.25f;
        float x = x1;
        float y = y1;
        for (char chr : text.toCharArray()) {
            if (chr == '\n') {
                y += fontSize + LINE_SPACING * fontSize;
                x = x1;
                continue;
            }
            if (chr == '\r') continue;
            if (chr == '\t') {
                float alignToPixels = (GlHelper.preloadFont.spaceWidthPl + CHAR_SPACING) * 8.0f * fontSize;
                x = (float)(Math.ceil((x - x1) / alignToPixels) * (double)alignToPixels + (double)x1);
                continue;
            }
            if (chr == ' ') {
                x += (GlHelper.preloadFont.spaceWidthPl + CHAR_SPACING) * fontSize;
                continue;
            }
            SimpleFont.GlyphProperty glyph = preloadFont.getGlyph(chr);
            float advance = glyph.advancePl * fontSize;
            if (x + advance + CHAR_SPACING * fontSize > x1 + width) {
                if (noWrap) continue;
                y += fontSize + LINE_SPACING * fontSize;
                x = x1;
            }
            if (y + fontSize > y1 + height) {
                return;
            }
            GlHelper.blit(x + glyph.offsetXPl * fontSize, y + (GlHelper.preloadFont.baseLineYPl + glyph.offsetYPl) * fontSize, glyph.widthPl * fontSize, glyph.heightPl * fontSize, glyph.u1, glyph.v1, glyph.u2, glyph.v2, color);
            x += advance + CHAR_SPACING * fontSize;
        }
    }

    public static float getStringWidth(String text, float fontSize) {
        float CHAR_SPACING = 0.0f;
        float width = 0.0f;
        float x = 0.0f;
        for (char chr : text.toCharArray()) {
            if (chr == '\n') {
                width = Math.max(width, x);
                x = 0.0f;
                continue;
            }
            if (chr == '\r') continue;
            if (chr == '\t') {
                float alignToPixels = (GlHelper.preloadFont.spaceWidthPl + CHAR_SPACING) * 8.0f * fontSize;
                x = (float)(Math.ceil(x / alignToPixels) * (double)alignToPixels);
                continue;
            }
            if (chr == ' ') {
                x += (GlHelper.preloadFont.spaceWidthPl + CHAR_SPACING) * fontSize;
                continue;
            }
            SimpleFont.GlyphProperty glyph = preloadFont.getGlyph(chr);
            x += glyph.advancePl * fontSize + CHAR_SPACING * fontSize;
        }
        return Math.max(width, x);
    }

    public static void setMatIdentity() {
        RenderSystem.getModelViewStack().method_34426();
    }

    public static void setMatPixel() {
        Matrix4f matrix = new Matrix4f();
        matrix.scale(2.0f, -2.0f, 1.0f);
        matrix.translate(-0.5f, -0.5f, 0.0f);
        float rawWidth = class_310.method_1551().method_22683().method_4489();
        float rawHeight = class_310.method_1551().method_22683().method_4506();
        matrix.scale(1.0f / rawWidth, 1.0f / rawHeight, 1.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (class_8251)class_8251.field_43361);
    }

    public static void setMatScaledPixel() {
        Matrix4f matrix = new Matrix4f();
        matrix.scale(2.0f, -2.0f, 1.0f);
        matrix.translate(-0.5f, -0.5f, 0.0f);
        matrix.scale(1.0f / (float)GlHelper.getWidth(), 1.0f / (float)GlHelper.getHeight(), 1.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (class_8251)class_8251.field_43361);
    }

    public static int getWidth() {
        int rawWidth = class_310.method_1551().method_22683().method_4489();
        if (rawWidth < 854) {
            return rawWidth;
        }
        if (rawWidth < 1920) {
            return (int)((float)(rawWidth - 854) * 1.0f / 1066.0f * 512.0f + 854.0f);
        }
        return 1366;
    }

    public static int getHeight() {
        int rawWidth = class_310.method_1551().method_22683().method_4489();
        int rawHeight = class_310.method_1551().method_22683().method_4506();
        return (int)((float)rawHeight * ((float)GlHelper.getWidth() * 1.0f / (float)rawWidth));
    }

    public static void setMatCenterForm(float width, float height, float widthPercent) {
        Matrix4f matrix = new Matrix4f();
        matrix.scale(2.0f, -2.0f, 1.0f);
        matrix.translate(-0.5f, -0.5f, 0.0f);
        float rawWidth = class_310.method_1551().method_22683().method_4489();
        float rawHeight = class_310.method_1551().method_22683().method_4506();
        matrix.scale(1.0f / rawWidth, 1.0f / rawHeight, 1.0f);
        float formRawWidth = rawWidth * widthPercent;
        float formRawHeight = height / width * formRawWidth;
        matrix.translate((rawWidth - formRawWidth) / 2.0f, (rawHeight - formRawHeight) / 2.0f, 0.0f);
        matrix.scale(formRawWidth / width, formRawHeight / height, 1.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix, (class_8251)class_8251.field_43361);
    }

    public static void enableScissor(float x, float y, float width, float height) {
        Matrix4f posMap = RenderSystem.getProjectionMatrix();
        Vector3f bottomLeft = posMap.transformPosition(new Vector3f(x, y + height, 0.0f));
        Vector3f topRight = posMap.transformPosition(new Vector3f(x + width, y, 0.0f));
        float x1 = class_3532.method_37959((float)bottomLeft.x, (float)-1.0f, (float)1.0f, (float)0.0f, (float)class_310.method_1551().method_22683().method_4489());
        float y1 = class_3532.method_37959((float)bottomLeft.y, (float)-1.0f, (float)1.0f, (float)0.0f, (float)class_310.method_1551().method_22683().method_4506());
        float x2 = class_3532.method_37959((float)topRight.x, (float)-1.0f, (float)1.0f, (float)0.0f, (float)class_310.method_1551().method_22683().method_4489());
        float y2 = class_3532.method_37959((float)topRight.y, (float)-1.0f, (float)1.0f, (float)0.0f, (float)class_310.method_1551().method_22683().method_4506());
        RenderSystem.enableScissor((int)((int)x1), (int)((int)y1), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    private static class_4588 withColor(class_4588 vc, int color) {
        int a = color >>> 24 & 0xFF;
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        return vc.method_1336(r, g, b, a);
    }

    static {
        PRELOAD_FONT_TEXTURE = new class_2960("resourcepackupdater", "textures/font/roboto.png");
        preloadFont = new SimpleFont(PRELOAD_FONT_TEXTURE);
    }

    public static class MinecraftStoppingException
    extends RuntimeException {
        public MinecraftStoppingException() {
            super("Minecraft is now stopping.");
        }
    }
}

