/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.gui;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.gui.forms.ExceptionForm;
import cn.zbx1425.resourcepackupdater.gui.forms.GlScreenForm;
import cn.zbx1425.resourcepackupdater.gui.forms.ProgressForm;
import cn.zbx1425.resourcepackupdater.gui.forms.SelectSourceForm;
import cn.zbx1425.resourcepackupdater.gui.gl.GlHelper;
import cn.zbx1425.resourcepackupdater.io.ProgressReceiver;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class GlProgressScreen
implements ProgressReceiver {
    private final SelectSourceForm selectSourceForm = new SelectSourceForm();
    private final ProgressForm progressForm = new ProgressForm();
    private final ExceptionForm exceptionForm = new ExceptionForm();
    private final List<GlScreenForm> forms = List.of(this.selectSourceForm, this.progressForm, this.exceptionForm);
    private GlScreenForm activeForm = this.progressForm;
    private boolean paused;
    public static final class_2960 PRELOAD_HEADER_TEXTURE = new class_2960("resourcepackupdater", "textures/gui/header.png");
    public static final class_2960 PRELOAD_BACKGROUND_TEXTURE = new class_2960("resourcepackupdater", "textures/gui/background.png");

    @Override
    public void printLog(String line) throws GlHelper.MinecraftStoppingException {
        for (GlScreenForm form : this.forms) {
            form.printLog(line);
        }
        ResourcePackUpdater.LOGGER.info(line);
        this.redrawScreen(true);
    }

    @Override
    public void amendLastLog(String postfix) throws GlHelper.MinecraftStoppingException {
        for (GlScreenForm form : this.forms) {
            form.amendLastLog(postfix);
        }
        this.redrawScreen(true);
    }

    @Override
    public void setProgress(float primary, float secondary) throws GlHelper.MinecraftStoppingException {
        for (GlScreenForm form : this.forms) {
            form.setProgress(primary, secondary);
        }
        this.redrawScreen(true);
    }

    @Override
    public void setInfo(String secondary, String textValue) throws GlHelper.MinecraftStoppingException {
        for (GlScreenForm form : this.forms) {
            form.setInfo(secondary, textValue);
        }
        this.redrawScreen(true);
    }

    @Override
    public void setException(Exception exception) throws GlHelper.MinecraftStoppingException {
        for (GlScreenForm form : this.forms) {
            form.setException(exception);
        }
        this.activeForm = this.exceptionForm;
        this.paused = true;
        ResourcePackUpdater.LOGGER.error("Resource Update Exception", (Throwable)exception);
    }

    public boolean shouldContinuePausing(boolean swap) throws GlHelper.MinecraftStoppingException {
        boolean bl = this.paused = this.paused && !this.activeForm.shouldStopPausing();
        if (this.paused) {
            this.redrawScreen(swap);
        }
        return this.paused;
    }

    public void reset() {
        for (GlScreenForm form : this.forms) {
            form.reset();
        }
        this.activeForm = this.progressForm;
        this.paused = false;
    }

    public void resetToSelectSource() {
        for (GlScreenForm form : this.forms) {
            form.reset();
        }
        this.activeForm = this.selectSourceForm;
        this.paused = true;
    }

    public void setToException() {
        this.activeForm = this.exceptionForm;
        this.paused = true;
    }

    public void redrawScreen(boolean swap) throws GlHelper.MinecraftStoppingException {
        GlHelper.clearScreen(1.0f, 0.0f, 1.0f);
        GlProgressScreen.drawBackground();
        this.activeForm.shouldStopPausing();
        this.activeForm.render();
        if (swap) {
            GlHelper.swapBuffer();
        }
    }

    private static void drawBackground() {
        GlHelper.setMatScaledPixel();
        GlHelper.begin(PRELOAD_BACKGROUND_TEXTURE);
        class_310.method_1551().method_1531().method_4619(PRELOAD_BACKGROUND_TEXTURE).method_4527(true, false);
        float bgScale = Math.max((float)GlHelper.getWidth() / 16.0f, (float)GlHelper.getHeight() / 9.0f);
        float bgW = 16.0f * bgScale;
        float bgH = 9.0f * bgScale;
        float bgX = ((float)GlHelper.getWidth() - bgW) / 2.0f;
        float bgY = ((float)GlHelper.getHeight() - bgH) / 2.0f;
        GlHelper.blit(bgX, bgY, bgW, bgH, 0.0f, 0.0f, 1.0f, 1.0f, -1);
        GlHelper.end();
        GlHelper.begin(GlHelper.PRELOAD_FONT_TEXTURE);
        GlHelper.drawShadowString(GlHelper.getWidth() - 10 - 80, GlHelper.getHeight() - 10 - 16, 80.0f, 20.0f, 16.0f, "v" + ResourcePackUpdater.MOD_VERSION, -256, false, true);
        GlHelper.end();
        GlHelper.begin(PRELOAD_HEADER_TEXTURE);
        float hdW = 512.0f;
        float hdH = hdW * 32.0f / 512.0f;
        GlHelper.blit(10.0f, (float)(GlHelper.getHeight() - 10) - hdH, hdW, hdH, 0.0f, 0.0f, 1.0f, 1.0f, -1);
        GlHelper.end();
    }
}

