/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.drm;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.drm.AssetEncryption;
import cn.zbx1425.resourcepackupdater.mappings.Text;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.apache.commons.io.IOUtils;

public class ServerLockRegistry {
    public static boolean lockAllSyncedPacks = true;
    private static String localServerLock;
    private static String remoteServerLock;
    private static String packAppliedServerLock;
    private static boolean serverLockPrefetched;

    public static void updateLocalServerLock(Path rpFolder) {
        if (lockAllSyncedPacks) {
            localServerLock = null;
            return;
        }
        try {
            JsonObject metaObj = ResourcePackUpdater.JSON_PARSER.parse(IOUtils.toString((InputStream)AssetEncryption.wrapInputStream(new FileInputStream(rpFolder.resolve("pack.mcmeta").toFile())), (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
            if (metaObj.has("zbx_rpu_server_lock")) {
                localServerLock = metaObj.get("zbx_rpu_server_lock").getAsString();
                if (!serverLockPrefetched) {
                    packAppliedServerLock = remoteServerLock = localServerLock;
                    ResourcePackUpdater.LOGGER.info("Server lock info prefetched from local pack.");
                    serverLockPrefetched = true;
                }
            } else {
                localServerLock = null;
            }
        }
        catch (Exception ignored) {
            localServerLock = null;
        }
    }

    public static boolean shouldRefuseProvidingFile(String resourcePath) {
        if (Objects.equals(resourcePath, "pack.mcmeta") || Objects.equals(resourcePath, "pack.png")) {
            return false;
        }
        if (lockAllSyncedPacks) {
            return true;
        }
        if (localServerLock == null) {
            return false;
        }
        return !Objects.equals(localServerLock, remoteServerLock);
    }

    public static void onLoginInitiated() {
        remoteServerLock = null;
    }

    public static void onSetServerLock(String serverLock) {
        remoteServerLock = serverLock;
    }

    public static void onAfterSetServerLock() {
        if (lockAllSyncedPacks) {
            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47585, (class_2561)Text.literal("\u540c\u6b65\u8cc7\u6e90\u5305\u4e0d\u5b8c\u6574\u800c\u672a\u88ab\u91c7\u7528"), (class_2561)Text.literal("\u60a8\u53ef\u6309 F3+T \u91cd\u8a66\u4e0b\u8f09\u3002\u5982\u6709\u932f\u8aa4\u8acb\u806f\u7d61\u7ba1\u7406\u4eba\u54e1\u3002")));
            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47585, (class_2561)Text.literal("Synced Resource Pack Incomplete and Thus not Used"), (class_2561)Text.literal("Press F3+T to download again. Ask the staff when error.")));
        }
        if (localServerLock == null) {
            ResourcePackUpdater.LOGGER.info("Asset coordination not required.");
        } else if (remoteServerLock == null) {
            ResourcePackUpdater.LOGGER.info("Asset coordination received no cooperation.");
        } else if (!remoteServerLock.equals(localServerLock)) {
            ResourcePackUpdater.LOGGER.info("Asset coordination received discrepancy.");
        } else if (lockAllSyncedPacks) {
            ResourcePackUpdater.LOGGER.info("Asset coordination is unavailable for incompleteness.");
        } else {
            ResourcePackUpdater.LOGGER.info("Asset coordination is applicable.");
        }
        if (localServerLock != null && !Objects.equals(packAppliedServerLock, remoteServerLock)) {
            packAppliedServerLock = remoteServerLock;
            class_310.method_1551().execute(() -> class_310.method_1551().method_1521());
        }
    }

    static {
        serverLockPrefetched = false;
    }
}

