/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.drm;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;

public class AssetEncryption {
    private static final byte[] HEADER_MAGIC = "ZBXNMB10".getBytes(StandardCharsets.UTF_8);

    public static boolean isFisEncrypted(FileInputStream fis) throws IOException {
        fis.getChannel().position(0L);
        boolean result = Arrays.equals(fis.readNBytes(HEADER_MAGIC.length), HEADER_MAGIC);
        if (!result) {
            fis.getChannel().position(0L);
        }
        return result;
    }

    public static InputStream wrapInputStream(FileInputStream fis) throws IOException {
        if (AssetEncryption.isFisEncrypted(fis)) {
            return AssetEncryption.decryptInputStream(fis);
        }
        return fis;
    }

    public static InputStream wrapInputStream(InputStream is) throws IOException {
        byte[] header = is.readNBytes(HEADER_MAGIC.length);
        if (header.length != HEADER_MAGIC.length) {
            return new ByteArrayInputStream(header);
        }
        if (!Arrays.equals(header, HEADER_MAGIC)) {
            return new SequenceInputStream(new ByteArrayInputStream(header), is);
        }
        return AssetEncryption.decryptInputStream(is);
    }

    private static InputStream decryptInputStream(InputStream is) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        DataInputStream dis = new DataInputStream(is);
        try {
            int versionMajor = dis.readInt();
            int versionMinor = dis.readInt();
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] key = dis.readNBytes(32);
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            byte[] iv = Arrays.copyOfRange(sha256.digest(key), 0, 16);
            IvParameterSpec aesIv = new IvParameterSpec(iv);
            int len = dis.readInt();
            byte[] eContent = dis.readNBytes(len);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)aesKey, aesIv);
            byte[] dContent = cipher.doFinal(eContent);
            byteArrayInputStream = new ByteArrayInputStream(dContent);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        dis.close();
        return byteArrayInputStream;
    }

    public static void writeEncrypted(byte[] src, File target) throws IOException {
        byte[] eContent;
        byte[] key;
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            key = keyGenerator.generateKey().getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            byte[] iv = Arrays.copyOfRange(sha256.digest(key), 0, 16);
            IvParameterSpec aesIv = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)aesKey, aesIv);
            eContent = cipher.doFinal(src);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));){
            DataOutputStream dos = new DataOutputStream(bos);
            dos.write("ZBXNMB10".getBytes(StandardCharsets.UTF_8));
            dos.writeInt(1);
            dos.writeInt(0);
            dos.write(key);
            dos.writeInt(eContent.length);
            dos.write(eContent);
        }
    }

    public static void encryptIfRaw(File target) throws IOException {
        byte[] src;
        try (FileInputStream fis = new FileInputStream(target);){
            if (AssetEncryption.isFisEncrypted(fis)) {
                return;
            }
            src = IOUtils.toByteArray((InputStream)fis);
        }
        AssetEncryption.writeEncrypted(src, target);
    }
}

