/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater;

import cn.zbx1425.resourcepackupdater.Config;
import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.drm.ServerLockRegistry;
import cn.zbx1425.resourcepackupdater.gui.GlProgressScreen;
import cn.zbx1425.resourcepackupdater.gui.gl.GlHelper;
import cn.zbx1425.resourcepackupdater.io.Dispatcher;
import cn.zbx1425.resourcepackupdater.io.network.DummyTrustManager;
import cn.zbx1425.resourcepackupdater.network.ClientVersionC2SPacket;
import cn.zbx1425.resourcepackupdater.network.ServerLockS2CPacket;
import java.io.IOException;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3283;

public class ResourcePackUpdaterClient
implements ClientModInitializer {
    public static final GlProgressScreen GL_PROGRESS_SCREEN = new GlProgressScreen();
    public static final HttpClient HTTP_CLIENT;

    public void onInitializeClient() {
        ClientConfigurationConnectionEvents.INIT.register((handler, client) -> ServerLockRegistry.onLoginInitiated());
        ClientConfigurationNetworking.registerGlobalReceiver(ServerLockS2CPacket.TYPE, (packet, sender) -> {
            ServerLockRegistry.onSetServerLock(packet.serverLockKey);
            sender.sendPacket((FabricPacket)new ClientVersionC2SPacket(ResourcePackUpdater.MOD_VERSION));
        });
        ClientConfigurationConnectionEvents.READY.register((handler, client) -> ServerLockRegistry.onAfterSetServerLock());
    }

    public static void dispatchSyncWork() {
        GlHelper.initGlStates();
        while (true) {
            Dispatcher syncDispatcher;
            block17: {
                syncDispatcher = new Dispatcher();
                if (ResourcePackUpdater.CONFIG.selectedSource.value == null || ((Config.SourceProperty)ResourcePackUpdater.CONFIG.selectedSource.value).baseUrl.isEmpty()) {
                    if (((List)ResourcePackUpdater.CONFIG.sourceList.value).size() > 1) {
                        GL_PROGRESS_SCREEN.resetToSelectSource();
                        try {
                            while (GL_PROGRESS_SCREEN.shouldContinuePausing(true)) {
                                Thread.sleep(50L);
                            }
                            break block17;
                        }
                        catch (GlHelper.MinecraftStoppingException ignored) {
                            ServerLockRegistry.lockAllSyncedPacks = true;
                            break;
                        }
                        catch (Exception ignored) {
                            break block17;
                        }
                    }
                    if (((List)ResourcePackUpdater.CONFIG.sourceList.value).size() == 1) {
                        ResourcePackUpdater.CONFIG.selectedSource.value = ((List)ResourcePackUpdater.CONFIG.sourceList.value).get(0);
                        ResourcePackUpdater.CONFIG.selectedSource.isFromLocal = true;
                    } else {
                        ResourcePackUpdater.CONFIG.selectedSource.value = new Config.SourceProperty("NOT CONFIGURED", "", false, false, true);
                    }
                }
            }
            GL_PROGRESS_SCREEN.reset();
            try {
                boolean syncSuccess = syncDispatcher.runSync(ResourcePackUpdater.CONFIG.getPackBaseDir(), (Config.SourceProperty)ResourcePackUpdater.CONFIG.selectedSource.value, GL_PROGRESS_SCREEN);
                ServerLockRegistry.lockAllSyncedPacks = !syncSuccess;
                class_310.method_1551().field_1690.method_1640();
                try {
                    ResourcePackUpdater.CONFIG.save();
                }
                catch (IOException iOException) {
                }
            }
            catch (GlHelper.MinecraftStoppingException ignored) {
                ServerLockRegistry.lockAllSyncedPacks = true;
                ResourcePackUpdater.CONFIG.selectedSource.value = new Config.SourceProperty("NOT CONFIGURED", "", false, false, true);
                if (((List)ResourcePackUpdater.CONFIG.sourceList.value).size() > 1) continue;
            }
            catch (Exception ignored) {
                ServerLockRegistry.lockAllSyncedPacks = true;
            }
            break;
        }
        try {
            while (GL_PROGRESS_SCREEN.shouldContinuePausing(true)) {
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerLockRegistry.updateLocalServerLock((Path)ResourcePackUpdater.CONFIG.packBaseDirFile.value);
        GlHelper.resetGlStates();
    }

    public static void modifyPackList() {
        class_315 options = class_310.method_1551().field_1690;
        String expectedEntry = "file/" + (String)ResourcePackUpdater.CONFIG.localPackName.value;
        options.field_1887.remove(expectedEntry);
        if (!options.field_1887.contains("vanilla")) {
            options.field_1887.add("vanilla");
        }
        if (!options.field_1887.contains("Fabric Mods")) {
            options.field_1887.add("Fabric Mods");
        }
        options.field_1887.add(expectedEntry);
        options.field_1846.remove(expectedEntry);
        class_3283 repository = class_310.method_1551().method_1520();
        repository.method_14445();
        options.method_1627(repository);
    }

    static {
        Properties props = System.getProperties();
        props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
        ExecutorService HTTP_CLIENT_EXECUTOR = Executors.newFixedThreadPool(4);
        HTTP_CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).executor(HTTP_CLIENT_EXECUTOR).sslContext(DummyTrustManager.UNSAFE_CONTEXT).build();
    }
}

