/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater;

import cn.zbx1425.resourcepackupdater.ResourcePackUpdater;
import cn.zbx1425.resourcepackupdater.ResourcePackUpdaterClient;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Config {
    public final ConfigItem<String> remoteConfigUrl = new ConfigItem<String>("remoteConfigUrl", JsonElement::getAsString, JsonPrimitive::new, "https://mc.zbx1425.cn/jlp-rp4/client_config.json");
    public final ConfigItem<List<SourceProperty>> sourceList = new ConfigItem("sources", json -> {
        ArrayList<SourceProperty> list = new ArrayList<SourceProperty>();
        for (JsonElement source : json.getAsJsonArray()) {
            list.add(new SourceProperty((JsonObject)source));
        }
        return list;
    }, value -> {
        JsonArray array = new JsonArray();
        for (SourceProperty source : value) {
            if (source.isBuiltin) continue;
            array.add((JsonElement)source.toJson());
        }
        return array;
    }, new ArrayList());
    public final ConfigItem<SourceProperty> selectedSource = new ConfigItem<SourceProperty>("selectedSource", json -> new SourceProperty((JsonObject)json), SourceProperty::toJson, () -> null);
    public final ConfigItem<String> localPackName = new ConfigItem<String>("localPackName", JsonElement::getAsString, JsonPrimitive::new, "SyncedPack");
    public final ConfigItem<Boolean> disableBuiltinSources = new ConfigItem<Boolean>("disableBuiltinSources", JsonElement::getAsBoolean, JsonPrimitive::new, false);
    public final ConfigItem<Boolean> pauseWhenSuccess = new ConfigItem<Boolean>("pauseWhenSuccess", JsonElement::getAsBoolean, JsonPrimitive::new, false);
    public final ConfigItem<Path> packBaseDirFile = new ConfigItem<Path>("packBaseDirFile", json -> Paths.get(json.getAsString(), new String[0]), value -> new JsonPrimitive(value.toString()), () -> Paths.get(this.getPackBaseDir(), new String[0]));
    public final ConfigItem<String> serverLockKey = new ConfigItem<String>("serverLockKey", JsonElement::getAsString, JsonPrimitive::new, "");
    public final ConfigItem<Boolean> clientEnforceInstall = new ConfigItem<Boolean>("clientEnforceInstall", JsonElement::getAsBoolean, JsonPrimitive::new, false);
    public final ConfigItem<String> clientEnforceVersion = new ConfigItem<String>("clientEnforceVersion", JsonElement::getAsString, JsonPrimitive::new, "");
    public List<ConfigItem<?>> configItems = List.of(this.remoteConfigUrl, this.sourceList, this.selectedSource, this.localPackName, this.disableBuiltinSources, this.pauseWhenSuccess, this.packBaseDirFile, this.serverLockKey, this.clientEnforceInstall, this.clientEnforceVersion);

    public void load() throws IOException {
        JsonObject remoteConfig;
        if (!Files.isRegularFile(this.getConfigFilePath(), new LinkOption[0])) {
            this.save();
        }
        JsonObject localConfig = (JsonObject)ResourcePackUpdater.JSON_PARSER.parse(Files.readString(this.getConfigFilePath()));
        this.remoteConfigUrl.load(localConfig, new JsonObject());
        if (((String)this.remoteConfigUrl.value).isEmpty()) {
            remoteConfig = new JsonObject();
        } else {
            try {
                HttpResponse<String> httpResponse;
                HttpRequest httpRequest = HttpRequest.newBuilder(new URI((String)this.remoteConfigUrl.value)).timeout(Duration.ofSeconds(10L)).setHeader("User-Agent", "ResourcePackUpdater/" + ResourcePackUpdater.MOD_VERSION + " +https://www.zbx1425.cn").setHeader("Accept-Encoding", "gzip").GET().build();
                try {
                    httpResponse = ResourcePackUpdaterClient.HTTP_CLIENT.send(httpRequest, HttpResponse.BodyHandlers.ofString());
                }
                catch (InterruptedException ex) {
                    throw new IOException(ex);
                }
                if (httpResponse.statusCode() != 200) {
                    throw new IOException("HTTP " + httpResponse.statusCode() + " " + httpResponse.body());
                }
                remoteConfig = (JsonObject)ResourcePackUpdater.JSON_PARSER.parse(httpResponse.body());
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        for (ConfigItem<?> item : this.configItems) {
            item.load(localConfig, remoteConfig);
        }
        if (this.remoteConfigUrl.isFromLocal && remoteConfig.has("remoteConfigUrl") && !remoteConfig.get("remoteConfigUrl").getAsString().equals(this.remoteConfigUrl.value)) {
            this.remoteConfigUrl.load(remoteConfig, remoteConfig);
            this.save();
        }
        if (!((Boolean)this.disableBuiltinSources.value).booleanValue()) {
            this.addBuiltinSources();
        }
        if (!((List)this.sourceList.value).contains(this.selectedSource.value)) {
            this.selectedSource.value = null;
        }
        if (this.selectedSource.value == null) {
            this.selectedSource.value = new SourceProperty("NOT CONFIGURED", "", false, false, true);
        }
    }

    public void save() throws IOException {
        JsonObject obj = new JsonObject();
        obj.addProperty("version", (Number)2);
        for (ConfigItem<?> item : this.configItems) {
            item.save(obj);
        }
        Files.writeString(this.getConfigFilePath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj), new OpenOption[0]);
    }

    private void addBuiltinSources() {
    }

    public String getPackBaseDir() {
        String sx = FabricLoader.getInstance().getGameDir().toString();
        return Paths.get(sx, "resourcepacks", (String)this.localPackName.value).toAbsolutePath().normalize().toString();
    }

    public Path getConfigFilePath() {
        return FabricLoader.getInstance().getConfigDir().resolve("resourcepackupdater.json");
    }

    public static class ConfigItem<T> {
        public T value;
        public boolean isFromLocal;
        private final String key;
        private final Function<JsonElement, T> fromCodec;
        private final Function<T, JsonElement> toCodec;
        private final Supplier<T> defaultSupplier;

        public ConfigItem(String key, Function<JsonElement, T> fromCodec, Function<T, JsonElement> toCodec, T defaultValue) {
            this.key = key;
            this.fromCodec = fromCodec;
            this.toCodec = toCodec;
            this.defaultSupplier = () -> defaultValue;
        }

        public ConfigItem(String key, Function<JsonElement, T> fromCodec, Function<T, JsonElement> toCodec, Supplier<T> defaultSupplier) {
            this.key = key;
            this.fromCodec = fromCodec;
            this.toCodec = toCodec;
            this.defaultSupplier = defaultSupplier;
        }

        public void load(JsonObject localObject, JsonObject remoteObject) {
            if (localObject.has("!" + this.key)) {
                this.value = this.fromCodec.apply(localObject.get("!" + this.key));
                this.isFromLocal = true;
            } else if (remoteObject.has(this.key)) {
                this.value = this.fromCodec.apply(remoteObject.get(this.key));
                this.isFromLocal = false;
            } else if (localObject.has(this.key)) {
                this.value = this.fromCodec.apply(localObject.get(this.key));
                this.isFromLocal = true;
            } else {
                this.value = this.defaultSupplier.get();
                this.isFromLocal = false;
            }
        }

        public void save(JsonObject jsonObject) {
            if (this.isFromLocal && this.value != null) {
                jsonObject.add(this.key, this.toCodec.apply(this.value));
            }
        }
    }

    public static class SourceProperty {
        public String name;
        public String baseUrl;
        public boolean hasDirHash;
        public boolean hasArchive;
        public boolean isBuiltin;

        public SourceProperty(String name, String baseUrl, boolean hasDirHash, boolean hasArchive, boolean isBuiltin) {
            this.name = name;
            this.baseUrl = baseUrl;
            this.hasDirHash = hasDirHash;
            this.hasArchive = hasArchive;
            this.isBuiltin = isBuiltin;
        }

        public SourceProperty(JsonObject obj) {
            this.name = obj.get("name").getAsString();
            this.baseUrl = obj.get("baseUrl").getAsString();
            this.hasDirHash = obj.get("hasDirHash").getAsBoolean();
            this.hasArchive = obj.get("hasArchive").getAsBoolean();
            this.isBuiltin = false;
        }

        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", this.name);
            obj.addProperty("baseUrl", this.baseUrl);
            obj.addProperty("hasDirHash", Boolean.valueOf(this.hasDirHash));
            obj.addProperty("hasArchive", Boolean.valueOf(this.hasArchive));
            return obj;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceProperty that = (SourceProperty)o;
            return new EqualsBuilder().append(this.hasDirHash, that.hasDirHash).append(this.hasArchive, that.hasArchive).append((Object)this.baseUrl, (Object)that.baseUrl).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.baseUrl).append(this.hasDirHash).append(this.hasArchive).toHashCode();
        }
    }
}

