/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import net.minecraft.class_1011;
import org.lwjgl.opengl.GL12C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;
import org.teacon.slides.Slideshow;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.TextureProvider;

public final class StaticTextureProvider
implements TextureProvider {
    private int mTexture;
    private final SlideRenderType mRenderType;
    private final int mWidth;
    private final int mHeight;

    public StaticTextureProvider(@Nonnull byte[] data) {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)data.length).put(data).rewind();
        try (class_1011 image = class_1011.method_4324((ByteBuffer)buffer);){
            this.mWidth = image.method_4307();
            this.mHeight = image.method_4323();
            if (this.mWidth > Integer.MAX_VALUE || this.mHeight > Integer.MAX_VALUE) {
                throw new IOException("Image is too big: " + this.mWidth + "x" + this.mHeight);
            }
            int maxLevel = Math.min(31 - Integer.numberOfLeadingZeros(Math.max(this.mWidth, this.mHeight)), 4);
            this.mTexture = GlStateManager._genTexture();
            GlStateManager._bindTexture((int)this.mTexture);
            GL12C.glTexParameteri((int)3553, (int)33082, (int)0);
            GL12C.glTexParameteri((int)3553, (int)33083, (int)maxLevel);
            GL12C.glTexParameteri((int)3553, (int)33084, (int)0);
            GL12C.glTexParameteri((int)3553, (int)33085, (int)maxLevel);
            GL12C.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            for (int level = 0; level <= maxLevel; ++level) {
                GL12C.glTexImage2D((int)3553, (int)level, (int)32856, (int)(this.mWidth >> level), (int)(this.mHeight >> level), (int)0, (int)6403, (int)5121, (IntBuffer)null);
            }
            GL12C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL12C.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL12C.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL12C.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL12C.glPixelStorei((int)3314, (int)0);
            GL12C.glPixelStorei((int)3316, (int)0);
            GL12C.glPixelStorei((int)3315, (int)0);
            GL12C.glPixelStorei((int)3317, (int)1);
            try (class_1011 class_10112 = image;){
                GL12C.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)6408, (int)5121, (long)image.field_4988);
            }
            GL30C.glGenerateMipmap((int)3553);
            this.mRenderType = new SlideRenderType(this.mTexture);
        }
        catch (Throwable t) {
            this.close();
            Slideshow.LOGGER.warn("Failed to generate texture", t);
            throw new CompletionException(t);
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    @Override
    @Nonnull
    public SlideRenderType updateAndGet(long tick, float partialTick) {
        return this.mRenderType;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public void close() {
        if (this.mTexture != 0) {
            GlStateManager._deleteTexture((int)this.mTexture);
        }
        this.mTexture = 0;
    }
}

