/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import org.mtr.core.data.Platform;
import org.mtr.core.data.Route;
import org.mtr.core.data.RoutePlatformData;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.SavedRailScreenBase;

public class PlatformScreen
extends SavedRailScreenBase<Platform, Station> {
    private static final MutableText DWELL_TIME_TEXT = TranslationProvider.GUI_MTR_DWELL_TIME.getMutableText(new Object[0]);
    private static final MutableText ROUTES_AT_PLATFORM_TEXT = TranslationProvider.GUI_MTR_ROUTES_AT_PLATFORM.getMutableText(new Object[0]);
    private final ObjectOpenHashSet<Route> routes = new ObjectOpenHashSet();

    public PlatformScreen(Platform savedRailBase, TransportMode transportMode, ScreenExtension previousScreenExtension) {
        super(savedRailBase, transportMode, previousScreenExtension, DWELL_TIME_TEXT, ROUTES_AT_PLATFORM_TEXT);
        for (Route route : MinecraftClientData.getDashboardInstance().routes) {
            for (RoutePlatformData routePlat : route.getRoutePlatforms()) {
                if (routePlat.getPlatform().getId() != savedRailBase.getId()) continue;
                this.routes.add(route);
            }
        }
    }

    @Override
    protected void init2() {
        super.init2();
        this.sliderDwellTimeMin.setY2(44);
        this.sliderDwellTimeMin.setValue((int)Math.floor((float)((Platform)this.savedRailBase).getDwellTime() / 1000.0f / 60.0f));
        this.sliderDwellTimeSec.setY2(54);
        this.sliderDwellTimeSec.setValue((int)(((Platform)this.savedRailBase).getDwellTime() / 500L % 120L));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        super.render(graphicsHolder, mouseX, mouseY, delta);
        if (this.showScheduleControls) {
            graphicsHolder.drawText(DWELL_TIME_TEXT, 20, 50, -1, false, GraphicsHolder.getDefaultLight());
        }
        graphicsHolder.drawText(ROUTES_AT_PLATFORM_TEXT, 20, 90, -1, false, GraphicsHolder.getDefaultLight());
        int i = 0;
        for (Route rts : this.routes) {
            graphicsHolder.drawText(IGui.formatStationName(rts.getName()), 20 + this.textWidth, 80 + 10 * i + 4 + 6, -16777216 + rts.getColor(), false, GraphicsHolder.getDefaultLight());
            ++i;
        }
    }

    @Override
    public void onClose2() {
        int minutes = this.sliderDwellTimeMin.getIntValue();
        float second = (float)this.sliderDwellTimeSec.getIntValue() / 2.0f;
        ((Platform)this.savedRailBase).setDwellTime((long)((second + (float)((long)minutes * 60L)) * 1000.0f));
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addPlatform((Platform)this.savedRailBase)));
        super.onClose2();
    }

    @Override
    protected TranslationProvider.TranslationHolder getNumberStringKey() {
        return TranslationProvider.GUI_MTR_PLATFORM_NUMBER;
    }
}

