/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.List;
import javax.annotation.Nullable;
import org.mtr.core.data.Depot;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.item.ItemCreativeDriverKey;
import org.mtr.mod.item.ItemDriverKey;

public final class ItemDepotDriverKey
extends ItemDriverKey {
    private static final String TAG_DEPOT_ID = "depot_id";
    private static final String TAG_EXPIRY_TIME = "expiry_time";

    public ItemDepotDriverKey(ItemSettings itemSettings, boolean canDrive, boolean canOpenDoors, boolean canBoardAnyVehicle, int color) {
        super(itemSettings, canDrive, canOpenDoors, canBoardAnyVehicle, color);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        if (ItemDepotDriverKey.isUsable(stack)) {
            long timeout2 = (stack.getOrCreateTag().getLong(TAG_EXPIRY_TIME) - System.currentTimeMillis()) / 1000L;
            long hours = timeout2 / 3600L;
            long minutes = timeout2 % 3600L / 60L;
            long seconds = timeout2 % 60L;
            tooltip.add(TranslationProvider.TOOLTIP_MTR_EXPIRES_IN.getMutableText(hours == 0L ? String.format("%02d:%02d", minutes, seconds) : String.format("%d:%02d:%02d", hours, minutes, seconds)).formatted(TextFormatting.GOLD));
        } else {
            tooltip.add(TranslationProvider.TOOLTIP_MTR_EXPIRED.getMutableText(new Object[0]).formatted(TextFormatting.RED));
        }
        super.addTooltips(stack, world, tooltip, options);
    }

    public static void setData(ItemStack itemStack, Depot depot, long timeout2) {
        if (itemStack.getItem().data instanceof ItemDepotDriverKey) {
            CompoundTag compoundTag = itemStack.getOrCreateTag();
            compoundTag.putLong(TAG_DEPOT_ID, depot.getId());
            compoundTag.putLong(TAG_EXPIRY_TIME, System.currentTimeMillis() + timeout2);
        }
    }

    public static boolean isCreativeDriverKeyOrMatchesDepot(ItemStack itemStack, long depotId) {
        return itemStack.getItem().data instanceof ItemCreativeDriverKey || ItemDepotDriverKey.isUsable(itemStack) && itemStack.getOrCreateTag().getLong(TAG_DEPOT_ID) == depotId;
    }

    private static boolean isUsable(ItemStack itemStack) {
        return itemStack.getItem().data instanceof ItemDepotDriverKey && itemStack.getOrCreateTag().getLong(TAG_EXPIRY_TIME) > System.currentTimeMillis();
    }
}

