/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import javax.annotation.Nonnull;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.block.BlockAPGDoor;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.BlockAPGGlassEnd;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPSDDoor;
import org.mtr.mod.block.BlockPSDGlass;
import org.mtr.mod.block.BlockPSDGlassEnd;
import org.mtr.mod.block.IBlock;

public interface PlatformHelper
extends DirectionHelper {
    public static final EnumProperty<EnumDoorType> DOOR_TYPE = EnumProperty.of("door_type", EnumDoorType.class);
    public static final IntegerProperty SIDE = IntegerProperty.of("side", 0, 4);

    public static BlockState getActualState(BlockView world, BlockPos pos, BlockState state) {
        int side;
        EnumDoorType doorType;
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        BlockState stateAbove = world.getBlockState(pos.up());
        Block blockAbove = stateAbove.getBlock();
        if (blockAbove.data instanceof BlockPSDDoor || blockAbove.data instanceof BlockPSDGlass || blockAbove.data instanceof BlockPSDGlassEnd) {
            doorType = EnumDoorType.PSD;
            facing = IBlock.getStatePropertySafe(stateAbove, FACING);
        } else if (blockAbove.data instanceof BlockAPGDoor || blockAbove.data instanceof BlockAPGGlass || blockAbove.data instanceof BlockAPGGlassEnd) {
            doorType = EnumDoorType.APG;
            facing = IBlock.getStatePropertySafe(stateAbove, FACING);
        } else {
            doorType = EnumDoorType.NONE;
        }
        boolean aboveIsDoor = blockAbove.data instanceof BlockPSDAPGDoorBase;
        BlockState stateLeftAbove = world.getBlockState(pos.up().offset(facing.rotateYCounterclockwise()));
        boolean leftAboveIsDoor = stateLeftAbove.getBlock().data instanceof BlockPSDAPGDoorBase;
        BlockState stateRightAbove = world.getBlockState(pos.up().offset(facing.rotateYClockwise()));
        boolean rightAboveIsDoor = stateRightAbove.getBlock().data instanceof BlockPSDAPGDoorBase;
        if (aboveIsDoor && rightAboveIsDoor) {
            side = 2;
        } else if (aboveIsDoor && leftAboveIsDoor) {
            side = 3;
        } else if (rightAboveIsDoor) {
            side = 1;
            facing = IBlock.getStatePropertySafe(stateRightAbove, FACING);
        } else if (leftAboveIsDoor) {
            side = 4;
            facing = IBlock.getStatePropertySafe(stateLeftAbove, FACING);
        } else {
            side = 0;
        }
        return state.with(new Property((class_2769)PlatformHelper.FACING.data), facing.data).with(new Property((class_2769)PlatformHelper.DOOR_TYPE.data), doorType).with(new Property((class_2769)PlatformHelper.SIDE.data), side);
    }

    public static enum EnumDoorType implements StringIdentifiable
    {
        NONE("none"),
        PSD("psd"),
        APG("apg");

        private final String name;

        private EnumDoorType(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

