/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public class BlockRubbishBin
extends BlockExtension
implements DirectionHelper {
    public static final int MAX_LEVEL = 15;
    public static final IntegerProperty FILLED = IntegerProperty.of("filled", 0, 15);

    public BlockRubbishBin(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new Property((class_2769)BlockRubbishBin.FACING.data), ctx.getPlayerFacing().data);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection(2.0, 0.0, 0.0, 14.0, 16.0, 4.5, Direction.convert((class_2350)state.get(new Property((class_2769)BlockRubbishBin.FACING.data))));
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> world.setBlockState(pos, state.with(new Property((class_2769)BlockRubbishBin.FILLED.data), 0)), () -> {
            int currentLevel = IBlock.getStatePropertySafe(state, FILLED);
            if (!player.getMainHandStack().isEmpty() && currentLevel < 15) {
                world.setBlockState(pos, state.with(new Property((class_2769)BlockRubbishBin.FILLED.data), currentLevel + 1));
                if (!player.isCreative()) {
                    player.getMainHandStack().decrement(1);
                }
            }
        });
    }

    @Override
    public void randomTick2(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int newLevel = IBlock.getStatePropertySafe(state, FILLED) - 1;
        if (newLevel >= 0) {
            world.setBlockState(pos, state.with(new Property((class_2769)BlockRubbishBin.FILLED.data), newLevel));
        }
    }

    @Override
    public boolean hasRandomTicks2(BlockState state) {
        return true;
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(FILLED);
    }
}

