/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.BlockDirectionalDoubleBlockBase;
import org.mtr.mod.block.IBlock;

public class BlockGlassFence
extends BlockDirectionalDoubleBlockBase {
    public static final IntegerProperty NUMBER = IntegerProperty.of("number", 1, 7);

    public BlockGlassFence() {
        super(Blocks.createDefaultBlockSettings(true).nonOpaque());
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 3.0, 3.0, facing);
        }
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 3.0, facing);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        return VoxelShapes.union(this.getOutlineShape2(state, world, pos, context), IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 8.0, 3.0, facing));
    }

    @Override
    @Nonnull
    public VoxelShape getCameraCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable("tooltip." + stack.getItem().getTranslationKey(), new Object[0]).formatted(TextFormatting.GRAY));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(NUMBER);
    }

    @Override
    protected BlockState getAdditionalState(BlockPos pos, Direction facing) {
        return this.getDefaultState2().with(new Property((class_2769)BlockGlassFence.NUMBER.data), BlockGlassFence.getNumber(pos, facing));
    }

    private static int getNumber(BlockPos pos, Direction facing) {
        int x = (pos.getX() % 7 + 7) % 7;
        int z = (pos.getZ() % 7 + 7) % 7;
        if (facing == Direction.NORTH || facing == Direction.EAST) {
            return (x + z) % 7 + 1;
        }
        return (-x - z) % 7 + 7;
    }
}

