/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.shader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;

public final class ModShaderHandler {
    private static InternalHandler internalHandler;
    private static final String IRIS_PREFIX = "net.irisshaders";
    private static final String IRIS_CLASS = "net.irisshaders.iris.api.v0.IrisApi";
    private static final String OPTIFINE_PREFIX = "net.optifine";
    private static final String OPTIFINE_CLASS = "net.optifine.shaders.Shaders";

    public static InternalHandler getInternalHandler() {
        if (internalHandler == null) {
            Class<?> ignored2;
            internalHandler = new InternalHandler();
            try {
                ignored2 = Class.forName(IRIS_CLASS);
                internalHandler = new Iris();
            }
            catch (Exception ignored2) {
                // empty catch block
            }
            try {
                ignored2 = Class.forName(OPTIFINE_CLASS);
                internalHandler = new Optifine();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return internalHandler;
    }

    public static boolean renderingShadows() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            String className = stackTraceElement.getClassName();
            if (!className.startsWith(IRIS_PREFIX) && !className.startsWith(OPTIFINE_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public static class InternalHandler {
        public boolean noShaderPackInUse() {
            return true;
        }
    }

    private static class Iris
    extends InternalHandler {
        private final BooleanSupplier shadersEnabledSupplier = Iris.createShadersEnabledSupplier();

        private Iris() {
        }

        @Override
        public boolean noShaderPackInUse() {
            return !this.shadersEnabledSupplier.getAsBoolean();
        }

        private static BooleanSupplier createShadersEnabledSupplier() {
            try {
                Class<?> irisApiClass = Class.forName(ModShaderHandler.IRIS_CLASS);
                Object irisApiInstance = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                Method fnIsShaderPackInUse = irisApiClass.getMethod("isShaderPackInUse", new Class[0]);
                return () -> {
                    try {
                        return (Boolean)fnIsShaderPackInUse.invoke(irisApiInstance, new Object[0]);
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }
    }

    private static class Optifine
    extends InternalHandler {
        private final BooleanSupplier shadersEnabledSupplier = Optifine.createShadersEnabledSupplier();

        private Optifine() {
        }

        @Override
        public boolean noShaderPackInUse() {
            return !this.shadersEnabledSupplier.getAsBoolean();
        }

        private static BooleanSupplier createShadersEnabledSupplier() {
            try {
                Class<?> ofShaders = Class.forName(ModShaderHandler.OPTIFINE_CLASS);
                Field field = ofShaders.getDeclaredField("activeProgramID");
                return () -> {
                    try {
                        return (Integer)field.get(null) != 0;
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }
    }
}

