/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.DummyClass;

public final class CommandBuilder<T extends ArgumentBuilder<class_2168, T>>
extends DummyClass {
    T argumentBuilder;

    CommandBuilder(T argumentBuilder) {
        this.argumentBuilder = argumentBuilder;
    }

    @MappedMethod
    public void permissionLevel(int permissionLevel) {
        this.argumentBuilder = this.argumentBuilder.requires(serverCommandSource -> serverCommandSource.method_9259(permissionLevel));
    }

    @MappedMethod
    public <U> void then(String argumentName, ArgumentType<U> argumentType, Consumer<CommandBuilder<?>> consumer) {
        CommandBuilder<RequiredArgumentBuilder> commandBuilder = new CommandBuilder<RequiredArgumentBuilder>(class_2170.method_9244((String)argumentName, argumentType));
        consumer.accept(commandBuilder);
        this.argumentBuilder = this.argumentBuilder.then(commandBuilder.argumentBuilder);
    }

    @MappedMethod
    public void then(String commandName, Consumer<CommandBuilder<?>> consumer) {
        CommandBuilder<LiteralArgumentBuilder> commandBuilder = new CommandBuilder<LiteralArgumentBuilder>(class_2170.method_9247((String)commandName));
        consumer.accept(commandBuilder);
        this.argumentBuilder = this.argumentBuilder.then(commandBuilder.argumentBuilder);
    }

    @MappedMethod
    public void executes(ToIntFunction<ContextHandler> execute2) {
        this.argumentBuilder = this.argumentBuilder.executes(context -> execute2.applyAsInt(new ContextHandler((CommandContext<class_2168>)context)));
    }

    public static class ContextHandler {
        private final CommandContext<class_2168> context;

        private ContextHandler(CommandContext<class_2168> context) {
            this.context = context;
        }

        @MappedMethod
        public boolean getBoolean(String argumentName) {
            return BoolArgumentType.getBool(this.context, (String)argumentName);
        }

        @MappedMethod
        public double getDouble(String argumentName) {
            return DoubleArgumentType.getDouble(this.context, (String)argumentName);
        }

        @MappedMethod
        public float getFloat(String argumentName) {
            return FloatArgumentType.getFloat(this.context, (String)argumentName);
        }

        @MappedMethod
        public int getInteger(String argumentName) {
            return IntegerArgumentType.getInteger(this.context, (String)argumentName);
        }

        @MappedMethod
        public long getLong(String argumentName) {
            return LongArgumentType.getLong(this.context, (String)argumentName);
        }

        @MappedMethod
        public String getString(String argumentName) {
            return StringArgumentType.getString(this.context, (String)argumentName);
        }

        @MappedMethod
        public void sendSuccess(String message, boolean broadcastToOps, Object ... translatableArguments) {
            ((class_2168)this.context.getSource()).method_9226(() -> class_2561.method_43469((String)message, (Object[])translatableArguments), broadcastToOps);
        }

        @MappedMethod
        public void sendFailure(String message, Object ... translatableArguments) {
            ((class_2168)this.context.getSource()).method_9213((class_2561)class_2561.method_43469((String)message, (Object[])translatableArguments));
        }

        @MappedMethod
        public MinecraftServer getServer() {
            return new MinecraftServer(((class_2168)this.context.getSource()).method_9211());
        }

        @MappedMethod
        public World getWorld() {
            return new World((class_1937)((class_2168)this.context.getSource()).method_9225());
        }

        @MappedMethod
        @Nullable
        public ServerPlayerEntity getServerPlayer() {
            class_3222 serverPlayerEntity = ((class_2168)this.context.getSource()).method_44023();
            return serverPlayerEntity == null ? null : new ServerPlayerEntity(serverPlayerEntity);
        }
    }
}

