/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.libraries.de.javagl.obj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.StringTokenizer;
import org.mtr.libraries.de.javagl.obj.Obj;
import org.mtr.libraries.de.javagl.obj.ObjFaceParser;
import org.mtr.libraries.de.javagl.obj.ObjFaces;
import org.mtr.libraries.de.javagl.obj.Objs;
import org.mtr.libraries.de.javagl.obj.Utils;
import org.mtr.libraries.de.javagl.obj.WritableObj;

public class ObjReader {
    public static Obj read(InputStream inputStream2) throws IOException {
        return ObjReader.read(inputStream2, Objs.create());
    }

    public static <T extends WritableObj> T read(InputStream inputStream2, T output) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2, StandardCharsets.US_ASCII));
        return ObjReader.readImpl(reader, output);
    }

    public static Obj read(Reader reader) throws IOException {
        return ObjReader.read(reader, Objs.create());
    }

    public static <T extends WritableObj> T read(Reader reader, T output) throws IOException {
        if (reader instanceof BufferedReader) {
            return ObjReader.readImpl((BufferedReader)reader, output);
        }
        return ObjReader.readImpl(new BufferedReader(reader), output);
    }

    private static <T extends WritableObj> T readImpl(BufferedReader reader, T output) throws IOException {
        String line;
        ObjFaceParser objFaceParser = new ObjFaceParser();
        String groupOrObject = "";
        int vertexCounter = 0;
        int texCoordCounter = 0;
        int normalCounter = 0;
        while ((line = reader.readLine()) != null) {
            String identifier;
            line = line.trim();
            boolean finished = false;
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 2);
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    finished = true;
                    break;
                }
                line = line + " " + nextLine;
            }
            if (finished) break;
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            switch (identifier = st.nextToken().toLowerCase()) {
                case "v": {
                    output.addVertex(Utils.readFloatTuple(st));
                    ++vertexCounter;
                    break;
                }
                case "vt": {
                    output.addTexCoord(Utils.readFloatTuple(st));
                    ++texCoordCounter;
                    break;
                }
                case "vn": {
                    output.addNormal(Utils.readFloatTuple(st));
                    ++normalCounter;
                    break;
                }
                case "mtllib": {
                    String s = line.substring(6).trim();
                    output.setMtlFileNames(Collections.singleton(s));
                    break;
                }
                case "usemtl": {
                    String materialGroupName = line.substring(6).trim();
                    output.setActiveMaterialGroupName(materialGroupName);
                    break;
                }
                case "g": 
                case "o": {
                    if (!groupOrObject.equals(identifier) && !groupOrObject.isEmpty()) break;
                    String s = line.substring(1).trim();
                    String[] groupNames = ObjReader.readStrings(s);
                    output.setActiveGroupNames(Arrays.asList(groupNames));
                    groupOrObject = identifier;
                    break;
                }
                case "f": {
                    objFaceParser.parse(line);
                    int[] v = objFaceParser.getVertexIndices();
                    int[] vt = objFaceParser.getTexCoordIndices();
                    int[] vn = objFaceParser.getNormalIndices();
                    ObjReader.makeIndicesAbsolute(v, vertexCounter);
                    ObjReader.makeIndicesAbsolute(vt, texCoordCounter);
                    ObjReader.makeIndicesAbsolute(vn, normalCounter);
                    output.addFace(ObjFaces.create(v, vt, vn));
                }
            }
        }
        return output;
    }

    private static void makeIndicesAbsolute(int[] array, int count) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < 0) {
                array[i] = count + array[i];
                continue;
            }
            int n = i;
            array[n] = array[n] - 1;
        }
    }

    private static String[] readStrings(String input) {
        StringTokenizer st = new StringTokenizer(input);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private ObjReader() {
    }
}

