

## 5.1 机器学习的基本任务

- 监督学习
    - 分类
    - 回归
    - 目标检测
    - 识别
- 无监督学习
    - 聚类
    - 降维
- 半监督学习
    - 自编码
    - 推荐
    - 生成式对抗
- 强化学习
    - 分类
    - 回归

## 5.2 机器学习的一般流程

0. 定义问题
1. 明确目标
2. 收集数据
3. 数据探索与预处理
4. 选择模型及损失函数
5. 评估及优化模型

## 5.3 过拟合与欠拟合

1. 权重正则化
2. Dropout正则化
3. Batch Normalization
4. 权重初始化

## 5.4 选择合适的**激活函数**

- sigmoid
表达式：$f(x)=\frac {1} {1+e^{-x}}$
导数：
- tanh
$f(x)=\frac {1-e^{-2x}} {1+e^{-2x}}$
>【注意】书中89页下边tanh公式写少写了个负号。
- relu
- LeakyReLU
- softmax

## 5.5 选择合适的**损失函数**
训练模型的过程实际就是优化损失函数的过程。

1. 分类问题——交叉熵（Cross Entropy)
交叉熵反应的是两个概率分布之间的距离。
交叉熵损失又称对数似然损失。


2. 回归问题——均方误差（Mean Sequared error, Mse）

## 5.6 选择合适优化器

### 5.6.1 传统梯度优化的不足
* 对超参数学习率比较敏感。
* 容易卡在鞍点上。

### 5.6.2 动量算法
动量（Momentum）算法：每下降一步由前面下降方向的一个累积和当前点的梯度方向 组合而成。
NAG算法：按照前面一小步位置 的超前梯度来做梯度合并。

### 5.6.3 AdaGrad 算法
能自动调整模型参数的学习率。

### 5.6.4 RMSProp 算法
超参数\rho$ 用来控制移动平均的长度范围。

### 5.6.5 Adam 算法
带有动量项的 RMSProp 算法


## 5.7 GPU加速
### 5.7.1 单GPU加速
* torch.cuda.is_available()             GPU是否可用。
* torch.cuda.device_count()             获得能够使用的GPU的数量
* to(device) .cuda()                    从内存转到GPU


### 5.7.2 多GPU加速
- 单机多GPU   DataParallel
- 多机多GPU   DistributedParallel

### 5.7.3 使用GPU注意事项
1. GPU数量尽量为偶数
2. 数据量小时多GPU未必更快。
3. 内存不够大，可设置pin_memory为false。



# 参考
《Python深度学习基于Pytorch》

