/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.tieredstore.common.SelectBufferResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final int MSG_ID_LENGTH = 16;
    public static final int MAGIC_CODE_POSITION = 4;
    public static final int QUEUE_OFFSET_POSITION = 20;
    public static final int PHYSICAL_OFFSET_POSITION = 28;
    public static final int SYS_FLAG_OFFSET_POSITION = 36;
    public static final int STORE_TIMESTAMP_POSITION = 56;
    public static final int STORE_HOST_POSITION = 64;
    public static final int COMMIT_LOG_CODA_SIZE = 16;
    public static final int BLANK_MAGIC_CODE = -875286124;
    public static final int CONSUME_QUEUE_UNIT_SIZE = 20;

    public static int getTotalSize(ByteBuffer message) {
        return message.getInt(message.position());
    }

    public static int getMagicCode(ByteBuffer message) {
        return message.getInt(message.position() + 4);
    }

    public static long getQueueOffset(ByteBuffer message) {
        return message.getLong(message.position() + 20);
    }

    public static long getCommitLogOffset(ByteBuffer message) {
        return message.getLong(message.position() + 28);
    }

    public static long getStoreTimeStamp(ByteBuffer message) {
        return message.getLong(message.position() + 56);
    }

    public static ByteBuffer getOffsetIdBuffer(ByteBuffer message) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(message.getLong(message.position() + 64));
        buffer.putLong(MessageFormatUtil.getCommitLogOffset(message));
        buffer.flip();
        return buffer;
    }

    public static String getOffsetId(ByteBuffer message) {
        return UtilAll.bytes2string((byte[])MessageFormatUtil.getOffsetIdBuffer(message).array());
    }

    public static Map<String, String> getProperties(ByteBuffer message) {
        return MessageDecoder.decodeProperties((ByteBuffer)message.slice());
    }

    public static long getCommitLogOffsetFromItem(ByteBuffer cqItem) {
        return cqItem.getLong(cqItem.position());
    }

    public static int getSizeFromItem(ByteBuffer cqItem) {
        return cqItem.getInt(cqItem.position() + 8);
    }

    public static long getTagCodeFromItem(ByteBuffer cqItem) {
        return cqItem.getLong(cqItem.position() + 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SelectBufferResult> splitMessageBuffer(ByteBuffer cqBuffer, ByteBuffer msgBuffer) {
        if (cqBuffer == null || msgBuffer == null) {
            log.error("MessageFormatUtil split buffer error, cq buffer or msg buffer is null");
            return new ArrayList<SelectBufferResult>();
        }
        cqBuffer.rewind();
        msgBuffer.rewind();
        ArrayList<SelectBufferResult> bufferResultList = new ArrayList<SelectBufferResult>(cqBuffer.remaining() / 20);
        if (msgBuffer.remaining() == 0) {
            log.error("MessageFormatUtil split buffer error, msg buffer length is 0");
            return bufferResultList;
        }
        if (cqBuffer.remaining() == 0 || cqBuffer.remaining() % 20 != 0) {
            log.error("MessageFormatUtil split buffer error, cq buffer size is {}", (Object)cqBuffer.remaining());
            return bufferResultList;
        }
        try {
            long firstCommitLogOffset = MessageFormatUtil.getCommitLogOffsetFromItem(cqBuffer);
            for (int position = cqBuffer.position(); position < cqBuffer.limit(); position += 20) {
                cqBuffer.position(position);
                long logOffset = MessageFormatUtil.getCommitLogOffsetFromItem(cqBuffer);
                int bufferSize = MessageFormatUtil.getSizeFromItem(cqBuffer);
                long tagCode = MessageFormatUtil.getTagCodeFromItem(cqBuffer);
                int offset = (int)(logOffset - firstCommitLogOffset);
                if (offset + bufferSize > msgBuffer.limit()) {
                    log.error("MessageFormatUtil split buffer error, message buffer offset exceeded limit. Expect length: {}, Actual length: {}", (Object)(offset + bufferSize), (Object)msgBuffer.limit());
                    break;
                }
                msgBuffer.position(offset);
                int magicCode = MessageFormatUtil.getMagicCode(msgBuffer);
                if (magicCode == -875286124) {
                    msgBuffer.position(offset += 16);
                    magicCode = MessageFormatUtil.getMagicCode(msgBuffer);
                }
                if (magicCode != -626843481 && magicCode != -626843477) {
                    log.error("MessageFormatUtil split buffer error, found unknown magic code. Message offset: {}, wrong magic code: {}", (Object)offset, (Object)magicCode);
                    continue;
                }
                if (bufferSize != MessageFormatUtil.getTotalSize(msgBuffer)) {
                    log.error("MessageFormatUtil split buffer error, message length not match. CommitLog length: {}, buffer length: {}", (Object)MessageFormatUtil.getTotalSize(msgBuffer), (Object)bufferSize);
                    continue;
                }
                ByteBuffer sliceBuffer = msgBuffer.slice();
                sliceBuffer.limit(bufferSize);
                bufferResultList.add(new SelectBufferResult(sliceBuffer, offset, bufferSize, tagCode));
            }
        }
        finally {
            cqBuffer.rewind();
            msgBuffer.rewind();
        }
        return bufferResultList;
    }
}

