/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.client;

import io.openmessaging.storage.dledger.ShutdownAbleThread;
import io.openmessaging.storage.dledger.client.DLedgerClientRpcNettyService;
import io.openmessaging.storage.dledger.client.DLedgerClientRpcService;
import io.openmessaging.storage.dledger.protocol.AppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.AppendEntryResponse;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.protocol.GetEntriesRequest;
import io.openmessaging.storage.dledger.protocol.GetEntriesResponse;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferRequest;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferResponse;
import io.openmessaging.storage.dledger.protocol.MetadataRequest;
import io.openmessaging.storage.dledger.protocol.MetadataResponse;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedgerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DLedgerClient.class);
    private final Map<String, String> peerMap = new ConcurrentHashMap<String, String>();
    private final String group;
    private String leaderId;
    private final DLedgerClientRpcService dLedgerClientRpcService;
    private final MetadataUpdater metadataUpdater = new MetadataUpdater("MetadataUpdater", LOGGER);

    public DLedgerClient(String group, String peers) {
        this.group = group;
        this.updatePeers(peers);
        this.dLedgerClientRpcService = new DLedgerClientRpcNettyService();
        this.dLedgerClientRpcService.updatePeers(peers);
        this.leaderId = this.peerMap.keySet().iterator().next();
    }

    public AppendEntryResponse append(byte[] body) {
        try {
            this.waitOnUpdatingMetadata(1500L, false);
            if (this.leaderId == null) {
                AppendEntryResponse appendEntryResponse = new AppendEntryResponse();
                appendEntryResponse.setCode(DLedgerResponseCode.METADATA_ERROR.getCode());
                return appendEntryResponse;
            }
            AppendEntryRequest appendEntryRequest = new AppendEntryRequest();
            appendEntryRequest.setGroup(this.group);
            appendEntryRequest.setRemoteId(this.leaderId);
            appendEntryRequest.setBody(body);
            AppendEntryResponse response = this.dLedgerClientRpcService.append(appendEntryRequest).get();
            if (response.getCode() == DLedgerResponseCode.NOT_LEADER.getCode()) {
                this.waitOnUpdatingMetadata(1500L, true);
                if (this.leaderId != null) {
                    appendEntryRequest.setRemoteId(this.leaderId);
                    response = this.dLedgerClientRpcService.append(appendEntryRequest).get();
                }
            }
            return response;
        }
        catch (Exception e) {
            this.needFreshMetadata();
            LOGGER.error("Append error", (Throwable)e);
            AppendEntryResponse appendEntryResponse = new AppendEntryResponse();
            appendEntryResponse.setCode(DLedgerResponseCode.INTERNAL_ERROR.getCode());
            return appendEntryResponse;
        }
    }

    public GetEntriesResponse get(long index) {
        try {
            this.waitOnUpdatingMetadata(1500L, false);
            if (this.leaderId == null) {
                GetEntriesResponse response = new GetEntriesResponse();
                response.setCode(DLedgerResponseCode.METADATA_ERROR.getCode());
                return response;
            }
            GetEntriesRequest request = new GetEntriesRequest();
            request.setGroup(this.group);
            request.setRemoteId(this.leaderId);
            request.setBeginIndex(index);
            GetEntriesResponse response = this.dLedgerClientRpcService.get(request).get();
            if (response.getCode() == DLedgerResponseCode.NOT_LEADER.getCode()) {
                this.waitOnUpdatingMetadata(1500L, true);
                if (this.leaderId != null) {
                    request.setRemoteId(this.leaderId);
                    response = this.dLedgerClientRpcService.get(request).get();
                }
            }
            return response;
        }
        catch (Exception t) {
            this.needFreshMetadata();
            LOGGER.error("", (Throwable)t);
            GetEntriesResponse getEntriesResponse = new GetEntriesResponse();
            getEntriesResponse.setCode(DLedgerResponseCode.INTERNAL_ERROR.getCode());
            return getEntriesResponse;
        }
    }

    public LeadershipTransferResponse leadershipTransfer(String curLeaderId, String transfereeId, long term) {
        try {
            LeadershipTransferRequest request = new LeadershipTransferRequest();
            request.setGroup(this.group);
            request.setRemoteId(curLeaderId);
            request.setTransferId(curLeaderId);
            request.setTransfereeId(transfereeId);
            request.setTerm(term);
            return this.dLedgerClientRpcService.leadershipTransfer(request).get();
        }
        catch (Exception t) {
            this.needFreshMetadata();
            LOGGER.error("leadershipTransfer to {} error", (Object)transfereeId, (Object)t);
            return new LeadershipTransferResponse().code(DLedgerResponseCode.INTERNAL_ERROR.getCode());
        }
    }

    public void startup() {
        this.dLedgerClientRpcService.startup();
        this.metadataUpdater.start();
    }

    public void shutdown() {
        this.dLedgerClientRpcService.shutdown();
        this.metadataUpdater.shutdown();
    }

    private void updatePeers(String peers) {
        for (String peerInfo : peers.split(";")) {
            String nodeId = peerInfo.split("-")[0];
            this.peerMap.put(nodeId, peerInfo.substring(nodeId.length() + 1));
        }
    }

    private synchronized void needFreshMetadata() {
        this.leaderId = null;
        this.metadataUpdater.wakeup();
    }

    private synchronized void waitOnUpdatingMetadata(long maxWaitMs, boolean needFresh) {
        if (needFresh) {
            this.leaderId = null;
        } else if (this.leaderId != null) {
            return;
        }
        long start = System.currentTimeMillis();
        while (DLedgerUtils.elapsed(start) < maxWaitMs && this.leaderId == null) {
            this.metadataUpdater.wakeup();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private class MetadataUpdater
    extends ShutdownAbleThread {
        public MetadataUpdater(String name, Logger logger) {
            super(name, logger);
        }

        private void getMetadata(String peerId, boolean isLeader) {
            try {
                MetadataRequest request = new MetadataRequest();
                request.setGroup(DLedgerClient.this.group);
                request.setRemoteId(peerId);
                CompletableFuture<MetadataResponse> future = DLedgerClient.this.dLedgerClientRpcService.metadata(request);
                MetadataResponse response = future.get(1500L, TimeUnit.MILLISECONDS);
                if (response.getLeaderId() != null) {
                    DLedgerClient.this.leaderId = response.getLeaderId();
                    if (response.getPeers() != null) {
                        DLedgerClient.this.peerMap.putAll(response.getPeers());
                        DLedgerClient.this.dLedgerClientRpcService.updatePeers(response.getPeers());
                    }
                }
            }
            catch (Throwable t) {
                if (isLeader) {
                    DLedgerClient.this.needFreshMetadata();
                }
                this.logger.warn("Get metadata failed from {}", (Object)peerId, (Object)t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doWork() {
            try {
                if (DLedgerClient.this.leaderId == null) {
                    for (String peer : DLedgerClient.this.peerMap.keySet()) {
                        this.getMetadata(peer, false);
                        if (DLedgerClient.this.leaderId == null) continue;
                        DLedgerClient dLedgerClient = DLedgerClient.this;
                        synchronized (dLedgerClient) {
                            DLedgerClient.this.notifyAll();
                        }
                        DLedgerUtils.sleep(1000L);
                        break;
                    }
                } else {
                    this.getMetadata(DLedgerClient.this.leaderId, true);
                }
                this.waitForRunning(3000L);
            }
            catch (Throwable t) {
                this.logger.error("Error", t);
                DLedgerUtils.sleep(1000L);
            }
        }
    }
}

