/*
 * Copyright 2019 Xilinx, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _AU_MATH_H_
#define _AU_MATH_H_

#include "ap_int.h"
#include "common/xf_common.hpp"
#include <assert.h>

#define XF_PI 3.14159265358979323846 // floating point pi value
#define XF_PI_FIXED 12867            // fixed point pi in Q4.12
#define XF_PI_BY_2_FIXED 6433        // fixed point pi/2 in Q4.12

#define DATA_SIZE 16 // Number of bits for x and y
#define LUT_BITS 11  // Look up table size = 2^LUT_BITS

namespace xf {
namespace cv {
// look up table for division which returns 32-bit values for high precision.
static unsigned int division_lut32[32768] = {
    131068, 131070, 131068, 131064, 131060, 131056, 131052, 131048, 131044, 131040, 131036, 131032, 131028, 131024,
    131020, 131016, 131012, 131008, 131004, 131000, 130996, 130992, 130988, 130984, 130980, 130976, 130972, 130968,
    130964, 130960, 130956, 130952, 130948, 130944, 130940, 130936, 130932, 130928, 130924, 130920, 130916, 130912,
    130908, 130904, 130900, 130896, 130892, 130888, 130884, 130880, 130876, 130872, 130868, 130864, 130860, 130856,
    130852, 130848, 130844, 130840, 130836, 130832, 130828, 130824, 130820, 130816, 130812, 130808, 130804, 130800,
    130796, 130792, 130788, 130784, 130780, 130776, 130772, 130768, 130764, 130760, 130756, 130752, 130748, 130744,
    130740, 130736, 130732, 130728, 130724, 130720, 130716, 130712, 130709, 130705, 130701, 130697, 130693, 130689,
    130685, 130681, 130677, 130673, 130669, 130665, 130661, 130657, 130653, 130649, 130645, 130641, 130637, 130633,
    130629, 130625, 130621, 130617, 130613, 130609, 130605, 130601, 130597, 130593, 130589, 130585, 130581, 130577,
    130573, 130569, 130565, 130561, 130558, 130554, 130550, 130546, 130542, 130538, 130534, 130530, 130526, 130522,
    130518, 130514, 130510, 130506, 130502, 130498, 130494, 130490, 130486, 130482, 130478, 130474, 130470, 130466,
    130462, 130458, 130454, 130450, 130446, 130443, 130439, 130435, 130431, 130427, 130423, 130419, 130415, 130411,
    130407, 130403, 130399, 130395, 130391, 130387, 130383, 130379, 130375, 130371, 130367, 130363, 130359, 130355,
    130351, 130348, 130344, 130340, 130336, 130332, 130328, 130324, 130320, 130316, 130312, 130308, 130304, 130300,
    130296, 130292, 130288, 130284, 130280, 130276, 130272, 130268, 130265, 130261, 130257, 130253, 130249, 130245,
    130241, 130237, 130233, 130229, 130225, 130221, 130217, 130213, 130209, 130205, 130201, 130197, 130193, 130189,
    130186, 130182, 130178, 130174, 130170, 130166, 130162, 130158, 130154, 130150, 130146, 130142, 130138, 130134,
    130130, 130126, 130122, 130118, 130115, 130111, 130107, 130103, 130099, 130095, 130091, 130087, 130083, 130079,
    130075, 130071, 130067, 130063, 130059, 130055, 130052, 130048, 130044, 130040, 130036, 130032, 130028, 130024,
    130020, 130016, 130012, 130008, 130004, 130000, 129996, 129992, 129989, 129985, 129981, 129977, 129973, 129969,
    129965, 129961, 129957, 129953, 129949, 129945, 129941, 129937, 129933, 129930, 129926, 129922, 129918, 129914,
    129910, 129906, 129902, 129898, 129894, 129890, 129886, 129882, 129878, 129875, 129871, 129867, 129863, 129859,
    129855, 129851, 129847, 129843, 129839, 129835, 129831, 129827, 129824, 129820, 129816, 129812, 129808, 129804,
    129800, 129796, 129792, 129788, 129784, 129780, 129776, 129773, 129769, 129765, 129761, 129757, 129753, 129749,
    129745, 129741, 129737, 129733, 129729, 129725, 129722, 129718, 129714, 129710, 129706, 129702, 129698, 129694,
    129690, 129686, 129682, 129678, 129675, 129671, 129667, 129663, 129659, 129655, 129651, 129647, 129643, 129639,
    129635, 129632, 129628, 129624, 129620, 129616, 129612, 129608, 129604, 129600, 129596, 129592, 129588, 129585,
    129581, 129577, 129573, 129569, 129565, 129561, 129557, 129553, 129549, 129545, 129542, 129538, 129534, 129530,
    129526, 129522, 129518, 129514, 129510, 129506, 129503, 129499, 129495, 129491, 129487, 129483, 129479, 129475,
    129471, 129467, 129463, 129460, 129456, 129452, 129448, 129444, 129440, 129436, 129432, 129428, 129424, 129421,
    129417, 129413, 129409, 129405, 129401, 129397, 129393, 129389, 129385, 129382, 129378, 129374, 129370, 129366,
    129362, 129358, 129354, 129350, 129347, 129343, 129339, 129335, 129331, 129327, 129323, 129319, 129315, 129311,
    129308, 129304, 129300, 129296, 129292, 129288, 129284, 129280, 129276, 129273, 129269, 129265, 129261, 129257,
    129253, 129249, 129245, 129241, 129238, 129234, 129230, 129226, 129222, 129218, 129214, 129210, 129206, 129203,
    129199, 129195, 129191, 129187, 129183, 129179, 129175, 129171, 129168, 129164, 129160, 129156, 129152, 129148,
    129144, 129140, 129136, 129133, 129129, 129125, 129121, 129117, 129113, 129109, 129105, 129102, 129098, 129094,
    129090, 129086, 129082, 129078, 129074, 129071, 129067, 129063, 129059, 129055, 129051, 129047, 129043, 129040,
    129036, 129032, 129028, 129024, 129020, 129016, 129012, 129008, 129005, 129001, 128997, 128993, 128989, 128985,
    128981, 128978, 128974, 128970, 128966, 128962, 128958, 128954, 128950, 128947, 128943, 128939, 128935, 128931,
    128927, 128923, 128919, 128916, 128912, 128908, 128904, 128900, 128896, 128892, 128888, 128885, 128881, 128877,
    128873, 128869, 128865, 128861, 128858, 128854, 128850, 128846, 128842, 128838, 128834, 128830, 128827, 128823,
    128819, 128815, 128811, 128807, 128803, 128800, 128796, 128792, 128788, 128784, 128780, 128776, 128773, 128769,
    128765, 128761, 128757, 128753, 128749, 128746, 128742, 128738, 128734, 128730, 128726, 128722, 128719, 128715,
    128711, 128707, 128703, 128699, 128695, 128692, 128688, 128684, 128680, 128676, 128672, 128668, 128665, 128661,
    128657, 128653, 128649, 128645, 128641, 128638, 128634, 128630, 128626, 128622, 128618, 128614, 128611, 128607,
    128603, 128599, 128595, 128591, 128587, 128584, 128580, 128576, 128572, 128568, 128564, 128561, 128557, 128553,
    128549, 128545, 128541, 128537, 128534, 128530, 128526, 128522, 128518, 128514, 128511, 128507, 128503, 128499,
    128495, 128491, 128487, 128484, 128480, 128476, 128472, 128468, 128464, 128461, 128457, 128453, 128449, 128445,
    128441, 128438, 128434, 128430, 128426, 128422, 128418, 128414, 128411, 128407, 128403, 128399, 128395, 128391,
    128388, 128384, 128380, 128376, 128372, 128368, 128365, 128361, 128357, 128353, 128349, 128345, 128342, 128338,
    128334, 128330, 128326, 128322, 128319, 128315, 128311, 128307, 128303, 128299, 128296, 128292, 128288, 128284,
    128280, 128276, 128273, 128269, 128265, 128261, 128257, 128253, 128250, 128246, 128242, 128238, 128234, 128230,
    128227, 128223, 128219, 128215, 128211, 128207, 128204, 128200, 128196, 128192, 128188, 128185, 128181, 128177,
    128173, 128169, 128165, 128162, 128158, 128154, 128150, 128146, 128142, 128139, 128135, 128131, 128127, 128123,
    128120, 128116, 128112, 128108, 128104, 128100, 128097, 128093, 128089, 128085, 128081, 128077, 128074, 128070,
    128066, 128062, 128058, 128055, 128051, 128047, 128043, 128039, 128035, 128032, 128028, 128024, 128020, 128016,
    128013, 128009, 128005, 128001, 127997, 127994, 127990, 127986, 127982, 127978, 127974, 127971, 127967, 127963,
    127959, 127955, 127952, 127948, 127944, 127940, 127936, 127933, 127929, 127925, 127921, 127917, 127913, 127910,
    127906, 127902, 127898, 127894, 127891, 127887, 127883, 127879, 127875, 127872, 127868, 127864, 127860, 127856,
    127853, 127849, 127845, 127841, 127837, 127834, 127830, 127826, 127822, 127818, 127814, 127811, 127807, 127803,
    127799, 127795, 127792, 127788, 127784, 127780, 127776, 127773, 127769, 127765, 127761, 127757, 127754, 127750,
    127746, 127742, 127738, 127735, 127731, 127727, 127723, 127719, 127716, 127712, 127708, 127704, 127700, 127697,
    127693, 127689, 127685, 127682, 127678, 127674, 127670, 127666, 127663, 127659, 127655, 127651, 127647, 127644,
    127640, 127636, 127632, 127628, 127625, 127621, 127617, 127613, 127609, 127606, 127602, 127598, 127594, 127590,
    127587, 127583, 127579, 127575, 127572, 127568, 127564, 127560, 127556, 127553, 127549, 127545, 127541, 127537,
    127534, 127530, 127526, 127522, 127518, 127515, 127511, 127507, 127503, 127500, 127496, 127492, 127488, 127484,
    127481, 127477, 127473, 127469, 127466, 127462, 127458, 127454, 127450, 127447, 127443, 127439, 127435, 127431,
    127428, 127424, 127420, 127416, 127413, 127409, 127405, 127401, 127397, 127394, 127390, 127386, 127382, 127379,
    127375, 127371, 127367, 127363, 127360, 127356, 127352, 127348, 127345, 127341, 127337, 127333, 127329, 127326,
    127322, 127318, 127314, 127311, 127307, 127303, 127299, 127296, 127292, 127288, 127284, 127280, 127277, 127273,
    127269, 127265, 127262, 127258, 127254, 127250, 127246, 127243, 127239, 127235, 127231, 127228, 127224, 127220,
    127216, 127213, 127209, 127205, 127201, 127197, 127194, 127190, 127186, 127182, 127179, 127175, 127171, 127167,
    127164, 127160, 127156, 127152, 127149, 127145, 127141, 127137, 127133, 127130, 127126, 127122, 127118, 127115,
    127111, 127107, 127103, 127100, 127096, 127092, 127088, 127085, 127081, 127077, 127073, 127070, 127066, 127062,
    127058, 127055, 127051, 127047, 127043, 127039, 127036, 127032, 127028, 127024, 127021, 127017, 127013, 127009,
    127006, 127002, 126998, 126994, 126991, 126987, 126983, 126979, 126976, 126972, 126968, 126964, 126961, 126957,
    126953, 126949, 126946, 126942, 126938, 126934, 126931, 126927, 126923, 126919, 126916, 126912, 126908, 126904,
    126901, 126897, 126893, 126889, 126886, 126882, 126878, 126874, 126871, 126867, 126863, 126859, 126856, 126852,
    126848, 126844, 126841, 126837, 126833, 126829, 126826, 126822, 126818, 126814, 126811, 126807, 126803, 126799,
    126796, 126792, 126788, 126784, 126781, 126777, 126773, 126769, 126766, 126762, 126758, 126755, 126751, 126747,
    126743, 126740, 126736, 126732, 126728, 126725, 126721, 126717, 126713, 126710, 126706, 126702, 126698, 126695,
    126691, 126687, 126683, 126680, 126676, 126672, 126669, 126665, 126661, 126657, 126654, 126650, 126646, 126642,
    126639, 126635, 126631, 126627, 126624, 126620, 126616, 126613, 126609, 126605, 126601, 126598, 126594, 126590,
    126586, 126583, 126579, 126575, 126571, 126568, 126564, 126560, 126557, 126553, 126549, 126545, 126542, 126538,
    126534, 126530, 126527, 126523, 126519, 126516, 126512, 126508, 126504, 126501, 126497, 126493, 126489, 126486,
    126482, 126478, 126475, 126471, 126467, 126463, 126460, 126456, 126452, 126449, 126445, 126441, 126437, 126434,
    126430, 126426, 126422, 126419, 126415, 126411, 126408, 126404, 126400, 126396, 126393, 126389, 126385, 126382,
    126378, 126374, 126370, 126367, 126363, 126359, 126356, 126352, 126348, 126344, 126341, 126337, 126333, 126330,
    126326, 126322, 126318, 126315, 126311, 126307, 126303, 126300, 126296, 126292, 126289, 126285, 126281, 126278,
    126274, 126270, 126266, 126263, 126259, 126255, 126252, 126248, 126244, 126240, 126237, 126233, 126229, 126226,
    126222, 126218, 126214, 126211, 126207, 126203, 126200, 126196, 126192, 126188, 126185, 126181, 126177, 126174,
    126170, 126166, 126163, 126159, 126155, 126151, 126148, 126144, 126140, 126137, 126133, 126129, 126125, 126122,
    126118, 126114, 126111, 126107, 126103, 126100, 126096, 126092, 126088, 126085, 126081, 126077, 126074, 126070,
    126066, 126063, 126059, 126055, 126051, 126048, 126044, 126040, 126037, 126033, 126029, 126026, 126022, 126018,
    126014, 126011, 126007, 126003, 126000, 125996, 125992, 125989, 125985, 125981, 125977, 125974, 125970, 125966,
    125963, 125959, 125955, 125952, 125948, 125944, 125941, 125937, 125933, 125929, 125926, 125922, 125918, 125915,
    125911, 125907, 125904, 125900, 125896, 125893, 125889, 125885, 125881, 125878, 125874, 125870, 125867, 125863,
    125859, 125856, 125852, 125848, 125845, 125841, 125837, 125834, 125830, 125826, 125822, 125819, 125815, 125811,
    125808, 125804, 125800, 125797, 125793, 125789, 125786, 125782, 125778, 125775, 125771, 125767, 125764, 125760,
    125756, 125752, 125749, 125745, 125741, 125738, 125734, 125730, 125727, 125723, 125719, 125716, 125712, 125708,
    125705, 125701, 125697, 125694, 125690, 125686, 125683, 125679, 125675, 125672, 125668, 125664, 125661, 125657,
    125653, 125649, 125646, 125642, 125638, 125635, 125631, 125627, 125624, 125620, 125616, 125613, 125609, 125605,
    125602, 125598, 125594, 125591, 125587, 125583, 125580, 125576, 125572, 125569, 125565, 125561, 125558, 125554,
    125550, 125547, 125543, 125539, 125536, 125532, 125528, 125525, 125521, 125517, 125514, 125510, 125506, 125503,
    125499, 125495, 125492, 125488, 125484, 125481, 125477, 125473, 125470, 125466, 125462, 125459, 125455, 125451,
    125448, 125444, 125440, 125437, 125433, 125429, 125426, 125422, 125418, 125415, 125411, 125407, 125404, 125400,
    125396, 125393, 125389, 125385, 125382, 125378, 125374, 125371, 125367, 125363, 125360, 125356, 125352, 125349,
    125345, 125341, 125338, 125334, 125330, 125327, 125323, 125320, 125316, 125312, 125309, 125305, 125301, 125298,
    125294, 125290, 125287, 125283, 125279, 125276, 125272, 125268, 125265, 125261, 125257, 125254, 125250, 125246,
    125243, 125239, 125235, 125232, 125228, 125225, 125221, 125217, 125214, 125210, 125206, 125203, 125199, 125195,
    125192, 125188, 125184, 125181, 125177, 125173, 125170, 125166, 125162, 125159, 125155, 125152, 125148, 125144,
    125141, 125137, 125133, 125130, 125126, 125122, 125119, 125115, 125111, 125108, 125104, 125100, 125097, 125093,
    125090, 125086, 125082, 125079, 125075, 125071, 125068, 125064, 125060, 125057, 125053, 125050, 125046, 125042,
    125039, 125035, 125031, 125028, 125024, 125020, 125017, 125013, 125009, 125006, 125002, 124999, 124995, 124991,
    124988, 124984, 124980, 124977, 124973, 124969, 124966, 124962, 124959, 124955, 124951, 124948, 124944, 124940,
    124937, 124933, 124929, 124926, 124922, 124919, 124915, 124911, 124908, 124904, 124900, 124897, 124893, 124890,
    124886, 124882, 124879, 124875, 124871, 124868, 124864, 124860, 124857, 124853, 124850, 124846, 124842, 124839,
    124835, 124831, 124828, 124824, 124821, 124817, 124813, 124810, 124806, 124802, 124799, 124795, 124792, 124788,
    124784, 124781, 124777, 124773, 124770, 124766, 124763, 124759, 124755, 124752, 124748, 124744, 124741, 124737,
    124734, 124730, 124726, 124723, 124719, 124715, 124712, 124708, 124705, 124701, 124697, 124694, 124690, 124686,
    124683, 124679, 124676, 124672, 124668, 124665, 124661, 124658, 124654, 124650, 124647, 124643, 124639, 124636,
    124632, 124629, 124625, 124621, 124618, 124614, 124611, 124607, 124603, 124600, 124596, 124592, 124589, 124585,
    124582, 124578, 124574, 124571, 124567, 124564, 124560, 124556, 124553, 124549, 124545, 124542, 124538, 124535,
    124531, 124527, 124524, 124520, 124517, 124513, 124509, 124506, 124502, 124499, 124495, 124491, 124488, 124484,
    124480, 124477, 124473, 124470, 124466, 124462, 124459, 124455, 124452, 124448, 124444, 124441, 124437, 124434,
    124430, 124426, 124423, 124419, 124416, 124412, 124408, 124405, 124401, 124398, 124394, 124390, 124387, 124383,
    124380, 124376, 124372, 124369, 124365, 124362, 124358, 124354, 124351, 124347, 124344, 124340, 124336, 124333,
    124329, 124326, 124322, 124318, 124315, 124311, 124308, 124304, 124300, 124297, 124293, 124290, 124286, 124282,
    124279, 124275, 124272, 124268, 124264, 124261, 124257, 124254, 124250, 124246, 124243, 124239, 124236, 124232,
    124228, 124225, 124221, 124218, 124214, 124210, 124207, 124203, 124200, 124196, 124193, 124189, 124185, 124182,
    124178, 124175, 124171, 124167, 124164, 124160, 124157, 124153, 124149, 124146, 124142, 124139, 124135, 124132,
    124128, 124124, 124121, 124117, 124114, 124110, 124106, 124103, 124099, 124096, 124092, 124088, 124085, 124081,
    124078, 124074, 124071, 124067, 124063, 124060, 124056, 124053, 124049, 124045, 124042, 124038, 124035, 124031,
    124028, 124024, 124020, 124017, 124013, 124010, 124006, 124002, 123999, 123995, 123992, 123988, 123985, 123981,
    123977, 123974, 123970, 123967, 123963, 123960, 123956, 123952, 123949, 123945, 123942, 123938, 123935, 123931,
    123927, 123924, 123920, 123917, 123913, 123909, 123906, 123902, 123899, 123895, 123892, 123888, 123884, 123881,
    123877, 123874, 123870, 123867, 123863, 123859, 123856, 123852, 123849, 123845, 123842, 123838, 123834, 123831,
    123827, 123824, 123820, 123817, 123813, 123809, 123806, 123802, 123799, 123795, 123792, 123788, 123784, 123781,
    123777, 123774, 123770, 123767, 123763, 123760, 123756, 123752, 123749, 123745, 123742, 123738, 123735, 123731,
    123727, 123724, 123720, 123717, 123713, 123710, 123706, 123702, 123699, 123695, 123692, 123688, 123685, 123681,
    123678, 123674, 123670, 123667, 123663, 123660, 123656, 123653, 123649, 123645, 123642, 123638, 123635, 123631,
    123628, 123624, 123621, 123617, 123613, 123610, 123606, 123603, 123599, 123596, 123592, 123589, 123585, 123581,
    123578, 123574, 123571, 123567, 123564, 123560, 123557, 123553, 123549, 123546, 123542, 123539, 123535, 123532,
    123528, 123525, 123521, 123517, 123514, 123510, 123507, 123503, 123500, 123496, 123493, 123489, 123486, 123482,
    123478, 123475, 123471, 123468, 123464, 123461, 123457, 123454, 123450, 123446, 123443, 123439, 123436, 123432,
    123429, 123425, 123422, 123418, 123415, 123411, 123407, 123404, 123400, 123397, 123393, 123390, 123386, 123383,
    123379, 123376, 123372, 123368, 123365, 123361, 123358, 123354, 123351, 123347, 123344, 123340, 123337, 123333,
    123330, 123326, 123322, 123319, 123315, 123312, 123308, 123305, 123301, 123298, 123294, 123291, 123287, 123283,
    123280, 123276, 123273, 123269, 123266, 123262, 123259, 123255, 123252, 123248, 123245, 123241, 123237, 123234,
    123230, 123227, 123223, 123220, 123216, 123213, 123209, 123206, 123202, 123199, 123195, 123192, 123188, 123184,
    123181, 123177, 123174, 123170, 123167, 123163, 123160, 123156, 123153, 123149, 123146, 123142, 123139, 123135,
    123132, 123128, 123124, 123121, 123117, 123114, 123110, 123107, 123103, 123100, 123096, 123093, 123089, 123086,
    123082, 123079, 123075, 123072, 123068, 123064, 123061, 123057, 123054, 123050, 123047, 123043, 123040, 123036,
    123033, 123029, 123026, 123022, 123019, 123015, 123012, 123008, 123005, 123001, 122998, 122994, 122990, 122987,
    122983, 122980, 122976, 122973, 122969, 122966, 122962, 122959, 122955, 122952, 122948, 122945, 122941, 122938,
    122934, 122931, 122927, 122924, 122920, 122917, 122913, 122910, 122906, 122902, 122899, 122895, 122892, 122888,
    122885, 122881, 122878, 122874, 122871, 122867, 122864, 122860, 122857, 122853, 122850, 122846, 122843, 122839,
    122836, 122832, 122829, 122825, 122822, 122818, 122815, 122811, 122808, 122804, 122801, 122797, 122794, 122790,
    122787, 122783, 122780, 122776, 122772, 122769, 122765, 122762, 122758, 122755, 122751, 122748, 122744, 122741,
    122737, 122734, 122730, 122727, 122723, 122720, 122716, 122713, 122709, 122706, 122702, 122699, 122695, 122692,
    122688, 122685, 122681, 122678, 122674, 122671, 122667, 122664, 122660, 122657, 122653, 122650, 122646, 122643,
    122639, 122636, 122632, 122629, 122625, 122622, 122618, 122615, 122611, 122608, 122604, 122601, 122597, 122594,
    122590, 122587, 122583, 122580, 122576, 122573, 122569, 122566, 122562, 122559, 122555, 122552, 122548, 122545,
    122541, 122538, 122534, 122531, 122527, 122524, 122520, 122517, 122513, 122510, 122506, 122503, 122499, 122496,
    122492, 122489, 122485, 122482, 122478, 122475, 122471, 122468, 122464, 122461, 122457, 122454, 122450, 122447,
    122443, 122440, 122436, 122433, 122430, 122426, 122423, 122419, 122416, 122412, 122409, 122405, 122402, 122398,
    122395, 122391, 122388, 122384, 122381, 122377, 122374, 122370, 122367, 122363, 122360, 122356, 122353, 122349,
    122346, 122342, 122339, 122335, 122332, 122328, 122325, 122321, 122318, 122314, 122311, 122307, 122304, 122301,
    122297, 122294, 122290, 122287, 122283, 122280, 122276, 122273, 122269, 122266, 122262, 122259, 122255, 122252,
    122248, 122245, 122241, 122238, 122234, 122231, 122227, 122224, 122220, 122217, 122214, 122210, 122207, 122203,
    122200, 122196, 122193, 122189, 122186, 122182, 122179, 122175, 122172, 122168, 122165, 122161, 122158, 122154,
    122151, 122147, 122144, 122141, 122137, 122134, 122130, 122127, 122123, 122120, 122116, 122113, 122109, 122106,
    122102, 122099, 122095, 122092, 122088, 122085, 122082, 122078, 122075, 122071, 122068, 122064, 122061, 122057,
    122054, 122050, 122047, 122043, 122040, 122036, 122033, 122029, 122026, 122023, 122019, 122016, 122012, 122009,
    122005, 122002, 121998, 121995, 121991, 121988, 121984, 121981, 121978, 121974, 121971, 121967, 121964, 121960,
    121957, 121953, 121950, 121946, 121943, 121939, 121936, 121932, 121929, 121926, 121922, 121919, 121915, 121912,
    121908, 121905, 121901, 121898, 121894, 121891, 121887, 121884, 121881, 121877, 121874, 121870, 121867, 121863,
    121860, 121856, 121853, 121849, 121846, 121843, 121839, 121836, 121832, 121829, 121825, 121822, 121818, 121815,
    121811, 121808, 121805, 121801, 121798, 121794, 121791, 121787, 121784, 121780, 121777, 121773, 121770, 121767,
    121763, 121760, 121756, 121753, 121749, 121746, 121742, 121739, 121735, 121732, 121729, 121725, 121722, 121718,
    121715, 121711, 121708, 121704, 121701, 121698, 121694, 121691, 121687, 121684, 121680, 121677, 121673, 121670,
    121667, 121663, 121660, 121656, 121653, 121649, 121646, 121642, 121639, 121636, 121632, 121629, 121625, 121622,
    121618, 121615, 121611, 121608, 121605, 121601, 121598, 121594, 121591, 121587, 121584, 121580, 121577, 121574,
    121570, 121567, 121563, 121560, 121556, 121553, 121549, 121546, 121543, 121539, 121536, 121532, 121529, 121525,
    121522, 121518, 121515, 121512, 121508, 121505, 121501, 121498, 121494, 121491, 121488, 121484, 121481, 121477,
    121474, 121470, 121467, 121464, 121460, 121457, 121453, 121450, 121446, 121443, 121439, 121436, 121433, 121429,
    121426, 121422, 121419, 121415, 121412, 121409, 121405, 121402, 121398, 121395, 121391, 121388, 121385, 121381,
    121378, 121374, 121371, 121367, 121364, 121361, 121357, 121354, 121350, 121347, 121343, 121340, 121337, 121333,
    121330, 121326, 121323, 121319, 121316, 121313, 121309, 121306, 121302, 121299, 121295, 121292, 121289, 121285,
    121282, 121278, 121275, 121271, 121268, 121265, 121261, 121258, 121254, 121251, 121247, 121244, 121241, 121237,
    121234, 121230, 121227, 121224, 121220, 121217, 121213, 121210, 121206, 121203, 121200, 121196, 121193, 121189,
    121186, 121182, 121179, 121176, 121172, 121169, 121165, 121162, 121159, 121155, 121152, 121148, 121145, 121141,
    121138, 121135, 121131, 121128, 121124, 121121, 121118, 121114, 121111, 121107, 121104, 121100, 121097, 121094,
    121090, 121087, 121083, 121080, 121077, 121073, 121070, 121066, 121063, 121060, 121056, 121053, 121049, 121046,
    121042, 121039, 121036, 121032, 121029, 121025, 121022, 121019, 121015, 121012, 121008, 121005, 121002, 120998,
    120995, 120991, 120988, 120984, 120981, 120978, 120974, 120971, 120967, 120964, 120961, 120957, 120954, 120950,
    120947, 120944, 120940, 120937, 120933, 120930, 120927, 120923, 120920, 120916, 120913, 120910, 120906, 120903,
    120899, 120896, 120893, 120889, 120886, 120882, 120879, 120876, 120872, 120869, 120865, 120862, 120859, 120855,
    120852, 120848, 120845, 120842, 120838, 120835, 120831, 120828, 120825, 120821, 120818, 120814, 120811, 120808,
    120804, 120801, 120797, 120794, 120791, 120787, 120784, 120780, 120777, 120774, 120770, 120767, 120763, 120760,
    120757, 120753, 120750, 120746, 120743, 120740, 120736, 120733, 120729, 120726, 120723, 120719, 120716, 120712,
    120709, 120706, 120702, 120699, 120696, 120692, 120689, 120685, 120682, 120679, 120675, 120672, 120668, 120665,
    120662, 120658, 120655, 120651, 120648, 120645, 120641, 120638, 120634, 120631, 120628, 120624, 120621, 120618,
    120614, 120611, 120607, 120604, 120601, 120597, 120594, 120590, 120587, 120584, 120580, 120577, 120574, 120570,
    120567, 120563, 120560, 120557, 120553, 120550, 120546, 120543, 120540, 120536, 120533, 120530, 120526, 120523,
    120519, 120516, 120513, 120509, 120506, 120502, 120499, 120496, 120492, 120489, 120486, 120482, 120479, 120475,
    120472, 120469, 120465, 120462, 120459, 120455, 120452, 120448, 120445, 120442, 120438, 120435, 120432, 120428,
    120425, 120421, 120418, 120415, 120411, 120408, 120405, 120401, 120398, 120394, 120391, 120388, 120384, 120381,
    120378, 120374, 120371, 120367, 120364, 120361, 120357, 120354, 120351, 120347, 120344, 120340, 120337, 120334,
    120330, 120327, 120324, 120320, 120317, 120313, 120310, 120307, 120303, 120300, 120297, 120293, 120290, 120286,
    120283, 120280, 120276, 120273, 120270, 120266, 120263, 120260, 120256, 120253, 120249, 120246, 120243, 120239,
    120236, 120233, 120229, 120226, 120223, 120219, 120216, 120212, 120209, 120206, 120202, 120199, 120196, 120192,
    120189, 120186, 120182, 120179, 120175, 120172, 120169, 120165, 120162, 120159, 120155, 120152, 120149, 120145,
    120142, 120138, 120135, 120132, 120128, 120125, 120122, 120118, 120115, 120112, 120108, 120105, 120101, 120098,
    120095, 120091, 120088, 120085, 120081, 120078, 120075, 120071, 120068, 120065, 120061, 120058, 120054, 120051,
    120048, 120044, 120041, 120038, 120034, 120031, 120028, 120024, 120021, 120018, 120014, 120011, 120008, 120004,
    120001, 119997, 119994, 119991, 119987, 119984, 119981, 119977, 119974, 119971, 119967, 119964, 119961, 119957,
    119954, 119951, 119947, 119944, 119941, 119937, 119934, 119930, 119927, 119924, 119920, 119917, 119914, 119910,
    119907, 119904, 119900, 119897, 119894, 119890, 119887, 119884, 119880, 119877, 119874, 119870, 119867, 119864,
    119860, 119857, 119853, 119850, 119847, 119843, 119840, 119837, 119833, 119830, 119827, 119823, 119820, 119817,
    119813, 119810, 119807, 119803, 119800, 119797, 119793, 119790, 119787, 119783, 119780, 119777, 119773, 119770,
    119767, 119763, 119760, 119757, 119753, 119750, 119747, 119743, 119740, 119737, 119733, 119730, 119727, 119723,
    119720, 119717, 119713, 119710, 119706, 119703, 119700, 119696, 119693, 119690, 119686, 119683, 119680, 119676,
    119673, 119670, 119666, 119663, 119660, 119656, 119653, 119650, 119646, 119643, 119640, 119636, 119633, 119630,
    119626, 119623, 119620, 119616, 119613, 119610, 119606, 119603, 119600, 119596, 119593, 119590, 119587, 119583,
    119580, 119577, 119573, 119570, 119567, 119563, 119560, 119557, 119553, 119550, 119547, 119543, 119540, 119537,
    119533, 119530, 119527, 119523, 119520, 119517, 119513, 119510, 119507, 119503, 119500, 119497, 119493, 119490,
    119487, 119483, 119480, 119477, 119473, 119470, 119467, 119463, 119460, 119457, 119453, 119450, 119447, 119444,
    119440, 119437, 119434, 119430, 119427, 119424, 119420, 119417, 119414, 119410, 119407, 119404, 119400, 119397,
    119394, 119390, 119387, 119384, 119380, 119377, 119374, 119370, 119367, 119364, 119361, 119357, 119354, 119351,
    119347, 119344, 119341, 119337, 119334, 119331, 119327, 119324, 119321, 119317, 119314, 119311, 119307, 119304,
    119301, 119298, 119294, 119291, 119288, 119284, 119281, 119278, 119274, 119271, 119268, 119264, 119261, 119258,
    119254, 119251, 119248, 119245, 119241, 119238, 119235, 119231, 119228, 119225, 119221, 119218, 119215, 119211,
    119208, 119205, 119202, 119198, 119195, 119192, 119188, 119185, 119182, 119178, 119175, 119172, 119168, 119165,
    119162, 119159, 119155, 119152, 119149, 119145, 119142, 119139, 119135, 119132, 119129, 119125, 119122, 119119,
    119116, 119112, 119109, 119106, 119102, 119099, 119096, 119092, 119089, 119086, 119083, 119079, 119076, 119073,
    119069, 119066, 119063, 119059, 119056, 119053, 119050, 119046, 119043, 119040, 119036, 119033, 119030, 119026,
    119023, 119020, 119017, 119013, 119010, 119007, 119003, 119000, 118997, 118993, 118990, 118987, 118984, 118980,
    118977, 118974, 118970, 118967, 118964, 118960, 118957, 118954, 118951, 118947, 118944, 118941, 118937, 118934,
    118931, 118928, 118924, 118921, 118918, 118914, 118911, 118908, 118904, 118901, 118898, 118895, 118891, 118888,
    118885, 118881, 118878, 118875, 118872, 118868, 118865, 118862, 118858, 118855, 118852, 118849, 118845, 118842,
    118839, 118835, 118832, 118829, 118826, 118822, 118819, 118816, 118812, 118809, 118806, 118803, 118799, 118796,
    118793, 118789, 118786, 118783, 118780, 118776, 118773, 118770, 118766, 118763, 118760, 118757, 118753, 118750,
    118747, 118743, 118740, 118737, 118734, 118730, 118727, 118724, 118720, 118717, 118714, 118711, 118707, 118704,
    118701, 118697, 118694, 118691, 118688, 118684, 118681, 118678, 118675, 118671, 118668, 118665, 118661, 118658,
    118655, 118652, 118648, 118645, 118642, 118638, 118635, 118632, 118629, 118625, 118622, 118619, 118616, 118612,
    118609, 118606, 118602, 118599, 118596, 118593, 118589, 118586, 118583, 118579, 118576, 118573, 118570, 118566,
    118563, 118560, 118557, 118553, 118550, 118547, 118543, 118540, 118537, 118534, 118530, 118527, 118524, 118521,
    118517, 118514, 118511, 118508, 118504, 118501, 118498, 118494, 118491, 118488, 118485, 118481, 118478, 118475,
    118472, 118468, 118465, 118462, 118458, 118455, 118452, 118449, 118445, 118442, 118439, 118436, 118432, 118429,
    118426, 118423, 118419, 118416, 118413, 118409, 118406, 118403, 118400, 118396, 118393, 118390, 118387, 118383,
    118380, 118377, 118374, 118370, 118367, 118364, 118361, 118357, 118354, 118351, 118348, 118344, 118341, 118338,
    118334, 118331, 118328, 118325, 118321, 118318, 118315, 118312, 118308, 118305, 118302, 118299, 118295, 118292,
    118289, 118286, 118282, 118279, 118276, 118273, 118269, 118266, 118263, 118260, 118256, 118253, 118250, 118246,
    118243, 118240, 118237, 118233, 118230, 118227, 118224, 118220, 118217, 118214, 118211, 118207, 118204, 118201,
    118198, 118194, 118191, 118188, 118185, 118181, 118178, 118175, 118172, 118168, 118165, 118162, 118159, 118155,
    118152, 118149, 118146, 118142, 118139, 118136, 118133, 118129, 118126, 118123, 118120, 118116, 118113, 118110,
    118107, 118103, 118100, 118097, 118094, 118090, 118087, 118084, 118081, 118077, 118074, 118071, 118068, 118064,
    118061, 118058, 118055, 118051, 118048, 118045, 118042, 118039, 118035, 118032, 118029, 118026, 118022, 118019,
    118016, 118013, 118009, 118006, 118003, 118000, 117996, 117993, 117990, 117987, 117983, 117980, 117977, 117974,
    117970, 117967, 117964, 117961, 117957, 117954, 117951, 117948, 117945, 117941, 117938, 117935, 117932, 117928,
    117925, 117922, 117919, 117915, 117912, 117909, 117906, 117902, 117899, 117896, 117893, 117889, 117886, 117883,
    117880, 117877, 117873, 117870, 117867, 117864, 117860, 117857, 117854, 117851, 117847, 117844, 117841, 117838,
    117834, 117831, 117828, 117825, 117822, 117818, 117815, 117812, 117809, 117805, 117802, 117799, 117796, 117792,
    117789, 117786, 117783, 117780, 117776, 117773, 117770, 117767, 117763, 117760, 117757, 117754, 117750, 117747,
    117744, 117741, 117738, 117734, 117731, 117728, 117725, 117721, 117718, 117715, 117712, 117709, 117705, 117702,
    117699, 117696, 117692, 117689, 117686, 117683, 117680, 117676, 117673, 117670, 117667, 117663, 117660, 117657,
    117654, 117651, 117647, 117644, 117641, 117638, 117634, 117631, 117628, 117625, 117622, 117618, 117615, 117612,
    117609, 117605, 117602, 117599, 117596, 117593, 117589, 117586, 117583, 117580, 117576, 117573, 117570, 117567,
    117564, 117560, 117557, 117554, 117551, 117547, 117544, 117541, 117538, 117535, 117531, 117528, 117525, 117522,
    117519, 117515, 117512, 117509, 117506, 117502, 117499, 117496, 117493, 117490, 117486, 117483, 117480, 117477,
    117474, 117470, 117467, 117464, 117461, 117457, 117454, 117451, 117448, 117445, 117441, 117438, 117435, 117432,
    117429, 117425, 117422, 117419, 117416, 117412, 117409, 117406, 117403, 117400, 117396, 117393, 117390, 117387,
    117384, 117380, 117377, 117374, 117371, 117368, 117364, 117361, 117358, 117355, 117352, 117348, 117345, 117342,
    117339, 117336, 117332, 117329, 117326, 117323, 117319, 117316, 117313, 117310, 117307, 117303, 117300, 117297,
    117294, 117291, 117287, 117284, 117281, 117278, 117275, 117271, 117268, 117265, 117262, 117259, 117255, 117252,
    117249, 117246, 117243, 117239, 117236, 117233, 117230, 117227, 117223, 117220, 117217, 117214, 117211, 117207,
    117204, 117201, 117198, 117195, 117191, 117188, 117185, 117182, 117179, 117175, 117172, 117169, 117166, 117163,
    117159, 117156, 117153, 117150, 117147, 117143, 117140, 117137, 117134, 117131, 117128, 117124, 117121, 117118,
    117115, 117112, 117108, 117105, 117102, 117099, 117096, 117092, 117089, 117086, 117083, 117080, 117076, 117073,
    117070, 117067, 117064, 117060, 117057, 117054, 117051, 117048, 117045, 117041, 117038, 117035, 117032, 117029,
    117025, 117022, 117019, 117016, 117013, 117009, 117006, 117003, 117000, 116997, 116994, 116990, 116987, 116984,
    116981, 116978, 116974, 116971, 116968, 116965, 116962, 116958, 116955, 116952, 116949, 116946, 116943, 116939,
    116936, 116933, 116930, 116927, 116923, 116920, 116917, 116914, 116911, 116908, 116904, 116901, 116898, 116895,
    116892, 116888, 116885, 116882, 116879, 116876, 116873, 116869, 116866, 116863, 116860, 116857, 116853, 116850,
    116847, 116844, 116841, 116838, 116834, 116831, 116828, 116825, 116822, 116819, 116815, 116812, 116809, 116806,
    116803, 116799, 116796, 116793, 116790, 116787, 116784, 116780, 116777, 116774, 116771, 116768, 116765, 116761,
    116758, 116755, 116752, 116749, 116745, 116742, 116739, 116736, 116733, 116730, 116726, 116723, 116720, 116717,
    116714, 116711, 116707, 116704, 116701, 116698, 116695, 116692, 116688, 116685, 116682, 116679, 116676, 116673,
    116669, 116666, 116663, 116660, 116657, 116654, 116650, 116647, 116644, 116641, 116638, 116635, 116631, 116628,
    116625, 116622, 116619, 116616, 116612, 116609, 116606, 116603, 116600, 116597, 116593, 116590, 116587, 116584,
    116581, 116578, 116574, 116571, 116568, 116565, 116562, 116559, 116555, 116552, 116549, 116546, 116543, 116540,
    116536, 116533, 116530, 116527, 116524, 116521, 116517, 116514, 116511, 116508, 116505, 116502, 116498, 116495,
    116492, 116489, 116486, 116483, 116480, 116476, 116473, 116470, 116467, 116464, 116461, 116457, 116454, 116451,
    116448, 116445, 116442, 116438, 116435, 116432, 116429, 116426, 116423, 116420, 116416, 116413, 116410, 116407,
    116404, 116401, 116397, 116394, 116391, 116388, 116385, 116382, 116379, 116375, 116372, 116369, 116366, 116363,
    116360, 116356, 116353, 116350, 116347, 116344, 116341, 116338, 116334, 116331, 116328, 116325, 116322, 116319,
    116315, 116312, 116309, 116306, 116303, 116300, 116297, 116293, 116290, 116287, 116284, 116281, 116278, 116275,
    116271, 116268, 116265, 116262, 116259, 116256, 116253, 116249, 116246, 116243, 116240, 116237, 116234, 116230,
    116227, 116224, 116221, 116218, 116215, 116212, 116208, 116205, 116202, 116199, 116196, 116193, 116190, 116186,
    116183, 116180, 116177, 116174, 116171, 116168, 116164, 116161, 116158, 116155, 116152, 116149, 116146, 116142,
    116139, 116136, 116133, 116130, 116127, 116124, 116121, 116117, 116114, 116111, 116108, 116105, 116102, 116099,
    116095, 116092, 116089, 116086, 116083, 116080, 116077, 116073, 116070, 116067, 116064, 116061, 116058, 116055,
    116051, 116048, 116045, 116042, 116039, 116036, 116033, 116030, 116026, 116023, 116020, 116017, 116014, 116011,
    116008, 116004, 116001, 115998, 115995, 115992, 115989, 115986, 115983, 115979, 115976, 115973, 115970, 115967,
    115964, 115961, 115957, 115954, 115951, 115948, 115945, 115942, 115939, 115936, 115932, 115929, 115926, 115923,
    115920, 115917, 115914, 115911, 115907, 115904, 115901, 115898, 115895, 115892, 115889, 115886, 115882, 115879,
    115876, 115873, 115870, 115867, 115864, 115861, 115857, 115854, 115851, 115848, 115845, 115842, 115839, 115836,
    115832, 115829, 115826, 115823, 115820, 115817, 115814, 115811, 115807, 115804, 115801, 115798, 115795, 115792,
    115789, 115786, 115782, 115779, 115776, 115773, 115770, 115767, 115764, 115761, 115757, 115754, 115751, 115748,
    115745, 115742, 115739, 115736, 115733, 115729, 115726, 115723, 115720, 115717, 115714, 115711, 115708, 115704,
    115701, 115698, 115695, 115692, 115689, 115686, 115683, 115680, 115676, 115673, 115670, 115667, 115664, 115661,
    115658, 115655, 115651, 115648, 115645, 115642, 115639, 115636, 115633, 115630, 115627, 115623, 115620, 115617,
    115614, 115611, 115608, 115605, 115602, 115599, 115595, 115592, 115589, 115586, 115583, 115580, 115577, 115574,
    115571, 115567, 115564, 115561, 115558, 115555, 115552, 115549, 115546, 115543, 115539, 115536, 115533, 115530,
    115527, 115524, 115521, 115518, 115515, 115512, 115508, 115505, 115502, 115499, 115496, 115493, 115490, 115487,
    115484, 115480, 115477, 115474, 115471, 115468, 115465, 115462, 115459, 115456, 115453, 115449, 115446, 115443,
    115440, 115437, 115434, 115431, 115428, 115425, 115421, 115418, 115415, 115412, 115409, 115406, 115403, 115400,
    115397, 115394, 115390, 115387, 115384, 115381, 115378, 115375, 115372, 115369, 115366, 115363, 115359, 115356,
    115353, 115350, 115347, 115344, 115341, 115338, 115335, 115332, 115329, 115325, 115322, 115319, 115316, 115313,
    115310, 115307, 115304, 115301, 115298, 115294, 115291, 115288, 115285, 115282, 115279, 115276, 115273, 115270,
    115267, 115264, 115260, 115257, 115254, 115251, 115248, 115245, 115242, 115239, 115236, 115233, 115229, 115226,
    115223, 115220, 115217, 115214, 115211, 115208, 115205, 115202, 115199, 115195, 115192, 115189, 115186, 115183,
    115180, 115177, 115174, 115171, 115168, 115165, 115162, 115158, 115155, 115152, 115149, 115146, 115143, 115140,
    115137, 115134, 115131, 115128, 115124, 115121, 115118, 115115, 115112, 115109, 115106, 115103, 115100, 115097,
    115094, 115091, 115087, 115084, 115081, 115078, 115075, 115072, 115069, 115066, 115063, 115060, 115057, 115054,
    115050, 115047, 115044, 115041, 115038, 115035, 115032, 115029, 115026, 115023, 115020, 115017, 115013, 115010,
    115007, 115004, 115001, 114998, 114995, 114992, 114989, 114986, 114983, 114980, 114977, 114973, 114970, 114967,
    114964, 114961, 114958, 114955, 114952, 114949, 114946, 114943, 114940, 114937, 114933, 114930, 114927, 114924,
    114921, 114918, 114915, 114912, 114909, 114906, 114903, 114900, 114897, 114893, 114890, 114887, 114884, 114881,
    114878, 114875, 114872, 114869, 114866, 114863, 114860, 114857, 114854, 114850, 114847, 114844, 114841, 114838,
    114835, 114832, 114829, 114826, 114823, 114820, 114817, 114814, 114811, 114808, 114804, 114801, 114798, 114795,
    114792, 114789, 114786, 114783, 114780, 114777, 114774, 114771, 114768, 114765, 114761, 114758, 114755, 114752,
    114749, 114746, 114743, 114740, 114737, 114734, 114731, 114728, 114725, 114722, 114719, 114716, 114712, 114709,
    114706, 114703, 114700, 114697, 114694, 114691, 114688, 114685, 114682, 114679, 114676, 114673, 114670, 114667,
    114663, 114660, 114657, 114654, 114651, 114648, 114645, 114642, 114639, 114636, 114633, 114630, 114627, 114624,
    114621, 114618, 114614, 114611, 114608, 114605, 114602, 114599, 114596, 114593, 114590, 114587, 114584, 114581,
    114578, 114575, 114572, 114569, 114566, 114563, 114559, 114556, 114553, 114550, 114547, 114544, 114541, 114538,
    114535, 114532, 114529, 114526, 114523, 114520, 114517, 114514, 114511, 114508, 114504, 114501, 114498, 114495,
    114492, 114489, 114486, 114483, 114480, 114477, 114474, 114471, 114468, 114465, 114462, 114459, 114456, 114453,
    114450, 114447, 114443, 114440, 114437, 114434, 114431, 114428, 114425, 114422, 114419, 114416, 114413, 114410,
    114407, 114404, 114401, 114398, 114395, 114392, 114389, 114386, 114383, 114379, 114376, 114373, 114370, 114367,
    114364, 114361, 114358, 114355, 114352, 114349, 114346, 114343, 114340, 114337, 114334, 114331, 114328, 114325,
    114322, 114319, 114316, 114312, 114309, 114306, 114303, 114300, 114297, 114294, 114291, 114288, 114285, 114282,
    114279, 114276, 114273, 114270, 114267, 114264, 114261, 114258, 114255, 114252, 114249, 114246, 114243, 114240,
    114236, 114233, 114230, 114227, 114224, 114221, 114218, 114215, 114212, 114209, 114206, 114203, 114200, 114197,
    114194, 114191, 114188, 114185, 114182, 114179, 114176, 114173, 114170, 114167, 114164, 114161, 114158, 114154,
    114151, 114148, 114145, 114142, 114139, 114136, 114133, 114130, 114127, 114124, 114121, 114118, 114115, 114112,
    114109, 114106, 114103, 114100, 114097, 114094, 114091, 114088, 114085, 114082, 114079, 114076, 114073, 114070,
    114067, 114064, 114061, 114057, 114054, 114051, 114048, 114045, 114042, 114039, 114036, 114033, 114030, 114027,
    114024, 114021, 114018, 114015, 114012, 114009, 114006, 114003, 114000, 113997, 113994, 113991, 113988, 113985,
    113982, 113979, 113976, 113973, 113970, 113967, 113964, 113961, 113958, 113955, 113952, 113949, 113946, 113943,
    113939, 113936, 113933, 113930, 113927, 113924, 113921, 113918, 113915, 113912, 113909, 113906, 113903, 113900,
    113897, 113894, 113891, 113888, 113885, 113882, 113879, 113876, 113873, 113870, 113867, 113864, 113861, 113858,
    113855, 113852, 113849, 113846, 113843, 113840, 113837, 113834, 113831, 113828, 113825, 113822, 113819, 113816,
    113813, 113810, 113807, 113804, 113801, 113798, 113795, 113792, 113789, 113786, 113783, 113780, 113776, 113773,
    113770, 113767, 113764, 113761, 113758, 113755, 113752, 113749, 113746, 113743, 113740, 113737, 113734, 113731,
    113728, 113725, 113722, 113719, 113716, 113713, 113710, 113707, 113704, 113701, 113698, 113695, 113692, 113689,
    113686, 113683, 113680, 113677, 113674, 113671, 113668, 113665, 113662, 113659, 113656, 113653, 113650, 113647,
    113644, 113641, 113638, 113635, 113632, 113629, 113626, 113623, 113620, 113617, 113614, 113611, 113608, 113605,
    113602, 113599, 113596, 113593, 113590, 113587, 113584, 113581, 113578, 113575, 113572, 113569, 113566, 113563,
    113560, 113557, 113554, 113551, 113548, 113545, 113542, 113539, 113536, 113533, 113530, 113527, 113524, 113521,
    113518, 113515, 113512, 113509, 113506, 113503, 113500, 113497, 113494, 113491, 113488, 113485, 113482, 113479,
    113476, 113473, 113470, 113467, 113464, 113461, 113458, 113455, 113452, 113449, 113446, 113443, 113440, 113437,
    113434, 113431, 113428, 113425, 113422, 113419, 113416, 113413, 113410, 113407, 113404, 113401, 113398, 113395,
    113392, 113389, 113386, 113383, 113380, 113377, 113374, 113371, 113368, 113365, 113362, 113359, 113356, 113353,
    113350, 113347, 113344, 113341, 113338, 113335, 113332, 113329, 113326, 113323, 113320, 113317, 113314, 113311,
    113308, 113305, 113302, 113299, 113296, 113293, 113290, 113287, 113284, 113281, 113278, 113275, 113272, 113269,
    113266, 113263, 113260, 113257, 113254, 113251, 113248, 113245, 113243, 113240, 113237, 113234, 113231, 113228,
    113225, 113222, 113219, 113216, 113213, 113210, 113207, 113204, 113201, 113198, 113195, 113192, 113189, 113186,
    113183, 113180, 113177, 113174, 113171, 113168, 113165, 113162, 113159, 113156, 113153, 113150, 113147, 113144,
    113141, 113138, 113135, 113132, 113129, 113126, 113123, 113120, 113117, 113114, 113111, 113108, 113105, 113102,
    113099, 113096, 113093, 113090, 113087, 113084, 113082, 113079, 113076, 113073, 113070, 113067, 113064, 113061,
    113058, 113055, 113052, 113049, 113046, 113043, 113040, 113037, 113034, 113031, 113028, 113025, 113022, 113019,
    113016, 113013, 113010, 113007, 113004, 113001, 112998, 112995, 112992, 112989, 112986, 112983, 112980, 112977,
    112974, 112971, 112968, 112966, 112963, 112960, 112957, 112954, 112951, 112948, 112945, 112942, 112939, 112936,
    112933, 112930, 112927, 112924, 112921, 112918, 112915, 112912, 112909, 112906, 112903, 112900, 112897, 112894,
    112891, 112888, 112885, 112882, 112879, 112876, 112873, 112871, 112868, 112865, 112862, 112859, 112856, 112853,
    112850, 112847, 112844, 112841, 112838, 112835, 112832, 112829, 112826, 112823, 112820, 112817, 112814, 112811,
    112808, 112805, 112802, 112799, 112796, 112793, 112790, 112788, 112785, 112782, 112779, 112776, 112773, 112770,
    112767, 112764, 112761, 112758, 112755, 112752, 112749, 112746, 112743, 112740, 112737, 112734, 112731, 112728,
    112725, 112722, 112719, 112716, 112714, 112711, 112708, 112705, 112702, 112699, 112696, 112693, 112690, 112687,
    112684, 112681, 112678, 112675, 112672, 112669, 112666, 112663, 112660, 112657, 112654, 112651, 112648, 112646,
    112643, 112640, 112637, 112634, 112631, 112628, 112625, 112622, 112619, 112616, 112613, 112610, 112607, 112604,
    112601, 112598, 112595, 112592, 112589, 112586, 112584, 112581, 112578, 112575, 112572, 112569, 112566, 112563,
    112560, 112557, 112554, 112551, 112548, 112545, 112542, 112539, 112536, 112533, 112530, 112527, 112525, 112522,
    112519, 112516, 112513, 112510, 112507, 112504, 112501, 112498, 112495, 112492, 112489, 112486, 112483, 112480,
    112477, 112474, 112471, 112469, 112466, 112463, 112460, 112457, 112454, 112451, 112448, 112445, 112442, 112439,
    112436, 112433, 112430, 112427, 112424, 112421, 112418, 112416, 112413, 112410, 112407, 112404, 112401, 112398,
    112395, 112392, 112389, 112386, 112383, 112380, 112377, 112374, 112371, 112368, 112366, 112363, 112360, 112357,
    112354, 112351, 112348, 112345, 112342, 112339, 112336, 112333, 112330, 112327, 112324, 112321, 112319, 112316,
    112313, 112310, 112307, 112304, 112301, 112298, 112295, 112292, 112289, 112286, 112283, 112280, 112277, 112274,
    112272, 112269, 112266, 112263, 112260, 112257, 112254, 112251, 112248, 112245, 112242, 112239, 112236, 112233,
    112230, 112228, 112225, 112222, 112219, 112216, 112213, 112210, 112207, 112204, 112201, 112198, 112195, 112192,
    112189, 112187, 112184, 112181, 112178, 112175, 112172, 112169, 112166, 112163, 112160, 112157, 112154, 112151,
    112148, 112145, 112143, 112140, 112137, 112134, 112131, 112128, 112125, 112122, 112119, 112116, 112113, 112110,
    112107, 112105, 112102, 112099, 112096, 112093, 112090, 112087, 112084, 112081, 112078, 112075, 112072, 112069,
    112066, 112064, 112061, 112058, 112055, 112052, 112049, 112046, 112043, 112040, 112037, 112034, 112031, 112028,
    112026, 112023, 112020, 112017, 112014, 112011, 112008, 112005, 112002, 111999, 111996, 111993, 111991, 111988,
    111985, 111982, 111979, 111976, 111973, 111970, 111967, 111964, 111961, 111958, 111955, 111953, 111950, 111947,
    111944, 111941, 111938, 111935, 111932, 111929, 111926, 111923, 111920, 111918, 111915, 111912, 111909, 111906,
    111903, 111900, 111897, 111894, 111891, 111888, 111885, 111883, 111880, 111877, 111874, 111871, 111868, 111865,
    111862, 111859, 111856, 111853, 111851, 111848, 111845, 111842, 111839, 111836, 111833, 111830, 111827, 111824,
    111821, 111818, 111816, 111813, 111810, 111807, 111804, 111801, 111798, 111795, 111792, 111789, 111786, 111784,
    111781, 111778, 111775, 111772, 111769, 111766, 111763, 111760, 111757, 111754, 111752, 111749, 111746, 111743,
    111740, 111737, 111734, 111731, 111728, 111725, 111723, 111720, 111717, 111714, 111711, 111708, 111705, 111702,
    111699, 111696, 111693, 111691, 111688, 111685, 111682, 111679, 111676, 111673, 111670, 111667, 111664, 111662,
    111659, 111656, 111653, 111650, 111647, 111644, 111641, 111638, 111635, 111632, 111630, 111627, 111624, 111621,
    111618, 111615, 111612, 111609, 111606, 111603, 111601, 111598, 111595, 111592, 111589, 111586, 111583, 111580,
    111577, 111574, 111572, 111569, 111566, 111563, 111560, 111557, 111554, 111551, 111548, 111546, 111543, 111540,
    111537, 111534, 111531, 111528, 111525, 111522, 111519, 111517, 111514, 111511, 111508, 111505, 111502, 111499,
    111496, 111493, 111490, 111488, 111485, 111482, 111479, 111476, 111473, 111470, 111467, 111464, 111462, 111459,
    111456, 111453, 111450, 111447, 111444, 111441, 111438, 111436, 111433, 111430, 111427, 111424, 111421, 111418,
    111415, 111412, 111410, 111407, 111404, 111401, 111398, 111395, 111392, 111389, 111386, 111384, 111381, 111378,
    111375, 111372, 111369, 111366, 111363, 111360, 111358, 111355, 111352, 111349, 111346, 111343, 111340, 111337,
    111334, 111332, 111329, 111326, 111323, 111320, 111317, 111314, 111311, 111308, 111306, 111303, 111300, 111297,
    111294, 111291, 111288, 111285, 111283, 111280, 111277, 111274, 111271, 111268, 111265, 111262, 111259, 111257,
    111254, 111251, 111248, 111245, 111242, 111239, 111236, 111234, 111231, 111228, 111225, 111222, 111219, 111216,
    111213, 111210, 111208, 111205, 111202, 111199, 111196, 111193, 111190, 111187, 111185, 111182, 111179, 111176,
    111173, 111170, 111167, 111164, 111162, 111159, 111156, 111153, 111150, 111147, 111144, 111141, 111139, 111136,
    111133, 111130, 111127, 111124, 111121, 111118, 111116, 111113, 111110, 111107, 111104, 111101, 111098, 111095,
    111093, 111090, 111087, 111084, 111081, 111078, 111075, 111072, 111070, 111067, 111064, 111061, 111058, 111055,
    111052, 111049, 111047, 111044, 111041, 111038, 111035, 111032, 111029, 111026, 111024, 111021, 111018, 111015,
    111012, 111009, 111006, 111004, 111001, 110998, 110995, 110992, 110989, 110986, 110983, 110981, 110978, 110975,
    110972, 110969, 110966, 110963, 110961, 110958, 110955, 110952, 110949, 110946, 110943, 110940, 110938, 110935,
    110932, 110929, 110926, 110923, 110920, 110918, 110915, 110912, 110909, 110906, 110903, 110900, 110897, 110895,
    110892, 110889, 110886, 110883, 110880, 110877, 110875, 110872, 110869, 110866, 110863, 110860, 110857, 110855,
    110852, 110849, 110846, 110843, 110840, 110837, 110835, 110832, 110829, 110826, 110823, 110820, 110817, 110814,
    110812, 110809, 110806, 110803, 110800, 110797, 110794, 110792, 110789, 110786, 110783, 110780, 110777, 110774,
    110772, 110769, 110766, 110763, 110760, 110757, 110754, 110752, 110749, 110746, 110743, 110740, 110737, 110734,
    110732, 110729, 110726, 110723, 110720, 110717, 110715, 110712, 110709, 110706, 110703, 110700, 110697, 110695,
    110692, 110689, 110686, 110683, 110680, 110677, 110675, 110672, 110669, 110666, 110663, 110660, 110657, 110655,
    110652, 110649, 110646, 110643, 110640, 110638, 110635, 110632, 110629, 110626, 110623, 110620, 110618, 110615,
    110612, 110609, 110606, 110603, 110600, 110598, 110595, 110592, 110589, 110586, 110583, 110581, 110578, 110575,
    110572, 110569, 110566, 110563, 110561, 110558, 110555, 110552, 110549, 110546, 110544, 110541, 110538, 110535,
    110532, 110529, 110526, 110524, 110521, 110518, 110515, 110512, 110509, 110507, 110504, 110501, 110498, 110495,
    110492, 110490, 110487, 110484, 110481, 110478, 110475, 110472, 110470, 110467, 110464, 110461, 110458, 110455,
    110453, 110450, 110447, 110444, 110441, 110438, 110436, 110433, 110430, 110427, 110424, 110421, 110418, 110416,
    110413, 110410, 110407, 110404, 110401, 110399, 110396, 110393, 110390, 110387, 110384, 110382, 110379, 110376,
    110373, 110370, 110367, 110365, 110362, 110359, 110356, 110353, 110350, 110348, 110345, 110342, 110339, 110336,
    110333, 110331, 110328, 110325, 110322, 110319, 110316, 110314, 110311, 110308, 110305, 110302, 110299, 110297,
    110294, 110291, 110288, 110285, 110282, 110280, 110277, 110274, 110271, 110268, 110265, 110263, 110260, 110257,
    110254, 110251, 110248, 110246, 110243, 110240, 110237, 110234, 110231, 110229, 110226, 110223, 110220, 110217,
    110214, 110212, 110209, 110206, 110203, 110200, 110198, 110195, 110192, 110189, 110186, 110183, 110181, 110178,
    110175, 110172, 110169, 110166, 110164, 110161, 110158, 110155, 110152, 110149, 110147, 110144, 110141, 110138,
    110135, 110133, 110130, 110127, 110124, 110121, 110118, 110116, 110113, 110110, 110107, 110104, 110101, 110099,
    110096, 110093, 110090, 110087, 110085, 110082, 110079, 110076, 110073, 110070, 110068, 110065, 110062, 110059,
    110056, 110054, 110051, 110048, 110045, 110042, 110039, 110037, 110034, 110031, 110028, 110025, 110022, 110020,
    110017, 110014, 110011, 110008, 110006, 110003, 110000, 109997, 109994, 109991, 109989, 109986, 109983, 109980,
    109977, 109975, 109972, 109969, 109966, 109963, 109961, 109958, 109955, 109952, 109949, 109946, 109944, 109941,
    109938, 109935, 109932, 109930, 109927, 109924, 109921, 109918, 109915, 109913, 109910, 109907, 109904, 109901,
    109899, 109896, 109893, 109890, 109887, 109885, 109882, 109879, 109876, 109873, 109871, 109868, 109865, 109862,
    109859, 109856, 109854, 109851, 109848, 109845, 109842, 109840, 109837, 109834, 109831, 109828, 109826, 109823,
    109820, 109817, 109814, 109812, 109809, 109806, 109803, 109800, 109797, 109795, 109792, 109789, 109786, 109783,
    109781, 109778, 109775, 109772, 109769, 109767, 109764, 109761, 109758, 109755, 109753, 109750, 109747, 109744,
    109741, 109739, 109736, 109733, 109730, 109727, 109725, 109722, 109719, 109716, 109713, 109711, 109708, 109705,
    109702, 109699, 109697, 109694, 109691, 109688, 109685, 109683, 109680, 109677, 109674, 109671, 109669, 109666,
    109663, 109660, 109657, 109655, 109652, 109649, 109646, 109643, 109641, 109638, 109635, 109632, 109629, 109627,
    109624, 109621, 109618, 109615, 109613, 109610, 109607, 109604, 109601, 109599, 109596, 109593, 109590, 109587,
    109585, 109582, 109579, 109576, 109573, 109571, 109568, 109565, 109562, 109559, 109557, 109554, 109551, 109548,
    109545, 109543, 109540, 109537, 109534, 109531, 109529, 109526, 109523, 109520, 109518, 109515, 109512, 109509,
    109506, 109504, 109501, 109498, 109495, 109492, 109490, 109487, 109484, 109481, 109478, 109476, 109473, 109470,
    109467, 109464, 109462, 109459, 109456, 109453, 109451, 109448, 109445, 109442, 109439, 109437, 109434, 109431,
    109428, 109425, 109423, 109420, 109417, 109414, 109411, 109409, 109406, 109403, 109400, 109398, 109395, 109392,
    109389, 109386, 109384, 109381, 109378, 109375, 109372, 109370, 109367, 109364, 109361, 109359, 109356, 109353,
    109350, 109347, 109345, 109342, 109339, 109336, 109333, 109331, 109328, 109325, 109322, 109320, 109317, 109314,
    109311, 109308, 109306, 109303, 109300, 109297, 109295, 109292, 109289, 109286, 109283, 109281, 109278, 109275,
    109272, 109270, 109267, 109264, 109261, 109258, 109256, 109253, 109250, 109247, 109245, 109242, 109239, 109236,
    109233, 109231, 109228, 109225, 109222, 109220, 109217, 109214, 109211, 109208, 109206, 109203, 109200, 109197,
    109195, 109192, 109189, 109186, 109183, 109181, 109178, 109175, 109172, 109170, 109167, 109164, 109161, 109158,
    109156, 109153, 109150, 109147, 109145, 109142, 109139, 109136, 109133, 109131, 109128, 109125, 109122, 109120,
    109117, 109114, 109111, 109109, 109106, 109103, 109100, 109097, 109095, 109092, 109089, 109086, 109084, 109081,
    109078, 109075, 109072, 109070, 109067, 109064, 109061, 109059, 109056, 109053, 109050, 109048, 109045, 109042,
    109039, 109037, 109034, 109031, 109028, 109025, 109023, 109020, 109017, 109014, 109012, 109009, 109006, 109003,
    109001, 108998, 108995, 108992, 108989, 108987, 108984, 108981, 108978, 108976, 108973, 108970, 108967, 108965,
    108962, 108959, 108956, 108954, 108951, 108948, 108945, 108942, 108940, 108937, 108934, 108931, 108929, 108926,
    108923, 108920, 108918, 108915, 108912, 108909, 108907, 108904, 108901, 108898, 108896, 108893, 108890, 108887,
    108884, 108882, 108879, 108876, 108873, 108871, 108868, 108865, 108862, 108860, 108857, 108854, 108851, 108849,
    108846, 108843, 108840, 108838, 108835, 108832, 108829, 108827, 108824, 108821, 108818, 108815, 108813, 108810,
    108807, 108804, 108802, 108799, 108796, 108793, 108791, 108788, 108785, 108782, 108780, 108777, 108774, 108771,
    108769, 108766, 108763, 108760, 108758, 108755, 108752, 108749, 108747, 108744, 108741, 108738, 108736, 108733,
    108730, 108727, 108725, 108722, 108719, 108716, 108714, 108711, 108708, 108705, 108703, 108700, 108697, 108694,
    108692, 108689, 108686, 108683, 108681, 108678, 108675, 108672, 108670, 108667, 108664, 108661, 108659, 108656,
    108653, 108650, 108648, 108645, 108642, 108639, 108637, 108634, 108631, 108628, 108626, 108623, 108620, 108617,
    108615, 108612, 108609, 108606, 108604, 108601, 108598, 108595, 108593, 108590, 108587, 108584, 108582, 108579,
    108576, 108573, 108571, 108568, 108565, 108562, 108560, 108557, 108554, 108551, 108549, 108546, 108543, 108541,
    108538, 108535, 108532, 108530, 108527, 108524, 108521, 108519, 108516, 108513, 108510, 108508, 108505, 108502,
    108499, 108497, 108494, 108491, 108488, 108486, 108483, 108480, 108477, 108475, 108472, 108469, 108466, 108464,
    108461, 108458, 108456, 108453, 108450, 108447, 108445, 108442, 108439, 108436, 108434, 108431, 108428, 108425,
    108423, 108420, 108417, 108414, 108412, 108409, 108406, 108404, 108401, 108398, 108395, 108393, 108390, 108387,
    108384, 108382, 108379, 108376, 108373, 108371, 108368, 108365, 108362, 108360, 108357, 108354, 108352, 108349,
    108346, 108343, 108341, 108338, 108335, 108332, 108330, 108327, 108324, 108322, 108319, 108316, 108313, 108311,
    108308, 108305, 108302, 108300, 108297, 108294, 108291, 108289, 108286, 108283, 108281, 108278, 108275, 108272,
    108270, 108267, 108264, 108261, 108259, 108256, 108253, 108251, 108248, 108245, 108242, 108240, 108237, 108234,
    108231, 108229, 108226, 108223, 108221, 108218, 108215, 108212, 108210, 108207, 108204, 108201, 108199, 108196,
    108193, 108191, 108188, 108185, 108182, 108180, 108177, 108174, 108171, 108169, 108166, 108163, 108161, 108158,
    108155, 108152, 108150, 108147, 108144, 108141, 108139, 108136, 108133, 108131, 108128, 108125, 108122, 108120,
    108117, 108114, 108112, 108109, 108106, 108103, 108101, 108098, 108095, 108093, 108090, 108087, 108084, 108082,
    108079, 108076, 108073, 108071, 108068, 108065, 108063, 108060, 108057, 108054, 108052, 108049, 108046, 108044,
    108041, 108038, 108035, 108033, 108030, 108027, 108025, 108022, 108019, 108016, 108014, 108011, 108008, 108006,
    108003, 108000, 107997, 107995, 107992, 107989, 107987, 107984, 107981, 107978, 107976, 107973, 107970, 107968,
    107965, 107962, 107959, 107957, 107954, 107951, 107949, 107946, 107943, 107940, 107938, 107935, 107932, 107930,
    107927, 107924, 107921, 107919, 107916, 107913, 107911, 107908, 107905, 107902, 107900, 107897, 107894, 107892,
    107889, 107886, 107883, 107881, 107878, 107875, 107873, 107870, 107867, 107864, 107862, 107859, 107856, 107854,
    107851, 107848, 107846, 107843, 107840, 107837, 107835, 107832, 107829, 107827, 107824, 107821, 107818, 107816,
    107813, 107810, 107808, 107805, 107802, 107799, 107797, 107794, 107791, 107789, 107786, 107783, 107781, 107778,
    107775, 107772, 107770, 107767, 107764, 107762, 107759, 107756, 107754, 107751, 107748, 107745, 107743, 107740,
    107737, 107735, 107732, 107729, 107726, 107724, 107721, 107718, 107716, 107713, 107710, 107708, 107705, 107702,
    107699, 107697, 107694, 107691, 107689, 107686, 107683, 107681, 107678, 107675, 107672, 107670, 107667, 107664,
    107662, 107659, 107656, 107654, 107651, 107648, 107645, 107643, 107640, 107637, 107635, 107632, 107629, 107627,
    107624, 107621, 107619, 107616, 107613, 107610, 107608, 107605, 107602, 107600, 107597, 107594, 107592, 107589,
    107586, 107583, 107581, 107578, 107575, 107573, 107570, 107567, 107565, 107562, 107559, 107557, 107554, 107551,
    107548, 107546, 107543, 107540, 107538, 107535, 107532, 107530, 107527, 107524, 107522, 107519, 107516, 107513,
    107511, 107508, 107505, 107503, 107500, 107497, 107495, 107492, 107489, 107487, 107484, 107481, 107478, 107476,
    107473, 107470, 107468, 107465, 107462, 107460, 107457, 107454, 107452, 107449, 107446, 107444, 107441, 107438,
    107435, 107433, 107430, 107427, 107425, 107422, 107419, 107417, 107414, 107411, 107409, 107406, 107403, 107401,
    107398, 107395, 107392, 107390, 107387, 107384, 107382, 107379, 107376, 107374, 107371, 107368, 107366, 107363,
    107360, 107358, 107355, 107352, 107350, 107347, 107344, 107341, 107339, 107336, 107333, 107331, 107328, 107325,
    107323, 107320, 107317, 107315, 107312, 107309, 107307, 107304, 107301, 107299, 107296, 107293, 107291, 107288,
    107285, 107282, 107280, 107277, 107274, 107272, 107269, 107266, 107264, 107261, 107258, 107256, 107253, 107250,
    107248, 107245, 107242, 107240, 107237, 107234, 107232, 107229, 107226, 107224, 107221, 107218, 107216, 107213,
    107210, 107208, 107205, 107202, 107199, 107197, 107194, 107191, 107189, 107186, 107183, 107181, 107178, 107175,
    107173, 107170, 107167, 107165, 107162, 107159, 107157, 107154, 107151, 107149, 107146, 107143, 107141, 107138,
    107135, 107133, 107130, 107127, 107125, 107122, 107119, 107117, 107114, 107111, 107109, 107106, 107103, 107101,
    107098, 107095, 107093, 107090, 107087, 107085, 107082, 107079, 107077, 107074, 107071, 107069, 107066, 107063,
    107061, 107058, 107055, 107053, 107050, 107047, 107045, 107042, 107039, 107037, 107034, 107031, 107029, 107026,
    107023, 107021, 107018, 107015, 107013, 107010, 107007, 107005, 107002, 106999, 106997, 106994, 106991, 106989,
    106986, 106983, 106981, 106978, 106975, 106973, 106970, 106967, 106965, 106962, 106959, 106957, 106954, 106951,
    106949, 106946, 106943, 106941, 106938, 106935, 106933, 106930, 106927, 106925, 106922, 106919, 106917, 106914,
    106911, 106909, 106906, 106903, 106901, 106898, 106895, 106893, 106890, 106887, 106885, 106882, 106879, 106877,
    106874, 106871, 106869, 106866, 106863, 106861, 106858, 106855, 106853, 106850, 106847, 106845, 106842, 106839,
    106837, 106834, 106832, 106829, 106826, 106824, 106821, 106818, 106816, 106813, 106810, 106808, 106805, 106802,
    106800, 106797, 106794, 106792, 106789, 106786, 106784, 106781, 106778, 106776, 106773, 106770, 106768, 106765,
    106762, 106760, 106757, 106755, 106752, 106749, 106747, 106744, 106741, 106739, 106736, 106733, 106731, 106728,
    106725, 106723, 106720, 106717, 106715, 106712, 106709, 106707, 106704, 106701, 106699, 106696, 106694, 106691,
    106688, 106686, 106683, 106680, 106678, 106675, 106672, 106670, 106667, 106664, 106662, 106659, 106656, 106654,
    106651, 106648, 106646, 106643, 106641, 106638, 106635, 106633, 106630, 106627, 106625, 106622, 106619, 106617,
    106614, 106611, 106609, 106606, 106603, 106601, 106598, 106596, 106593, 106590, 106588, 106585, 106582, 106580,
    106577, 106574, 106572, 106569, 106566, 106564, 106561, 106559, 106556, 106553, 106551, 106548, 106545, 106543,
    106540, 106537, 106535, 106532, 106529, 106527, 106524, 106522, 106519, 106516, 106514, 106511, 106508, 106506,
    106503, 106500, 106498, 106495, 106492, 106490, 106487, 106485, 106482, 106479, 106477, 106474, 106471, 106469,
    106466, 106463, 106461, 106458, 106456, 106453, 106450, 106448, 106445, 106442, 106440, 106437, 106434, 106432,
    106429, 106426, 106424, 106421, 106419, 106416, 106413, 106411, 106408, 106405, 106403, 106400, 106397, 106395,
    106392, 106390, 106387, 106384, 106382, 106379, 106376, 106374, 106371, 106368, 106366, 106363, 106361, 106358,
    106355, 106353, 106350, 106347, 106345, 106342, 106340, 106337, 106334, 106332, 106329, 106326, 106324, 106321,
    106318, 106316, 106313, 106311, 106308, 106305, 106303, 106300, 106297, 106295, 106292, 106290, 106287, 106284,
    106282, 106279, 106276, 106274, 106271, 106268, 106266, 106263, 106261, 106258, 106255, 106253, 106250, 106247,
    106245, 106242, 106240, 106237, 106234, 106232, 106229, 106226, 106224, 106221, 106219, 106216, 106213, 106211,
    106208, 106205, 106203, 106200, 106198, 106195, 106192, 106190, 106187, 106184, 106182, 106179, 106177, 106174,
    106171, 106169, 106166, 106163, 106161, 106158, 106156, 106153, 106150, 106148, 106145, 106142, 106140, 106137,
    106135, 106132, 106129, 106127, 106124, 106121, 106119, 106116, 106114, 106111, 106108, 106106, 106103, 106100,
    106098, 106095, 106093, 106090, 106087, 106085, 106082, 106080, 106077, 106074, 106072, 106069, 106066, 106064,
    106061, 106059, 106056, 106053, 106051, 106048, 106045, 106043, 106040, 106038, 106035, 106032, 106030, 106027,
    106025, 106022, 106019, 106017, 106014, 106011, 106009, 106006, 106004, 106001, 105998, 105996, 105993, 105991,
    105988, 105985, 105983, 105980, 105977, 105975, 105972, 105970, 105967, 105964, 105962, 105959, 105957, 105954,
    105951, 105949, 105946, 105943, 105941, 105938, 105936, 105933, 105930, 105928, 105925, 105923, 105920, 105917,
    105915, 105912, 105909, 105907, 105904, 105902, 105899, 105896, 105894, 105891, 105889, 105886, 105883, 105881,
    105878, 105876, 105873, 105870, 105868, 105865, 105862, 105860, 105857, 105855, 105852, 105849, 105847, 105844,
    105842, 105839, 105836, 105834, 105831, 105829, 105826, 105823, 105821, 105818, 105816, 105813, 105810, 105808,
    105805, 105803, 105800, 105797, 105795, 105792, 105789, 105787, 105784, 105782, 105779, 105776, 105774, 105771,
    105769, 105766, 105763, 105761, 105758, 105756, 105753, 105750, 105748, 105745, 105743, 105740, 105737, 105735,
    105732, 105730, 105727, 105724, 105722, 105719, 105717, 105714, 105711, 105709, 105706, 105704, 105701, 105698,
    105696, 105693, 105691, 105688, 105685, 105683, 105680, 105678, 105675, 105672, 105670, 105667, 105665, 105662,
    105659, 105657, 105654, 105652, 105649, 105646, 105644, 105641, 105639, 105636, 105633, 105631, 105628, 105626,
    105623, 105620, 105618, 105615, 105613, 105610, 105607, 105605, 105602, 105600, 105597, 105594, 105592, 105589,
    105587, 105584, 105581, 105579, 105576, 105574, 105571, 105568, 105566, 105563, 105561, 105558, 105555, 105553,
    105550, 105548, 105545, 105543, 105540, 105537, 105535, 105532, 105530, 105527, 105524, 105522, 105519, 105517,
    105514, 105511, 105509, 105506, 105504, 105501, 105498, 105496, 105493, 105491, 105488, 105485, 105483, 105480,
    105478, 105475, 105473, 105470, 105467, 105465, 105462, 105460, 105457, 105454, 105452, 105449, 105447, 105444,
    105441, 105439, 105436, 105434, 105431, 105429, 105426, 105423, 105421, 105418, 105416, 105413, 105410, 105408,
    105405, 105403, 105400, 105397, 105395, 105392, 105390, 105387, 105385, 105382, 105379, 105377, 105374, 105372,
    105369, 105366, 105364, 105361, 105359, 105356, 105354, 105351, 105348, 105346, 105343, 105341, 105338, 105335,
    105333, 105330, 105328, 105325, 105323, 105320, 105317, 105315, 105312, 105310, 105307, 105304, 105302, 105299,
    105297, 105294, 105292, 105289, 105286, 105284, 105281, 105279, 105276, 105273, 105271, 105268, 105266, 105263,
    105261, 105258, 105255, 105253, 105250, 105248, 105245, 105243, 105240, 105237, 105235, 105232, 105230, 105227,
    105224, 105222, 105219, 105217, 105214, 105212, 105209, 105206, 105204, 105201, 105199, 105196, 105194, 105191,
    105188, 105186, 105183, 105181, 105178, 105176, 105173, 105170, 105168, 105165, 105163, 105160, 105157, 105155,
    105152, 105150, 105147, 105145, 105142, 105139, 105137, 105134, 105132, 105129, 105127, 105124, 105121, 105119,
    105116, 105114, 105111, 105109, 105106, 105103, 105101, 105098, 105096, 105093, 105091, 105088, 105085, 105083,
    105080, 105078, 105075, 105073, 105070, 105067, 105065, 105062, 105060, 105057, 105055, 105052, 105049, 105047,
    105044, 105042, 105039, 105037, 105034, 105031, 105029, 105026, 105024, 105021, 105019, 105016, 105013, 105011,
    105008, 105006, 105003, 105001, 104998, 104996, 104993, 104990, 104988, 104985, 104983, 104980, 104978, 104975,
    104972, 104970, 104967, 104965, 104962, 104960, 104957, 104954, 104952, 104949, 104947, 104944, 104942, 104939,
    104937, 104934, 104931, 104929, 104926, 104924, 104921, 104919, 104916, 104913, 104911, 104908, 104906, 104903,
    104901, 104898, 104896, 104893, 104890, 104888, 104885, 104883, 104880, 104878, 104875, 104872, 104870, 104867,
    104865, 104862, 104860, 104857, 104855, 104852, 104849, 104847, 104844, 104842, 104839, 104837, 104834, 104832,
    104829, 104826, 104824, 104821, 104819, 104816, 104814, 104811, 104808, 104806, 104803, 104801, 104798, 104796,
    104793, 104791, 104788, 104785, 104783, 104780, 104778, 104775, 104773, 104770, 104768, 104765, 104762, 104760,
    104757, 104755, 104752, 104750, 104747, 104745, 104742, 104739, 104737, 104734, 104732, 104729, 104727, 104724,
    104722, 104719, 104716, 104714, 104711, 104709, 104706, 104704, 104701, 104699, 104696, 104694, 104691, 104688,
    104686, 104683, 104681, 104678, 104676, 104673, 104671, 104668, 104665, 104663, 104660, 104658, 104655, 104653,
    104650, 104648, 104645, 104643, 104640, 104637, 104635, 104632, 104630, 104627, 104625, 104622, 104620, 104617,
    104614, 104612, 104609, 104607, 104604, 104602, 104599, 104597, 104594, 104592, 104589, 104586, 104584, 104581,
    104579, 104576, 104574, 104571, 104569, 104566, 104564, 104561, 104558, 104556, 104553, 104551, 104548, 104546,
    104543, 104541, 104538, 104536, 104533, 104530, 104528, 104525, 104523, 104520, 104518, 104515, 104513, 104510,
    104508, 104505, 104502, 104500, 104497, 104495, 104492, 104490, 104487, 104485, 104482, 104480, 104477, 104475,
    104472, 104469, 104467, 104464, 104462, 104459, 104457, 104454, 104452, 104449, 104447, 104444, 104441, 104439,
    104436, 104434, 104431, 104429, 104426, 104424, 104421, 104419, 104416, 104414, 104411, 104408, 104406, 104403,
    104401, 104398, 104396, 104393, 104391, 104388, 104386, 104383, 104381, 104378, 104375, 104373, 104370, 104368,
    104365, 104363, 104360, 104358, 104355, 104353, 104350, 104348, 104345, 104343, 104340, 104337, 104335, 104332,
    104330, 104327, 104325, 104322, 104320, 104317, 104315, 104312, 104310, 104307, 104305, 104302, 104299, 104297,
    104294, 104292, 104289, 104287, 104284, 104282, 104279, 104277, 104274, 104272, 104269, 104267, 104264, 104261,
    104259, 104256, 104254, 104251, 104249, 104246, 104244, 104241, 104239, 104236, 104234, 104231, 104229, 104226,
    104224, 104221, 104218, 104216, 104213, 104211, 104208, 104206, 104203, 104201, 104198, 104196, 104193, 104191,
    104188, 104186, 104183, 104181, 104178, 104175, 104173, 104170, 104168, 104165, 104163, 104160, 104158, 104155,
    104153, 104150, 104148, 104145, 104143, 104140, 104138, 104135, 104133, 104130, 104127, 104125, 104122, 104120,
    104117, 104115, 104112, 104110, 104107, 104105, 104102, 104100, 104097, 104095, 104092, 104090, 104087, 104085,
    104082, 104080, 104077, 104075, 104072, 104069, 104067, 104064, 104062, 104059, 104057, 104054, 104052, 104049,
    104047, 104044, 104042, 104039, 104037, 104034, 104032, 104029, 104027, 104024, 104022, 104019, 104017, 104014,
    104011, 104009, 104006, 104004, 104001, 103999, 103996, 103994, 103991, 103989, 103986, 103984, 103981, 103979,
    103976, 103974, 103971, 103969, 103966, 103964, 103961, 103959, 103956, 103954, 103951, 103949, 103946, 103944,
    103941, 103939, 103936, 103933, 103931, 103928, 103926, 103923, 103921, 103918, 103916, 103913, 103911, 103908,
    103906, 103903, 103901, 103898, 103896, 103893, 103891, 103888, 103886, 103883, 103881, 103878, 103876, 103873,
    103871, 103868, 103866, 103863, 103861, 103858, 103856, 103853, 103851, 103848, 103846, 103843, 103840, 103838,
    103835, 103833, 103830, 103828, 103825, 103823, 103820, 103818, 103815, 103813, 103810, 103808, 103805, 103803,
    103800, 103798, 103795, 103793, 103790, 103788, 103785, 103783, 103780, 103778, 103775, 103773, 103770, 103768,
    103765, 103763, 103760, 103758, 103755, 103753, 103750, 103748, 103745, 103743, 103740, 103738, 103735, 103733,
    103730, 103728, 103725, 103723, 103720, 103718, 103715, 103713, 103710, 103708, 103705, 103703, 103700, 103698,
    103695, 103693, 103690, 103688, 103685, 103683, 103680, 103678, 103675, 103673, 103670, 103668, 103665, 103663,
    103660, 103658, 103655, 103653, 103650, 103648, 103645, 103643, 103640, 103638, 103635, 103633, 103630, 103628,
    103625, 103623, 103620, 103618, 103615, 103613, 103610, 103608, 103605, 103603, 103600, 103598, 103595, 103593,
    103590, 103588, 103585, 103583, 103580, 103578, 103575, 103573, 103570, 103568, 103565, 103563, 103560, 103558,
    103555, 103553, 103550, 103548, 103545, 103543, 103540, 103538, 103535, 103533, 103530, 103528, 103525, 103523,
    103520, 103518, 103515, 103513, 103510, 103508, 103505, 103503, 103500, 103498, 103495, 103493, 103490, 103488,
    103485, 103483, 103480, 103478, 103475, 103473, 103470, 103468, 103465, 103463, 103460, 103458, 103455, 103453,
    103450, 103448, 103445, 103443, 103440, 103438, 103435, 103433, 103430, 103428, 103425, 103423, 103420, 103418,
    103415, 103413, 103410, 103408, 103405, 103403, 103401, 103398, 103396, 103393, 103391, 103388, 103386, 103383,
    103381, 103378, 103376, 103373, 103371, 103368, 103366, 103363, 103361, 103358, 103356, 103353, 103351, 103348,
    103346, 103343, 103341, 103338, 103336, 103333, 103331, 103328, 103326, 103323, 103321, 103318, 103316, 103313,
    103311, 103308, 103306, 103304, 103301, 103299, 103296, 103294, 103291, 103289, 103286, 103284, 103281, 103279,
    103276, 103274, 103271, 103269, 103266, 103264, 103261, 103259, 103256, 103254, 103251, 103249, 103246, 103244,
    103241, 103239, 103236, 103234, 103232, 103229, 103227, 103224, 103222, 103219, 103217, 103214, 103212, 103209,
    103207, 103204, 103202, 103199, 103197, 103194, 103192, 103189, 103187, 103184, 103182, 103179, 103177, 103174,
    103172, 103170, 103167, 103165, 103162, 103160, 103157, 103155, 103152, 103150, 103147, 103145, 103142, 103140,
    103137, 103135, 103132, 103130, 103127, 103125, 103122, 103120, 103117, 103115, 103113, 103110, 103108, 103105,
    103103, 103100, 103098, 103095, 103093, 103090, 103088, 103085, 103083, 103080, 103078, 103075, 103073, 103070,
    103068, 103066, 103063, 103061, 103058, 103056, 103053, 103051, 103048, 103046, 103043, 103041, 103038, 103036,
    103033, 103031, 103028, 103026, 103023, 103021, 103019, 103016, 103014, 103011, 103009, 103006, 103004, 103001,
    102999, 102996, 102994, 102991, 102989, 102986, 102984, 102982, 102979, 102977, 102974, 102972, 102969, 102967,
    102964, 102962, 102959, 102957, 102954, 102952, 102949, 102947, 102944, 102942, 102940, 102937, 102935, 102932,
    102930, 102927, 102925, 102922, 102920, 102917, 102915, 102912, 102910, 102907, 102905, 102903, 102900, 102898,
    102895, 102893, 102890, 102888, 102885, 102883, 102880, 102878, 102875, 102873, 102871, 102868, 102866, 102863,
    102861, 102858, 102856, 102853, 102851, 102848, 102846, 102843, 102841, 102838, 102836, 102834, 102831, 102829,
    102826, 102824, 102821, 102819, 102816, 102814, 102811, 102809, 102806, 102804, 102802, 102799, 102797, 102794,
    102792, 102789, 102787, 102784, 102782, 102779, 102777, 102775, 102772, 102770, 102767, 102765, 102762, 102760,
    102757, 102755, 102752, 102750, 102747, 102745, 102743, 102740, 102738, 102735, 102733, 102730, 102728, 102725,
    102723, 102720, 102718, 102716, 102713, 102711, 102708, 102706, 102703, 102701, 102698, 102696, 102693, 102691,
    102689, 102686, 102684, 102681, 102679, 102676, 102674, 102671, 102669, 102666, 102664, 102662, 102659, 102657,
    102654, 102652, 102649, 102647, 102644, 102642, 102639, 102637, 102635, 102632, 102630, 102627, 102625, 102622,
    102620, 102617, 102615, 102612, 102610, 102608, 102605, 102603, 102600, 102598, 102595, 102593, 102590, 102588,
    102585, 102583, 102581, 102578, 102576, 102573, 102571, 102568, 102566, 102563, 102561, 102559, 102556, 102554,
    102551, 102549, 102546, 102544, 102541, 102539, 102537, 102534, 102532, 102529, 102527, 102524, 102522, 102519,
    102517, 102514, 102512, 102510, 102507, 102505, 102502, 102500, 102497, 102495, 102492, 102490, 102488, 102485,
    102483, 102480, 102478, 102475, 102473, 102470, 102468, 102466, 102463, 102461, 102458, 102456, 102453, 102451,
    102448, 102446, 102444, 102441, 102439, 102436, 102434, 102431, 102429, 102426, 102424, 102422, 102419, 102417,
    102414, 102412, 102409, 102407, 102404, 102402, 102400, 102397, 102395, 102392, 102390, 102387, 102385, 102383,
    102380, 102378, 102375, 102373, 102370, 102368, 102365, 102363, 102361, 102358, 102356, 102353, 102351, 102348,
    102346, 102343, 102341, 102339, 102336, 102334, 102331, 102329, 102326, 102324, 102322, 102319, 102317, 102314,
    102312, 102309, 102307, 102304, 102302, 102300, 102297, 102295, 102292, 102290, 102287, 102285, 102283, 102280,
    102278, 102275, 102273, 102270, 102268, 102265, 102263, 102261, 102258, 102256, 102253, 102251, 102248, 102246,
    102244, 102241, 102239, 102236, 102234, 102231, 102229, 102227, 102224, 102222, 102219, 102217, 102214, 102212,
    102210, 102207, 102205, 102202, 102200, 102197, 102195, 102193, 102190, 102188, 102185, 102183, 102180, 102178,
    102175, 102173, 102171, 102168, 102166, 102163, 102161, 102158, 102156, 102154, 102151, 102149, 102146, 102144,
    102141, 102139, 102137, 102134, 102132, 102129, 102127, 102124, 102122, 102120, 102117, 102115, 102112, 102110,
    102107, 102105, 102103, 102100, 102098, 102095, 102093, 102090, 102088, 102086, 102083, 102081, 102078, 102076,
    102073, 102071, 102069, 102066, 102064, 102061, 102059, 102057, 102054, 102052, 102049, 102047, 102044, 102042,
    102040, 102037, 102035, 102032, 102030, 102027, 102025, 102023, 102020, 102018, 102015, 102013, 102010, 102008,
    102006, 102003, 102001, 101998, 101996, 101994, 101991, 101989, 101986, 101984, 101981, 101979, 101977, 101974,
    101972, 101969, 101967, 101964, 101962, 101960, 101957, 101955, 101952, 101950, 101948, 101945, 101943, 101940,
    101938, 101935, 101933, 101931, 101928, 101926, 101923, 101921, 101918, 101916, 101914, 101911, 101909, 101906,
    101904, 101902, 101899, 101897, 101894, 101892, 101889, 101887, 101885, 101882, 101880, 101877, 101875, 101873,
    101870, 101868, 101865, 101863, 101860, 101858, 101856, 101853, 101851, 101848, 101846, 101844, 101841, 101839,
    101836, 101834, 101831, 101829, 101827, 101824, 101822, 101819, 101817, 101815, 101812, 101810, 101807, 101805,
    101803, 101800, 101798, 101795, 101793, 101790, 101788, 101786, 101783, 101781, 101778, 101776, 101774, 101771,
    101769, 101766, 101764, 101762, 101759, 101757, 101754, 101752, 101749, 101747, 101745, 101742, 101740, 101737,
    101735, 101733, 101730, 101728, 101725, 101723, 101721, 101718, 101716, 101713, 101711, 101708, 101706, 101704,
    101701, 101699, 101696, 101694, 101692, 101689, 101687, 101684, 101682, 101680, 101677, 101675, 101672, 101670,
    101668, 101665, 101663, 101660, 101658, 101656, 101653, 101651, 101648, 101646, 101644, 101641, 101639, 101636,
    101634, 101631, 101629, 101627, 101624, 101622, 101619, 101617, 101615, 101612, 101610, 101607, 101605, 101603,
    101600, 101598, 101595, 101593, 101591, 101588, 101586, 101583, 101581, 101579, 101576, 101574, 101571, 101569,
    101567, 101564, 101562, 101559, 101557, 101555, 101552, 101550, 101547, 101545, 101543, 101540, 101538, 101535,
    101533, 101531, 101528, 101526, 101523, 101521, 101519, 101516, 101514, 101511, 101509, 101507, 101504, 101502,
    101499, 101497, 101495, 101492, 101490, 101487, 101485, 101483, 101480, 101478, 101475, 101473, 101471, 101468,
    101466, 101463, 101461, 101459, 101456, 101454, 101451, 101449, 101447, 101444, 101442, 101439, 101437, 101435,
    101432, 101430, 101427, 101425, 101423, 101420, 101418, 101415, 101413, 101411, 101408, 101406, 101404, 101401,
    101399, 101396, 101394, 101392, 101389, 101387, 101384, 101382, 101380, 101377, 101375, 101372, 101370, 101368,
    101365, 101363, 101360, 101358, 101356, 101353, 101351, 101348, 101346, 101344, 101341, 101339, 101337, 101334,
    101332, 101329, 101327, 101325, 101322, 101320, 101317, 101315, 101313, 101310, 101308, 101305, 101303, 101301,
    101298, 101296, 101294, 101291, 101289, 101286, 101284, 101282, 101279, 101277, 101274, 101272, 101270, 101267,
    101265, 101262, 101260, 101258, 101255, 101253, 101251, 101248, 101246, 101243, 101241, 101239, 101236, 101234,
    101231, 101229, 101227, 101224, 101222, 101220, 101217, 101215, 101212, 101210, 101208, 101205, 101203, 101200,
    101198, 101196, 101193, 101191, 101189, 101186, 101184, 101181, 101179, 101177, 101174, 101172, 101169, 101167,
    101165, 101162, 101160, 101158, 101155, 101153, 101150, 101148, 101146, 101143, 101141, 101138, 101136, 101134,
    101131, 101129, 101127, 101124, 101122, 101119, 101117, 101115, 101112, 101110, 101108, 101105, 101103, 101100,
    101098, 101096, 101093, 101091, 101088, 101086, 101084, 101081, 101079, 101077, 101074, 101072, 101069, 101067,
    101065, 101062, 101060, 101058, 101055, 101053, 101050, 101048, 101046, 101043, 101041, 101039, 101036, 101034,
    101031, 101029, 101027, 101024, 101022, 101020, 101017, 101015, 101012, 101010, 101008, 101005, 101003, 101001,
    100998, 100996, 100993, 100991, 100989, 100986, 100984, 100982, 100979, 100977, 100974, 100972, 100970, 100967,
    100965, 100963, 100960, 100958, 100955, 100953, 100951, 100948, 100946, 100944, 100941, 100939, 100936, 100934,
    100932, 100929, 100927, 100925, 100922, 100920, 100917, 100915, 100913, 100910, 100908, 100906, 100903, 100901,
    100898, 100896, 100894, 100891, 100889, 100887, 100884, 100882, 100880, 100877, 100875, 100872, 100870, 100868,
    100865, 100863, 100861, 100858, 100856, 100853, 100851, 100849, 100846, 100844, 100842, 100839, 100837, 100835,
    100832, 100830, 100827, 100825, 100823, 100820, 100818, 100816, 100813, 100811, 100809, 100806, 100804, 100801,
    100799, 100797, 100794, 100792, 100790, 100787, 100785, 100782, 100780, 100778, 100775, 100773, 100771, 100768,
    100766, 100764, 100761, 100759, 100756, 100754, 100752, 100749, 100747, 100745, 100742, 100740, 100738, 100735,
    100733, 100730, 100728, 100726, 100723, 100721, 100719, 100716, 100714, 100712, 100709, 100707, 100704, 100702,
    100700, 100697, 100695, 100693, 100690, 100688, 100686, 100683, 100681, 100679, 100676, 100674, 100671, 100669,
    100667, 100664, 100662, 100660, 100657, 100655, 100653, 100650, 100648, 100646, 100643, 100641, 100638, 100636,
    100634, 100631, 100629, 100627, 100624, 100622, 100620, 100617, 100615, 100612, 100610, 100608, 100605, 100603,
    100601, 100598, 100596, 100594, 100591, 100589, 100587, 100584, 100582, 100580, 100577, 100575, 100572, 100570,
    100568, 100565, 100563, 100561, 100558, 100556, 100554, 100551, 100549, 100547, 100544, 100542, 100539, 100537,
    100535, 100532, 100530, 100528, 100525, 100523, 100521, 100518, 100516, 100514, 100511, 100509, 100507, 100504,
    100502, 100499, 100497, 100495, 100492, 100490, 100488, 100485, 100483, 100481, 100478, 100476, 100474, 100471,
    100469, 100467, 100464, 100462, 100460, 100457, 100455, 100452, 100450, 100448, 100445, 100443, 100441, 100438,
    100436, 100434, 100431, 100429, 100427, 100424, 100422, 100420, 100417, 100415, 100413, 100410, 100408, 100406,
    100403, 100401, 100398, 100396, 100394, 100391, 100389, 100387, 100384, 100382, 100380, 100377, 100375, 100373,
    100370, 100368, 100366, 100363, 100361, 100359, 100356, 100354, 100352, 100349, 100347, 100345, 100342, 100340,
    100337, 100335, 100333, 100330, 100328, 100326, 100323, 100321, 100319, 100316, 100314, 100312, 100309, 100307,
    100305, 100302, 100300, 100298, 100295, 100293, 100291, 100288, 100286, 100284, 100281, 100279, 100277, 100274,
    100272, 100270, 100267, 100265, 100263, 100260, 100258, 100256, 100253, 100251, 100248, 100246, 100244, 100241,
    100239, 100237, 100234, 100232, 100230, 100227, 100225, 100223, 100220, 100218, 100216, 100213, 100211, 100209,
    100206, 100204, 100202, 100199, 100197, 100195, 100192, 100190, 100188, 100185, 100183, 100181, 100178, 100176,
    100174, 100171, 100169, 100167, 100164, 100162, 100160, 100157, 100155, 100153, 100150, 100148, 100146, 100143,
    100141, 100139, 100136, 100134, 100132, 100129, 100127, 100125, 100122, 100120, 100118, 100115, 100113, 100111,
    100108, 100106, 100104, 100101, 100099, 100097, 100094, 100092, 100090, 100087, 100085, 100083, 100080, 100078,
    100076, 100073, 100071, 100069, 100066, 100064, 100062, 100059, 100057, 100055, 100052, 100050, 100048, 100045,
    100043, 100041, 100038, 100036, 100034, 100031, 100029, 100027, 100024, 100022, 100020, 100017, 100015, 100013,
    100010, 100008, 100006, 100003, 100001, 99999,  99996,  99994,  99992,  99989,  99987,  99985,  99982,  99980,
    99978,  99975,  99973,  99971,  99968,  99966,  99964,  99962,  99959,  99957,  99955,  99952,  99950,  99948,
    99945,  99943,  99941,  99938,  99936,  99934,  99931,  99929,  99927,  99924,  99922,  99920,  99917,  99915,
    99913,  99910,  99908,  99906,  99903,  99901,  99899,  99896,  99894,  99892,  99889,  99887,  99885,  99882,
    99880,  99878,  99875,  99873,  99871,  99869,  99866,  99864,  99862,  99859,  99857,  99855,  99852,  99850,
    99848,  99845,  99843,  99841,  99838,  99836,  99834,  99831,  99829,  99827,  99824,  99822,  99820,  99817,
    99815,  99813,  99811,  99808,  99806,  99804,  99801,  99799,  99797,  99794,  99792,  99790,  99787,  99785,
    99783,  99780,  99778,  99776,  99773,  99771,  99769,  99766,  99764,  99762,  99760,  99757,  99755,  99753,
    99750,  99748,  99746,  99743,  99741,  99739,  99736,  99734,  99732,  99729,  99727,  99725,  99722,  99720,
    99718,  99715,  99713,  99711,  99709,  99706,  99704,  99702,  99699,  99697,  99695,  99692,  99690,  99688,
    99685,  99683,  99681,  99678,  99676,  99674,  99672,  99669,  99667,  99665,  99662,  99660,  99658,  99655,
    99653,  99651,  99648,  99646,  99644,  99641,  99639,  99637,  99635,  99632,  99630,  99628,  99625,  99623,
    99621,  99618,  99616,  99614,  99611,  99609,  99607,  99604,  99602,  99600,  99598,  99595,  99593,  99591,
    99588,  99586,  99584,  99581,  99579,  99577,  99574,  99572,  99570,  99568,  99565,  99563,  99561,  99558,
    99556,  99554,  99551,  99549,  99547,  99544,  99542,  99540,  99538,  99535,  99533,  99531,  99528,  99526,
    99524,  99521,  99519,  99517,  99514,  99512,  99510,  99508,  99505,  99503,  99501,  99498,  99496,  99494,
    99491,  99489,  99487,  99485,  99482,  99480,  99478,  99475,  99473,  99471,  99468,  99466,  99464,  99461,
    99459,  99457,  99455,  99452,  99450,  99448,  99445,  99443,  99441,  99438,  99436,  99434,  99432,  99429,
    99427,  99425,  99422,  99420,  99418,  99415,  99413,  99411,  99409,  99406,  99404,  99402,  99399,  99397,
    99395,  99392,  99390,  99388,  99386,  99383,  99381,  99379,  99376,  99374,  99372,  99369,  99367,  99365,
    99363,  99360,  99358,  99356,  99353,  99351,  99349,  99346,  99344,  99342,  99340,  99337,  99335,  99333,
    99330,  99328,  99326,  99323,  99321,  99319,  99317,  99314,  99312,  99310,  99307,  99305,  99303,  99301,
    99298,  99296,  99294,  99291,  99289,  99287,  99284,  99282,  99280,  99278,  99275,  99273,  99271,  99268,
    99266,  99264,  99261,  99259,  99257,  99255,  99252,  99250,  99248,  99245,  99243,  99241,  99239,  99236,
    99234,  99232,  99229,  99227,  99225,  99223,  99220,  99218,  99216,  99213,  99211,  99209,  99206,  99204,
    99202,  99200,  99197,  99195,  99193,  99190,  99188,  99186,  99184,  99181,  99179,  99177,  99174,  99172,
    99170,  99168,  99165,  99163,  99161,  99158,  99156,  99154,  99152,  99149,  99147,  99145,  99142,  99140,
    99138,  99135,  99133,  99131,  99129,  99126,  99124,  99122,  99119,  99117,  99115,  99113,  99110,  99108,
    99106,  99103,  99101,  99099,  99097,  99094,  99092,  99090,  99087,  99085,  99083,  99081,  99078,  99076,
    99074,  99071,  99069,  99067,  99065,  99062,  99060,  99058,  99055,  99053,  99051,  99049,  99046,  99044,
    99042,  99039,  99037,  99035,  99033,  99030,  99028,  99026,  99023,  99021,  99019,  99017,  99014,  99012,
    99010,  99008,  99005,  99003,  99001,  98998,  98996,  98994,  98992,  98989,  98987,  98985,  98982,  98980,
    98978,  98976,  98973,  98971,  98969,  98966,  98964,  98962,  98960,  98957,  98955,  98953,  98950,  98948,
    98946,  98944,  98941,  98939,  98937,  98935,  98932,  98930,  98928,  98925,  98923,  98921,  98919,  98916,
    98914,  98912,  98909,  98907,  98905,  98903,  98900,  98898,  98896,  98894,  98891,  98889,  98887,  98884,
    98882,  98880,  98878,  98875,  98873,  98871,  98868,  98866,  98864,  98862,  98859,  98857,  98855,  98853,
    98850,  98848,  98846,  98843,  98841,  98839,  98837,  98834,  98832,  98830,  98828,  98825,  98823,  98821,
    98818,  98816,  98814,  98812,  98809,  98807,  98805,  98803,  98800,  98798,  98796,  98793,  98791,  98789,
    98787,  98784,  98782,  98780,  98778,  98775,  98773,  98771,  98768,  98766,  98764,  98762,  98759,  98757,
    98755,  98753,  98750,  98748,  98746,  98743,  98741,  98739,  98737,  98734,  98732,  98730,  98728,  98725,
    98723,  98721,  98718,  98716,  98714,  98712,  98709,  98707,  98705,  98703,  98700,  98698,  98696,  98694,
    98691,  98689,  98687,  98684,  98682,  98680,  98678,  98675,  98673,  98671,  98669,  98666,  98664,  98662,
    98660,  98657,  98655,  98653,  98650,  98648,  98646,  98644,  98641,  98639,  98637,  98635,  98632,  98630,
    98628,  98626,  98623,  98621,  98619,  98616,  98614,  98612,  98610,  98607,  98605,  98603,  98601,  98598,
    98596,  98594,  98592,  98589,  98587,  98585,  98583,  98580,  98578,  98576,  98573,  98571,  98569,  98567,
    98564,  98562,  98560,  98558,  98555,  98553,  98551,  98549,  98546,  98544,  98542,  98540,  98537,  98535,
    98533,  98531,  98528,  98526,  98524,  98521,  98519,  98517,  98515,  98512,  98510,  98508,  98506,  98503,
    98501,  98499,  98497,  98494,  98492,  98490,  98488,  98485,  98483,  98481,  98479,  98476,  98474,  98472,
    98470,  98467,  98465,  98463,  98461,  98458,  98456,  98454,  98451,  98449,  98447,  98445,  98442,  98440,
    98438,  98436,  98433,  98431,  98429,  98427,  98424,  98422,  98420,  98418,  98415,  98413,  98411,  98409,
    98406,  98404,  98402,  98400,  98397,  98395,  98393,  98391,  98388,  98386,  98384,  98382,  98379,  98377,
    98375,  98373,  98370,  98368,  98366,  98364,  98361,  98359,  98357,  98355,  98352,  98350,  98348,  98346,
    98343,  98341,  98339,  98337,  98334,  98332,  98330,  98328,  98325,  98323,  98321,  98319,  98316,  98314,
    98312,  98310,  98307,  98305,  98303,  98301,  98298,  98296,  98294,  98292,  98289,  98287,  98285,  98283,
    98280,  98278,  98276,  98274,  98271,  98269,  98267,  98265,  98262,  98260,  98258,  98256,  98253,  98251,
    98249,  98247,  98244,  98242,  98240,  98238,  98235,  98233,  98231,  98229,  98226,  98224,  98222,  98220,
    98217,  98215,  98213,  98211,  98208,  98206,  98204,  98202,  98199,  98197,  98195,  98193,  98190,  98188,
    98186,  98184,  98181,  98179,  98177,  98175,  98172,  98170,  98168,  98166,  98163,  98161,  98159,  98157,
    98154,  98152,  98150,  98148,  98146,  98143,  98141,  98139,  98137,  98134,  98132,  98130,  98128,  98125,
    98123,  98121,  98119,  98116,  98114,  98112,  98110,  98107,  98105,  98103,  98101,  98098,  98096,  98094,
    98092,  98089,  98087,  98085,  98083,  98081,  98078,  98076,  98074,  98072,  98069,  98067,  98065,  98063,
    98060,  98058,  98056,  98054,  98051,  98049,  98047,  98045,  98042,  98040,  98038,  98036,  98033,  98031,
    98029,  98027,  98025,  98022,  98020,  98018,  98016,  98013,  98011,  98009,  98007,  98004,  98002,  98000,
    97998,  97995,  97993,  97991,  97989,  97987,  97984,  97982,  97980,  97978,  97975,  97973,  97971,  97969,
    97966,  97964,  97962,  97960,  97957,  97955,  97953,  97951,  97949,  97946,  97944,  97942,  97940,  97937,
    97935,  97933,  97931,  97928,  97926,  97924,  97922,  97920,  97917,  97915,  97913,  97911,  97908,  97906,
    97904,  97902,  97899,  97897,  97895,  97893,  97890,  97888,  97886,  97884,  97882,  97879,  97877,  97875,
    97873,  97870,  97868,  97866,  97864,  97862,  97859,  97857,  97855,  97853,  97850,  97848,  97846,  97844,
    97841,  97839,  97837,  97835,  97833,  97830,  97828,  97826,  97824,  97821,  97819,  97817,  97815,  97812,
    97810,  97808,  97806,  97804,  97801,  97799,  97797,  97795,  97792,  97790,  97788,  97786,  97784,  97781,
    97779,  97777,  97775,  97772,  97770,  97768,  97766,  97763,  97761,  97759,  97757,  97755,  97752,  97750,
    97748,  97746,  97743,  97741,  97739,  97737,  97735,  97732,  97730,  97728,  97726,  97723,  97721,  97719,
    97717,  97715,  97712,  97710,  97708,  97706,  97703,  97701,  97699,  97697,  97695,  97692,  97690,  97688,
    97686,  97683,  97681,  97679,  97677,  97675,  97672,  97670,  97668,  97666,  97663,  97661,  97659,  97657,
    97655,  97652,  97650,  97648,  97646,  97643,  97641,  97639,  97637,  97635,  97632,  97630,  97628,  97626,
    97623,  97621,  97619,  97617,  97615,  97612,  97610,  97608,  97606,  97604,  97601,  97599,  97597,  97595,
    97592,  97590,  97588,  97586,  97584,  97581,  97579,  97577,  97575,  97572,  97570,  97568,  97566,  97564,
    97561,  97559,  97557,  97555,  97553,  97550,  97548,  97546,  97544,  97541,  97539,  97537,  97535,  97533,
    97530,  97528,  97526,  97524,  97522,  97519,  97517,  97515,  97513,  97510,  97508,  97506,  97504,  97502,
    97499,  97497,  97495,  97493,  97491,  97488,  97486,  97484,  97482,  97479,  97477,  97475,  97473,  97471,
    97468,  97466,  97464,  97462,  97460,  97457,  97455,  97453,  97451,  97449,  97446,  97444,  97442,  97440,
    97437,  97435,  97433,  97431,  97429,  97426,  97424,  97422,  97420,  97418,  97415,  97413,  97411,  97409,
    97407,  97404,  97402,  97400,  97398,  97395,  97393,  97391,  97389,  97387,  97384,  97382,  97380,  97378,
    97376,  97373,  97371,  97369,  97367,  97365,  97362,  97360,  97358,  97356,  97354,  97351,  97349,  97347,
    97345,  97342,  97340,  97338,  97336,  97334,  97331,  97329,  97327,  97325,  97323,  97320,  97318,  97316,
    97314,  97312,  97309,  97307,  97305,  97303,  97301,  97298,  97296,  97294,  97292,  97290,  97287,  97285,
    97283,  97281,  97279,  97276,  97274,  97272,  97270,  97268,  97265,  97263,  97261,  97259,  97257,  97254,
    97252,  97250,  97248,  97246,  97243,  97241,  97239,  97237,  97235,  97232,  97230,  97228,  97226,  97224,
    97221,  97219,  97217,  97215,  97212,  97210,  97208,  97206,  97204,  97201,  97199,  97197,  97195,  97193,
    97190,  97188,  97186,  97184,  97182,  97180,  97177,  97175,  97173,  97171,  97169,  97166,  97164,  97162,
    97160,  97158,  97155,  97153,  97151,  97149,  97147,  97144,  97142,  97140,  97138,  97136,  97133,  97131,
    97129,  97127,  97125,  97122,  97120,  97118,  97116,  97114,  97111,  97109,  97107,  97105,  97103,  97100,
    97098,  97096,  97094,  97092,  97089,  97087,  97085,  97083,  97081,  97078,  97076,  97074,  97072,  97070,
    97067,  97065,  97063,  97061,  97059,  97057,  97054,  97052,  97050,  97048,  97046,  97043,  97041,  97039,
    97037,  97035,  97032,  97030,  97028,  97026,  97024,  97021,  97019,  97017,  97015,  97013,  97010,  97008,
    97006,  97004,  97002,  97000,  96997,  96995,  96993,  96991,  96989,  96986,  96984,  96982,  96980,  96978,
    96975,  96973,  96971,  96969,  96967,  96964,  96962,  96960,  96958,  96956,  96954,  96951,  96949,  96947,
    96945,  96943,  96940,  96938,  96936,  96934,  96932,  96929,  96927,  96925,  96923,  96921,  96919,  96916,
    96914,  96912,  96910,  96908,  96905,  96903,  96901,  96899,  96897,  96894,  96892,  96890,  96888,  96886,
    96884,  96881,  96879,  96877,  96875,  96873,  96870,  96868,  96866,  96864,  96862,  96860,  96857,  96855,
    96853,  96851,  96849,  96846,  96844,  96842,  96840,  96838,  96836,  96833,  96831,  96829,  96827,  96825,
    96822,  96820,  96818,  96816,  96814,  96811,  96809,  96807,  96805,  96803,  96801,  96798,  96796,  96794,
    96792,  96790,  96787,  96785,  96783,  96781,  96779,  96777,  96774,  96772,  96770,  96768,  96766,  96764,
    96761,  96759,  96757,  96755,  96753,  96750,  96748,  96746,  96744,  96742,  96740,  96737,  96735,  96733,
    96731,  96729,  96726,  96724,  96722,  96720,  96718,  96716,  96713,  96711,  96709,  96707,  96705,  96703,
    96700,  96698,  96696,  96694,  96692,  96689,  96687,  96685,  96683,  96681,  96679,  96676,  96674,  96672,
    96670,  96668,  96666,  96663,  96661,  96659,  96657,  96655,  96652,  96650,  96648,  96646,  96644,  96642,
    96639,  96637,  96635,  96633,  96631,  96629,  96626,  96624,  96622,  96620,  96618,  96615,  96613,  96611,
    96609,  96607,  96605,  96602,  96600,  96598,  96596,  96594,  96592,  96589,  96587,  96585,  96583,  96581,
    96579,  96576,  96574,  96572,  96570,  96568,  96566,  96563,  96561,  96559,  96557,  96555,  96553,  96550,
    96548,  96546,  96544,  96542,  96539,  96537,  96535,  96533,  96531,  96529,  96526,  96524,  96522,  96520,
    96518,  96516,  96513,  96511,  96509,  96507,  96505,  96503,  96500,  96498,  96496,  96494,  96492,  96490,
    96487,  96485,  96483,  96481,  96479,  96477,  96474,  96472,  96470,  96468,  96466,  96464,  96461,  96459,
    96457,  96455,  96453,  96451,  96448,  96446,  96444,  96442,  96440,  96438,  96435,  96433,  96431,  96429,
    96427,  96425,  96422,  96420,  96418,  96416,  96414,  96412,  96409,  96407,  96405,  96403,  96401,  96399,
    96396,  96394,  96392,  96390,  96388,  96386,  96384,  96381,  96379,  96377,  96375,  96373,  96371,  96368,
    96366,  96364,  96362,  96360,  96358,  96355,  96353,  96351,  96349,  96347,  96345,  96342,  96340,  96338,
    96336,  96334,  96332,  96329,  96327,  96325,  96323,  96321,  96319,  96316,  96314,  96312,  96310,  96308,
    96306,  96304,  96301,  96299,  96297,  96295,  96293,  96291,  96288,  96286,  96284,  96282,  96280,  96278,
    96275,  96273,  96271,  96269,  96267,  96265,  96263,  96260,  96258,  96256,  96254,  96252,  96250,  96247,
    96245,  96243,  96241,  96239,  96237,  96234,  96232,  96230,  96228,  96226,  96224,  96222,  96219,  96217,
    96215,  96213,  96211,  96209,  96206,  96204,  96202,  96200,  96198,  96196,  96194,  96191,  96189,  96187,
    96185,  96183,  96181,  96178,  96176,  96174,  96172,  96170,  96168,  96166,  96163,  96161,  96159,  96157,
    96155,  96153,  96150,  96148,  96146,  96144,  96142,  96140,  96138,  96135,  96133,  96131,  96129,  96127,
    96125,  96122,  96120,  96118,  96116,  96114,  96112,  96110,  96107,  96105,  96103,  96101,  96099,  96097,
    96095,  96092,  96090,  96088,  96086,  96084,  96082,  96079,  96077,  96075,  96073,  96071,  96069,  96067,
    96064,  96062,  96060,  96058,  96056,  96054,  96052,  96049,  96047,  96045,  96043,  96041,  96039,  96037,
    96034,  96032,  96030,  96028,  96026,  96024,  96021,  96019,  96017,  96015,  96013,  96011,  96009,  96006,
    96004,  96002,  96000,  95998,  95996,  95994,  95991,  95989,  95987,  95985,  95983,  95981,  95979,  95976,
    95974,  95972,  95970,  95968,  95966,  95964,  95961,  95959,  95957,  95955,  95953,  95951,  95949,  95946,
    95944,  95942,  95940,  95938,  95936,  95934,  95931,  95929,  95927,  95925,  95923,  95921,  95919,  95916,
    95914,  95912,  95910,  95908,  95906,  95904,  95901,  95899,  95897,  95895,  95893,  95891,  95889,  95886,
    95884,  95882,  95880,  95878,  95876,  95874,  95871,  95869,  95867,  95865,  95863,  95861,  95859,  95856,
    95854,  95852,  95850,  95848,  95846,  95844,  95841,  95839,  95837,  95835,  95833,  95831,  95829,  95827,
    95824,  95822,  95820,  95818,  95816,  95814,  95812,  95809,  95807,  95805,  95803,  95801,  95799,  95797,
    95794,  95792,  95790,  95788,  95786,  95784,  95782,  95780,  95777,  95775,  95773,  95771,  95769,  95767,
    95765,  95762,  95760,  95758,  95756,  95754,  95752,  95750,  95747,  95745,  95743,  95741,  95739,  95737,
    95735,  95733,  95730,  95728,  95726,  95724,  95722,  95720,  95718,  95715,  95713,  95711,  95709,  95707,
    95705,  95703,  95701,  95698,  95696,  95694,  95692,  95690,  95688,  95686,  95683,  95681,  95679,  95677,
    95675,  95673,  95671,  95669,  95666,  95664,  95662,  95660,  95658,  95656,  95654,  95652,  95649,  95647,
    95645,  95643,  95641,  95639,  95637,  95634,  95632,  95630,  95628,  95626,  95624,  95622,  95620,  95617,
    95615,  95613,  95611,  95609,  95607,  95605,  95603,  95600,  95598,  95596,  95594,  95592,  95590,  95588,
    95586,  95583,  95581,  95579,  95577,  95575,  95573,  95571,  95569,  95566,  95564,  95562,  95560,  95558,
    95556,  95554,  95552,  95549,  95547,  95545,  95543,  95541,  95539,  95537,  95535,  95532,  95530,  95528,
    95526,  95524,  95522,  95520,  95518,  95515,  95513,  95511,  95509,  95507,  95505,  95503,  95501,  95498,
    95496,  95494,  95492,  95490,  95488,  95486,  95484,  95481,  95479,  95477,  95475,  95473,  95471,  95469,
    95467,  95464,  95462,  95460,  95458,  95456,  95454,  95452,  95450,  95447,  95445,  95443,  95441,  95439,
    95437,  95435,  95433,  95430,  95428,  95426,  95424,  95422,  95420,  95418,  95416,  95414,  95411,  95409,
    95407,  95405,  95403,  95401,  95399,  95397,  95394,  95392,  95390,  95388,  95386,  95384,  95382,  95380,
    95378,  95375,  95373,  95371,  95369,  95367,  95365,  95363,  95361,  95358,  95356,  95354,  95352,  95350,
    95348,  95346,  95344,  95342,  95339,  95337,  95335,  95333,  95331,  95329,  95327,  95325,  95322,  95320,
    95318,  95316,  95314,  95312,  95310,  95308,  95306,  95303,  95301,  95299,  95297,  95295,  95293,  95291,
    95289,  95287,  95284,  95282,  95280,  95278,  95276,  95274,  95272,  95270,  95268,  95265,  95263,  95261,
    95259,  95257,  95255,  95253,  95251,  95248,  95246,  95244,  95242,  95240,  95238,  95236,  95234,  95232,
    95229,  95227,  95225,  95223,  95221,  95219,  95217,  95215,  95213,  95210,  95208,  95206,  95204,  95202,
    95200,  95198,  95196,  95194,  95191,  95189,  95187,  95185,  95183,  95181,  95179,  95177,  95175,  95173,
    95170,  95168,  95166,  95164,  95162,  95160,  95158,  95156,  95154,  95151,  95149,  95147,  95145,  95143,
    95141,  95139,  95137,  95135,  95132,  95130,  95128,  95126,  95124,  95122,  95120,  95118,  95116,  95113,
    95111,  95109,  95107,  95105,  95103,  95101,  95099,  95097,  95095,  95092,  95090,  95088,  95086,  95084,
    95082,  95080,  95078,  95076,  95073,  95071,  95069,  95067,  95065,  95063,  95061,  95059,  95057,  95055,
    95052,  95050,  95048,  95046,  95044,  95042,  95040,  95038,  95036,  95034,  95031,  95029,  95027,  95025,
    95023,  95021,  95019,  95017,  95015,  95012,  95010,  95008,  95006,  95004,  95002,  95000,  94998,  94996,
    94994,  94991,  94989,  94987,  94985,  94983,  94981,  94979,  94977,  94975,  94973,  94970,  94968,  94966,
    94964,  94962,  94960,  94958,  94956,  94954,  94952,  94949,  94947,  94945,  94943,  94941,  94939,  94937,
    94935,  94933,  94931,  94928,  94926,  94924,  94922,  94920,  94918,  94916,  94914,  94912,  94910,  94908,
    94905,  94903,  94901,  94899,  94897,  94895,  94893,  94891,  94889,  94887,  94884,  94882,  94880,  94878,
    94876,  94874,  94872,  94870,  94868,  94866,  94863,  94861,  94859,  94857,  94855,  94853,  94851,  94849,
    94847,  94845,  94843,  94840,  94838,  94836,  94834,  94832,  94830,  94828,  94826,  94824,  94822,  94820,
    94817,  94815,  94813,  94811,  94809,  94807,  94805,  94803,  94801,  94799,  94796,  94794,  94792,  94790,
    94788,  94786,  94784,  94782,  94780,  94778,  94776,  94773,  94771,  94769,  94767,  94765,  94763,  94761,
    94759,  94757,  94755,  94753,  94750,  94748,  94746,  94744,  94742,  94740,  94738,  94736,  94734,  94732,
    94730,  94727,  94725,  94723,  94721,  94719,  94717,  94715,  94713,  94711,  94709,  94707,  94705,  94702,
    94700,  94698,  94696,  94694,  94692,  94690,  94688,  94686,  94684,  94682,  94679,  94677,  94675,  94673,
    94671,  94669,  94667,  94665,  94663,  94661,  94659,  94657,  94654,  94652,  94650,  94648,  94646,  94644,
    94642,  94640,  94638,  94636,  94634,  94631,  94629,  94627,  94625,  94623,  94621,  94619,  94617,  94615,
    94613,  94611,  94609,  94606,  94604,  94602,  94600,  94598,  94596,  94594,  94592,  94590,  94588,  94586,
    94584,  94581,  94579,  94577,  94575,  94573,  94571,  94569,  94567,  94565,  94563,  94561,  94559,  94556,
    94554,  94552,  94550,  94548,  94546,  94544,  94542,  94540,  94538,  94536,  94534,  94532,  94529,  94527,
    94525,  94523,  94521,  94519,  94517,  94515,  94513,  94511,  94509,  94507,  94504,  94502,  94500,  94498,
    94496,  94494,  94492,  94490,  94488,  94486,  94484,  94482,  94480,  94477,  94475,  94473,  94471,  94469,
    94467,  94465,  94463,  94461,  94459,  94457,  94455,  94453,  94450,  94448,  94446,  94444,  94442,  94440,
    94438,  94436,  94434,  94432,  94430,  94428,  94426,  94423,  94421,  94419,  94417,  94415,  94413,  94411,
    94409,  94407,  94405,  94403,  94401,  94399,  94396,  94394,  94392,  94390,  94388,  94386,  94384,  94382,
    94380,  94378,  94376,  94374,  94372,  94370,  94367,  94365,  94363,  94361,  94359,  94357,  94355,  94353,
    94351,  94349,  94347,  94345,  94343,  94340,  94338,  94336,  94334,  94332,  94330,  94328,  94326,  94324,
    94322,  94320,  94318,  94316,  94314,  94311,  94309,  94307,  94305,  94303,  94301,  94299,  94297,  94295,
    94293,  94291,  94289,  94287,  94285,  94282,  94280,  94278,  94276,  94274,  94272,  94270,  94268,  94266,
    94264,  94262,  94260,  94258,  94256,  94254,  94251,  94249,  94247,  94245,  94243,  94241,  94239,  94237,
    94235,  94233,  94231,  94229,  94227,  94225,  94223,  94220,  94218,  94216,  94214,  94212,  94210,  94208,
    94206,  94204,  94202,  94200,  94198,  94196,  94194,  94192,  94189,  94187,  94185,  94183,  94181,  94179,
    94177,  94175,  94173,  94171,  94169,  94167,  94165,  94163,  94161,  94158,  94156,  94154,  94152,  94150,
    94148,  94146,  94144,  94142,  94140,  94138,  94136,  94134,  94132,  94130,  94128,  94125,  94123,  94121,
    94119,  94117,  94115,  94113,  94111,  94109,  94107,  94105,  94103,  94101,  94099,  94097,  94095,  94092,
    94090,  94088,  94086,  94084,  94082,  94080,  94078,  94076,  94074,  94072,  94070,  94068,  94066,  94064,
    94062,  94059,  94057,  94055,  94053,  94051,  94049,  94047,  94045,  94043,  94041,  94039,  94037,  94035,
    94033,  94031,  94029,  94027,  94024,  94022,  94020,  94018,  94016,  94014,  94012,  94010,  94008,  94006,
    94004,  94002,  94000,  93998,  93996,  93994,  93992,  93990,  93987,  93985,  93983,  93981,  93979,  93977,
    93975,  93973,  93971,  93969,  93967,  93965,  93963,  93961,  93959,  93957,  93955,  93953,  93950,  93948,
    93946,  93944,  93942,  93940,  93938,  93936,  93934,  93932,  93930,  93928,  93926,  93924,  93922,  93920,
    93918,  93916,  93913,  93911,  93909,  93907,  93905,  93903,  93901,  93899,  93897,  93895,  93893,  93891,
    93889,  93887,  93885,  93883,  93881,  93879,  93877,  93874,  93872,  93870,  93868,  93866,  93864,  93862,
    93860,  93858,  93856,  93854,  93852,  93850,  93848,  93846,  93844,  93842,  93840,  93838,  93835,  93833,
    93831,  93829,  93827,  93825,  93823,  93821,  93819,  93817,  93815,  93813,  93811,  93809,  93807,  93805,
    93803,  93801,  93799,  93797,  93795,  93792,  93790,  93788,  93786,  93784,  93782,  93780,  93778,  93776,
    93774,  93772,  93770,  93768,  93766,  93764,  93762,  93760,  93758,  93756,  93754,  93752,  93749,  93747,
    93745,  93743,  93741,  93739,  93737,  93735,  93733,  93731,  93729,  93727,  93725,  93723,  93721,  93719,
    93717,  93715,  93713,  93711,  93709,  93707,  93704,  93702,  93700,  93698,  93696,  93694,  93692,  93690,
    93688,  93686,  93684,  93682,  93680,  93678,  93676,  93674,  93672,  93670,  93668,  93666,  93664,  93662,
    93660,  93657,  93655,  93653,  93651,  93649,  93647,  93645,  93643,  93641,  93639,  93637,  93635,  93633,
    93631,  93629,  93627,  93625,  93623,  93621,  93619,  93617,  93615,  93613,  93611,  93608,  93606,  93604,
    93602,  93600,  93598,  93596,  93594,  93592,  93590,  93588,  93586,  93584,  93582,  93580,  93578,  93576,
    93574,  93572,  93570,  93568,  93566,  93564,  93562,  93560,  93558,  93555,  93553,  93551,  93549,  93547,
    93545,  93543,  93541,  93539,  93537,  93535,  93533,  93531,  93529,  93527,  93525,  93523,  93521,  93519,
    93517,  93515,  93513,  93511,  93509,  93507,  93505,  93503,  93500,  93498,  93496,  93494,  93492,  93490,
    93488,  93486,  93484,  93482,  93480,  93478,  93476,  93474,  93472,  93470,  93468,  93466,  93464,  93462,
    93460,  93458,  93456,  93454,  93452,  93450,  93448,  93446,  93444,  93441,  93439,  93437,  93435,  93433,
    93431,  93429,  93427,  93425,  93423,  93421,  93419,  93417,  93415,  93413,  93411,  93409,  93407,  93405,
    93403,  93401,  93399,  93397,  93395,  93393,  93391,  93389,  93387,  93385,  93383,  93381,  93379,  93376,
    93374,  93372,  93370,  93368,  93366,  93364,  93362,  93360,  93358,  93356,  93354,  93352,  93350,  93348,
    93346,  93344,  93342,  93340,  93338,  93336,  93334,  93332,  93330,  93328,  93326,  93324,  93322,  93320,
    93318,  93316,  93314,  93312,  93310,  93308,  93305,  93303,  93301,  93299,  93297,  93295,  93293,  93291,
    93289,  93287,  93285,  93283,  93281,  93279,  93277,  93275,  93273,  93271,  93269,  93267,  93265,  93263,
    93261,  93259,  93257,  93255,  93253,  93251,  93249,  93247,  93245,  93243,  93241,  93239,  93237,  93235,
    93233,  93231,  93229,  93226,  93224,  93222,  93220,  93218,  93216,  93214,  93212,  93210,  93208,  93206,
    93204,  93202,  93200,  93198,  93196,  93194,  93192,  93190,  93188,  93186,  93184,  93182,  93180,  93178,
    93176,  93174,  93172,  93170,  93168,  93166,  93164,  93162,  93160,  93158,  93156,  93154,  93152,  93150,
    93148,  93146,  93144,  93142,  93140,  93138,  93136,  93133,  93131,  93129,  93127,  93125,  93123,  93121,
    93119,  93117,  93115,  93113,  93111,  93109,  93107,  93105,  93103,  93101,  93099,  93097,  93095,  93093,
    93091,  93089,  93087,  93085,  93083,  93081,  93079,  93077,  93075,  93073,  93071,  93069,  93067,  93065,
    93063,  93061,  93059,  93057,  93055,  93053,  93051,  93049,  93047,  93045,  93043,  93041,  93039,  93037,
    93035,  93033,  93031,  93029,  93027,  93025,  93023,  93021,  93019,  93017,  93014,  93012,  93010,  93008,
    93006,  93004,  93002,  93000,  92998,  92996,  92994,  92992,  92990,  92988,  92986,  92984,  92982,  92980,
    92978,  92976,  92974,  92972,  92970,  92968,  92966,  92964,  92962,  92960,  92958,  92956,  92954,  92952,
    92950,  92948,  92946,  92944,  92942,  92940,  92938,  92936,  92934,  92932,  92930,  92928,  92926,  92924,
    92922,  92920,  92918,  92916,  92914,  92912,  92910,  92908,  92906,  92904,  92902,  92900,  92898,  92896,
    92894,  92892,  92890,  92888,  92886,  92884,  92882,  92880,  92878,  92876,  92874,  92872,  92870,  92868,
    92866,  92864,  92862,  92860,  92858,  92856,  92854,  92852,  92850,  92848,  92846,  92844,  92842,  92840,
    92838,  92836,  92834,  92832,  92830,  92828,  92826,  92824,  92822,  92820,  92818,  92815,  92813,  92811,
    92809,  92807,  92805,  92803,  92801,  92799,  92797,  92795,  92793,  92791,  92789,  92787,  92785,  92783,
    92781,  92779,  92777,  92775,  92773,  92771,  92769,  92767,  92765,  92763,  92761,  92759,  92757,  92755,
    92753,  92751,  92749,  92747,  92745,  92743,  92741,  92739,  92737,  92735,  92733,  92731,  92729,  92727,
    92725,  92723,  92721,  92719,  92717,  92715,  92713,  92711,  92709,  92707,  92705,  92703,  92701,  92699,
    92697,  92695,  92693,  92691,  92689,  92687,  92685,  92683,  92681,  92679,  92677,  92675,  92673,  92671,
    92669,  92667,  92665,  92663,  92661,  92659,  92657,  92655,  92653,  92651,  92649,  92647,  92645,  92643,
    92641,  92639,  92637,  92635,  92633,  92631,  92629,  92627,  92625,  92623,  92621,  92619,  92617,  92615,
    92613,  92611,  92609,  92607,  92605,  92603,  92601,  92599,  92597,  92595,  92593,  92591,  92589,  92587,
    92585,  92583,  92581,  92579,  92577,  92575,  92573,  92571,  92569,  92567,  92565,  92563,  92561,  92559,
    92557,  92555,  92553,  92551,  92549,  92547,  92546,  92544,  92542,  92540,  92538,  92536,  92534,  92532,
    92530,  92528,  92526,  92524,  92522,  92520,  92518,  92516,  92514,  92512,  92510,  92508,  92506,  92504,
    92502,  92500,  92498,  92496,  92494,  92492,  92490,  92488,  92486,  92484,  92482,  92480,  92478,  92476,
    92474,  92472,  92470,  92468,  92466,  92464,  92462,  92460,  92458,  92456,  92454,  92452,  92450,  92448,
    92446,  92444,  92442,  92440,  92438,  92436,  92434,  92432,  92430,  92428,  92426,  92424,  92422,  92420,
    92418,  92416,  92414,  92412,  92410,  92408,  92406,  92404,  92402,  92400,  92398,  92396,  92394,  92392,
    92390,  92388,  92386,  92384,  92382,  92380,  92378,  92376,  92374,  92372,  92370,  92368,  92366,  92364,
    92362,  92360,  92358,  92356,  92354,  92352,  92350,  92349,  92347,  92345,  92343,  92341,  92339,  92337,
    92335,  92333,  92331,  92329,  92327,  92325,  92323,  92321,  92319,  92317,  92315,  92313,  92311,  92309,
    92307,  92305,  92303,  92301,  92299,  92297,  92295,  92293,  92291,  92289,  92287,  92285,  92283,  92281,
    92279,  92277,  92275,  92273,  92271,  92269,  92267,  92265,  92263,  92261,  92259,  92257,  92255,  92253,
    92251,  92249,  92247,  92245,  92243,  92241,  92239,  92237,  92235,  92233,  92231,  92230,  92228,  92226,
    92224,  92222,  92220,  92218,  92216,  92214,  92212,  92210,  92208,  92206,  92204,  92202,  92200,  92198,
    92196,  92194,  92192,  92190,  92188,  92186,  92184,  92182,  92180,  92178,  92176,  92174,  92172,  92170,
    92168,  92166,  92164,  92162,  92160,  92158,  92156,  92154,  92152,  92150,  92148,  92146,  92144,  92142,
    92140,  92139,  92137,  92135,  92133,  92131,  92129,  92127,  92125,  92123,  92121,  92119,  92117,  92115,
    92113,  92111,  92109,  92107,  92105,  92103,  92101,  92099,  92097,  92095,  92093,  92091,  92089,  92087,
    92085,  92083,  92081,  92079,  92077,  92075,  92073,  92071,  92069,  92067,  92065,  92063,  92061,  92060,
    92058,  92056,  92054,  92052,  92050,  92048,  92046,  92044,  92042,  92040,  92038,  92036,  92034,  92032,
    92030,  92028,  92026,  92024,  92022,  92020,  92018,  92016,  92014,  92012,  92010,  92008,  92006,  92004,
    92002,  92000,  91998,  91996,  91994,  91992,  91990,  91989,  91987,  91985,  91983,  91981,  91979,  91977,
    91975,  91973,  91971,  91969,  91967,  91965,  91963,  91961,  91959,  91957,  91955,  91953,  91951,  91949,
    91947,  91945,  91943,  91941,  91939,  91937,  91935,  91933,  91931,  91929,  91927,  91926,  91924,  91922,
    91920,  91918,  91916,  91914,  91912,  91910,  91908,  91906,  91904,  91902,  91900,  91898,  91896,  91894,
    91892,  91890,  91888,  91886,  91884,  91882,  91880,  91878,  91876,  91874,  91872,  91870,  91868,  91867,
    91865,  91863,  91861,  91859,  91857,  91855,  91853,  91851,  91849,  91847,  91845,  91843,  91841,  91839,
    91837,  91835,  91833,  91831,  91829,  91827,  91825,  91823,  91821,  91819,  91817,  91815,  91814,  91812,
    91810,  91808,  91806,  91804,  91802,  91800,  91798,  91796,  91794,  91792,  91790,  91788,  91786,  91784,
    91782,  91780,  91778,  91776,  91774,  91772,  91770,  91768,  91766,  91764,  91763,  91761,  91759,  91757,
    91755,  91753,  91751,  91749,  91747,  91745,  91743,  91741,  91739,  91737,  91735,  91733,  91731,  91729,
    91727,  91725,  91723,  91721,  91719,  91717,  91715,  91714,  91712,  91710,  91708,  91706,  91704,  91702,
    91700,  91698,  91696,  91694,  91692,  91690,  91688,  91686,  91684,  91682,  91680,  91678,  91676,  91674,
    91672,  91670,  91668,  91667,  91665,  91663,  91661,  91659,  91657,  91655,  91653,  91651,  91649,  91647,
    91645,  91643,  91641,  91639,  91637,  91635,  91633,  91631,  91629,  91627,  91625,  91624,  91622,  91620,
    91618,  91616,  91614,  91612,  91610,  91608,  91606,  91604,  91602,  91600,  91598,  91596,  91594,  91592,
    91590,  91588,  91586,  91584,  91582,  91581,  91579,  91577,  91575,  91573,  91571,  91569,  91567,  91565,
    91563,  91561,  91559,  91557,  91555,  91553,  91551,  91549,  91547,  91545,  91543,  91541,  91540,  91538,
    91536,  91534,  91532,  91530,  91528,  91526,  91524,  91522,  91520,  91518,  91516,  91514,  91512,  91510,
    91508,  91506,  91504,  91502,  91501,  91499,  91497,  91495,  91493,  91491,  91489,  91487,  91485,  91483,
    91481,  91479,  91477,  91475,  91473,  91471,  91469,  91467,  91465,  91464,  91462,  91460,  91458,  91456,
    91454,  91452,  91450,  91448,  91446,  91444,  91442,  91440,  91438,  91436,  91434,  91432,  91430,  91428,
    91427,  91425,  91423,  91421,  91419,  91417,  91415,  91413,  91411,  91409,  91407,  91405,  91403,  91401,
    91399,  91397,  91395,  91393,  91392,  91390,  91388,  91386,  91384,  91382,  91380,  91378,  91376,  91374,
    91372,  91370,  91368,  91366,  91364,  91362,  91360,  91358,  91357,  91355,  91353,  91351,  91349,  91347,
    91345,  91343,  91341,  91339,  91337,  91335,  91333,  91331,  91329,  91327,  91325,  91323,  91322,  91320,
    91318,  91316,  91314,  91312,  91310,  91308,  91306,  91304,  91302,  91300,  91298,  91296,  91294,  91292,
    91290,  91289,  91287,  91285,  91283,  91281,  91279,  91277,  91275,  91273,  91271,  91269,  91267,  91265,
    91263,  91261,  91259,  91258,  91256,  91254,  91252,  91250,  91248,  91246,  91244,  91242,  91240,  91238,
    91236,  91234,  91232,  91230,  91228,  91227,  91225,  91223,  91221,  91219,  91217,  91215,  91213,  91211,
    91209,  91207,  91205,  91203,  91201,  91199,  91197,  91196,  91194,  91192,  91190,  91188,  91186,  91184,
    91182,  91180,  91178,  91176,  91174,  91172,  91170,  91168,  91166,  91165,  91163,  91161,  91159,  91157,
    91155,  91153,  91151,  91149,  91147,  91145,  91143,  91141,  91139,  91137,  91136,  91134,  91132,  91130,
    91128,  91126,  91124,  91122,  91120,  91118,  91116,  91114,  91112,  91110,  91108,  91107,  91105,  91103,
    91101,  91099,  91097,  91095,  91093,  91091,  91089,  91087,  91085,  91083,  91081,  91079,  91078,  91076,
    91074,  91072,  91070,  91068,  91066,  91064,  91062,  91060,  91058,  91056,  91054,  91052,  91051,  91049,
    91047,  91045,  91043,  91041,  91039,  91037,  91035,  91033,  91031,  91029,  91027,  91025,  91024,  91022,
    91020,  91018,  91016,  91014,  91012,  91010,  91008,  91006,  91004,  91002,  91000,  90998,  90997,  90995,
    90993,  90991,  90989,  90987,  90985,  90983,  90981,  90979,  90977,  90975,  90973,  90971,  90970,  90968,
    90966,  90964,  90962,  90960,  90958,  90956,  90954,  90952,  90950,  90948,  90946,  90944,  90943,  90941,
    90939,  90937,  90935,  90933,  90931,  90929,  90927,  90925,  90923,  90921,  90919,  90918,  90916,  90914,
    90912,  90910,  90908,  90906,  90904,  90902,  90900,  90898,  90896,  90894,  90893,  90891,  90889,  90887,
    90885,  90883,  90881,  90879,  90877,  90875,  90873,  90871,  90869,  90868,  90866,  90864,  90862,  90860,
    90858,  90856,  90854,  90852,  90850,  90848,  90846,  90844,  90843,  90841,  90839,  90837,  90835,  90833,
    90831,  90829,  90827,  90825,  90823,  90821,  90819,  90818,  90816,  90814,  90812,  90810,  90808,  90806,
    90804,  90802,  90800,  90798,  90796,  90795,  90793,  90791,  90789,  90787,  90785,  90783,  90781,  90779,
    90777,  90775,  90773,  90771,  90770,  90768,  90766,  90764,  90762,  90760,  90758,  90756,  90754,  90752,
    90750,  90748,  90747,  90745,  90743,  90741,  90739,  90737,  90735,  90733,  90731,  90729,  90727,  90725,
    90724,  90722,  90720,  90718,  90716,  90714,  90712,  90710,  90708,  90706,  90704,  90702,  90701,  90699,
    90697,  90695,  90693,  90691,  90689,  90687,  90685,  90683,  90681,  90679,  90678,  90676,  90674,  90672,
    90670,  90668,  90666,  90664,  90662,  90660,  90658,  90657,  90655,  90653,  90651,  90649,  90647,  90645,
    90643,  90641,  90639,  90637,  90635,  90634,  90632,  90630,  90628,  90626,  90624,  90622,  90620,  90618,
    90616,  90614,  90613,  90611,  90609,  90607,  90605,  90603,  90601,  90599,  90597,  90595,  90593,  90592,
    90590,  90588,  90586,  90584,  90582,  90580,  90578,  90576,  90574,  90572,  90571,  90569,  90567,  90565,
    90563,  90561,  90559,  90557,  90555,  90553,  90551,  90549,  90548,  90546,  90544,  90542,  90540,  90538,
    90536,  90534,  90532,  90530,  90529,  90527,  90525,  90523,  90521,  90519,  90517,  90515,  90513,  90511,
    90509,  90508,  90506,  90504,  90502,  90500,  90498,  90496,  90494,  90492,  90490,  90488,  90487,  90485,
    90483,  90481,  90479,  90477,  90475,  90473,  90471,  90469,  90467,  90466,  90464,  90462,  90460,  90458,
    90456,  90454,  90452,  90450,  90448,  90447,  90445,  90443,  90441,  90439,  90437,  90435,  90433,  90431,
    90429,  90427,  90426,  90424,  90422,  90420,  90418,  90416,  90414,  90412,  90410,  90408,  90407,  90405,
    90403,  90401,  90399,  90397,  90395,  90393,  90391,  90389,  90388,  90386,  90384,  90382,  90380,  90378,
    90376,  90374,  90372,  90370,  90369,  90367,  90365,  90363,  90361,  90359,  90357,  90355,  90353,  90351,
    90349,  90348,  90346,  90344,  90342,  90340,  90338,  90336,  90334,  90332,  90330,  90329,  90327,  90325,
    90323,  90321,  90319,  90317,  90315,  90313,  90311,  90310,  90308,  90306,  90304,  90302,  90300,  90298,
    90296,  90294,  90293,  90291,  90289,  90287,  90285,  90283,  90281,  90279,  90277,  90275,  90274,  90272,
    90270,  90268,  90266,  90264,  90262,  90260,  90258,  90256,  90255,  90253,  90251,  90249,  90247,  90245,
    90243,  90241,  90239,  90237,  90236,  90234,  90232,  90230,  90228,  90226,  90224,  90222,  90220,  90219,
    90217,  90215,  90213,  90211,  90209,  90207,  90205,  90203,  90201,  90200,  90198,  90196,  90194,  90192,
    90190,  90188,  90186,  90184,  90183,  90181,  90179,  90177,  90175,  90173,  90171,  90169,  90167,  90166,
    90164,  90162,  90160,  90158,  90156,  90154,  90152,  90150,  90148,  90147,  90145,  90143,  90141,  90139,
    90137,  90135,  90133,  90131,  90130,  90128,  90126,  90124,  90122,  90120,  90118,  90116,  90114,  90113,
    90111,  90109,  90107,  90105,  90103,  90101,  90099,  90097,  90096,  90094,  90092,  90090,  90088,  90086,
    90084,  90082,  90080,  90079,  90077,  90075,  90073,  90071,  90069,  90067,  90065,  90063,  90062,  90060,
    90058,  90056,  90054,  90052,  90050,  90048,  90046,  90045,  90043,  90041,  90039,  90037,  90035,  90033,
    90031,  90029,  90028,  90026,  90024,  90022,  90020,  90018,  90016,  90014,  90012,  90011,  90009,  90007,
    90005,  90003,  90001,  89999,  89997,  89995,  89994,  89992,  89990,  89988,  89986,  89984,  89982,  89980,
    89978,  89977,  89975,  89973,  89971,  89969,  89967,  89965,  89963,  89962,  89960,  89958,  89956,  89954,
    89952,  89950,  89948,  89946,  89945,  89943,  89941,  89939,  89937,  89935,  89933,  89931,  89930,  89928,
    89926,  89924,  89922,  89920,  89918,  89916,  89914,  89913,  89911,  89909,  89907,  89905,  89903,  89901,
    89899,  89898,  89896,  89894,  89892,  89890,  89888,  89886,  89884,  89882,  89881,  89879,  89877,  89875,
    89873,  89871,  89869,  89867,  89866,  89864,  89862,  89860,  89858,  89856,  89854,  89852,  89850,  89849,
    89847,  89845,  89843,  89841,  89839,  89837,  89835,  89834,  89832,  89830,  89828,  89826,  89824,  89822,
    89820,  89819,  89817,  89815,  89813,  89811,  89809,  89807,  89805,  89804,  89802,  89800,  89798,  89796,
    89794,  89792,  89790,  89789,  89787,  89785,  89783,  89781,  89779,  89777,  89775,  89773,  89772,  89770,
    89768,  89766,  89764,  89762,  89760,  89758,  89757,  89755,  89753,  89751,  89749,  89747,  89745,  89743,
    89742,  89740,  89738,  89736,  89734,  89732,  89730,  89728,  89727,  89725,  89723,  89721,  89719,  89717,
    89715,  89713,  89712,  89710,  89708,  89706,  89704,  89702,  89700,  89698,  89697,  89695,  89693,  89691,
    89689,  89687,  89685,  89684,  89682,  89680,  89678,  89676,  89674,  89672,  89670,  89669,  89667,  89665,
    89663,  89661,  89659,  89657,  89655,  89654,  89652,  89650,  89648,  89646,  89644,  89642,  89640,  89639,
    89637,  89635,  89633,  89631,  89629,  89627,  89625,  89624,  89622,  89620,  89618,  89616,  89614,  89612,
    89611,  89609,  89607,  89605,  89603,  89601,  89599,  89597,  89596,  89594,  89592,  89590,  89588,  89586,
    89584,  89583,  89581,  89579,  89577,  89575,  89573,  89571,  89569,  89568,  89566,  89564,  89562,  89560,
    89558,  89556,  89554,  89553,  89551,  89549,  89547,  89545,  89543,  89541,  89540,  89538,  89536,  89534,
    89532,  89530,  89528,  89526,  89525,  89523,  89521,  89519,  89517,  89515,  89513,  89512,  89510,  89508,
    89506,  89504,  89502,  89500,  89498,  89497,  89495,  89493,  89491,  89489,  89487,  89485,  89484,  89482,
    89480,  89478,  89476,  89474,  89472,  89471,  89469,  89467,  89465,  89463,  89461,  89459,  89457,  89456,
    89454,  89452,  89450,  89448,  89446,  89444,  89443,  89441,  89439,  89437,  89435,  89433,  89431,  89430,
    89428,  89426,  89424,  89422,  89420,  89418,  89417,  89415,  89413,  89411,  89409,  89407,  89405,  89403,
    89402,  89400,  89398,  89396,  89394,  89392,  89390,  89389,  89387,  89385,  89383,  89381,  89379,  89377,
    89376,  89374,  89372,  89370,  89368,  89366,  89364,  89363,  89361,  89359,  89357,  89355,  89353,  89351,
    89350,  89348,  89346,  89344,  89342,  89340,  89338,  89337,  89335,  89333,  89331,  89329,  89327,  89325,
    89324,  89322,  89320,  89318,  89316,  89314,  89312,  89311,  89309,  89307,  89305,  89303,  89301,  89299,
    89298,  89296,  89294,  89292,  89290,  89288,  89286,  89285,  89283,  89281,  89279,  89277,  89275,  89273,
    89272,  89270,  89268,  89266,  89264,  89262,  89260,  89259,  89257,  89255,  89253,  89251,  89249,  89247,
    89246,  89244,  89242,  89240,  89238,  89236,  89234,  89233,  89231,  89229,  89227,  89225,  89223,  89221,
    89220,  89218,  89216,  89214,  89212,  89210,  89209,  89207,  89205,  89203,  89201,  89199,  89197,  89196,
    89194,  89192,  89190,  89188,  89186,  89184,  89183,  89181,  89179,  89177,  89175,  89173,  89171,  89170,
    89168,  89166,  89164,  89162,  89160,  89159,  89157,  89155,  89153,  89151,  89149,  89147,  89146,  89144,
    89142,  89140,  89138,  89136,  89134,  89133,  89131,  89129,  89127,  89125,  89123,  89122,  89120,  89118,
    89116,  89114,  89112,  89110,  89109,  89107,  89105,  89103,  89101,  89099,  89097,  89096,  89094,  89092,
    89090,  89088,  89086,  89085,  89083,  89081,  89079,  89077,  89075,  89073,  89072,  89070,  89068,  89066,
    89064,  89062,  89061,  89059,  89057,  89055,  89053,  89051,  89049,  89048,  89046,  89044,  89042,  89040,
    89038,  89037,  89035,  89033,  89031,  89029,  89027,  89025,  89024,  89022,  89020,  89018,  89016,  89014,
    89013,  89011,  89009,  89007,  89005,  89003,  89001,  89000,  88998,  88996,  88994,  88992,  88990,  88989,
    88987,  88985,  88983,  88981,  88979,  88977,  88976,  88974,  88972,  88970,  88968,  88966,  88965,  88963,
    88961,  88959,  88957,  88955,  88954,  88952,  88950,  88948,  88946,  88944,  88942,  88941,  88939,  88937,
    88935,  88933,  88931,  88930,  88928,  88926,  88924,  88922,  88920,  88919,  88917,  88915,  88913,  88911,
    88909,  88907,  88906,  88904,  88902,  88900,  88898,  88896,  88895,  88893,  88891,  88889,  88887,  88885,
    88884,  88882,  88880,  88878,  88876,  88874,  88873,  88871,  88869,  88867,  88865,  88863,  88862,  88860,
    88858,  88856,  88854,  88852,  88850,  88849,  88847,  88845,  88843,  88841,  88839,  88838,  88836,  88834,
    88832,  88830,  88828,  88827,  88825,  88823,  88821,  88819,  88817,  88816,  88814,  88812,  88810,  88808,
    88806,  88805,  88803,  88801,  88799,  88797,  88795,  88794,  88792,  88790,  88788,  88786,  88784,  88783,
    88781,  88779,  88777,  88775,  88773,  88772,  88770,  88768,  88766,  88764,  88762,  88761,  88759,  88757,
    88755,  88753,  88751,  88749,  88748,  88746,  88744,  88742,  88740,  88738,  88737,  88735,  88733,  88731,
    88729,  88727,  88726,  88724,  88722,  88720,  88718,  88717,  88715,  88713,  88711,  88709,  88707,  88706,
    88704,  88702,  88700,  88698,  88696,  88695,  88693,  88691,  88689,  88687,  88685,  88684,  88682,  88680,
    88678,  88676,  88674,  88673,  88671,  88669,  88667,  88665,  88663,  88662,  88660,  88658,  88656,  88654,
    88652,  88651,  88649,  88647,  88645,  88643,  88641,  88640,  88638,  88636,  88634,  88632,  88630,  88629,
    88627,  88625,  88623,  88621,  88619,  88618,  88616,  88614,  88612,  88610,  88609,  88607,  88605,  88603,
    88601,  88599,  88598,  88596,  88594,  88592,  88590,  88588,  88587,  88585,  88583,  88581,  88579,  88577,
    88576,  88574,  88572,  88570,  88568,  88566,  88565,  88563,  88561,  88559,  88557,  88556,  88554,  88552,
    88550,  88548,  88546,  88545,  88543,  88541,  88539,  88537,  88535,  88534,  88532,  88530,  88528,  88526,
    88525,  88523,  88521,  88519,  88517,  88515,  88514,  88512,  88510,  88508,  88506,  88504,  88503,  88501,
    88499,  88497,  88495,  88493,  88492,  88490,  88488,  88486,  88484,  88483,  88481,  88479,  88477,  88475,
    88473,  88472,  88470,  88468,  88466,  88464,  88463,  88461,  88459,  88457,  88455,  88453,  88452,  88450,
    88448,  88446,  88444,  88442,  88441,  88439,  88437,  88435,  88433,  88432,  88430,  88428,  88426,  88424,
    88422,  88421,  88419,  88417,  88415,  88413,  88412,  88410,  88408,  88406,  88404,  88402,  88401,  88399,
    88397,  88395,  88393,  88392,  88390,  88388,  88386,  88384,  88382,  88381,  88379,  88377,  88375,  88373,
    88371,  88370,  88368,  88366,  88364,  88362,  88361,  88359,  88357,  88355,  88353,  88352,  88350,  88348,
    88346,  88344,  88342,  88341,  88339,  88337,  88335,  88333,  88332,  88330,  88328,  88326,  88324,  88322,
    88321,  88319,  88317,  88315,  88313,  88312,  88310,  88308,  88306,  88304,  88302,  88301,  88299,  88297,
    88295,  88293,  88292,  88290,  88288,  88286,  88284,  88282,  88281,  88279,  88277,  88275,  88273,  88272,
    88270,  88268,  88266,  88264,  88263,  88261,  88259,  88257,  88255,  88253,  88252,  88250,  88248,  88246,
    88244,  88243,  88241,  88239,  88237,  88235,  88234,  88232,  88230,  88228,  88226,  88224,  88223,  88221,
    88219,  88217,  88215,  88214,  88212,  88210,  88208,  88206,  88205,  88203,  88201,  88199,  88197,  88195,
    88194,  88192,  88190,  88188,  88186,  88185,  88183,  88181,  88179,  88177,  88176,  88174,  88172,  88170,
    88168,  88167,  88165,  88163,  88161,  88159,  88157,  88156,  88154,  88152,  88150,  88148,  88147,  88145,
    88143,  88141,  88139,  88138,  88136,  88134,  88132,  88130,  88129,  88127,  88125,  88123,  88121,  88119,
    88118,  88116,  88114,  88112,  88110,  88109,  88107,  88105,  88103,  88101,  88100,  88098,  88096,  88094,
    88092,  88091,  88089,  88087,  88085,  88083,  88082,  88080,  88078,  88076,  88074,  88072,  88071,  88069,
    88067,  88065,  88063,  88062,  88060,  88058,  88056,  88054,  88053,  88051,  88049,  88047,  88045,  88044,
    88042,  88040,  88038,  88036,  88035,  88033,  88031,  88029,  88027,  88026,  88024,  88022,  88020,  88018,
    88017,  88015,  88013,  88011,  88009,  88008,  88006,  88004,  88002,  88000,  87999,  87997,  87995,  87993,
    87991,  87989,  87988,  87986,  87984,  87982,  87980,  87979,  87977,  87975,  87973,  87971,  87970,  87968,
    87966,  87964,  87962,  87961,  87959,  87957,  87955,  87953,  87952,  87950,  87948,  87946,  87944,  87943,
    87941,  87939,  87937,  87935,  87934,  87932,  87930,  87928,  87926,  87925,  87923,  87921,  87919,  87917,
    87916,  87914,  87912,  87910,  87908,  87907,  87905,  87903,  87901,  87899,  87898,  87896,  87894,  87892,
    87890,  87889,  87887,  87885,  87883,  87881,  87880,  87878,  87876,  87874,  87872,  87871,  87869,  87867,
    87865,  87863,  87862,  87860,  87858,  87856,  87855,  87853,  87851,  87849,  87847,  87846,  87844,  87842,
    87840,  87838,  87837,  87835,  87833,  87831,  87829,  87828,  87826,  87824,  87822,  87820,  87819,  87817,
    87815,  87813,  87811,  87810,  87808,  87806,  87804,  87802,  87801,  87799,  87797,  87795,  87793,  87792,
    87790,  87788,  87786,  87784,  87783,  87781,  87779,  87777,  87776,  87774,  87772,  87770,  87768,  87767,
    87765,  87763,  87761,  87759,  87758,  87756,  87754,  87752,  87750,  87749,  87747,  87745,  87743,  87741,
    87740,  87738,  87736,  87734,  87732,  87731,  87729,  87727,  87725,  87724,  87722,  87720,  87718,  87716,
    87715,  87713,  87711,  87709,  87707,  87706,  87704,  87702,  87700,  87698,  87697,  87695,  87693,  87691,
    87689,  87688,  87686,  87684,  87682,  87681,  87679,  87677,  87675,  87673,  87672,  87670,  87668,  87666,
    87664,  87663,  87661,  87659,  87657,  87655,  87654,  87652,  87650,  87648,  87647,  87645,  87643,  87641,
    87639,  87638,  87636,  87634,  87632,  87630,  87629,  87627,  87625,  87623,  87621,  87620,  87618,  87616,
    87614,  87613,  87611,  87609,  87607,  87605,  87604,  87602,  87600,  87598,  87596,  87595,  87593,  87591,
    87589,  87588,  87586,  87584,  87582,  87580,  87579,  87577,  87575,  87573,  87571,  87570,  87568,  87566,
    87564,  87563,  87561,  87559,  87557,  87555,  87554,  87552,  87550,  87548,  87546,  87545,  87543,  87541,
    87539,  87538,  87536,  87534,  87532,  87530,  87529,  87527,  87525,  87523,  87522,  87520,  87518,  87516,
    87514,  87513,  87511,  87509,  87507,  87505,  87504,  87502,  87500,  87498,  87497,  87495,  87493,  87491,
    87489,  87488,  87486,  87484,  87482,  87481,  87479,  87477,  87475,  87473,  87472,  87470,  87468,  87466,
    87464,  87463,  87461,  87459,  87457,  87456,  87454,  87452,  87450,  87448,  87447,  87445,  87443,  87441,
    87440,  87438,  87436,  87434,  87432,  87431,  87429,  87427,  87425,  87424,  87422,  87420,  87418,  87416,
    87415,  87413,  87411,  87409,  87408,  87406,  87404,  87402,  87400,  87399,  87397,  87395,  87393,  87392,
    87390,  87388,  87386,  87384,  87383,  87381,  87379,  87377,  87376,  87374,  87372,  87370,  87368,  87367,
    87365,  87363,  87361,  87360,  87358,  87356,  87354,  87352,  87351,  87349,  87347,  87345,  87344,  87342,
    87340,  87338,  87336,  87335,  87333,  87331,  87329,  87328,  87326,  87324,  87322,  87320,  87319,  87317,
    87315,  87313,  87312,  87310,  87308,  87306,  87304,  87303,  87301,  87299,  87297,  87296,  87294,  87292,
    87290,  87288,  87287,  87285,  87283,  87281,  87280,  87278,  87276,  87274,  87273,  87271,  87269,  87267,
    87265,  87264,  87262,  87260,  87258,  87257,  87255,  87253,  87251,  87249,  87248,  87246,  87244,  87242,
    87241,  87239,  87237,  87235,  87234,  87232,  87230,  87228,  87226,  87225,  87223,  87221,  87219,  87218,
    87216,  87214,  87212,  87211,  87209,  87207,  87205,  87203,  87202,  87200,  87198,  87196,  87195,  87193,
    87191,  87189,  87187,  87186,  87184,  87182,  87180,  87179,  87177,  87175,  87173,  87172,  87170,  87168,
    87166,  87164,  87163,  87161,  87159,  87157,  87156,  87154,  87152,  87150,  87149,  87147,  87145,  87143,
    87141,  87140,  87138,  87136,  87134,  87133,  87131,  87129,  87127,  87126,  87124,  87122,  87120,  87119,
    87117,  87115,  87113,  87111,  87110,  87108,  87106,  87104,  87103,  87101,  87099,  87097,  87096,  87094,
    87092,  87090,  87088,  87087,  87085,  87083,  87081,  87080,  87078,  87076,  87074,  87073,  87071,  87069,
    87067,  87066,  87064,  87062,  87060,  87058,  87057,  87055,  87053,  87051,  87050,  87048,  87046,  87044,
    87043,  87041,  87039,  87037,  87036,  87034,  87032,  87030,  87028,  87027,  87025,  87023,  87021,  87020,
    87018,  87016,  87014,  87013,  87011,  87009,  87007,  87006,  87004,  87002,  87000,  86999,  86997,  86995,
    86993,  86991,  86990,  86988,  86986,  86984,  86983,  86981,  86979,  86977,  86976,  86974,  86972,  86970,
    86969,  86967,  86965,  86963,  86962,  86960,  86958,  86956,  86954,  86953,  86951,  86949,  86947,  86946,
    86944,  86942,  86940,  86939,  86937,  86935,  86933,  86932,  86930,  86928,  86926,  86925,  86923,  86921,
    86919,  86918,  86916,  86914,  86912,  86910,  86909,  86907,  86905,  86903,  86902,  86900,  86898,  86896,
    86895,  86893,  86891,  86889,  86888,  86886,  86884,  86882,  86881,  86879,  86877,  86875,  86874,  86872,
    86870,  86868,  86867,  86865,  86863,  86861,  86860,  86858,  86856,  86854,  86852,  86851,  86849,  86847,
    86845,  86844,  86842,  86840,  86838,  86837,  86835,  86833,  86831,  86830,  86828,  86826,  86824,  86823,
    86821,  86819,  86817,  86816,  86814,  86812,  86810,  86809,  86807,  86805,  86803,  86802,  86800,  86798,
    86796,  86795,  86793,  86791,  86789,  86788,  86786,  86784,  86782,  86781,  86779,  86777,  86775,  86774,
    86772,  86770,  86768,  86767,  86765,  86763,  86761,  86760,  86758,  86756,  86754,  86752,  86751,  86749,
    86747,  86745,  86744,  86742,  86740,  86738,  86737,  86735,  86733,  86731,  86730,  86728,  86726,  86724,
    86723,  86721,  86719,  86717,  86716,  86714,  86712,  86710,  86709,  86707,  86705,  86703,  86702,  86700,
    86698,  86696,  86695,  86693,  86691,  86689,  86688,  86686,  86684,  86682,  86681,  86679,  86677,  86675,
    86674,  86672,  86670,  86668,  86667,  86665,  86663,  86661,  86660,  86658,  86656,  86654,  86653,  86651,
    86649,  86647,  86646,  86644,  86642,  86640,  86639,  86637,  86635,  86634,  86632,  86630,  86628,  86627,
    86625,  86623,  86621,  86620,  86618,  86616,  86614,  86613,  86611,  86609,  86607,  86606,  86604,  86602,
    86600,  86599,  86597,  86595,  86593,  86592,  86590,  86588,  86586,  86585,  86583,  86581,  86579,  86578,
    86576,  86574,  86572,  86571,  86569,  86567,  86565,  86564,  86562,  86560,  86558,  86557,  86555,  86553,
    86551,  86550,  86548,  86546,  86544,  86543,  86541,  86539,  86538,  86536,  86534,  86532,  86531,  86529,
    86527,  86525,  86524,  86522,  86520,  86518,  86517,  86515,  86513,  86511,  86510,  86508,  86506,  86504,
    86503,  86501,  86499,  86497,  86496,  86494,  86492,  86490,  86489,  86487,  86485,  86483,  86482,  86480,
    86478,  86477,  86475,  86473,  86471,  86470,  86468,  86466,  86464,  86463,  86461,  86459,  86457,  86456,
    86454,  86452,  86450,  86449,  86447,  86445,  86443,  86442,  86440,  86438,  86436,  86435,  86433,  86431,
    86430,  86428,  86426,  86424,  86423,  86421,  86419,  86417,  86416,  86414,  86412,  86410,  86409,  86407,
    86405,  86403,  86402,  86400,  86398,  86396,  86395,  86393,  86391,  86390,  86388,  86386,  86384,  86383,
    86381,  86379,  86377,  86376,  86374,  86372,  86370,  86369,  86367,  86365,  86363,  86362,  86360,  86358,
    86357,  86355,  86353,  86351,  86350,  86348,  86346,  86344,  86343,  86341,  86339,  86337,  86336,  86334,
    86332,  86331,  86329,  86327,  86325,  86324,  86322,  86320,  86318,  86317,  86315,  86313,  86311,  86310,
    86308,  86306,  86304,  86303,  86301,  86299,  86298,  86296,  86294,  86292,  86291,  86289,  86287,  86285,
    86284,  86282,  86280,  86278,  86277,  86275,  86273,  86272,  86270,  86268,  86266,  86265,  86263,  86261,
    86259,  86258,  86256,  86254,  86252,  86251,  86249,  86247,  86246,  86244,  86242,  86240,  86239,  86237,
    86235,  86233,  86232,  86230,  86228,  86227,  86225,  86223,  86221,  86220,  86218,  86216,  86214,  86213,
    86211,  86209,  86207,  86206,  86204,  86202,  86201,  86199,  86197,  86195,  86194,  86192,  86190,  86188,
    86187,  86185,  86183,  86182,  86180,  86178,  86176,  86175,  86173,  86171,  86169,  86168,  86166,  86164,
    86163,  86161,  86159,  86157,  86156,  86154,  86152,  86150,  86149,  86147,  86145,  86143,  86142,  86140,
    86138,  86137,  86135,  86133,  86131,  86130,  86128,  86126,  86124,  86123,  86121,  86119,  86118,  86116,
    86114,  86112,  86111,  86109,  86107,  86106,  86104,  86102,  86100,  86099,  86097,  86095,  86093,  86092,
    86090,  86088,  86087,  86085,  86083,  86081,  86080,  86078,  86076,  86074,  86073,  86071,  86069,  86068,
    86066,  86064,  86062,  86061,  86059,  86057,  86055,  86054,  86052,  86050,  86049,  86047,  86045,  86043,
    86042,  86040,  86038,  86037,  86035,  86033,  86031,  86030,  86028,  86026,  86024,  86023,  86021,  86019,
    86018,  86016,  86014,  86012,  86011,  86009,  86007,  86005,  86004,  86002,  86000,  85999,  85997,  85995,
    85993,  85992,  85990,  85988,  85987,  85985,  85983,  85981,  85980,  85978,  85976,  85975,  85973,  85971,
    85969,  85968,  85966,  85964,  85962,  85961,  85959,  85957,  85956,  85954,  85952,  85950,  85949,  85947,
    85945,  85944,  85942,  85940,  85938,  85937,  85935,  85933,  85932,  85930,  85928,  85926,  85925,  85923,
    85921,  85919,  85918,  85916,  85914,  85913,  85911,  85909,  85907,  85906,  85904,  85902,  85901,  85899,
    85897,  85895,  85894,  85892,  85890,  85889,  85887,  85885,  85883,  85882,  85880,  85878,  85877,  85875,
    85873,  85871,  85870,  85868,  85866,  85865,  85863,  85861,  85859,  85858,  85856,  85854,  85852,  85851,
    85849,  85847,  85846,  85844,  85842,  85840,  85839,  85837,  85835,  85834,  85832,  85830,  85828,  85827,
    85825,  85823,  85822,  85820,  85818,  85816,  85815,  85813,  85811,  85810,  85808,  85806,  85804,  85803,
    85801,  85799,  85798,  85796,  85794,  85792,  85791,  85789,  85787,  85786,  85784,  85782,  85780,  85779,
    85777,  85775,  85774,  85772,  85770,  85768,  85767,  85765,  85763,  85762,  85760,  85758,  85756,  85755,
    85753,  85751,  85750,  85748,  85746,  85745,  85743,  85741,  85739,  85738,  85736,  85734,  85733,  85731,
    85729,  85727,  85726,  85724,  85722,  85721,  85719,  85717,  85715,  85714,  85712,  85710,  85709,  85707,
    85705,  85703,  85702,  85700,  85698,  85697,  85695,  85693,  85691,  85690,  85688,  85686,  85685,  85683,
    85681,  85680,  85678,  85676,  85674,  85673,  85671,  85669,  85668,  85666,  85664,  85662,  85661,  85659,
    85657,  85656,  85654,  85652,  85650,  85649,  85647,  85645,  85644,  85642,  85640,  85639,  85637,  85635,
    85633,  85632,  85630,  85628,  85627,  85625,  85623,  85621,  85620,  85618,  85616,  85615,  85613,  85611,
    85609,  85608,  85606,  85604,  85603,  85601,  85599,  85598,  85596,  85594,  85592,  85591,  85589,  85587,
    85586,  85584,  85582,  85580,  85579,  85577,  85575,  85574,  85572,  85570,  85569,  85567,  85565,  85563,
    85562,  85560,  85558,  85557,  85555,  85553,  85552,  85550,  85548,  85546,  85545,  85543,  85541,  85540,
    85538,  85536,  85534,  85533,  85531,  85529,  85528,  85526,  85524,  85523,  85521,  85519,  85517,  85516,
    85514,  85512,  85511,  85509,  85507,  85506,  85504,  85502,  85500,  85499,  85497,  85495,  85494,  85492,
    85490,  85489,  85487,  85485,  85483,  85482,  85480,  85478,  85477,  85475,  85473,  85471,  85470,  85468,
    85466,  85465,  85463,  85461,  85460,  85458,  85456,  85454,  85453,  85451,  85449,  85448,  85446,  85444,
    85443,  85441,  85439,  85437,  85436,  85434,  85432,  85431,  85429,  85427,  85426,  85424,  85422,  85420,
    85419,  85417,  85415,  85414,  85412,  85410,  85409,  85407,  85405,  85404,  85402,  85400,  85398,  85397,
    85395,  85393,  85392,  85390,  85388,  85387,  85385,  85383,  85381,  85380,  85378,  85376,  85375,  85373,
    85371,  85370,  85368,  85366,  85364,  85363,  85361,  85359,  85358,  85356,  85354,  85353,  85351,  85349,
    85348,  85346,  85344,  85342,  85341,  85339,  85337,  85336,  85334,  85332,  85331,  85329,  85327,  85325,
    85324,  85322,  85320,  85319,  85317,  85315,  85314,  85312,  85310,  85309,  85307,  85305,  85303,  85302,
    85300,  85298,  85297,  85295,  85293,  85292,  85290,  85288,  85286,  85285,  85283,  85281,  85280,  85278,
    85276,  85275,  85273,  85271,  85270,  85268,  85266,  85264,  85263,  85261,  85259,  85258,  85256,  85254,
    85253,  85251,  85249,  85248,  85246,  85244,  85242,  85241,  85239,  85237,  85236,  85234,  85232,  85231,
    85229,  85227,  85226,  85224,  85222,  85220,  85219,  85217,  85215,  85214,  85212,  85210,  85209,  85207,
    85205,  85204,  85202,  85200,  85199,  85197,  85195,  85193,  85192,  85190,  85188,  85187,  85185,  85183,
    85182,  85180,  85178,  85177,  85175,  85173,  85171,  85170,  85168,  85166,  85165,  85163,  85161,  85160,
    85158,  85156,  85155,  85153,  85151,  85150,  85148,  85146,  85144,  85143,  85141,  85139,  85138,  85136,
    85134,  85133,  85131,  85129,  85128,  85126,  85124,  85123,  85121,  85119,  85117,  85116,  85114,  85112,
    85111,  85109,  85107,  85106,  85104,  85102,  85101,  85099,  85097,  85096,  85094,  85092,  85090,  85089,
    85087,  85085,  85084,  85082,  85080,  85079,  85077,  85075,  85074,  85072,  85070,  85069,  85067,  85065,
    85064,  85062,  85060,  85058,  85057,  85055,  85053,  85052,  85050,  85048,  85047,  85045,  85043,  85042,
    85040,  85038,  85037,  85035,  85033,  85032,  85030,  85028,  85026,  85025,  85023,  85021,  85020,  85018,
    85016,  85015,  85013,  85011,  85010,  85008,  85006,  85005,  85003,  85001,  85000,  84998,  84996,  84995,
    84993,  84991,  84989,  84988,  84986,  84984,  84983,  84981,  84979,  84978,  84976,  84974,  84973,  84971,
    84969,  84968,  84966,  84964,  84963,  84961,  84959,  84958,  84956,  84954,  84952,  84951,  84949,  84947,
    84946,  84944,  84942,  84941,  84939,  84937,  84936,  84934,  84932,  84931,  84929,  84927,  84926,  84924,
    84922,  84921,  84919,  84917,  84916,  84914,  84912,  84910,  84909,  84907,  84905,  84904,  84902,  84900,
    84899,  84897,  84895,  84894,  84892,  84890,  84889,  84887,  84885,  84884,  84882,  84880,  84879,  84877,
    84875,  84874,  84872,  84870,  84869,  84867,  84865,  84864,  84862,  84860,  84858,  84857,  84855,  84853,
    84852,  84850,  84848,  84847,  84845,  84843,  84842,  84840,  84838,  84837,  84835,  84833,  84832,  84830,
    84828,  84827,  84825,  84823,  84822,  84820,  84818,  84817,  84815,  84813,  84812,  84810,  84808,  84807,
    84805,  84803,  84802,  84800,  84798,  84796,  84795,  84793,  84791,  84790,  84788,  84786,  84785,  84783,
    84781,  84780,  84778,  84776,  84775,  84773,  84771,  84770,  84768,  84766,  84765,  84763,  84761,  84760,
    84758,  84756,  84755,  84753,  84751,  84750,  84748,  84746,  84745,  84743,  84741,  84740,  84738,  84736,
    84735,  84733,  84731,  84730,  84728,  84726,  84725,  84723,  84721,  84720,  84718,  84716,  84715,  84713,
    84711,  84710,  84708,  84706,  84705,  84703,  84701,  84699,  84698,  84696,  84694,  84693,  84691,  84689,
    84688,  84686,  84684,  84683,  84681,  84679,  84678,  84676,  84674,  84673,  84671,  84669,  84668,  84666,
    84664,  84663,  84661,  84659,  84658,  84656,  84654,  84653,  84651,  84649,  84648,  84646,  84644,  84643,
    84641,  84639,  84638,  84636,  84634,  84633,  84631,  84629,  84628,  84626,  84624,  84623,  84621,  84619,
    84618,  84616,  84614,  84613,  84611,  84609,  84608,  84606,  84604,  84603,  84601,  84599,  84598,  84596,
    84594,  84593,  84591,  84589,  84588,  84586,  84584,  84583,  84581,  84579,  84578,  84576,  84574,  84573,
    84571,  84569,  84568,  84566,  84564,  84563,  84561,  84559,  84558,  84556,  84554,  84553,  84551,  84549,
    84548,  84546,  84544,  84543,  84541,  84539,  84538,  84536,  84534,  84533,  84531,  84529,  84528,  84526,
    84524,  84523,  84521,  84519,  84518,  84516,  84514,  84513,  84511,  84510,  84508,  84506,  84505,  84503,
    84501,  84500,  84498,  84496,  84495,  84493,  84491,  84490,  84488,  84486,  84485,  84483,  84481,  84480,
    84478,  84476,  84475,  84473,  84471,  84470,  84468,  84466,  84465,  84463,  84461,  84460,  84458,  84456,
    84455,  84453,  84451,  84450,  84448,  84446,  84445,  84443,  84441,  84440,  84438,  84436,  84435,  84433,
    84431,  84430,  84428,  84426,  84425,  84423,  84421,  84420,  84418,  84416,  84415,  84413,  84412,  84410,
    84408,  84407,  84405,  84403,  84402,  84400,  84398,  84397,  84395,  84393,  84392,  84390,  84388,  84387,
    84385,  84383,  84382,  84380,  84378,  84377,  84375,  84373,  84372,  84370,  84368,  84367,  84365,  84363,
    84362,  84360,  84358,  84357,  84355,  84353,  84352,  84350,  84349,  84347,  84345,  84344,  84342,  84340,
    84339,  84337,  84335,  84334,  84332,  84330,  84329,  84327,  84325,  84324,  84322,  84320,  84319,  84317,
    84315,  84314,  84312,  84310,  84309,  84307,  84305,  84304,  84302,  84301,  84299,  84297,  84296,  84294,
    84292,  84291,  84289,  84287,  84286,  84284,  84282,  84281,  84279,  84277,  84276,  84274,  84272,  84271,
    84269,  84267,  84266,  84264,  84262,  84261,  84259,  84258,  84256,  84254,  84253,  84251,  84249,  84248,
    84246,  84244,  84243,  84241,  84239,  84238,  84236,  84234,  84233,  84231,  84229,  84228,  84226,  84224,
    84223,  84221,  84220,  84218,  84216,  84215,  84213,  84211,  84210,  84208,  84206,  84205,  84203,  84201,
    84200,  84198,  84196,  84195,  84193,  84191,  84190,  84188,  84186,  84185,  84183,  84182,  84180,  84178,
    84177,  84175,  84173,  84172,  84170,  84168,  84167,  84165,  84163,  84162,  84160,  84158,  84157,  84155,
    84153,  84152,  84150,  84149,  84147,  84145,  84144,  84142,  84140,  84139,  84137,  84135,  84134,  84132,
    84130,  84129,  84127,  84125,  84124,  84122,  84121,  84119,  84117,  84116,  84114,  84112,  84111,  84109,
    84107,  84106,  84104,  84102,  84101,  84099,  84097,  84096,  84094,  84093,  84091,  84089,  84088,  84086,
    84084,  84083,  84081,  84079,  84078,  84076,  84074,  84073,  84071,  84069,  84068,  84066,  84065,  84063,
    84061,  84060,  84058,  84056,  84055,  84053,  84051,  84050,  84048,  84046,  84045,  84043,  84042,  84040,
    84038,  84037,  84035,  84033,  84032,  84030,  84028,  84027,  84025,  84023,  84022,  84020,  84019,  84017,
    84015,  84014,  84012,  84010,  84009,  84007,  84005,  84004,  84002,  84000,  83999,  83997,  83996,  83994,
    83992,  83991,  83989,  83987,  83986,  83984,  83982,  83981,  83979,  83977,  83976,  83974,  83973,  83971,
    83969,  83968,  83966,  83964,  83963,  83961,  83959,  83958,  83956,  83954,  83953,  83951,  83950,  83948,
    83946,  83945,  83943,  83941,  83940,  83938,  83936,  83935,  83933,  83931,  83930,  83928,  83927,  83925,
    83923,  83922,  83920,  83918,  83917,  83915,  83913,  83912,  83910,  83909,  83907,  83905,  83904,  83902,
    83900,  83899,  83897,  83895,  83894,  83892,  83890,  83889,  83887,  83886,  83884,  83882,  83881,  83879,
    83877,  83876,  83874,  83872,  83871,  83869,  83868,  83866,  83864,  83863,  83861,  83859,  83858,  83856,
    83854,  83853,  83851,  83850,  83848,  83846,  83845,  83843,  83841,  83840,  83838,  83836,  83835,  83833,
    83832,  83830,  83828,  83827,  83825,  83823,  83822,  83820,  83818,  83817,  83815,  83814,  83812,  83810,
    83809,  83807,  83805,  83804,  83802,  83800,  83799,  83797,  83796,  83794,  83792,  83791,  83789,  83787,
    83786,  83784,  83782,  83781,  83779,  83778,  83776,  83774,  83773,  83771,  83769,  83768,  83766,  83765,
    83763,  83761,  83760,  83758,  83756,  83755,  83753,  83751,  83750,  83748,  83747,  83745,  83743,  83742,
    83740,  83738,  83737,  83735,  83733,  83732,  83730,  83729,  83727,  83725,  83724,  83722,  83720,  83719,
    83717,  83716,  83714,  83712,  83711,  83709,  83707,  83706,  83704,  83702,  83701,  83699,  83698,  83696,
    83694,  83693,  83691,  83689,  83688,  83686,  83685,  83683,  83681,  83680,  83678,  83676,  83675,  83673,
    83672,  83670,  83668,  83667,  83665,  83663,  83662,  83660,  83658,  83657,  83655,  83654,  83652,  83650,
    83649,  83647,  83645,  83644,  83642,  83641,  83639,  83637,  83636,  83634,  83632,  83631,  83629,  83628,
    83626,  83624,  83623,  83621,  83619,  83618,  83616,  83614,  83613,  83611,  83610,  83608,  83606,  83605,
    83603,  83601,  83600,  83598,  83597,  83595,  83593,  83592,  83590,  83588,  83587,  83585,  83584,  83582,
    83580,  83579,  83577,  83575,  83574,  83572,  83571,  83569,  83567,  83566,  83564,  83562,  83561,  83559,
    83558,  83556,  83554,  83553,  83551,  83549,  83548,  83546,  83545,  83543,  83541,  83540,  83538,  83536,
    83535,  83533,  83532,  83530,  83528,  83527,  83525,  83523,  83522,  83520,  83519,  83517,  83515,  83514,
    83512,  83510,  83509,  83507,  83506,  83504,  83502,  83501,  83499,  83497,  83496,  83494,  83493,  83491,
    83489,  83488,  83486,  83484,  83483,  83481,  83480,  83478,  83476,  83475,  83473,  83471,  83470,  83468,
    83467,  83465,  83463,  83462,  83460,  83459,  83457,  83455,  83454,  83452,  83450,  83449,  83447,  83446,
    83444,  83442,  83441,  83439,  83437,  83436,  83434,  83433,  83431,  83429,  83428,  83426,  83424,  83423,
    83421,  83420,  83418,  83416,  83415,  83413,  83412,  83410,  83408,  83407,  83405,  83403,  83402,  83400,
    83399,  83397,  83395,  83394,  83392,  83390,  83389,  83387,  83386,  83384,  83382,  83381,  83379,  83377,
    83376,  83374,  83373,  83371,  83369,  83368,  83366,  83365,  83363,  83361,  83360,  83358,  83356,  83355,
    83353,  83352,  83350,  83348,  83347,  83345,  83344,  83342,  83340,  83339,  83337,  83335,  83334,  83332,
    83331,  83329,  83327,  83326,  83324,  83323,  83321,  83319,  83318,  83316,  83314,  83313,  83311,  83310,
    83308,  83306,  83305,  83303,  83301,  83300,  83298,  83297,  83295,  83293,  83292,  83290,  83289,  83287,
    83285,  83284,  83282,  83280,  83279,  83277,  83276,  83274,  83272,  83271,  83269,  83268,  83266,  83264,
    83263,  83261,  83260,  83258,  83256,  83255,  83253,  83251,  83250,  83248,  83247,  83245,  83243,  83242,
    83240,  83239,  83237,  83235,  83234,  83232,  83230,  83229,  83227,  83226,  83224,  83222,  83221,  83219,
    83218,  83216,  83214,  83213,  83211,  83210,  83208,  83206,  83205,  83203,  83201,  83200,  83198,  83197,
    83195,  83193,  83192,  83190,  83189,  83187,  83185,  83184,  83182,  83180,  83179,  83177,  83176,  83174,
    83172,  83171,  83169,  83168,  83166,  83164,  83163,  83161,  83160,  83158,  83156,  83155,  83153,  83152,
    83150,  83148,  83147,  83145,  83143,  83142,  83140,  83139,  83137,  83135,  83134,  83132,  83131,  83129,
    83127,  83126,  83124,  83123,  83121,  83119,  83118,  83116,  83114,  83113,  83111,  83110,  83108,  83106,
    83105,  83103,  83102,  83100,  83098,  83097,  83095,  83094,  83092,  83090,  83089,  83087,  83086,  83084,
    83082,  83081,  83079,  83078,  83076,  83074,  83073,  83071,  83069,  83068,  83066,  83065,  83063,  83061,
    83060,  83058,  83057,  83055,  83053,  83052,  83050,  83049,  83047,  83045,  83044,  83042,  83041,  83039,
    83037,  83036,  83034,  83033,  83031,  83029,  83028,  83026,  83025,  83023,  83021,  83020,  83018,  83016,
    83015,  83013,  83012,  83010,  83008,  83007,  83005,  83004,  83002,  83000,  82999,  82997,  82996,  82994,
    82992,  82991,  82989,  82988,  82986,  82984,  82983,  82981,  82980,  82978,  82976,  82975,  82973,  82972,
    82970,  82968,  82967,  82965,  82964,  82962,  82960,  82959,  82957,  82956,  82954,  82952,  82951,  82949,
    82948,  82946,  82944,  82943,  82941,  82940,  82938,  82936,  82935,  82933,  82932,  82930,  82928,  82927,
    82925,  82924,  82922,  82920,  82919,  82917,  82916,  82914,  82912,  82911,  82909,  82908,  82906,  82904,
    82903,  82901,  82900,  82898,  82896,  82895,  82893,  82892,  82890,  82888,  82887,  82885,  82884,  82882,
    82880,  82879,  82877,  82876,  82874,  82872,  82871,  82869,  82868,  82866,  82864,  82863,  82861,  82860,
    82858,  82856,  82855,  82853,  82852,  82850,  82848,  82847,  82845,  82844,  82842,  82840,  82839,  82837,
    82836,  82834,  82832,  82831,  82829,  82828,  82826,  82824,  82823,  82821,  82820,  82818,  82816,  82815,
    82813,  82812,  82810,  82808,  82807,  82805,  82804,  82802,  82800,  82799,  82797,  82796,  82794,  82792,
    82791,  82789,  82788,  82786,  82784,  82783,  82781,  82780,  82778,  82777,  82775,  82773,  82772,  82770,
    82769,  82767,  82765,  82764,  82762,  82761,  82759,  82757,  82756,  82754,  82753,  82751,  82749,  82748,
    82746,  82745,  82743,  82741,  82740,  82738,  82737,  82735,  82733,  82732,  82730,  82729,  82727,  82725,
    82724,  82722,  82721,  82719,  82718,  82716,  82714,  82713,  82711,  82710,  82708,  82706,  82705,  82703,
    82702,  82700,  82698,  82697,  82695,  82694,  82692,  82690,  82689,  82687,  82686,  82684,  82682,  82681,
    82679,  82678,  82676,  82675,  82673,  82671,  82670,  82668,  82667,  82665,  82663,  82662,  82660,  82659,
    82657,  82655,  82654,  82652,  82651,  82649,  82647,  82646,  82644,  82643,  82641,  82640,  82638,  82636,
    82635,  82633,  82632,  82630,  82628,  82627,  82625,  82624,  82622,  82620,  82619,  82617,  82616,  82614,
    82613,  82611,  82609,  82608,  82606,  82605,  82603,  82601,  82600,  82598,  82597,  82595,  82593,  82592,
    82590,  82589,  82587,  82585,  82584,  82582,  82581,  82579,  82578,  82576,  82574,  82573,  82571,  82570,
    82568,  82566,  82565,  82563,  82562,  82560,  82559,  82557,  82555,  82554,  82552,  82551,  82549,  82547,
    82546,  82544,  82543,  82541,  82539,  82538,  82536,  82535,  82533,  82532,  82530,  82528,  82527,  82525,
    82524,  82522,  82520,  82519,  82517,  82516,  82514,  82513,  82511,  82509,  82508,  82506,  82505,  82503,
    82501,  82500,  82498,  82497,  82495,  82493,  82492,  82490,  82489,  82487,  82486,  82484,  82482,  82481,
    82479,  82478,  82476,  82474,  82473,  82471,  82470,  82468,  82467,  82465,  82463,  82462,  82460,  82459,
    82457,  82455,  82454,  82452,  82451,  82449,  82448,  82446,  82444,  82443,  82441,  82440,  82438,  82436,
    82435,  82433,  82432,  82430,  82429,  82427,  82425,  82424,  82422,  82421,  82419,  82418,  82416,  82414,
    82413,  82411,  82410,  82408,  82406,  82405,  82403,  82402,  82400,  82399,  82397,  82395,  82394,  82392,
    82391,  82389,  82387,  82386,  82384,  82383,  82381,  82380,  82378,  82376,  82375,  82373,  82372,  82370,
    82369,  82367,  82365,  82364,  82362,  82361,  82359,  82357,  82356,  82354,  82353,  82351,  82350,  82348,
    82346,  82345,  82343,  82342,  82340,  82339,  82337,  82335,  82334,  82332,  82331,  82329,  82327,  82326,
    82324,  82323,  82321,  82320,  82318,  82316,  82315,  82313,  82312,  82310,  82309,  82307,  82305,  82304,
    82302,  82301,  82299,  82297,  82296,  82294,  82293,  82291,  82290,  82288,  82286,  82285,  82283,  82282,
    82280,  82279,  82277,  82275,  82274,  82272,  82271,  82269,  82268,  82266,  82264,  82263,  82261,  82260,
    82258,  82257,  82255,  82253,  82252,  82250,  82249,  82247,  82245,  82244,  82242,  82241,  82239,  82238,
    82236,  82234,  82233,  82231,  82230,  82228,  82227,  82225,  82223,  82222,  82220,  82219,  82217,  82216,
    82214,  82212,  82211,  82209,  82208,  82206,  82205,  82203,  82201,  82200,  82198,  82197,  82195,  82194,
    82192,  82190,  82189,  82187,  82186,  82184,  82183,  82181,  82179,  82178,  82176,  82175,  82173,  82172,
    82170,  82168,  82167,  82165,  82164,  82162,  82161,  82159,  82157,  82156,  82154,  82153,  82151,  82150,
    82148,  82146,  82145,  82143,  82142,  82140,  82139,  82137,  82135,  82134,  82132,  82131,  82129,  82128,
    82126,  82124,  82123,  82121,  82120,  82118,  82117,  82115,  82113,  82112,  82110,  82109,  82107,  82106,
    82104,  82102,  82101,  82099,  82098,  82096,  82095,  82093,  82091,  82090,  82088,  82087,  82085,  82084,
    82082,  82080,  82079,  82077,  82076,  82074,  82073,  82071,  82069,  82068,  82066,  82065,  82063,  82062,
    82060,  82058,  82057,  82055,  82054,  82052,  82051,  82049,  82048,  82046,  82044,  82043,  82041,  82040,
    82038,  82037,  82035,  82033,  82032,  82030,  82029,  82027,  82026,  82024,  82022,  82021,  82019,  82018,
    82016,  82015,  82013,  82011,  82010,  82008,  82007,  82005,  82004,  82002,  82001,  81999,  81997,  81996,
    81994,  81993,  81991,  81990,  81988,  81986,  81985,  81983,  81982,  81980,  81979,  81977,  81975,  81974,
    81972,  81971,  81969,  81968,  81966,  81965,  81963,  81961,  81960,  81958,  81957,  81955,  81954,  81952,
    81950,  81949,  81947,  81946,  81944,  81943,  81941,  81940,  81938,  81936,  81935,  81933,  81932,  81930,
    81929,  81927,  81925,  81924,  81922,  81921,  81919,  81918,  81916,  81915,  81913,  81911,  81910,  81908,
    81907,  81905,  81904,  81902,  81900,  81899,  81897,  81896,  81894,  81893,  81891,  81890,  81888,  81886,
    81885,  81883,  81882,  81880,  81879,  81877,  81875,  81874,  81872,  81871,  81869,  81868,  81866,  81865,
    81863,  81861,  81860,  81858,  81857,  81855,  81854,  81852,  81850,  81849,  81847,  81846,  81844,  81843,
    81841,  81840,  81838,  81836,  81835,  81833,  81832,  81830,  81829,  81827,  81826,  81824,  81822,  81821,
    81819,  81818,  81816,  81815,  81813,  81812,  81810,  81808,  81807,  81805,  81804,  81802,  81801,  81799,
    81797,  81796,  81794,  81793,  81791,  81790,  81788,  81787,  81785,  81783,  81782,  81780,  81779,  81777,
    81776,  81774,  81773,  81771,  81769,  81768,  81766,  81765,  81763,  81762,  81760,  81759,  81757,  81755,
    81754,  81752,  81751,  81749,  81748,  81746,  81745,  81743,  81741,  81740,  81738,  81737,  81735,  81734,
    81732,  81731,  81729,  81727,  81726,  81724,  81723,  81721,  81720,  81718,  81717,  81715,  81713,  81712,
    81710,  81709,  81707,  81706,  81704,  81703,  81701,  81699,  81698,  81696,  81695,  81693,  81692,  81690,
    81689,  81687,  81685,  81684,  81682,  81681,  81679,  81678,  81676,  81675,  81673,  81672,  81670,  81668,
    81667,  81665,  81664,  81662,  81661,  81659,  81658,  81656,  81654,  81653,  81651,  81650,  81648,  81647,
    81645,  81644,  81642,  81640,  81639,  81637,  81636,  81634,  81633,  81631,  81630,  81628,  81626,  81625,
    81623,  81622,  81620,  81619,  81617,  81616,  81614,  81613,  81611,  81609,  81608,  81606,  81605,  81603,
    81602,  81600,  81599,  81597,  81595,  81594,  81592,  81591,  81589,  81588,  81586,  81585,  81583,  81582,
    81580,  81578,  81577,  81575,  81574,  81572,  81571,  81569,  81568,  81566,  81564,  81563,  81561,  81560,
    81558,  81557,  81555,  81554,  81552,  81551,  81549,  81547,  81546,  81544,  81543,  81541,  81540,  81538,
    81537,  81535,  81534,  81532,  81530,  81529,  81527,  81526,  81524,  81523,  81521,  81520,  81518,  81516,
    81515,  81513,  81512,  81510,  81509,  81507,  81506,  81504,  81503,  81501,  81499,  81498,  81496,  81495,
    81493,  81492,  81490,  81489,  81487,  81486,  81484,  81482,  81481,  81479,  81478,  81476,  81475,  81473,
    81472,  81470,  81469,  81467,  81465,  81464,  81462,  81461,  81459,  81458,  81456,  81455,  81453,  81452,
    81450,  81448,  81447,  81445,  81444,  81442,  81441,  81439,  81438,  81436,  81435,  81433,  81431,  81430,
    81428,  81427,  81425,  81424,  81422,  81421,  81419,  81418,  81416,  81415,  81413,  81411,  81410,  81408,
    81407,  81405,  81404,  81402,  81401,  81399,  81398,  81396,  81394,  81393,  81391,  81390,  81388,  81387,
    81385,  81384,  81382,  81381,  81379,  81377,  81376,  81374,  81373,  81371,  81370,  81368,  81367,  81365,
    81364,  81362,  81361,  81359,  81357,  81356,  81354,  81353,  81351,  81350,  81348,  81347,  81345,  81344,
    81342,  81341,  81339,  81337,  81336,  81334,  81333,  81331,  81330,  81328,  81327,  81325,  81324,  81322,
    81320,  81319,  81317,  81316,  81314,  81313,  81311,  81310,  81308,  81307,  81305,  81304,  81302,  81300,
    81299,  81297,  81296,  81294,  81293,  81291,  81290,  81288,  81287,  81285,  81284,  81282,  81280,  81279,
    81277,  81276,  81274,  81273,  81271,  81270,  81268,  81267,  81265,  81264,  81262,  81260,  81259,  81257,
    81256,  81254,  81253,  81251,  81250,  81248,  81247,  81245,  81244,  81242,  81240,  81239,  81237,  81236,
    81234,  81233,  81231,  81230,  81228,  81227,  81225,  81224,  81222,  81221,  81219,  81217,  81216,  81214,
    81213,  81211,  81210,  81208,  81207,  81205,  81204,  81202,  81201,  81199,  81197,  81196,  81194,  81193,
    81191,  81190,  81188,  81187,  81185,  81184,  81182,  81181,  81179,  81178,  81176,  81174,  81173,  81171,
    81170,  81168,  81167,  81165,  81164,  81162,  81161,  81159,  81158,  81156,  81155,  81153,  81151,  81150,
    81148,  81147,  81145,  81144,  81142,  81141,  81139,  81138,  81136,  81135,  81133,  81132,  81130,  81128,
    81127,  81125,  81124,  81122,  81121,  81119,  81118,  81116,  81115,  81113,  81112,  81110,  81109,  81107,
    81105,  81104,  81102,  81101,  81099,  81098,  81096,  81095,  81093,  81092,  81090,  81089,  81087,  81086,
    81084,  81083,  81081,  81079,  81078,  81076,  81075,  81073,  81072,  81070,  81069,  81067,  81066,  81064,
    81063,  81061,  81060,  81058,  81057,  81055,  81053,  81052,  81050,  81049,  81047,  81046,  81044,  81043,
    81041,  81040,  81038,  81037,  81035,  81034,  81032,  81031,  81029,  81027,  81026,  81024,  81023,  81021,
    81020,  81018,  81017,  81015,  81014,  81012,  81011,  81009,  81008,  81006,  81005,  81003,  81001,  81000,
    80998,  80997,  80995,  80994,  80992,  80991,  80989,  80988,  80986,  80985,  80983,  80982,  80980,  80979,
    80977,  80976,  80974,  80972,  80971,  80969,  80968,  80966,  80965,  80963,  80962,  80960,  80959,  80957,
    80956,  80954,  80953,  80951,  80950,  80948,  80947,  80945,  80943,  80942,  80940,  80939,  80937,  80936,
    80934,  80933,  80931,  80930,  80928,  80927,  80925,  80924,  80922,  80921,  80919,  80918,  80916,  80914,
    80913,  80911,  80910,  80908,  80907,  80905,  80904,  80902,  80901,  80899,  80898,  80896,  80895,  80893,
    80892,  80890,  80889,  80887,  80886,  80884,  80882,  80881,  80879,  80878,  80876,  80875,  80873,  80872,
    80870,  80869,  80867,  80866,  80864,  80863,  80861,  80860,  80858,  80857,  80855,  80854,  80852,  80851,
    80849,  80847,  80846,  80844,  80843,  80841,  80840,  80838,  80837,  80835,  80834,  80832,  80831,  80829,
    80828,  80826,  80825,  80823,  80822,  80820,  80819,  80817,  80816,  80814,  80812,  80811,  80809,  80808,
    80806,  80805,  80803,  80802,  80800,  80799,  80797,  80796,  80794,  80793,  80791,  80790,  80788,  80787,
    80785,  80784,  80782,  80781,  80779,  80778,  80776,  80774,  80773,  80771,  80770,  80768,  80767,  80765,
    80764,  80762,  80761,  80759,  80758,  80756,  80755,  80753,  80752,  80750,  80749,  80747,  80746,  80744,
    80743,  80741,  80740,  80738,  80737,  80735,  80733,  80732,  80730,  80729,  80727,  80726,  80724,  80723,
    80721,  80720,  80718,  80717,  80715,  80714,  80712,  80711,  80709,  80708,  80706,  80705,  80703,  80702,
    80700,  80699,  80697,  80696,  80694,  80693,  80691,  80690,  80688,  80686,  80685,  80683,  80682,  80680,
    80679,  80677,  80676,  80674,  80673,  80671,  80670,  80668,  80667,  80665,  80664,  80662,  80661,  80659,
    80658,  80656,  80655,  80653,  80652,  80650,  80649,  80647,  80646,  80644,  80643,  80641,  80640,  80638,
    80636,  80635,  80633,  80632,  80630,  80629,  80627,  80626,  80624,  80623,  80621,  80620,  80618,  80617,
    80615,  80614,  80612,  80611,  80609,  80608,  80606,  80605,  80603,  80602,  80600,  80599,  80597,  80596,
    80594,  80593,  80591,  80590,  80588,  80587,  80585,  80584,  80582,  80581,  80579,  80577,  80576,  80574,
    80573,  80571,  80570,  80568,  80567,  80565,  80564,  80562,  80561,  80559,  80558,  80556,  80555,  80553,
    80552,  80550,  80549,  80547,  80546,  80544,  80543,  80541,  80540,  80538,  80537,  80535,  80534,  80532,
    80531,  80529,  80528,  80526,  80525,  80523,  80522,  80520,  80519,  80517,  80516,  80514,  80513,  80511,
    80510,  80508,  80506,  80505,  80503,  80502,  80500,  80499,  80497,  80496,  80494,  80493,  80491,  80490,
    80488,  80487,  80485,  80484,  80482,  80481,  80479,  80478,  80476,  80475,  80473,  80472,  80470,  80469,
    80467,  80466,  80464,  80463,  80461,  80460,  80458,  80457,  80455,  80454,  80452,  80451,  80449,  80448,
    80446,  80445,  80443,  80442,  80440,  80439,  80437,  80436,  80434,  80433,  80431,  80430,  80428,  80427,
    80425,  80424,  80422,  80421,  80419,  80418,  80416,  80415,  80413,  80412,  80410,  80409,  80407,  80406,
    80404,  80403,  80401,  80399,  80398,  80396,  80395,  80393,  80392,  80390,  80389,  80387,  80386,  80384,
    80383,  80381,  80380,  80378,  80377,  80375,  80374,  80372,  80371,  80369,  80368,  80366,  80365,  80363,
    80362,  80360,  80359,  80357,  80356,  80354,  80353,  80351,  80350,  80348,  80347,  80345,  80344,  80342,
    80341,  80339,  80338,  80336,  80335,  80333,  80332,  80330,  80329,  80327,  80326,  80324,  80323,  80321,
    80320,  80318,  80317,  80315,  80314,  80312,  80311,  80309,  80308,  80306,  80305,  80303,  80302,  80300,
    80299,  80297,  80296,  80294,  80293,  80291,  80290,  80288,  80287,  80285,  80284,  80282,  80281,  80279,
    80278,  80276,  80275,  80273,  80272,  80270,  80269,  80267,  80266,  80264,  80263,  80261,  80260,  80258,
    80257,  80255,  80254,  80252,  80251,  80249,  80248,  80246,  80245,  80243,  80242,  80240,  80239,  80237,
    80236,  80234,  80233,  80231,  80230,  80228,  80227,  80225,  80224,  80222,  80221,  80219,  80218,  80216,
    80215,  80213,  80212,  80210,  80209,  80207,  80206,  80204,  80203,  80201,  80200,  80198,  80197,  80195,
    80194,  80192,  80191,  80189,  80188,  80186,  80185,  80183,  80182,  80180,  80179,  80177,  80176,  80174,
    80173,  80171,  80170,  80168,  80167,  80165,  80164,  80162,  80161,  80159,  80158,  80156,  80155,  80153,
    80152,  80150,  80149,  80147,  80146,  80144,  80143,  80141,  80140,  80138,  80137,  80135,  80134,  80132,
    80131,  80129,  80128,  80127,  80125,  80124,  80122,  80121,  80119,  80118,  80116,  80115,  80113,  80112,
    80110,  80109,  80107,  80106,  80104,  80103,  80101,  80100,  80098,  80097,  80095,  80094,  80092,  80091,
    80089,  80088,  80086,  80085,  80083,  80082,  80080,  80079,  80077,  80076,  80074,  80073,  80071,  80070,
    80068,  80067,  80065,  80064,  80062,  80061,  80059,  80058,  80056,  80055,  80053,  80052,  80050,  80049,
    80047,  80046,  80044,  80043,  80041,  80040,  80038,  80037,  80035,  80034,  80032,  80031,  80029,  80028,
    80026,  80025,  80023,  80022,  80021,  80019,  80018,  80016,  80015,  80013,  80012,  80010,  80009,  80007,
    80006,  80004,  80003,  80001,  80000,  79998,  79997,  79995,  79994,  79992,  79991,  79989,  79988,  79986,
    79985,  79983,  79982,  79980,  79979,  79977,  79976,  79974,  79973,  79971,  79970,  79968,  79967,  79965,
    79964,  79962,  79961,  79959,  79958,  79956,  79955,  79953,  79952,  79950,  79949,  79948,  79946,  79945,
    79943,  79942,  79940,  79939,  79937,  79936,  79934,  79933,  79931,  79930,  79928,  79927,  79925,  79924,
    79922,  79921,  79919,  79918,  79916,  79915,  79913,  79912,  79910,  79909,  79907,  79906,  79904,  79903,
    79901,  79900,  79898,  79897,  79895,  79894,  79892,  79891,  79890,  79888,  79887,  79885,  79884,  79882,
    79881,  79879,  79878,  79876,  79875,  79873,  79872,  79870,  79869,  79867,  79866,  79864,  79863,  79861,
    79860,  79858,  79857,  79855,  79854,  79852,  79851,  79849,  79848,  79846,  79845,  79843,  79842,  79841,
    79839,  79838,  79836,  79835,  79833,  79832,  79830,  79829,  79827,  79826,  79824,  79823,  79821,  79820,
    79818,  79817,  79815,  79814,  79812,  79811,  79809,  79808,  79806,  79805,  79803,  79802,  79800,  79799,
    79797,  79796,  79795,  79793,  79792,  79790,  79789,  79787,  79786,  79784,  79783,  79781,  79780,  79778,
    79777,  79775,  79774,  79772,  79771,  79769,  79768,  79766,  79765,  79763,  79762,  79760,  79759,  79757,
    79756,  79755,  79753,  79752,  79750,  79749,  79747,  79746,  79744,  79743,  79741,  79740,  79738,  79737,
    79735,  79734,  79732,  79731,  79729,  79728,  79726,  79725,  79723,  79722,  79720,  79719,  79718,  79716,
    79715,  79713,  79712,  79710,  79709,  79707,  79706,  79704,  79703,  79701,  79700,  79698,  79697,  79695,
    79694,  79692,  79691,  79689,  79688,  79686,  79685,  79683,  79682,  79681,  79679,  79678,  79676,  79675,
    79673,  79672,  79670,  79669,  79667,  79666,  79664,  79663,  79661,  79660,  79658,  79657,  79655,  79654,
    79652,  79651,  79650,  79648,  79647,  79645,  79644,  79642,  79641,  79639,  79638,  79636,  79635,  79633,
    79632,  79630,  79629,  79627,  79626,  79624,  79623,  79621,  79620,  79619,  79617,  79616,  79614,  79613,
    79611,  79610,  79608,  79607,  79605,  79604,  79602,  79601,  79599,  79598,  79596,  79595,  79593,  79592,
    79590,  79589,  79588,  79586,  79585,  79583,  79582,  79580,  79579,  79577,  79576,  79574,  79573,  79571,
    79570,  79568,  79567,  79565,  79564,  79562,  79561,  79560,  79558,  79557,  79555,  79554,  79552,  79551,
    79549,  79548,  79546,  79545,  79543,  79542,  79540,  79539,  79537,  79536,  79534,  79533,  79532,  79530,
    79529,  79527,  79526,  79524,  79523,  79521,  79520,  79518,  79517,  79515,  79514,  79512,  79511,  79509,
    79508,  79506,  79505,  79504,  79502,  79501,  79499,  79498,  79496,  79495,  79493,  79492,  79490,  79489,
    79487,  79486,  79484,  79483,  79481,  79480,  79479,  79477,  79476,  79474,  79473,  79471,  79470,  79468,
    79467,  79465,  79464,  79462,  79461,  79459,  79458,  79456,  79455,  79454,  79452,  79451,  79449,  79448,
    79446,  79445,  79443,  79442,  79440,  79439,  79437,  79436,  79434,  79433,  79431,  79430,  79429,  79427,
    79426,  79424,  79423,  79421,  79420,  79418,  79417,  79415,  79414,  79412,  79411,  79409,  79408,  79407,
    79405,  79404,  79402,  79401,  79399,  79398,  79396,  79395,  79393,  79392,  79390,  79389,  79387,  79386,
    79385,  79383,  79382,  79380,  79379,  79377,  79376,  79374,  79373,  79371,  79370,  79368,  79367,  79365,
    79364,  79363,  79361,  79360,  79358,  79357,  79355,  79354,  79352,  79351,  79349,  79348,  79346,  79345,
    79343,  79342,  79341,  79339,  79338,  79336,  79335,  79333,  79332,  79330,  79329,  79327,  79326,  79324,
    79323,  79321,  79320,  79319,  79317,  79316,  79314,  79313,  79311,  79310,  79308,  79307,  79305,  79304,
    79302,  79301,  79300,  79298,  79297,  79295,  79294,  79292,  79291,  79289,  79288,  79286,  79285,  79283,
    79282,  79280,  79279,  79278,  79276,  79275,  79273,  79272,  79270,  79269,  79267,  79266,  79264,  79263,
    79261,  79260,  79259,  79257,  79256,  79254,  79253,  79251,  79250,  79248,  79247,  79245,  79244,  79242,
    79241,  79240,  79238,  79237,  79235,  79234,  79232,  79231,  79229,  79228,  79226,  79225,  79223,  79222,
    79221,  79219,  79218,  79216,  79215,  79213,  79212,  79210,  79209,  79207,  79206,  79204,  79203,  79202,
    79200,  79199,  79197,  79196,  79194,  79193,  79191,  79190,  79188,  79187,  79185,  79184,  79183,  79181,
    79180,  79178,  79177,  79175,  79174,  79172,  79171,  79169,  79168,  79166,  79165,  79164,  79162,  79161,
    79159,  79158,  79156,  79155,  79153,  79152,  79150,  79149,  79148,  79146,  79145,  79143,  79142,  79140,
    79139,  79137,  79136,  79134,  79133,  79131,  79130,  79129,  79127,  79126,  79124,  79123,  79121,  79120,
    79118,  79117,  79115,  79114,  79113,  79111,  79110,  79108,  79107,  79105,  79104,  79102,  79101,  79099,
    79098,  79097,  79095,  79094,  79092,  79091,  79089,  79088,  79086,  79085,  79083,  79082,  79080,  79079,
    79078,  79076,  79075,  79073,  79072,  79070,  79069,  79067,  79066,  79064,  79063,  79062,  79060,  79059,
    79057,  79056,  79054,  79053,  79051,  79050,  79048,  79047,  79046,  79044,  79043,  79041,  79040,  79038,
    79037,  79035,  79034,  79032,  79031,  79030,  79028,  79027,  79025,  79024,  79022,  79021,  79019,  79018,
    79016,  79015,  79014,  79012,  79011,  79009,  79008,  79006,  79005,  79003,  79002,  79000,  78999,  78998,
    78996,  78995,  78993,  78992,  78990,  78989,  78987,  78986,  78985,  78983,  78982,  78980,  78979,  78977,
    78976,  78974,  78973,  78971,  78970,  78969,  78967,  78966,  78964,  78963,  78961,  78960,  78958,  78957,
    78955,  78954,  78953,  78951,  78950,  78948,  78947,  78945,  78944,  78942,  78941,  78939,  78938,  78937,
    78935,  78934,  78932,  78931,  78929,  78928,  78926,  78925,  78924,  78922,  78921,  78919,  78918,  78916,
    78915,  78913,  78912,  78910,  78909,  78908,  78906,  78905,  78903,  78902,  78900,  78899,  78897,  78896,
    78895,  78893,  78892,  78890,  78889,  78887,  78886,  78884,  78883,  78882,  78880,  78879,  78877,  78876,
    78874,  78873,  78871,  78870,  78868,  78867,  78866,  78864,  78863,  78861,  78860,  78858,  78857,  78855,
    78854,  78853,  78851,  78850,  78848,  78847,  78845,  78844,  78842,  78841,  78840,  78838,  78837,  78835,
    78834,  78832,  78831,  78829,  78828,  78826,  78825,  78824,  78822,  78821,  78819,  78818,  78816,  78815,
    78813,  78812,  78811,  78809,  78808,  78806,  78805,  78803,  78802,  78800,  78799,  78798,  78796,  78795,
    78793,  78792,  78790,  78789,  78787,  78786,  78785,  78783,  78782,  78780,  78779,  78777,  78776,  78774,
    78773,  78772,  78770,  78769,  78767,  78766,  78764,  78763,  78761,  78760,  78759,  78757,  78756,  78754,
    78753,  78751,  78750,  78748,  78747,  78746,  78744,  78743,  78741,  78740,  78738,  78737,  78735,  78734,
    78733,  78731,  78730,  78728,  78727,  78725,  78724,  78722,  78721,  78720,  78718,  78717,  78715,  78714,
    78712,  78711,  78709,  78708,  78707,  78705,  78704,  78702,  78701,  78699,  78698,  78697,  78695,  78694,
    78692,  78691,  78689,  78688,  78686,  78685,  78684,  78682,  78681,  78679,  78678,  78676,  78675,  78673,
    78672,  78671,  78669,  78668,  78666,  78665,  78663,  78662,  78660,  78659,  78658,  78656,  78655,  78653,
    78652,  78650,  78649,  78648,  78646,  78645,  78643,  78642,  78640,  78639,  78637,  78636,  78635,  78633,
    78632,  78630,  78629,  78627,  78626,  78624,  78623,  78622,  78620,  78619,  78617,  78616,  78614,  78613,
    78612,  78610,  78609,  78607,  78606,  78604,  78603,  78601,  78600,  78599,  78597,  78596,  78594,  78593,
    78591,  78590,  78589,  78587,  78586,  78584,  78583,  78581,  78580,  78578,  78577,  78576,  78574,  78573,
    78571,  78570,  78568,  78567,  78565,  78564,  78563,  78561,  78560,  78558,  78557,  78555,  78554,  78553,
    78551,  78550,  78548,  78547,  78545,  78544,  78543,  78541,  78540,  78538,  78537,  78535,  78534,  78532,
    78531,  78530,  78528,  78527,  78525,  78524,  78522,  78521,  78520,  78518,  78517,  78515,  78514,  78512,
    78511,  78509,  78508,  78507,  78505,  78504,  78502,  78501,  78499,  78498,  78497,  78495,  78494,  78492,
    78491,  78489,  78488,  78487,  78485,  78484,  78482,  78481,  78479,  78478,  78476,  78475,  78474,  78472,
    78471,  78469,  78468,  78466,  78465,  78464,  78462,  78461,  78459,  78458,  78456,  78455,  78454,  78452,
    78451,  78449,  78448,  78446,  78445,  78444,  78442,  78441,  78439,  78438,  78436,  78435,  78434,  78432,
    78431,  78429,  78428,  78426,  78425,  78423,  78422,  78421,  78419,  78418,  78416,  78415,  78413,  78412,
    78411,  78409,  78408,  78406,  78405,  78403,  78402,  78401,  78399,  78398,  78396,  78395,  78393,  78392,
    78391,  78389,  78388,  78386,  78385,  78383,  78382,  78381,  78379,  78378,  78376,  78375,  78373,  78372,
    78371,  78369,  78368,  78366,  78365,  78363,  78362,  78361,  78359,  78358,  78356,  78355,  78353,  78352,
    78351,  78349,  78348,  78346,  78345,  78343,  78342,  78341,  78339,  78338,  78336,  78335,  78333,  78332,
    78331,  78329,  78328,  78326,  78325,  78323,  78322,  78321,  78319,  78318,  78316,  78315,  78313,  78312,
    78311,  78309,  78308,  78306,  78305,  78303,  78302,  78301,  78299,  78298,  78296,  78295,  78293,  78292,
    78291,  78289,  78288,  78286,  78285,  78283,  78282,  78281,  78279,  78278,  78276,  78275,  78273,  78272,
    78271,  78269,  78268,  78266,  78265,  78263,  78262,  78261,  78259,  78258,  78256,  78255,  78253,  78252,
    78251,  78249,  78248,  78246,  78245,  78243,  78242,  78241,  78239,  78238,  78236,  78235,  78233,  78232,
    78231,  78229,  78228,  78226,  78225,  78224,  78222,  78221,  78219,  78218,  78216,  78215,  78214,  78212,
    78211,  78209,  78208,  78206,  78205,  78204,  78202,  78201,  78199,  78198,  78196,  78195,  78194,  78192,
    78191,  78189,  78188,  78186,  78185,  78184,  78182,  78181,  78179,  78178,  78177,  78175,  78174,  78172,
    78171,  78169,  78168,  78167,  78165,  78164,  78162,  78161,  78159,  78158,  78157,  78155,  78154,  78152,
    78151,  78149,  78148,  78147,  78145,  78144,  78142,  78141,  78140,  78138,  78137,  78135,  78134,  78132,
    78131,  78130,  78128,  78127,  78125,  78124,  78122,  78121,  78120,  78118,  78117,  78115,  78114,  78113,
    78111,  78110,  78108,  78107,  78105,  78104,  78103,  78101,  78100,  78098,  78097,  78095,  78094,  78093,
    78091,  78090,  78088,  78087,  78086,  78084,  78083,  78081,  78080,  78078,  78077,  78076,  78074,  78073,
    78071,  78070,  78069,  78067,  78066,  78064,  78063,  78061,  78060,  78059,  78057,  78056,  78054,  78053,
    78052,  78050,  78049,  78047,  78046,  78044,  78043,  78042,  78040,  78039,  78037,  78036,  78034,  78033,
    78032,  78030,  78029,  78027,  78026,  78025,  78023,  78022,  78020,  78019,  78017,  78016,  78015,  78013,
    78012,  78010,  78009,  78008,  78006,  78005,  78003,  78002,  78000,  77999,  77998,  77996,  77995,  77993,
    77992,  77991,  77989,  77988,  77986,  77985,  77983,  77982,  77981,  77979,  77978,  77976,  77975,  77974,
    77972,  77971,  77969,  77968,  77966,  77965,  77964,  77962,  77961,  77959,  77958,  77957,  77955,  77954,
    77952,  77951,  77950,  77948,  77947,  77945,  77944,  77942,  77941,  77940,  77938,  77937,  77935,  77934,
    77933,  77931,  77930,  77928,  77927,  77925,  77924,  77923,  77921,  77920,  77918,  77917,  77916,  77914,
    77913,  77911,  77910,  77909,  77907,  77906,  77904,  77903,  77901,  77900,  77899,  77897,  77896,  77894,
    77893,  77892,  77890,  77889,  77887,  77886,  77884,  77883,  77882,  77880,  77879,  77877,  77876,  77875,
    77873,  77872,  77870,  77869,  77868,  77866,  77865,  77863,  77862,  77860,  77859,  77858,  77856,  77855,
    77853,  77852,  77851,  77849,  77848,  77846,  77845,  77844,  77842,  77841,  77839,  77838,  77836,  77835,
    77834,  77832,  77831,  77829,  77828,  77827,  77825,  77824,  77822,  77821,  77820,  77818,  77817,  77815,
    77814,  77813,  77811,  77810,  77808,  77807,  77805,  77804,  77803,  77801,  77800,  77798,  77797,  77796,
    77794,  77793,  77791,  77790,  77789,  77787,  77786,  77784,  77783,  77782,  77780,  77779,  77777,  77776,
    77774,  77773,  77772,  77770,  77769,  77767,  77766,  77765,  77763,  77762,  77760,  77759,  77758,  77756,
    77755,  77753,  77752,  77751,  77749,  77748,  77746,  77745,  77744,  77742,  77741,  77739,  77738,  77736,
    77735,  77734,  77732,  77731,  77729,  77728,  77727,  77725,  77724,  77722,  77721,  77720,  77718,  77717,
    77715,  77714,  77713,  77711,  77710,  77708,  77707,  77706,  77704,  77703,  77701,  77700,  77698,  77697,
    77696,  77694,  77693,  77691,  77690,  77689,  77687,  77686,  77684,  77683,  77682,  77680,  77679,  77677,
    77676,  77675,  77673,  77672,  77670,  77669,  77668,  77666,  77665,  77663,  77662,  77661,  77659,  77658,
    77656,  77655,  77654,  77652,  77651,  77649,  77648,  77647,  77645,  77644,  77642,  77641,  77640,  77638,
    77637,  77635,  77634,  77632,  77631,  77630,  77628,  77627,  77625,  77624,  77623,  77621,  77620,  77618,
    77617,  77616,  77614,  77613,  77611,  77610,  77609,  77607,  77606,  77604,  77603,  77602,  77600,  77599,
    77597,  77596,  77595,  77593,  77592,  77590,  77589,  77588,  77586,  77585,  77583,  77582,  77581,  77579,
    77578,  77576,  77575,  77574,  77572,  77571,  77569,  77568,  77567,  77565,  77564,  77562,  77561,  77560,
    77558,  77557,  77555,  77554,  77553,  77551,  77550,  77548,  77547,  77546,  77544,  77543,  77541,  77540,
    77539,  77537,  77536,  77534,  77533,  77532,  77530,  77529,  77527,  77526,  77525,  77523,  77522,  77520,
    77519,  77518,  77516,  77515,  77513,  77512,  77511,  77509,  77508,  77506,  77505,  77504,  77502,  77501,
    77499,  77498,  77497,  77495,  77494,  77492,  77491,  77490,  77488,  77487,  77485,  77484,  77483,  77481,
    77480,  77478,  77477,  77476,  77474,  77473,  77471,  77470,  77469,  77467,  77466,  77464,  77463,  77462,
    77460,  77459,  77457,  77456,  77455,  77453,  77452,  77450,  77449,  77448,  77446,  77445,  77444,  77442,
    77441,  77439,  77438,  77437,  77435,  77434,  77432,  77431,  77430,  77428,  77427,  77425,  77424,  77423,
    77421,  77420,  77418,  77417,  77416,  77414,  77413,  77411,  77410,  77409,  77407,  77406,  77404,  77403,
    77402,  77400,  77399,  77397,  77396,  77395,  77393,  77392,  77390,  77389,  77388,  77386,  77385,  77384,
    77382,  77381,  77379,  77378,  77377,  77375,  77374,  77372,  77371,  77370,  77368,  77367,  77365,  77364,
    77363,  77361,  77360,  77358,  77357,  77356,  77354,  77353,  77351,  77350,  77349,  77347,  77346,  77344,
    77343,  77342,  77340,  77339,  77338,  77336,  77335,  77333,  77332,  77331,  77329,  77328,  77326,  77325,
    77324,  77322,  77321,  77319,  77318,  77317,  77315,  77314,  77312,  77311,  77310,  77308,  77307,  77306,
    77304,  77303,  77301,  77300,  77299,  77297,  77296,  77294,  77293,  77292,  77290,  77289,  77287,  77286,
    77285,  77283,  77282,  77280,  77279,  77278,  77276,  77275,  77274,  77272,  77271,  77269,  77268,  77267,
    77265,  77264,  77262,  77261,  77260,  77258,  77257,  77255,  77254,  77253,  77251,  77250,  77249,  77247,
    77246,  77244,  77243,  77242,  77240,  77239,  77237,  77236,  77235,  77233,  77232,  77230,  77229,  77228,
    77226,  77225,  77224,  77222,  77221,  77219,  77218,  77217,  77215,  77214,  77212,  77211,  77210,  77208,
    77207,  77205,  77204,  77203,  77201,  77200,  77199,  77197,  77196,  77194,  77193,  77192,  77190,  77189,
    77187,  77186,  77185,  77183,  77182,  77180,  77179,  77178,  77176,  77175,  77174,  77172,  77171,  77169,
    77168,  77167,  77165,  77164,  77162,  77161,  77160,  77158,  77157,  77156,  77154,  77153,  77151,  77150,
    77149,  77147,  77146,  77144,  77143,  77142,  77140,  77139,  77138,  77136,  77135,  77133,  77132,  77131,
    77129,  77128,  77126,  77125,  77124,  77122,  77121,  77120,  77118,  77117,  77115,  77114,  77113,  77111,
    77110,  77108,  77107,  77106,  77104,  77103,  77102,  77100,  77099,  77097,  77096,  77095,  77093,  77092,
    77090,  77089,  77088,  77086,  77085,  77084,  77082,  77081,  77079,  77078,  77077,  77075,  77074,  77072,
    77071,  77070,  77068,  77067,  77066,  77064,  77063,  77061,  77060,  77059,  77057,  77056,  77054,  77053,
    77052,  77050,  77049,  77048,  77046,  77045,  77043,  77042,  77041,  77039,  77038,  77037,  77035,  77034,
    77032,  77031,  77030,  77028,  77027,  77025,  77024,  77023,  77021,  77020,  77019,  77017,  77016,  77014,
    77013,  77012,  77010,  77009,  77008,  77006,  77005,  77003,  77002,  77001,  76999,  76998,  76996,  76995,
    76994,  76992,  76991,  76990,  76988,  76987,  76985,  76984,  76983,  76981,  76980,  76979,  76977,  76976,
    76974,  76973,  76972,  76970,  76969,  76967,  76966,  76965,  76963,  76962,  76961,  76959,  76958,  76956,
    76955,  76954,  76952,  76951,  76950,  76948,  76947,  76945,  76944,  76943,  76941,  76940,  76939,  76937,
    76936,  76934,  76933,  76932,  76930,  76929,  76928,  76926,  76925,  76923,  76922,  76921,  76919,  76918,
    76916,  76915,  76914,  76912,  76911,  76910,  76908,  76907,  76905,  76904,  76903,  76901,  76900,  76899,
    76897,  76896,  76894,  76893,  76892,  76890,  76889,  76888,  76886,  76885,  76883,  76882,  76881,  76879,
    76878,  76877,  76875,  76874,  76872,  76871,  76870,  76868,  76867,  76866,  76864,  76863,  76861,  76860,
    76859,  76857,  76856,  76855,  76853,  76852,  76850,  76849,  76848,  76846,  76845,  76844,  76842,  76841,
    76839,  76838,  76837,  76835,  76834,  76833,  76831,  76830,  76828,  76827,  76826,  76824,  76823,  76822,
    76820,  76819,  76817,  76816,  76815,  76813,  76812,  76811,  76809,  76808,  76806,  76805,  76804,  76802,
    76801,  76800,  76798,  76797,  76795,  76794,  76793,  76791,  76790,  76789,  76787,  76786,  76784,  76783,
    76782,  76780,  76779,  76778,  76776,  76775,  76773,  76772,  76771,  76769,  76768,  76767,  76765,  76764,
    76763,  76761,  76760,  76758,  76757,  76756,  76754,  76753,  76752,  76750,  76749,  76747,  76746,  76745,
    76743,  76742,  76741,  76739,  76738,  76736,  76735,  76734,  76732,  76731,  76730,  76728,  76727,  76725,
    76724,  76723,  76721,  76720,  76719,  76717,  76716,  76715,  76713,  76712,  76710,  76709,  76708,  76706,
    76705,  76704,  76702,  76701,  76699,  76698,  76697,  76695,  76694,  76693,  76691,  76690,  76689,  76687,
    76686,  76684,  76683,  76682,  76680,  76679,  76678,  76676,  76675,  76673,  76672,  76671,  76669,  76668,
    76667,  76665,  76664,  76662,  76661,  76660,  76658,  76657,  76656,  76654,  76653,  76652,  76650,  76649,
    76647,  76646,  76645,  76643,  76642,  76641,  76639,  76638,  76637,  76635,  76634,  76632,  76631,  76630,
    76628,  76627,  76626,  76624,  76623,  76621,  76620,  76619,  76617,  76616,  76615,  76613,  76612,  76611,
    76609,  76608,  76606,  76605,  76604,  76602,  76601,  76600,  76598,  76597,  76596,  76594,  76593,  76591,
    76590,  76589,  76587,  76586,  76585,  76583,  76582,  76580,  76579,  76578,  76576,  76575,  76574,  76572,
    76571,  76570,  76568,  76567,  76565,  76564,  76563,  76561,  76560,  76559,  76557,  76556,  76555,  76553,
    76552,  76550,  76549,  76548,  76546,  76545,  76544,  76542,  76541,  76540,  76538,  76537,  76535,  76534,
    76533,  76531,  76530,  76529,  76527,  76526,  76525,  76523,  76522,  76520,  76519,  76518,  76516,  76515,
    76514,  76512,  76511,  76510,  76508,  76507,  76505,  76504,  76503,  76501,  76500,  76499,  76497,  76496,
    76495,  76493,  76492,  76490,  76489,  76488,  76486,  76485,  76484,  76482,  76481,  76480,  76478,  76477,
    76475,  76474,  76473,  76471,  76470,  76469,  76467,  76466,  76465,  76463,  76462,  76461,  76459,  76458,
    76456,  76455,  76454,  76452,  76451,  76450,  76448,  76447,  76446,  76444,  76443,  76441,  76440,  76439,
    76437,  76436,  76435,  76433,  76432,  76431,  76429,  76428,  76426,  76425,  76424,  76422,  76421,  76420,
    76418,  76417,  76416,  76414,  76413,  76412,  76410,  76409,  76407,  76406,  76405,  76403,  76402,  76401,
    76399,  76398,  76397,  76395,  76394,  76393,  76391,  76390,  76388,  76387,  76386,  76384,  76383,  76382,
    76380,  76379,  76378,  76376,  76375,  76373,  76372,  76371,  76369,  76368,  76367,  76365,  76364,  76363,
    76361,  76360,  76359,  76357,  76356,  76354,  76353,  76352,  76350,  76349,  76348,  76346,  76345,  76344,
    76342,  76341,  76340,  76338,  76337,  76335,  76334,  76333,  76331,  76330,  76329,  76327,  76326,  76325,
    76323,  76322,  76321,  76319,  76318,  76316,  76315,  76314,  76312,  76311,  76310,  76308,  76307,  76306,
    76304,  76303,  76302,  76300,  76299,  76298,  76296,  76295,  76293,  76292,  76291,  76289,  76288,  76287,
    76285,  76284,  76283,  76281,  76280,  76279,  76277,  76276,  76274,  76273,  76272,  76270,  76269,  76268,
    76266,  76265,  76264,  76262,  76261,  76260,  76258,  76257,  76256,  76254,  76253,  76251,  76250,  76249,
    76247,  76246,  76245,  76243,  76242,  76241,  76239,  76238,  76237,  76235,  76234,  76233,  76231,  76230,
    76228,  76227,  76226,  76224,  76223,  76222,  76220,  76219,  76218,  76216,  76215,  76214,  76212,  76211,
    76210,  76208,  76207,  76205,  76204,  76203,  76201,  76200,  76199,  76197,  76196,  76195,  76193,  76192,
    76191,  76189,  76188,  76187,  76185,  76184,  76182,  76181,  76180,  76178,  76177,  76176,  76174,  76173,
    76172,  76170,  76169,  76168,  76166,  76165,  76164,  76162,  76161,  76160,  76158,  76157,  76155,  76154,
    76153,  76151,  76150,  76149,  76147,  76146,  76145,  76143,  76142,  76141,  76139,  76138,  76137,  76135,
    76134,  76133,  76131,  76130,  76128,  76127,  76126,  76124,  76123,  76122,  76120,  76119,  76118,  76116,
    76115,  76114,  76112,  76111,  76110,  76108,  76107,  76106,  76104,  76103,  76101,  76100,  76099,  76097,
    76096,  76095,  76093,  76092,  76091,  76089,  76088,  76087,  76085,  76084,  76083,  76081,  76080,  76079,
    76077,  76076,  76075,  76073,  76072,  76070,  76069,  76068,  76066,  76065,  76064,  76062,  76061,  76060,
    76058,  76057,  76056,  76054,  76053,  76052,  76050,  76049,  76048,  76046,  76045,  76044,  76042,  76041,
    76040,  76038,  76037,  76035,  76034,  76033,  76031,  76030,  76029,  76027,  76026,  76025,  76023,  76022,
    76021,  76019,  76018,  76017,  76015,  76014,  76013,  76011,  76010,  76009,  76007,  76006,  76005,  76003,
    76002,  76000,  75999,  75998,  75996,  75995,  75994,  75992,  75991,  75990,  75988,  75987,  75986,  75984,
    75983,  75982,  75980,  75979,  75978,  75976,  75975,  75974,  75972,  75971,  75970,  75968,  75967,  75966,
    75964,  75963,  75962,  75960,  75959,  75957,  75956,  75955,  75953,  75952,  75951,  75949,  75948,  75947,
    75945,  75944,  75943,  75941,  75940,  75939,  75937,  75936,  75935,  75933,  75932,  75931,  75929,  75928,
    75927,  75925,  75924,  75923,  75921,  75920,  75919,  75917,  75916,  75915,  75913,  75912,  75910,  75909,
    75908,  75906,  75905,  75904,  75902,  75901,  75900,  75898,  75897,  75896,  75894,  75893,  75892,  75890,
    75889,  75888,  75886,  75885,  75884,  75882,  75881,  75880,  75878,  75877,  75876,  75874,  75873,  75872,
    75870,  75869,  75868,  75866,  75865,  75864,  75862,  75861,  75860,  75858,  75857,  75856,  75854,  75853,
    75851,  75850,  75849,  75847,  75846,  75845,  75843,  75842,  75841,  75839,  75838,  75837,  75835,  75834,
    75833,  75831,  75830,  75829,  75827,  75826,  75825,  75823,  75822,  75821,  75819,  75818,  75817,  75815,
    75814,  75813,  75811,  75810,  75809,  75807,  75806,  75805,  75803,  75802,  75801,  75799,  75798,  75797,
    75795,  75794,  75793,  75791,  75790,  75789,  75787,  75786,  75785,  75783,  75782,  75781,  75779,  75778,
    75777,  75775,  75774,  75773,  75771,  75770,  75769,  75767,  75766,  75765,  75763,  75762,  75761,  75759,
    75758,  75757,  75755,  75754,  75752,  75751,  75750,  75748,  75747,  75746,  75744,  75743,  75742,  75740,
    75739,  75738,  75736,  75735,  75734,  75732,  75731,  75730,  75728,  75727,  75726,  75724,  75723,  75722,
    75720,  75719,  75718,  75716,  75715,  75714,  75712,  75711,  75710,  75708,  75707,  75706,  75704,  75703,
    75702,  75700,  75699,  75698,  75696,  75695,  75694,  75692,  75691,  75690,  75688,  75687,  75686,  75684,
    75683,  75682,  75680,  75679,  75678,  75676,  75675,  75674,  75672,  75671,  75670,  75668,  75667,  75666,
    75664,  75663,  75662,  75660,  75659,  75658,  75656,  75655,  75654,  75652,  75651,  75650,  75648,  75647,
    75646,  75644,  75643,  75642,  75640,  75639,  75638,  75636,  75635,  75634,  75632,  75631,  75630,  75628,
    75627,  75626,  75624,  75623,  75622,  75620,  75619,  75618,  75616,  75615,  75614,  75612,  75611,  75610,
    75608,  75607,  75606,  75604,  75603,  75602,  75600,  75599,  75598,  75596,  75595,  75594,  75593,  75591,
    75590,  75589,  75587,  75586,  75585,  75583,  75582,  75581,  75579,  75578,  75577,  75575,  75574,  75573,
    75571,  75570,  75569,  75567,  75566,  75565,  75563,  75562,  75561,  75559,  75558,  75557,  75555,  75554,
    75553,  75551,  75550,  75549,  75547,  75546,  75545,  75543,  75542,  75541,  75539,  75538,  75537,  75535,
    75534,  75533,  75531,  75530,  75529,  75527,  75526,  75525,  75523,  75522,  75521,  75519,  75518,  75517,
    75515,  75514,  75513,  75511,  75510,  75509,  75507,  75506,  75505,  75503,  75502,  75501,  75499,  75498,
    75497,  75496,  75494,  75493,  75492,  75490,  75489,  75488,  75486,  75485,  75484,  75482,  75481,  75480,
    75478,  75477,  75476,  75474,  75473,  75472,  75470,  75469,  75468,  75466,  75465,  75464,  75462,  75461,
    75460,  75458,  75457,  75456,  75454,  75453,  75452,  75450,  75449,  75448,  75446,  75445,  75444,  75442,
    75441,  75440,  75438,  75437,  75436,  75435,  75433,  75432,  75431,  75429,  75428,  75427,  75425,  75424,
    75423,  75421,  75420,  75419,  75417,  75416,  75415,  75413,  75412,  75411,  75409,  75408,  75407,  75405,
    75404,  75403,  75401,  75400,  75399,  75397,  75396,  75395,  75393,  75392,  75391,  75389,  75388,  75387,
    75386,  75384,  75383,  75382,  75380,  75379,  75378,  75376,  75375,  75374,  75372,  75371,  75370,  75368,
    75367,  75366,  75364,  75363,  75362,  75360,  75359,  75358,  75356,  75355,  75354,  75352,  75351,  75350,
    75348,  75347,  75346,  75345,  75343,  75342,  75341,  75339,  75338,  75337,  75335,  75334,  75333,  75331,
    75330,  75329,  75327,  75326,  75325,  75323,  75322,  75321,  75319,  75318,  75317,  75315,  75314,  75313,
    75311,  75310,  75309,  75308,  75306,  75305,  75304,  75302,  75301,  75300,  75298,  75297,  75296,  75294,
    75293,  75292,  75290,  75289,  75288,  75286,  75285,  75284,  75282,  75281,  75280,  75278,  75277,  75276,
    75275,  75273,  75272,  75271,  75269,  75268,  75267,  75265,  75264,  75263,  75261,  75260,  75259,  75257,
    75256,  75255,  75253,  75252,  75251,  75249,  75248,  75247,  75246,  75244,  75243,  75242,  75240,  75239,
    75238,  75236,  75235,  75234,  75232,  75231,  75230,  75228,  75227,  75226,  75224,  75223,  75222,  75220,
    75219,  75218,  75217,  75215,  75214,  75213,  75211,  75210,  75209,  75207,  75206,  75205,  75203,  75202,
    75201,  75199,  75198,  75197,  75195,  75194,  75193,  75192,  75190,  75189,  75188,  75186,  75185,  75184,
    75182,  75181,  75180,  75178,  75177,  75176,  75174,  75173,  75172,  75170,  75169,  75168,  75167,  75165,
    75164,  75163,  75161,  75160,  75159,  75157,  75156,  75155,  75153,  75152,  75151,  75149,  75148,  75147,
    75145,  75144,  75143,  75142,  75140,  75139,  75138,  75136,  75135,  75134,  75132,  75131,  75130,  75128,
    75127,  75126,  75124,  75123,  75122,  75120,  75119,  75118,  75117,  75115,  75114,  75113,  75111,  75110,
    75109,  75107,  75106,  75105,  75103,  75102,  75101,  75099,  75098,  75097,  75096,  75094,  75093,  75092,
    75090,  75089,  75088,  75086,  75085,  75084,  75082,  75081,  75080,  75078,  75077,  75076,  75075,  75073,
    75072,  75071,  75069,  75068,  75067,  75065,  75064,  75063,  75061,  75060,  75059,  75057,  75056,  75055,
    75054,  75052,  75051,  75050,  75048,  75047,  75046,  75044,  75043,  75042,  75040,  75039,  75038,  75036,
    75035,  75034,  75033,  75031,  75030,  75029,  75027,  75026,  75025,  75023,  75022,  75021,  75019,  75018,
    75017,  75016,  75014,  75013,  75012,  75010,  75009,  75008,  75006,  75005,  75004,  75002,  75001,  75000,
    74998,  74997,  74996,  74995,  74993,  74992,  74991,  74989,  74988,  74987,  74985,  74984,  74983,  74981,
    74980,  74979,  74978,  74976,  74975,  74974,  74972,  74971,  74970,  74968,  74967,  74966,  74964,  74963,
    74962,  74961,  74959,  74958,  74957,  74955,  74954,  74953,  74951,  74950,  74949,  74947,  74946,  74945,
    74944,  74942,  74941,  74940,  74938,  74937,  74936,  74934,  74933,  74932,  74930,  74929,  74928,  74927,
    74925,  74924,  74923,  74921,  74920,  74919,  74917,  74916,  74915,  74913,  74912,  74911,  74910,  74908,
    74907,  74906,  74904,  74903,  74902,  74900,  74899,  74898,  74896,  74895,  74894,  74893,  74891,  74890,
    74889,  74887,  74886,  74885,  74883,  74882,  74881,  74880,  74878,  74877,  74876,  74874,  74873,  74872,
    74870,  74869,  74868,  74866,  74865,  74864,  74863,  74861,  74860,  74859,  74857,  74856,  74855,  74853,
    74852,  74851,  74849,  74848,  74847,  74846,  74844,  74843,  74842,  74840,  74839,  74838,  74836,  74835,
    74834,  74833,  74831,  74830,  74829,  74827,  74826,  74825,  74823,  74822,  74821,  74820,  74818,  74817,
    74816,  74814,  74813,  74812,  74810,  74809,  74808,  74806,  74805,  74804,  74803,  74801,  74800,  74799,
    74797,  74796,  74795,  74793,  74792,  74791,  74790,  74788,  74787,  74786,  74784,  74783,  74782,  74780,
    74779,  74778,  74777,  74775,  74774,  74773,  74771,  74770,  74769,  74767,  74766,  74765,  74764,  74762,
    74761,  74760,  74758,  74757,  74756,  74754,  74753,  74752,  74750,  74749,  74748,  74747,  74745,  74744,
    74743,  74741,  74740,  74739,  74737,  74736,  74735,  74734,  74732,  74731,  74730,  74728,  74727,  74726,
    74724,  74723,  74722,  74721,  74719,  74718,  74717,  74715,  74714,  74713,  74711,  74710,  74709,  74708,
    74706,  74705,  74704,  74702,  74701,  74700,  74698,  74697,  74696,  74695,  74693,  74692,  74691,  74689,
    74688,  74687,  74685,  74684,  74683,  74682,  74680,  74679,  74678,  74676,  74675,  74674,  74673,  74671,
    74670,  74669,  74667,  74666,  74665,  74663,  74662,  74661,  74660,  74658,  74657,  74656,  74654,  74653,
    74652,  74650,  74649,  74648,  74647,  74645,  74644,  74643,  74641,  74640,  74639,  74637,  74636,  74635,
    74634,  74632,  74631,  74630,  74628,  74627,  74626,  74625,  74623,  74622,  74621,  74619,  74618,  74617,
    74615,  74614,  74613,  74612,  74610,  74609,  74608,  74606,  74605,  74604,  74602,  74601,  74600,  74599,
    74597,  74596,  74595,  74593,  74592,  74591,  74590,  74588,  74587,  74586,  74584,  74583,  74582,  74580,
    74579,  74578,  74577,  74575,  74574,  74573,  74571,  74570,  74569,  74567,  74566,  74565,  74564,  74562,
    74561,  74560,  74558,  74557,  74556,  74555,  74553,  74552,  74551,  74549,  74548,  74547,  74545,  74544,
    74543,  74542,  74540,  74539,  74538,  74536,  74535,  74534,  74533,  74531,  74530,  74529,  74527,  74526,
    74525,  74524,  74522,  74521,  74520,  74518,  74517,  74516,  74514,  74513,  74512,  74511,  74509,  74508,
    74507,  74505,  74504,  74503,  74502,  74500,  74499,  74498,  74496,  74495,  74494,  74492,  74491,  74490,
    74489,  74487,  74486,  74485,  74483,  74482,  74481,  74480,  74478,  74477,  74476,  74474,  74473,  74472,
    74471,  74469,  74468,  74467,  74465,  74464,  74463,  74461,  74460,  74459,  74458,  74456,  74455,  74454,
    74452,  74451,  74450,  74449,  74447,  74446,  74445,  74443,  74442,  74441,  74440,  74438,  74437,  74436,
    74434,  74433,  74432,  74431,  74429,  74428,  74427,  74425,  74424,  74423,  74421,  74420,  74419,  74418,
    74416,  74415,  74414,  74412,  74411,  74410,  74409,  74407,  74406,  74405,  74403,  74402,  74401,  74400,
    74398,  74397,  74396,  74394,  74393,  74392,  74391,  74389,  74388,  74387,  74385,  74384,  74383,  74382,
    74380,  74379,  74378,  74376,  74375,  74374,  74373,  74371,  74370,  74369,  74367,  74366,  74365,  74364,
    74362,  74361,  74360,  74358,  74357,  74356,  74354,  74353,  74352,  74351,  74349,  74348,  74347,  74345,
    74344,  74343,  74342,  74340,  74339,  74338,  74336,  74335,  74334,  74333,  74331,  74330,  74329,  74327,
    74326,  74325,  74324,  74322,  74321,  74320,  74318,  74317,  74316,  74315,  74313,  74312,  74311,  74309,
    74308,  74307,  74306,  74304,  74303,  74302,  74300,  74299,  74298,  74297,  74295,  74294,  74293,  74291,
    74290,  74289,  74288,  74286,  74285,  74284,  74282,  74281,  74280,  74279,  74277,  74276,  74275,  74273,
    74272,  74271,  74270,  74268,  74267,  74266,  74264,  74263,  74262,  74261,  74259,  74258,  74257,  74256,
    74254,  74253,  74252,  74250,  74249,  74248,  74247,  74245,  74244,  74243,  74241,  74240,  74239,  74238,
    74236,  74235,  74234,  74232,  74231,  74230,  74229,  74227,  74226,  74225,  74223,  74222,  74221,  74220,
    74218,  74217,  74216,  74214,  74213,  74212,  74211,  74209,  74208,  74207,  74205,  74204,  74203,  74202,
    74200,  74199,  74198,  74196,  74195,  74194,  74193,  74191,  74190,  74189,  74188,  74186,  74185,  74184,
    74182,  74181,  74180,  74179,  74177,  74176,  74175,  74173,  74172,  74171,  74170,  74168,  74167,  74166,
    74164,  74163,  74162,  74161,  74159,  74158,  74157,  74156,  74154,  74153,  74152,  74150,  74149,  74148,
    74147,  74145,  74144,  74143,  74141,  74140,  74139,  74138,  74136,  74135,  74134,  74132,  74131,  74130,
    74129,  74127,  74126,  74125,  74124,  74122,  74121,  74120,  74118,  74117,  74116,  74115,  74113,  74112,
    74111,  74109,  74108,  74107,  74106,  74104,  74103,  74102,  74100,  74099,  74098,  74097,  74095,  74094,
    74093,  74092,  74090,  74089,  74088,  74086,  74085,  74084,  74083,  74081,  74080,  74079,  74077,  74076,
    74075,  74074,  74072,  74071,  74070,  74069,  74067,  74066,  74065,  74063,  74062,  74061,  74060,  74058,
    74057,  74056,  74054,  74053,  74052,  74051,  74049,  74048,  74047,  74046,  74044,  74043,  74042,  74040,
    74039,  74038,  74037,  74035,  74034,  74033,  74032,  74030,  74029,  74028,  74026,  74025,  74024,  74023,
    74021,  74020,  74019,  74017,  74016,  74015,  74014,  74012,  74011,  74010,  74009,  74007,  74006,  74005,
    74003,  74002,  74001,  74000,  73998,  73997,  73996,  73995,  73993,  73992,  73991,  73989,  73988,  73987,
    73986,  73984,  73983,  73982,  73981,  73979,  73978,  73977,  73975,  73974,  73973,  73972,  73970,  73969,
    73968,  73966,  73965,  73964,  73963,  73961,  73960,  73959,  73958,  73956,  73955,  73954,  73952,  73951,
    73950,  73949,  73947,  73946,  73945,  73944,  73942,  73941,  73940,  73938,  73937,  73936,  73935,  73933,
    73932,  73931,  73930,  73928,  73927,  73926,  73924,  73923,  73922,  73921,  73919,  73918,  73917,  73916,
    73914,  73913,  73912,  73910,  73909,  73908,  73907,  73905,  73904,  73903,  73902,  73900,  73899,  73898,
    73896,  73895,  73894,  73893,  73891,  73890,  73889,  73888,  73886,  73885,  73884,  73883,  73881,  73880,
    73879,  73877,  73876,  73875,  73874,  73872,  73871,  73870,  73869,  73867,  73866,  73865,  73863,  73862,
    73861,  73860,  73858,  73857,  73856,  73855,  73853,  73852,  73851,  73849,  73848,  73847,  73846,  73844,
    73843,  73842,  73841,  73839,  73838,  73837,  73836,  73834,  73833,  73832,  73830,  73829,  73828,  73827,
    73825,  73824,  73823,  73822,  73820,  73819,  73818,  73816,  73815,  73814,  73813,  73811,  73810,  73809,
    73808,  73806,  73805,  73804,  73803,  73801,  73800,  73799,  73797,  73796,  73795,  73794,  73792,  73791,
    73790,  73789,  73787,  73786,  73785,  73784,  73782,  73781,  73780,  73778,  73777,  73776,  73775,  73773,
    73772,  73771,  73770,  73768,  73767,  73766,  73765,  73763,  73762,  73761,  73759,  73758,  73757,  73756,
    73754,  73753,  73752,  73751,  73749,  73748,  73747,  73746,  73744,  73743,  73742,  73740,  73739,  73738,
    73737,  73735,  73734,  73733,  73732,  73730,  73729,  73728,  73727,  73725,  73724,  73723,  73721,  73720,
    73719,  73718,  73716,  73715,  73714,  73713,  73711,  73710,  73709,  73708,  73706,  73705,  73704,  73702,
    73701,  73700,  73699,  73697,  73696,  73695,  73694,  73692,  73691,  73690,  73689,  73687,  73686,  73685,
    73684,  73682,  73681,  73680,  73678,  73677,  73676,  73675,  73673,  73672,  73671,  73670,  73668,  73667,
    73666,  73665,  73663,  73662,  73661,  73660,  73658,  73657,  73656,  73654,  73653,  73652,  73651,  73649,
    73648,  73647,  73646,  73644,  73643,  73642,  73641,  73639,  73638,  73637,  73636,  73634,  73633,  73632,
    73630,  73629,  73628,  73627,  73625,  73624,  73623,  73622,  73620,  73619,  73618,  73617,  73615,  73614,
    73613,  73612,  73610,  73609,  73608,  73606,  73605,  73604,  73603,  73601,  73600,  73599,  73598,  73596,
    73595,  73594,  73593,  73591,  73590,  73589,  73588,  73586,  73585,  73584,  73583,  73581,  73580,  73579,
    73577,  73576,  73575,  73574,  73572,  73571,  73570,  73569,  73567,  73566,  73565,  73564,  73562,  73561,
    73560,  73559,  73557,  73556,  73555,  73554,  73552,  73551,  73550,  73549,  73547,  73546,  73545,  73543,
    73542,  73541,  73540,  73538,  73537,  73536,  73535,  73533,  73532,  73531,  73530,  73528,  73527,  73526,
    73525,  73523,  73522,  73521,  73520,  73518,  73517,  73516,  73515,  73513,  73512,  73511,  73509,  73508,
    73507,  73506,  73504,  73503,  73502,  73501,  73499,  73498,  73497,  73496,  73494,  73493,  73492,  73491,
    73489,  73488,  73487,  73486,  73484,  73483,  73482,  73481,  73479,  73478,  73477,  73476,  73474,  73473,
    73472,  73470,  73469,  73468,  73467,  73465,  73464,  73463,  73462,  73460,  73459,  73458,  73457,  73455,
    73454,  73453,  73452,  73450,  73449,  73448,  73447,  73445,  73444,  73443,  73442,  73440,  73439,  73438,
    73437,  73435,  73434,  73433,  73432,  73430,  73429,  73428,  73427,  73425,  73424,  73423,  73422,  73420,
    73419,  73418,  73416,  73415,  73414,  73413,  73411,  73410,  73409,  73408,  73406,  73405,  73404,  73403,
    73401,  73400,  73399,  73398,  73396,  73395,  73394,  73393,  73391,  73390,  73389,  73388,  73386,  73385,
    73384,  73383,  73381,  73380,  73379,  73378,  73376,  73375,  73374,  73373,  73371,  73370,  73369,  73368,
    73366,  73365,  73364,  73363,  73361,  73360,  73359,  73358,  73356,  73355,  73354,  73353,  73351,  73350,
    73349,  73348,  73346,  73345,  73344,  73343,  73341,  73340,  73339,  73338,  73336,  73335,  73334,  73333,
    73331,  73330,  73329,  73327,  73326,  73325,  73324,  73322,  73321,  73320,  73319,  73317,  73316,  73315,
    73314,  73312,  73311,  73310,  73309,  73307,  73306,  73305,  73304,  73302,  73301,  73300,  73299,  73297,
    73296,  73295,  73294,  73292,  73291,  73290,  73289,  73287,  73286,  73285,  73284,  73282,  73281,  73280,
    73279,  73277,  73276,  73275,  73274,  73272,  73271,  73270,  73269,  73267,  73266,  73265,  73264,  73262,
    73261,  73260,  73259,  73257,  73256,  73255,  73254,  73252,  73251,  73250,  73249,  73247,  73246,  73245,
    73244,  73242,  73241,  73240,  73239,  73237,  73236,  73235,  73234,  73232,  73231,  73230,  73229,  73227,
    73226,  73225,  73224,  73222,  73221,  73220,  73219,  73217,  73216,  73215,  73214,  73213,  73211,  73210,
    73209,  73208,  73206,  73205,  73204,  73203,  73201,  73200,  73199,  73198,  73196,  73195,  73194,  73193,
    73191,  73190,  73189,  73188,  73186,  73185,  73184,  73183,  73181,  73180,  73179,  73178,  73176,  73175,
    73174,  73173,  73171,  73170,  73169,  73168,  73166,  73165,  73164,  73163,  73161,  73160,  73159,  73158,
    73156,  73155,  73154,  73153,  73151,  73150,  73149,  73148,  73146,  73145,  73144,  73143,  73141,  73140,
    73139,  73138,  73136,  73135,  73134,  73133,  73131,  73130,  73129,  73128,  73126,  73125,  73124,  73123,
    73122,  73120,  73119,  73118,  73117,  73115,  73114,  73113,  73112,  73110,  73109,  73108,  73107,  73105,
    73104,  73103,  73102,  73100,  73099,  73098,  73097,  73095,  73094,  73093,  73092,  73090,  73089,  73088,
    73087,  73085,  73084,  73083,  73082,  73080,  73079,  73078,  73077,  73075,  73074,  73073,  73072,  73071,
    73069,  73068,  73067,  73066,  73064,  73063,  73062,  73061,  73059,  73058,  73057,  73056,  73054,  73053,
    73052,  73051,  73049,  73048,  73047,  73046,  73044,  73043,  73042,  73041,  73039,  73038,  73037,  73036,
    73034,  73033,  73032,  73031,  73030,  73028,  73027,  73026,  73025,  73023,  73022,  73021,  73020,  73018,
    73017,  73016,  73015,  73013,  73012,  73011,  73010,  73008,  73007,  73006,  73005,  73003,  73002,  73001,
    73000,  72998,  72997,  72996,  72995,  72994,  72992,  72991,  72990,  72989,  72987,  72986,  72985,  72984,
    72982,  72981,  72980,  72979,  72977,  72976,  72975,  72974,  72972,  72971,  72970,  72969,  72967,  72966,
    72965,  72964,  72963,  72961,  72960,  72959,  72958,  72956,  72955,  72954,  72953,  72951,  72950,  72949,
    72948,  72946,  72945,  72944,  72943,  72941,  72940,  72939,  72938,  72936,  72935,  72934,  72933,  72932,
    72930,  72929,  72928,  72927,  72925,  72924,  72923,  72922,  72920,  72919,  72918,  72917,  72915,  72914,
    72913,  72912,  72910,  72909,  72908,  72907,  72906,  72904,  72903,  72902,  72901,  72899,  72898,  72897,
    72896,  72894,  72893,  72892,  72891,  72889,  72888,  72887,  72886,  72885,  72883,  72882,  72881,  72880,
    72878,  72877,  72876,  72875,  72873,  72872,  72871,  72870,  72868,  72867,  72866,  72865,  72863,  72862,
    72861,  72860,  72859,  72857,  72856,  72855,  72854,  72852,  72851,  72850,  72849,  72847,  72846,  72845,
    72844,  72842,  72841,  72840,  72839,  72838,  72836,  72835,  72834,  72833,  72831,  72830,  72829,  72828,
    72826,  72825,  72824,  72823,  72821,  72820,  72819,  72818,  72817,  72815,  72814,  72813,  72812,  72810,
    72809,  72808,  72807,  72805,  72804,  72803,  72802,  72800,  72799,  72798,  72797,  72796,  72794,  72793,
    72792,  72791,  72789,  72788,  72787,  72786,  72784,  72783,  72782,  72781,  72780,  72778,  72777,  72776,
    72775,  72773,  72772,  72771,  72770,  72768,  72767,  72766,  72765,  72763,  72762,  72761,  72760,  72759,
    72757,  72756,  72755,  72754,  72752,  72751,  72750,  72749,  72747,  72746,  72745,  72744,  72743,  72741,
    72740,  72739,  72738,  72736,  72735,  72734,  72733,  72731,  72730,  72729,  72728,  72727,  72725,  72724,
    72723,  72722,  72720,  72719,  72718,  72717,  72715,  72714,  72713,  72712,  72711,  72709,  72708,  72707,
    72706,  72704,  72703,  72702,  72701,  72699,  72698,  72697,  72696,  72695,  72693,  72692,  72691,  72690,
    72688,  72687,  72686,  72685,  72683,  72682,  72681,  72680,  72679,  72677,  72676,  72675,  72674,  72672,
    72671,  72670,  72669,  72667,  72666,  72665,  72664,  72663,  72661,  72660,  72659,  72658,  72656,  72655,
    72654,  72653,  72651,  72650,  72649,  72648,  72647,  72645,  72644,  72643,  72642,  72640,  72639,  72638,
    72637,  72636,  72634,  72633,  72632,  72631,  72629,  72628,  72627,  72626,  72624,  72623,  72622,  72621,
    72620,  72618,  72617,  72616,  72615,  72613,  72612,  72611,  72610,  72608,  72607,  72606,  72605,  72604,
    72602,  72601,  72600,  72599,  72597,  72596,  72595,  72594,  72593,  72591,  72590,  72589,  72588,  72586,
    72585,  72584,  72583,  72582,  72580,  72579,  72578,  72577,  72575,  72574,  72573,  72572,  72570,  72569,
    72568,  72567,  72566,  72564,  72563,  72562,  72561,  72559,  72558,  72557,  72556,  72555,  72553,  72552,
    72551,  72550,  72548,  72547,  72546,  72545,  72544,  72542,  72541,  72540,  72539,  72537,  72536,  72535,
    72534,  72532,  72531,  72530,  72529,  72528,  72526,  72525,  72524,  72523,  72521,  72520,  72519,  72518,
    72517,  72515,  72514,  72513,  72512,  72510,  72509,  72508,  72507,  72506,  72504,  72503,  72502,  72501,
    72499,  72498,  72497,  72496,  72495,  72493,  72492,  72491,  72490,  72488,  72487,  72486,  72485,  72484,
    72482,  72481,  72480,  72479,  72477,  72476,  72475,  72474,  72473,  72471,  72470,  72469,  72468,  72466,
    72465,  72464,  72463,  72461,  72460,  72459,  72458,  72457,  72455,  72454,  72453,  72452,  72450,  72449,
    72448,  72447,  72446,  72444,  72443,  72442,  72441,  72439,  72438,  72437,  72436,  72435,  72433,  72432,
    72431,  72430,  72429,  72427,  72426,  72425,  72424,  72422,  72421,  72420,  72419,  72418,  72416,  72415,
    72414,  72413,  72411,  72410,  72409,  72408,  72407,  72405,  72404,  72403,  72402,  72400,  72399,  72398,
    72397,  72396,  72394,  72393,  72392,  72391,  72389,  72388,  72387,  72386,  72385,  72383,  72382,  72381,
    72380,  72378,  72377,  72376,  72375,  72374,  72372,  72371,  72370,  72369,  72367,  72366,  72365,  72364,
    72363,  72361,  72360,  72359,  72358,  72357,  72355,  72354,  72353,  72352,  72350,  72349,  72348,  72347,
    72346,  72344,  72343,  72342,  72341,  72339,  72338,  72337,  72336,  72335,  72333,  72332,  72331,  72330,
    72328,  72327,  72326,  72325,  72324,  72322,  72321,  72320,  72319,  72318,  72316,  72315,  72314,  72313,
    72311,  72310,  72309,  72308,  72307,  72305,  72304,  72303,  72302,  72300,  72299,  72298,  72297,  72296,
    72294,  72293,  72292,  72291,  72290,  72288,  72287,  72286,  72285,  72283,  72282,  72281,  72280,  72279,
    72277,  72276,  72275,  72274,  72272,  72271,  72270,  72269,  72268,  72266,  72265,  72264,  72263,  72262,
    72260,  72259,  72258,  72257,  72255,  72254,  72253,  72252,  72251,  72249,  72248,  72247,  72246,  72245,
    72243,  72242,  72241,  72240,  72238,  72237,  72236,  72235,  72234,  72232,  72231,  72230,  72229,  72228,
    72226,  72225,  72224,  72223,  72221,  72220,  72219,  72218,  72217,  72215,  72214,  72213,  72212,  72211,
    72209,  72208,  72207,  72206,  72204,  72203,  72202,  72201,  72200,  72198,  72197,  72196,  72195,  72194,
    72192,  72191,  72190,  72189,  72187,  72186,  72185,  72184,  72183,  72181,  72180,  72179,  72178,  72177,
    72175,  72174,  72173,  72172,  72170,  72169,  72168,  72167,  72166,  72164,  72163,  72162,  72161,  72160,
    72158,  72157,  72156,  72155,  72154,  72152,  72151,  72150,  72149,  72147,  72146,  72145,  72144,  72143,
    72141,  72140,  72139,  72138,  72137,  72135,  72134,  72133,  72132,  72130,  72129,  72128,  72127,  72126,
    72124,  72123,  72122,  72121,  72120,  72118,  72117,  72116,  72115,  72114,  72112,  72111,  72110,  72109,
    72107,  72106,  72105,  72104,  72103,  72101,  72100,  72099,  72098,  72097,  72095,  72094,  72093,  72092,
    72091,  72089,  72088,  72087,  72086,  72084,  72083,  72082,  72081,  72080,  72078,  72077,  72076,  72075,
    72074,  72072,  72071,  72070,  72069,  72068,  72066,  72065,  72064,  72063,  72062,  72060,  72059,  72058,
    72057,  72055,  72054,  72053,  72052,  72051,  72049,  72048,  72047,  72046,  72045,  72043,  72042,  72041,
    72040,  72039,  72037,  72036,  72035,  72034,  72032,  72031,  72030,  72029,  72028,  72026,  72025,  72024,
    72023,  72022,  72020,  72019,  72018,  72017,  72016,  72014,  72013,  72012,  72011,  72010,  72008,  72007,
    72006,  72005,  72004,  72002,  72001,  72000,  71999,  71997,  71996,  71995,  71994,  71993,  71991,  71990,
    71989,  71988,  71987,  71985,  71984,  71983,  71982,  71981,  71979,  71978,  71977,  71976,  71975,  71973,
    71972,  71971,  71970,  71969,  71967,  71966,  71965,  71964,  71962,  71961,  71960,  71959,  71958,  71956,
    71955,  71954,  71953,  71952,  71950,  71949,  71948,  71947,  71946,  71944,  71943,  71942,  71941,  71940,
    71938,  71937,  71936,  71935,  71934,  71932,  71931,  71930,  71929,  71928,  71926,  71925,  71924,  71923,
    71922,  71920,  71919,  71918,  71917,  71916,  71914,  71913,  71912,  71911,  71909,  71908,  71907,  71906,
    71905,  71903,  71902,  71901,  71900,  71899,  71897,  71896,  71895,  71894,  71893,  71891,  71890,  71889,
    71888,  71887,  71885,  71884,  71883,  71882,  71881,  71879,  71878,  71877,  71876,  71875,  71873,  71872,
    71871,  71870,  71869,  71867,  71866,  71865,  71864,  71863,  71861,  71860,  71859,  71858,  71857,  71855,
    71854,  71853,  71852,  71851,  71849,  71848,  71847,  71846,  71845,  71843,  71842,  71841,  71840,  71839,
    71837,  71836,  71835,  71834,  71833,  71831,  71830,  71829,  71828,  71827,  71825,  71824,  71823,  71822,
    71820,  71819,  71818,  71817,  71816,  71814,  71813,  71812,  71811,  71810,  71808,  71807,  71806,  71805,
    71804,  71802,  71801,  71800,  71799,  71798,  71796,  71795,  71794,  71793,  71792,  71790,  71789,  71788,
    71787,  71786,  71784,  71783,  71782,  71781,  71780,  71778,  71777,  71776,  71775,  71774,  71772,  71771,
    71770,  71769,  71768,  71766,  71765,  71764,  71763,  71762,  71760,  71759,  71758,  71757,  71756,  71755,
    71753,  71752,  71751,  71750,  71749,  71747,  71746,  71745,  71744,  71743,  71741,  71740,  71739,  71738,
    71737,  71735,  71734,  71733,  71732,  71731,  71729,  71728,  71727,  71726,  71725,  71723,  71722,  71721,
    71720,  71719,  71717,  71716,  71715,  71714,  71713,  71711,  71710,  71709,  71708,  71707,  71705,  71704,
    71703,  71702,  71701,  71699,  71698,  71697,  71696,  71695,  71693,  71692,  71691,  71690,  71689,  71687,
    71686,  71685,  71684,  71683,  71681,  71680,  71679,  71678,  71677,  71675,  71674,  71673,  71672,  71671,
    71669,  71668,  71667,  71666,  71665,  71664,  71662,  71661,  71660,  71659,  71658,  71656,  71655,  71654,
    71653,  71652,  71650,  71649,  71648,  71647,  71646,  71644,  71643,  71642,  71641,  71640,  71638,  71637,
    71636,  71635,  71634,  71632,  71631,  71630,  71629,  71628,  71626,  71625,  71624,  71623,  71622,  71620,
    71619,  71618,  71617,  71616,  71615,  71613,  71612,  71611,  71610,  71609,  71607,  71606,  71605,  71604,
    71603,  71601,  71600,  71599,  71598,  71597,  71595,  71594,  71593,  71592,  71591,  71589,  71588,  71587,
    71586,  71585,  71583,  71582,  71581,  71580,  71579,  71578,  71576,  71575,  71574,  71573,  71572,  71570,
    71569,  71568,  71567,  71566,  71564,  71563,  71562,  71561,  71560,  71558,  71557,  71556,  71555,  71554,
    71552,  71551,  71550,  71549,  71548,  71547,  71545,  71544,  71543,  71542,  71541,  71539,  71538,  71537,
    71536,  71535,  71533,  71532,  71531,  71530,  71529,  71527,  71526,  71525,  71524,  71523,  71521,  71520,
    71519,  71518,  71517,  71516,  71514,  71513,  71512,  71511,  71510,  71508,  71507,  71506,  71505,  71504,
    71502,  71501,  71500,  71499,  71498,  71496,  71495,  71494,  71493,  71492,  71491,  71489,  71488,  71487,
    71486,  71485,  71483,  71482,  71481,  71480,  71479,  71477,  71476,  71475,  71474,  71473,  71472,  71470,
    71469,  71468,  71467,  71466,  71464,  71463,  71462,  71461,  71460,  71458,  71457,  71456,  71455,  71454,
    71452,  71451,  71450,  71449,  71448,  71447,  71445,  71444,  71443,  71442,  71441,  71439,  71438,  71437,
    71436,  71435,  71433,  71432,  71431,  71430,  71429,  71428,  71426,  71425,  71424,  71423,  71422,  71420,
    71419,  71418,  71417,  71416,  71414,  71413,  71412,  71411,  71410,  71409,  71407,  71406,  71405,  71404,
    71403,  71401,  71400,  71399,  71398,  71397,  71395,  71394,  71393,  71392,  71391,  71390,  71388,  71387,
    71386,  71385,  71384,  71382,  71381,  71380,  71379,  71378,  71376,  71375,  71374,  71373,  71372,  71371,
    71369,  71368,  71367,  71366,  71365,  71363,  71362,  71361,  71360,  71359,  71358,  71356,  71355,  71354,
    71353,  71352,  71350,  71349,  71348,  71347,  71346,  71344,  71343,  71342,  71341,  71340,  71339,  71337,
    71336,  71335,  71334,  71333,  71331,  71330,  71329,  71328,  71327,  71326,  71324,  71323,  71322,  71321,
    71320,  71318,  71317,  71316,  71315,  71314,  71312,  71311,  71310,  71309,  71308,  71307,  71305,  71304,
    71303,  71302,  71301,  71299,  71298,  71297,  71296,  71295,  71294,  71292,  71291,  71290,  71289,  71288,
    71286,  71285,  71284,  71283,  71282,  71281,  71279,  71278,  71277,  71276,  71275,  71273,  71272,  71271,
    71270,  71269,  71268,  71266,  71265,  71264,  71263,  71262,  71260,  71259,  71258,  71257,  71256,  71255,
    71253,  71252,  71251,  71250,  71249,  71247,  71246,  71245,  71244,  71243,  71242,  71240,  71239,  71238,
    71237,  71236,  71234,  71233,  71232,  71231,  71230,  71229,  71227,  71226,  71225,  71224,  71223,  71221,
    71220,  71219,  71218,  71217,  71216,  71214,  71213,  71212,  71211,  71210,  71208,  71207,  71206,  71205,
    71204,  71203,  71201,  71200,  71199,  71198,  71197,  71195,  71194,  71193,  71192,  71191,  71190,  71188,
    71187,  71186,  71185,  71184,  71182,  71181,  71180,  71179,  71178,  71177,  71175,  71174,  71173,  71172,
    71171,  71170,  71168,  71167,  71166,  71165,  71164,  71162,  71161,  71160,  71159,  71158,  71157,  71155,
    71154,  71153,  71152,  71151,  71149,  71148,  71147,  71146,  71145,  71144,  71142,  71141,  71140,  71139,
    71138,  71137,  71135,  71134,  71133,  71132,  71131,  71129,  71128,  71127,  71126,  71125,  71124,  71122,
    71121,  71120,  71119,  71118,  71116,  71115,  71114,  71113,  71112,  71111,  71109,  71108,  71107,  71106,
    71105,  71104,  71102,  71101,  71100,  71099,  71098,  71096,  71095,  71094,  71093,  71092,  71091,  71089,
    71088,  71087,  71086,  71085,  71084,  71082,  71081,  71080,  71079,  71078,  71076,  71075,  71074,  71073,
    71072,  71071,  71069,  71068,  71067,  71066,  71065,  71064,  71062,  71061,  71060,  71059,  71058,  71056,
    71055,  71054,  71053,  71052,  71051,  71049,  71048,  71047,  71046,  71045,  71044,  71042,  71041,  71040,
    71039,  71038,  71036,  71035,  71034,  71033,  71032,  71031,  71029,  71028,  71027,  71026,  71025,  71024,
    71022,  71021,  71020,  71019,  71018,  71017,  71015,  71014,  71013,  71012,  71011,  71009,  71008,  71007,
    71006,  71005,  71004,  71002,  71001,  71000,  70999,  70998,  70997,  70995,  70994,  70993,  70992,  70991,
    70990,  70988,  70987,  70986,  70985,  70984,  70982,  70981,  70980,  70979,  70978,  70977,  70975,  70974,
    70973,  70972,  70971,  70970,  70968,  70967,  70966,  70965,  70964,  70963,  70961,  70960,  70959,  70958,
    70957,  70956,  70954,  70953,  70952,  70951,  70950,  70948,  70947,  70946,  70945,  70944,  70943,  70941,
    70940,  70939,  70938,  70937,  70936,  70934,  70933,  70932,  70931,  70930,  70929,  70927,  70926,  70925,
    70924,  70923,  70922,  70920,  70919,  70918,  70917,  70916,  70915,  70913,  70912,  70911,  70910,  70909,
    70907,  70906,  70905,  70904,  70903,  70902,  70900,  70899,  70898,  70897,  70896,  70895,  70893,  70892,
    70891,  70890,  70889,  70888,  70886,  70885,  70884,  70883,  70882,  70881,  70879,  70878,  70877,  70876,
    70875,  70874,  70872,  70871,  70870,  70869,  70868,  70867,  70865,  70864,  70863,  70862,  70861,  70860,
    70858,  70857,  70856,  70855,  70854,  70853,  70851,  70850,  70849,  70848,  70847,  70845,  70844,  70843,
    70842,  70841,  70840,  70838,  70837,  70836,  70835,  70834,  70833,  70831,  70830,  70829,  70828,  70827,
    70826,  70824,  70823,  70822,  70821,  70820,  70819,  70817,  70816,  70815,  70814,  70813,  70812,  70810,
    70809,  70808,  70807,  70806,  70805,  70803,  70802,  70801,  70800,  70799,  70798,  70796,  70795,  70794,
    70793,  70792,  70791,  70789,  70788,  70787,  70786,  70785,  70784,  70782,  70781,  70780,  70779,  70778,
    70777,  70775,  70774,  70773,  70772,  70771,  70770,  70768,  70767,  70766,  70765,  70764,  70763,  70761,
    70760,  70759,  70758,  70757,  70756,  70754,  70753,  70752,  70751,  70750,  70749,  70747,  70746,  70745,
    70744,  70743,  70742,  70740,  70739,  70738,  70737,  70736,  70735,  70733,  70732,  70731,  70730,  70729,
    70728,  70726,  70725,  70724,  70723,  70722,  70721,  70720,  70718,  70717,  70716,  70715,  70714,  70713,
    70711,  70710,  70709,  70708,  70707,  70706,  70704,  70703,  70702,  70701,  70700,  70699,  70697,  70696,
    70695,  70694,  70693,  70692,  70690,  70689,  70688,  70687,  70686,  70685,  70683,  70682,  70681,  70680,
    70679,  70678,  70676,  70675,  70674,  70673,  70672,  70671,  70669,  70668,  70667,  70666,  70665,  70664,
    70662,  70661,  70660,  70659,  70658,  70657,  70656,  70654,  70653,  70652,  70651,  70650,  70649,  70647,
    70646,  70645,  70644,  70643,  70642,  70640,  70639,  70638,  70637,  70636,  70635,  70633,  70632,  70631,
    70630,  70629,  70628,  70626,  70625,  70624,  70623,  70622,  70621,  70620,  70618,  70617,  70616,  70615,
    70614,  70613,  70611,  70610,  70609,  70608,  70607,  70606,  70604,  70603,  70602,  70601,  70600,  70599,
    70597,  70596,  70595,  70594,  70593,  70592,  70590,  70589,  70588,  70587,  70586,  70585,  70584,  70582,
    70581,  70580,  70579,  70578,  70577,  70575,  70574,  70573,  70572,  70571,  70570,  70568,  70567,  70566,
    70565,  70564,  70563,  70561,  70560,  70559,  70558,  70557,  70556,  70555,  70553,  70552,  70551,  70550,
    70549,  70548,  70546,  70545,  70544,  70543,  70542,  70541,  70539,  70538,  70537,  70536,  70535,  70534,
    70533,  70531,  70530,  70529,  70528,  70527,  70526,  70524,  70523,  70522,  70521,  70520,  70519,  70517,
    70516,  70515,  70514,  70513,  70512,  70511,  70509,  70508,  70507,  70506,  70505,  70504,  70502,  70501,
    70500,  70499,  70498,  70497,  70495,  70494,  70493,  70492,  70491,  70490,  70489,  70487,  70486,  70485,
    70484,  70483,  70482,  70480,  70479,  70478,  70477,  70476,  70475,  70474,  70472,  70471,  70470,  70469,
    70468,  70467,  70465,  70464,  70463,  70462,  70461,  70460,  70458,  70457,  70456,  70455,  70454,  70453,
    70452,  70450,  70449,  70448,  70447,  70446,  70445,  70443,  70442,  70441,  70440,  70439,  70438,  70437,
    70435,  70434,  70433,  70432,  70431,  70430,  70428,  70427,  70426,  70425,  70424,  70423,  70422,  70420,
    70419,  70418,  70417,  70416,  70415,  70413,  70412,  70411,  70410,  70409,  70408,  70406,  70405,  70404,
    70403,  70402,  70401,  70400,  70398,  70397,  70396,  70395,  70394,  70393,  70391,  70390,  70389,  70388,
    70387,  70386,  70385,  70383,  70382,  70381,  70380,  70379,  70378,  70376,  70375,  70374,  70373,  70372,
    70371,  70370,  70368,  70367,  70366,  70365,  70364,  70363,  70362,  70360,  70359,  70358,  70357,  70356,
    70355,  70353,  70352,  70351,  70350,  70349,  70348,  70347,  70345,  70344,  70343,  70342,  70341,  70340,
    70338,  70337,  70336,  70335,  70334,  70333,  70332,  70330,  70329,  70328,  70327,  70326,  70325,  70323,
    70322,  70321,  70320,  70319,  70318,  70317,  70315,  70314,  70313,  70312,  70311,  70310,  70309,  70307,
    70306,  70305,  70304,  70303,  70302,  70300,  70299,  70298,  70297,  70296,  70295,  70294,  70292,  70291,
    70290,  70289,  70288,  70287,  70286,  70284,  70283,  70282,  70281,  70280,  70279,  70277,  70276,  70275,
    70274,  70273,  70272,  70271,  70269,  70268,  70267,  70266,  70265,  70264,  70263,  70261,  70260,  70259,
    70258,  70257,  70256,  70254,  70253,  70252,  70251,  70250,  70249,  70248,  70246,  70245,  70244,  70243,
    70242,  70241,  70240,  70238,  70237,  70236,  70235,  70234,  70233,  70231,  70230,  70229,  70228,  70227,
    70226,  70225,  70223,  70222,  70221,  70220,  70219,  70218,  70217,  70215,  70214,  70213,  70212,  70211,
    70210,  70209,  70207,  70206,  70205,  70204,  70203,  70202,  70201,  70199,  70198,  70197,  70196,  70195,
    70194,  70192,  70191,  70190,  70189,  70188,  70187,  70186,  70184,  70183,  70182,  70181,  70180,  70179,
    70178,  70176,  70175,  70174,  70173,  70172,  70171,  70170,  70168,  70167,  70166,  70165,  70164,  70163,
    70162,  70160,  70159,  70158,  70157,  70156,  70155,  70153,  70152,  70151,  70150,  70149,  70148,  70147,
    70145,  70144,  70143,  70142,  70141,  70140,  70139,  70137,  70136,  70135,  70134,  70133,  70132,  70131,
    70129,  70128,  70127,  70126,  70125,  70124,  70123,  70121,  70120,  70119,  70118,  70117,  70116,  70115,
    70113,  70112,  70111,  70110,  70109,  70108,  70107,  70105,  70104,  70103,  70102,  70101,  70100,  70099,
    70097,  70096,  70095,  70094,  70093,  70092,  70091,  70089,  70088,  70087,  70086,  70085,  70084,  70083,
    70081,  70080,  70079,  70078,  70077,  70076,  70075,  70073,  70072,  70071,  70070,  70069,  70068,  70067,
    70065,  70064,  70063,  70062,  70061,  70060,  70059,  70057,  70056,  70055,  70054,  70053,  70052,  70051,
    70049,  70048,  70047,  70046,  70045,  70044,  70043,  70041,  70040,  70039,  70038,  70037,  70036,  70035,
    70033,  70032,  70031,  70030,  70029,  70028,  70027,  70025,  70024,  70023,  70022,  70021,  70020,  70019,
    70017,  70016,  70015,  70014,  70013,  70012,  70011,  70009,  70008,  70007,  70006,  70005,  70004,  70003,
    70001,  70000,  69999,  69998,  69997,  69996,  69995,  69993,  69992,  69991,  69990,  69989,  69988,  69987,
    69985,  69984,  69983,  69982,  69981,  69980,  69979,  69977,  69976,  69975,  69974,  69973,  69972,  69971,
    69969,  69968,  69967,  69966,  69965,  69964,  69963,  69962,  69960,  69959,  69958,  69957,  69956,  69955,
    69954,  69952,  69951,  69950,  69949,  69948,  69947,  69946,  69944,  69943,  69942,  69941,  69940,  69939,
    69938,  69936,  69935,  69934,  69933,  69932,  69931,  69930,  69928,  69927,  69926,  69925,  69924,  69923,
    69922,  69921,  69919,  69918,  69917,  69916,  69915,  69914,  69913,  69911,  69910,  69909,  69908,  69907,
    69906,  69905,  69903,  69902,  69901,  69900,  69899,  69898,  69897,  69895,  69894,  69893,  69892,  69891,
    69890,  69889,  69888,  69886,  69885,  69884,  69883,  69882,  69881,  69880,  69878,  69877,  69876,  69875,
    69874,  69873,  69872,  69870,  69869,  69868,  69867,  69866,  69865,  69864,  69862,  69861,  69860,  69859,
    69858,  69857,  69856,  69855,  69853,  69852,  69851,  69850,  69849,  69848,  69847,  69845,  69844,  69843,
    69842,  69841,  69840,  69839,  69838,  69836,  69835,  69834,  69833,  69832,  69831,  69830,  69828,  69827,
    69826,  69825,  69824,  69823,  69822,  69820,  69819,  69818,  69817,  69816,  69815,  69814,  69813,  69811,
    69810,  69809,  69808,  69807,  69806,  69805,  69803,  69802,  69801,  69800,  69799,  69798,  69797,  69796,
    69794,  69793,  69792,  69791,  69790,  69789,  69788,  69786,  69785,  69784,  69783,  69782,  69781,  69780,
    69779,  69777,  69776,  69775,  69774,  69773,  69772,  69771,  69769,  69768,  69767,  69766,  69765,  69764,
    69763,  69762,  69760,  69759,  69758,  69757,  69756,  69755,  69754,  69752,  69751,  69750,  69749,  69748,
    69747,  69746,  69745,  69743,  69742,  69741,  69740,  69739,  69738,  69737,  69735,  69734,  69733,  69732,
    69731,  69730,  69729,  69728,  69726,  69725,  69724,  69723,  69722,  69721,  69720,  69718,  69717,  69716,
    69715,  69714,  69713,  69712,  69711,  69709,  69708,  69707,  69706,  69705,  69704,  69703,  69701,  69700,
    69699,  69698,  69697,  69696,  69695,  69694,  69692,  69691,  69690,  69689,  69688,  69687,  69686,  69685,
    69683,  69682,  69681,  69680,  69679,  69678,  69677,  69675,  69674,  69673,  69672,  69671,  69670,  69669,
    69668,  69666,  69665,  69664,  69663,  69662,  69661,  69660,  69659,  69657,  69656,  69655,  69654,  69653,
    69652,  69651,  69650,  69648,  69647,  69646,  69645,  69644,  69643,  69642,  69640,  69639,  69638,  69637,
    69636,  69635,  69634,  69633,  69631,  69630,  69629,  69628,  69627,  69626,  69625,  69624,  69622,  69621,
    69620,  69619,  69618,  69617,  69616,  69615,  69613,  69612,  69611,  69610,  69609,  69608,  69607,  69605,
    69604,  69603,  69602,  69601,  69600,  69599,  69598,  69596,  69595,  69594,  69593,  69592,  69591,  69590,
    69589,  69587,  69586,  69585,  69584,  69583,  69582,  69581,  69580,  69578,  69577,  69576,  69575,  69574,
    69573,  69572,  69571,  69569,  69568,  69567,  69566,  69565,  69564,  69563,  69562,  69560,  69559,  69558,
    69557,  69556,  69555,  69554,  69553,  69551,  69550,  69549,  69548,  69547,  69546,  69545,  69543,  69542,
    69541,  69540,  69539,  69538,  69537,  69536,  69534,  69533,  69532,  69531,  69530,  69529,  69528,  69527,
    69525,  69524,  69523,  69522,  69521,  69520,  69519,  69518,  69516,  69515,  69514,  69513,  69512,  69511,
    69510,  69509,  69507,  69506,  69505,  69504,  69503,  69502,  69501,  69500,  69498,  69497,  69496,  69495,
    69494,  69493,  69492,  69491,  69489,  69488,  69487,  69486,  69485,  69484,  69483,  69482,  69480,  69479,
    69478,  69477,  69476,  69475,  69474,  69473,  69472,  69470,  69469,  69468,  69467,  69466,  69465,  69464,
    69463,  69461,  69460,  69459,  69458,  69457,  69456,  69455,  69454,  69452,  69451,  69450,  69449,  69448,
    69447,  69446,  69445,  69443,  69442,  69441,  69440,  69439,  69438,  69437,  69436,  69434,  69433,  69432,
    69431,  69430,  69429,  69428,  69427,  69425,  69424,  69423,  69422,  69421,  69420,  69419,  69418,  69416,
    69415,  69414,  69413,  69412,  69411,  69410,  69409,  69408,  69406,  69405,  69404,  69403,  69402,  69401,
    69400,  69399,  69397,  69396,  69395,  69394,  69393,  69392,  69391,  69390,  69388,  69387,  69386,  69385,
    69384,  69383,  69382,  69381,  69379,  69378,  69377,  69376,  69375,  69374,  69373,  69372,  69371,  69369,
    69368,  69367,  69366,  69365,  69364,  69363,  69362,  69360,  69359,  69358,  69357,  69356,  69355,  69354,
    69353,  69351,  69350,  69349,  69348,  69347,  69346,  69345,  69344,  69343,  69341,  69340,  69339,  69338,
    69337,  69336,  69335,  69334,  69332,  69331,  69330,  69329,  69328,  69327,  69326,  69325,  69323,  69322,
    69321,  69320,  69319,  69318,  69317,  69316,  69315,  69313,  69312,  69311,  69310,  69309,  69308,  69307,
    69306,  69304,  69303,  69302,  69301,  69300,  69299,  69298,  69297,  69296,  69294,  69293,  69292,  69291,
    69290,  69289,  69288,  69287,  69285,  69284,  69283,  69282,  69281,  69280,  69279,  69278,  69277,  69275,
    69274,  69273,  69272,  69271,  69270,  69269,  69268,  69266,  69265,  69264,  69263,  69262,  69261,  69260,
    69259,  69258,  69256,  69255,  69254,  69253,  69252,  69251,  69250,  69249,  69247,  69246,  69245,  69244,
    69243,  69242,  69241,  69240,  69239,  69237,  69236,  69235,  69234,  69233,  69232,  69231,  69230,  69229,
    69227,  69226,  69225,  69224,  69223,  69222,  69221,  69220,  69218,  69217,  69216,  69215,  69214,  69213,
    69212,  69211,  69210,  69208,  69207,  69206,  69205,  69204,  69203,  69202,  69201,  69200,  69198,  69197,
    69196,  69195,  69194,  69193,  69192,  69191,  69189,  69188,  69187,  69186,  69185,  69184,  69183,  69182,
    69181,  69179,  69178,  69177,  69176,  69175,  69174,  69173,  69172,  69171,  69169,  69168,  69167,  69166,
    69165,  69164,  69163,  69162,  69161,  69159,  69158,  69157,  69156,  69155,  69154,  69153,  69152,  69150,
    69149,  69148,  69147,  69146,  69145,  69144,  69143,  69142,  69140,  69139,  69138,  69137,  69136,  69135,
    69134,  69133,  69132,  69130,  69129,  69128,  69127,  69126,  69125,  69124,  69123,  69122,  69120,  69119,
    69118,  69117,  69116,  69115,  69114,  69113,  69112,  69110,  69109,  69108,  69107,  69106,  69105,  69104,
    69103,  69102,  69100,  69099,  69098,  69097,  69096,  69095,  69094,  69093,  69092,  69090,  69089,  69088,
    69087,  69086,  69085,  69084,  69083,  69082,  69080,  69079,  69078,  69077,  69076,  69075,  69074,  69073,
    69072,  69070,  69069,  69068,  69067,  69066,  69065,  69064,  69063,  69062,  69060,  69059,  69058,  69057,
    69056,  69055,  69054,  69053,  69052,  69050,  69049,  69048,  69047,  69046,  69045,  69044,  69043,  69042,
    69040,  69039,  69038,  69037,  69036,  69035,  69034,  69033,  69032,  69030,  69029,  69028,  69027,  69026,
    69025,  69024,  69023,  69022,  69020,  69019,  69018,  69017,  69016,  69015,  69014,  69013,  69012,  69010,
    69009,  69008,  69007,  69006,  69005,  69004,  69003,  69002,  69001,  68999,  68998,  68997,  68996,  68995,
    68994,  68993,  68992,  68991,  68989,  68988,  68987,  68986,  68985,  68984,  68983,  68982,  68981,  68979,
    68978,  68977,  68976,  68975,  68974,  68973,  68972,  68971,  68969,  68968,  68967,  68966,  68965,  68964,
    68963,  68962,  68961,  68960,  68958,  68957,  68956,  68955,  68954,  68953,  68952,  68951,  68950,  68948,
    68947,  68946,  68945,  68944,  68943,  68942,  68941,  68940,  68938,  68937,  68936,  68935,  68934,  68933,
    68932,  68931,  68930,  68929,  68927,  68926,  68925,  68924,  68923,  68922,  68921,  68920,  68919,  68917,
    68916,  68915,  68914,  68913,  68912,  68911,  68910,  68909,  68908,  68906,  68905,  68904,  68903,  68902,
    68901,  68900,  68899,  68898,  68896,  68895,  68894,  68893,  68892,  68891,  68890,  68889,  68888,  68887,
    68885,  68884,  68883,  68882,  68881,  68880,  68879,  68878,  68877,  68875,  68874,  68873,  68872,  68871,
    68870,  68869,  68868,  68867,  68866,  68864,  68863,  68862,  68861,  68860,  68859,  68858,  68857,  68856,
    68854,  68853,  68852,  68851,  68850,  68849,  68848,  68847,  68846,  68845,  68843,  68842,  68841,  68840,
    68839,  68838,  68837,  68836,  68835,  68834,  68832,  68831,  68830,  68829,  68828,  68827,  68826,  68825,
    68824,  68822,  68821,  68820,  68819,  68818,  68817,  68816,  68815,  68814,  68813,  68811,  68810,  68809,
    68808,  68807,  68806,  68805,  68804,  68803,  68802,  68800,  68799,  68798,  68797,  68796,  68795,  68794,
    68793,  68792,  68791,  68789,  68788,  68787,  68786,  68785,  68784,  68783,  68782,  68781,  68780,  68778,
    68777,  68776,  68775,  68774,  68773,  68772,  68771,  68770,  68768,  68767,  68766,  68765,  68764,  68763,
    68762,  68761,  68760,  68759,  68757,  68756,  68755,  68754,  68753,  68752,  68751,  68750,  68749,  68748,
    68746,  68745,  68744,  68743,  68742,  68741,  68740,  68739,  68738,  68737,  68735,  68734,  68733,  68732,
    68731,  68730,  68729,  68728,  68727,  68726,  68724,  68723,  68722,  68721,  68720,  68719,  68718,  68717,
    68716,  68715,  68713,  68712,  68711,  68710,  68709,  68708,  68707,  68706,  68705,  68704,  68702,  68701,
    68700,  68699,  68698,  68697,  68696,  68695,  68694,  68693,  68692,  68690,  68689,  68688,  68687,  68686,
    68685,  68684,  68683,  68682,  68681,  68679,  68678,  68677,  68676,  68675,  68674,  68673,  68672,  68671,
    68670,  68668,  68667,  68666,  68665,  68664,  68663,  68662,  68661,  68660,  68659,  68657,  68656,  68655,
    68654,  68653,  68652,  68651,  68650,  68649,  68648,  68646,  68645,  68644,  68643,  68642,  68641,  68640,
    68639,  68638,  68637,  68636,  68634,  68633,  68632,  68631,  68630,  68629,  68628,  68627,  68626,  68625,
    68623,  68622,  68621,  68620,  68619,  68618,  68617,  68616,  68615,  68614,  68612,  68611,  68610,  68609,
    68608,  68607,  68606,  68605,  68604,  68603,  68602,  68600,  68599,  68598,  68597,  68596,  68595,  68594,
    68593,  68592,  68591,  68589,  68588,  68587,  68586,  68585,  68584,  68583,  68582,  68581,  68580,  68579,
    68577,  68576,  68575,  68574,  68573,  68572,  68571,  68570,  68569,  68568,  68566,  68565,  68564,  68563,
    68562,  68561,  68560,  68559,  68558,  68557,  68556,  68554,  68553,  68552,  68551,  68550,  68549,  68548,
    68547,  68546,  68545,  68544,  68542,  68541,  68540,  68539,  68538,  68537,  68536,  68535,  68534,  68533,
    68531,  68530,  68529,  68528,  68527,  68526,  68525,  68524,  68523,  68522,  68521,  68519,  68518,  68517,
    68516,  68515,  68514,  68513,  68512,  68511,  68510,  68509,  68507,  68506,  68505,  68504,  68503,  68502,
    68501,  68500,  68499,  68498,  68497,  68495,  68494,  68493,  68492,  68491,  68490,  68489,  68488,  68487,
    68486,  68484,  68483,  68482,  68481,  68480,  68479,  68478,  68477,  68476,  68475,  68474,  68472,  68471,
    68470,  68469,  68468,  68467,  68466,  68465,  68464,  68463,  68462,  68460,  68459,  68458,  68457,  68456,
    68455,  68454,  68453,  68452,  68451,  68450,  68448,  68447,  68446,  68445,  68444,  68443,  68442,  68441,
    68440,  68439,  68438,  68436,  68435,  68434,  68433,  68432,  68431,  68430,  68429,  68428,  68427,  68426,
    68424,  68423,  68422,  68421,  68420,  68419,  68418,  68417,  68416,  68415,  68414,  68412,  68411,  68410,
    68409,  68408,  68407,  68406,  68405,  68404,  68403,  68402,  68401,  68399,  68398,  68397,  68396,  68395,
    68394,  68393,  68392,  68391,  68390,  68389,  68387,  68386,  68385,  68384,  68383,  68382,  68381,  68380,
    68379,  68378,  68377,  68375,  68374,  68373,  68372,  68371,  68370,  68369,  68368,  68367,  68366,  68365,
    68363,  68362,  68361,  68360,  68359,  68358,  68357,  68356,  68355,  68354,  68353,  68352,  68350,  68349,
    68348,  68347,  68346,  68345,  68344,  68343,  68342,  68341,  68340,  68338,  68337,  68336,  68335,  68334,
    68333,  68332,  68331,  68330,  68329,  68328,  68327,  68325,  68324,  68323,  68322,  68321,  68320,  68319,
    68318,  68317,  68316,  68315,  68313,  68312,  68311,  68310,  68309,  68308,  68307,  68306,  68305,  68304,
    68303,  68302,  68300,  68299,  68298,  68297,  68296,  68295,  68294,  68293,  68292,  68291,  68290,  68288,
    68287,  68286,  68285,  68284,  68283,  68282,  68281,  68280,  68279,  68278,  68277,  68275,  68274,  68273,
    68272,  68271,  68270,  68269,  68268,  68267,  68266,  68265,  68264,  68262,  68261,  68260,  68259,  68258,
    68257,  68256,  68255,  68254,  68253,  68252,  68251,  68249,  68248,  68247,  68246,  68245,  68244,  68243,
    68242,  68241,  68240,  68239,  68237,  68236,  68235,  68234,  68233,  68232,  68231,  68230,  68229,  68228,
    68227,  68226,  68224,  68223,  68222,  68221,  68220,  68219,  68218,  68217,  68216,  68215,  68214,  68213,
    68211,  68210,  68209,  68208,  68207,  68206,  68205,  68204,  68203,  68202,  68201,  68200,  68198,  68197,
    68196,  68195,  68194,  68193,  68192,  68191,  68190,  68189,  68188,  68187,  68185,  68184,  68183,  68182,
    68181,  68180,  68179,  68178,  68177,  68176,  68175,  68174,  68173,  68171,  68170,  68169,  68168,  68167,
    68166,  68165,  68164,  68163,  68162,  68161,  68160,  68158,  68157,  68156,  68155,  68154,  68153,  68152,
    68151,  68150,  68149,  68148,  68147,  68145,  68144,  68143,  68142,  68141,  68140,  68139,  68138,  68137,
    68136,  68135,  68134,  68132,  68131,  68130,  68129,  68128,  68127,  68126,  68125,  68124,  68123,  68122,
    68121,  68120,  68118,  68117,  68116,  68115,  68114,  68113,  68112,  68111,  68110,  68109,  68108,  68107,
    68105,  68104,  68103,  68102,  68101,  68100,  68099,  68098,  68097,  68096,  68095,  68094,  68093,  68091,
    68090,  68089,  68088,  68087,  68086,  68085,  68084,  68083,  68082,  68081,  68080,  68078,  68077,  68076,
    68075,  68074,  68073,  68072,  68071,  68070,  68069,  68068,  68067,  68066,  68064,  68063,  68062,  68061,
    68060,  68059,  68058,  68057,  68056,  68055,  68054,  68053,  68052,  68050,  68049,  68048,  68047,  68046,
    68045,  68044,  68043,  68042,  68041,  68040,  68039,  68038,  68036,  68035,  68034,  68033,  68032,  68031,
    68030,  68029,  68028,  68027,  68026,  68025,  68024,  68022,  68021,  68020,  68019,  68018,  68017,  68016,
    68015,  68014,  68013,  68012,  68011,  68010,  68008,  68007,  68006,  68005,  68004,  68003,  68002,  68001,
    68000,  67999,  67998,  67997,  67996,  67994,  67993,  67992,  67991,  67990,  67989,  67988,  67987,  67986,
    67985,  67984,  67983,  67982,  67980,  67979,  67978,  67977,  67976,  67975,  67974,  67973,  67972,  67971,
    67970,  67969,  67968,  67966,  67965,  67964,  67963,  67962,  67961,  67960,  67959,  67958,  67957,  67956,
    67955,  67954,  67952,  67951,  67950,  67949,  67948,  67947,  67946,  67945,  67944,  67943,  67942,  67941,
    67940,  67938,  67937,  67936,  67935,  67934,  67933,  67932,  67931,  67930,  67929,  67928,  67927,  67926,
    67925,  67923,  67922,  67921,  67920,  67919,  67918,  67917,  67916,  67915,  67914,  67913,  67912,  67911,
    67909,  67908,  67907,  67906,  67905,  67904,  67903,  67902,  67901,  67900,  67899,  67898,  67897,  67896,
    67894,  67893,  67892,  67891,  67890,  67889,  67888,  67887,  67886,  67885,  67884,  67883,  67882,  67881,
    67879,  67878,  67877,  67876,  67875,  67874,  67873,  67872,  67871,  67870,  67869,  67868,  67867,  67865,
    67864,  67863,  67862,  67861,  67860,  67859,  67858,  67857,  67856,  67855,  67854,  67853,  67852,  67850,
    67849,  67848,  67847,  67846,  67845,  67844,  67843,  67842,  67841,  67840,  67839,  67838,  67837,  67835,
    67834,  67833,  67832,  67831,  67830,  67829,  67828,  67827,  67826,  67825,  67824,  67823,  67822,  67820,
    67819,  67818,  67817,  67816,  67815,  67814,  67813,  67812,  67811,  67810,  67809,  67808,  67807,  67805,
    67804,  67803,  67802,  67801,  67800,  67799,  67798,  67797,  67796,  67795,  67794,  67793,  67792,  67791,
    67789,  67788,  67787,  67786,  67785,  67784,  67783,  67782,  67781,  67780,  67779,  67778,  67777,  67776,
    67774,  67773,  67772,  67771,  67770,  67769,  67768,  67767,  67766,  67765,  67764,  67763,  67762,  67761,
    67759,  67758,  67757,  67756,  67755,  67754,  67753,  67752,  67751,  67750,  67749,  67748,  67747,  67746,
    67745,  67743,  67742,  67741,  67740,  67739,  67738,  67737,  67736,  67735,  67734,  67733,  67732,  67731,
    67730,  67729,  67727,  67726,  67725,  67724,  67723,  67722,  67721,  67720,  67719,  67718,  67717,  67716,
    67715,  67714,  67712,  67711,  67710,  67709,  67708,  67707,  67706,  67705,  67704,  67703,  67702,  67701,
    67700,  67699,  67698,  67696,  67695,  67694,  67693,  67692,  67691,  67690,  67689,  67688,  67687,  67686,
    67685,  67684,  67683,  67682,  67680,  67679,  67678,  67677,  67676,  67675,  67674,  67673,  67672,  67671,
    67670,  67669,  67668,  67667,  67666,  67664,  67663,  67662,  67661,  67660,  67659,  67658,  67657,  67656,
    67655,  67654,  67653,  67652,  67651,  67650,  67649,  67647,  67646,  67645,  67644,  67643,  67642,  67641,
    67640,  67639,  67638,  67637,  67636,  67635,  67634,  67633,  67631,  67630,  67629,  67628,  67627,  67626,
    67625,  67624,  67623,  67622,  67621,  67620,  67619,  67618,  67617,  67615,  67614,  67613,  67612,  67611,
    67610,  67609,  67608,  67607,  67606,  67605,  67604,  67603,  67602,  67601,  67600,  67598,  67597,  67596,
    67595,  67594,  67593,  67592,  67591,  67590,  67589,  67588,  67587,  67586,  67585,  67584,  67583,  67581,
    67580,  67579,  67578,  67577,  67576,  67575,  67574,  67573,  67572,  67571,  67570,  67569,  67568,  67567,
    67565,  67564,  67563,  67562,  67561,  67560,  67559,  67558,  67557,  67556,  67555,  67554,  67553,  67552,
    67551,  67550,  67548,  67547,  67546,  67545,  67544,  67543,  67542,  67541,  67540,  67539,  67538,  67537,
    67536,  67535,  67534,  67533,  67531,  67530,  67529,  67528,  67527,  67526,  67525,  67524,  67523,  67522,
    67521,  67520,  67519,  67518,  67517,  67516,  67515,  67513,  67512,  67511,  67510,  67509,  67508,  67507,
    67506,  67505,  67504,  67503,  67502,  67501,  67500,  67499,  67498,  67496,  67495,  67494,  67493,  67492,
    67491,  67490,  67489,  67488,  67487,  67486,  67485,  67484,  67483,  67482,  67481,  67480,  67478,  67477,
    67476,  67475,  67474,  67473,  67472,  67471,  67470,  67469,  67468,  67467,  67466,  67465,  67464,  67463,
    67461,  67460,  67459,  67458,  67457,  67456,  67455,  67454,  67453,  67452,  67451,  67450,  67449,  67448,
    67447,  67446,  67445,  67443,  67442,  67441,  67440,  67439,  67438,  67437,  67436,  67435,  67434,  67433,
    67432,  67431,  67430,  67429,  67428,  67427,  67425,  67424,  67423,  67422,  67421,  67420,  67419,  67418,
    67417,  67416,  67415,  67414,  67413,  67412,  67411,  67410,  67409,  67407,  67406,  67405,  67404,  67403,
    67402,  67401,  67400,  67399,  67398,  67397,  67396,  67395,  67394,  67393,  67392,  67391,  67390,  67388,
    67387,  67386,  67385,  67384,  67383,  67382,  67381,  67380,  67379,  67378,  67377,  67376,  67375,  67374,
    67373,  67372,  67370,  67369,  67368,  67367,  67366,  67365,  67364,  67363,  67362,  67361,  67360,  67359,
    67358,  67357,  67356,  67355,  67354,  67353,  67351,  67350,  67349,  67348,  67347,  67346,  67345,  67344,
    67343,  67342,  67341,  67340,  67339,  67338,  67337,  67336,  67335,  67334,  67332,  67331,  67330,  67329,
    67328,  67327,  67326,  67325,  67324,  67323,  67322,  67321,  67320,  67319,  67318,  67317,  67316,  67315,
    67313,  67312,  67311,  67310,  67309,  67308,  67307,  67306,  67305,  67304,  67303,  67302,  67301,  67300,
    67299,  67298,  67297,  67296,  67294,  67293,  67292,  67291,  67290,  67289,  67288,  67287,  67286,  67285,
    67284,  67283,  67282,  67281,  67280,  67279,  67278,  67277,  67276,  67274,  67273,  67272,  67271,  67270,
    67269,  67268,  67267,  67266,  67265,  67264,  67263,  67262,  67261,  67260,  67259,  67258,  67257,  67255,
    67254,  67253,  67252,  67251,  67250,  67249,  67248,  67247,  67246,  67245,  67244,  67243,  67242,  67241,
    67240,  67239,  67238,  67237,  67235,  67234,  67233,  67232,  67231,  67230,  67229,  67228,  67227,  67226,
    67225,  67224,  67223,  67222,  67221,  67220,  67219,  67218,  67217,  67215,  67214,  67213,  67212,  67211,
    67210,  67209,  67208,  67207,  67206,  67205,  67204,  67203,  67202,  67201,  67200,  67199,  67198,  67197,
    67196,  67194,  67193,  67192,  67191,  67190,  67189,  67188,  67187,  67186,  67185,  67184,  67183,  67182,
    67181,  67180,  67179,  67178,  67177,  67176,  67174,  67173,  67172,  67171,  67170,  67169,  67168,  67167,
    67166,  67165,  67164,  67163,  67162,  67161,  67160,  67159,  67158,  67157,  67156,  67155,  67153,  67152,
    67151,  67150,  67149,  67148,  67147,  67146,  67145,  67144,  67143,  67142,  67141,  67140,  67139,  67138,
    67137,  67136,  67135,  67134,  67132,  67131,  67130,  67129,  67128,  67127,  67126,  67125,  67124,  67123,
    67122,  67121,  67120,  67119,  67118,  67117,  67116,  67115,  67114,  67113,  67112,  67110,  67109,  67108,
    67107,  67106,  67105,  67104,  67103,  67102,  67101,  67100,  67099,  67098,  67097,  67096,  67095,  67094,
    67093,  67092,  67091,  67089,  67088,  67087,  67086,  67085,  67084,  67083,  67082,  67081,  67080,  67079,
    67078,  67077,  67076,  67075,  67074,  67073,  67072,  67071,  67070,  67069,  67067,  67066,  67065,  67064,
    67063,  67062,  67061,  67060,  67059,  67058,  67057,  67056,  67055,  67054,  67053,  67052,  67051,  67050,
    67049,  67048,  67047,  67046,  67044,  67043,  67042,  67041,  67040,  67039,  67038,  67037,  67036,  67035,
    67034,  67033,  67032,  67031,  67030,  67029,  67028,  67027,  67026,  67025,  67024,  67022,  67021,  67020,
    67019,  67018,  67017,  67016,  67015,  67014,  67013,  67012,  67011,  67010,  67009,  67008,  67007,  67006,
    67005,  67004,  67003,  67002,  67001,  66999,  66998,  66997,  66996,  66995,  66994,  66993,  66992,  66991,
    66990,  66989,  66988,  66987,  66986,  66985,  66984,  66983,  66982,  66981,  66980,  66979,  66978,  66977,
    66975,  66974,  66973,  66972,  66971,  66970,  66969,  66968,  66967,  66966,  66965,  66964,  66963,  66962,
    66961,  66960,  66959,  66958,  66957,  66956,  66955,  66954,  66952,  66951,  66950,  66949,  66948,  66947,
    66946,  66945,  66944,  66943,  66942,  66941,  66940,  66939,  66938,  66937,  66936,  66935,  66934,  66933,
    66932,  66931,  66930,  66928,  66927,  66926,  66925,  66924,  66923,  66922,  66921,  66920,  66919,  66918,
    66917,  66916,  66915,  66914,  66913,  66912,  66911,  66910,  66909,  66908,  66907,  66906,  66905,  66903,
    66902,  66901,  66900,  66899,  66898,  66897,  66896,  66895,  66894,  66893,  66892,  66891,  66890,  66889,
    66888,  66887,  66886,  66885,  66884,  66883,  66882,  66881,  66880,  66878,  66877,  66876,  66875,  66874,
    66873,  66872,  66871,  66870,  66869,  66868,  66867,  66866,  66865,  66864,  66863,  66862,  66861,  66860,
    66859,  66858,  66857,  66856,  66855,  66853,  66852,  66851,  66850,  66849,  66848,  66847,  66846,  66845,
    66844,  66843,  66842,  66841,  66840,  66839,  66838,  66837,  66836,  66835,  66834,  66833,  66832,  66831,
    66830,  66829,  66827,  66826,  66825,  66824,  66823,  66822,  66821,  66820,  66819,  66818,  66817,  66816,
    66815,  66814,  66813,  66812,  66811,  66810,  66809,  66808,  66807,  66806,  66805,  66804,  66803,  66801,
    66800,  66799,  66798,  66797,  66796,  66795,  66794,  66793,  66792,  66791,  66790,  66789,  66788,  66787,
    66786,  66785,  66784,  66783,  66782,  66781,  66780,  66779,  66778,  66777,  66776,  66774,  66773,  66772,
    66771,  66770,  66769,  66768,  66767,  66766,  66765,  66764,  66763,  66762,  66761,  66760,  66759,  66758,
    66757,  66756,  66755,  66754,  66753,  66752,  66751,  66750,  66749,  66748,  66746,  66745,  66744,  66743,
    66742,  66741,  66740,  66739,  66738,  66737,  66736,  66735,  66734,  66733,  66732,  66731,  66730,  66729,
    66728,  66727,  66726,  66725,  66724,  66723,  66722,  66721,  66720,  66718,  66717,  66716,  66715,  66714,
    66713,  66712,  66711,  66710,  66709,  66708,  66707,  66706,  66705,  66704,  66703,  66702,  66701,  66700,
    66699,  66698,  66697,  66696,  66695,  66694,  66693,  66692,  66691,  66689,  66688,  66687,  66686,  66685,
    66684,  66683,  66682,  66681,  66680,  66679,  66678,  66677,  66676,  66675,  66674,  66673,  66672,  66671,
    66670,  66669,  66668,  66667,  66666,  66665,  66664,  66663,  66662,  66660,  66659,  66658,  66657,  66656,
    66655,  66654,  66653,  66652,  66651,  66650,  66649,  66648,  66647,  66646,  66645,  66644,  66643,  66642,
    66641,  66640,  66639,  66638,  66637,  66636,  66635,  66634,  66633,  66632,  66630,  66629,  66628,  66627,
    66626,  66625,  66624,  66623,  66622,  66621,  66620,  66619,  66618,  66617,  66616,  66615,  66614,  66613,
    66612,  66611,  66610,  66609,  66608,  66607,  66606,  66605,  66604,  66603,  66602,  66601,  66600,  66598,
    66597,  66596,  66595,  66594,  66593,  66592,  66591,  66590,  66589,  66588,  66587,  66586,  66585,  66584,
    66583,  66582,  66581,  66580,  66579,  66578,  66577,  66576,  66575,  66574,  66573,  66572,  66571,  66570,
    66569,  66568,  66566,  66565,  66564,  66563,  66562,  66561,  66560,  66559,  66558,  66557,  66556,  66555,
    66554,  66553,  66552,  66551,  66550,  66549,  66548,  66547,  66546,  66545,  66544,  66543,  66542,  66541,
    66540,  66539,  66538,  66537,  66536,  66535,  66533,  66532,  66531,  66530,  66529,  66528,  66527,  66526,
    66525,  66524,  66523,  66522,  66521,  66520,  66519,  66518,  66517,  66516,  66515,  66514,  66513,  66512,
    66511,  66510,  66509,  66508,  66507,  66506,  66505,  66504,  66503,  66502,  66501,  66499,  66498,  66497,
    66496,  66495,  66494,  66493,  66492,  66491,  66490,  66489,  66488,  66487,  66486,  66485,  66484,  66483,
    66482,  66481,  66480,  66479,  66478,  66477,  66476,  66475,  66474,  66473,  66472,  66471,  66470,  66469,
    66468,  66467,  66466,  66464,  66463,  66462,  66461,  66460,  66459,  66458,  66457,  66456,  66455,  66454,
    66453,  66452,  66451,  66450,  66449,  66448,  66447,  66446,  66445,  66444,  66443,  66442,  66441,  66440,
    66439,  66438,  66437,  66436,  66435,  66434,  66433,  66432,  66431,  66430,  66429,  66427,  66426,  66425,
    66424,  66423,  66422,  66421,  66420,  66419,  66418,  66417,  66416,  66415,  66414,  66413,  66412,  66411,
    66410,  66409,  66408,  66407,  66406,  66405,  66404,  66403,  66402,  66401,  66400,  66399,  66398,  66397,
    66396,  66395,  66394,  66393,  66392,  66391,  66389,  66388,  66387,  66386,  66385,  66384,  66383,  66382,
    66381,  66380,  66379,  66378,  66377,  66376,  66375,  66374,  66373,  66372,  66371,  66370,  66369,  66368,
    66367,  66366,  66365,  66364,  66363,  66362,  66361,  66360,  66359,  66358,  66357,  66356,  66355,  66354,
    66353,  66352,  66351,  66349,  66348,  66347,  66346,  66345,  66344,  66343,  66342,  66341,  66340,  66339,
    66338,  66337,  66336,  66335,  66334,  66333,  66332,  66331,  66330,  66329,  66328,  66327,  66326,  66325,
    66324,  66323,  66322,  66321,  66320,  66319,  66318,  66317,  66316,  66315,  66314,  66313,  66312,  66311,
    66310,  66309,  66307,  66306,  66305,  66304,  66303,  66302,  66301,  66300,  66299,  66298,  66297,  66296,
    66295,  66294,  66293,  66292,  66291,  66290,  66289,  66288,  66287,  66286,  66285,  66284,  66283,  66282,
    66281,  66280,  66279,  66278,  66277,  66276,  66275,  66274,  66273,  66272,  66271,  66270,  66269,  66268,
    66267,  66266,  66265,  66264,  66262,  66261,  66260,  66259,  66258,  66257,  66256,  66255,  66254,  66253,
    66252,  66251,  66250,  66249,  66248,  66247,  66246,  66245,  66244,  66243,  66242,  66241,  66240,  66239,
    66238,  66237,  66236,  66235,  66234,  66233,  66232,  66231,  66230,  66229,  66228,  66227,  66226,  66225,
    66224,  66223,  66222,  66221,  66220,  66219,  66218,  66217,  66215,  66214,  66213,  66212,  66211,  66210,
    66209,  66208,  66207,  66206,  66205,  66204,  66203,  66202,  66201,  66200,  66199,  66198,  66197,  66196,
    66195,  66194,  66193,  66192,  66191,  66190,  66189,  66188,  66187,  66186,  66185,  66184,  66183,  66182,
    66181,  66180,  66179,  66178,  66177,  66176,  66175,  66174,  66173,  66172,  66171,  66170,  66169,  66168,
    66167,  66166,  66164,  66163,  66162,  66161,  66160,  66159,  66158,  66157,  66156,  66155,  66154,  66153,
    66152,  66151,  66150,  66149,  66148,  66147,  66146,  66145,  66144,  66143,  66142,  66141,  66140,  66139,
    66138,  66137,  66136,  66135,  66134,  66133,  66132,  66131,  66130,  66129,  66128,  66127,  66126,  66125,
    66124,  66123,  66122,  66121,  66120,  66119,  66118,  66117,  66116,  66115,  66114,  66113,  66112,  66111,
    66109,  66108,  66107,  66106,  66105,  66104,  66103,  66102,  66101,  66100,  66099,  66098,  66097,  66096,
    66095,  66094,  66093,  66092,  66091,  66090,  66089,  66088,  66087,  66086,  66085,  66084,  66083,  66082,
    66081,  66080,  66079,  66078,  66077,  66076,  66075,  66074,  66073,  66072,  66071,  66070,  66069,  66068,
    66067,  66066,  66065,  66064,  66063,  66062,  66061,  66060,  66059,  66058,  66057,  66056,  66055,  66054,
    66053,  66052,  66051,  66050,  66048,  66047,  66046,  66045,  66044,  66043,  66042,  66041,  66040,  66039,
    66038,  66037,  66036,  66035,  66034,  66033,  66032,  66031,  66030,  66029,  66028,  66027,  66026,  66025,
    66024,  66023,  66022,  66021,  66020,  66019,  66018,  66017,  66016,  66015,  66014,  66013,  66012,  66011,
    66010,  66009,  66008,  66007,  66006,  66005,  66004,  66003,  66002,  66001,  66000,  65999,  65998,  65997,
    65996,  65995,  65994,  65993,  65992,  65991,  65990,  65989,  65988,  65987,  65986,  65985,  65984,  65983,
    65982,  65981,  65979,  65978,  65977,  65976,  65975,  65974,  65973,  65972,  65971,  65970,  65969,  65968,
    65967,  65966,  65965,  65964,  65963,  65962,  65961,  65960,  65959,  65958,  65957,  65956,  65955,  65954,
    65953,  65952,  65951,  65950,  65949,  65948,  65947,  65946,  65945,  65944,  65943,  65942,  65941,  65940,
    65939,  65938,  65937,  65936,  65935,  65934,  65933,  65932,  65931,  65930,  65929,  65928,  65927,  65926,
    65925,  65924,  65923,  65922,  65921,  65920,  65919,  65918,  65917,  65916,  65915,  65914,  65913,  65912,
    65911,  65910,  65909,  65908,  65907,  65906,  65905,  65904,  65903,  65902,  65901,  65900,  65899,  65897,
    65896,  65895,  65894,  65893,  65892,  65891,  65890,  65889,  65888,  65887,  65886,  65885,  65884,  65883,
    65882,  65881,  65880,  65879,  65878,  65877,  65876,  65875,  65874,  65873,  65872,  65871,  65870,  65869,
    65868,  65867,  65866,  65865,  65864,  65863,  65862,  65861,  65860,  65859,  65858,  65857,  65856,  65855,
    65854,  65853,  65852,  65851,  65850,  65849,  65848,  65847,  65846,  65845,  65844,  65843,  65842,  65841,
    65840,  65839,  65838,  65837,  65836,  65835,  65834,  65833,  65832,  65831,  65830,  65829,  65828,  65827,
    65826,  65825,  65824,  65823,  65822,  65821,  65820,  65819,  65818,  65817,  65816,  65815,  65814,  65813,
    65812,  65811,  65810,  65809,  65808,  65807,  65806,  65805,  65804,  65803,  65802,  65801,  65800,  65799,
    65798,  65797,  65796,  65795,  65794,  65793,  65791,  65790,  65789,  65788,  65787,  65786,  65785,  65784,
    65783,  65782,  65781,  65780,  65779,  65778,  65777,  65776,  65775,  65774,  65773,  65772,  65771,  65770,
    65769,  65768,  65767,  65766,  65765,  65764,  65763,  65762,  65761,  65760,  65759,  65758,  65757,  65756,
    65755,  65754,  65753,  65752,  65751,  65750,  65749,  65748,  65747,  65746,  65745,  65744,  65743,  65742,
    65741,  65740,  65739,  65738,  65737,  65736,  65735,  65734,  65733,  65732,  65731,  65730,  65729,  65728,
    65727,  65726,  65725,  65724,  65723,  65722,  65721,  65720,  65719,  65718,  65717,  65716,  65715,  65714,
    65713,  65712,  65711,  65710,  65709,  65708,  65707,  65706,  65705,  65704,  65703,  65702,  65701,  65700,
    65699,  65698,  65697,  65696,  65695,  65694,  65693,  65692,  65691,  65690,  65689,  65688,  65687,  65686,
    65685,  65684,  65683,  65682,  65681,  65680,  65679,  65678,  65677,  65676,  65675,  65674,  65673,  65672,
    65671,  65670,  65669,  65668,  65667,  65666,  65665,  65664,  65663,  65662,  65661,  65660,  65659,  65658,
    65657,  65656,  65655,  65654,  65653,  65652,  65651,  65650,  65649,  65648,  65647,  65646,  65645,  65644,
    65643,  65642,  65641,  65640,  65639,  65638,  65637,  65636,  65635,  65634,  65633,  65632,  65631,  65630,
    65629,  65628,  65627,  65626,  65625,  65624,  65623,  65622,  65621,  65620,  65619,  65618,  65617,  65616,
    65615,  65614,  65613,  65612,  65611,  65610,  65609,  65608,  65607,  65606,  65605,  65604,  65603,  65602,
    65601,  65600,  65599,  65598,  65597,  65596,  65595,  65594,  65593,  65592,  65591,  65590,  65589,  65588,
    65587,  65586,  65585,  65584,  65583,  65582,  65581,  65580,  65579,  65578,  65577,  65576,  65575,  65574,
    65573,  65572,  65571,  65570,  65569,  65568,  65567,  65566,  65565,  65564,  65563,  65562,  65561,  65560,
    65559,  65558,  65557,  65556,  65555,  65554,  65553,  65552,  65551,  65550,  65549,  65548,  65547,  65546,
    65545,  65544,  65543,  65542,  65541,  65540,  65539,  65538};

// look up table for division
static unsigned short division_lut[] = {
    65535, 65535, 65535, 65504, 65472, 65440, 65408, 65376, 65344, 65312, 65280, 65249, 65217, 65185, 65154, 65122,
    65091, 65059, 65027, 64996, 64965, 64933, 64902, 64870, 64839, 64808, 64776, 64745, 64714, 64683, 64652, 64620,
    64589, 64558, 64527, 64496, 64465, 64434, 64403, 64373, 64342, 64311, 64280, 64249, 64219, 64188, 64157, 64126,
    64096, 64065, 64035, 64004, 63974, 63943, 63913, 63882, 63852, 63822, 63791, 63761, 63731, 63700, 63670, 63640,
    63610, 63580, 63550, 63519, 63489, 63459, 63429, 63399, 63370, 63340, 63310, 63280, 63250, 63220, 63191, 63161,
    63131, 63101, 63072, 63042, 63013, 62983, 62953, 62924, 62894, 62865, 62836, 62806, 62777, 62747, 62718, 62689,
    62660, 62630, 62601, 62572, 62543, 62514, 62484, 62455, 62426, 62397, 62368, 62339, 62310, 62282, 62253, 62224,
    62195, 62166, 62137, 62109, 62080, 62051, 62022, 61994, 61965, 61937, 61908, 61880, 61851, 61822, 61794, 61766,
    61737, 61709, 61680, 61652, 61624, 61596, 61567, 61539, 61511, 61483, 61455, 61426, 61398, 61370, 61342, 61314,
    61286, 61258, 61230, 61202, 61174, 61147, 61119, 61091, 61063, 61035, 61008, 60980, 60952, 60924, 60897, 60869,
    60842, 60814, 60787, 60759, 60732, 60704, 60677, 60649, 60622, 60594, 60567, 60540, 60512, 60485, 60458, 60431,
    60404, 60376, 60349, 60322, 60295, 60268, 60241, 60214, 60187, 60160, 60133, 60106, 60079, 60052, 60025, 59998,
    59972, 59945, 59918, 59891, 59865, 59838, 59811, 59785, 59758, 59731, 59705, 59678, 59652, 59625, 59599, 59572,
    59546, 59520, 59493, 59467, 59440, 59414, 59388, 59362, 59335, 59309, 59283, 59257, 59231, 59204, 59178, 59152,
    59126, 59100, 59074, 59048, 59022, 58996, 58970, 58944, 58919, 58893, 58867, 58841, 58815, 58790, 58764, 58738,
    58712, 58687, 58661, 58635, 58610, 58584, 58559, 58533, 58508, 58482, 58457, 58431, 58406, 58380, 58355, 58330,
    58304, 58279, 58254, 58228, 58203, 58178, 58153, 58128, 58102, 58077, 58052, 58027, 58002, 57977, 57952, 57927,
    57902, 57877, 57852, 57827, 57802, 57777, 57752, 57728, 57703, 57678, 57653, 57628, 57604, 57579, 57554, 57530,
    57505, 57480, 57456, 57431, 57407, 57382, 57358, 57333, 57309, 57284, 57260, 57235, 57211, 57186, 57162, 57138,
    57113, 57089, 57065, 57041, 57016, 56992, 56968, 56944, 56920, 56896, 56871, 56847, 56823, 56799, 56775, 56751,
    56727, 56703, 56679, 56655, 56631, 56608, 56584, 56560, 56536, 56512, 56488, 56465, 56441, 56417, 56394, 56370,
    56346, 56323, 56299, 56275, 56252, 56228, 56205, 56181, 56158, 56134, 56111, 56087, 56064, 56040, 56017, 55994,
    55970, 55947, 55924, 55900, 55877, 55854, 55831, 55807, 55784, 55761, 55738, 55715, 55692, 55668, 55645, 55622,
    55599, 55576, 55553, 55530, 55507, 55484, 55461, 55438, 55416, 55393, 55370, 55347, 55324, 55301, 55279, 55256,
    55233, 55210, 55188, 55165, 55142, 55120, 55097, 55074, 55052, 55029, 55007, 54984, 54962, 54939, 54917, 54894,
    54872, 54849, 54827, 54805, 54782, 54760, 54738, 54715, 54693, 54671, 54648, 54626, 54604, 54582, 54560, 54537,
    54515, 54493, 54471, 54449, 54427, 54405, 54383, 54361, 54339, 54317, 54295, 54273, 54251, 54229, 54207, 54185,
    54163, 54141, 54120, 54098, 54076, 54054, 54032, 54011, 53989, 53967, 53946, 53924, 53902, 53881, 53859, 53837,
    53816, 53794, 53773, 53751, 53730, 53708, 53687, 53665, 53644, 53622, 53601, 53579, 53558, 53537, 53515, 53494,
    53473, 53451, 53430, 53409, 53388, 53366, 53345, 53324, 53303, 53282, 53261, 53239, 53218, 53197, 53176, 53155,
    53134, 53113, 53092, 53071, 53050, 53029, 53008, 52987, 52966, 52945, 52924, 52904, 52883, 52862, 52841, 52820,
    52800, 52779, 52758, 52737, 52717, 52696, 52675, 52655, 52634, 52613, 52593, 52572, 52551, 52531, 52510, 52490,
    52469, 52449, 52428, 52408, 52387, 52367, 52347, 52326, 52306, 52285, 52265, 52245, 52224, 52204, 52184, 52163,
    52143, 52123, 52103, 52082, 52062, 52042, 52022, 52002, 51982, 51961, 51941, 51921, 51901, 51881, 51861, 51841,
    51821, 51801, 51781, 51761, 51741, 51721, 51701, 51681, 51661, 51642, 51622, 51602, 51582, 51562, 51542, 51523,
    51503, 51483, 51463, 51444, 51424, 51404, 51385, 51365, 51345, 51326, 51306, 51286, 51267, 51247, 51228, 51208,
    51189, 51169, 51150, 51130, 51111, 51091, 51072, 51052, 51033, 51013, 50994, 50975, 50955, 50936, 50917, 50897,
    50878, 50859, 50840, 50820, 50801, 50782, 50763, 50743, 50724, 50705, 50686, 50667, 50648, 50629, 50610, 50590,
    50571, 50552, 50533, 50514, 50495, 50476, 50457, 50438, 50419, 50400, 50382, 50363, 50344, 50325, 50306, 50287,
    50268, 50249, 50231, 50212, 50193, 50174, 50156, 50137, 50118, 50099, 50081, 50062, 50043, 50025, 50006, 49987,
    49969, 49950, 49932, 49913, 49895, 49876, 49857, 49839, 49820, 49802, 49784, 49765, 49747, 49728, 49710, 49691,
    49673, 49655, 49636, 49618, 49600, 49581, 49563, 49545, 49526, 49508, 49490, 49472, 49453, 49435, 49417, 49399,
    49381, 49362, 49344, 49326, 49308, 49290, 49272, 49254, 49236, 49218, 49200, 49182, 49164, 49146, 49128, 49110,
    49092, 49074, 49056, 49038, 49020, 49002, 48984, 48966, 48948, 48931, 48913, 48895, 48877, 48859, 48841, 48824,
    48806, 48788, 48770, 48753, 48735, 48717, 48700, 48682, 48664, 48647, 48629, 48612, 48594, 48576, 48559, 48541,
    48524, 48506, 48489, 48471, 48454, 48436, 48419, 48401, 48384, 48366, 48349, 48331, 48314, 48297, 48279, 48262,
    48245, 48227, 48210, 48193, 48175, 48158, 48141, 48123, 48106, 48089, 48072, 48055, 48037, 48020, 48003, 47986,
    47969, 47952, 47934, 47917, 47900, 47883, 47866, 47849, 47832, 47815, 47798, 47781, 47764, 47747, 47730, 47713,
    47696, 47679, 47662, 47645, 47628, 47611, 47594, 47578, 47561, 47544, 47527, 47510, 47493, 47477, 47460, 47443,
    47426, 47410, 47393, 47376, 47359, 47343, 47326, 47309, 47293, 47276, 47259, 47243, 47226, 47209, 47193, 47176,
    47160, 47143, 47127, 47110, 47093, 47077, 47060, 47044, 47027, 47011, 46995, 46978, 46962, 46945, 46929, 46912,
    46896, 46880, 46863, 46847, 46831, 46814, 46798, 46782, 46765, 46749, 46733, 46716, 46700, 46684, 46668, 46651,
    46635, 46619, 46603, 46587, 46571, 46554, 46538, 46522, 46506, 46490, 46474, 46458, 46442, 46426, 46410, 46393,
    46377, 46361, 46345, 46329, 46313, 46297, 46281, 46266, 46250, 46234, 46218, 46202, 46186, 46170, 46154, 46138,
    46122, 46107, 46091, 46075, 46059, 46043, 46028, 46012, 45996, 45980, 45964, 45949, 45933, 45917, 45902, 45886,
    45870, 45855, 45839, 45823, 45808, 45792, 45776, 45761, 45745, 45730, 45714, 45698, 45683, 45667, 45652, 45636,
    45621, 45605, 45590, 45574, 45559, 45543, 45528, 45512, 45497, 45482, 45466, 45451, 45435, 45420, 45405, 45389,
    45374, 45359, 45343, 45328, 45313, 45297, 45282, 45267, 45252, 45236, 45221, 45206, 45191, 45175, 45160, 45145,
    45130, 45115, 45100, 45084, 45069, 45054, 45039, 45024, 45009, 44994, 44979, 44964, 44949, 44933, 44918, 44903,
    44888, 44873, 44858, 44843, 44828, 44813, 44798, 44784, 44769, 44754, 44739, 44724, 44709, 44694, 44679, 44664,
    44649, 44635, 44620, 44605, 44590, 44575, 44561, 44546, 44531, 44516, 44501, 44487, 44472, 44457, 44442, 44428,
    44413, 44398, 44384, 44369, 44354, 44340, 44325, 44310, 44296, 44281, 44267, 44252, 44237, 44223, 44208, 44194,
    44179, 44165, 44150, 44136, 44121, 44107, 44092, 44078, 44063, 44049, 44034, 44020, 44005, 43991, 43976, 43962,
    43948, 43933, 43919, 43905, 43890, 43876, 43862, 43847, 43833, 43819, 43804, 43790, 43776, 43761, 43747, 43733,
    43719, 43704, 43690, 43676, 43662, 43648, 43633, 43619, 43605, 43591, 43577, 43563, 43548, 43534, 43520, 43506,
    43492, 43478, 43464, 43450, 43436, 43422, 43408, 43394, 43380, 43365, 43351, 43337, 43323, 43310, 43296, 43282,
    43268, 43254, 43240, 43226, 43212, 43198, 43184, 43170, 43156, 43142, 43129, 43115, 43101, 43087, 43073, 43059,
    43046, 43032, 43018, 43004, 42990, 42977, 42963, 42949, 42935, 42922, 42908, 42894, 42881, 42867, 42853, 42840,
    42826, 42812, 42799, 42785, 42771, 42758, 42744, 42730, 42717, 42703, 42690, 42676, 42662, 42649, 42635, 42622,
    42608, 42595, 42581, 42568, 42554, 42541, 42527, 42514, 42500, 42487, 42473, 42460, 42447, 42433, 42420, 42406,
    42393, 42380, 42366, 42353, 42339, 42326, 42313, 42299, 42286, 42273, 42259, 42246, 42233, 42220, 42206, 42193,
    42180, 42167, 42153, 42140, 42127, 42114, 42100, 42087, 42074, 42061, 42048, 42034, 42021, 42008, 41995, 41982,
    41969, 41956, 41943, 41929, 41916, 41903, 41890, 41877, 41864, 41851, 41838, 41825, 41812, 41799, 41786, 41773,
    41760, 41747, 41734, 41721, 41708, 41695, 41682, 41669, 41656, 41643, 41630, 41617, 41605, 41592, 41579, 41566,
    41553, 41540, 41527, 41514, 41502, 41489, 41476, 41463, 41450, 41438, 41425, 41412, 41399, 41386, 41374, 41361,
    41348, 41335, 41323, 41310, 41297, 41285, 41272, 41259, 41246, 41234, 41221, 41209, 41196, 41183, 41171, 41158,
    41145, 41133, 41120, 41108, 41095, 41082, 41070, 41057, 41045, 41032, 41020, 41007, 40995, 40982, 40970, 40957,
    40945, 40932, 40920, 40907, 40895, 40882, 40870, 40857, 40845, 40832, 40820, 40808, 40795, 40783, 40770, 40758,
    40746, 40733, 40721, 40709, 40696, 40684, 40672, 40659, 40647, 40635, 40622, 40610, 40598, 40585, 40573, 40561,
    40549, 40536, 40524, 40512, 40500, 40488, 40475, 40463, 40451, 40439, 40427, 40414, 40402, 40390, 40378, 40366,
    40354, 40341, 40329, 40317, 40305, 40293, 40281, 40269, 40257, 40245, 40233, 40221, 40209, 40196, 40184, 40172,
    40160, 40148, 40136, 40124, 40112, 40100, 40088, 40076, 40064, 40053, 40041, 40029, 40017, 40005, 39993, 39981,
    39969, 39957, 39945, 39933, 39921, 39910, 39898, 39886, 39874, 39862, 39850, 39839, 39827, 39815, 39803, 39791,
    39780, 39768, 39756, 39744, 39732, 39721, 39709, 39697, 39685, 39674, 39662, 39650, 39639, 39627, 39615, 39603,
    39592, 39580, 39568, 39557, 39545, 39533, 39522, 39510, 39499, 39487, 39475, 39464, 39452, 39441, 39429, 39417,
    39406, 39394, 39383, 39371, 39360, 39348, 39336, 39325, 39313, 39302, 39290, 39279, 39267, 39256, 39244, 39233,
    39222, 39210, 39199, 39187, 39176, 39164, 39153, 39141, 39130, 39119, 39107, 39096, 39084, 39073, 39062, 39050,
    39039, 39028, 39016, 39005, 38994, 38982, 38971, 38960, 38948, 38937, 38926, 38914, 38903, 38892, 38881, 38869,
    38858, 38847, 38836, 38824, 38813, 38802, 38791, 38780, 38768, 38757, 38746, 38735, 38724, 38712, 38701, 38690,
    38679, 38668, 38657, 38646, 38634, 38623, 38612, 38601, 38590, 38579, 38568, 38557, 38546, 38535, 38524, 38512,
    38501, 38490, 38479, 38468, 38457, 38446, 38435, 38424, 38413, 38402, 38391, 38380, 38369, 38358, 38347, 38336,
    38326, 38315, 38304, 38293, 38282, 38271, 38260, 38249, 38238, 38227, 38216, 38206, 38195, 38184, 38173, 38162,
    38151, 38140, 38130, 38119, 38108, 38097, 38086, 38075, 38065, 38054, 38043, 38032, 38022, 38011, 38000, 37989,
    37978, 37968, 37957, 37946, 37936, 37925, 37914, 37903, 37893, 37882, 37871, 37861, 37850, 37839, 37829, 37818,
    37807, 37797, 37786, 37775, 37765, 37754, 37744, 37733, 37722, 37712, 37701, 37691, 37680, 37669, 37659, 37648,
    37638, 37627, 37617, 37606, 37596, 37585, 37574, 37564, 37553, 37543, 37532, 37522, 37511, 37501, 37490, 37480,
    37470, 37459, 37449, 37438, 37428, 37417, 37407, 37396, 37386, 37376, 37365, 37355, 37344, 37334, 37324, 37313,
    37303, 37293, 37282, 37272, 37262, 37251, 37241, 37230, 37220, 37210, 37200, 37189, 37179, 37169, 37158, 37148,
    37138, 37128, 37117, 37107, 37097, 37086, 37076, 37066, 37056, 37046, 37035, 37025, 37015, 37005, 36994, 36984,
    36974, 36964, 36954, 36944, 36933, 36923, 36913, 36903, 36893, 36883, 36873, 36862, 36852, 36842, 36832, 36822,
    36812, 36802, 36792, 36782, 36771, 36761, 36751, 36741, 36731, 36721, 36711, 36701, 36691, 36681, 36671, 36661,
    36651, 36641, 36631, 36621, 36611, 36601, 36591, 36581, 36571, 36561, 36551, 36541, 36531, 36521, 36511, 36501,
    36492, 36482, 36472, 36462, 36452, 36442, 36432, 36422, 36412, 36402, 36393, 36383, 36373, 36363, 36353, 36343,
    36333, 36324, 36314, 36304, 36294, 36284, 36275, 36265, 36255, 36245, 36235, 36226, 36216, 36206, 36196, 36187,
    36177, 36167, 36157, 36148, 36138, 36128, 36118, 36109, 36099, 36089, 36080, 36070, 36060, 36050, 36041, 36031,
    36021, 36012, 36002, 35992, 35983, 35973, 35964, 35954, 35944, 35935, 35925, 35915, 35906, 35896, 35887, 35877,
    35867, 35858, 35848, 35839, 35829, 35820, 35810, 35800, 35791, 35781, 35772, 35762, 35753, 35743, 35734, 35724,
    35715, 35705, 35696, 35686, 35677, 35667, 35658, 35648, 35639, 35629, 35620, 35610, 35601, 35592, 35582, 35573,
    35563, 35554, 35544, 35535, 35526, 35516, 35507, 35497, 35488, 35479, 35469, 35460, 35451, 35441, 35432, 35422,
    35413, 35404, 35394, 35385, 35376, 35366, 35357, 35348, 35339, 35329, 35320, 35311, 35301, 35292, 35283, 35274,
    35264, 35255, 35246, 35237, 35227, 35218, 35209, 35200, 35190, 35181, 35172, 35163, 35153, 35144, 35135, 35126,
    35117, 35107, 35098, 35089, 35080, 35071, 35062, 35052, 35043, 35034, 35025, 35016, 35007, 34998, 34988, 34979,
    34970, 34961, 34952, 34943, 34934, 34925, 34916, 34907, 34898, 34888, 34879, 34870, 34861, 34852, 34843, 34834,
    34825, 34816, 34807, 34798, 34789, 34780, 34771, 34762, 34753, 34744, 34735, 34726, 34717, 34708, 34699, 34690,
    34681, 34672, 34663, 34654, 34645, 34636, 34627, 34618, 34610, 34601, 34592, 34583, 34574, 34565, 34556, 34547,
    34538, 34529, 34521, 34512, 34503, 34494, 34485, 34476, 34467, 34458, 34450, 34441, 34432, 34423, 34414, 34405,
    34397, 34388, 34379, 34370, 34361, 34353, 34344, 34335, 34326, 34318, 34309, 34300, 34291, 34282, 34274, 34265,
    34256, 34247, 34239, 34230, 34221, 34213, 34204, 34195, 34186, 34178, 34169, 34160, 34152, 34143, 34134, 34126,
    34117, 34108, 34100, 34091, 34082, 34074, 34065, 34056, 34048, 34039, 34030, 34022, 34013, 34005, 33996, 33987,
    33979, 33970, 33961, 33953, 33944, 33936, 33927, 33919, 33910, 33901, 33893, 33884, 33876, 33867, 33859, 33850,
    33842, 33833, 33825, 33816, 33807, 33799, 33790, 33782, 33773, 33765, 33756, 33748, 33740, 33731, 33723, 33714,
    33706, 33697, 33689, 33680, 33672, 33663, 33655, 33646, 33638, 33630, 33621, 33613, 33604, 33596, 33588, 33579,
    33571, 33562, 33554, 33546, 33537, 33529, 33520, 33512, 33504, 33495, 33487, 33479, 33470, 33462, 33454, 33445,
    33437, 33429, 33420, 33412, 33404, 33395, 33387, 33379, 33370, 33362, 33354, 33346, 33337, 33329, 33321, 33312,
    33304, 33296, 33288, 33279, 33271, 33263, 33255, 33246, 33238, 33230, 33222, 33213, 33205, 33197, 33189, 33181,
    33172, 33164, 33156, 33148, 33140, 33132, 33123, 33115, 33107, 33099, 33091, 33083, 33074, 33066, 33058, 33050,
    33042, 33034, 33026, 33017, 33009, 33001, 32993, 32985, 32977, 32969, 32961, 32953, 32944, 32936, 32928, 32920,
    32912, 32904, 32896, 32888, 32880, 32872, 32864, 32856, 32848, 32840, 32832, 32824, 32816, 32808, 32800, 32792,
    32784};

// Look up table for 1/x values where x will be in Q8.0 format
static unsigned short division_lut8[256] = {
    65535, 32768, 16384, 10922, 8192, 6553, 5461, 4681, 4096, 3640, 3276, 2978, 2730, 2520, 2340, 2184, 2048, 1927,
    1820,  1724,  1638,  1560,  1489, 1424, 1365, 1310, 1260, 1213, 1170, 1129, 1092, 1057, 1024, 992,  963,  936,
    910,   885,   862,   840,   819,  799,  780,  762,  744,  728,  712,  697,  682,  668,  655,  642,  630,  618,
    606,   595,   585,   574,   564,  555,  546,  537,  528,  520,  512,  504,  496,  489,  481,  474,  468,  461,
    455,   448,   442,   436,   431,  425,  420,  414,  409,  404,  399,  394,  390,  385,  381,  376,  372,  368,
    364,   360,   356,   352,   348,  344,  341,  337,  334,  330,  327,  324,  321,  318,  315,  312,  309,  306,
    303,   300,   297,   295,   292,  289,  287,  284,  282,  280,  277,  275,  273,  270,  268,  266,  264,  262,
    260,   258,   256,   254,   252,  250,  248,  246,  244,  242,  240,  239,  237,  235,  234,  232,  230,  229,
    227,   225,   224,   222,   221,  219,  218,  217,  215,  214,  212,  211,  210,  208,  207,  206,  204,  203,
    202,   201,   199,   198,   197,  196,  195,  193,  192,  191,  190,  189,  188,  187,  186,  185,  184,  183,
    182,   181,   180,   179,   178,  177,  176,  175,  174,  173,  172,  171,  170,  169,  168,  168,  167,  166,
    165,   164,   163,   163,   162,  161,  160,  159,  159,  158,  157,  156,  156,  155,  154,  153,  153,  152,
    151,   151,   150,   149,   148,  148,  147,  146,  146,  145,  144,  144,  143,  143,  142,  141,  141,  140,
    140,   139,   138,   138,   137,  137,  136,  135,  135,  134,  134,  133,  133,  132,  132,  131,  131,  130,
    130,   129,   129,   128};

/***  look up tables for atan2 ***/
// table to store the base indices
static int base_addr_lut[63] = {0,    512,  768,  896,  960,  1024, 1088, 1120, 1152, 1184, 1200, 1216, 1232,
                                1248, 1264, 1280, 1296, 1304, 1312, 1320, 1328, 1336, 1344, 1352, 1360, 1362,
                                1364, 1366, 1368, 1370, 1372, 1374, 1376, 1378, 1380, 1382, 1384, 1386, 1388,
                                1390, 1392, 1394, 1396, 1398, 1400, 1402, 1404, 1406, 1408, 1410, 1412, 1414,
                                1416, 1418, 1420, 1422, 1424, 1426, 1428, 1430, 1432, 1434, 1436};
// table to store the number of bits to be used as index for fractional index look up.
static int frac_bits_lut[63] = {9, 8, 7, 6, 6, 6, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3,
                                3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                                2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
// Fixed point representation of atan values. atan_lut_fp is Q4.12 format
static short atan_lut_fp[1440] = {
    0,    7,    15,   23,   31,   39,   47,   55,   63,   71,   79,   87,   95,   103,  111,  119,  127,  135,  143,
    151,  159,  167,  175,  183,  191,  199,  207,  215,  223,  231,  239,  247,  255,  263,  271,  279,  287,  295,
    303,  311,  319,  327,  335,  343,  351,  358,  366,  374,  382,  390,  398,  406,  414,  422,  430,  438,  446,
    454,  461,  469,  477,  485,  493,  501,  509,  517,  524,  532,  540,  548,  556,  564,  572,  579,  587,  595,
    603,  611,  619,  626,  634,  642,  650,  658,  665,  673,  681,  689,  697,  704,  712,  720,  728,  735,  743,
    751,  758,  766,  774,  782,  789,  797,  805,  812,  820,  828,  835,  843,  851,  858,  866,  874,  881,  889,
    897,  904,  912,  919,  927,  935,  942,  950,  957,  965,  973,  980,  988,  995,  1003, 1010, 1018, 1025, 1033,
    1040, 1048, 1055, 1063, 1070, 1078, 1085, 1093, 1100, 1107, 1115, 1122, 1130, 1137, 1144, 1152, 1159, 1167, 1174,
    1181, 1189, 1196, 1203, 1211, 1218, 1225, 1233, 1240, 1247, 1254, 1262, 1269, 1276, 1283, 1291, 1298, 1305, 1312,
    1319, 1327, 1334, 1341, 1348, 1355, 1362, 1370, 1377, 1384, 1391, 1398, 1405, 1412, 1419, 1426, 1433, 1441, 1448,
    1455, 1462, 1469, 1476, 1483, 1490, 1497, 1504, 1511, 1518, 1524, 1531, 1538, 1545, 1552, 1559, 1566, 1573, 1580,
    1587, 1593, 1600, 1607, 1614, 1621, 1628, 1634, 1641, 1648, 1655, 1661, 1668, 1675, 1682, 1688, 1695, 1702, 1708,
    1715, 1722, 1728, 1735, 1742, 1748, 1755, 1762, 1768, 1775, 1781, 1788, 1794, 1801, 1808, 1814, 1821, 1827, 1834,
    1840, 1847, 1853, 1860, 1866, 1872, 1879, 1885, 1892, 1898, 1905, 1911, 1917, 1924, 1930, 1936, 1943, 1949, 1955,
    1962, 1968, 1974, 1980, 1987, 1993, 1999, 2005, 2012, 2018, 2024, 2030, 2036, 2043, 2049, 2055, 2061, 2067, 2073,
    2079, 2086, 2092, 2098, 2104, 2110, 2116, 2122, 2128, 2134, 2140, 2146, 2152, 2158, 2164, 2170, 2176, 2182, 2188,
    2194, 2200, 2205, 2211, 2217, 2223, 2229, 2235, 2241, 2246, 2252, 2258, 2264, 2270, 2275, 2281, 2287, 2293, 2298,
    2304, 2310, 2316, 2321, 2327, 2333, 2338, 2344, 2350, 2355, 2361, 2366, 2372, 2378, 2383, 2389, 2394, 2400, 2406,
    2411, 2417, 2422, 2428, 2433, 2439, 2444, 2450, 2455, 2460, 2466, 2471, 2477, 2482, 2488, 2493, 2498, 2504, 2509,
    2514, 2520, 2525, 2530, 2536, 2541, 2546, 2552, 2557, 2562, 2567, 2573, 2578, 2583, 2588, 2593, 2599, 2604, 2609,
    2614, 2619, 2624, 2630, 2635, 2640, 2645, 2650, 2655, 2660, 2665, 2670, 2675, 2680, 2685, 2690, 2695, 2700, 2705,
    2710, 2715, 2720, 2725, 2730, 2735, 2740, 2745, 2750, 2755, 2760, 2765, 2769, 2774, 2779, 2784, 2789, 2794, 2798,
    2803, 2808, 2813, 2818, 2822, 2827, 2832, 2837, 2841, 2846, 2851, 2855, 2860, 2865, 2869, 2874, 2879, 2883, 2888,
    2893, 2897, 2902, 2907, 2911, 2916, 2920, 2925, 2929, 2934, 2939, 2943, 2948, 2952, 2957, 2961, 2966, 2970, 2975,
    2979, 2984, 2988, 2992, 2997, 3001, 3006, 3010, 3014, 3019, 3023, 3028, 3032, 3036, 3041, 3045, 3049, 3054, 3058,
    3062, 3067, 3071, 3075, 3079, 3084, 3088, 3092, 3096, 3101, 3105, 3109, 3113, 3117, 3122, 3126, 3130, 3134, 3138,
    3142, 3147, 3151, 3155, 3159, 3163, 3167, 3171, 3175, 3179, 3183, 3188, 3192, 3196, 3200, 3204, 3208, 3212, 3216,
    3224, 3232, 3240, 3247, 3255, 3263, 3271, 3279, 3286, 3294, 3302, 3309, 3317, 3325, 3332, 3340, 3347, 3355, 3362,
    3370, 3377, 3384, 3392, 3399, 3406, 3413, 3421, 3428, 3435, 3442, 3449, 3456, 3463, 3470, 3477, 3484, 3491, 3498,
    3505, 3512, 3519, 3526, 3532, 3539, 3546, 3553, 3559, 3566, 3572, 3579, 3586, 3592, 3599, 3605, 3612, 3618, 3625,
    3631, 3637, 3644, 3650, 3656, 3663, 3669, 3675, 3681, 3687, 3694, 3700, 3706, 3712, 3718, 3724, 3730, 3736, 3742,
    3748, 3754, 3760, 3766, 3772, 3777, 3783, 3789, 3795, 3801, 3806, 3812, 3818, 3823, 3829, 3835, 3840, 3846, 3851,
    3857, 3863, 3868, 3873, 3879, 3884, 3890, 3895, 3901, 3906, 3911, 3917, 3922, 3927, 3932, 3938, 3943, 3948, 3953,
    3959, 3964, 3969, 3974, 3979, 3984, 3989, 3994, 3999, 4004, 4009, 4014, 4019, 4024, 4029, 4034, 4039, 4044, 4048,
    4053, 4058, 4063, 4068, 4072, 4077, 4082, 4087, 4091, 4096, 4101, 4105, 4110, 4114, 4119, 4124, 4128, 4133, 4137,
    4142, 4146, 4151, 4155, 4160, 4164, 4168, 4173, 4177, 4182, 4186, 4190, 4195, 4199, 4203, 4208, 4212, 4216, 4220,
    4225, 4229, 4233, 4237, 4241, 4245, 4250, 4254, 4258, 4262, 4266, 4270, 4274, 4278, 4282, 4286, 4290, 4294, 4298,
    4302, 4306, 4310, 4314, 4318, 4322, 4326, 4329, 4333, 4337, 4341, 4345, 4349, 4352, 4356, 4360, 4364, 4367, 4371,
    4375, 4378, 4382, 4386, 4390, 4393, 4397, 4400, 4404, 4408, 4411, 4415, 4418, 4422, 4426, 4429, 4433, 4436, 4440,
    4443, 4447, 4450, 4454, 4457, 4460, 4464, 4467, 4471, 4474, 4477, 4481, 4484, 4487, 4491, 4494, 4497, 4501, 4504,
    4507, 4511, 4514, 4517, 4520, 4524, 4527, 4530, 4533, 4540, 4546, 4552, 4559, 4565, 4571, 4577, 4583, 4589, 4595,
    4601, 4607, 4613, 4619, 4625, 4631, 4637, 4642, 4648, 4654, 4659, 4665, 4671, 4676, 4682, 4687, 4693, 4698, 4703,
    4709, 4714, 4719, 4725, 4730, 4735, 4740, 4745, 4750, 4755, 4761, 4766, 4771, 4776, 4780, 4785, 4790, 4795, 4800,
    4805, 4810, 4814, 4819, 4824, 4828, 4833, 4838, 4842, 4847, 4851, 4856, 4860, 4865, 4869, 4874, 4878, 4883, 4887,
    4891, 4896, 4900, 4904, 4908, 4913, 4917, 4921, 4925, 4929, 4933, 4937, 4941, 4945, 4949, 4953, 4957, 4961, 4965,
    4969, 4973, 4977, 4981, 4985, 4989, 4992, 4996, 5000, 5004, 5007, 5011, 5015, 5018, 5022, 5026, 5029, 5033, 5037,
    5040, 5044, 5047, 5051, 5054, 5058, 5061, 5065, 5068, 5071, 5075, 5078, 5082, 5085, 5088, 5092, 5095, 5098, 5101,
    5105, 5108, 5111, 5114, 5121, 5127, 5133, 5139, 5146, 5152, 5158, 5164, 5170, 5175, 5181, 5187, 5193, 5198, 5204,
    5210, 5215, 5221, 5226, 5231, 5237, 5242, 5247, 5252, 5257, 5263, 5268, 5273, 5278, 5283, 5287, 5292, 5297, 5302,
    5307, 5311, 5316, 5321, 5325, 5330, 5334, 5339, 5343, 5347, 5352, 5356, 5360, 5365, 5369, 5373, 5377, 5381, 5386,
    5390, 5394, 5398, 5402, 5406, 5410, 5413, 5417, 5421, 5425, 5429, 5432, 5436, 5440, 5444, 5447, 5451, 5454, 5458,
    5462, 5465, 5469, 5472, 5475, 5479, 5482, 5486, 5489, 5492, 5496, 5499, 5502, 5505, 5509, 5512, 5515, 5518, 5521,
    5524, 5527, 5530, 5533, 5536, 5539, 5542, 5545, 5548, 5551, 5554, 5557, 5560, 5563, 5566, 5568, 5571, 5574, 5577,
    5579, 5582, 5585, 5588, 5590, 5593, 5596, 5598, 5601, 5603, 5606, 5609, 5611, 5614, 5616, 5619, 5621, 5624, 5626,
    5628, 5631, 5633, 5636, 5638, 5640, 5643, 5645, 5647, 5650, 5652, 5654, 5657, 5659, 5661, 5663, 5666, 5668, 5670,
    5672, 5674, 5677, 5679, 5681, 5683, 5685, 5687, 5689, 5691, 5693, 5695, 5697, 5699, 5702, 5704, 5706, 5707, 5709,
    5711, 5713, 5715, 5717, 5719, 5721, 5723, 5725, 5727, 5729, 5731, 5732, 5734, 5736, 5738, 5740, 5742, 5743, 5745,
    5747, 5749, 5750, 5752, 5754, 5756, 5759, 5762, 5766, 5769, 5772, 5776, 5779, 5782, 5785, 5789, 5792, 5795, 5798,
    5801, 5804, 5807, 5810, 5813, 5816, 5818, 5821, 5824, 5827, 5830, 5832, 5835, 5838, 5840, 5843, 5846, 5848, 5851,
    5853, 5856, 5858, 5861, 5863, 5866, 5868, 5871, 5873, 5875, 5878, 5880, 5882, 5885, 5887, 5889, 5891, 5894, 5896,
    5898, 5900, 5902, 5904, 5906, 5909, 5911, 5913, 5915, 5917, 5919, 5921, 5923, 5925, 5927, 5929, 5930, 5932, 5934,
    5936, 5938, 5940, 5942, 5943, 5945, 5947, 5949, 5951, 5952, 5954, 5956, 5958, 5959, 5961, 5963, 5964, 5966, 5968,
    5969, 5971, 5972, 5974, 5976, 5977, 5979, 5982, 5985, 5988, 5991, 5994, 5997, 6000, 6002, 6005, 6008, 6011, 6013,
    6016, 6019, 6021, 6024, 6026, 6029, 6031, 6034, 6036, 6038, 6041, 6043, 6045, 6048, 6050, 6052, 6054, 6056, 6059,
    6061, 6063, 6065, 6067, 6069, 6071, 6073, 6075, 6077, 6079, 6081, 6082, 6084, 6086, 6088, 6090, 6091, 6093, 6095,
    6097, 6098, 6100, 6102, 6103, 6105, 6107, 6108, 6110, 6111, 6113, 6114, 6116, 6118, 6119, 6121, 6122, 6123, 6125,
    6126, 6128, 6129, 6131, 6132, 6133, 6135, 6136, 6137, 6139, 6140, 6141, 6142, 6144, 6145, 6146, 6147, 6149, 6150,
    6151, 6152, 6154, 6155, 6156, 6157, 6158, 6159, 6160, 6162, 6163, 6164, 6165, 6166, 6167, 6168, 6169, 6170, 6171,
    6172, 6173, 6174, 6175, 6176, 6178, 6180, 6182, 6184, 6186, 6188, 6190, 6191, 6193, 6195, 6196, 6198, 6200, 6201,
    6203, 6205, 6206, 6208, 6209, 6211, 6212, 6214, 6215, 6217, 6218, 6219, 6221, 6222, 6223, 6225, 6226, 6227, 6229,
    6230, 6231, 6232, 6234, 6235, 6236, 6237, 6238, 6239, 6240, 6242, 6243, 6244, 6245, 6246, 6247, 6248, 6249, 6250,
    6251, 6252, 6253, 6254, 6255, 6256, 6257, 6258, 6259, 6260, 6260, 6261, 6265, 6268, 6271, 6274, 6277, 6280, 6283,
    6286, 6288, 6291, 6293, 6295, 6298, 6300, 6302, 6304, 6306, 6308, 6310, 6312, 6313, 6315, 6317, 6318, 6320, 6321,
    6323, 6324, 6326, 6327, 6328, 6330, 6331, 6332, 6333, 6334, 6336, 6337, 6338, 6339, 6340, 6341, 6342, 6343, 6344,
    6345, 6346, 6347, 6347, 6348, 6349, 6350, 6351, 6352, 6352, 6353, 6354, 6355, 6355, 6356, 6357, 6357, 6358, 6359,
    6359, 6360, 6361, 6361, 6362, 6363, 6363, 6364, 6364, 6365, 6365, 6366, 6366, 6367, 6367};

/* Reduced atan2 look up tables */
static int base_addr_lut8[126] = {
    0,   512, 640, 704, 736, 768, 800, 816, 832, 848, 856, 864, 872, 880, 888, 896, 904, 908, 912, 916, 920,
    924, 928, 932, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953,
    954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974,
    9,   7,   6,   5,   5,   5,   4,   4,   4,   3,   3,   3,   3,   3,   3,   3,   2,   2,   2,   2,   2,
    2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1};
static short atan_lut_fp8[977] = {
    0,    7,    15,   23,   31,   39,   47,   55,   63,   71,   79,   87,   95,   103,  111,  119,  127,  135,  143,
    151,  159,  167,  175,  183,  191,  199,  207,  215,  223,  231,  239,  247,  255,  263,  271,  279,  287,  295,
    303,  311,  319,  327,  335,  343,  351,  358,  366,  374,  382,  390,  398,  406,  414,  422,  430,  438,  446,
    454,  461,  469,  477,  485,  493,  501,  509,  517,  524,  532,  540,  548,  556,  564,  572,  579,  587,  595,
    603,  611,  619,  626,  634,  642,  650,  658,  665,  673,  681,  689,  697,  704,  712,  720,  728,  735,  743,
    751,  758,  766,  774,  782,  789,  797,  805,  812,  820,  828,  835,  843,  851,  858,  866,  874,  881,  889,
    897,  904,  912,  919,  927,  935,  942,  950,  957,  965,  973,  980,  988,  995,  1003, 1010, 1018, 1025, 1033,
    1040, 1048, 1055, 1063, 1070, 1078, 1085, 1093, 1100, 1107, 1115, 1122, 1130, 1137, 1144, 1152, 1159, 1167, 1174,
    1181, 1189, 1196, 1203, 1211, 1218, 1225, 1233, 1240, 1247, 1254, 1262, 1269, 1276, 1283, 1291, 1298, 1305, 1312,
    1319, 1327, 1334, 1341, 1348, 1355, 1362, 1370, 1377, 1384, 1391, 1398, 1405, 1412, 1419, 1426, 1433, 1441, 1448,
    1455, 1462, 1469, 1476, 1483, 1490, 1497, 1504, 1511, 1518, 1524, 1531, 1538, 1545, 1552, 1559, 1566, 1573, 1580,
    1587, 1593, 1600, 1607, 1614, 1621, 1628, 1634, 1641, 1648, 1655, 1661, 1668, 1675, 1682, 1688, 1695, 1702, 1708,
    1715, 1722, 1728, 1735, 1742, 1748, 1755, 1762, 1768, 1775, 1781, 1788, 1794, 1801, 1808, 1814, 1821, 1827, 1834,
    1840, 1847, 1853, 1860, 1866, 1872, 1879, 1885, 1892, 1898, 1905, 1911, 1917, 1924, 1930, 1936, 1943, 1949, 1955,
    1962, 1968, 1974, 1980, 1987, 1993, 1999, 2005, 2012, 2018, 2024, 2030, 2036, 2043, 2049, 2055, 2061, 2067, 2073,
    2079, 2086, 2092, 2098, 2104, 2110, 2116, 2122, 2128, 2134, 2140, 2146, 2152, 2158, 2164, 2170, 2176, 2182, 2188,
    2194, 2200, 2205, 2211, 2217, 2223, 2229, 2235, 2241, 2246, 2252, 2258, 2264, 2270, 2275, 2281, 2287, 2293, 2298,
    2304, 2310, 2316, 2321, 2327, 2333, 2338, 2344, 2350, 2355, 2361, 2366, 2372, 2378, 2383, 2389, 2394, 2400, 2406,
    2411, 2417, 2422, 2428, 2433, 2439, 2444, 2450, 2455, 2460, 2466, 2471, 2477, 2482, 2488, 2493, 2498, 2504, 2509,
    2514, 2520, 2525, 2530, 2536, 2541, 2546, 2552, 2557, 2562, 2567, 2573, 2578, 2583, 2588, 2593, 2599, 2604, 2609,
    2614, 2619, 2624, 2630, 2635, 2640, 2645, 2650, 2655, 2660, 2665, 2670, 2675, 2680, 2685, 2690, 2695, 2700, 2705,
    2710, 2715, 2720, 2725, 2730, 2735, 2740, 2745, 2750, 2755, 2760, 2765, 2769, 2774, 2779, 2784, 2789, 2794, 2798,
    2803, 2808, 2813, 2818, 2822, 2827, 2832, 2837, 2841, 2846, 2851, 2855, 2860, 2865, 2869, 2874, 2879, 2883, 2888,
    2893, 2897, 2902, 2907, 2911, 2916, 2920, 2925, 2929, 2934, 2939, 2943, 2948, 2952, 2957, 2961, 2966, 2970, 2975,
    2979, 2984, 2988, 2992, 2997, 3001, 3006, 3010, 3014, 3019, 3023, 3028, 3032, 3036, 3041, 3045, 3049, 3054, 3058,
    3062, 3067, 3071, 3075, 3079, 3084, 3088, 3092, 3096, 3101, 3105, 3109, 3113, 3117, 3122, 3126, 3130, 3134, 3138,
    3142, 3147, 3151, 3155, 3159, 3163, 3167, 3171, 3175, 3179, 3183, 3188, 3192, 3196, 3200, 3204, 3208, 3212, 3216,
    3232, 3247, 3263, 3279, 3294, 3309, 3325, 3340, 3355, 3370, 3384, 3399, 3413, 3428, 3442, 3456, 3470, 3484, 3498,
    3512, 3526, 3539, 3553, 3566, 3579, 3592, 3605, 3618, 3631, 3644, 3656, 3669, 3681, 3694, 3706, 3718, 3730, 3742,
    3754, 3766, 3777, 3789, 3801, 3812, 3823, 3835, 3846, 3857, 3868, 3879, 3890, 3901, 3911, 3922, 3932, 3943, 3953,
    3964, 3974, 3984, 3994, 4004, 4014, 4024, 4034, 4044, 4053, 4063, 4072, 4082, 4091, 4101, 4110, 4119, 4128, 4137,
    4146, 4155, 4164, 4173, 4182, 4190, 4199, 4208, 4216, 4225, 4233, 4241, 4250, 4258, 4266, 4274, 4282, 4290, 4298,
    4306, 4314, 4322, 4329, 4337, 4345, 4352, 4360, 4367, 4375, 4382, 4390, 4397, 4404, 4411, 4418, 4426, 4433, 4440,
    4447, 4454, 4460, 4467, 4474, 4481, 4487, 4494, 4501, 4507, 4514, 4520, 4527, 4533, 4546, 4559, 4571, 4583, 4595,
    4607, 4619, 4631, 4642, 4654, 4665, 4676, 4687, 4698, 4709, 4719, 4730, 4740, 4750, 4761, 4771, 4780, 4790, 4800,
    4810, 4819, 4828, 4838, 4847, 4856, 4865, 4874, 4883, 4891, 4900, 4908, 4917, 4925, 4933, 4941, 4949, 4957, 4965,
    4973, 4981, 4989, 4996, 5004, 5011, 5018, 5026, 5033, 5040, 5047, 5054, 5061, 5068, 5075, 5082, 5088, 5095, 5101,
    5108, 5114, 5127, 5139, 5152, 5164, 5175, 5187, 5198, 5210, 5221, 5231, 5242, 5252, 5263, 5273, 5283, 5292, 5302,
    5311, 5321, 5330, 5339, 5347, 5356, 5365, 5373, 5381, 5390, 5398, 5406, 5413, 5421, 5429, 5436, 5444, 5451, 5458,
    5465, 5472, 5479, 5486, 5492, 5499, 5505, 5512, 5518, 5524, 5530, 5536, 5542, 5548, 5554, 5560, 5566, 5571, 5577,
    5582, 5588, 5593, 5598, 5603, 5609, 5614, 5619, 5624, 5628, 5633, 5638, 5643, 5647, 5652, 5657, 5661, 5666, 5670,
    5674, 5679, 5683, 5687, 5691, 5695, 5699, 5704, 5707, 5711, 5715, 5719, 5723, 5727, 5731, 5734, 5738, 5742, 5745,
    5749, 5752, 5756, 5762, 5769, 5776, 5782, 5789, 5795, 5801, 5807, 5813, 5818, 5824, 5830, 5835, 5840, 5846, 5851,
    5856, 5861, 5866, 5871, 5875, 5880, 5885, 5889, 5894, 5898, 5902, 5906, 5911, 5915, 5919, 5923, 5927, 5930, 5934,
    5938, 5942, 5945, 5949, 5952, 5956, 5959, 5963, 5966, 5969, 5972, 5976, 5979, 5985, 5991, 5997, 6002, 6008, 6013,
    6019, 6024, 6029, 6034, 6038, 6043, 6048, 6052, 6056, 6061, 6065, 6069, 6073, 6077, 6081, 6084, 6088, 6091, 6095,
    6098, 6102, 6105, 6108, 6111, 6114, 6118, 6121, 6123, 6126, 6129, 6132, 6135, 6137, 6140, 6142, 6145, 6147, 6150,
    6152, 6155, 6157, 6159, 6162, 6164, 6166, 6168, 6170, 6172, 6174, 6176, 6180, 6184, 6188, 6191, 6195, 6198, 6201,
    6205, 6208, 6211, 6214, 6217, 6219, 6222, 6225, 6227, 6230, 6232, 6235, 6237, 6239, 6242, 6244, 6246, 6248, 6250,
    6252, 6254, 6256, 6258, 6260, 6261, 6268, 6274, 6280, 6286, 6291, 6295, 6300, 6304, 6308, 6312, 6315, 6318, 6321,
    6324, 6327, 6330, 6332, 6334, 6337, 6339, 6341, 6343, 6345, 6347, 6348, 6350, 6352, 6353, 6355, 6356, 6357, 6359,
    6360, 6361, 6363, 6364, 6365, 6366, 6367, 6367};

static unsigned short sin_fix_lut[1572] = {
    0,     32,    65,    98,    131,   163,   196,   229,   262,   294,   327,   360,   393,   425,   458,   491,
    524,   557,   589,   622,   655,   688,   720,   753,   786,   819,   851,   884,   917,   950,   982,   1015,
    1048,  1081,  1113,  1146,  1179,  1212,  1244,  1277,  1310,  1343,  1375,  1408,  1441,  1474,  1506,  1539,
    1572,  1604,  1637,  1670,  1703,  1735,  1768,  1801,  1834,  1866,  1899,  1932,  1964,  1997,  2030,  2063,
    2095,  2128,  2161,  2193,  2226,  2259,  2291,  2324,  2357,  2389,  2422,  2455,  2487,  2520,  2553,  2585,
    2618,  2651,  2683,  2716,  2749,  2781,  2814,  2847,  2879,  2912,  2945,  2977,  3010,  3043,  3075,  3108,
    3140,  3173,  3206,  3238,  3271,  3303,  3336,  3369,  3401,  3434,  3466,  3499,  3532,  3564,  3597,  3629,
    3662,  3694,  3727,  3760,  3792,  3825,  3857,  3890,  3922,  3955,  3987,  4020,  4052,  4085,  4117,  4150,
    4182,  4215,  4247,  4280,  4312,  4345,  4377,  4410,  4442,  4475,  4507,  4540,  4572,  4604,  4637,  4669,
    4702,  4734,  4767,  4799,  4831,  4864,  4896,  4929,  4961,  4993,  5026,  5058,  5091,  5123,  5155,  5188,
    5220,  5252,  5285,  5317,  5349,  5382,  5414,  5446,  5479,  5511,  5543,  5576,  5608,  5640,  5672,  5705,
    5737,  5769,  5801,  5834,  5866,  5898,  5930,  5963,  5995,  6027,  6059,  6091,  6124,  6156,  6188,  6220,
    6252,  6285,  6317,  6349,  6381,  6413,  6445,  6477,  6510,  6542,  6574,  6606,  6638,  6670,  6702,  6734,
    6766,  6798,  6830,  6862,  6894,  6926,  6958,  6990,  7022,  7054,  7086,  7118,  7150,  7182,  7214,  7246,
    7278,  7310,  7342,  7374,  7406,  7438,  7470,  7502,  7534,  7566,  7597,  7629,  7661,  7693,  7725,  7757,
    7789,  7820,  7852,  7884,  7916,  7948,  7979,  8011,  8043,  8075,  8106,  8138,  8170,  8202,  8233,  8265,
    8297,  8328,  8360,  8392,  8424,  8455,  8487,  8518,  8550,  8582,  8613,  8645,  8677,  8708,  8740,  8771,
    8803,  8834,  8866,  8898,  8929,  8961,  8992,  9024,  9055,  9087,  9118,  9150,  9181,  9212,  9244,  9275,
    9307,  9338,  9370,  9401,  9432,  9464,  9495,  9526,  9558,  9589,  9620,  9652,  9683,  9714,  9746,  9777,
    9808,  9839,  9871,  9902,  9933,  9964,  9996,  10027, 10058, 10089, 10120, 10152, 10183, 10214, 10245, 10276,
    10307, 10338, 10369, 10400, 10432, 10463, 10494, 10525, 10556, 10587, 10618, 10649, 10680, 10711, 10742, 10773,
    10804, 10834, 10865, 10896, 10927, 10958, 10989, 11020, 11051, 11082, 11112, 11143, 11174, 11205, 11236, 11266,
    11297, 11328, 11359, 11389, 11420, 11451, 11481, 11512, 11543, 11573, 11604, 11635, 11665, 11696, 11727, 11757,
    11788, 11818, 11849, 11879, 11910, 11940, 11971, 12001, 12032, 12062, 12093, 12123, 12154, 12184, 12215, 12245,
    12275, 12306, 12336, 12366, 12397, 12427, 12457, 12488, 12518, 12548, 12579, 12609, 12639, 12669, 12700, 12730,
    12760, 12790, 12820, 12850, 12881, 12911, 12941, 12971, 13001, 13031, 13061, 13091, 13121, 13151, 13181, 13211,
    13241, 13271, 13301, 13331, 13361, 13391, 13421, 13451, 13481, 13510, 13540, 13570, 13600, 13630, 13659, 13689,
    13719, 13749, 13778, 13808, 13838, 13868, 13897, 13927, 13957, 13986, 14016, 14045, 14075, 14105, 14134, 14164,
    14193, 14223, 14252, 14282, 14311, 14341, 14370, 14400, 14429, 14459, 14488, 14517, 14547, 14576, 14605, 14635,
    14664, 14693, 14723, 14752, 14781, 14810, 14840, 14869, 14898, 14927, 14956, 14985, 15015, 15044, 15073, 15102,
    15131, 15160, 15189, 15218, 15247, 15276, 15305, 15334, 15363, 15392, 15421, 15450, 15479, 15508, 15536, 15565,
    15594, 15623, 15652, 15680, 15709, 15738, 15767, 15795, 15824, 15853, 15881, 15910, 15939, 15967, 15996, 16025,
    16053, 16082, 16110, 16139, 16167, 16196, 16224, 16253, 16281, 16310, 16338, 16366, 16395, 16423, 16452, 16480,
    16508, 16536, 16565, 16593, 16621, 16649, 16678, 16706, 16734, 16762, 16790, 16819, 16847, 16875, 16903, 16931,
    16959, 16987, 17015, 17043, 17071, 17099, 17127, 17155, 17183, 17211, 17238, 17266, 17294, 17322, 17350, 17378,
    17405, 17433, 17461, 17489, 17516, 17544, 17572, 17599, 17627, 17654, 17682, 17710, 17737, 17765, 17792, 17820,
    17847, 17875, 17902, 17930, 17957, 17984, 18012, 18039, 18067, 18094, 18121, 18148, 18176, 18203, 18230, 18257,
    18285, 18312, 18339, 18366, 18393, 18420, 18447, 18475, 18502, 18529, 18556, 18583, 18610, 18637, 18664, 18690,
    18717, 18744, 18771, 18798, 18825, 18852, 18878, 18905, 18932, 18959, 18985, 19012, 19039, 19065, 19092, 19119,
    19145, 19172, 19198, 19225, 19251, 19278, 19304, 19331, 19357, 19384, 19410, 19437, 19463, 19489, 19516, 19542,
    19568, 19595, 19621, 19647, 19673, 19699, 19726, 19752, 19778, 19804, 19830, 19856, 19882, 19908, 19934, 19960,
    19986, 20012, 20038, 20064, 20090, 20116, 20142, 20168, 20193, 20219, 20245, 20271, 20296, 20322, 20348, 20374,
    20399, 20425, 20450, 20476, 20502, 20527, 20553, 20578, 20604, 20629, 20655, 20680, 20705, 20731, 20756, 20782,
    20807, 20832, 20857, 20883, 20908, 20933, 20958, 20984, 21009, 21034, 21059, 21084, 21109, 21134, 21159, 21184,
    21209, 21234, 21259, 21284, 21309, 21334, 21359, 21383, 21408, 21433, 21458, 21483, 21507, 21532, 21557, 21581,
    21606, 21631, 21655, 21680, 21704, 21729, 21753, 21778, 21802, 21827, 21851, 21876, 21900, 21924, 21949, 21973,
    21997, 22022, 22046, 22070, 22094, 22119, 22143, 22167, 22191, 22215, 22239, 22263, 22287, 22311, 22335, 22359,
    22383, 22407, 22431, 22455, 22479, 22503, 22526, 22550, 22574, 22598, 22621, 22645, 22669, 22692, 22716, 22740,
    22763, 22787, 22810, 22834, 22857, 22881, 22904, 22928, 22951, 22974, 22998, 23021, 23044, 23068, 23091, 23114,
    23137, 23161, 23184, 23207, 23230, 23253, 23276, 23299, 23322, 23345, 23368, 23391, 23414, 23437, 23460, 23483,
    23506, 23528, 23551, 23574, 23597, 23620, 23642, 23665, 23688, 23710, 23733, 23755, 23778, 23800, 23823, 23845,
    23868, 23890, 23913, 23935, 23958, 23980, 24002, 24024, 24047, 24069, 24091, 24113, 24136, 24158, 24180, 24202,
    24224, 24246, 24268, 24290, 24312, 24334, 24356, 24378, 24400, 24422, 24444, 24465, 24487, 24509, 24531, 24552,
    24574, 24596, 24617, 24639, 24661, 24682, 24704, 24725, 24747, 24768, 24790, 24811, 24832, 24854, 24875, 24896,
    24918, 24939, 24960, 24981, 25003, 25024, 25045, 25066, 25087, 25108, 25129, 25150, 25171, 25192, 25213, 25234,
    25255, 25276, 25297, 25317, 25338, 25359, 25380, 25400, 25421, 25442, 25462, 25483, 25504, 25524, 25545, 25565,
    25586, 25606, 25627, 25647, 25667, 25688, 25708, 25728, 25749, 25769, 25789, 25809, 25830, 25850, 25870, 25890,
    25910, 25930, 25950, 25970, 25990, 26010, 26030, 26050, 26070, 26089, 26109, 26129, 26149, 26169, 26188, 26208,
    26228, 26247, 26267, 26286, 26306, 26325, 26345, 26364, 26384, 26403, 26423, 26442, 26461, 26481, 26500, 26519,
    26538, 26558, 26577, 26596, 26615, 26634, 26653, 26672, 26691, 26710, 26729, 26748, 26767, 26786, 26805, 26824,
    26843, 26861, 26880, 26899, 26918, 26936, 26955, 26973, 26992, 27011, 27029, 27048, 27066, 27085, 27103, 27121,
    27140, 27158, 27177, 27195, 27213, 27231, 27250, 27268, 27286, 27304, 27322, 27340, 27358, 27376, 27394, 27412,
    27430, 27448, 27466, 27484, 27502, 27519, 27537, 27555, 27573, 27590, 27608, 27626, 27643, 27661, 27678, 27696,
    27713, 27731, 27748, 27766, 27783, 27800, 27818, 27835, 27852, 27870, 27887, 27904, 27921, 27938, 27955, 27973,
    27990, 28007, 28024, 28041, 28058, 28074, 28091, 28108, 28125, 28142, 28159, 28175, 28192, 28209, 28225, 28242,
    28259, 28275, 28292, 28308, 28325, 28341, 28358, 28374, 28390, 28407, 28423, 28439, 28456, 28472, 28488, 28504,
    28520, 28537, 28553, 28569, 28585, 28601, 28617, 28633, 28649, 28664, 28680, 28696, 28712, 28728, 28744, 28759,
    28775, 28791, 28806, 28822, 28837, 28853, 28868, 28884, 28899, 28915, 28930, 28946, 28961, 28976, 28992, 29007,
    29022, 29037, 29052, 29068, 29083, 29098, 29113, 29128, 29143, 29158, 29173, 29188, 29203, 29217, 29232, 29247,
    29262, 29276, 29291, 29306, 29320, 29335, 29350, 29364, 29379, 29393, 29408, 29422, 29437, 29451, 29465, 29480,
    29494, 29508, 29522, 29537, 29551, 29565, 29579, 29593, 29607, 29621, 29635, 29649, 29663, 29677, 29691, 29705,
    29719, 29732, 29746, 29760, 29774, 29787, 29801, 29814, 29828, 29842, 29855, 29869, 29882, 29896, 29909, 29922,
    29936, 29949, 29962, 29975, 29989, 30002, 30015, 30028, 30041, 30054, 30067, 30080, 30093, 30106, 30119, 30132,
    30145, 30158, 30171, 30183, 30196, 30209, 30222, 30234, 30247, 30259, 30272, 30284, 30297, 30309, 30322, 30334,
    30347, 30359, 30371, 30384, 30396, 30408, 30420, 30432, 30445, 30457, 30469, 30481, 30493, 30505, 30517, 30529,
    30541, 30552, 30564, 30576, 30588, 30600, 30611, 30623, 30635, 30646, 30658, 30669, 30681, 30692, 30704, 30715,
    30727, 30738, 30749, 30761, 30772, 30783, 30794, 30806, 30817, 30828, 30839, 30850, 30861, 30872, 30883, 30894,
    30905, 30916, 30927, 30937, 30948, 30959, 30970, 30980, 30991, 31002, 31012, 31023, 31033, 31044, 31054, 31065,
    31075, 31086, 31096, 31106, 31116, 31127, 31137, 31147, 31157, 31167, 31178, 31188, 31198, 31208, 31218, 31228,
    31237, 31247, 31257, 31267, 31277, 31287, 31296, 31306, 31316, 31325, 31335, 31344, 31354, 31363, 31373, 31382,
    31392, 31401, 31411, 31420, 31429, 31438, 31448, 31457, 31466, 31475, 31484, 31493, 31502, 31511, 31520, 31529,
    31538, 31547, 31556, 31565, 31573, 31582, 31591, 31600, 31608, 31617, 31625, 31634, 31643, 31651, 31659, 31668,
    31676, 31685, 31693, 31701, 31710, 31718, 31726, 31734, 31742, 31751, 31759, 31767, 31775, 31783, 31791, 31799,
    31806, 31814, 31822, 31830, 31838, 31845, 31853, 31861, 31868, 31876, 31884, 31891, 31899, 31906, 31914, 31921,
    31928, 31936, 31943, 31950, 31958, 31965, 31972, 31979, 31986, 31993, 32001, 32008, 32015, 32022, 32028, 32035,
    32042, 32049, 32056, 32063, 32069, 32076, 32083, 32089, 32096, 32103, 32109, 32116, 32122, 32129, 32135, 32141,
    32148, 32154, 32160, 32167, 32173, 32179, 32185, 32191, 32198, 32204, 32210, 32216, 32222, 32228, 32233, 32239,
    32245, 32251, 32257, 32263, 32268, 32274, 32280, 32285, 32291, 32296, 32302, 32307, 32313, 32318, 32324, 32329,
    32334, 32340, 32345, 32350, 32355, 32360, 32366, 32371, 32376, 32381, 32386, 32391, 32396, 32401, 32405, 32410,
    32415, 32420, 32425, 32429, 32434, 32439, 32443, 32448, 32452, 32457, 32461, 32466, 32470, 32475, 32479, 32483,
    32488, 32492, 32496, 32500, 32504, 32509, 32513, 32517, 32521, 32525, 32529, 32533, 32537, 32540, 32544, 32548,
    32552, 32556, 32559, 32563, 32567, 32570, 32574, 32577, 32581, 32584, 32588, 32591, 32595, 32598, 32601, 32605,
    32608, 32611, 32614, 32617, 32620, 32624, 32627, 32630, 32633, 32636, 32638, 32641, 32644, 32647, 32650, 32653,
    32655, 32658, 32661, 32663, 32666, 32668, 32671, 32673, 32676, 32678, 32681, 32683, 32685, 32688, 32690, 32692,
    32694, 32697, 32699, 32701, 32703, 32705, 32707, 32709, 32711, 32713, 32715, 32717, 32718, 32720, 32722, 32724,
    32725, 32727, 32729, 32730, 32732, 32733, 32735, 32736, 32738, 32739, 32740, 32742, 32743, 32744, 32745, 32747,
    32748, 32749, 32750, 32751, 32752, 32753, 32754, 32755, 32756, 32757, 32757, 32758, 32759, 32760, 32760, 32761,
    32762, 32762, 32763, 32763, 32764, 32764, 32765, 32765, 32766, 32766, 32766, 32767, 32767, 32767, 32767, 32767,
    32767, 32767, 32767, 32768};

static unsigned short cos_fix_lut[1572] = {
    32768, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32766, 32766, 32766, 32766, 32765, 32765, 32764, 32764,
    32763, 32763, 32762, 32762, 32761, 32760, 32760, 32759, 32758, 32757, 32756, 32756, 32755, 32754, 32753, 32752,
    32751, 32750, 32749, 32747, 32746, 32745, 32744, 32743, 32741, 32740, 32739, 32737, 32736, 32734, 32733, 32731,
    32730, 32728, 32727, 32725, 32723, 32721, 32720, 32718, 32716, 32714, 32712, 32710, 32709, 32707, 32705, 32702,
    32700, 32698, 32696, 32694, 32692, 32690, 32687, 32685, 32683, 32680, 32678, 32675, 32673, 32670, 32668, 32665,
    32663, 32660, 32657, 32655, 32652, 32649, 32646, 32644, 32641, 32638, 32635, 32632, 32629, 32626, 32623, 32620,
    32617, 32613, 32610, 32607, 32604, 32601, 32597, 32594, 32590, 32587, 32584, 32580, 32577, 32573, 32569, 32566,
    32562, 32559, 32555, 32551, 32547, 32543, 32540, 32536, 32532, 32528, 32524, 32520, 32516, 32512, 32508, 32504,
    32499, 32495, 32491, 32487, 32482, 32478, 32474, 32469, 32465, 32460, 32456, 32451, 32447, 32442, 32438, 32433,
    32428, 32424, 32419, 32414, 32409, 32404, 32400, 32395, 32390, 32385, 32380, 32375, 32370, 32364, 32359, 32354,
    32349, 32344, 32338, 32333, 32328, 32322, 32317, 32312, 32306, 32301, 32295, 32290, 32284, 32278, 32273, 32267,
    32261, 32256, 32250, 32244, 32238, 32232, 32226, 32220, 32214, 32208, 32202, 32196, 32190, 32184, 32178, 32172,
    32165, 32159, 32153, 32146, 32140, 32134, 32127, 32121, 32114, 32108, 32101, 32095, 32088, 32081, 32075, 32068,
    32061, 32054, 32048, 32041, 32034, 32027, 32020, 32013, 32006, 31999, 31992, 31985, 31978, 31971, 31963, 31956,
    31949, 31942, 31934, 31927, 31919, 31912, 31905, 31897, 31890, 31882, 31874, 31867, 31859, 31852, 31844, 31836,
    31828, 31820, 31813, 31805, 31797, 31789, 31781, 31773, 31765, 31757, 31749, 31741, 31733, 31724, 31716, 31708,
    31700, 31691, 31683, 31675, 31666, 31658, 31649, 31641, 31632, 31624, 31615, 31606, 31598, 31589, 31580, 31572,
    31563, 31554, 31545, 31536, 31527, 31518, 31509, 31500, 31491, 31482, 31473, 31464, 31455, 31446, 31436, 31427,
    31418, 31409, 31399, 31390, 31380, 31371, 31362, 31352, 31342, 31333, 31323, 31314, 31304, 31294, 31285, 31275,
    31265, 31255, 31245, 31235, 31226, 31216, 31206, 31196, 31186, 31175, 31165, 31155, 31145, 31135, 31125, 31114,
    31104, 31094, 31083, 31073, 31063, 31052, 31042, 31031, 31021, 31010, 30999, 30989, 30978, 30967, 30957, 30946,
    30935, 30924, 30913, 30903, 30892, 30881, 30870, 30859, 30848, 30837, 30826, 30814, 30803, 30792, 30781, 30770,
    30758, 30747, 30736, 30724, 30713, 30701, 30690, 30679, 30667, 30655, 30644, 30632, 30621, 30609, 30597, 30585,
    30574, 30562, 30550, 30538, 30526, 30514, 30502, 30490, 30478, 30466, 30454, 30442, 30430, 30418, 30406, 30393,
    30381, 30369, 30357, 30344, 30332, 30319, 30307, 30294, 30282, 30269, 30257, 30244, 30232, 30219, 30206, 30194,
    30181, 30168, 30155, 30142, 30130, 30117, 30104, 30091, 30078, 30065, 30052, 30039, 30026, 30012, 29999, 29986,
    29973, 29960, 29946, 29933, 29920, 29906, 29893, 29879, 29866, 29852, 29839, 29825, 29812, 29798, 29785, 29771,
    29757, 29743, 29730, 29716, 29702, 29688, 29674, 29660, 29646, 29632, 29618, 29604, 29590, 29576, 29562, 29548,
    29534, 29520, 29505, 29491, 29477, 29462, 29448, 29434, 29419, 29405, 29390, 29376, 29361, 29347, 29332, 29318,
    29303, 29288, 29274, 29259, 29244, 29229, 29214, 29200, 29185, 29170, 29155, 29140, 29125, 29110, 29095, 29080,
    29065, 29049, 29034, 29019, 29004, 28989, 28973, 28958, 28943, 28927, 28912, 28896, 28881, 28865, 28850, 28834,
    28819, 28803, 28788, 28772, 28756, 28740, 28725, 28709, 28693, 28677, 28661, 28646, 28630, 28614, 28598, 28582,
    28566, 28550, 28533, 28517, 28501, 28485, 28469, 28453, 28436, 28420, 28404, 28387, 28371, 28354, 28338, 28322,
    28305, 28289, 28272, 28255, 28239, 28222, 28206, 28189, 28172, 28155, 28139, 28122, 28105, 28088, 28071, 28054,
    28037, 28020, 28003, 27986, 27969, 27952, 27935, 27918, 27901, 27884, 27866, 27849, 27832, 27815, 27797, 27780,
    27762, 27745, 27728, 27710, 27693, 27675, 27657, 27640, 27622, 27605, 27587, 27569, 27552, 27534, 27516, 27498,
    27480, 27463, 27445, 27427, 27409, 27391, 27373, 27355, 27337, 27319, 27301, 27282, 27264, 27246, 27228, 27210,
    27191, 27173, 27155, 27136, 27118, 27100, 27081, 27063, 27044, 27026, 27007, 26989, 26970, 26951, 26933, 26914,
    26895, 26877, 26858, 26839, 26820, 26801, 26783, 26764, 26745, 26726, 26707, 26688, 26669, 26650, 26631, 26612,
    26592, 26573, 26554, 26535, 26516, 26496, 26477, 26458, 26438, 26419, 26400, 26380, 26361, 26341, 26322, 26302,
    26283, 26263, 26243, 26224, 26204, 26184, 26165, 26145, 26125, 26105, 26086, 26066, 26046, 26026, 26006, 25986,
    25966, 25946, 25926, 25906, 25886, 25866, 25846, 25826, 25805, 25785, 25765, 25745, 25725, 25704, 25684, 25664,
    25643, 25623, 25602, 25582, 25561, 25541, 25520, 25500, 25479, 25458, 25438, 25417, 25396, 25376, 25355, 25334,
    25313, 25293, 25272, 25251, 25230, 25209, 25188, 25167, 25146, 25125, 25104, 25083, 25062, 25041, 25020, 24999,
    24977, 24956, 24935, 24914, 24892, 24871, 24850, 24828, 24807, 24785, 24764, 24743, 24721, 24700, 24678, 24656,
    24635, 24613, 24592, 24570, 24548, 24526, 24505, 24483, 24461, 24439, 24418, 24396, 24374, 24352, 24330, 24308,
    24286, 24264, 24242, 24220, 24198, 24176, 24154, 24131, 24109, 24087, 24065, 24043, 24020, 23998, 23976, 23953,
    23931, 23909, 23886, 23864, 23841, 23819, 23796, 23774, 23751, 23728, 23706, 23683, 23661, 23638, 23615, 23592,
    23570, 23547, 23524, 23501, 23478, 23456, 23433, 23410, 23387, 23364, 23341, 23318, 23295, 23272, 23249, 23226,
    23203, 23179, 23156, 23133, 23110, 23087, 23063, 23040, 23017, 22993, 22970, 22947, 22923, 22900, 22876, 22853,
    22829, 22806, 22782, 22759, 22735, 22712, 22688, 22664, 22641, 22617, 22593, 22569, 22546, 22522, 22498, 22474,
    22450, 22426, 22403, 22379, 22355, 22331, 22307, 22283, 22259, 22235, 22211, 22186, 22162, 22138, 22114, 22090,
    22066, 22041, 22017, 21993, 21969, 21944, 21920, 21895, 21871, 21847, 21822, 21798, 21773, 21749, 21724, 21700,
    21675, 21651, 21626, 21601, 21577, 21552, 21527, 21503, 21478, 21453, 21428, 21404, 21379, 21354, 21329, 21304,
    21279, 21254, 21229, 21204, 21179, 21154, 21129, 21104, 21079, 21054, 21029, 21004, 20979, 20954, 20928, 20903,
    20878, 20853, 20827, 20802, 20777, 20751, 20726, 20701, 20675, 20650, 20624, 20599, 20573, 20548, 20522, 20497,
    20471, 20446, 20420, 20394, 20369, 20343, 20317, 20292, 20266, 20240, 20214, 20188, 20163, 20137, 20111, 20085,
    20059, 20033, 20007, 19981, 19955, 19929, 19903, 19877, 19851, 19825, 19799, 19773, 19747, 19721, 19694, 19668,
    19642, 19616, 19590, 19563, 19537, 19511, 19484, 19458, 19432, 19405, 19379, 19352, 19326, 19299, 19273, 19246,
    19220, 19193, 19167, 19140, 19114, 19087, 19060, 19034, 19007, 18980, 18954, 18927, 18900, 18873, 18846, 18820,
    18793, 18766, 18739, 18712, 18685, 18658, 18631, 18604, 18577, 18550, 18523, 18496, 18469, 18442, 18415, 18388,
    18361, 18334, 18307, 18279, 18252, 18225, 18198, 18171, 18143, 18116, 18089, 18061, 18034, 18007, 17979, 17952,
    17924, 17897, 17870, 17842, 17815, 17787, 17759, 17732, 17704, 17677, 17649, 17622, 17594, 17566, 17539, 17511,
    17483, 17455, 17428, 17400, 17372, 17344, 17317, 17289, 17261, 17233, 17205, 17177, 17149, 17121, 17094, 17066,
    17038, 17010, 16982, 16954, 16925, 16897, 16869, 16841, 16813, 16785, 16757, 16729, 16700, 16672, 16644, 16616,
    16588, 16559, 16531, 16503, 16474, 16446, 16418, 16389, 16361, 16333, 16304, 16276, 16247, 16219, 16190, 16162,
    16133, 16105, 16076, 16048, 16019, 15990, 15962, 15933, 15905, 15876, 15847, 15819, 15790, 15761, 15732, 15704,
    15675, 15646, 15617, 15588, 15560, 15531, 15502, 15473, 15444, 15415, 15386, 15357, 15328, 15299, 15270, 15241,
    15212, 15183, 15154, 15125, 15096, 15067, 15038, 15009, 14980, 14951, 14921, 14892, 14863, 14834, 14805, 14775,
    14746, 14717, 14688, 14658, 14629, 14600, 14570, 14541, 14512, 14482, 14453, 14423, 14394, 14364, 14335, 14306,
    14276, 14247, 14217, 14188, 14158, 14128, 14099, 14069, 14040, 14010, 13980, 13951, 13921, 13891, 13862, 13832,
    13802, 13773, 13743, 13713, 13683, 13654, 13624, 13594, 13564, 13534, 13504, 13475, 13445, 13415, 13385, 13355,
    13325, 13295, 13265, 13235, 13205, 13175, 13145, 13115, 13085, 13055, 13025, 12995, 12965, 12935, 12905, 12874,
    12844, 12814, 12784, 12754, 12724, 12693, 12663, 12633, 12603, 12573, 12542, 12512, 12482, 12451, 12421, 12391,
    12360, 12330, 12300, 12269, 12239, 12208, 12178, 12148, 12117, 12087, 12056, 12026, 11995, 11965, 11934, 11904,
    11873, 11843, 11812, 11782, 11751, 11720, 11690, 11659, 11629, 11598, 11567, 11537, 11506, 11475, 11444, 11414,
    11383, 11352, 11322, 11291, 11260, 11229, 11198, 11168, 11137, 11106, 11075, 11044, 11014, 10983, 10952, 10921,
    10890, 10859, 10828, 10797, 10766, 10735, 10704, 10673, 10642, 10611, 10580, 10549, 10518, 10487, 10456, 10425,
    10394, 10363, 10332, 10301, 10270, 10239, 10207, 10176, 10145, 10114, 10083, 10052, 10020, 9989,  9958,  9927,
    9896,  9864,  9833,  9802,  9771,  9739,  9708,  9677,  9645,  9614,  9583,  9551,  9520,  9489,  9457,  9426,
    9394,  9363,  9332,  9300,  9269,  9237,  9206,  9174,  9143,  9112,  9080,  9049,  9017,  8986,  8954,  8923,
    8891,  8859,  8828,  8796,  8765,  8733,  8702,  8670,  8638,  8607,  8575,  8544,  8512,  8480,  8449,  8417,
    8385,  8354,  8322,  8290,  8258,  8227,  8195,  8163,  8132,  8100,  8068,  8036,  8004,  7973,  7941,  7909,
    7877,  7846,  7814,  7782,  7750,  7718,  7686,  7654,  7623,  7591,  7559,  7527,  7495,  7463,  7431,  7399,
    7367,  7335,  7304,  7272,  7240,  7208,  7176,  7144,  7112,  7080,  7048,  7016,  6984,  6952,  6920,  6888,
    6856,  6824,  6791,  6759,  6727,  6695,  6663,  6631,  6599,  6567,  6535,  6503,  6471,  6438,  6406,  6374,
    6342,  6310,  6278,  6246,  6213,  6181,  6149,  6117,  6085,  6052,  6020,  5988,  5956,  5924,  5891,  5859,
    5827,  5795,  5762,  5730,  5698,  5666,  5633,  5601,  5569,  5536,  5504,  5472,  5439,  5407,  5375,  5342,
    5310,  5278,  5245,  5213,  5181,  5148,  5116,  5084,  5051,  5019,  4987,  4954,  4922,  4889,  4857,  4825,
    4792,  4760,  4727,  4695,  4662,  4630,  4598,  4565,  4533,  4500,  4468,  4435,  4403,  4370,  4338,  4305,
    4273,  4240,  4208,  4175,  4143,  4110,  4078,  4045,  4013,  3980,  3948,  3915,  3883,  3850,  3818,  3785,
    3752,  3720,  3687,  3655,  3622,  3590,  3557,  3525,  3492,  3459,  3427,  3394,  3362,  3329,  3296,  3264,
    3231,  3199,  3166,  3133,  3101,  3068,  3035,  3003,  2970,  2938,  2905,  2872,  2840,  2807,  2774,  2742,
    2709,  2676,  2644,  2611,  2578,  2546,  2513,  2480,  2448,  2415,  2382,  2350,  2317,  2284,  2252,  2219,
    2186,  2153,  2121,  2088,  2055,  2023,  1990,  1957,  1925,  1892,  1859,  1826,  1794,  1761,  1728,  1696,
    1663,  1630,  1597,  1565,  1532,  1499,  1466,  1434,  1401,  1368,  1335,  1303,  1270,  1237,  1204,  1172,
    1139,  1106,  1073,  1041,  1008,  975,   942,   910,   877,   844,   811,   779,   746,   713,   680,   648,
    615,   582,   549,   517,   484,   451,   418,   385,   353,   320,   287,   254,   222,   189,   156,   123,
    91,    58,    25};

/**
 * Funtion to find 1/x. x is QM.(16-M) fixed point format.
 * The value returned is of 16-bit wide with fractional part equal to N i.e. Q(16-N).N.
 * This works only for a 16-bit fixed point representation of x.
 */
static unsigned int Inverse(unsigned short x, int M, char* N);

/**
 * Funtion to find 1/x. x is QM.(16-M) fixed point format.
 * The value returned is of 32-bit wide with fractional part equal to N i.e. Q(32-N).N.
 * This works only for a 16-bit fixed point representation of x.
 *
 */
static unsigned int Inverse32(unsigned short x, int M, char* N);

/**
 * Funtion to find y/x. x is QM1.(16-M1) and y is QM2.(16-M2) fixed point format.
 * The value returned is of 32-bit width fixed point format of Qout_M.out_N.
 * This works only for a 16-bit fixed point representation of x and y.
 *
 * This function implements the division like y*Inverse(x).
 */
static unsigned int DivideYByX(unsigned short x, unsigned short y, int M1, int M2, char* out_M, char* out_N);

/**
 * Funtion to find atan2(y,x). x is QM1.N1 and y is QM2.N2 fixed point format. x and y are of 16-bit.
 * The value returned is of 16-bit width fixed point format of Qout_M.out_N.
 * The angle returned by this function will be in -pi to pi range in Q4.12
 */
static short Atan2LookupFP(short xs, short ys, int M1, int N1, int M2, int N2);

/**
 * Square root computation
 * D is 32-bit fixed point number. Q is the sqrt(D) and is 16-bit type
 * If format of D is QM.N then format of Q is Q(M/2).N
 *
 * For more details on Q formats of square root refer to sqrt.pdf
 */
static int Sqrt(unsigned int D);

/**
 * 	Inverse32: Computes the inverse of 16-bit integer and returns high precision value.
 */
static unsigned int Inverse32(unsigned short x, int M, char* N) {
    assert((M <= 16) && "Integer part of x should always be less than or equal to 16 bits.");
    unsigned int val = 0;
    unsigned int index;
    int B_L = 17;

    int tmp = 4;
    int pos, block;
    pos = block = 0;
    int shift = 0;
    unsigned short x1 = (x >> 12) & 0x000F;
    unsigned short x2 = (x >> 8) & 0x000F;
    unsigned short x3 = (x >> 4) & 0x000F;
    unsigned short x4 = x & 0x000F;

    unsigned short tmpx = 0;

    if (x == 0) {
        return division_lut[0];
    } else {
        if (x1 > 0) {
            tmpx = x1;
            block = 0;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x1 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        } else if (x2 > 0) {
            block = 4;
            tmpx = x2;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x2 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        } else if (x3 > 0) {
            block = 8;
            tmpx = x3;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x3 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        } else {
            block = 12;
            tmpx = x4;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x4 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        }
    }
    B_L = block + pos;
    shift = 0; // DATA_SIZE - LUT_BITS - 1;
    if (B_L >= 1) {
        index = ((x << (B_L - 1)) & 0x7FFF) >> shift;
    } else {
        index = (x & 0x7FFF) >> shift;
    }
    val = division_lut32[index];

    *N = M + 16 - B_L;

    return val;
}

static unsigned int Inverse(unsigned short x, int M, char* N) {
    assert((M <= 16) && "Integer part of x should always be less than or equal to 16 bits.");
    unsigned int val = 0;
    unsigned int index;
    int B_L = DATA_SIZE + 1;

    int tmp = 4;
    int pos, block;
    pos = block = 0;
    int shift = 0;
    unsigned short x1 = (x >> 12) & 0x000F;
    unsigned short x2 = (x >> 8) & 0x000F;
    unsigned short x3 = (x >> 4) & 0x000F;
    unsigned short x4 = x & 0x000F;

    unsigned short tmpx = 0;

    if (x == 0)
        return division_lut[0];
    else {
        if (x1 > 0) {
            tmpx = x1;
            block = 0;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x1 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        } else if (x2 > 0) {
            block = 1;
            tmpx = x2;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x2 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        } else if (x3 > 0) {
            block = 2;
            tmpx = x3;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x3 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        } else {
            block = 3;
            tmpx = x4;
            for (tmp = 0; tmp < 4; tmp++) {
// clang-format off
                #pragma HLS LOOP_TRIPCOUNT min=4 max=4 avg=4
                #pragma HLS pipeline
                // clang-format on
                tmpx = x4 >> (3 - tmp);
                if (tmpx) {
                    pos = tmp + 1;
                    break;
                }
            }
        }
    }
    B_L = 4 * block + pos;
    shift = DATA_SIZE - LUT_BITS - 1;
    if (B_L >= 1)
        index = ((x << (B_L - 1)) & 0x7FFF) >> shift;
    else
        index = (x & 0x7FFF) >> shift;

    val = division_lut[index];
    *N = M + DATA_SIZE - B_L;

    return val;
}

static char IdentifySignBits(ap_int<24> in_val) {
    bool flag = 0;
    char counter = 0;

    bool signbit = in_val.range(23, 23);

signBitsLoop:
    while (flag == 0) {
// clang-format off
        #pragma HLS LOOP_TRIPCOUNT min=24 max=24
        #pragma HLS PIPELINE
        // clang-format on

        bool bit_val = in_val.range((23 - counter), (23 - counter));

        if (bit_val == signbit)
            counter++;
        else
            flag = 1;

        if (counter == 24) break;
    }
    return counter;
}

static unsigned short Inverse8(unsigned char x, int M, char* N) {
    assert((M == 8) && "x should be of Q8.0 format.");
    unsigned int val = 0;
    unsigned int index;

    if (x == 0)
        return division_lut8[0];
    else {
        val = division_lut8[x];
        *N = 15;
    }

    return val;
}

static unsigned int DivideYByX(unsigned short x, unsigned short y, int M1, int M2, char* out_M, char* out_N) {
    unsigned int div_val;
    char MOut, NOut;
    unsigned int x_inv = Inverse(x, M1, &NOut);

    MOut = DATA_SIZE - NOut + M2;
    NOut = NOut + DATA_SIZE - M2;

    div_val = y * x_inv;

    *out_M = MOut;
    *out_N = NOut;

    return div_val;
}
static void findInverse24(ap_int<24>& x, int& M, int& N, unsigned int& inv_x, int* outM, int* outN) {
    if (x == 0) { // if the denominator is '0', return the highest value with the highest integer bit and zero
                  // fractional bits
        inv_x = division_lut[0];
        *outM = 16;
        *outN = 0;
        return;
    }
    char sb = IdentifySignBits(x); // find number of sign bits

    ap_int24_t unsigned_x = (ap_int24_t)x.range(23 - sb, 0); // Extract the value without sign bits

    int M1, N1, leftover_bits = 0;
    if (N == 0) {
        M1 = M - sb; // Number of valid integer bits
        if (M1 > 16) {
            leftover_bits = M1 - 16; // No of bits left over in x after extracting unsigned_x
        }
        M1 = 16; // No of integer bits in unsigned_x
    }

    unsigned short xs = unsigned_x >> leftover_bits; // Extract the 16 MSBits from unsigned_x
    char Nout;
    unsigned int inv_xs = Inverse(xs, M1, &Nout); // find inverse to the MSBits
    inv_x = (long int)inv_xs;                     // return output

    *outN = Nout + leftover_bits; // return output Q format, no of fractional bits
    *outM = 32 - Nout;            // return output Q format, no of integer bits
}
static unsigned int DivideYByX8(unsigned char x, unsigned char y, int M1, int M2, char* out_M, char* out_N) {
    assert((M1 == 8) && (M2 == 8) && "x and y should be of Q8.0 format.");

    unsigned int div_val;
    char MOut, NOut;
    unsigned short x_inv = Inverse8(x, M1, &NOut);

    MOut = (16 - NOut) + M2; // int part of 1/x + int part of y
    NOut = NOut + (8 - M2);  // frac part of 1/x + frac part of y

    div_val = y * x_inv;

    *out_M = MOut;
    *out_N = NOut;

    return div_val;
}

static unsigned long int DivideYByX24(ap_int24_t x, ap_int24_t y, int M1, int M2, int* out_M, int* out_N) {
    unsigned long int div_val;
    char MOut, NOut;
    unsigned int x_inv;
    int N1 = 0, N2 = 0;
    int M3, N3;

    findInverse24(x, M1, N1, x_inv, &M3, &N3);

    MOut = M2 + M3;
    NOut = N3 + 24 - M2;

    div_val = (unsigned long int)y * x_inv;

    *out_M = MOut;
    *out_N = NOut;

    return div_val;
}
static short Atan2LookupFP(short xs, short ys, int M1, int N1, int M2, int N2) {
    assert(((N1 == 16 - M1) && (N2 == 16 - M2) && (M1 == M2)) &&
           "xs and ys should be of 16-bit and same fixed point type.");
    short theta;
    signed char s1, s2, s;
    if (ys == 0 && xs == 0)
        return 0;
    else {
        unsigned long gy_fp, gx_fp;
        unsigned long int frac_extractor;
        unsigned long int k2_fp;
        unsigned short int_part;
        unsigned int frac_part, frac_ind, frac_bits;

        gx_fp = xs;
        s1 = 1;
        gy_fp = ys;
        s2 = 1;

        if (xs < 0) {
            gx_fp = -xs;
            s1 = -1;
        }
        if (ys < 0) {
            gy_fp = -ys;
            s2 = -1;
        }

        s = s1 * s2; // find the sign of gy/gx

        char MOut, NOut;
        k2_fp = DivideYByX(gx_fp, gy_fp, M1, M2, &MOut, &NOut);

        frac_extractor = (1 << NOut) - 1;

        int_part = k2_fp >> NOut;
        frac_part = (k2_fp & frac_extractor);

        if (int_part < 63) {
            frac_bits = frac_bits_lut[int_part]; // Number of fractional bits needed to find sub-index in look-up table
            frac_ind = (frac_part >> (NOut - frac_bits)); // find sub-index
            int ind = base_addr_lut[int_part] + frac_ind; // find the index for atan look up table
            theta = atan_lut_fp[ind];
        } else
            theta = XF_PI_BY_2_FIXED;

        if (gx_fp == 0) theta = XF_PI_BY_2_FIXED;

        if (s < 0) theta = -theta;

        if (xs > 0)
            return theta;
        else if (ys >= 0 && xs < 0)
            return XF_PI_FIXED + theta;
        else if (ys < 0 && xs < 0)
            return theta - XF_PI_FIXED;
        else if (ys > 0 && xs == 0)
            return XF_PI_BY_2_FIXED;
        else if (ys < 0 && xs == 0)
            return -XF_PI_BY_2_FIXED;
    }
    return theta; // returns atan2 value in fixed point form of signed Q4.12. Its range will be b/w -pi to pi.
}

static short Atan2LUT8(short xs, short ys, int M1, int N1, int M2, int N2) {
    assert(((N1 == 9 - M1) && (N2 == 9 - M2) && (M1 == M2)) &&
           "xs and ys should be of signed 9-bit and same fixed point type.");
    short theta;
    signed char s1, s2, s;
    if (ys == 0 && xs == 0)
        return 0;
    else {
        unsigned short gy_fp, gx_fp;
        unsigned long int frac_extractor;
        unsigned int k2_fp;
        unsigned short int_part;
        unsigned int frac_part, frac_ind, frac_bits;

        gx_fp = xs;
        s1 = 1;
        gy_fp = ys;
        s2 = 1;

        if (xs < 0) {
            gx_fp = -xs;
            s1 = -1;
        }
        if (ys < 0) {
            gy_fp = -ys;
            s2 = -1;
        }

        s = s1 * s2; // find the sign of gy/gx

        char MOut, NOut;

        k2_fp = DivideYByX8((unsigned char)gx_fp, (unsigned char)gy_fp, 8, 8, &MOut, &NOut);

        frac_extractor = (1 << NOut) - 1;

        int_part = k2_fp >> NOut;
        frac_part = (k2_fp & frac_extractor);

        if (int_part < 63) {
            frac_bits = base_addr_lut8[63 + int_part];
            frac_ind = (frac_part >> (NOut - frac_bits));  // find sub-index
            int ind = base_addr_lut8[int_part] + frac_ind; // find the index for atan look up table
            theta = atan_lut_fp8[ind];
        } else
            theta = XF_PI_BY_2_FIXED;

        if (gx_fp == 0) theta = XF_PI_BY_2_FIXED;

        if (s < 0) theta = -theta;

        if (xs > 0)
            return theta;
        else if (ys >= 0 && xs < 0)
            return XF_PI_FIXED + theta;
        else if (ys < 0 && xs < 0)
            return theta - XF_PI_FIXED;
        else if (ys > 0 && xs == 0)
            return XF_PI_BY_2_FIXED;
        else if (ys < 0 && xs == 0)
            return -XF_PI_BY_2_FIXED;
    }
    return theta; // returns atan2 value in fixed point form of signed Q4.12. Its range will be b/w -pi to pi.
}

static short Atan2LookupFP24(ap_int24_t xs, ap_int24_t ys, int M1, int N1, int M2, int N2) {
    assert(((N1 == 24 - M1) && (N2 == 24 - M2) && (M1 == M2)) &&
           "xs and ys should be of 24-bit and same fixed point type.");
    short theta;
    char s1, s2, s;
    if (ys == 0 && xs == 0)
        return 0;
    else {
        ap_int24_t gy_fp, gx_fp;
        unsigned long int frac_extractor;
        unsigned long int k2_fp;
        unsigned short int_part;
        unsigned long int frac_part = 0, frac_ind = 0, frac_bits = 0;

        gx_fp = xs;
        s1 = 1;
        gy_fp = ys;
        s2 = 1;

        if (xs < 0) {
            gx_fp = -xs;
            s1 = -1;
        }
        if (ys < 0) {
            gy_fp = -ys;
            s2 = -1;
        }

        s = s1 * s2; // find the sign of gy/gx

        int MOut, NOut;

        k2_fp = DivideYByX24(gx_fp, gy_fp, M1, M2, &MOut, &NOut);

        frac_extractor = ((unsigned long int)1 << NOut) - 1;

        int_part = k2_fp >> NOut;
        frac_part = (k2_fp & frac_extractor);

        if (int_part < 63) {
            frac_bits = frac_bits_lut[int_part]; // Number of fractional bits needed to find sub-index in look-up table
            frac_ind = (unsigned long int)(frac_part >> (NOut - frac_bits)); // find sub-index
            int ind = base_addr_lut[int_part] + frac_ind;                    // find the index for atan look up table
            theta = atan_lut_fp[ind];
        } else
            theta = XF_PI_BY_2_FIXED;

        if (gx_fp == 0) theta = XF_PI_BY_2_FIXED;

        if (s < 0) theta = -theta;

        if (xs > 0)
            return theta;
        else if (ys >= 0 && xs < 0)
            return XF_PI_FIXED + theta;
        else if (ys < 0 && xs < 0)
            return theta - XF_PI_FIXED;
        else if (ys > 0 && xs == 0)
            return XF_PI_BY_2_FIXED;
        else if (ys < 0 && xs == 0)
            return -XF_PI_BY_2_FIXED;
    }
    return theta; // returns atan2 value in fixed point form of signed Q4.12. Its range will be b/w -pi to pi.
}

/**
 * Square root computation for a 16-bit fixed point number.
 *
 * Input argument D should be 16-bit number though it is declared as 32-bit.
 * Q is the sqrt(D) and is 16-bit type
 * If format of D is QM.N (where M+N = 16) then format of Q is Q(M/2).N
 *
 *	In order to get a precision of 'n' bits in fractional part, you can simply shift left the radicand (D) by '2n'
 *	before function call and shift the solution right by 'n' to get the correct answer.
 *
 *	For example, if you want to find the square root of 35 (01100011) with one bit after decimal point i.e. N=1.
 *	You have to first find the square root of 0110001100 (shift left by 2). After you get the answer (1011) you
 *	have right shift it right by 1, so that the correct answer is 101.1 which is 5.5.
 *
 */
static int Sqrt(unsigned int D) {
    //#pragma HLS license key=IPAUVIZ_CV_BASIC
    int i;
    short int Q;
    int R;
    Q = R = 0;
    int tmp = 0;
    int tmpQ, tmpR;

    for (i = 15; i >= 0; i--) {
// clang-format off
        #pragma HLS pipeline
        // clang-format on
        if (R >= 0) {
            tmp = D >> (i + i);
            tmp = tmp & 3;
            tmpR = R << 2;
            R = tmpR | tmp;

            tmpQ = Q << 2;
            tmpQ = tmpQ | 1;

            R = R - tmpQ;
        } else {
            tmp = D >> (i + i);
            tmp = tmp & 3;
            tmpR = R << 2;
            R = tmpR | tmp;

            tmpQ = Q << 2;
            tmpQ = tmpQ | 3;

            R = R + tmpQ;
        }
        if (R >= 0) {
            Q = Q << 1;
            Q = Q | 1;
        } else {
            Q = Q << 1;
            Q = Q | 0;
        }
    }
    return Q;
}
} // namespace cv
} // namespace xf
#endif
