/*
 * Copyright 2019 Xilinx, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

typedef float param_T;

//#define OLD720PPARAMS
//#define JACKSCAMERA_FHD
//#define JACKSCAMERA_HACKF_720P
//#define DANSCAMERA_FHD
//#define DANSCAMERA_720P
#define DANSCAMERA_HACKF_720P

#ifdef OLD720PPARAMS
param_T cameraMA_l[9] = {1000, 0.0, 950, 0.0, 1000, 950, 0, 0, 1};
param_T irA_l[9] = {0.001, 0, -0.95, 0, 0.001, -0.95, 0, 0, 1};
param_T distC_l[5] = {0, 0, 0, 0, 0};
param_T cameraMA_r[9] = {1000, 0.0, 950, 0.0, 1000, 950, 0, 0, 1};
param_T irA_r[9] = {0.001, 0, -0.95, 0, 0.001, -0.95, 0, 0, 1};
param_T distC_r[5] = {0, 0, 0, 0, 0};
#endif

#ifdef JACKSCAMERA_HACKF_720P
param_T cameraMA_l[9] = {933.6330000000, 0.0000000000, 695.1210000000, 0.0000000000, 933.6330000000,
                         357.9060000000, 0.0000000000, 0.0000000000,   1.0000000000};

param_T cameraMA_r[9] = {933.0330000000, 0.0000000000, 713.4870000000, 0.0000000000, 933.0330000000,
                         371.9880000000, 0.0000000000, 0.0000000000,   1.0000000000};

param_T distC_l[5] = {-0.1742480000, 0.0257726000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T distC_r[5] = {-0.1761240000, 0.0290219000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T irA_l[9] = {0.0012029958,  0.0000006953, -0.8686828369, -0.0000006919, 0.0012030057,
                    -0.4384867217, 0.0000049680, -0.0000008223, 0.9967224703};

param_T irA_r[9] = {0.0012030062,  0.0000000000, -0.8643069377, -0.0000000000, 0.0012030059,
                    -0.4403546203, 0.0000000000, 0.0000008238,  0.9996986971};
#endif

#ifdef JACKSCAMERA_FHD
// ZED 2x 1080p Stereo Camera
// from SN2484.conf [LEFT_CAM_FHD] fx,cx,fy,cy
// Camera Mat Left:
param_T cameraMA_l[9] = {1400.4500000000, 0.0000000000, 1073.2400000000, 0.0000000000, 1400.4500000000,
                         538.8110000000,  0.0000000000, 0.0000000000,    1.0000000000};

// inv(Rotation Mat * new Camera Mat) Left:
param_T irA_l[9] = {0.0008019968,  0.0000004635, -0.9044744614, -0.0000004613, 0.0008020035,
                    -0.4432839221, 0.0000033120, -0.0000005482, 0.9965779658};

// from SN2484.conf [LEFT_CAM_FHD] k1,k2
param_T distC_l[5] = {-0.174248, 0.0257726, 0, 0, 0};

// from SN2484.conf [RIGHT_CAM_FHD] fx,cx,fy,cy
// Camera Mat Right:
param_T cameraMA_r[9] = {1399.5500000000, 0.0000000000, 1109.9700000000, 0.0000000000, 1399.5500000000,
                         566.9750000000,  0.0000000000, 0.0000000000,    1.0000000000};

// inv(Rotation Mat * new Camera Mat) Right:
param_T irA_r[9] = {0.0008020038,  0.0000000000, -0.9000960887, -0.0000000000, 0.0008020036,
                    -0.4451724061, 0.0000000000, 0.0000005492,  0.9996953980};

// from SN2484.conf [RIGHT_CAM_FHD] k1,k2
param_T distC_r[5] = {-0.176124, 0.0290219, 0, 0, 0};

#endif

#ifdef DANSCAMERA_720P
param_T cameraMA_l[9] = {699.8780000000, 0.0000000000, 663.4510000000, 0.0000000000, 699.8780000000,
                         377.0150000000, 0.0000000000, 0.0000000000,   1.0000000000};

param_T cameraMA_r[9] = {700.0990000000, 0.0000000000, 678.2970000000, 0.0000000000, 700.0990000000,
                         359.6230000000, 0.0000000000, 0.0000000000,   1.0000000000};

param_T distC_l[5] = {-0.1693980000, 0.0227329000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T distC_r[5] = {-0.1705810000, 0.0249444000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T irA_l[9] = {0.0024720519,  -0.0000000039, -1.7464382128, 0.0000000015, 0.0024721905,
                    -0.9765267985, 0.0000261810,  0.0000002197,  0.9814731201};

param_T irA_r[9] = {0.0024721905,  0.0000000000,  -1.7359468834, -0.0000000000, 0.0024721905,
                    -0.9763479760, -0.0000000000, -0.0000002197, 1.0000867727};
#endif

#ifdef DANSCAMERA_HACKF_720P
param_T cameraMA_l[9] = {933.1730000000, 0.0000000000, 663.4510000000, 0.0000000000, 933.1730000000,
                         377.0150000000, 0.0000000000, 0.0000000000,   1.0000000000};

param_T cameraMA_r[9] = {933.4670000000, 0.0000000000, 678.2970000000, 0.0000000000, 933.4670000000,
                         359.6230000000, 0.0000000000, 0.0000000000,   1.0000000000};

param_T distC_l[5] = {-0.1693980000, 0.0227329000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T distC_r[5] = {-0.1705810000, 0.0249444000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T irA_l[9] = {0.0011976323,  -0.0000000019, -0.8153011732, 0.0000000007, 0.0011976994,
                    -0.4422348617, 0.0000126839,  0.0000001064,  0.9913820905};

param_T irA_r[9] = {0.0011976994,  0.0000000000,  -0.8047567905, -0.0000000000, 0.0011976994,
                    -0.4420566166, -0.0000000000, -0.0000001064, 1.0000392898};
#endif

#ifdef DANSCAMERA_FHD
param_T cameraMA_l[9] = {1399.7600000000, 0.0000000000, 1009.9000000000, 0.0000000000, 1399.7600000000,
                         577.0300000000,  0.0000000000, 0.0000000000,    1.0000000000};

param_T cameraMA_r[9] = {1400.2000000000, 0.0000000000, 1039.5900000000, 0.0000000000, 1400.2000000000,
                         542.2460000000,  0.0000000000, 0.0000000000,    1.0000000000};

param_T distC_l[5] = {-0.1693980000, 0.0227329000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T distC_r[5] = {-0.1705810000, 0.0249444000, 0.0000000000, 0.0000000000, 0.0000000000};

param_T irA_l[9] = {0.0007984219,  -0.0000000012, -0.8338509656, 0.0000000005, 0.0007984666,
                    -0.4484861710, 0.0000084559,  0.0000000710,  0.9911850779};

param_T irA_r[9] = {0.0007984666,  0.0000000000,  -0.8233076329, -0.0000000000, 0.0007984666,
                    -0.4483079145, -0.0000000000, -0.0000000710, 1.0000398454};
#endif
