-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and OpenCL
-- Version: 2020.2
-- Copyright (C) 1986-2020 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity ISPpipeline_Block_Ma is
port (
    ap_clk : IN STD_LOGIC;
    ap_rst : IN STD_LOGIC;
    ap_start : IN STD_LOGIC;
    start_full_n : IN STD_LOGIC;
    ap_done : OUT STD_LOGIC;
    ap_continue : IN STD_LOGIC;
    ap_idle : OUT STD_LOGIC;
    ap_ready : OUT STD_LOGIC;
    start_out : OUT STD_LOGIC;
    start_write : OUT STD_LOGIC;
    height : IN STD_LOGIC_VECTOR (15 downto 0);
    width : IN STD_LOGIC_VECTOR (15 downto 0);
    imgInput1_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    imgInput1_rows_out_full_n : IN STD_LOGIC;
    imgInput1_rows_out_write : OUT STD_LOGIC;
    imgInput1_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    imgInput1_cols_out_full_n : IN STD_LOGIC;
    imgInput1_cols_out_write : OUT STD_LOGIC;
    imgInput2_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    imgInput2_rows_out_full_n : IN STD_LOGIC;
    imgInput2_rows_out_write : OUT STD_LOGIC;
    imgInput2_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    imgInput2_cols_out_full_n : IN STD_LOGIC;
    imgInput2_cols_out_write : OUT STD_LOGIC;
    bpc_out_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    bpc_out_rows_out_full_n : IN STD_LOGIC;
    bpc_out_rows_out_write : OUT STD_LOGIC;
    bpc_out_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    bpc_out_cols_out_full_n : IN STD_LOGIC;
    bpc_out_cols_out_write : OUT STD_LOGIC;
    gain_out_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    gain_out_rows_out_full_n : IN STD_LOGIC;
    gain_out_rows_out_write : OUT STD_LOGIC;
    gain_out_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    gain_out_cols_out_full_n : IN STD_LOGIC;
    gain_out_cols_out_write : OUT STD_LOGIC;
    demosaic_out_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    demosaic_out_rows_out_full_n : IN STD_LOGIC;
    demosaic_out_rows_out_write : OUT STD_LOGIC;
    demosaic_out_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    demosaic_out_cols_out_full_n : IN STD_LOGIC;
    demosaic_out_cols_out_write : OUT STD_LOGIC;
    ltm_in_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    ltm_in_rows_out_full_n : IN STD_LOGIC;
    ltm_in_rows_out_write : OUT STD_LOGIC;
    ltm_in_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    ltm_in_cols_out_full_n : IN STD_LOGIC;
    ltm_in_cols_out_write : OUT STD_LOGIC;
    lsc_out_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    lsc_out_rows_out_full_n : IN STD_LOGIC;
    lsc_out_rows_out_write : OUT STD_LOGIC;
    lsc_out_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    lsc_out_cols_out_full_n : IN STD_LOGIC;
    lsc_out_cols_out_write : OUT STD_LOGIC;
    aecin_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    aecin_rows_out_full_n : IN STD_LOGIC;
    aecin_rows_out_write : OUT STD_LOGIC;
    aecin_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    aecin_cols_out_full_n : IN STD_LOGIC;
    aecin_cols_out_write : OUT STD_LOGIC );
end;


architecture behav of ISPpipeline_Block_Ma is 
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_ST_fsm_state1 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_boolean_1 : BOOLEAN := true;

    signal real_start : STD_LOGIC;
    signal start_once_reg : STD_LOGIC := '0';
    signal ap_done_reg : STD_LOGIC := '0';
    signal ap_CS_fsm : STD_LOGIC_VECTOR (0 downto 0) := "1";
    attribute fsm_encoding : string;
    attribute fsm_encoding of ap_CS_fsm : signal is "none";
    signal ap_CS_fsm_state1 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state1 : signal is "none";
    signal internal_ap_ready : STD_LOGIC;
    signal imgInput1_rows_out_blk_n : STD_LOGIC;
    signal imgInput1_cols_out_blk_n : STD_LOGIC;
    signal imgInput2_rows_out_blk_n : STD_LOGIC;
    signal imgInput2_cols_out_blk_n : STD_LOGIC;
    signal bpc_out_rows_out_blk_n : STD_LOGIC;
    signal bpc_out_cols_out_blk_n : STD_LOGIC;
    signal gain_out_rows_out_blk_n : STD_LOGIC;
    signal gain_out_cols_out_blk_n : STD_LOGIC;
    signal demosaic_out_rows_out_blk_n : STD_LOGIC;
    signal demosaic_out_cols_out_blk_n : STD_LOGIC;
    signal ltm_in_rows_out_blk_n : STD_LOGIC;
    signal ltm_in_cols_out_blk_n : STD_LOGIC;
    signal lsc_out_rows_out_blk_n : STD_LOGIC;
    signal lsc_out_cols_out_blk_n : STD_LOGIC;
    signal aecin_rows_out_blk_n : STD_LOGIC;
    signal aecin_cols_out_blk_n : STD_LOGIC;
    signal ap_block_state1 : BOOLEAN;
    signal ap_NS_fsm : STD_LOGIC_VECTOR (0 downto 0);


begin




    ap_CS_fsm_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_CS_fsm <= ap_ST_fsm_state1;
            else
                ap_CS_fsm <= ap_NS_fsm;
            end if;
        end if;
    end process;


    ap_done_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_done_reg <= ap_const_logic_0;
            else
                if ((ap_continue = ap_const_logic_1)) then 
                    ap_done_reg <= ap_const_logic_0;
                elsif ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
                    ap_done_reg <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    start_once_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                start_once_reg <= ap_const_logic_0;
            else
                if (((internal_ap_ready = ap_const_logic_0) and (real_start = ap_const_logic_1))) then 
                    start_once_reg <= ap_const_logic_1;
                elsif ((internal_ap_ready = ap_const_logic_1)) then 
                    start_once_reg <= ap_const_logic_0;
                end if; 
            end if;
        end if;
    end process;


    ap_NS_fsm_assign_proc : process (real_start, ap_done_reg, ap_CS_fsm, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        case ap_CS_fsm is
            when ap_ST_fsm_state1 => 
                ap_NS_fsm <= ap_ST_fsm_state1;
            when others =>  
                ap_NS_fsm <= "X";
        end case;
    end process;

    aecin_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, aecin_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            aecin_cols_out_blk_n <= aecin_cols_out_full_n;
        else 
            aecin_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    aecin_cols_out_din <= width;

    aecin_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            aecin_cols_out_write <= ap_const_logic_1;
        else 
            aecin_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    aecin_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, aecin_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            aecin_rows_out_blk_n <= aecin_rows_out_full_n;
        else 
            aecin_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    aecin_rows_out_din <= height;

    aecin_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            aecin_rows_out_write <= ap_const_logic_1;
        else 
            aecin_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;

    ap_CS_fsm_state1 <= ap_CS_fsm(0);

    ap_block_state1_assign_proc : process(real_start, ap_done_reg, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
                ap_block_state1 <= ((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1));
    end process;


    ap_done_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ap_done <= ap_const_logic_1;
        else 
            ap_done <= ap_done_reg;
        end if; 
    end process;


    ap_idle_assign_proc : process(real_start, ap_CS_fsm_state1)
    begin
        if (((real_start = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ap_idle <= ap_const_logic_1;
        else 
            ap_idle <= ap_const_logic_0;
        end if; 
    end process;

    ap_ready <= internal_ap_ready;

    bpc_out_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bpc_out_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bpc_out_cols_out_blk_n <= bpc_out_cols_out_full_n;
        else 
            bpc_out_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    bpc_out_cols_out_din <= width;

    bpc_out_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bpc_out_cols_out_write <= ap_const_logic_1;
        else 
            bpc_out_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    bpc_out_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bpc_out_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bpc_out_rows_out_blk_n <= bpc_out_rows_out_full_n;
        else 
            bpc_out_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    bpc_out_rows_out_din <= height;

    bpc_out_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bpc_out_rows_out_write <= ap_const_logic_1;
        else 
            bpc_out_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    demosaic_out_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, demosaic_out_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            demosaic_out_cols_out_blk_n <= demosaic_out_cols_out_full_n;
        else 
            demosaic_out_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    demosaic_out_cols_out_din <= width;

    demosaic_out_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            demosaic_out_cols_out_write <= ap_const_logic_1;
        else 
            demosaic_out_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    demosaic_out_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, demosaic_out_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            demosaic_out_rows_out_blk_n <= demosaic_out_rows_out_full_n;
        else 
            demosaic_out_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    demosaic_out_rows_out_din <= height;

    demosaic_out_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            demosaic_out_rows_out_write <= ap_const_logic_1;
        else 
            demosaic_out_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    gain_out_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, gain_out_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            gain_out_cols_out_blk_n <= gain_out_cols_out_full_n;
        else 
            gain_out_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    gain_out_cols_out_din <= width;

    gain_out_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            gain_out_cols_out_write <= ap_const_logic_1;
        else 
            gain_out_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    gain_out_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, gain_out_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            gain_out_rows_out_blk_n <= gain_out_rows_out_full_n;
        else 
            gain_out_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    gain_out_rows_out_din <= height;

    gain_out_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            gain_out_rows_out_write <= ap_const_logic_1;
        else 
            gain_out_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    imgInput1_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput1_cols_out_blk_n <= imgInput1_cols_out_full_n;
        else 
            imgInput1_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    imgInput1_cols_out_din <= width;

    imgInput1_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput1_cols_out_write <= ap_const_logic_1;
        else 
            imgInput1_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    imgInput1_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput1_rows_out_blk_n <= imgInput1_rows_out_full_n;
        else 
            imgInput1_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    imgInput1_rows_out_din <= height;

    imgInput1_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput1_rows_out_write <= ap_const_logic_1;
        else 
            imgInput1_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    imgInput2_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput2_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput2_cols_out_blk_n <= imgInput2_cols_out_full_n;
        else 
            imgInput2_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    imgInput2_cols_out_din <= width;

    imgInput2_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput2_cols_out_write <= ap_const_logic_1;
        else 
            imgInput2_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    imgInput2_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput2_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput2_rows_out_blk_n <= imgInput2_rows_out_full_n;
        else 
            imgInput2_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    imgInput2_rows_out_din <= height;

    imgInput2_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            imgInput2_rows_out_write <= ap_const_logic_1;
        else 
            imgInput2_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    internal_ap_ready_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            internal_ap_ready <= ap_const_logic_1;
        else 
            internal_ap_ready <= ap_const_logic_0;
        end if; 
    end process;


    lsc_out_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, lsc_out_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            lsc_out_cols_out_blk_n <= lsc_out_cols_out_full_n;
        else 
            lsc_out_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    lsc_out_cols_out_din <= width;

    lsc_out_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            lsc_out_cols_out_write <= ap_const_logic_1;
        else 
            lsc_out_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    lsc_out_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, lsc_out_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            lsc_out_rows_out_blk_n <= lsc_out_rows_out_full_n;
        else 
            lsc_out_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    lsc_out_rows_out_din <= height;

    lsc_out_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            lsc_out_rows_out_write <= ap_const_logic_1;
        else 
            lsc_out_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    ltm_in_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, ltm_in_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ltm_in_cols_out_blk_n <= ltm_in_cols_out_full_n;
        else 
            ltm_in_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    ltm_in_cols_out_din <= width;

    ltm_in_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ltm_in_cols_out_write <= ap_const_logic_1;
        else 
            ltm_in_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    ltm_in_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, ltm_in_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ltm_in_rows_out_blk_n <= ltm_in_rows_out_full_n;
        else 
            ltm_in_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    ltm_in_rows_out_din <= height;

    ltm_in_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, imgInput1_rows_out_full_n, imgInput1_cols_out_full_n, imgInput2_rows_out_full_n, imgInput2_cols_out_full_n, bpc_out_rows_out_full_n, bpc_out_cols_out_full_n, gain_out_rows_out_full_n, gain_out_cols_out_full_n, demosaic_out_rows_out_full_n, demosaic_out_cols_out_full_n, ltm_in_rows_out_full_n, ltm_in_cols_out_full_n, lsc_out_rows_out_full_n, lsc_out_cols_out_full_n, aecin_rows_out_full_n, aecin_cols_out_full_n)
    begin
        if ((not(((ap_const_logic_0 = aecin_rows_out_full_n) or (lsc_out_cols_out_full_n = ap_const_logic_0) or (lsc_out_rows_out_full_n = ap_const_logic_0) or (ltm_in_cols_out_full_n = ap_const_logic_0) or (ltm_in_rows_out_full_n = ap_const_logic_0) or (demosaic_out_cols_out_full_n = ap_const_logic_0) or (demosaic_out_rows_out_full_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (gain_out_cols_out_full_n = ap_const_logic_0) or (gain_out_rows_out_full_n = ap_const_logic_0) or (bpc_out_cols_out_full_n = ap_const_logic_0) or (bpc_out_rows_out_full_n = ap_const_logic_0) or (imgInput2_cols_out_full_n = ap_const_logic_0) or (imgInput2_rows_out_full_n = ap_const_logic_0) or (imgInput1_cols_out_full_n = ap_const_logic_0) or (imgInput1_rows_out_full_n = ap_const_logic_0) or (ap_const_logic_0 = aecin_cols_out_full_n) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ltm_in_rows_out_write <= ap_const_logic_1;
        else 
            ltm_in_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    real_start_assign_proc : process(ap_start, start_full_n, start_once_reg)
    begin
        if (((start_full_n = ap_const_logic_0) and (start_once_reg = ap_const_logic_0))) then 
            real_start <= ap_const_logic_0;
        else 
            real_start <= ap_start;
        end if; 
    end process;

    start_out <= real_start;

    start_write_assign_proc : process(real_start, start_once_reg)
    begin
        if (((start_once_reg = ap_const_logic_0) and (real_start = ap_const_logic_1))) then 
            start_write <= ap_const_logic_1;
        else 
            start_write <= ap_const_logic_0;
        end if; 
    end process;

end behav;
