-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and OpenCL
-- Version: 2020.2
-- Copyright (C) 1986-2020 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity blackLevelCorrection is
port (
    ap_clk : IN STD_LOGIC;
    ap_rst : IN STD_LOGIC;
    ap_start : IN STD_LOGIC;
    ap_done : OUT STD_LOGIC;
    ap_continue : IN STD_LOGIC;
    ap_idle : OUT STD_LOGIC;
    ap_ready : OUT STD_LOGIC;
    p_Src_rows_dout : IN STD_LOGIC_VECTOR (15 downto 0);
    p_Src_rows_empty_n : IN STD_LOGIC;
    p_Src_rows_read : OUT STD_LOGIC;
    p_Src_cols_dout : IN STD_LOGIC_VECTOR (15 downto 0);
    p_Src_cols_empty_n : IN STD_LOGIC;
    p_Src_cols_read : OUT STD_LOGIC;
    p_Src_data_V_V_dout : IN STD_LOGIC_VECTOR (39 downto 0);
    p_Src_data_V_V_empty_n : IN STD_LOGIC;
    p_Src_data_V_V_read : OUT STD_LOGIC;
    p_Dst_data_V_V_din : OUT STD_LOGIC_VECTOR (39 downto 0);
    p_Dst_data_V_V_full_n : IN STD_LOGIC;
    p_Dst_data_V_V_write : OUT STD_LOGIC );
end;


architecture behav of blackLevelCorrection is 
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_ST_fsm_state1 : STD_LOGIC_VECTOR (3 downto 0) := "0001";
    constant ap_ST_fsm_state2 : STD_LOGIC_VECTOR (3 downto 0) := "0010";
    constant ap_ST_fsm_pp0_stage0 : STD_LOGIC_VECTOR (3 downto 0) := "0100";
    constant ap_ST_fsm_state7 : STD_LOGIC_VECTOR (3 downto 0) := "1000";
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_boolean_1 : BOOLEAN := true;
    constant ap_const_lv32_2 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000010";
    constant ap_const_boolean_0 : BOOLEAN := false;
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_lv32_1 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000001";
    constant ap_const_lv1_1 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_lv30_0 : STD_LOGIC_VECTOR (29 downto 0) := "000000000000000000000000000000";
    constant ap_const_lv32_F : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000001111";
    constant ap_const_lv30_1 : STD_LOGIC_VECTOR (29 downto 0) := "000000000000000000000000000001";
    constant ap_const_lv11_7E0 : STD_LOGIC_VECTOR (10 downto 0) := "11111100000";
    constant ap_const_lv32_5 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000101";
    constant ap_const_lv32_9 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000001001";
    constant ap_const_lv5_0 : STD_LOGIC_VECTOR (4 downto 0) := "00000";
    constant ap_const_lv32_A : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000001010";
    constant ap_const_lv32_13 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000010011";
    constant ap_const_lv32_14 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000010100";
    constant ap_const_lv32_1D : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000011101";
    constant ap_const_lv32_19 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000011001";
    constant ap_const_lv32_1E : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000011110";
    constant ap_const_lv32_27 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000100111";
    constant ap_const_lv32_23 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000100011";
    constant ap_const_lv32_1B : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000011011";
    constant ap_const_lv13_0 : STD_LOGIC_VECTOR (12 downto 0) := "0000000000000";
    constant ap_const_lv32_C : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000001100";
    constant ap_const_lv3_0 : STD_LOGIC_VECTOR (2 downto 0) := "000";
    constant ap_const_lv10_3FF : STD_LOGIC_VECTOR (9 downto 0) := "1111111111";
    constant ap_const_lv28_8422 : STD_LOGIC_VECTOR (27 downto 0) := "0000000000001000010000100010";
    constant ap_const_lv32_3 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000011";

    signal ap_done_reg : STD_LOGIC := '0';
    signal ap_CS_fsm : STD_LOGIC_VECTOR (3 downto 0) := "0001";
    attribute fsm_encoding : string;
    attribute fsm_encoding of ap_CS_fsm : signal is "none";
    signal ap_CS_fsm_state1 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state1 : signal is "none";
    signal p_Src_rows_blk_n : STD_LOGIC;
    signal p_Src_cols_blk_n : STD_LOGIC;
    signal p_Src_data_V_V_blk_n : STD_LOGIC;
    signal ap_CS_fsm_pp0_stage0 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_pp0_stage0 : signal is "none";
    signal ap_enable_reg_pp0_iter1 : STD_LOGIC := '0';
    signal ap_block_pp0_stage0 : BOOLEAN;
    signal icmp_ln69_reg_543 : STD_LOGIC_VECTOR (0 downto 0);
    signal p_Dst_data_V_V_blk_n : STD_LOGIC;
    signal ap_enable_reg_pp0_iter3 : STD_LOGIC := '0';
    signal icmp_ln69_reg_543_pp0_iter2_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal rw_ptr_0_i_reg_121 : STD_LOGIC_VECTOR (29 downto 0);
    signal p_Src_rows_read_reg_528 : STD_LOGIC_VECTOR (15 downto 0);
    signal ap_block_state1 : BOOLEAN;
    signal lshr_ln_reg_533 : STD_LOGIC_VECTOR (13 downto 0);
    signal mul_ln59_fu_494_p2 : STD_LOGIC_VECTOR (29 downto 0);
    signal mul_ln59_reg_538 : STD_LOGIC_VECTOR (29 downto 0);
    signal ap_CS_fsm_state2 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state2 : signal is "none";
    signal icmp_ln69_fu_148_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_block_state3_pp0_stage0_iter0 : BOOLEAN;
    signal ap_block_state4_pp0_stage0_iter1 : BOOLEAN;
    signal ap_block_state5_pp0_stage0_iter2 : BOOLEAN;
    signal ap_block_state6_pp0_stage0_iter3 : BOOLEAN;
    signal ap_block_pp0_stage0_11001 : BOOLEAN;
    signal icmp_ln69_reg_543_pp0_iter1_reg : STD_LOGIC_VECTOR (0 downto 0);
    signal rw_ptr_fu_153_p2 : STD_LOGIC_VECTOR (29 downto 0);
    signal ap_enable_reg_pp0_iter0 : STD_LOGIC := '0';
    signal add_ln1354_fu_167_p2 : STD_LOGIC_VECTOR (10 downto 0);
    signal add_ln1354_reg_552 : STD_LOGIC_VECTOR (10 downto 0);
    signal icmp_ln887_fu_183_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln887_reg_557 : STD_LOGIC_VECTOR (0 downto 0);
    signal add_ln1354_1_fu_203_p2 : STD_LOGIC_VECTOR (10 downto 0);
    signal add_ln1354_1_reg_562 : STD_LOGIC_VECTOR (10 downto 0);
    signal icmp_ln887_32_fu_219_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln887_32_reg_567 : STD_LOGIC_VECTOR (0 downto 0);
    signal add_ln1354_2_fu_239_p2 : STD_LOGIC_VECTOR (10 downto 0);
    signal add_ln1354_2_reg_572 : STD_LOGIC_VECTOR (10 downto 0);
    signal icmp_ln887_33_fu_255_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln887_33_reg_577 : STD_LOGIC_VECTOR (0 downto 0);
    signal add_ln1354_3_fu_275_p2 : STD_LOGIC_VECTOR (10 downto 0);
    signal add_ln1354_3_reg_582 : STD_LOGIC_VECTOR (10 downto 0);
    signal icmp_ln887_34_fu_291_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal icmp_ln887_34_reg_587 : STD_LOGIC_VECTOR (0 downto 0);
    signal select_ln301_fu_336_p3 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_reg_592 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_12_fu_383_p3 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_12_reg_597 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_13_fu_430_p3 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_13_reg_602 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_14_fu_477_p3 : STD_LOGIC_VECTOR (9 downto 0);
    signal select_ln301_14_reg_607 : STD_LOGIC_VECTOR (9 downto 0);
    signal ap_block_pp0_stage0_subdone : BOOLEAN;
    signal ap_condition_pp0_exit_iter0_state3 : STD_LOGIC;
    signal ap_enable_reg_pp0_iter2 : STD_LOGIC := '0';
    signal ap_block_pp0_stage0_01001 : BOOLEAN;
    signal trunc_ln647_fu_159_p1 : STD_LOGIC_VECTOR (9 downto 0);
    signal zext_ln215_fu_163_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal tmp_156_fu_173_p4 : STD_LOGIC_VECTOR (4 downto 0);
    signal p_Result_78_1_i_fu_189_p4 : STD_LOGIC_VECTOR (9 downto 0);
    signal zext_ln215_30_fu_199_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal tmp_158_fu_209_p4 : STD_LOGIC_VECTOR (4 downto 0);
    signal p_Result_78_2_i_fu_225_p4 : STD_LOGIC_VECTOR (9 downto 0);
    signal zext_ln215_31_fu_235_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal tmp_160_fu_245_p4 : STD_LOGIC_VECTOR (4 downto 0);
    signal p_Result_78_3_i_fu_261_p4 : STD_LOGIC_VECTOR (9 downto 0);
    signal zext_ln215_32_fu_271_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal tmp_162_fu_281_p4 : STD_LOGIC_VECTOR (4 downto 0);
    signal mul_ln1118_fu_500_p2 : STD_LOGIC_VECTOR (27 downto 0);
    signal tmp_fu_300_p4 : STD_LOGIC_VECTOR (12 downto 0);
    signal select_ln887_fu_309_p3 : STD_LOGIC_VECTOR (12 downto 0);
    signal tmp_157_fu_316_p4 : STD_LOGIC_VECTOR (2 downto 0);
    signal icmp_ln23_fu_326_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal trunc_ln301_fu_332_p1 : STD_LOGIC_VECTOR (9 downto 0);
    signal mul_ln1118_32_fu_507_p2 : STD_LOGIC_VECTOR (27 downto 0);
    signal tmp_s_fu_347_p4 : STD_LOGIC_VECTOR (12 downto 0);
    signal select_ln887_4_fu_356_p3 : STD_LOGIC_VECTOR (12 downto 0);
    signal tmp_159_fu_363_p4 : STD_LOGIC_VECTOR (2 downto 0);
    signal icmp_ln23_1_fu_373_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal trunc_ln301_12_fu_379_p1 : STD_LOGIC_VECTOR (9 downto 0);
    signal mul_ln1118_33_fu_514_p2 : STD_LOGIC_VECTOR (27 downto 0);
    signal tmp_75_fu_394_p4 : STD_LOGIC_VECTOR (12 downto 0);
    signal select_ln887_5_fu_403_p3 : STD_LOGIC_VECTOR (12 downto 0);
    signal tmp_161_fu_410_p4 : STD_LOGIC_VECTOR (2 downto 0);
    signal icmp_ln23_2_fu_420_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal trunc_ln301_13_fu_426_p1 : STD_LOGIC_VECTOR (9 downto 0);
    signal mul_ln1118_34_fu_521_p2 : STD_LOGIC_VECTOR (27 downto 0);
    signal tmp_76_fu_441_p4 : STD_LOGIC_VECTOR (12 downto 0);
    signal select_ln887_6_fu_450_p3 : STD_LOGIC_VECTOR (12 downto 0);
    signal tmp_163_fu_457_p4 : STD_LOGIC_VECTOR (2 downto 0);
    signal icmp_ln23_3_fu_467_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal trunc_ln301_14_fu_473_p1 : STD_LOGIC_VECTOR (9 downto 0);
    signal mul_ln59_fu_494_p0 : STD_LOGIC_VECTOR (13 downto 0);
    signal mul_ln59_fu_494_p1 : STD_LOGIC_VECTOR (15 downto 0);
    signal mul_ln1118_fu_500_p0 : STD_LOGIC_VECTOR (16 downto 0);
    signal mul_ln1118_fu_500_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal mul_ln1118_32_fu_507_p0 : STD_LOGIC_VECTOR (16 downto 0);
    signal mul_ln1118_32_fu_507_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal mul_ln1118_33_fu_514_p0 : STD_LOGIC_VECTOR (16 downto 0);
    signal mul_ln1118_33_fu_514_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal mul_ln1118_34_fu_521_p0 : STD_LOGIC_VECTOR (16 downto 0);
    signal mul_ln1118_34_fu_521_p1 : STD_LOGIC_VECTOR (10 downto 0);
    signal ap_CS_fsm_state7 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state7 : signal is "none";
    signal ap_NS_fsm : STD_LOGIC_VECTOR (3 downto 0);
    signal ap_idle_pp0 : STD_LOGIC;
    signal ap_enable_pp0 : STD_LOGIC;
    signal mul_ln1118_32_fu_507_p10 : STD_LOGIC_VECTOR (27 downto 0);
    signal mul_ln1118_33_fu_514_p10 : STD_LOGIC_VECTOR (27 downto 0);
    signal mul_ln1118_34_fu_521_p10 : STD_LOGIC_VECTOR (27 downto 0);
    signal mul_ln1118_fu_500_p10 : STD_LOGIC_VECTOR (27 downto 0);
    signal mul_ln59_fu_494_p00 : STD_LOGIC_VECTOR (29 downto 0);
    signal mul_ln59_fu_494_p10 : STD_LOGIC_VECTOR (29 downto 0);

    component ISPPipeline_accelbkb IS
    generic (
        ID : INTEGER;
        NUM_STAGE : INTEGER;
        din0_WIDTH : INTEGER;
        din1_WIDTH : INTEGER;
        dout_WIDTH : INTEGER );
    port (
        din0 : IN STD_LOGIC_VECTOR (13 downto 0);
        din1 : IN STD_LOGIC_VECTOR (15 downto 0);
        dout : OUT STD_LOGIC_VECTOR (29 downto 0) );
    end component;


    component ISPPipeline_accelcud IS
    generic (
        ID : INTEGER;
        NUM_STAGE : INTEGER;
        din0_WIDTH : INTEGER;
        din1_WIDTH : INTEGER;
        dout_WIDTH : INTEGER );
    port (
        din0 : IN STD_LOGIC_VECTOR (16 downto 0);
        din1 : IN STD_LOGIC_VECTOR (10 downto 0);
        dout : OUT STD_LOGIC_VECTOR (27 downto 0) );
    end component;



begin
    ISPPipeline_accelbkb_U31 : component ISPPipeline_accelbkb
    generic map (
        ID => 1,
        NUM_STAGE => 1,
        din0_WIDTH => 14,
        din1_WIDTH => 16,
        dout_WIDTH => 30)
    port map (
        din0 => mul_ln59_fu_494_p0,
        din1 => mul_ln59_fu_494_p1,
        dout => mul_ln59_fu_494_p2);

    ISPPipeline_accelcud_U32 : component ISPPipeline_accelcud
    generic map (
        ID => 1,
        NUM_STAGE => 1,
        din0_WIDTH => 17,
        din1_WIDTH => 11,
        dout_WIDTH => 28)
    port map (
        din0 => mul_ln1118_fu_500_p0,
        din1 => mul_ln1118_fu_500_p1,
        dout => mul_ln1118_fu_500_p2);

    ISPPipeline_accelcud_U33 : component ISPPipeline_accelcud
    generic map (
        ID => 1,
        NUM_STAGE => 1,
        din0_WIDTH => 17,
        din1_WIDTH => 11,
        dout_WIDTH => 28)
    port map (
        din0 => mul_ln1118_32_fu_507_p0,
        din1 => mul_ln1118_32_fu_507_p1,
        dout => mul_ln1118_32_fu_507_p2);

    ISPPipeline_accelcud_U34 : component ISPPipeline_accelcud
    generic map (
        ID => 1,
        NUM_STAGE => 1,
        din0_WIDTH => 17,
        din1_WIDTH => 11,
        dout_WIDTH => 28)
    port map (
        din0 => mul_ln1118_33_fu_514_p0,
        din1 => mul_ln1118_33_fu_514_p1,
        dout => mul_ln1118_33_fu_514_p2);

    ISPPipeline_accelcud_U35 : component ISPPipeline_accelcud
    generic map (
        ID => 1,
        NUM_STAGE => 1,
        din0_WIDTH => 17,
        din1_WIDTH => 11,
        dout_WIDTH => 28)
    port map (
        din0 => mul_ln1118_34_fu_521_p0,
        din1 => mul_ln1118_34_fu_521_p1,
        dout => mul_ln1118_34_fu_521_p2);





    ap_CS_fsm_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_CS_fsm <= ap_ST_fsm_state1;
            else
                ap_CS_fsm <= ap_NS_fsm;
            end if;
        end if;
    end process;


    ap_done_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_done_reg <= ap_const_logic_0;
            else
                if ((ap_continue = ap_const_logic_1)) then 
                    ap_done_reg <= ap_const_logic_0;
                elsif ((ap_const_logic_1 = ap_CS_fsm_state7)) then 
                    ap_done_reg <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter0_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_enable_reg_pp0_iter0 <= ap_const_logic_0;
            else
                if (((ap_const_logic_1 = ap_CS_fsm_pp0_stage0) and (ap_const_logic_1 = ap_condition_pp0_exit_iter0_state3) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone))) then 
                    ap_enable_reg_pp0_iter0 <= ap_const_logic_0;
                elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
                    ap_enable_reg_pp0_iter0 <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter1_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_enable_reg_pp0_iter1 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then
                    if ((ap_const_logic_1 = ap_condition_pp0_exit_iter0_state3)) then 
                        ap_enable_reg_pp0_iter1 <= (ap_const_logic_1 xor ap_condition_pp0_exit_iter0_state3);
                    elsif ((ap_const_boolean_1 = ap_const_boolean_1)) then 
                        ap_enable_reg_pp0_iter1 <= ap_enable_reg_pp0_iter0;
                    end if;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter2_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_enable_reg_pp0_iter2 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter2 <= ap_enable_reg_pp0_iter1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp0_iter3_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_enable_reg_pp0_iter3 <= ap_const_logic_0;
            else
                if ((ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) then 
                    ap_enable_reg_pp0_iter3 <= ap_enable_reg_pp0_iter2;
                elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
                    ap_enable_reg_pp0_iter3 <= ap_const_logic_0;
                end if; 
            end if;
        end if;
    end process;


    rw_ptr_0_i_reg_121_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln69_fu_148_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0) and (ap_enable_reg_pp0_iter0 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001))) then 
                rw_ptr_0_i_reg_121 <= rw_ptr_fu_153_p2;
            elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
                rw_ptr_0_i_reg_121 <= ap_const_lv30_0;
            end if; 
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln69_reg_543 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001))) then
                add_ln1354_1_reg_562 <= add_ln1354_1_fu_203_p2;
                add_ln1354_2_reg_572 <= add_ln1354_2_fu_239_p2;
                add_ln1354_3_reg_582 <= add_ln1354_3_fu_275_p2;
                add_ln1354_reg_552 <= add_ln1354_fu_167_p2;
                icmp_ln887_32_reg_567 <= icmp_ln887_32_fu_219_p2;
                icmp_ln887_33_reg_577 <= icmp_ln887_33_fu_255_p2;
                icmp_ln887_34_reg_587 <= icmp_ln887_34_fu_291_p2;
                icmp_ln887_reg_557 <= icmp_ln887_fu_183_p2;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_logic_1 = ap_CS_fsm_pp0_stage0) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001))) then
                icmp_ln69_reg_543 <= icmp_ln69_fu_148_p2;
                icmp_ln69_reg_543_pp0_iter1_reg <= icmp_ln69_reg_543;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_boolean_0 = ap_block_pp0_stage0_11001)) then
                icmp_ln69_reg_543_pp0_iter2_reg <= icmp_ln69_reg_543_pp0_iter1_reg;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((not(((ap_start = ap_const_logic_0) or (p_Src_cols_empty_n = ap_const_logic_0) or (p_Src_rows_empty_n = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then
                lshr_ln_reg_533 <= p_Src_cols_dout(15 downto 2);
                p_Src_rows_read_reg_528 <= p_Src_rows_dout;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state2)) then
                mul_ln59_reg_538 <= mul_ln59_fu_494_p2;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln69_reg_543_pp0_iter1_reg = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001))) then
                select_ln301_12_reg_597 <= select_ln301_12_fu_383_p3;
                select_ln301_13_reg_602 <= select_ln301_13_fu_430_p3;
                select_ln301_14_reg_607 <= select_ln301_14_fu_477_p3;
                select_ln301_reg_592 <= select_ln301_fu_336_p3;
            end if;
        end if;
    end process;

    ap_NS_fsm_assign_proc : process (ap_start, ap_done_reg, ap_CS_fsm, ap_CS_fsm_state1, p_Src_rows_empty_n, p_Src_cols_empty_n, ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter3, icmp_ln69_fu_148_p2, ap_enable_reg_pp0_iter0, ap_block_pp0_stage0_subdone, ap_enable_reg_pp0_iter2)
    begin
        case ap_CS_fsm is
            when ap_ST_fsm_state1 => 
                if ((not(((ap_start = ap_const_logic_0) or (p_Src_cols_empty_n = ap_const_logic_0) or (p_Src_rows_empty_n = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then
                    ap_NS_fsm <= ap_ST_fsm_state2;
                else
                    ap_NS_fsm <= ap_ST_fsm_state1;
                end if;
            when ap_ST_fsm_state2 => 
                ap_NS_fsm <= ap_ST_fsm_pp0_stage0;
            when ap_ST_fsm_pp0_stage0 => 
                if ((not(((icmp_ln69_fu_148_p2 = ap_const_lv1_1) and (ap_enable_reg_pp0_iter1 = ap_const_logic_0) and (ap_enable_reg_pp0_iter0 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone))) and not(((ap_enable_reg_pp0_iter3 = ap_const_logic_1) and (ap_enable_reg_pp0_iter2 = ap_const_logic_0) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone))))) then
                    ap_NS_fsm <= ap_ST_fsm_pp0_stage0;
                elsif ((((ap_enable_reg_pp0_iter3 = ap_const_logic_1) and (ap_enable_reg_pp0_iter2 = ap_const_logic_0) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone)) or ((icmp_ln69_fu_148_p2 = ap_const_lv1_1) and (ap_enable_reg_pp0_iter1 = ap_const_logic_0) and (ap_enable_reg_pp0_iter0 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_subdone)))) then
                    ap_NS_fsm <= ap_ST_fsm_state7;
                else
                    ap_NS_fsm <= ap_ST_fsm_pp0_stage0;
                end if;
            when ap_ST_fsm_state7 => 
                ap_NS_fsm <= ap_ST_fsm_state1;
            when others =>  
                ap_NS_fsm <= "XXXX";
        end case;
    end process;
    add_ln1354_1_fu_203_p2 <= std_logic_vector(signed(ap_const_lv11_7E0) + signed(zext_ln215_30_fu_199_p1));
    add_ln1354_2_fu_239_p2 <= std_logic_vector(signed(ap_const_lv11_7E0) + signed(zext_ln215_31_fu_235_p1));
    add_ln1354_3_fu_275_p2 <= std_logic_vector(signed(ap_const_lv11_7E0) + signed(zext_ln215_32_fu_271_p1));
    add_ln1354_fu_167_p2 <= std_logic_vector(signed(ap_const_lv11_7E0) + signed(zext_ln215_fu_163_p1));
    ap_CS_fsm_pp0_stage0 <= ap_CS_fsm(2);
    ap_CS_fsm_state1 <= ap_CS_fsm(0);
    ap_CS_fsm_state2 <= ap_CS_fsm(1);
    ap_CS_fsm_state7 <= ap_CS_fsm(3);
        ap_block_pp0_stage0 <= not((ap_const_boolean_1 = ap_const_boolean_1));

    ap_block_pp0_stage0_01001_assign_proc : process(p_Src_data_V_V_empty_n, p_Dst_data_V_V_full_n, ap_enable_reg_pp0_iter1, icmp_ln69_reg_543, ap_enable_reg_pp0_iter3, icmp_ln69_reg_543_pp0_iter2_reg)
    begin
                ap_block_pp0_stage0_01001 <= (((icmp_ln69_reg_543_pp0_iter2_reg = ap_const_lv1_0) and (p_Dst_data_V_V_full_n = ap_const_logic_0) and (ap_enable_reg_pp0_iter3 = ap_const_logic_1)) or ((icmp_ln69_reg_543 = ap_const_lv1_0) and (p_Src_data_V_V_empty_n = ap_const_logic_0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1)));
    end process;


    ap_block_pp0_stage0_11001_assign_proc : process(p_Src_data_V_V_empty_n, p_Dst_data_V_V_full_n, ap_enable_reg_pp0_iter1, icmp_ln69_reg_543, ap_enable_reg_pp0_iter3, icmp_ln69_reg_543_pp0_iter2_reg)
    begin
                ap_block_pp0_stage0_11001 <= (((icmp_ln69_reg_543_pp0_iter2_reg = ap_const_lv1_0) and (p_Dst_data_V_V_full_n = ap_const_logic_0) and (ap_enable_reg_pp0_iter3 = ap_const_logic_1)) or ((icmp_ln69_reg_543 = ap_const_lv1_0) and (p_Src_data_V_V_empty_n = ap_const_logic_0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1)));
    end process;


    ap_block_pp0_stage0_subdone_assign_proc : process(p_Src_data_V_V_empty_n, p_Dst_data_V_V_full_n, ap_enable_reg_pp0_iter1, icmp_ln69_reg_543, ap_enable_reg_pp0_iter3, icmp_ln69_reg_543_pp0_iter2_reg)
    begin
                ap_block_pp0_stage0_subdone <= (((icmp_ln69_reg_543_pp0_iter2_reg = ap_const_lv1_0) and (p_Dst_data_V_V_full_n = ap_const_logic_0) and (ap_enable_reg_pp0_iter3 = ap_const_logic_1)) or ((icmp_ln69_reg_543 = ap_const_lv1_0) and (p_Src_data_V_V_empty_n = ap_const_logic_0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1)));
    end process;


    ap_block_state1_assign_proc : process(ap_start, ap_done_reg, p_Src_rows_empty_n, p_Src_cols_empty_n)
    begin
                ap_block_state1 <= ((ap_start = ap_const_logic_0) or (p_Src_cols_empty_n = ap_const_logic_0) or (p_Src_rows_empty_n = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1));
    end process;

        ap_block_state3_pp0_stage0_iter0 <= not((ap_const_boolean_1 = ap_const_boolean_1));

    ap_block_state4_pp0_stage0_iter1_assign_proc : process(p_Src_data_V_V_empty_n, icmp_ln69_reg_543)
    begin
                ap_block_state4_pp0_stage0_iter1 <= ((icmp_ln69_reg_543 = ap_const_lv1_0) and (p_Src_data_V_V_empty_n = ap_const_logic_0));
    end process;

        ap_block_state5_pp0_stage0_iter2 <= not((ap_const_boolean_1 = ap_const_boolean_1));

    ap_block_state6_pp0_stage0_iter3_assign_proc : process(p_Dst_data_V_V_full_n, icmp_ln69_reg_543_pp0_iter2_reg)
    begin
                ap_block_state6_pp0_stage0_iter3 <= ((icmp_ln69_reg_543_pp0_iter2_reg = ap_const_lv1_0) and (p_Dst_data_V_V_full_n = ap_const_logic_0));
    end process;


    ap_condition_pp0_exit_iter0_state3_assign_proc : process(icmp_ln69_fu_148_p2)
    begin
        if ((icmp_ln69_fu_148_p2 = ap_const_lv1_1)) then 
            ap_condition_pp0_exit_iter0_state3 <= ap_const_logic_1;
        else 
            ap_condition_pp0_exit_iter0_state3 <= ap_const_logic_0;
        end if; 
    end process;


    ap_done_assign_proc : process(ap_done_reg, ap_CS_fsm_state7)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state7)) then 
            ap_done <= ap_const_logic_1;
        else 
            ap_done <= ap_done_reg;
        end if; 
    end process;

    ap_enable_pp0 <= (ap_idle_pp0 xor ap_const_logic_1);

    ap_idle_assign_proc : process(ap_start, ap_CS_fsm_state1)
    begin
        if (((ap_start = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ap_idle <= ap_const_logic_1;
        else 
            ap_idle <= ap_const_logic_0;
        end if; 
    end process;


    ap_idle_pp0_assign_proc : process(ap_enable_reg_pp0_iter1, ap_enable_reg_pp0_iter3, ap_enable_reg_pp0_iter0, ap_enable_reg_pp0_iter2)
    begin
        if (((ap_enable_reg_pp0_iter3 = ap_const_logic_0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_0) and (ap_enable_reg_pp0_iter2 = ap_const_logic_0) and (ap_enable_reg_pp0_iter0 = ap_const_logic_0))) then 
            ap_idle_pp0 <= ap_const_logic_1;
        else 
            ap_idle_pp0 <= ap_const_logic_0;
        end if; 
    end process;


    ap_ready_assign_proc : process(ap_CS_fsm_state7)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state7)) then 
            ap_ready <= ap_const_logic_1;
        else 
            ap_ready <= ap_const_logic_0;
        end if; 
    end process;

    icmp_ln23_1_fu_373_p2 <= "0" when (tmp_159_fu_363_p4 = ap_const_lv3_0) else "1";
    icmp_ln23_2_fu_420_p2 <= "0" when (tmp_161_fu_410_p4 = ap_const_lv3_0) else "1";
    icmp_ln23_3_fu_467_p2 <= "0" when (tmp_163_fu_457_p4 = ap_const_lv3_0) else "1";
    icmp_ln23_fu_326_p2 <= "0" when (tmp_157_fu_316_p4 = ap_const_lv3_0) else "1";
    icmp_ln69_fu_148_p2 <= "1" when (rw_ptr_0_i_reg_121 = mul_ln59_reg_538) else "0";
    icmp_ln887_32_fu_219_p2 <= "1" when (tmp_158_fu_209_p4 = ap_const_lv5_0) else "0";
    icmp_ln887_33_fu_255_p2 <= "1" when (tmp_160_fu_245_p4 = ap_const_lv5_0) else "0";
    icmp_ln887_34_fu_291_p2 <= "1" when (tmp_162_fu_281_p4 = ap_const_lv5_0) else "0";
    icmp_ln887_fu_183_p2 <= "1" when (tmp_156_fu_173_p4 = ap_const_lv5_0) else "0";
    mul_ln1118_32_fu_507_p0 <= ap_const_lv28_8422(17 - 1 downto 0);
    mul_ln1118_32_fu_507_p1 <= mul_ln1118_32_fu_507_p10(11 - 1 downto 0);
    mul_ln1118_32_fu_507_p10 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(add_ln1354_1_reg_562),28));
    mul_ln1118_33_fu_514_p0 <= ap_const_lv28_8422(17 - 1 downto 0);
    mul_ln1118_33_fu_514_p1 <= mul_ln1118_33_fu_514_p10(11 - 1 downto 0);
    mul_ln1118_33_fu_514_p10 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(add_ln1354_2_reg_572),28));
    mul_ln1118_34_fu_521_p0 <= ap_const_lv28_8422(17 - 1 downto 0);
    mul_ln1118_34_fu_521_p1 <= mul_ln1118_34_fu_521_p10(11 - 1 downto 0);
    mul_ln1118_34_fu_521_p10 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(add_ln1354_3_reg_582),28));
    mul_ln1118_fu_500_p0 <= ap_const_lv28_8422(17 - 1 downto 0);
    mul_ln1118_fu_500_p1 <= mul_ln1118_fu_500_p10(11 - 1 downto 0);
    mul_ln1118_fu_500_p10 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(add_ln1354_reg_552),28));
    mul_ln59_fu_494_p0 <= mul_ln59_fu_494_p00(14 - 1 downto 0);
    mul_ln59_fu_494_p00 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(lshr_ln_reg_533),30));
    mul_ln59_fu_494_p1 <= mul_ln59_fu_494_p10(16 - 1 downto 0);
    mul_ln59_fu_494_p10 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(p_Src_rows_read_reg_528),30));

    p_Dst_data_V_V_blk_n_assign_proc : process(p_Dst_data_V_V_full_n, ap_block_pp0_stage0, ap_enable_reg_pp0_iter3, icmp_ln69_reg_543_pp0_iter2_reg)
    begin
        if (((icmp_ln69_reg_543_pp0_iter2_reg = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp0_stage0) and (ap_enable_reg_pp0_iter3 = ap_const_logic_1))) then 
            p_Dst_data_V_V_blk_n <= p_Dst_data_V_V_full_n;
        else 
            p_Dst_data_V_V_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    p_Dst_data_V_V_din <= (((select_ln301_14_reg_607 & select_ln301_13_reg_602) & select_ln301_12_reg_597) & select_ln301_reg_592);

    p_Dst_data_V_V_write_assign_proc : process(ap_enable_reg_pp0_iter3, icmp_ln69_reg_543_pp0_iter2_reg, ap_block_pp0_stage0_11001)
    begin
        if (((icmp_ln69_reg_543_pp0_iter2_reg = ap_const_lv1_0) and (ap_enable_reg_pp0_iter3 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001))) then 
            p_Dst_data_V_V_write <= ap_const_logic_1;
        else 
            p_Dst_data_V_V_write <= ap_const_logic_0;
        end if; 
    end process;

    p_Result_78_1_i_fu_189_p4 <= p_Src_data_V_V_dout(19 downto 10);
    p_Result_78_2_i_fu_225_p4 <= p_Src_data_V_V_dout(29 downto 20);
    p_Result_78_3_i_fu_261_p4 <= p_Src_data_V_V_dout(39 downto 30);

    p_Src_cols_blk_n_assign_proc : process(ap_start, ap_done_reg, ap_CS_fsm_state1, p_Src_cols_empty_n)
    begin
        if ((not(((ap_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            p_Src_cols_blk_n <= p_Src_cols_empty_n;
        else 
            p_Src_cols_blk_n <= ap_const_logic_1;
        end if; 
    end process;


    p_Src_cols_read_assign_proc : process(ap_start, ap_done_reg, ap_CS_fsm_state1, p_Src_rows_empty_n, p_Src_cols_empty_n)
    begin
        if ((not(((ap_start = ap_const_logic_0) or (p_Src_cols_empty_n = ap_const_logic_0) or (p_Src_rows_empty_n = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            p_Src_cols_read <= ap_const_logic_1;
        else 
            p_Src_cols_read <= ap_const_logic_0;
        end if; 
    end process;


    p_Src_data_V_V_blk_n_assign_proc : process(p_Src_data_V_V_empty_n, ap_CS_fsm_pp0_stage0, ap_enable_reg_pp0_iter1, ap_block_pp0_stage0, icmp_ln69_reg_543)
    begin
        if (((icmp_ln69_reg_543 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp0_stage0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0))) then 
            p_Src_data_V_V_blk_n <= p_Src_data_V_V_empty_n;
        else 
            p_Src_data_V_V_blk_n <= ap_const_logic_1;
        end if; 
    end process;


    p_Src_data_V_V_read_assign_proc : process(ap_CS_fsm_pp0_stage0, ap_enable_reg_pp0_iter1, icmp_ln69_reg_543, ap_block_pp0_stage0_11001)
    begin
        if (((icmp_ln69_reg_543 = ap_const_lv1_0) and (ap_enable_reg_pp0_iter1 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp0_stage0) and (ap_const_boolean_0 = ap_block_pp0_stage0_11001))) then 
            p_Src_data_V_V_read <= ap_const_logic_1;
        else 
            p_Src_data_V_V_read <= ap_const_logic_0;
        end if; 
    end process;


    p_Src_rows_blk_n_assign_proc : process(ap_start, ap_done_reg, ap_CS_fsm_state1, p_Src_rows_empty_n)
    begin
        if ((not(((ap_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            p_Src_rows_blk_n <= p_Src_rows_empty_n;
        else 
            p_Src_rows_blk_n <= ap_const_logic_1;
        end if; 
    end process;


    p_Src_rows_read_assign_proc : process(ap_start, ap_done_reg, ap_CS_fsm_state1, p_Src_rows_empty_n, p_Src_cols_empty_n)
    begin
        if ((not(((ap_start = ap_const_logic_0) or (p_Src_cols_empty_n = ap_const_logic_0) or (p_Src_rows_empty_n = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            p_Src_rows_read <= ap_const_logic_1;
        else 
            p_Src_rows_read <= ap_const_logic_0;
        end if; 
    end process;

    rw_ptr_fu_153_p2 <= std_logic_vector(unsigned(rw_ptr_0_i_reg_121) + unsigned(ap_const_lv30_1));
    select_ln301_12_fu_383_p3 <= 
        ap_const_lv10_3FF when (icmp_ln23_1_fu_373_p2(0) = '1') else 
        trunc_ln301_12_fu_379_p1;
    select_ln301_13_fu_430_p3 <= 
        ap_const_lv10_3FF when (icmp_ln23_2_fu_420_p2(0) = '1') else 
        trunc_ln301_13_fu_426_p1;
    select_ln301_14_fu_477_p3 <= 
        ap_const_lv10_3FF when (icmp_ln23_3_fu_467_p2(0) = '1') else 
        trunc_ln301_14_fu_473_p1;
    select_ln301_fu_336_p3 <= 
        ap_const_lv10_3FF when (icmp_ln23_fu_326_p2(0) = '1') else 
        trunc_ln301_fu_332_p1;
    select_ln887_4_fu_356_p3 <= 
        ap_const_lv13_0 when (icmp_ln887_32_reg_567(0) = '1') else 
        tmp_s_fu_347_p4;
    select_ln887_5_fu_403_p3 <= 
        ap_const_lv13_0 when (icmp_ln887_33_reg_577(0) = '1') else 
        tmp_75_fu_394_p4;
    select_ln887_6_fu_450_p3 <= 
        ap_const_lv13_0 when (icmp_ln887_34_reg_587(0) = '1') else 
        tmp_76_fu_441_p4;
    select_ln887_fu_309_p3 <= 
        ap_const_lv13_0 when (icmp_ln887_reg_557(0) = '1') else 
        tmp_fu_300_p4;
    tmp_156_fu_173_p4 <= p_Src_data_V_V_dout(9 downto 5);
    tmp_157_fu_316_p4 <= select_ln887_fu_309_p3(12 downto 10);
    tmp_158_fu_209_p4 <= p_Src_data_V_V_dout(19 downto 15);
    tmp_159_fu_363_p4 <= select_ln887_4_fu_356_p3(12 downto 10);
    tmp_160_fu_245_p4 <= p_Src_data_V_V_dout(29 downto 25);
    tmp_161_fu_410_p4 <= select_ln887_5_fu_403_p3(12 downto 10);
    tmp_162_fu_281_p4 <= p_Src_data_V_V_dout(39 downto 35);
    tmp_163_fu_457_p4 <= select_ln887_6_fu_450_p3(12 downto 10);
    tmp_75_fu_394_p4 <= mul_ln1118_33_fu_514_p2(27 downto 15);
    tmp_76_fu_441_p4 <= mul_ln1118_34_fu_521_p2(27 downto 15);
    tmp_fu_300_p4 <= mul_ln1118_fu_500_p2(27 downto 15);
    tmp_s_fu_347_p4 <= mul_ln1118_32_fu_507_p2(27 downto 15);
    trunc_ln301_12_fu_379_p1 <= select_ln887_4_fu_356_p3(10 - 1 downto 0);
    trunc_ln301_13_fu_426_p1 <= select_ln887_5_fu_403_p3(10 - 1 downto 0);
    trunc_ln301_14_fu_473_p1 <= select_ln887_6_fu_450_p3(10 - 1 downto 0);
    trunc_ln301_fu_332_p1 <= select_ln887_fu_309_p3(10 - 1 downto 0);
    trunc_ln647_fu_159_p1 <= p_Src_data_V_V_dout(10 - 1 downto 0);
    zext_ln215_30_fu_199_p1 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(p_Result_78_1_i_fu_189_p4),11));
    zext_ln215_31_fu_235_p1 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(p_Result_78_2_i_fu_225_p4),11));
    zext_ln215_32_fu_271_p1 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(p_Result_78_3_i_fu_261_p4),11));
    zext_ln215_fu_163_p1 <= std_logic_vector(IEEE.numeric_std.resize(unsigned(trunc_ln647_fu_159_p1),11));
end behav;
