-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and OpenCL
-- Version: 2020.2
-- Copyright (C) 1986-2020 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity ISPPipeline_accel is
generic (
    C_S_AXI_CTRL_ADDR_WIDTH : INTEGER := 6;
    C_S_AXI_CTRL_DATA_WIDTH : INTEGER := 32 );
port (
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    s_axis_video_TDATA : IN STD_LOGIC_VECTOR (39 downto 0);
    s_axis_video_TVALID : IN STD_LOGIC;
    s_axis_video_TREADY : OUT STD_LOGIC;
    s_axis_video_TKEEP : IN STD_LOGIC_VECTOR (4 downto 0);
    s_axis_video_TSTRB : IN STD_LOGIC_VECTOR (4 downto 0);
    s_axis_video_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
    s_axis_video_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
    s_axis_video_TID : IN STD_LOGIC_VECTOR (0 downto 0);
    s_axis_video_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
    m_axis_video_TDATA : OUT STD_LOGIC_VECTOR (95 downto 0);
    m_axis_video_TVALID : OUT STD_LOGIC;
    m_axis_video_TREADY : IN STD_LOGIC;
    m_axis_video_TKEEP : OUT STD_LOGIC_VECTOR (11 downto 0);
    m_axis_video_TSTRB : OUT STD_LOGIC_VECTOR (11 downto 0);
    m_axis_video_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
    m_axis_video_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
    m_axis_video_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
    m_axis_video_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0);
    s_axi_CTRL_AWVALID : IN STD_LOGIC;
    s_axi_CTRL_AWREADY : OUT STD_LOGIC;
    s_axi_CTRL_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_ADDR_WIDTH-1 downto 0);
    s_axi_CTRL_WVALID : IN STD_LOGIC;
    s_axi_CTRL_WREADY : OUT STD_LOGIC;
    s_axi_CTRL_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_DATA_WIDTH-1 downto 0);
    s_axi_CTRL_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_DATA_WIDTH/8-1 downto 0);
    s_axi_CTRL_ARVALID : IN STD_LOGIC;
    s_axi_CTRL_ARREADY : OUT STD_LOGIC;
    s_axi_CTRL_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_CTRL_ADDR_WIDTH-1 downto 0);
    s_axi_CTRL_RVALID : OUT STD_LOGIC;
    s_axi_CTRL_RREADY : IN STD_LOGIC;
    s_axi_CTRL_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_CTRL_DATA_WIDTH-1 downto 0);
    s_axi_CTRL_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_CTRL_BVALID : OUT STD_LOGIC;
    s_axi_CTRL_BREADY : IN STD_LOGIC;
    s_axi_CTRL_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    interrupt : OUT STD_LOGIC );
end;


architecture behav of ISPPipeline_accel is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "ISPPipeline_accel,hls_ip_2020_2,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=0,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xcvc1902-vsva2197-1LP-e-S-es1,HLS_INPUT_CLOCK=5.000000,HLS_INPUT_ARCH=others,HLS_SYN_CLOCK=17.051000,HLS_SYN_LAT=-1,HLS_SYN_TPT=none,HLS_SYN_MEM=127,HLS_SYN_DSP=0,HLS_SYN_FF=49745,HLS_SYN_LUT=47474,HLS_VERSION=2020_2}";
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_ST_fsm_state1 : STD_LOGIC_VECTOR (3 downto 0) := "0001";
    constant ap_ST_fsm_state2 : STD_LOGIC_VECTOR (3 downto 0) := "0010";
    constant ap_ST_fsm_state3 : STD_LOGIC_VECTOR (3 downto 0) := "0100";
    constant ap_ST_fsm_state4 : STD_LOGIC_VECTOR (3 downto 0) := "1000";
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant C_S_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant ap_const_lv1_1 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_lv32_1 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000001";
    constant ap_const_boolean_0 : BOOLEAN := false;
    constant ap_const_lv32_2 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000010";
    constant ap_const_lv32_3 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000011";
    constant ap_const_boolean_1 : BOOLEAN := true;

    signal ap_rst_n_inv : STD_LOGIC;
    signal ap_start : STD_LOGIC;
    signal ap_done : STD_LOGIC;
    signal ap_idle : STD_LOGIC;
    signal ap_CS_fsm : STD_LOGIC_VECTOR (3 downto 0) := "0001";
    attribute fsm_encoding : string;
    attribute fsm_encoding of ap_CS_fsm : signal is "none";
    signal ap_CS_fsm_state1 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state1 : signal is "none";
    signal ap_ready : STD_LOGIC;
    signal width : STD_LOGIC_VECTOR (15 downto 0);
    signal height : STD_LOGIC_VECTOR (15 downto 0);
    signal bayer_phase : STD_LOGIC_VECTOR (15 downto 0);
    signal flag : STD_LOGIC_VECTOR (0 downto 0) := "0";
    signal hist0_0_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal hist0_0_ce0 : STD_LOGIC;
    signal hist0_0_we0 : STD_LOGIC;
    signal hist0_0_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal hist0_1_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal hist0_1_ce0 : STD_LOGIC;
    signal hist0_1_we0 : STD_LOGIC;
    signal hist0_1_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal hist0_2_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal hist0_2_ce0 : STD_LOGIC;
    signal hist0_2_we0 : STD_LOGIC;
    signal hist0_2_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal hist1_0_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal hist1_0_ce0 : STD_LOGIC;
    signal hist1_0_we0 : STD_LOGIC;
    signal hist1_0_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal hist1_1_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal hist1_1_ce0 : STD_LOGIC;
    signal hist1_1_we0 : STD_LOGIC;
    signal hist1_1_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal hist1_2_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal hist1_2_ce0 : STD_LOGIC;
    signal hist1_2_we0 : STD_LOGIC;
    signal hist1_2_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal height_read_reg_173 : STD_LOGIC_VECTOR (15 downto 0);
    signal width_read_reg_178 : STD_LOGIC_VECTOR (15 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TDATA : STD_LOGIC_VECTOR (95 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TKEEP : STD_LOGIC_VECTOR (11 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TSTRB : STD_LOGIC_VECTOR (11 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TLAST : STD_LOGIC_VECTOR (0 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TID : STD_LOGIC_VECTOR (0 downto 0);
    signal grp_ISPpipeline_fu_109_m_axis_video_TDEST : STD_LOGIC_VECTOR (0 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_0_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_0_ce0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_0_d0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_0_we0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_0_address1 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_0_ce1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_0_d1 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_0_we1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_1_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_1_ce0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_1_d0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_1_we0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_1_address1 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_1_ce1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_1_d1 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_1_we1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_2_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_2_ce0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_2_d0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_2_we0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_2_address1 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_2_ce1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist0_2_d1 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist0_2_we1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_0_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_0_ce0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_0_d0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_0_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_0_we0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_0_address1 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_0_ce1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_0_d1 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_0_we1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_1_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_1_ce0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_1_d0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_1_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_1_we0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_1_address1 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_1_ce1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_1_d1 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_1_we1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_2_address0 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_2_ce0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_2_d0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_2_q0 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_2_we0 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_2_address1 : STD_LOGIC_VECTOR (9 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_2_ce1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_hist1_2_d1 : STD_LOGIC_VECTOR (31 downto 0);
    signal grp_ISPpipeline_fu_109_hist1_2_we1 : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_ap_start : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_s_axis_video_TREADY : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_ap_done : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_m_axis_video_TVALID : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_m_axis_video_TREADY : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_ap_ready : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_ap_idle : STD_LOGIC;
    signal grp_ISPpipeline_fu_109_ap_continue : STD_LOGIC;
    signal storemerge_reg_96 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_CS_fsm_state2 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state2 : signal is "none";
    signal ap_sync_grp_ISPpipeline_fu_109_ap_ready : STD_LOGIC;
    signal ap_sync_grp_ISPpipeline_fu_109_ap_done : STD_LOGIC;
    signal ap_block_state2_on_subcall_done : BOOLEAN;
    signal ap_CS_fsm_state3 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state3 : signal is "none";
    signal ap_block_state3_on_subcall_done : BOOLEAN;
    signal grp_ISPpipeline_fu_109_ap_start_reg : STD_LOGIC := '0';
    signal flag_load_load_fu_163_p1 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_sync_reg_grp_ISPpipeline_fu_109_ap_ready : STD_LOGIC := '0';
    signal ap_sync_reg_grp_ISPpipeline_fu_109_ap_done : STD_LOGIC := '0';
    signal ap_CS_fsm_state4 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state4 : signal is "none";
    signal regslice_both_m_axis_video_V_data_V_U_apdone_blk : STD_LOGIC;
    signal ap_NS_fsm : STD_LOGIC_VECTOR (3 downto 0);
    signal regslice_both_s_axis_video_V_data_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TDATA_int : STD_LOGIC_VECTOR (39 downto 0);
    signal s_axis_video_TVALID_int : STD_LOGIC;
    signal s_axis_video_TREADY_int : STD_LOGIC;
    signal regslice_both_s_axis_video_V_data_V_U_ack_in : STD_LOGIC;
    signal regslice_both_s_axis_video_V_keep_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TKEEP_int : STD_LOGIC_VECTOR (4 downto 0);
    signal regslice_both_s_axis_video_V_keep_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_axis_video_V_keep_V_U_ack_in : STD_LOGIC;
    signal regslice_both_s_axis_video_V_strb_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TSTRB_int : STD_LOGIC_VECTOR (4 downto 0);
    signal regslice_both_s_axis_video_V_strb_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_axis_video_V_strb_V_U_ack_in : STD_LOGIC;
    signal regslice_both_s_axis_video_V_user_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TUSER_int : STD_LOGIC_VECTOR (0 downto 0);
    signal regslice_both_s_axis_video_V_user_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_axis_video_V_user_V_U_ack_in : STD_LOGIC;
    signal regslice_both_s_axis_video_V_last_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TLAST_int : STD_LOGIC_VECTOR (0 downto 0);
    signal regslice_both_s_axis_video_V_last_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_axis_video_V_last_V_U_ack_in : STD_LOGIC;
    signal regslice_both_s_axis_video_V_id_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TID_int : STD_LOGIC_VECTOR (0 downto 0);
    signal regslice_both_s_axis_video_V_id_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_axis_video_V_id_V_U_ack_in : STD_LOGIC;
    signal regslice_both_s_axis_video_V_dest_V_U_apdone_blk : STD_LOGIC;
    signal s_axis_video_TDEST_int : STD_LOGIC_VECTOR (0 downto 0);
    signal regslice_both_s_axis_video_V_dest_V_U_vld_out : STD_LOGIC;
    signal regslice_both_s_axis_video_V_dest_V_U_ack_in : STD_LOGIC;
    signal m_axis_video_TVALID_int : STD_LOGIC;
    signal m_axis_video_TREADY_int : STD_LOGIC;
    signal regslice_both_m_axis_video_V_data_V_U_vld_out : STD_LOGIC;
    signal regslice_both_m_axis_video_V_keep_V_U_apdone_blk : STD_LOGIC;
    signal regslice_both_m_axis_video_V_keep_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_m_axis_video_V_keep_V_U_vld_out : STD_LOGIC;
    signal regslice_both_m_axis_video_V_strb_V_U_apdone_blk : STD_LOGIC;
    signal regslice_both_m_axis_video_V_strb_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_m_axis_video_V_strb_V_U_vld_out : STD_LOGIC;
    signal regslice_both_m_axis_video_V_user_V_U_apdone_blk : STD_LOGIC;
    signal regslice_both_m_axis_video_V_user_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_m_axis_video_V_user_V_U_vld_out : STD_LOGIC;
    signal regslice_both_m_axis_video_V_last_V_U_apdone_blk : STD_LOGIC;
    signal regslice_both_m_axis_video_V_last_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_m_axis_video_V_last_V_U_vld_out : STD_LOGIC;
    signal regslice_both_m_axis_video_V_id_V_U_apdone_blk : STD_LOGIC;
    signal regslice_both_m_axis_video_V_id_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_m_axis_video_V_id_V_U_vld_out : STD_LOGIC;
    signal regslice_both_m_axis_video_V_dest_V_U_apdone_blk : STD_LOGIC;
    signal regslice_both_m_axis_video_V_dest_V_U_ack_in_dummy : STD_LOGIC;
    signal regslice_both_m_axis_video_V_dest_V_U_vld_out : STD_LOGIC;

    component ISPpipeline IS
    port (
        s_axis_video_TDATA : IN STD_LOGIC_VECTOR (39 downto 0);
        s_axis_video_TKEEP : IN STD_LOGIC_VECTOR (4 downto 0);
        s_axis_video_TSTRB : IN STD_LOGIC_VECTOR (4 downto 0);
        s_axis_video_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        s_axis_video_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
        s_axis_video_TID : IN STD_LOGIC_VECTOR (0 downto 0);
        s_axis_video_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axis_video_TDATA : OUT STD_LOGIC_VECTOR (95 downto 0);
        m_axis_video_TKEEP : OUT STD_LOGIC_VECTOR (11 downto 0);
        m_axis_video_TSTRB : OUT STD_LOGIC_VECTOR (11 downto 0);
        m_axis_video_TUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axis_video_TLAST : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axis_video_TID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axis_video_TDEST : OUT STD_LOGIC_VECTOR (0 downto 0);
        height : IN STD_LOGIC_VECTOR (15 downto 0);
        width : IN STD_LOGIC_VECTOR (15 downto 0);
        hist0_0_address0 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist0_0_ce0 : OUT STD_LOGIC;
        hist0_0_d0 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist0_0_q0 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist0_0_we0 : OUT STD_LOGIC;
        hist0_0_address1 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist0_0_ce1 : OUT STD_LOGIC;
        hist0_0_d1 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist0_0_q1 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist0_0_we1 : OUT STD_LOGIC;
        hist0_1_address0 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist0_1_ce0 : OUT STD_LOGIC;
        hist0_1_d0 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist0_1_q0 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist0_1_we0 : OUT STD_LOGIC;
        hist0_1_address1 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist0_1_ce1 : OUT STD_LOGIC;
        hist0_1_d1 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist0_1_q1 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist0_1_we1 : OUT STD_LOGIC;
        hist0_2_address0 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist0_2_ce0 : OUT STD_LOGIC;
        hist0_2_d0 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist0_2_q0 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist0_2_we0 : OUT STD_LOGIC;
        hist0_2_address1 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist0_2_ce1 : OUT STD_LOGIC;
        hist0_2_d1 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist0_2_q1 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist0_2_we1 : OUT STD_LOGIC;
        hist1_0_address0 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist1_0_ce0 : OUT STD_LOGIC;
        hist1_0_d0 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist1_0_q0 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist1_0_we0 : OUT STD_LOGIC;
        hist1_0_address1 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist1_0_ce1 : OUT STD_LOGIC;
        hist1_0_d1 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist1_0_q1 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist1_0_we1 : OUT STD_LOGIC;
        hist1_1_address0 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist1_1_ce0 : OUT STD_LOGIC;
        hist1_1_d0 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist1_1_q0 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist1_1_we0 : OUT STD_LOGIC;
        hist1_1_address1 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist1_1_ce1 : OUT STD_LOGIC;
        hist1_1_d1 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist1_1_q1 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist1_1_we1 : OUT STD_LOGIC;
        hist1_2_address0 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist1_2_ce0 : OUT STD_LOGIC;
        hist1_2_d0 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist1_2_q0 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist1_2_we0 : OUT STD_LOGIC;
        hist1_2_address1 : OUT STD_LOGIC_VECTOR (9 downto 0);
        hist1_2_ce1 : OUT STD_LOGIC;
        hist1_2_d1 : OUT STD_LOGIC_VECTOR (31 downto 0);
        hist1_2_q1 : IN STD_LOGIC_VECTOR (31 downto 0);
        hist1_2_we1 : OUT STD_LOGIC;
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        height_ap_vld : IN STD_LOGIC;
        width_ap_vld : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        s_axis_video_TVALID : IN STD_LOGIC;
        s_axis_video_TREADY : OUT STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        m_axis_video_TVALID : OUT STD_LOGIC;
        m_axis_video_TREADY : IN STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC );
    end component;


    component ISPPipeline_accelbml IS
    generic (
        DataWidth : INTEGER;
        AddressRange : INTEGER;
        AddressWidth : INTEGER );
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR (9 downto 0);
        ce0 : IN STD_LOGIC;
        we0 : IN STD_LOGIC;
        d0 : IN STD_LOGIC_VECTOR (31 downto 0);
        q0 : OUT STD_LOGIC_VECTOR (31 downto 0) );
    end component;


    component ISPPipeline_accel_CTRL_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        width : OUT STD_LOGIC_VECTOR (15 downto 0);
        height : OUT STD_LOGIC_VECTOR (15 downto 0);
        bayer_phase : OUT STD_LOGIC_VECTOR (15 downto 0);
        ap_start : OUT STD_LOGIC;
        interrupt : OUT STD_LOGIC;
        ap_ready : IN STD_LOGIC;
        ap_done : IN STD_LOGIC;
        ap_idle : IN STD_LOGIC );
    end component;


    component regslice_both IS
    generic (
        DataWidth : INTEGER );
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        data_in : IN STD_LOGIC_VECTOR (DataWidth-1 downto 0);
        vld_in : IN STD_LOGIC;
        ack_in : OUT STD_LOGIC;
        data_out : OUT STD_LOGIC_VECTOR (DataWidth-1 downto 0);
        vld_out : OUT STD_LOGIC;
        ack_out : IN STD_LOGIC;
        apdone_blk : OUT STD_LOGIC );
    end component;



begin
    hist0_0_U : component ISPPipeline_accelbml
    generic map (
        DataWidth => 32,
        AddressRange => 1024,
        AddressWidth => 10)
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        address0 => hist0_0_address0,
        ce0 => hist0_0_ce0,
        we0 => hist0_0_we0,
        d0 => grp_ISPpipeline_fu_109_hist0_0_d0,
        q0 => hist0_0_q0);

    hist0_1_U : component ISPPipeline_accelbml
    generic map (
        DataWidth => 32,
        AddressRange => 1024,
        AddressWidth => 10)
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        address0 => hist0_1_address0,
        ce0 => hist0_1_ce0,
        we0 => hist0_1_we0,
        d0 => grp_ISPpipeline_fu_109_hist0_1_d0,
        q0 => hist0_1_q0);

    hist0_2_U : component ISPPipeline_accelbml
    generic map (
        DataWidth => 32,
        AddressRange => 1024,
        AddressWidth => 10)
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        address0 => hist0_2_address0,
        ce0 => hist0_2_ce0,
        we0 => hist0_2_we0,
        d0 => grp_ISPpipeline_fu_109_hist0_2_d0,
        q0 => hist0_2_q0);

    hist1_0_U : component ISPPipeline_accelbml
    generic map (
        DataWidth => 32,
        AddressRange => 1024,
        AddressWidth => 10)
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        address0 => hist1_0_address0,
        ce0 => hist1_0_ce0,
        we0 => hist1_0_we0,
        d0 => grp_ISPpipeline_fu_109_hist0_0_d0,
        q0 => hist1_0_q0);

    hist1_1_U : component ISPPipeline_accelbml
    generic map (
        DataWidth => 32,
        AddressRange => 1024,
        AddressWidth => 10)
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        address0 => hist1_1_address0,
        ce0 => hist1_1_ce0,
        we0 => hist1_1_we0,
        d0 => grp_ISPpipeline_fu_109_hist0_1_d0,
        q0 => hist1_1_q0);

    hist1_2_U : component ISPPipeline_accelbml
    generic map (
        DataWidth => 32,
        AddressRange => 1024,
        AddressWidth => 10)
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        address0 => hist1_2_address0,
        ce0 => hist1_2_ce0,
        we0 => hist1_2_we0,
        d0 => grp_ISPpipeline_fu_109_hist0_2_d0,
        q0 => hist1_2_q0);

    ISPPipeline_accel_CTRL_s_axi_U : component ISPPipeline_accel_CTRL_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_CTRL_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_CTRL_DATA_WIDTH)
    port map (
        AWVALID => s_axi_CTRL_AWVALID,
        AWREADY => s_axi_CTRL_AWREADY,
        AWADDR => s_axi_CTRL_AWADDR,
        WVALID => s_axi_CTRL_WVALID,
        WREADY => s_axi_CTRL_WREADY,
        WDATA => s_axi_CTRL_WDATA,
        WSTRB => s_axi_CTRL_WSTRB,
        ARVALID => s_axi_CTRL_ARVALID,
        ARREADY => s_axi_CTRL_ARREADY,
        ARADDR => s_axi_CTRL_ARADDR,
        RVALID => s_axi_CTRL_RVALID,
        RREADY => s_axi_CTRL_RREADY,
        RDATA => s_axi_CTRL_RDATA,
        RRESP => s_axi_CTRL_RRESP,
        BVALID => s_axi_CTRL_BVALID,
        BREADY => s_axi_CTRL_BREADY,
        BRESP => s_axi_CTRL_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        width => width,
        height => height,
        bayer_phase => bayer_phase,
        ap_start => ap_start,
        interrupt => interrupt,
        ap_ready => ap_ready,
        ap_done => ap_done,
        ap_idle => ap_idle);

    grp_ISPpipeline_fu_109 : component ISPpipeline
    port map (
        s_axis_video_TDATA => s_axis_video_TDATA_int,
        s_axis_video_TKEEP => s_axis_video_TKEEP_int,
        s_axis_video_TSTRB => s_axis_video_TSTRB_int,
        s_axis_video_TUSER => s_axis_video_TUSER_int,
        s_axis_video_TLAST => s_axis_video_TLAST_int,
        s_axis_video_TID => s_axis_video_TID_int,
        s_axis_video_TDEST => s_axis_video_TDEST_int,
        m_axis_video_TDATA => grp_ISPpipeline_fu_109_m_axis_video_TDATA,
        m_axis_video_TKEEP => grp_ISPpipeline_fu_109_m_axis_video_TKEEP,
        m_axis_video_TSTRB => grp_ISPpipeline_fu_109_m_axis_video_TSTRB,
        m_axis_video_TUSER => grp_ISPpipeline_fu_109_m_axis_video_TUSER,
        m_axis_video_TLAST => grp_ISPpipeline_fu_109_m_axis_video_TLAST,
        m_axis_video_TID => grp_ISPpipeline_fu_109_m_axis_video_TID,
        m_axis_video_TDEST => grp_ISPpipeline_fu_109_m_axis_video_TDEST,
        height => height_read_reg_173,
        width => width_read_reg_178,
        hist0_0_address0 => grp_ISPpipeline_fu_109_hist0_0_address0,
        hist0_0_ce0 => grp_ISPpipeline_fu_109_hist0_0_ce0,
        hist0_0_d0 => grp_ISPpipeline_fu_109_hist0_0_d0,
        hist0_0_q0 => ap_const_lv32_0,
        hist0_0_we0 => grp_ISPpipeline_fu_109_hist0_0_we0,
        hist0_0_address1 => grp_ISPpipeline_fu_109_hist0_0_address1,
        hist0_0_ce1 => grp_ISPpipeline_fu_109_hist0_0_ce1,
        hist0_0_d1 => grp_ISPpipeline_fu_109_hist0_0_d1,
        hist0_0_q1 => ap_const_lv32_0,
        hist0_0_we1 => grp_ISPpipeline_fu_109_hist0_0_we1,
        hist0_1_address0 => grp_ISPpipeline_fu_109_hist0_1_address0,
        hist0_1_ce0 => grp_ISPpipeline_fu_109_hist0_1_ce0,
        hist0_1_d0 => grp_ISPpipeline_fu_109_hist0_1_d0,
        hist0_1_q0 => ap_const_lv32_0,
        hist0_1_we0 => grp_ISPpipeline_fu_109_hist0_1_we0,
        hist0_1_address1 => grp_ISPpipeline_fu_109_hist0_1_address1,
        hist0_1_ce1 => grp_ISPpipeline_fu_109_hist0_1_ce1,
        hist0_1_d1 => grp_ISPpipeline_fu_109_hist0_1_d1,
        hist0_1_q1 => ap_const_lv32_0,
        hist0_1_we1 => grp_ISPpipeline_fu_109_hist0_1_we1,
        hist0_2_address0 => grp_ISPpipeline_fu_109_hist0_2_address0,
        hist0_2_ce0 => grp_ISPpipeline_fu_109_hist0_2_ce0,
        hist0_2_d0 => grp_ISPpipeline_fu_109_hist0_2_d0,
        hist0_2_q0 => ap_const_lv32_0,
        hist0_2_we0 => grp_ISPpipeline_fu_109_hist0_2_we0,
        hist0_2_address1 => grp_ISPpipeline_fu_109_hist0_2_address1,
        hist0_2_ce1 => grp_ISPpipeline_fu_109_hist0_2_ce1,
        hist0_2_d1 => grp_ISPpipeline_fu_109_hist0_2_d1,
        hist0_2_q1 => ap_const_lv32_0,
        hist0_2_we1 => grp_ISPpipeline_fu_109_hist0_2_we1,
        hist1_0_address0 => grp_ISPpipeline_fu_109_hist1_0_address0,
        hist1_0_ce0 => grp_ISPpipeline_fu_109_hist1_0_ce0,
        hist1_0_d0 => grp_ISPpipeline_fu_109_hist1_0_d0,
        hist1_0_q0 => grp_ISPpipeline_fu_109_hist1_0_q0,
        hist1_0_we0 => grp_ISPpipeline_fu_109_hist1_0_we0,
        hist1_0_address1 => grp_ISPpipeline_fu_109_hist1_0_address1,
        hist1_0_ce1 => grp_ISPpipeline_fu_109_hist1_0_ce1,
        hist1_0_d1 => grp_ISPpipeline_fu_109_hist1_0_d1,
        hist1_0_q1 => ap_const_lv32_0,
        hist1_0_we1 => grp_ISPpipeline_fu_109_hist1_0_we1,
        hist1_1_address0 => grp_ISPpipeline_fu_109_hist1_1_address0,
        hist1_1_ce0 => grp_ISPpipeline_fu_109_hist1_1_ce0,
        hist1_1_d0 => grp_ISPpipeline_fu_109_hist1_1_d0,
        hist1_1_q0 => grp_ISPpipeline_fu_109_hist1_1_q0,
        hist1_1_we0 => grp_ISPpipeline_fu_109_hist1_1_we0,
        hist1_1_address1 => grp_ISPpipeline_fu_109_hist1_1_address1,
        hist1_1_ce1 => grp_ISPpipeline_fu_109_hist1_1_ce1,
        hist1_1_d1 => grp_ISPpipeline_fu_109_hist1_1_d1,
        hist1_1_q1 => ap_const_lv32_0,
        hist1_1_we1 => grp_ISPpipeline_fu_109_hist1_1_we1,
        hist1_2_address0 => grp_ISPpipeline_fu_109_hist1_2_address0,
        hist1_2_ce0 => grp_ISPpipeline_fu_109_hist1_2_ce0,
        hist1_2_d0 => grp_ISPpipeline_fu_109_hist1_2_d0,
        hist1_2_q0 => grp_ISPpipeline_fu_109_hist1_2_q0,
        hist1_2_we0 => grp_ISPpipeline_fu_109_hist1_2_we0,
        hist1_2_address1 => grp_ISPpipeline_fu_109_hist1_2_address1,
        hist1_2_ce1 => grp_ISPpipeline_fu_109_hist1_2_ce1,
        hist1_2_d1 => grp_ISPpipeline_fu_109_hist1_2_d1,
        hist1_2_q1 => ap_const_lv32_0,
        hist1_2_we1 => grp_ISPpipeline_fu_109_hist1_2_we1,
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        height_ap_vld => ap_const_logic_1,
        width_ap_vld => ap_const_logic_1,
        ap_start => grp_ISPpipeline_fu_109_ap_start,
        s_axis_video_TVALID => s_axis_video_TVALID_int,
        s_axis_video_TREADY => grp_ISPpipeline_fu_109_s_axis_video_TREADY,
        ap_done => grp_ISPpipeline_fu_109_ap_done,
        m_axis_video_TVALID => grp_ISPpipeline_fu_109_m_axis_video_TVALID,
        m_axis_video_TREADY => grp_ISPpipeline_fu_109_m_axis_video_TREADY,
        ap_ready => grp_ISPpipeline_fu_109_ap_ready,
        ap_idle => grp_ISPpipeline_fu_109_ap_idle,
        ap_continue => grp_ISPpipeline_fu_109_ap_continue);

    regslice_both_s_axis_video_V_data_V_U : component regslice_both
    generic map (
        DataWidth => 40)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TDATA,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_data_V_U_ack_in,
        data_out => s_axis_video_TDATA_int,
        vld_out => s_axis_video_TVALID_int,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_data_V_U_apdone_blk);

    regslice_both_s_axis_video_V_keep_V_U : component regslice_both
    generic map (
        DataWidth => 5)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TKEEP,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_keep_V_U_ack_in,
        data_out => s_axis_video_TKEEP_int,
        vld_out => regslice_both_s_axis_video_V_keep_V_U_vld_out,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_keep_V_U_apdone_blk);

    regslice_both_s_axis_video_V_strb_V_U : component regslice_both
    generic map (
        DataWidth => 5)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TSTRB,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_strb_V_U_ack_in,
        data_out => s_axis_video_TSTRB_int,
        vld_out => regslice_both_s_axis_video_V_strb_V_U_vld_out,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_strb_V_U_apdone_blk);

    regslice_both_s_axis_video_V_user_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TUSER,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_user_V_U_ack_in,
        data_out => s_axis_video_TUSER_int,
        vld_out => regslice_both_s_axis_video_V_user_V_U_vld_out,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_user_V_U_apdone_blk);

    regslice_both_s_axis_video_V_last_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TLAST,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_last_V_U_ack_in,
        data_out => s_axis_video_TLAST_int,
        vld_out => regslice_both_s_axis_video_V_last_V_U_vld_out,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_last_V_U_apdone_blk);

    regslice_both_s_axis_video_V_id_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TID,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_id_V_U_ack_in,
        data_out => s_axis_video_TID_int,
        vld_out => regslice_both_s_axis_video_V_id_V_U_vld_out,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_id_V_U_apdone_blk);

    regslice_both_s_axis_video_V_dest_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => s_axis_video_TDEST,
        vld_in => s_axis_video_TVALID,
        ack_in => regslice_both_s_axis_video_V_dest_V_U_ack_in,
        data_out => s_axis_video_TDEST_int,
        vld_out => regslice_both_s_axis_video_V_dest_V_U_vld_out,
        ack_out => s_axis_video_TREADY_int,
        apdone_blk => regslice_both_s_axis_video_V_dest_V_U_apdone_blk);

    regslice_both_m_axis_video_V_data_V_U : component regslice_both
    generic map (
        DataWidth => 96)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TDATA,
        vld_in => m_axis_video_TVALID_int,
        ack_in => m_axis_video_TREADY_int,
        data_out => m_axis_video_TDATA,
        vld_out => regslice_both_m_axis_video_V_data_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_data_V_U_apdone_blk);

    regslice_both_m_axis_video_V_keep_V_U : component regslice_both
    generic map (
        DataWidth => 12)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TKEEP,
        vld_in => m_axis_video_TVALID_int,
        ack_in => regslice_both_m_axis_video_V_keep_V_U_ack_in_dummy,
        data_out => m_axis_video_TKEEP,
        vld_out => regslice_both_m_axis_video_V_keep_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_keep_V_U_apdone_blk);

    regslice_both_m_axis_video_V_strb_V_U : component regslice_both
    generic map (
        DataWidth => 12)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TSTRB,
        vld_in => m_axis_video_TVALID_int,
        ack_in => regslice_both_m_axis_video_V_strb_V_U_ack_in_dummy,
        data_out => m_axis_video_TSTRB,
        vld_out => regslice_both_m_axis_video_V_strb_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_strb_V_U_apdone_blk);

    regslice_both_m_axis_video_V_user_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TUSER,
        vld_in => m_axis_video_TVALID_int,
        ack_in => regslice_both_m_axis_video_V_user_V_U_ack_in_dummy,
        data_out => m_axis_video_TUSER,
        vld_out => regslice_both_m_axis_video_V_user_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_user_V_U_apdone_blk);

    regslice_both_m_axis_video_V_last_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TLAST,
        vld_in => m_axis_video_TVALID_int,
        ack_in => regslice_both_m_axis_video_V_last_V_U_ack_in_dummy,
        data_out => m_axis_video_TLAST,
        vld_out => regslice_both_m_axis_video_V_last_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_last_V_U_apdone_blk);

    regslice_both_m_axis_video_V_id_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TID,
        vld_in => m_axis_video_TVALID_int,
        ack_in => regslice_both_m_axis_video_V_id_V_U_ack_in_dummy,
        data_out => m_axis_video_TID,
        vld_out => regslice_both_m_axis_video_V_id_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_id_V_U_apdone_blk);

    regslice_both_m_axis_video_V_dest_V_U : component regslice_both
    generic map (
        DataWidth => 1)
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        data_in => grp_ISPpipeline_fu_109_m_axis_video_TDEST,
        vld_in => m_axis_video_TVALID_int,
        ack_in => regslice_both_m_axis_video_V_dest_V_U_ack_in_dummy,
        data_out => m_axis_video_TDEST,
        vld_out => regslice_both_m_axis_video_V_dest_V_U_vld_out,
        ack_out => m_axis_video_TREADY,
        apdone_blk => regslice_both_m_axis_video_V_dest_V_U_apdone_blk);





    ap_CS_fsm_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_CS_fsm <= ap_ST_fsm_state1;
            else
                ap_CS_fsm <= ap_NS_fsm;
            end if;
        end if;
    end process;


    ap_sync_reg_grp_ISPpipeline_fu_109_ap_done_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_sync_reg_grp_ISPpipeline_fu_109_ap_done <= ap_const_logic_0;
            else
                if ((((ap_const_boolean_0 = ap_block_state3_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state3)) or ((ap_const_boolean_0 = ap_block_state2_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state2)))) then 
                    ap_sync_reg_grp_ISPpipeline_fu_109_ap_done <= ap_const_logic_0;
                elsif ((grp_ISPpipeline_fu_109_ap_done = ap_const_logic_1)) then 
                    ap_sync_reg_grp_ISPpipeline_fu_109_ap_done <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    ap_sync_reg_grp_ISPpipeline_fu_109_ap_ready_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                ap_sync_reg_grp_ISPpipeline_fu_109_ap_ready <= ap_const_logic_0;
            else
                if ((((ap_const_boolean_0 = ap_block_state3_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state3)) or ((ap_const_boolean_0 = ap_block_state2_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state2)))) then 
                    ap_sync_reg_grp_ISPpipeline_fu_109_ap_ready <= ap_const_logic_0;
                elsif ((grp_ISPpipeline_fu_109_ap_ready = ap_const_logic_1)) then 
                    ap_sync_reg_grp_ISPpipeline_fu_109_ap_ready <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    grp_ISPpipeline_fu_109_ap_start_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst_n_inv = '1') then
                grp_ISPpipeline_fu_109_ap_start_reg <= ap_const_logic_0;
            else
                if ((((ap_sync_grp_ISPpipeline_fu_109_ap_ready = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state3)) or ((ap_sync_grp_ISPpipeline_fu_109_ap_ready = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state2)) or ((flag_load_load_fu_163_p1 = ap_const_lv1_1) and (ap_const_logic_1 = ap_CS_fsm_state1) and (ap_start = ap_const_logic_1)) or ((flag_load_load_fu_163_p1 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state1) and (ap_start = ap_const_logic_1)))) then 
                    grp_ISPpipeline_fu_109_ap_start_reg <= ap_const_logic_1;
                elsif ((grp_ISPpipeline_fu_109_ap_ready = ap_const_logic_1)) then 
                    grp_ISPpipeline_fu_109_ap_start_reg <= ap_const_logic_0;
                end if; 
            end if;
        end if;
    end process;


    storemerge_reg_96_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_boolean_0 = ap_block_state3_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state3))) then 
                storemerge_reg_96 <= ap_const_lv1_0;
            elsif (((ap_const_boolean_0 = ap_block_state2_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state2))) then 
                storemerge_reg_96 <= ap_const_lv1_1;
            end if; 
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((regslice_both_m_axis_video_V_data_V_U_apdone_blk = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then
                flag <= storemerge_reg_96;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_logic_1 = ap_CS_fsm_state1) and (ap_start = ap_const_logic_1))) then
                height_read_reg_173 <= height;
                width_read_reg_178 <= width;
            end if;
        end if;
    end process;

    ap_NS_fsm_assign_proc : process (ap_start, ap_CS_fsm, ap_CS_fsm_state1, ap_CS_fsm_state2, ap_block_state2_on_subcall_done, ap_CS_fsm_state3, ap_block_state3_on_subcall_done, flag_load_load_fu_163_p1, ap_CS_fsm_state4, regslice_both_m_axis_video_V_data_V_U_apdone_blk)
    begin
        case ap_CS_fsm is
            when ap_ST_fsm_state1 => 
                if (((flag_load_load_fu_163_p1 = ap_const_lv1_1) and (ap_const_logic_1 = ap_CS_fsm_state1) and (ap_start = ap_const_logic_1))) then
                    ap_NS_fsm <= ap_ST_fsm_state3;
                elsif (((flag_load_load_fu_163_p1 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state1) and (ap_start = ap_const_logic_1))) then
                    ap_NS_fsm <= ap_ST_fsm_state2;
                else
                    ap_NS_fsm <= ap_ST_fsm_state1;
                end if;
            when ap_ST_fsm_state2 => 
                if (((ap_const_boolean_0 = ap_block_state2_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state2))) then
                    ap_NS_fsm <= ap_ST_fsm_state4;
                else
                    ap_NS_fsm <= ap_ST_fsm_state2;
                end if;
            when ap_ST_fsm_state3 => 
                if (((ap_const_boolean_0 = ap_block_state3_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state3))) then
                    ap_NS_fsm <= ap_ST_fsm_state4;
                else
                    ap_NS_fsm <= ap_ST_fsm_state3;
                end if;
            when ap_ST_fsm_state4 => 
                if (((regslice_both_m_axis_video_V_data_V_U_apdone_blk = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then
                    ap_NS_fsm <= ap_ST_fsm_state1;
                else
                    ap_NS_fsm <= ap_ST_fsm_state4;
                end if;
            when others =>  
                ap_NS_fsm <= "XXXX";
        end case;
    end process;
    ap_CS_fsm_state1 <= ap_CS_fsm(0);
    ap_CS_fsm_state2 <= ap_CS_fsm(1);
    ap_CS_fsm_state3 <= ap_CS_fsm(2);
    ap_CS_fsm_state4 <= ap_CS_fsm(3);

    ap_block_state2_on_subcall_done_assign_proc : process(ap_sync_grp_ISPpipeline_fu_109_ap_ready, ap_sync_grp_ISPpipeline_fu_109_ap_done)
    begin
                ap_block_state2_on_subcall_done <= ((ap_sync_grp_ISPpipeline_fu_109_ap_ready and ap_sync_grp_ISPpipeline_fu_109_ap_done) = ap_const_logic_0);
    end process;


    ap_block_state3_on_subcall_done_assign_proc : process(ap_sync_grp_ISPpipeline_fu_109_ap_ready, ap_sync_grp_ISPpipeline_fu_109_ap_done)
    begin
                ap_block_state3_on_subcall_done <= ((ap_sync_grp_ISPpipeline_fu_109_ap_ready and ap_sync_grp_ISPpipeline_fu_109_ap_done) = ap_const_logic_0);
    end process;


    ap_done_assign_proc : process(ap_CS_fsm_state4, regslice_both_m_axis_video_V_data_V_U_apdone_blk)
    begin
        if (((regslice_both_m_axis_video_V_data_V_U_apdone_blk = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
            ap_done <= ap_const_logic_1;
        else 
            ap_done <= ap_const_logic_0;
        end if; 
    end process;


    ap_idle_assign_proc : process(ap_start, ap_CS_fsm_state1)
    begin
        if (((ap_start = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ap_idle <= ap_const_logic_1;
        else 
            ap_idle <= ap_const_logic_0;
        end if; 
    end process;


    ap_ready_assign_proc : process(ap_CS_fsm_state4, regslice_both_m_axis_video_V_data_V_U_apdone_blk)
    begin
        if (((regslice_both_m_axis_video_V_data_V_U_apdone_blk = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
            ap_ready <= ap_const_logic_1;
        else 
            ap_ready <= ap_const_logic_0;
        end if; 
    end process;


    ap_rst_n_inv_assign_proc : process(ap_rst_n)
    begin
                ap_rst_n_inv <= not(ap_rst_n);
    end process;

    ap_sync_grp_ISPpipeline_fu_109_ap_done <= (grp_ISPpipeline_fu_109_ap_done or ap_sync_reg_grp_ISPpipeline_fu_109_ap_done);
    ap_sync_grp_ISPpipeline_fu_109_ap_ready <= (grp_ISPpipeline_fu_109_ap_ready or ap_sync_reg_grp_ISPpipeline_fu_109_ap_ready);
    flag_load_load_fu_163_p1 <= flag;

    grp_ISPpipeline_fu_109_ap_continue_assign_proc : process(ap_CS_fsm_state2, ap_block_state2_on_subcall_done, ap_CS_fsm_state3, ap_block_state3_on_subcall_done)
    begin
        if ((((ap_const_boolean_0 = ap_block_state3_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state3)) or ((ap_const_boolean_0 = ap_block_state2_on_subcall_done) and (ap_const_logic_1 = ap_CS_fsm_state2)))) then 
            grp_ISPpipeline_fu_109_ap_continue <= ap_const_logic_1;
        else 
            grp_ISPpipeline_fu_109_ap_continue <= ap_const_logic_0;
        end if; 
    end process;

    grp_ISPpipeline_fu_109_ap_start <= grp_ISPpipeline_fu_109_ap_start_reg;

    grp_ISPpipeline_fu_109_hist1_0_q0_assign_proc : process(hist0_0_q0, hist1_0_q0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            grp_ISPpipeline_fu_109_hist1_0_q0 <= hist0_0_q0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            grp_ISPpipeline_fu_109_hist1_0_q0 <= hist1_0_q0;
        else 
            grp_ISPpipeline_fu_109_hist1_0_q0 <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        end if; 
    end process;


    grp_ISPpipeline_fu_109_hist1_1_q0_assign_proc : process(hist0_1_q0, hist1_1_q0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            grp_ISPpipeline_fu_109_hist1_1_q0 <= hist0_1_q0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            grp_ISPpipeline_fu_109_hist1_1_q0 <= hist1_1_q0;
        else 
            grp_ISPpipeline_fu_109_hist1_1_q0 <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        end if; 
    end process;


    grp_ISPpipeline_fu_109_hist1_2_q0_assign_proc : process(hist0_2_q0, hist1_2_q0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            grp_ISPpipeline_fu_109_hist1_2_q0 <= hist0_2_q0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            grp_ISPpipeline_fu_109_hist1_2_q0 <= hist1_2_q0;
        else 
            grp_ISPpipeline_fu_109_hist1_2_q0 <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        end if; 
    end process;

    grp_ISPpipeline_fu_109_m_axis_video_TREADY <= ((m_axis_video_TREADY_int and ap_CS_fsm_state3) or (m_axis_video_TREADY_int and ap_CS_fsm_state2));

    hist0_0_address0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_0_address0, grp_ISPpipeline_fu_109_hist1_0_address0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist0_0_address0 <= grp_ISPpipeline_fu_109_hist1_0_address0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_0_address0 <= grp_ISPpipeline_fu_109_hist0_0_address0;
        else 
            hist0_0_address0 <= "XXXXXXXXXX";
        end if; 
    end process;


    hist0_0_ce0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_0_ce0, grp_ISPpipeline_fu_109_hist1_0_ce0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist0_0_ce0 <= grp_ISPpipeline_fu_109_hist1_0_ce0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_0_ce0 <= grp_ISPpipeline_fu_109_hist0_0_ce0;
        else 
            hist0_0_ce0 <= ap_const_logic_0;
        end if; 
    end process;


    hist0_0_we0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_0_we0, ap_CS_fsm_state2)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_0_we0 <= grp_ISPpipeline_fu_109_hist0_0_we0;
        else 
            hist0_0_we0 <= ap_const_logic_0;
        end if; 
    end process;


    hist0_1_address0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_1_address0, grp_ISPpipeline_fu_109_hist1_1_address0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist0_1_address0 <= grp_ISPpipeline_fu_109_hist1_1_address0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_1_address0 <= grp_ISPpipeline_fu_109_hist0_1_address0;
        else 
            hist0_1_address0 <= "XXXXXXXXXX";
        end if; 
    end process;


    hist0_1_ce0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_1_ce0, grp_ISPpipeline_fu_109_hist1_1_ce0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist0_1_ce0 <= grp_ISPpipeline_fu_109_hist1_1_ce0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_1_ce0 <= grp_ISPpipeline_fu_109_hist0_1_ce0;
        else 
            hist0_1_ce0 <= ap_const_logic_0;
        end if; 
    end process;


    hist0_1_we0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_1_we0, ap_CS_fsm_state2)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_1_we0 <= grp_ISPpipeline_fu_109_hist0_1_we0;
        else 
            hist0_1_we0 <= ap_const_logic_0;
        end if; 
    end process;


    hist0_2_address0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_2_address0, grp_ISPpipeline_fu_109_hist1_2_address0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist0_2_address0 <= grp_ISPpipeline_fu_109_hist1_2_address0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_2_address0 <= grp_ISPpipeline_fu_109_hist0_2_address0;
        else 
            hist0_2_address0 <= "XXXXXXXXXX";
        end if; 
    end process;


    hist0_2_ce0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_2_ce0, grp_ISPpipeline_fu_109_hist1_2_ce0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist0_2_ce0 <= grp_ISPpipeline_fu_109_hist1_2_ce0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_2_ce0 <= grp_ISPpipeline_fu_109_hist0_2_ce0;
        else 
            hist0_2_ce0 <= ap_const_logic_0;
        end if; 
    end process;


    hist0_2_we0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_2_we0, ap_CS_fsm_state2)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist0_2_we0 <= grp_ISPpipeline_fu_109_hist0_2_we0;
        else 
            hist0_2_we0 <= ap_const_logic_0;
        end if; 
    end process;


    hist1_0_address0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_0_address0, grp_ISPpipeline_fu_109_hist1_0_address0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist1_0_address0 <= grp_ISPpipeline_fu_109_hist1_0_address0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_0_address0 <= grp_ISPpipeline_fu_109_hist0_0_address0;
        else 
            hist1_0_address0 <= "XXXXXXXXXX";
        end if; 
    end process;


    hist1_0_ce0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_0_ce0, grp_ISPpipeline_fu_109_hist1_0_ce0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist1_0_ce0 <= grp_ISPpipeline_fu_109_hist1_0_ce0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_0_ce0 <= grp_ISPpipeline_fu_109_hist0_0_ce0;
        else 
            hist1_0_ce0 <= ap_const_logic_0;
        end if; 
    end process;


    hist1_0_we0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_0_we0, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_0_we0 <= grp_ISPpipeline_fu_109_hist0_0_we0;
        else 
            hist1_0_we0 <= ap_const_logic_0;
        end if; 
    end process;


    hist1_1_address0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_1_address0, grp_ISPpipeline_fu_109_hist1_1_address0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist1_1_address0 <= grp_ISPpipeline_fu_109_hist1_1_address0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_1_address0 <= grp_ISPpipeline_fu_109_hist0_1_address0;
        else 
            hist1_1_address0 <= "XXXXXXXXXX";
        end if; 
    end process;


    hist1_1_ce0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_1_ce0, grp_ISPpipeline_fu_109_hist1_1_ce0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist1_1_ce0 <= grp_ISPpipeline_fu_109_hist1_1_ce0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_1_ce0 <= grp_ISPpipeline_fu_109_hist0_1_ce0;
        else 
            hist1_1_ce0 <= ap_const_logic_0;
        end if; 
    end process;


    hist1_1_we0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_1_we0, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_1_we0 <= grp_ISPpipeline_fu_109_hist0_1_we0;
        else 
            hist1_1_we0 <= ap_const_logic_0;
        end if; 
    end process;


    hist1_2_address0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_2_address0, grp_ISPpipeline_fu_109_hist1_2_address0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist1_2_address0 <= grp_ISPpipeline_fu_109_hist1_2_address0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_2_address0 <= grp_ISPpipeline_fu_109_hist0_2_address0;
        else 
            hist1_2_address0 <= "XXXXXXXXXX";
        end if; 
    end process;


    hist1_2_ce0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_2_ce0, grp_ISPpipeline_fu_109_hist1_2_ce0, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state2)) then 
            hist1_2_ce0 <= grp_ISPpipeline_fu_109_hist1_2_ce0;
        elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_2_ce0 <= grp_ISPpipeline_fu_109_hist0_2_ce0;
        else 
            hist1_2_ce0 <= ap_const_logic_0;
        end if; 
    end process;


    hist1_2_we0_assign_proc : process(grp_ISPpipeline_fu_109_hist0_2_we0, ap_CS_fsm_state3)
    begin
        if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
            hist1_2_we0 <= grp_ISPpipeline_fu_109_hist0_2_we0;
        else 
            hist1_2_we0 <= ap_const_logic_0;
        end if; 
    end process;

    m_axis_video_TVALID <= regslice_both_m_axis_video_V_data_V_U_vld_out;

    m_axis_video_TVALID_int_assign_proc : process(grp_ISPpipeline_fu_109_m_axis_video_TVALID, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if (((ap_const_logic_1 = ap_CS_fsm_state3) or (ap_const_logic_1 = ap_CS_fsm_state2))) then 
            m_axis_video_TVALID_int <= grp_ISPpipeline_fu_109_m_axis_video_TVALID;
        else 
            m_axis_video_TVALID_int <= ap_const_logic_0;
        end if; 
    end process;


    s_axis_video_TREADY_assign_proc : process(s_axis_video_TVALID, regslice_both_s_axis_video_V_data_V_U_ack_in)
    begin
        if (((regslice_both_s_axis_video_V_data_V_U_ack_in = ap_const_logic_1) and (s_axis_video_TVALID = ap_const_logic_1))) then 
            s_axis_video_TREADY <= ap_const_logic_1;
        else 
            s_axis_video_TREADY <= ap_const_logic_0;
        end if; 
    end process;


    s_axis_video_TREADY_int_assign_proc : process(grp_ISPpipeline_fu_109_s_axis_video_TREADY, ap_CS_fsm_state2, ap_CS_fsm_state3)
    begin
        if (((ap_const_logic_1 = ap_CS_fsm_state3) or (ap_const_logic_1 = ap_CS_fsm_state2))) then 
            s_axis_video_TREADY_int <= grp_ISPpipeline_fu_109_s_axis_video_TREADY;
        else 
            s_axis_video_TREADY_int <= ap_const_logic_0;
        end if; 
    end process;

end behav;
