-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and OpenCL
-- Version: 2020.2
-- Copyright (C) 1986-2020 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity AXIVideo2BayerMat is
port (
    ap_clk : IN STD_LOGIC;
    ap_rst : IN STD_LOGIC;
    ap_start : IN STD_LOGIC;
    start_full_n : IN STD_LOGIC;
    ap_done : OUT STD_LOGIC;
    ap_continue : IN STD_LOGIC;
    ap_idle : OUT STD_LOGIC;
    ap_ready : OUT STD_LOGIC;
    start_out : OUT STD_LOGIC;
    start_write : OUT STD_LOGIC;
    s_axis_video_TDATA : IN STD_LOGIC_VECTOR (39 downto 0);
    s_axis_video_TVALID : IN STD_LOGIC;
    s_axis_video_TREADY : OUT STD_LOGIC;
    s_axis_video_TKEEP : IN STD_LOGIC_VECTOR (4 downto 0);
    s_axis_video_TSTRB : IN STD_LOGIC_VECTOR (4 downto 0);
    s_axis_video_TUSER : IN STD_LOGIC_VECTOR (0 downto 0);
    s_axis_video_TLAST : IN STD_LOGIC_VECTOR (0 downto 0);
    s_axis_video_TID : IN STD_LOGIC_VECTOR (0 downto 0);
    s_axis_video_TDEST : IN STD_LOGIC_VECTOR (0 downto 0);
    bayer_mat_rows_dout : IN STD_LOGIC_VECTOR (15 downto 0);
    bayer_mat_rows_empty_n : IN STD_LOGIC;
    bayer_mat_rows_read : OUT STD_LOGIC;
    bayer_mat_cols_dout : IN STD_LOGIC_VECTOR (15 downto 0);
    bayer_mat_cols_empty_n : IN STD_LOGIC;
    bayer_mat_cols_read : OUT STD_LOGIC;
    bayer_mat_data_V_V_din : OUT STD_LOGIC_VECTOR (39 downto 0);
    bayer_mat_data_V_V_full_n : IN STD_LOGIC;
    bayer_mat_data_V_V_write : OUT STD_LOGIC;
    bayer_mat_rows_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    bayer_mat_rows_out_full_n : IN STD_LOGIC;
    bayer_mat_rows_out_write : OUT STD_LOGIC;
    bayer_mat_cols_out_din : OUT STD_LOGIC_VECTOR (15 downto 0);
    bayer_mat_cols_out_full_n : IN STD_LOGIC;
    bayer_mat_cols_out_write : OUT STD_LOGIC );
end;


architecture behav of AXIVideo2BayerMat is 
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_ST_fsm_state1 : STD_LOGIC_VECTOR (7 downto 0) := "00000001";
    constant ap_ST_fsm_state2 : STD_LOGIC_VECTOR (7 downto 0) := "00000010";
    constant ap_ST_fsm_state3 : STD_LOGIC_VECTOR (7 downto 0) := "00000100";
    constant ap_ST_fsm_state4 : STD_LOGIC_VECTOR (7 downto 0) := "00001000";
    constant ap_ST_fsm_pp1_stage0 : STD_LOGIC_VECTOR (7 downto 0) := "00010000";
    constant ap_ST_fsm_state7 : STD_LOGIC_VECTOR (7 downto 0) := "00100000";
    constant ap_ST_fsm_state8 : STD_LOGIC_VECTOR (7 downto 0) := "01000000";
    constant ap_ST_fsm_state9 : STD_LOGIC_VECTOR (7 downto 0) := "10000000";
    constant ap_const_boolean_1 : BOOLEAN := true;
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_lv32_1 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000001";
    constant ap_const_lv32_4 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000100";
    constant ap_const_boolean_0 : BOOLEAN := false;
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_lv32_6 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000110";
    constant ap_const_lv32_2 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000010";
    constant ap_const_lv32_3 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000011";
    constant ap_const_lv1_1 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_lv32_7 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000111";
    constant ap_const_lv16_0 : STD_LOGIC_VECTOR (15 downto 0) := "0000000000000000";
    constant ap_const_lv14_0 : STD_LOGIC_VECTOR (13 downto 0) := "00000000000000";
    constant ap_const_lv32_5 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000101";
    constant ap_const_lv32_F : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000001111";
    constant ap_const_lv16_1 : STD_LOGIC_VECTOR (15 downto 0) := "0000000000000001";
    constant ap_const_lv14_1 : STD_LOGIC_VECTOR (13 downto 0) := "00000000000001";

    signal real_start : STD_LOGIC;
    signal start_once_reg : STD_LOGIC := '0';
    signal ap_done_reg : STD_LOGIC := '0';
    signal ap_CS_fsm : STD_LOGIC_VECTOR (7 downto 0) := "00000001";
    attribute fsm_encoding : string;
    attribute fsm_encoding of ap_CS_fsm : signal is "none";
    signal ap_CS_fsm_state1 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state1 : signal is "none";
    signal internal_ap_ready : STD_LOGIC;
    signal s_axis_video_TDATA_blk_n : STD_LOGIC;
    signal ap_CS_fsm_state2 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state2 : signal is "none";
    signal ap_CS_fsm_pp1_stage0 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_pp1_stage0 : signal is "none";
    signal ap_enable_reg_pp1_iter0 : STD_LOGIC := '0';
    signal ap_block_pp1_stage0 : BOOLEAN;
    signal icmp_ln83_fu_322_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal or_ln90_fu_336_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_CS_fsm_state8 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state8 : signal is "none";
    signal ap_phi_mux_last_1_i_phi_fu_276_p4 : STD_LOGIC_VECTOR (0 downto 0);
    signal bayer_mat_rows_blk_n : STD_LOGIC;
    signal bayer_mat_cols_blk_n : STD_LOGIC;
    signal bayer_mat_data_V_V_blk_n : STD_LOGIC;
    signal ap_enable_reg_pp1_iter1 : STD_LOGIC := '0';
    signal icmp_ln83_reg_391 : STD_LOGIC_VECTOR (0 downto 0);
    signal bayer_mat_rows_out_blk_n : STD_LOGIC;
    signal bayer_mat_cols_out_blk_n : STD_LOGIC;
    signal axi_last_V_1_i_reg_178 : STD_LOGIC_VECTOR (0 downto 0);
    signal axi_data_V_1_i_reg_189 : STD_LOGIC_VECTOR (39 downto 0);
    signal last_0_i_reg_200 : STD_LOGIC_VECTOR (0 downto 0);
    signal j_0_i_reg_212 : STD_LOGIC_VECTOR (13 downto 0);
    signal last_reg_223 : STD_LOGIC_VECTOR (0 downto 0);
    signal p_Val2_s_reg_236 : STD_LOGIC_VECTOR (39 downto 0);
    signal bayer_mat_rows_read_reg_347 : STD_LOGIC_VECTOR (15 downto 0);
    signal ap_block_state1 : BOOLEAN;
    signal bayer_mat_cols_read_reg_352 : STD_LOGIC_VECTOR (15 downto 0);
    signal tmp_data_V_reg_357 : STD_LOGIC_VECTOR (39 downto 0);
    signal tmp_last_V_reg_365 : STD_LOGIC_VECTOR (0 downto 0);
    signal tmp_reg_377 : STD_LOGIC_VECTOR (13 downto 0);
    signal ap_CS_fsm_state3 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state3 : signal is "none";
    signal icmp_ln77_fu_311_p2 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_CS_fsm_state4 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state4 : signal is "none";
    signal i_fu_316_p2 : STD_LOGIC_VECTOR (15 downto 0);
    signal i_reg_386 : STD_LOGIC_VECTOR (15 downto 0);
    signal ap_predicate_op63_read_state5 : BOOLEAN;
    signal ap_block_state5_pp1_stage0_iter0 : BOOLEAN;
    signal ap_block_state6_pp1_stage0_iter1 : BOOLEAN;
    signal ap_block_pp1_stage0_11001 : BOOLEAN;
    signal j_fu_327_p2 : STD_LOGIC_VECTOR (13 downto 0);
    signal ap_block_state8 : BOOLEAN;
    signal ap_block_pp1_stage0_subdone : BOOLEAN;
    signal ap_condition_pp1_exit_iter0_state5 : STD_LOGIC;
    signal axi_last_V_3_i_reg_249 : STD_LOGIC_VECTOR (0 downto 0);
    signal axi_last_V_0_i_reg_147 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_CS_fsm_state9 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state9 : signal is "none";
    signal axi_data_V_3_i_reg_261 : STD_LOGIC_VECTOR (39 downto 0);
    signal axi_data_V_0_i_reg_157 : STD_LOGIC_VECTOR (39 downto 0);
    signal i_0_i_reg_167 : STD_LOGIC_VECTOR (15 downto 0);
    signal ap_phi_mux_axi_last_V_1_i_phi_fu_181_p4 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_phi_mux_axi_data_V_1_i_phi_fu_192_p4 : STD_LOGIC_VECTOR (39 downto 0);
    signal ap_phi_mux_last_0_i_phi_fu_204_p4 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_phi_reg_pp1_iter0_last_reg_223 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_phi_reg_pp1_iter0_p_Val2_s_reg_236 : STD_LOGIC_VECTOR (39 downto 0);
    signal ap_CS_fsm_state7 : STD_LOGIC;
    attribute fsm_encoding of ap_CS_fsm_state7 : signal is "none";
    signal last_1_i_reg_273 : STD_LOGIC_VECTOR (0 downto 0);
    signal start_1_i_fu_90 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_block_pp1_stage0_01001 : BOOLEAN;
    signal tmp_user_V_fu_293_p1 : STD_LOGIC_VECTOR (0 downto 0);
    signal ap_NS_fsm : STD_LOGIC_VECTOR (7 downto 0);
    signal ap_idle_pp1 : STD_LOGIC;
    signal ap_enable_pp1 : STD_LOGIC;
    signal ap_condition_191 : BOOLEAN;


begin




    ap_CS_fsm_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_CS_fsm <= ap_ST_fsm_state1;
            else
                ap_CS_fsm <= ap_NS_fsm;
            end if;
        end if;
    end process;


    ap_done_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_done_reg <= ap_const_logic_0;
            else
                if ((ap_continue = ap_const_logic_1)) then 
                    ap_done_reg <= ap_const_logic_0;
                elsif (((ap_const_logic_1 = ap_CS_fsm_state4) and (icmp_ln77_fu_311_p2 = ap_const_lv1_1))) then 
                    ap_done_reg <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp1_iter0_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_enable_reg_pp1_iter0 <= ap_const_logic_0;
            else
                if (((ap_const_boolean_0 = ap_block_pp1_stage0_subdone) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_const_logic_1 = ap_condition_pp1_exit_iter0_state5))) then 
                    ap_enable_reg_pp1_iter0 <= ap_const_logic_0;
                elsif (((icmp_ln77_fu_311_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
                    ap_enable_reg_pp1_iter0 <= ap_const_logic_1;
                end if; 
            end if;
        end if;
    end process;


    ap_enable_reg_pp1_iter1_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                ap_enable_reg_pp1_iter1 <= ap_const_logic_0;
            else
                if (((ap_const_boolean_0 = ap_block_pp1_stage0_subdone) and (ap_const_logic_1 = ap_condition_pp1_exit_iter0_state5))) then 
                    ap_enable_reg_pp1_iter1 <= (ap_const_logic_1 xor ap_condition_pp1_exit_iter0_state5);
                elsif ((ap_const_boolean_0 = ap_block_pp1_stage0_subdone)) then 
                    ap_enable_reg_pp1_iter1 <= ap_enable_reg_pp1_iter0;
                elsif (((icmp_ln77_fu_311_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
                    ap_enable_reg_pp1_iter1 <= ap_const_logic_0;
                end if; 
            end if;
        end if;
    end process;


    start_once_reg_assign_proc : process(ap_clk)
    begin
        if (ap_clk'event and ap_clk =  '1') then
            if (ap_rst = '1') then
                start_once_reg <= ap_const_logic_0;
            else
                if (((internal_ap_ready = ap_const_logic_0) and (real_start = ap_const_logic_1))) then 
                    start_once_reg <= ap_const_logic_1;
                elsif ((internal_ap_ready = ap_const_logic_1)) then 
                    start_once_reg <= ap_const_logic_0;
                end if; 
            end if;
        end if;
    end process;


    axi_data_V_0_i_reg_157_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
                axi_data_V_0_i_reg_157 <= tmp_data_V_reg_357;
            elsif ((ap_const_logic_1 = ap_CS_fsm_state9)) then 
                axi_data_V_0_i_reg_157 <= axi_data_V_3_i_reg_261;
            end if; 
        end if;
    end process;

    axi_data_V_1_i_reg_189_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then 
                axi_data_V_1_i_reg_189 <= p_Val2_s_reg_236;
            elsif (((icmp_ln77_fu_311_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
                axi_data_V_1_i_reg_189 <= axi_data_V_0_i_reg_157;
            end if; 
        end if;
    end process;

    axi_data_V_3_i_reg_261_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state7)) then 
                axi_data_V_3_i_reg_261 <= axi_data_V_1_i_reg_189;
            elsif ((not(((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0))) and (last_1_i_reg_273 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state8))) then 
                axi_data_V_3_i_reg_261 <= s_axis_video_TDATA;
            end if; 
        end if;
    end process;

    axi_last_V_0_i_reg_147_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
                axi_last_V_0_i_reg_147 <= tmp_last_V_reg_365;
            elsif ((ap_const_logic_1 = ap_CS_fsm_state9)) then 
                axi_last_V_0_i_reg_147 <= axi_last_V_3_i_reg_249;
            end if; 
        end if;
    end process;

    axi_last_V_1_i_reg_178_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then 
                axi_last_V_1_i_reg_178 <= last_reg_223;
            elsif (((icmp_ln77_fu_311_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
                axi_last_V_1_i_reg_178 <= axi_last_V_0_i_reg_147;
            end if; 
        end if;
    end process;

    axi_last_V_3_i_reg_249_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state7)) then 
                axi_last_V_3_i_reg_249 <= axi_last_V_1_i_reg_178;
            elsif ((not(((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0))) and (last_1_i_reg_273 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state8))) then 
                axi_last_V_3_i_reg_249 <= s_axis_video_TLAST;
            end if; 
        end if;
    end process;

    i_0_i_reg_167_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
                i_0_i_reg_167 <= ap_const_lv16_0;
            elsif ((ap_const_logic_1 = ap_CS_fsm_state9)) then 
                i_0_i_reg_167 <= i_reg_386;
            end if; 
        end if;
    end process;

    j_0_i_reg_212_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln83_fu_322_p2 = ap_const_lv1_0) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then 
                j_0_i_reg_212 <= j_fu_327_p2;
            elsif (((icmp_ln77_fu_311_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
                j_0_i_reg_212 <= ap_const_lv14_0;
            end if; 
        end if;
    end process;

    last_0_i_reg_200_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then 
                last_0_i_reg_200 <= last_reg_223;
            elsif (((icmp_ln77_fu_311_p2 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state4))) then 
                last_0_i_reg_200 <= ap_const_lv1_0;
            end if; 
        end if;
    end process;

    last_1_i_reg_273_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state7)) then 
                last_1_i_reg_273 <= last_0_i_reg_200;
            elsif ((not(((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0))) and (last_1_i_reg_273 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state8))) then 
                last_1_i_reg_273 <= s_axis_video_TLAST;
            end if; 
        end if;
    end process;

    last_reg_223_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_boolean_1 = ap_condition_191)) then
                if (((or_ln90_fu_336_p2 = ap_const_lv1_0) and (icmp_ln83_fu_322_p2 = ap_const_lv1_0))) then 
                    last_reg_223 <= s_axis_video_TLAST;
                elsif (((or_ln90_fu_336_p2 = ap_const_lv1_1) and (icmp_ln83_fu_322_p2 = ap_const_lv1_0))) then 
                    last_reg_223 <= ap_phi_mux_axi_last_V_1_i_phi_fu_181_p4;
                elsif ((ap_const_boolean_1 = ap_const_boolean_1)) then 
                    last_reg_223 <= ap_phi_reg_pp1_iter0_last_reg_223;
                end if;
            end if; 
        end if;
    end process;

    p_Val2_s_reg_236_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_boolean_1 = ap_condition_191)) then
                if (((or_ln90_fu_336_p2 = ap_const_lv1_0) and (icmp_ln83_fu_322_p2 = ap_const_lv1_0))) then 
                    p_Val2_s_reg_236 <= s_axis_video_TDATA;
                elsif (((or_ln90_fu_336_p2 = ap_const_lv1_1) and (icmp_ln83_fu_322_p2 = ap_const_lv1_0))) then 
                    p_Val2_s_reg_236 <= ap_phi_mux_axi_data_V_1_i_phi_fu_192_p4;
                elsif ((ap_const_boolean_1 = ap_const_boolean_1)) then 
                    p_Val2_s_reg_236 <= ap_phi_reg_pp1_iter0_p_Val2_s_reg_236;
                end if;
            end if; 
        end if;
    end process;

    start_1_i_fu_90_assign_proc : process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((icmp_ln83_fu_322_p2 = ap_const_lv1_0) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then 
                start_1_i_fu_90 <= ap_const_lv1_0;
            elsif ((ap_const_logic_1 = ap_CS_fsm_state3)) then 
                start_1_i_fu_90 <= ap_const_lv1_1;
            end if; 
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((not(((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then
                bayer_mat_cols_read_reg_352 <= bayer_mat_cols_dout;
                bayer_mat_rows_read_reg_347 <= bayer_mat_rows_dout;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state4)) then
                i_reg_386 <= i_fu_316_p2;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then
                icmp_ln83_reg_391 <= icmp_ln83_fu_322_p2;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if (((s_axis_video_TVALID = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_state2))) then
                tmp_data_V_reg_357 <= s_axis_video_TDATA;
                tmp_last_V_reg_365 <= s_axis_video_TLAST;
            end if;
        end if;
    end process;
    process (ap_clk)
    begin
        if (ap_clk'event and ap_clk = '1') then
            if ((ap_const_logic_1 = ap_CS_fsm_state3)) then
                tmp_reg_377 <= bayer_mat_cols_read_reg_352(15 downto 2);
            end if;
        end if;
    end process;

    ap_NS_fsm_assign_proc : process (real_start, ap_done_reg, ap_CS_fsm, ap_CS_fsm_state1, s_axis_video_TVALID, bayer_mat_rows_empty_n, bayer_mat_cols_empty_n, bayer_mat_rows_out_full_n, bayer_mat_cols_out_full_n, ap_CS_fsm_state2, ap_enable_reg_pp1_iter0, icmp_ln83_fu_322_p2, ap_CS_fsm_state8, ap_phi_mux_last_1_i_phi_fu_276_p4, icmp_ln77_fu_311_p2, ap_CS_fsm_state4, ap_block_pp1_stage0_subdone, last_1_i_reg_273, tmp_user_V_fu_293_p1)
    begin
        case ap_CS_fsm is
            when ap_ST_fsm_state1 => 
                if ((not(((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then
                    ap_NS_fsm <= ap_ST_fsm_state2;
                else
                    ap_NS_fsm <= ap_ST_fsm_state1;
                end if;
            when ap_ST_fsm_state2 => 
                if (((tmp_user_V_fu_293_p1 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_state2))) then
                    ap_NS_fsm <= ap_ST_fsm_state2;
                elsif (((s_axis_video_TVALID = ap_const_logic_1) and (tmp_user_V_fu_293_p1 = ap_const_lv1_1) and (ap_const_logic_1 = ap_CS_fsm_state2))) then
                    ap_NS_fsm <= ap_ST_fsm_state3;
                else
                    ap_NS_fsm <= ap_ST_fsm_state2;
                end if;
            when ap_ST_fsm_state3 => 
                ap_NS_fsm <= ap_ST_fsm_state4;
            when ap_ST_fsm_state4 => 
                if (((ap_const_logic_1 = ap_CS_fsm_state4) and (icmp_ln77_fu_311_p2 = ap_const_lv1_1))) then
                    ap_NS_fsm <= ap_ST_fsm_state1;
                else
                    ap_NS_fsm <= ap_ST_fsm_pp1_stage0;
                end if;
            when ap_ST_fsm_pp1_stage0 => 
                if (not(((icmp_ln83_fu_322_p2 = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_subdone) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1)))) then
                    ap_NS_fsm <= ap_ST_fsm_pp1_stage0;
                elsif (((icmp_ln83_fu_322_p2 = ap_const_lv1_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_subdone) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1))) then
                    ap_NS_fsm <= ap_ST_fsm_state7;
                else
                    ap_NS_fsm <= ap_ST_fsm_pp1_stage0;
                end if;
            when ap_ST_fsm_state7 => 
                ap_NS_fsm <= ap_ST_fsm_state8;
            when ap_ST_fsm_state8 => 
                if ((not(((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0))) and (last_1_i_reg_273 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state8))) then
                    ap_NS_fsm <= ap_ST_fsm_state8;
                elsif ((not(((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0))) and (ap_const_logic_1 = ap_CS_fsm_state8) and (ap_phi_mux_last_1_i_phi_fu_276_p4 = ap_const_lv1_1))) then
                    ap_NS_fsm <= ap_ST_fsm_state9;
                else
                    ap_NS_fsm <= ap_ST_fsm_state8;
                end if;
            when ap_ST_fsm_state9 => 
                ap_NS_fsm <= ap_ST_fsm_state4;
            when others =>  
                ap_NS_fsm <= "XXXXXXXX";
        end case;
    end process;
    ap_CS_fsm_pp1_stage0 <= ap_CS_fsm(4);
    ap_CS_fsm_state1 <= ap_CS_fsm(0);
    ap_CS_fsm_state2 <= ap_CS_fsm(1);
    ap_CS_fsm_state3 <= ap_CS_fsm(2);
    ap_CS_fsm_state4 <= ap_CS_fsm(3);
    ap_CS_fsm_state7 <= ap_CS_fsm(5);
    ap_CS_fsm_state8 <= ap_CS_fsm(6);
    ap_CS_fsm_state9 <= ap_CS_fsm(7);
        ap_block_pp1_stage0 <= not((ap_const_boolean_1 = ap_const_boolean_1));

    ap_block_pp1_stage0_01001_assign_proc : process(s_axis_video_TVALID, bayer_mat_data_V_V_full_n, ap_enable_reg_pp1_iter0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, ap_predicate_op63_read_state5)
    begin
                ap_block_pp1_stage0_01001 <= (((s_axis_video_TVALID = ap_const_logic_0) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_predicate_op63_read_state5 = ap_const_boolean_1)) or ((icmp_ln83_reg_391 = ap_const_lv1_0) and (bayer_mat_data_V_V_full_n = ap_const_logic_0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1)));
    end process;


    ap_block_pp1_stage0_11001_assign_proc : process(s_axis_video_TVALID, bayer_mat_data_V_V_full_n, ap_enable_reg_pp1_iter0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, ap_predicate_op63_read_state5)
    begin
                ap_block_pp1_stage0_11001 <= (((s_axis_video_TVALID = ap_const_logic_0) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_predicate_op63_read_state5 = ap_const_boolean_1)) or ((icmp_ln83_reg_391 = ap_const_lv1_0) and (bayer_mat_data_V_V_full_n = ap_const_logic_0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1)));
    end process;


    ap_block_pp1_stage0_subdone_assign_proc : process(s_axis_video_TVALID, bayer_mat_data_V_V_full_n, ap_enable_reg_pp1_iter0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, ap_predicate_op63_read_state5)
    begin
                ap_block_pp1_stage0_subdone <= (((s_axis_video_TVALID = ap_const_logic_0) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_predicate_op63_read_state5 = ap_const_boolean_1)) or ((icmp_ln83_reg_391 = ap_const_lv1_0) and (bayer_mat_data_V_V_full_n = ap_const_logic_0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1)));
    end process;


    ap_block_state1_assign_proc : process(real_start, ap_done_reg, bayer_mat_rows_empty_n, bayer_mat_cols_empty_n, bayer_mat_rows_out_full_n, bayer_mat_cols_out_full_n)
    begin
                ap_block_state1 <= ((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1));
    end process;


    ap_block_state5_pp1_stage0_iter0_assign_proc : process(s_axis_video_TVALID, ap_predicate_op63_read_state5)
    begin
                ap_block_state5_pp1_stage0_iter0 <= ((s_axis_video_TVALID = ap_const_logic_0) and (ap_predicate_op63_read_state5 = ap_const_boolean_1));
    end process;


    ap_block_state6_pp1_stage0_iter1_assign_proc : process(bayer_mat_data_V_V_full_n, icmp_ln83_reg_391)
    begin
                ap_block_state6_pp1_stage0_iter1 <= ((icmp_ln83_reg_391 = ap_const_lv1_0) and (bayer_mat_data_V_V_full_n = ap_const_logic_0));
    end process;


    ap_block_state8_assign_proc : process(s_axis_video_TVALID, last_1_i_reg_273)
    begin
                ap_block_state8 <= ((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0));
    end process;


    ap_condition_191_assign_proc : process(ap_CS_fsm_pp1_stage0, ap_enable_reg_pp1_iter0, ap_block_pp1_stage0_11001)
    begin
                ap_condition_191 <= ((ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001));
    end process;


    ap_condition_pp1_exit_iter0_state5_assign_proc : process(icmp_ln83_fu_322_p2)
    begin
        if ((icmp_ln83_fu_322_p2 = ap_const_lv1_1)) then 
            ap_condition_pp1_exit_iter0_state5 <= ap_const_logic_1;
        else 
            ap_condition_pp1_exit_iter0_state5 <= ap_const_logic_0;
        end if; 
    end process;


    ap_done_assign_proc : process(ap_done_reg, icmp_ln77_fu_311_p2, ap_CS_fsm_state4)
    begin
        if (((ap_const_logic_1 = ap_CS_fsm_state4) and (icmp_ln77_fu_311_p2 = ap_const_lv1_1))) then 
            ap_done <= ap_const_logic_1;
        else 
            ap_done <= ap_done_reg;
        end if; 
    end process;

    ap_enable_pp1 <= (ap_idle_pp1 xor ap_const_logic_1);

    ap_idle_assign_proc : process(real_start, ap_CS_fsm_state1)
    begin
        if (((real_start = ap_const_logic_0) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            ap_idle <= ap_const_logic_1;
        else 
            ap_idle <= ap_const_logic_0;
        end if; 
    end process;


    ap_idle_pp1_assign_proc : process(ap_enable_reg_pp1_iter0, ap_enable_reg_pp1_iter1)
    begin
        if (((ap_enable_reg_pp1_iter0 = ap_const_logic_0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_0))) then 
            ap_idle_pp1 <= ap_const_logic_1;
        else 
            ap_idle_pp1 <= ap_const_logic_0;
        end if; 
    end process;


    ap_phi_mux_axi_data_V_1_i_phi_fu_192_p4_assign_proc : process(ap_CS_fsm_pp1_stage0, ap_block_pp1_stage0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, axi_data_V_1_i_reg_189, p_Val2_s_reg_236)
    begin
        if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp1_stage0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1))) then 
            ap_phi_mux_axi_data_V_1_i_phi_fu_192_p4 <= p_Val2_s_reg_236;
        else 
            ap_phi_mux_axi_data_V_1_i_phi_fu_192_p4 <= axi_data_V_1_i_reg_189;
        end if; 
    end process;


    ap_phi_mux_axi_last_V_1_i_phi_fu_181_p4_assign_proc : process(ap_CS_fsm_pp1_stage0, ap_block_pp1_stage0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, axi_last_V_1_i_reg_178, last_reg_223)
    begin
        if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp1_stage0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1))) then 
            ap_phi_mux_axi_last_V_1_i_phi_fu_181_p4 <= last_reg_223;
        else 
            ap_phi_mux_axi_last_V_1_i_phi_fu_181_p4 <= axi_last_V_1_i_reg_178;
        end if; 
    end process;


    ap_phi_mux_last_0_i_phi_fu_204_p4_assign_proc : process(ap_CS_fsm_pp1_stage0, ap_block_pp1_stage0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, last_0_i_reg_200, last_reg_223)
    begin
        if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp1_stage0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1))) then 
            ap_phi_mux_last_0_i_phi_fu_204_p4 <= last_reg_223;
        else 
            ap_phi_mux_last_0_i_phi_fu_204_p4 <= last_0_i_reg_200;
        end if; 
    end process;

    ap_phi_mux_last_1_i_phi_fu_276_p4 <= last_1_i_reg_273;
    ap_phi_reg_pp1_iter0_last_reg_223 <= "X";
    ap_phi_reg_pp1_iter0_p_Val2_s_reg_236 <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";

    ap_predicate_op63_read_state5_assign_proc : process(icmp_ln83_fu_322_p2, or_ln90_fu_336_p2)
    begin
                ap_predicate_op63_read_state5 <= ((or_ln90_fu_336_p2 = ap_const_lv1_0) and (icmp_ln83_fu_322_p2 = ap_const_lv1_0));
    end process;

    ap_ready <= internal_ap_ready;

    bayer_mat_cols_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_cols_empty_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_cols_blk_n <= bayer_mat_cols_empty_n;
        else 
            bayer_mat_cols_blk_n <= ap_const_logic_1;
        end if; 
    end process;


    bayer_mat_cols_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_cols_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_cols_out_blk_n <= bayer_mat_cols_out_full_n;
        else 
            bayer_mat_cols_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    bayer_mat_cols_out_din <= bayer_mat_cols_dout;

    bayer_mat_cols_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_rows_empty_n, bayer_mat_cols_empty_n, bayer_mat_rows_out_full_n, bayer_mat_cols_out_full_n)
    begin
        if ((not(((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_cols_out_write <= ap_const_logic_1;
        else 
            bayer_mat_cols_out_write <= ap_const_logic_0;
        end if; 
    end process;


    bayer_mat_cols_read_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_rows_empty_n, bayer_mat_cols_empty_n, bayer_mat_rows_out_full_n, bayer_mat_cols_out_full_n)
    begin
        if ((not(((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_cols_read <= ap_const_logic_1;
        else 
            bayer_mat_cols_read <= ap_const_logic_0;
        end if; 
    end process;


    bayer_mat_data_V_V_blk_n_assign_proc : process(bayer_mat_data_V_V_full_n, ap_CS_fsm_pp1_stage0, ap_block_pp1_stage0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391)
    begin
        if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp1_stage0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1))) then 
            bayer_mat_data_V_V_blk_n <= bayer_mat_data_V_V_full_n;
        else 
            bayer_mat_data_V_V_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    bayer_mat_data_V_V_din <= p_Val2_s_reg_236;

    bayer_mat_data_V_V_write_assign_proc : process(ap_CS_fsm_pp1_stage0, ap_enable_reg_pp1_iter1, icmp_ln83_reg_391, ap_block_pp1_stage0_11001)
    begin
        if (((icmp_ln83_reg_391 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_enable_reg_pp1_iter1 = ap_const_logic_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001))) then 
            bayer_mat_data_V_V_write <= ap_const_logic_1;
        else 
            bayer_mat_data_V_V_write <= ap_const_logic_0;
        end if; 
    end process;


    bayer_mat_rows_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_rows_empty_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_rows_blk_n <= bayer_mat_rows_empty_n;
        else 
            bayer_mat_rows_blk_n <= ap_const_logic_1;
        end if; 
    end process;


    bayer_mat_rows_out_blk_n_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_rows_out_full_n)
    begin
        if ((not(((real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_rows_out_blk_n <= bayer_mat_rows_out_full_n;
        else 
            bayer_mat_rows_out_blk_n <= ap_const_logic_1;
        end if; 
    end process;

    bayer_mat_rows_out_din <= bayer_mat_rows_dout;

    bayer_mat_rows_out_write_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_rows_empty_n, bayer_mat_cols_empty_n, bayer_mat_rows_out_full_n, bayer_mat_cols_out_full_n)
    begin
        if ((not(((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_rows_out_write <= ap_const_logic_1;
        else 
            bayer_mat_rows_out_write <= ap_const_logic_0;
        end if; 
    end process;


    bayer_mat_rows_read_assign_proc : process(real_start, ap_done_reg, ap_CS_fsm_state1, bayer_mat_rows_empty_n, bayer_mat_cols_empty_n, bayer_mat_rows_out_full_n, bayer_mat_cols_out_full_n)
    begin
        if ((not(((bayer_mat_cols_out_full_n = ap_const_logic_0) or (bayer_mat_rows_out_full_n = ap_const_logic_0) or (bayer_mat_cols_empty_n = ap_const_logic_0) or (bayer_mat_rows_empty_n = ap_const_logic_0) or (real_start = ap_const_logic_0) or (ap_done_reg = ap_const_logic_1))) and (ap_const_logic_1 = ap_CS_fsm_state1))) then 
            bayer_mat_rows_read <= ap_const_logic_1;
        else 
            bayer_mat_rows_read <= ap_const_logic_0;
        end if; 
    end process;

    i_fu_316_p2 <= std_logic_vector(unsigned(i_0_i_reg_167) + unsigned(ap_const_lv16_1));
    icmp_ln77_fu_311_p2 <= "1" when (i_0_i_reg_167 = bayer_mat_rows_read_reg_347) else "0";
    icmp_ln83_fu_322_p2 <= "1" when (j_0_i_reg_212 = tmp_reg_377) else "0";

    internal_ap_ready_assign_proc : process(icmp_ln77_fu_311_p2, ap_CS_fsm_state4)
    begin
        if (((ap_const_logic_1 = ap_CS_fsm_state4) and (icmp_ln77_fu_311_p2 = ap_const_lv1_1))) then 
            internal_ap_ready <= ap_const_logic_1;
        else 
            internal_ap_ready <= ap_const_logic_0;
        end if; 
    end process;

    j_fu_327_p2 <= std_logic_vector(unsigned(j_0_i_reg_212) + unsigned(ap_const_lv14_1));
    or_ln90_fu_336_p2 <= (start_1_i_fu_90 or ap_phi_mux_last_0_i_phi_fu_204_p4);

    real_start_assign_proc : process(ap_start, start_full_n, start_once_reg)
    begin
        if (((start_once_reg = ap_const_logic_0) and (start_full_n = ap_const_logic_0))) then 
            real_start <= ap_const_logic_0;
        else 
            real_start <= ap_start;
        end if; 
    end process;


    s_axis_video_TDATA_blk_n_assign_proc : process(s_axis_video_TVALID, ap_CS_fsm_state2, ap_CS_fsm_pp1_stage0, ap_enable_reg_pp1_iter0, ap_block_pp1_stage0, icmp_ln83_fu_322_p2, or_ln90_fu_336_p2, ap_CS_fsm_state8, last_1_i_reg_273)
    begin
        if (((ap_const_logic_1 = ap_CS_fsm_state2) or ((or_ln90_fu_336_p2 = ap_const_lv1_0) and (icmp_ln83_fu_322_p2 = ap_const_lv1_0) and (ap_const_boolean_0 = ap_block_pp1_stage0) and (ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0)) or ((last_1_i_reg_273 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state8)))) then 
            s_axis_video_TDATA_blk_n <= s_axis_video_TVALID;
        else 
            s_axis_video_TDATA_blk_n <= ap_const_logic_1;
        end if; 
    end process;


    s_axis_video_TREADY_assign_proc : process(s_axis_video_TVALID, ap_CS_fsm_state2, ap_CS_fsm_pp1_stage0, ap_enable_reg_pp1_iter0, ap_CS_fsm_state8, ap_predicate_op63_read_state5, ap_block_pp1_stage0_11001, last_1_i_reg_273)
    begin
        if ((((ap_enable_reg_pp1_iter0 = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_pp1_stage0) and (ap_predicate_op63_read_state5 = ap_const_boolean_1) and (ap_const_boolean_0 = ap_block_pp1_stage0_11001)) or ((s_axis_video_TVALID = ap_const_logic_1) and (ap_const_logic_1 = ap_CS_fsm_state2)) or (not(((last_1_i_reg_273 = ap_const_lv1_0) and (s_axis_video_TVALID = ap_const_logic_0))) and (last_1_i_reg_273 = ap_const_lv1_0) and (ap_const_logic_1 = ap_CS_fsm_state8)))) then 
            s_axis_video_TREADY <= ap_const_logic_1;
        else 
            s_axis_video_TREADY <= ap_const_logic_0;
        end if; 
    end process;

    start_out <= real_start;

    start_write_assign_proc : process(real_start, start_once_reg)
    begin
        if (((start_once_reg = ap_const_logic_0) and (real_start = ap_const_logic_1))) then 
            start_write <= ap_const_logic_1;
        else 
            start_write <= ap_const_logic_0;
        end if; 
    end process;

    tmp_user_V_fu_293_p1 <= s_axis_video_TUSER;
end behav;
